import * as vue from "vue";

export var state = vue.reactive({
    connected: false, //indicates sensor connection
    game_id: 0,
    punch_id: 0,
    stable: false, //is it stable (the ball?, if not , the ball is swinging)

    punch_threshold: 13, //considered punch (G > 13)
    punched: 0, //is it punched? 0 / 1
    punched_num: 0, //punched number of times
    punched_time: 0, //Timestamp, records last punch
    punch_time_allowed: 1000, //Allow 1S for score to grow
    punch_score: 0 //current score, higher = better, may change during the course of swing
});

var _port = null;

function _on_fail() {
    state.connected = false;
    // _port = null;

}

async function connect(port = _port) {
    console.log("real connect..")
    var server = await port.gatt.connect();
    console.log("real connect done..")
    // console.log(server);
    var service = await server.getPrimaryService('6e400001-b5a3-f393-e0a9-e50e24dcca9e'.toLowerCase());
    var c_accel = await service.getCharacteristic('6e400001-b5a3-f393-e0a9-e50e24dcca9e'.toLowerCase());
    await c_accel.startNotifications();
    c_accel.addEventListener('characteristicvaluechanged', (e) => {
        var x = e.target.value.getInt16(3, true) / 1000;
        var y = e.target.value.getInt16(5, true) / 1000;
        var z = e.target.value.getInt16(7, true) / 1000;
        update_acc([x, y, z]);
    });
    state.connected = true;
}

var q = null;
function auto_reconnect() {
    clearTimeout(q);
    q = setTimeout(async () => {
        if (!state.connected && _port) {
            try {
                await connect();
            } catch (e) {
                console.log(e);
            }
        }
        // console.log("auto reconnecting");
        auto_reconnect();
    }, 500);
}
async function delay(ms) {
    return new Promise((res) => {
        clearTimeout(q);
        q = setTimeout(() => {
            res();
        }, ms)
    });
}

var moving_avg = [0, 0, 0];
var prev_a = [0, 0, 0];
var new_a = [0, 0, 0];
var moving_total = 0;
function update_acc(a) {
    prev_a = [...new_a];
    new_a = a;
    var delta_a = [0, 0, 0];
    var total = 0;
    for (var i = 0; i < 3; i++) {
        moving_avg[i] += (new_a[i] - moving_avg[i]) * 0.3;
        delta_a[i] = new_a[i] - moving_avg[i];
        total += Math.abs(delta_a[i]);
    }

    state.stable = moving_total < 2; //considered stable
    if (state.game_id > 0) { //OK to play
        if (total > state.punch_threshold && !state.punched) {
            state.punched = true;
            state.punch_score = total;
            state.stable = false;
            state.punched_time = Date.now();
            state.punch_id = state.game_id;
            state.punched_num += 1;
        }
        else if (total > state.punch_score && Date.now() - state.punched_time < state.punch_time_allowed) {
            state.punch_score = total;
            // state.punched_num += 1;
        }
    }

    if (state.stable && state.game_id != state.punch_id) {
        state.punched = false;
    }
    moving_total += (total - moving_total) * 0.3;
}

export async function try_connect(dev = null, force = false) {
    if (state.connected && !force) {
        return;
    }
    try {
        var port = dev || (await navigator.bluetooth.requestDevice({
            // acceptAllDevices: true,
            optionalServices: ['6e400001-b5a3-f393-e0a9-e50e24dcca9e'.toLowerCase()],
            filters: [{
                namePrefix: "Holy-IOT"
                // services: ['6e400001-b5a3-f393-e0a9-e50e24dcca9e']
            }]
        }));
        await connect(port);
        _port = port;
        _port.ondisconnect = _on_fail;
        port.addEventListener('gattserverdisconnected', _on_fail);
    }
    catch (E) {
        console.log(E);
        // state.connected = state.connected
    }
}

export async function init() {

    try {
        var dev = await navigator.bluetooth.getDevices();
        console.log(dev);
        for (var i = 0; i < dev.length; i++) {
            try {
                if (!state.connected) {
                    console.log("try to connect devid", i);
                    await try_connect(dev[i], false)
                    console.log("maybe done?");
                    if (state.connected) break;
                }
            }
            catch (e) {
                console.log(e);
            }
        }
    } catch (e) {
        console.log(e);
        console.warn("You must be using Chrome with the chrome://flags/#enable-web-bluetooth-new-permissions-backend flag enabled. to use this feature(auto reconnect upon refresh)")
    }
    console.log("system start")
    document.addEventListener("mousedown", () => {
        try_connect(null, false);
    });
    auto_reconnect();

}
