// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles

(function (modules, entry, mainEntry, parcelRequireName, globalName) {
  /* eslint-disable no-undef */
  var globalObject =
    typeof globalThis !== 'undefined'
      ? globalThis
      : typeof self !== 'undefined'
      ? self
      : typeof window !== 'undefined'
      ? window
      : typeof global !== 'undefined'
      ? global
      : {};
  /* eslint-enable no-undef */

  // Save the require from previous bundle to this closure if any
  var previousRequire =
    typeof globalObject[parcelRequireName] === 'function' &&
    globalObject[parcelRequireName];

  var cache = previousRequire.cache || {};
  // Do not use `require` to prevent Webpack from trying to bundle this call
  var nodeRequire =
    typeof module !== 'undefined' &&
    typeof module.require === 'function' &&
    module.require.bind(module);

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire =
          typeof globalObject[parcelRequireName] === 'function' &&
          globalObject[parcelRequireName];
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error("Cannot find module '" + name + "'");
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = (cache[name] = new newRequire.Module(name));

      modules[name][0].call(
        module.exports,
        localRequire,
        module,
        module.exports,
        this
      );
    }

    return cache[name].exports;

    function localRequire(x) {
      var res = localRequire.resolve(x);
      return res === false ? {} : newRequire(res);
    }

    function resolve(x) {
      var id = modules[name][1][x];
      return id != null ? id : x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [
      function (require, module) {
        module.exports = exports;
      },
      {},
    ];
  };

  Object.defineProperty(newRequire, 'root', {
    get: function () {
      return globalObject[parcelRequireName];
    },
  });

  globalObject[parcelRequireName] = newRequire;

  for (var i = 0; i < entry.length; i++) {
    newRequire(entry[i]);
  }

  if (mainEntry) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(mainEntry);

    // CommonJS
    if (typeof exports === 'object' && typeof module !== 'undefined') {
      module.exports = mainExports;

      // RequireJS
    } else if (typeof define === 'function' && define.amd) {
      define(function () {
        return mainExports;
      });

      // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }
})({"adjPd":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
var _sensorGatt = require("./sensor-gatt");
var _vue = require("vue");
var _gameJs = require("./game.js");
var _vue3Lottie = require("vue3-lottie");
var _vue3LottieDefault = parcelHelpers.interopDefault(_vue3Lottie);
var _mainVue = require("./main.vue");
var _mainVueDefault = parcelHelpers.interopDefault(_mainVue);
async function start() {
    var q = setTimeout(()=>{
        location.reload(); //this ensures BLE wont put sys into stuck
    }, 5000);
    await _sensorGatt.init();
    clearTimeout(q);
    await _gameJs.start();
    _vue.createApp((0, _mainVueDefault.default)).use((0, _vue3LottieDefault.default)).mount("#app");
// const app_ref = vue.createApp(app);
// app_ref.config.globalProperties.$debug = true;
// app_ref.provide( 'debug', true );
// app_ref.mount('#app');
// vue.createApp({
//     methods: {
//         fire: () => {
//             button_state.triggered = 1;
//         }
//     },
//     data() {
//         return state
//     },
//     mounted: () => {
//         console.log("mounted")
//     }
// }).mount('#app')
}
start();

},{"./sensor-gatt":"byeTi","vue":"gzxs9","./game.js":"5JiMD","vue3-lottie":"82TDq","./main.vue":"3VFwt","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"byeTi":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "state", ()=>state);
parcelHelpers.export(exports, "try_connect", ()=>try_connect);
parcelHelpers.export(exports, "init", ()=>init);
var _vue = require("vue");
var state = _vue.reactive({
    connected: false,
    game_id: 0,
    punch_id: 0,
    stable: false,
    punch_threshold: 13,
    punched: 0,
    punched_num: 0,
    punched_time: 0,
    punch_time_allowed: 1000,
    punch_score: 0 //current score, higher = better, may change during the course of swing
});
var _port = null;
function _on_fail() {
    state.connected = false;
// _port = null;
}
async function connect(port = _port) {
    console.log("real connect..");
    var server = await port.gatt.connect();
    console.log("real connect done..");
    // console.log(server);
    var service = await server.getPrimaryService("39bd9032-a2ed-4561-abf6-710123c3eadd".toLowerCase());
    var c_accel = await service.getCharacteristic("d8bc20e9-84cc-421c-b5e0-a50ada48fb15".toLowerCase());
    await c_accel.startNotifications();
    c_accel.addEventListener("characteristicvaluechanged", (e)=>{
        var x = e.target.value.getInt16(3, true) / 1000;
        var y = e.target.value.getInt16(5, true) / 1000;
        var z = e.target.value.getInt16(7, true) / 1000;
        update_acc([
            x,
            y,
            z
        ]);
    });
    state.connected = true;
}
var q = null;
function auto_reconnect() {
    clearTimeout(q);
    q = setTimeout(async ()=>{
        if (!state.connected && _port) try {
            await connect();
        } catch (e) {
            console.log(e);
        }
        // console.log("auto reconnecting");
        auto_reconnect();
    }, 500);
}
async function delay(ms) {
    return new Promise((res)=>{
        clearTimeout(q);
        q = setTimeout(()=>{
            res();
        }, ms);
    });
}
var moving_avg = [
    0,
    0,
    0
];
var prev_a = [
    0,
    0,
    0
];
var new_a = [
    0,
    0,
    0
];
var moving_total = 0;
function update_acc(a) {
    prev_a = [
        ...new_a
    ];
    new_a = a;
    var delta_a = [
        0,
        0,
        0
    ];
    var total = 0;
    for(var i = 0; i < 3; i++){
        moving_avg[i] += (new_a[i] - moving_avg[i]) * 0.3;
        delta_a[i] = new_a[i] - moving_avg[i];
        total += Math.abs(delta_a[i]);
    }
    state.stable = moving_total < 2; //considered stable
    if (state.game_id > 0) {
        if (total > state.punch_threshold && !state.punched) {
            state.punched = true;
            state.punch_score = total;
            state.stable = false;
            state.punched_time = Date.now();
            state.punch_id = state.game_id;
            state.punched_num += 1;
        } else if (total > state.punch_score && Date.now() - state.punched_time < state.punch_time_allowed) state.punch_score = total;
    }
    if (state.stable && state.game_id != state.punch_id) state.punched = false;
    moving_total += (total - moving_total) * 0.3;
}
async function try_connect(dev = null, force = false) {
    if (state.connected && !force) return;
    try {
        var port = dev || await navigator.bluetooth.requestDevice({
            // acceptAllDevices: true,
            optionalServices: [
                "39bd9032-a2ed-4561-abf6-710123c3eadd".toLowerCase()
            ],
            filters: [
                {
                    namePrefix: "Harmless Smash"
                }
            ]
        });
        await connect(port);
        _port = port;
        _port.ondisconnect = _on_fail;
        port.addEventListener("gattserverdisconnected", _on_fail);
    } catch (E) {
        console.log(E);
    // state.connected = state.connected
    }
}
async function init() {
    try {
        var dev = await navigator.bluetooth.getDevices();
        console.log(dev);
        for(var i = 0; i < dev.length; i++)try {
            if (!state.connected) {
                console.log("try to connect devid", i);
                await try_connect(dev[i], false);
                console.log("maybe done?");
                if (state.connected) break;
            }
        } catch (e) {
            console.log(e);
        }
    } catch (e) {
        console.log(e);
        console.warn("You must be using Chrome with the chrome://flags/#enable-web-bluetooth-new-permissions-backend flag enabled. to use this feature(auto reconnect upon refresh)");
    }
    console.log("system start");
    document.addEventListener("mousedown", ()=>{
        try_connect(null, false);
    });
    auto_reconnect();
}

},{"vue":"gzxs9","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"gzxs9":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "compile", ()=>compile);
var _runtimeDom = require("@vue/runtime-dom");
parcelHelpers.exportAll(_runtimeDom, exports);
function initDev() {
    (0, _runtimeDom.initCustomFormatter)();
}
initDev();
const compile = ()=>{
    (0, _runtimeDom.warn)(`Runtime compilation is not supported in this build of Vue.` + ` Configure your bundler to alias "vue" to "vue/dist/vue.esm-bundler.js".`);
};

},{"@vue/runtime-dom":"9wNvI","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"9wNvI":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "Transition", ()=>Transition);
parcelHelpers.export(exports, "TransitionGroup", ()=>TransitionGroup);
parcelHelpers.export(exports, "VueElement", ()=>VueElement);
parcelHelpers.export(exports, "createApp", ()=>createApp);
parcelHelpers.export(exports, "createSSRApp", ()=>createSSRApp);
parcelHelpers.export(exports, "defineCustomElement", ()=>defineCustomElement);
parcelHelpers.export(exports, "defineSSRCustomElement", ()=>defineSSRCustomElement);
parcelHelpers.export(exports, "hydrate", ()=>hydrate);
parcelHelpers.export(exports, "initDirectivesForSSR", ()=>initDirectivesForSSR);
parcelHelpers.export(exports, "render", ()=>render);
parcelHelpers.export(exports, "useCssModule", ()=>useCssModule);
parcelHelpers.export(exports, "useCssVars", ()=>useCssVars);
parcelHelpers.export(exports, "vModelCheckbox", ()=>vModelCheckbox);
parcelHelpers.export(exports, "vModelDynamic", ()=>vModelDynamic);
parcelHelpers.export(exports, "vModelRadio", ()=>vModelRadio);
parcelHelpers.export(exports, "vModelSelect", ()=>vModelSelect);
parcelHelpers.export(exports, "vModelText", ()=>vModelText);
parcelHelpers.export(exports, "vShow", ()=>vShow);
parcelHelpers.export(exports, "withKeys", ()=>withKeys);
parcelHelpers.export(exports, "withModifiers", ()=>withModifiers);
var _runtimeCore = require("@vue/runtime-core");
parcelHelpers.exportAll(_runtimeCore, exports);
var _shared = require("@vue/shared");
const svgNS = "http://www.w3.org/2000/svg";
const doc = typeof document !== "undefined" ? document : null;
const templateContainer = doc && /*#__PURE__*/ doc.createElement("template");
const nodeOps = {
    insert: (child, parent, anchor)=>{
        parent.insertBefore(child, anchor || null);
    },
    remove: (child)=>{
        const parent = child.parentNode;
        if (parent) parent.removeChild(child);
    },
    createElement: (tag, isSVG, is, props)=>{
        const el = isSVG ? doc.createElementNS(svgNS, tag) : doc.createElement(tag, is ? {
            is
        } : undefined);
        if (tag === "select" && props && props.multiple != null) el.setAttribute("multiple", props.multiple);
        return el;
    },
    createText: (text)=>doc.createTextNode(text),
    createComment: (text)=>doc.createComment(text),
    setText: (node, text)=>{
        node.nodeValue = text;
    },
    setElementText: (el, text)=>{
        el.textContent = text;
    },
    parentNode: (node)=>node.parentNode,
    nextSibling: (node)=>node.nextSibling,
    querySelector: (selector)=>doc.querySelector(selector),
    setScopeId (el, id) {
        el.setAttribute(id, "");
    },
    // __UNSAFE__
    // Reason: innerHTML.
    // Static content here can only come from compiled templates.
    // As long as the user only uses trusted templates, this is safe.
    insertStaticContent (content, parent, anchor, isSVG, start, end) {
        // <parent> before | first ... last | anchor </parent>
        const before = anchor ? anchor.previousSibling : parent.lastChild;
        // #5308 can only take cached path if:
        // - has a single root node
        // - nextSibling info is still available
        if (start && (start === end || start.nextSibling)) // cached
        while(true){
            parent.insertBefore(start.cloneNode(true), anchor);
            if (start === end || !(start = start.nextSibling)) break;
        }
        else {
            // fresh insert
            templateContainer.innerHTML = isSVG ? `<svg>${content}</svg>` : content;
            const template = templateContainer.content;
            if (isSVG) {
                // remove outer svg wrapper
                const wrapper = template.firstChild;
                while(wrapper.firstChild)template.appendChild(wrapper.firstChild);
                template.removeChild(wrapper);
            }
            parent.insertBefore(template, anchor);
        }
        return [
            // first
            before ? before.nextSibling : parent.firstChild,
            // last
            anchor ? anchor.previousSibling : parent.lastChild
        ];
    }
};
// compiler should normalize class + :class bindings on the same element
// into a single binding ['staticClass', dynamic]
function patchClass(el, value, isSVG) {
    // directly setting className should be faster than setAttribute in theory
    // if this is an element during a transition, take the temporary transition
    // classes into account.
    const transitionClasses = el._vtc;
    if (transitionClasses) value = (value ? [
        value,
        ...transitionClasses
    ] : [
        ...transitionClasses
    ]).join(" ");
    if (value == null) el.removeAttribute("class");
    else if (isSVG) el.setAttribute("class", value);
    else el.className = value;
}
function patchStyle(el, prev, next) {
    const style = el.style;
    const isCssString = (0, _shared.isString)(next);
    if (next && !isCssString) {
        if (prev && !(0, _shared.isString)(prev)) {
            for(const key in prev)if (next[key] == null) setStyle(style, key, "");
        }
        for(const key in next)setStyle(style, key, next[key]);
    } else {
        const currentDisplay = style.display;
        if (isCssString) {
            if (prev !== next) style.cssText = next;
        } else if (prev) el.removeAttribute("style");
        // indicates that the `display` of the element is controlled by `v-show`,
        // so we always keep the current `display` value regardless of the `style`
        // value, thus handing over control to `v-show`.
        if ("_vod" in el) style.display = currentDisplay;
    }
}
const semicolonRE = /[^\\];\s*$/;
const importantRE = /\s*!important$/;
function setStyle(style, name, val) {
    if ((0, _shared.isArray)(val)) val.forEach((v)=>setStyle(style, name, v));
    else {
        if (val == null) val = "";
        if (semicolonRE.test(val)) (0, _runtimeCore.warn)(`Unexpected semicolon at the end of '${name}' style value: '${val}'`);
        if (name.startsWith("--")) // custom property definition
        style.setProperty(name, val);
        else {
            const prefixed = autoPrefix(style, name);
            if (importantRE.test(val)) // !important
            style.setProperty((0, _shared.hyphenate)(prefixed), val.replace(importantRE, ""), "important");
            else style[prefixed] = val;
        }
    }
}
const prefixes = [
    "Webkit",
    "Moz",
    "ms"
];
const prefixCache = {};
function autoPrefix(style, rawName) {
    const cached = prefixCache[rawName];
    if (cached) return cached;
    let name = (0, _runtimeCore.camelize)(rawName);
    if (name !== "filter" && name in style) return prefixCache[rawName] = name;
    name = (0, _shared.capitalize)(name);
    for(let i = 0; i < prefixes.length; i++){
        const prefixed = prefixes[i] + name;
        if (prefixed in style) return prefixCache[rawName] = prefixed;
    }
    return rawName;
}
const xlinkNS = "http://www.w3.org/1999/xlink";
function patchAttr(el, key, value, isSVG, instance) {
    if (isSVG && key.startsWith("xlink:")) {
        if (value == null) el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
        else el.setAttributeNS(xlinkNS, key, value);
    } else {
        // note we are only checking boolean attributes that don't have a
        // corresponding dom prop of the same name here.
        const isBoolean = (0, _shared.isSpecialBooleanAttr)(key);
        if (value == null || isBoolean && !(0, _shared.includeBooleanAttr)(value)) el.removeAttribute(key);
        else el.setAttribute(key, isBoolean ? "" : value);
    }
}
// __UNSAFE__
// functions. The user is responsible for using them with only trusted content.
function patchDOMProp(el, key, value, // the following args are passed only due to potential innerHTML/textContent
// overriding existing VNodes, in which case the old tree must be properly
// unmounted.
prevChildren, parentComponent, parentSuspense, unmountChildren) {
    if (key === "innerHTML" || key === "textContent") {
        if (prevChildren) unmountChildren(prevChildren, parentComponent, parentSuspense);
        el[key] = value == null ? "" : value;
        return;
    }
    if (key === "value" && el.tagName !== "PROGRESS" && // custom elements may use _value internally
    !el.tagName.includes("-")) {
        // store value as _value as well since
        // non-string values will be stringified.
        el._value = value;
        const newValue = value == null ? "" : value;
        if (el.value !== newValue || // #4956: always set for OPTION elements because its value falls back to
        // textContent if no value attribute is present. And setting .value for
        // OPTION has no side effect
        el.tagName === "OPTION") el.value = newValue;
        if (value == null) el.removeAttribute(key);
        return;
    }
    let needRemove = false;
    if (value === "" || value == null) {
        const type = typeof el[key];
        if (type === "boolean") // e.g. <select multiple> compiles to { multiple: '' }
        value = (0, _shared.includeBooleanAttr)(value);
        else if (value == null && type === "string") {
            // e.g. <div :id="null">
            value = "";
            needRemove = true;
        } else if (type === "number") {
            // e.g. <img :width="null">
            value = 0;
            needRemove = true;
        }
    }
    // some properties perform value validation and throw,
    // some properties has getter, no setter, will error in 'use strict'
    // eg. <select :type="null"></select> <select :willValidate="null"></select>
    try {
        el[key] = value;
    } catch (e) {
        // do not warn if value is auto-coerced from nullish values
        if (!needRemove) (0, _runtimeCore.warn)(`Failed setting prop "${key}" on <${el.tagName.toLowerCase()}>: ` + `value ${value} is invalid.`, e);
    }
    needRemove && el.removeAttribute(key);
}
function addEventListener(el, event, handler, options) {
    el.addEventListener(event, handler, options);
}
function removeEventListener(el, event, handler, options) {
    el.removeEventListener(event, handler, options);
}
function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
    // vei = vue event invokers
    const invokers = el._vei || (el._vei = {});
    const existingInvoker = invokers[rawName];
    if (nextValue && existingInvoker) // patch
    existingInvoker.value = nextValue;
    else {
        const [name, options] = parseName(rawName);
        if (nextValue) {
            // add
            const invoker = invokers[rawName] = createInvoker(nextValue, instance);
            addEventListener(el, name, invoker, options);
        } else if (existingInvoker) {
            // remove
            removeEventListener(el, name, existingInvoker, options);
            invokers[rawName] = undefined;
        }
    }
}
const optionsModifierRE = /(?:Once|Passive|Capture)$/;
function parseName(name) {
    let options;
    if (optionsModifierRE.test(name)) {
        options = {};
        let m;
        while(m = name.match(optionsModifierRE)){
            name = name.slice(0, name.length - m[0].length);
            options[m[0].toLowerCase()] = true;
        }
    }
    const event = name[2] === ":" ? name.slice(3) : (0, _shared.hyphenate)(name.slice(2));
    return [
        event,
        options
    ];
}
// To avoid the overhead of repeatedly calling Date.now(), we cache
// and use the same timestamp for all event listeners attached in the same tick.
let cachedNow = 0;
const p = /*#__PURE__*/ Promise.resolve();
const getNow = ()=>cachedNow || (p.then(()=>cachedNow = 0), cachedNow = Date.now());
function createInvoker(initialValue, instance) {
    const invoker = (e)=>{
        // async edge case vuejs/vue#6566
        // inner click event triggers patch, event handler
        // attached to outer element during patch, and triggered again. This
        // happens because browsers fire microtask ticks between event propagation.
        // this no longer happens for templates in Vue 3, but could still be
        // theoretically possible for hand-written render functions.
        // the solution: we save the timestamp when a handler is attached,
        // and also attach the timestamp to any event that was handled by vue
        // for the first time (to avoid inconsistent event timestamp implementations
        // or events fired from iframes, e.g. #2513)
        // The handler would only fire if the event passed to it was fired
        // AFTER it was attached.
        if (!e._vts) e._vts = Date.now();
        else if (e._vts <= invoker.attached) return;
        (0, _runtimeCore.callWithAsyncErrorHandling)(patchStopImmediatePropagation(e, invoker.value), instance, 5 /* ErrorCodes.NATIVE_EVENT_HANDLER */ , [
            e
        ]);
    };
    invoker.value = initialValue;
    invoker.attached = getNow();
    return invoker;
}
function patchStopImmediatePropagation(e, value) {
    if ((0, _shared.isArray)(value)) {
        const originalStop = e.stopImmediatePropagation;
        e.stopImmediatePropagation = ()=>{
            originalStop.call(e);
            e._stopped = true;
        };
        return value.map((fn)=>(e)=>!e._stopped && fn && fn(e));
    } else return value;
}
const nativeOnRE = /^on[a-z]/;
const patchProp = (el, key, prevValue, nextValue, isSVG = false, prevChildren, parentComponent, parentSuspense, unmountChildren)=>{
    if (key === "class") patchClass(el, nextValue, isSVG);
    else if (key === "style") patchStyle(el, prevValue, nextValue);
    else if ((0, _shared.isOn)(key)) // ignore v-model listeners
    {
        if (!(0, _shared.isModelListener)(key)) patchEvent(el, key, prevValue, nextValue, parentComponent);
    } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) patchDOMProp(el, key, nextValue, prevChildren, parentComponent, parentSuspense, unmountChildren);
    else {
        // special case for <input v-model type="checkbox"> with
        // :true-value & :false-value
        // store value as dom properties since non-string values will be
        // stringified.
        if (key === "true-value") el._trueValue = nextValue;
        else if (key === "false-value") el._falseValue = nextValue;
        patchAttr(el, key, nextValue, isSVG);
    }
};
function shouldSetAsProp(el, key, value, isSVG) {
    if (isSVG) {
        // most keys must be set as attribute on svg elements to work
        // ...except innerHTML & textContent
        if (key === "innerHTML" || key === "textContent") return true;
        // or native onclick with function values
        if (key in el && nativeOnRE.test(key) && (0, _shared.isFunction)(value)) return true;
        return false;
    }
    // these are enumerated attrs, however their corresponding DOM properties
    // are actually booleans - this leads to setting it with a string "false"
    // value leading it to be coerced to `true`, so we need to always treat
    // them as attributes.
    // Note that `contentEditable` doesn't have this problem: its DOM
    // property is also enumerated string values.
    if (key === "spellcheck" || key === "draggable" || key === "translate") return false;
    // #1787, #2840 form property on form elements is readonly and must be set as
    // attribute.
    if (key === "form") return false;
    // #1526 <input list> must be set as attribute
    if (key === "list" && el.tagName === "INPUT") return false;
    // #2766 <textarea type> must be set as attribute
    if (key === "type" && el.tagName === "TEXTAREA") return false;
    // native onclick with string value, must be set as attribute
    if (nativeOnRE.test(key) && (0, _shared.isString)(value)) return false;
    return key in el;
}
function defineCustomElement(options, hydrate) {
    const Comp = (0, _runtimeCore.defineComponent)(options);
    class VueCustomElement extends VueElement {
        constructor(initialProps){
            super(Comp, initialProps, hydrate);
        }
    }
    VueCustomElement.def = Comp;
    return VueCustomElement;
}
const defineSSRCustomElement = (options)=>{
    // @ts-ignore
    return defineCustomElement(options, hydrate);
};
const BaseClass = typeof HTMLElement !== "undefined" ? HTMLElement : class {
};
class VueElement extends BaseClass {
    constructor(_def, _props = {}, hydrate){
        super();
        this._def = _def;
        this._props = _props;
        /**
         * @internal
         */ this._instance = null;
        this._connected = false;
        this._resolved = false;
        this._numberProps = null;
        if (this.shadowRoot && hydrate) hydrate(this._createVNode(), this.shadowRoot);
        else {
            if (0, this.shadowRoot) (0, _runtimeCore.warn)(`Custom element has pre-rendered declarative shadow root but is not ` + `defined as hydratable. Use \`defineSSRCustomElement\`.`);
            this.attachShadow({
                mode: "open"
            });
            if (!this._def.__asyncLoader) // for sync component defs we can immediately resolve props
            this._resolveProps(this._def);
        }
    }
    connectedCallback() {
        this._connected = true;
        if (!this._instance) {
            if (this._resolved) this._update();
            else this._resolveDef();
        }
    }
    disconnectedCallback() {
        this._connected = false;
        (0, _runtimeCore.nextTick)(()=>{
            if (!this._connected) {
                render(null, this.shadowRoot);
                this._instance = null;
            }
        });
    }
    /**
     * resolve inner component definition (handle possible async component)
     */ _resolveDef() {
        this._resolved = true;
        // set initial attrs
        for(let i = 0; i < this.attributes.length; i++)this._setAttr(this.attributes[i].name);
        // watch future attr changes
        new MutationObserver((mutations)=>{
            for (const m of mutations)this._setAttr(m.attributeName);
        }).observe(this, {
            attributes: true
        });
        const resolve = (def, isAsync = false)=>{
            const { props , styles  } = def;
            // cast Number-type props set before resolve
            let numberProps;
            if (props && !(0, _shared.isArray)(props)) for(const key in props){
                const opt = props[key];
                if (opt === Number || opt && opt.type === Number) {
                    if (key in this._props) this._props[key] = (0, _shared.toNumber)(this._props[key]);
                    (numberProps || (numberProps = Object.create(null)))[(0, _shared.camelize)(key)] = true;
                }
            }
            this._numberProps = numberProps;
            if (isAsync) // defining getter/setters on prototype
            // for sync defs, this already happened in the constructor
            this._resolveProps(def);
            // apply CSS
            this._applyStyles(styles);
            // initial render
            this._update();
        };
        const asyncDef = this._def.__asyncLoader;
        if (asyncDef) asyncDef().then((def)=>resolve(def, true));
        else resolve(this._def);
    }
    _resolveProps(def) {
        const { props  } = def;
        const declaredPropKeys = (0, _shared.isArray)(props) ? props : Object.keys(props || {});
        // check if there are props set pre-upgrade or connect
        for (const key of Object.keys(this))if (key[0] !== "_" && declaredPropKeys.includes(key)) this._setProp(key, this[key], true, false);
        // defining getter/setters on prototype
        for (const key of declaredPropKeys.map((0, _shared.camelize)))Object.defineProperty(this, key, {
            get () {
                return this._getProp(key);
            },
            set (val) {
                this._setProp(key, val);
            }
        });
    }
    _setAttr(key) {
        let value = this.getAttribute(key);
        const camelKey = (0, _shared.camelize)(key);
        if (this._numberProps && this._numberProps[camelKey]) value = (0, _shared.toNumber)(value);
        this._setProp(camelKey, value, false);
    }
    /**
     * @internal
     */ _getProp(key) {
        return this._props[key];
    }
    /**
     * @internal
     */ _setProp(key, val, shouldReflect = true, shouldUpdate = true) {
        if (val !== this._props[key]) {
            this._props[key] = val;
            if (shouldUpdate && this._instance) this._update();
            // reflect
            if (shouldReflect) {
                if (val === true) this.setAttribute((0, _shared.hyphenate)(key), "");
                else if (typeof val === "string" || typeof val === "number") this.setAttribute((0, _shared.hyphenate)(key), val + "");
                else if (!val) this.removeAttribute((0, _shared.hyphenate)(key));
            }
        }
    }
    _update() {
        render(this._createVNode(), this.shadowRoot);
    }
    _createVNode() {
        const vnode = (0, _runtimeCore.createVNode)(this._def, (0, _shared.extend)({}, this._props));
        if (!this._instance) vnode.ce = (instance)=>{
            this._instance = instance;
            instance.isCE = true;
            instance.ceReload = (newStyles)=>{
                // always reset styles
                if (this._styles) {
                    this._styles.forEach((s)=>this.shadowRoot.removeChild(s));
                    this._styles.length = 0;
                }
                this._applyStyles(newStyles);
                this._instance = null;
                this._update();
            };
            const dispatch = (event, args)=>{
                this.dispatchEvent(new CustomEvent(event, {
                    detail: args
                }));
            };
            // intercept emit
            instance.emit = (event, ...args)=>{
                // dispatch both the raw and hyphenated versions of an event
                // to match Vue behavior
                dispatch(event, args);
                if ((0, _shared.hyphenate)(event) !== event) dispatch((0, _shared.hyphenate)(event), args);
            };
            // locate nearest Vue custom element parent for provide/inject
            let parent = this;
            while(parent = parent && (parent.parentNode || parent.host))if (parent instanceof VueElement) {
                instance.parent = parent._instance;
                instance.provides = parent._instance.provides;
                break;
            }
        };
        return vnode;
    }
    _applyStyles(styles) {
        if (styles) styles.forEach((css)=>{
            const s = document.createElement("style");
            s.textContent = css;
            this.shadowRoot.appendChild(s);
            (this._styles || (this._styles = [])).push(s);
        });
    }
}
function useCssModule(name = "$style") {
    /* istanbul ignore else */ {
        const instance = (0, _runtimeCore.getCurrentInstance)();
        if (!instance) {
            (0, _runtimeCore.warn)(`useCssModule must be called inside setup()`);
            return 0, _shared.EMPTY_OBJ;
        }
        const modules = instance.type.__cssModules;
        if (!modules) {
            (0, _runtimeCore.warn)(`Current instance does not have CSS modules injected.`);
            return 0, _shared.EMPTY_OBJ;
        }
        const mod = modules[name];
        if (!mod) {
            (0, _runtimeCore.warn)(`Current instance does not have CSS module named "${name}".`);
            return 0, _shared.EMPTY_OBJ;
        }
        return mod;
    }
}
/**
 * Runtime helper for SFC's CSS variable injection feature.
 * @private
 */ function useCssVars(getter) {
    const instance = (0, _runtimeCore.getCurrentInstance)();
    /* istanbul ignore next */ if (!instance) {
        (0, _runtimeCore.warn)(`useCssVars is called without current active component instance.`);
        return;
    }
    const updateTeleports = instance.ut = (vars = getter(instance.proxy))=>{
        Array.from(document.querySelectorAll(`[data-v-owner="${instance.uid}"]`)).forEach((node)=>setVarsOnNode(node, vars));
    };
    const setVars = ()=>{
        const vars = getter(instance.proxy);
        setVarsOnVNode(instance.subTree, vars);
        updateTeleports(vars);
    };
    (0, _runtimeCore.watchPostEffect)(setVars);
    (0, _runtimeCore.onMounted)(()=>{
        const ob = new MutationObserver(setVars);
        ob.observe(instance.subTree.el.parentNode, {
            childList: true
        });
        (0, _runtimeCore.onUnmounted)(()=>ob.disconnect());
    });
}
function setVarsOnVNode(vnode, vars) {
    if (vnode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) {
        const suspense = vnode.suspense;
        vnode = suspense.activeBranch;
        if (suspense.pendingBranch && !suspense.isHydrating) suspense.effects.push(()=>{
            setVarsOnVNode(suspense.activeBranch, vars);
        });
    }
    // drill down HOCs until it's a non-component vnode
    while(vnode.component)vnode = vnode.component.subTree;
    if (vnode.shapeFlag & 1 /* ShapeFlags.ELEMENT */  && vnode.el) setVarsOnNode(vnode.el, vars);
    else if (vnode.type === (0, _runtimeCore.Fragment)) vnode.children.forEach((c)=>setVarsOnVNode(c, vars));
    else if (vnode.type === (0, _runtimeCore.Static)) {
        let { el , anchor  } = vnode;
        while(el){
            setVarsOnNode(el, vars);
            if (el === anchor) break;
            el = el.nextSibling;
        }
    }
}
function setVarsOnNode(el, vars) {
    if (el.nodeType === 1) {
        const style = el.style;
        for(const key in vars)style.setProperty(`--${key}`, vars[key]);
    }
}
const TRANSITION = "transition";
const ANIMATION = "animation";
// DOM Transition is a higher-order-component based on the platform-agnostic
// base Transition component, with DOM-specific logic.
const Transition = (props, { slots  })=>(0, _runtimeCore.h)((0, _runtimeCore.BaseTransition), resolveTransitionProps(props), slots);
Transition.displayName = "Transition";
const DOMTransitionPropsValidators = {
    name: String,
    type: String,
    css: {
        type: Boolean,
        default: true
    },
    duration: [
        String,
        Number,
        Object
    ],
    enterFromClass: String,
    enterActiveClass: String,
    enterToClass: String,
    appearFromClass: String,
    appearActiveClass: String,
    appearToClass: String,
    leaveFromClass: String,
    leaveActiveClass: String,
    leaveToClass: String
};
const TransitionPropsValidators = Transition.props = /*#__PURE__*/ (0, _shared.extend)({}, (0, _runtimeCore.BaseTransition).props, DOMTransitionPropsValidators);
/**
 * #3227 Incoming hooks may be merged into arrays when wrapping Transition
 * with custom HOCs.
 */ const callHook = (hook, args = [])=>{
    if ((0, _shared.isArray)(hook)) hook.forEach((h)=>h(...args));
    else if (hook) hook(...args);
};
/**
 * Check if a hook expects a callback (2nd arg), which means the user
 * intends to explicitly control the end of the transition.
 */ const hasExplicitCallback = (hook)=>{
    return hook ? (0, _shared.isArray)(hook) ? hook.some((h)=>h.length > 1) : hook.length > 1 : false;
};
function resolveTransitionProps(rawProps) {
    const baseProps = {};
    for(const key in rawProps)if (!(key in DOMTransitionPropsValidators)) baseProps[key] = rawProps[key];
    if (rawProps.css === false) return baseProps;
    const { name ="v" , type , duration , enterFromClass =`${name}-enter-from` , enterActiveClass =`${name}-enter-active` , enterToClass =`${name}-enter-to` , appearFromClass =enterFromClass , appearActiveClass =enterActiveClass , appearToClass =enterToClass , leaveFromClass =`${name}-leave-from` , leaveActiveClass =`${name}-leave-active` , leaveToClass =`${name}-leave-to`  } = rawProps;
    const durations = normalizeDuration(duration);
    const enterDuration = durations && durations[0];
    const leaveDuration = durations && durations[1];
    const { onBeforeEnter , onEnter , onEnterCancelled , onLeave , onLeaveCancelled , onBeforeAppear =onBeforeEnter , onAppear =onEnter , onAppearCancelled =onEnterCancelled  } = baseProps;
    const finishEnter = (el, isAppear, done)=>{
        removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
        removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
        done && done();
    };
    const finishLeave = (el, done)=>{
        el._isLeaving = false;
        removeTransitionClass(el, leaveFromClass);
        removeTransitionClass(el, leaveToClass);
        removeTransitionClass(el, leaveActiveClass);
        done && done();
    };
    const makeEnterHook = (isAppear)=>{
        return (el, done)=>{
            const hook = isAppear ? onAppear : onEnter;
            const resolve = ()=>finishEnter(el, isAppear, done);
            callHook(hook, [
                el,
                resolve
            ]);
            nextFrame(()=>{
                removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
                addTransitionClass(el, isAppear ? appearToClass : enterToClass);
                if (!hasExplicitCallback(hook)) whenTransitionEnds(el, type, enterDuration, resolve);
            });
        };
    };
    return (0, _shared.extend)(baseProps, {
        onBeforeEnter (el) {
            callHook(onBeforeEnter, [
                el
            ]);
            addTransitionClass(el, enterFromClass);
            addTransitionClass(el, enterActiveClass);
        },
        onBeforeAppear (el) {
            callHook(onBeforeAppear, [
                el
            ]);
            addTransitionClass(el, appearFromClass);
            addTransitionClass(el, appearActiveClass);
        },
        onEnter: makeEnterHook(false),
        onAppear: makeEnterHook(true),
        onLeave (el, done) {
            el._isLeaving = true;
            const resolve = ()=>finishLeave(el, done);
            addTransitionClass(el, leaveFromClass);
            // force reflow so *-leave-from classes immediately take effect (#2593)
            forceReflow();
            addTransitionClass(el, leaveActiveClass);
            nextFrame(()=>{
                if (!el._isLeaving) // cancelled
                return;
                removeTransitionClass(el, leaveFromClass);
                addTransitionClass(el, leaveToClass);
                if (!hasExplicitCallback(onLeave)) whenTransitionEnds(el, type, leaveDuration, resolve);
            });
            callHook(onLeave, [
                el,
                resolve
            ]);
        },
        onEnterCancelled (el) {
            finishEnter(el, false);
            callHook(onEnterCancelled, [
                el
            ]);
        },
        onAppearCancelled (el) {
            finishEnter(el, true);
            callHook(onAppearCancelled, [
                el
            ]);
        },
        onLeaveCancelled (el) {
            finishLeave(el);
            callHook(onLeaveCancelled, [
                el
            ]);
        }
    });
}
function normalizeDuration(duration) {
    if (duration == null) return null;
    else if ((0, _shared.isObject)(duration)) return [
        NumberOf(duration.enter),
        NumberOf(duration.leave)
    ];
    else {
        const n = NumberOf(duration);
        return [
            n,
            n
        ];
    }
}
function NumberOf(val) {
    const res = (0, _shared.toNumber)(val);
    (0, _runtimeCore.assertNumber)(res, "<transition> explicit duration");
    return res;
}
function addTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c)=>c && el.classList.add(c));
    (el._vtc || (el._vtc = new Set())).add(cls);
}
function removeTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c)=>c && el.classList.remove(c));
    const { _vtc  } = el;
    if (_vtc) {
        _vtc.delete(cls);
        if (!_vtc.size) el._vtc = undefined;
    }
}
function nextFrame(cb) {
    requestAnimationFrame(()=>{
        requestAnimationFrame(cb);
    });
}
let endId = 0;
function whenTransitionEnds(el, expectedType, explicitTimeout, resolve) {
    const id = el._endId = ++endId;
    const resolveIfNotStale = ()=>{
        if (id === el._endId) resolve();
    };
    if (explicitTimeout) return setTimeout(resolveIfNotStale, explicitTimeout);
    const { type , timeout , propCount  } = getTransitionInfo(el, expectedType);
    if (!type) return resolve();
    const endEvent = type + "end";
    let ended = 0;
    const end = ()=>{
        el.removeEventListener(endEvent, onEnd);
        resolveIfNotStale();
    };
    const onEnd = (e)=>{
        if (e.target === el && ++ended >= propCount) end();
    };
    setTimeout(()=>{
        if (ended < propCount) end();
    }, timeout + 1);
    el.addEventListener(endEvent, onEnd);
}
function getTransitionInfo(el, expectedType) {
    const styles = window.getComputedStyle(el);
    // JSDOM may return undefined for transition properties
    const getStyleProperties = (key)=>(styles[key] || "").split(", ");
    const transitionDelays = getStyleProperties(`${TRANSITION}Delay`);
    const transitionDurations = getStyleProperties(`${TRANSITION}Duration`);
    const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
    const animationDelays = getStyleProperties(`${ANIMATION}Delay`);
    const animationDurations = getStyleProperties(`${ANIMATION}Duration`);
    const animationTimeout = getTimeout(animationDelays, animationDurations);
    let type = null;
    let timeout = 0;
    let propCount = 0;
    /* istanbul ignore if */ if (expectedType === TRANSITION) {
        if (transitionTimeout > 0) {
            type = TRANSITION;
            timeout = transitionTimeout;
            propCount = transitionDurations.length;
        }
    } else if (expectedType === ANIMATION) {
        if (animationTimeout > 0) {
            type = ANIMATION;
            timeout = animationTimeout;
            propCount = animationDurations.length;
        }
    } else {
        timeout = Math.max(transitionTimeout, animationTimeout);
        type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
        propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
    }
    const hasTransform = type === TRANSITION && /\b(transform|all)(,|$)/.test(getStyleProperties(`${TRANSITION}Property`).toString());
    return {
        type,
        timeout,
        propCount,
        hasTransform
    };
}
function getTimeout(delays, durations) {
    while(delays.length < durations.length)delays = delays.concat(delays);
    return Math.max(...durations.map((d, i)=>toMs(d) + toMs(delays[i])));
}
// Old versions of Chromium (below 61.0.3163.100) formats floating pointer
// numbers in a locale-dependent way, using a comma instead of a dot.
// If comma is not replaced with a dot, the input will be rounded down
// (i.e. acting as a floor function) causing unexpected behaviors
function toMs(s) {
    return Number(s.slice(0, -1).replace(",", ".")) * 1000;
}
// synchronously force layout to put elements into a certain state
function forceReflow() {
    return document.body.offsetHeight;
}
const positionMap = new WeakMap();
const newPositionMap = new WeakMap();
const TransitionGroupImpl = {
    name: "TransitionGroup",
    props: /*#__PURE__*/ (0, _shared.extend)({}, TransitionPropsValidators, {
        tag: String,
        moveClass: String
    }),
    setup (props, { slots  }) {
        const instance = (0, _runtimeCore.getCurrentInstance)();
        const state = (0, _runtimeCore.useTransitionState)();
        let prevChildren;
        let children;
        (0, _runtimeCore.onUpdated)(()=>{
            // children is guaranteed to exist after initial render
            if (!prevChildren.length) return;
            const moveClass = props.moveClass || `${props.name || "v"}-move`;
            if (!hasCSSTransform(prevChildren[0].el, instance.vnode.el, moveClass)) return;
            // we divide the work into three loops to avoid mixing DOM reads and writes
            // in each iteration - which helps prevent layout thrashing.
            prevChildren.forEach(callPendingCbs);
            prevChildren.forEach(recordPosition);
            const movedChildren = prevChildren.filter(applyTranslation);
            // force reflow to put everything in position
            forceReflow();
            movedChildren.forEach((c)=>{
                const el = c.el;
                const style = el.style;
                addTransitionClass(el, moveClass);
                style.transform = style.webkitTransform = style.transitionDuration = "";
                const cb = el._moveCb = (e)=>{
                    if (e && e.target !== el) return;
                    if (!e || /transform$/.test(e.propertyName)) {
                        el.removeEventListener("transitionend", cb);
                        el._moveCb = null;
                        removeTransitionClass(el, moveClass);
                    }
                };
                el.addEventListener("transitionend", cb);
            });
        });
        return ()=>{
            const rawProps = (0, _runtimeCore.toRaw)(props);
            const cssTransitionProps = resolveTransitionProps(rawProps);
            let tag = rawProps.tag || (0, _runtimeCore.Fragment);
            prevChildren = children;
            children = slots.default ? (0, _runtimeCore.getTransitionRawChildren)(slots.default()) : [];
            for(let i = 0; i < children.length; i++){
                const child = children[i];
                if (child.key != null) (0, _runtimeCore.setTransitionHooks)(child, (0, _runtimeCore.resolveTransitionHooks)(child, cssTransitionProps, state, instance));
                else (0, _runtimeCore.warn)(`<TransitionGroup> children must be keyed.`);
            }
            if (prevChildren) for(let i = 0; i < prevChildren.length; i++){
                const child = prevChildren[i];
                (0, _runtimeCore.setTransitionHooks)(child, (0, _runtimeCore.resolveTransitionHooks)(child, cssTransitionProps, state, instance));
                positionMap.set(child, child.el.getBoundingClientRect());
            }
            return (0, _runtimeCore.createVNode)(tag, null, children);
        };
    }
};
/**
 * TransitionGroup does not support "mode" so we need to remove it from the
 * props declarations, but direct delete operation is considered a side effect
 * and will make the entire transition feature non-tree-shakeable, so we do it
 * in a function and mark the function's invocation as pure.
 */ const removeMode = (props)=>delete props.mode;
/*#__PURE__*/ removeMode(TransitionGroupImpl.props);
const TransitionGroup = TransitionGroupImpl;
function callPendingCbs(c) {
    const el = c.el;
    if (el._moveCb) el._moveCb();
    if (el._enterCb) el._enterCb();
}
function recordPosition(c) {
    newPositionMap.set(c, c.el.getBoundingClientRect());
}
function applyTranslation(c) {
    const oldPos = positionMap.get(c);
    const newPos = newPositionMap.get(c);
    const dx = oldPos.left - newPos.left;
    const dy = oldPos.top - newPos.top;
    if (dx || dy) {
        const s = c.el.style;
        s.transform = s.webkitTransform = `translate(${dx}px,${dy}px)`;
        s.transitionDuration = "0s";
        return c;
    }
}
function hasCSSTransform(el, root, moveClass) {
    // Detect whether an element with the move class applied has
    // CSS transitions. Since the element may be inside an entering
    // transition at this very moment, we make a clone of it and remove
    // all other transition classes applied to ensure only the move class
    // is applied.
    const clone = el.cloneNode();
    if (el._vtc) el._vtc.forEach((cls)=>{
        cls.split(/\s+/).forEach((c)=>c && clone.classList.remove(c));
    });
    moveClass.split(/\s+/).forEach((c)=>c && clone.classList.add(c));
    clone.style.display = "none";
    const container = root.nodeType === 1 ? root : root.parentNode;
    container.appendChild(clone);
    const { hasTransform  } = getTransitionInfo(clone);
    container.removeChild(clone);
    return hasTransform;
}
const getModelAssigner = (vnode)=>{
    const fn = vnode.props["onUpdate:modelValue"] || false;
    return (0, _shared.isArray)(fn) ? (value)=>(0, _shared.invokeArrayFns)(fn, value) : fn;
};
function onCompositionStart(e) {
    e.target.composing = true;
}
function onCompositionEnd(e) {
    const target = e.target;
    if (target.composing) {
        target.composing = false;
        target.dispatchEvent(new Event("input"));
    }
}
// We are exporting the v-model runtime directly as vnode hooks so that it can
// be tree-shaken in case v-model is never used.
const vModelText = {
    created (el, { modifiers: { lazy , trim , number  }  }, vnode) {
        el._assign = getModelAssigner(vnode);
        const castToNumber = number || vnode.props && vnode.props.type === "number";
        addEventListener(el, lazy ? "change" : "input", (e)=>{
            if (e.target.composing) return;
            let domValue = el.value;
            if (trim) domValue = domValue.trim();
            if (castToNumber) domValue = (0, _shared.looseToNumber)(domValue);
            el._assign(domValue);
        });
        if (trim) addEventListener(el, "change", ()=>{
            el.value = el.value.trim();
        });
        if (!lazy) {
            addEventListener(el, "compositionstart", onCompositionStart);
            addEventListener(el, "compositionend", onCompositionEnd);
            // Safari < 10.2 & UIWebView doesn't fire compositionend when
            // switching focus before confirming composition choice
            // this also fixes the issue where some browsers e.g. iOS Chrome
            // fires "change" instead of "input" on autocomplete.
            addEventListener(el, "change", onCompositionEnd);
        }
    },
    // set value on mounted so it's after min/max for type="range"
    mounted (el, { value  }) {
        el.value = value == null ? "" : value;
    },
    beforeUpdate (el, { value , modifiers: { lazy , trim , number  }  }, vnode) {
        el._assign = getModelAssigner(vnode);
        // avoid clearing unresolved text. #2302
        if (el.composing) return;
        if (document.activeElement === el && el.type !== "range") {
            if (lazy) return;
            if (trim && el.value.trim() === value) return;
            if ((number || el.type === "number") && (0, _shared.looseToNumber)(el.value) === value) return;
        }
        const newValue = value == null ? "" : value;
        if (el.value !== newValue) el.value = newValue;
    }
};
const vModelCheckbox = {
    // #4096 array checkboxes need to be deep traversed
    deep: true,
    created (el, _, vnode) {
        el._assign = getModelAssigner(vnode);
        addEventListener(el, "change", ()=>{
            const modelValue = el._modelValue;
            const elementValue = getValue(el);
            const checked = el.checked;
            const assign = el._assign;
            if ((0, _shared.isArray)(modelValue)) {
                const index = (0, _shared.looseIndexOf)(modelValue, elementValue);
                const found = index !== -1;
                if (checked && !found) assign(modelValue.concat(elementValue));
                else if (!checked && found) {
                    const filtered = [
                        ...modelValue
                    ];
                    filtered.splice(index, 1);
                    assign(filtered);
                }
            } else if ((0, _shared.isSet)(modelValue)) {
                const cloned = new Set(modelValue);
                if (checked) cloned.add(elementValue);
                else cloned.delete(elementValue);
                assign(cloned);
            } else assign(getCheckboxValue(el, checked));
        });
    },
    // set initial checked on mount to wait for true-value/false-value
    mounted: setChecked,
    beforeUpdate (el, binding, vnode) {
        el._assign = getModelAssigner(vnode);
        setChecked(el, binding, vnode);
    }
};
function setChecked(el, { value , oldValue  }, vnode) {
    el._modelValue = value;
    if ((0, _shared.isArray)(value)) el.checked = (0, _shared.looseIndexOf)(value, vnode.props.value) > -1;
    else if ((0, _shared.isSet)(value)) el.checked = value.has(vnode.props.value);
    else if (value !== oldValue) el.checked = (0, _shared.looseEqual)(value, getCheckboxValue(el, true));
}
const vModelRadio = {
    created (el, { value  }, vnode) {
        el.checked = (0, _shared.looseEqual)(value, vnode.props.value);
        el._assign = getModelAssigner(vnode);
        addEventListener(el, "change", ()=>{
            el._assign(getValue(el));
        });
    },
    beforeUpdate (el, { value , oldValue  }, vnode) {
        el._assign = getModelAssigner(vnode);
        if (value !== oldValue) el.checked = (0, _shared.looseEqual)(value, vnode.props.value);
    }
};
const vModelSelect = {
    // <select multiple> value need to be deep traversed
    deep: true,
    created (el, { value , modifiers: { number  }  }, vnode) {
        const isSetModel = (0, _shared.isSet)(value);
        addEventListener(el, "change", ()=>{
            const selectedVal = Array.prototype.filter.call(el.options, (o)=>o.selected).map((o)=>number ? (0, _shared.looseToNumber)(getValue(o)) : getValue(o));
            el._assign(el.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]);
        });
        el._assign = getModelAssigner(vnode);
    },
    // set value in mounted & updated because <select> relies on its children
    // <option>s.
    mounted (el, { value  }) {
        setSelected(el, value);
    },
    beforeUpdate (el, _binding, vnode) {
        el._assign = getModelAssigner(vnode);
    },
    updated (el, { value  }) {
        setSelected(el, value);
    }
};
function setSelected(el, value) {
    const isMultiple = el.multiple;
    if (isMultiple && !(0, _shared.isArray)(value) && !(0, _shared.isSet)(value)) {
        (0, _runtimeCore.warn)(`<select multiple v-model> expects an Array or Set value for its binding, ` + `but got ${Object.prototype.toString.call(value).slice(8, -1)}.`);
        return;
    }
    for(let i = 0, l = el.options.length; i < l; i++){
        const option = el.options[i];
        const optionValue = getValue(option);
        if (isMultiple) {
            if ((0, _shared.isArray)(value)) option.selected = (0, _shared.looseIndexOf)(value, optionValue) > -1;
            else option.selected = value.has(optionValue);
        } else if ((0, _shared.looseEqual)(getValue(option), value)) {
            if (el.selectedIndex !== i) el.selectedIndex = i;
            return;
        }
    }
    if (!isMultiple && el.selectedIndex !== -1) el.selectedIndex = -1;
}
// retrieve raw value set via :value bindings
function getValue(el) {
    return "_value" in el ? el._value : el.value;
}
// retrieve raw value for true-value and false-value set via :true-value or :false-value bindings
function getCheckboxValue(el, checked) {
    const key = checked ? "_trueValue" : "_falseValue";
    return key in el ? el[key] : checked;
}
const vModelDynamic = {
    created (el, binding, vnode) {
        callModelHook(el, binding, vnode, null, "created");
    },
    mounted (el, binding, vnode) {
        callModelHook(el, binding, vnode, null, "mounted");
    },
    beforeUpdate (el, binding, vnode, prevVNode) {
        callModelHook(el, binding, vnode, prevVNode, "beforeUpdate");
    },
    updated (el, binding, vnode, prevVNode) {
        callModelHook(el, binding, vnode, prevVNode, "updated");
    }
};
function resolveDynamicModel(tagName, type) {
    switch(tagName){
        case "SELECT":
            return vModelSelect;
        case "TEXTAREA":
            return vModelText;
        default:
            switch(type){
                case "checkbox":
                    return vModelCheckbox;
                case "radio":
                    return vModelRadio;
                default:
                    return vModelText;
            }
    }
}
function callModelHook(el, binding, vnode, prevVNode, hook) {
    const modelToUse = resolveDynamicModel(el.tagName, vnode.props && vnode.props.type);
    const fn = modelToUse[hook];
    fn && fn(el, binding, vnode, prevVNode);
}
// SSR vnode transforms, only used when user includes client-oriented render
// function in SSR
function initVModelForSSR() {
    vModelText.getSSRProps = ({ value  })=>({
            value
        });
    vModelRadio.getSSRProps = ({ value  }, vnode)=>{
        if (vnode.props && (0, _shared.looseEqual)(vnode.props.value, value)) return {
            checked: true
        };
    };
    vModelCheckbox.getSSRProps = ({ value  }, vnode)=>{
        if ((0, _shared.isArray)(value)) {
            if (vnode.props && (0, _shared.looseIndexOf)(value, vnode.props.value) > -1) return {
                checked: true
            };
        } else if ((0, _shared.isSet)(value)) {
            if (vnode.props && value.has(vnode.props.value)) return {
                checked: true
            };
        } else if (value) return {
            checked: true
        };
    };
    vModelDynamic.getSSRProps = (binding, vnode)=>{
        if (typeof vnode.type !== "string") return;
        const modelToUse = resolveDynamicModel(// resolveDynamicModel expects an uppercase tag name, but vnode.type is lowercase
        vnode.type.toUpperCase(), vnode.props && vnode.props.type);
        if (modelToUse.getSSRProps) return modelToUse.getSSRProps(binding, vnode);
    };
}
const systemModifiers = [
    "ctrl",
    "shift",
    "alt",
    "meta"
];
const modifierGuards = {
    stop: (e)=>e.stopPropagation(),
    prevent: (e)=>e.preventDefault(),
    self: (e)=>e.target !== e.currentTarget,
    ctrl: (e)=>!e.ctrlKey,
    shift: (e)=>!e.shiftKey,
    alt: (e)=>!e.altKey,
    meta: (e)=>!e.metaKey,
    left: (e)=>"button" in e && e.button !== 0,
    middle: (e)=>"button" in e && e.button !== 1,
    right: (e)=>"button" in e && e.button !== 2,
    exact: (e, modifiers)=>systemModifiers.some((m)=>e[`${m}Key`] && !modifiers.includes(m))
};
/**
 * @private
 */ const withModifiers = (fn, modifiers)=>{
    return (event, ...args)=>{
        for(let i = 0; i < modifiers.length; i++){
            const guard = modifierGuards[modifiers[i]];
            if (guard && guard(event, modifiers)) return;
        }
        return fn(event, ...args);
    };
};
// Kept for 2.x compat.
// Note: IE11 compat for `spacebar` and `del` is removed for now.
const keyNames = {
    esc: "escape",
    space: " ",
    up: "arrow-up",
    left: "arrow-left",
    right: "arrow-right",
    down: "arrow-down",
    delete: "backspace"
};
/**
 * @private
 */ const withKeys = (fn, modifiers)=>{
    return (event)=>{
        if (!("key" in event)) return;
        const eventKey = (0, _shared.hyphenate)(event.key);
        if (modifiers.some((k)=>k === eventKey || keyNames[k] === eventKey)) return fn(event);
    };
};
const vShow = {
    beforeMount (el, { value  }, { transition  }) {
        el._vod = el.style.display === "none" ? "" : el.style.display;
        if (transition && value) transition.beforeEnter(el);
        else setDisplay(el, value);
    },
    mounted (el, { value  }, { transition  }) {
        if (transition && value) transition.enter(el);
    },
    updated (el, { value , oldValue  }, { transition  }) {
        if (!value === !oldValue) return;
        if (transition) {
            if (value) {
                transition.beforeEnter(el);
                setDisplay(el, true);
                transition.enter(el);
            } else transition.leave(el, ()=>{
                setDisplay(el, false);
            });
        } else setDisplay(el, value);
    },
    beforeUnmount (el, { value  }) {
        setDisplay(el, value);
    }
};
function setDisplay(el, value) {
    el.style.display = value ? el._vod : "none";
}
// SSR vnode transforms, only used when user includes client-oriented render
// function in SSR
function initVShowForSSR() {
    vShow.getSSRProps = ({ value  })=>{
        if (!value) return {
            style: {
                display: "none"
            }
        };
    };
}
const rendererOptions = /*#__PURE__*/ (0, _shared.extend)({
    patchProp
}, nodeOps);
// lazy create the renderer - this makes core renderer logic tree-shakable
// in case the user only imports reactivity utilities from Vue.
let renderer;
let enabledHydration = false;
function ensureRenderer() {
    return renderer || (renderer = (0, _runtimeCore.createRenderer)(rendererOptions));
}
function ensureHydrationRenderer() {
    renderer = enabledHydration ? renderer : (0, _runtimeCore.createHydrationRenderer)(rendererOptions);
    enabledHydration = true;
    return renderer;
}
// use explicit type casts here to avoid import() calls in rolled-up d.ts
const render = (...args)=>{
    ensureRenderer().render(...args);
};
const hydrate = (...args)=>{
    ensureHydrationRenderer().hydrate(...args);
};
const createApp = (...args)=>{
    const app = ensureRenderer().createApp(...args);
    injectNativeTagCheck(app);
    injectCompilerOptionsCheck(app);
    const { mount  } = app;
    app.mount = (containerOrSelector)=>{
        const container = normalizeContainer(containerOrSelector);
        if (!container) return;
        const component = app._component;
        if (!(0, _shared.isFunction)(component) && !component.render && !component.template) // __UNSAFE__
        // Reason: potential execution of JS expressions in in-DOM template.
        // The user must make sure the in-DOM template is trusted. If it's
        // rendered by the server, the template should not contain any user data.
        component.template = container.innerHTML;
        // clear content before mounting
        container.innerHTML = "";
        const proxy = mount(container, false, container instanceof SVGElement);
        if (container instanceof Element) {
            container.removeAttribute("v-cloak");
            container.setAttribute("data-v-app", "");
        }
        return proxy;
    };
    return app;
};
const createSSRApp = (...args)=>{
    const app = ensureHydrationRenderer().createApp(...args);
    injectNativeTagCheck(app);
    injectCompilerOptionsCheck(app);
    const { mount  } = app;
    app.mount = (containerOrSelector)=>{
        const container = normalizeContainer(containerOrSelector);
        if (container) return mount(container, true, container instanceof SVGElement);
    };
    return app;
};
function injectNativeTagCheck(app) {
    // Inject `isNativeTag`
    // this is used for component name validation (dev only)
    Object.defineProperty(app.config, "isNativeTag", {
        value: (tag)=>(0, _shared.isHTMLTag)(tag) || (0, _shared.isSVGTag)(tag),
        writable: false
    });
}
// dev only
function injectCompilerOptionsCheck(app) {
    if ((0, _runtimeCore.isRuntimeOnly)()) {
        const isCustomElement = app.config.isCustomElement;
        Object.defineProperty(app.config, "isCustomElement", {
            get () {
                return isCustomElement;
            },
            set () {
                (0, _runtimeCore.warn)(`The \`isCustomElement\` config option is deprecated. Use ` + `\`compilerOptions.isCustomElement\` instead.`);
            }
        });
        const compilerOptions = app.config.compilerOptions;
        const msg = `The \`compilerOptions\` config option is only respected when using ` + `a build of Vue.js that includes the runtime compiler (aka "full build"). ` + `Since you are using the runtime-only build, \`compilerOptions\` ` + `must be passed to \`@vue/compiler-dom\` in the build setup instead.\n` + `- For vue-loader: pass it via vue-loader's \`compilerOptions\` loader option.\n` + `- For vue-cli: see https://cli.vuejs.org/guide/webpack.html#modifying-options-of-a-loader\n` + `- For vite: pass it via @vitejs/plugin-vue options. See https://github.com/vitejs/vite/tree/main/packages/plugin-vue#example-for-passing-options-to-vuecompiler-dom`;
        Object.defineProperty(app.config, "compilerOptions", {
            get () {
                (0, _runtimeCore.warn)(msg);
                return compilerOptions;
            },
            set () {
                (0, _runtimeCore.warn)(msg);
            }
        });
    }
}
function normalizeContainer(container) {
    if ((0, _shared.isString)(container)) {
        const res = document.querySelector(container);
        if (!res) (0, _runtimeCore.warn)(`Failed to mount app: mount target selector "${container}" returned null.`);
        return res;
    }
    if ((0, window.ShadowRoot) && container instanceof window.ShadowRoot && container.mode === "closed") (0, _runtimeCore.warn)(`mounting on a ShadowRoot with \`{mode: "closed"}\` may lead to unpredictable bugs`);
    return container;
}
let ssrDirectiveInitialized = false;
/**
 * @internal
 */ const initDirectivesForSSR = ()=>{
    if (!ssrDirectiveInitialized) {
        ssrDirectiveInitialized = true;
        initVModelForSSR();
        initVShowForSSR();
    }
};

},{"@vue/runtime-core":"lmqBl","@vue/shared":"3SM3y","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"lmqBl":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "EffectScope", ()=>(0, _reactivity.EffectScope));
parcelHelpers.export(exports, "ReactiveEffect", ()=>(0, _reactivity.ReactiveEffect));
parcelHelpers.export(exports, "customRef", ()=>(0, _reactivity.customRef));
parcelHelpers.export(exports, "effect", ()=>(0, _reactivity.effect));
parcelHelpers.export(exports, "effectScope", ()=>(0, _reactivity.effectScope));
parcelHelpers.export(exports, "getCurrentScope", ()=>(0, _reactivity.getCurrentScope));
parcelHelpers.export(exports, "isProxy", ()=>(0, _reactivity.isProxy));
parcelHelpers.export(exports, "isReactive", ()=>(0, _reactivity.isReactive));
parcelHelpers.export(exports, "isReadonly", ()=>(0, _reactivity.isReadonly));
parcelHelpers.export(exports, "isRef", ()=>(0, _reactivity.isRef));
parcelHelpers.export(exports, "isShallow", ()=>(0, _reactivity.isShallow));
parcelHelpers.export(exports, "markRaw", ()=>(0, _reactivity.markRaw));
parcelHelpers.export(exports, "onScopeDispose", ()=>(0, _reactivity.onScopeDispose));
parcelHelpers.export(exports, "proxyRefs", ()=>(0, _reactivity.proxyRefs));
parcelHelpers.export(exports, "reactive", ()=>(0, _reactivity.reactive));
parcelHelpers.export(exports, "readonly", ()=>(0, _reactivity.readonly));
parcelHelpers.export(exports, "ref", ()=>(0, _reactivity.ref));
parcelHelpers.export(exports, "shallowReactive", ()=>(0, _reactivity.shallowReactive));
parcelHelpers.export(exports, "shallowReadonly", ()=>(0, _reactivity.shallowReadonly));
parcelHelpers.export(exports, "shallowRef", ()=>(0, _reactivity.shallowRef));
parcelHelpers.export(exports, "stop", ()=>(0, _reactivity.stop));
parcelHelpers.export(exports, "toRaw", ()=>(0, _reactivity.toRaw));
parcelHelpers.export(exports, "toRef", ()=>(0, _reactivity.toRef));
parcelHelpers.export(exports, "toRefs", ()=>(0, _reactivity.toRefs));
parcelHelpers.export(exports, "triggerRef", ()=>(0, _reactivity.triggerRef));
parcelHelpers.export(exports, "unref", ()=>(0, _reactivity.unref));
parcelHelpers.export(exports, "camelize", ()=>(0, _shared.camelize));
parcelHelpers.export(exports, "capitalize", ()=>(0, _shared.capitalize));
parcelHelpers.export(exports, "normalizeClass", ()=>(0, _shared.normalizeClass));
parcelHelpers.export(exports, "normalizeProps", ()=>(0, _shared.normalizeProps));
parcelHelpers.export(exports, "normalizeStyle", ()=>(0, _shared.normalizeStyle));
parcelHelpers.export(exports, "toDisplayString", ()=>(0, _shared.toDisplayString));
parcelHelpers.export(exports, "toHandlerKey", ()=>(0, _shared.toHandlerKey));
parcelHelpers.export(exports, "BaseTransition", ()=>BaseTransition);
parcelHelpers.export(exports, "Comment", ()=>Comment);
parcelHelpers.export(exports, "Fragment", ()=>Fragment);
parcelHelpers.export(exports, "KeepAlive", ()=>KeepAlive);
parcelHelpers.export(exports, "Static", ()=>Static);
parcelHelpers.export(exports, "Suspense", ()=>Suspense);
parcelHelpers.export(exports, "Teleport", ()=>Teleport);
parcelHelpers.export(exports, "Text", ()=>Text);
parcelHelpers.export(exports, "assertNumber", ()=>assertNumber);
parcelHelpers.export(exports, "callWithAsyncErrorHandling", ()=>callWithAsyncErrorHandling);
parcelHelpers.export(exports, "callWithErrorHandling", ()=>callWithErrorHandling);
parcelHelpers.export(exports, "cloneVNode", ()=>cloneVNode);
parcelHelpers.export(exports, "compatUtils", ()=>compatUtils);
parcelHelpers.export(exports, "computed", ()=>computed);
parcelHelpers.export(exports, "createBlock", ()=>createBlock);
parcelHelpers.export(exports, "createCommentVNode", ()=>createCommentVNode);
parcelHelpers.export(exports, "createElementBlock", ()=>createElementBlock);
parcelHelpers.export(exports, "createElementVNode", ()=>createBaseVNode);
parcelHelpers.export(exports, "createHydrationRenderer", ()=>createHydrationRenderer);
parcelHelpers.export(exports, "createPropsRestProxy", ()=>createPropsRestProxy);
parcelHelpers.export(exports, "createRenderer", ()=>createRenderer);
parcelHelpers.export(exports, "createSlots", ()=>createSlots);
parcelHelpers.export(exports, "createStaticVNode", ()=>createStaticVNode);
parcelHelpers.export(exports, "createTextVNode", ()=>createTextVNode);
parcelHelpers.export(exports, "createVNode", ()=>createVNode);
parcelHelpers.export(exports, "defineAsyncComponent", ()=>defineAsyncComponent);
parcelHelpers.export(exports, "defineComponent", ()=>defineComponent);
parcelHelpers.export(exports, "defineEmits", ()=>defineEmits);
parcelHelpers.export(exports, "defineExpose", ()=>defineExpose);
parcelHelpers.export(exports, "defineProps", ()=>defineProps);
parcelHelpers.export(exports, "devtools", ()=>devtools);
parcelHelpers.export(exports, "getCurrentInstance", ()=>getCurrentInstance);
parcelHelpers.export(exports, "getTransitionRawChildren", ()=>getTransitionRawChildren);
parcelHelpers.export(exports, "guardReactiveProps", ()=>guardReactiveProps);
parcelHelpers.export(exports, "h", ()=>h);
parcelHelpers.export(exports, "handleError", ()=>handleError);
parcelHelpers.export(exports, "initCustomFormatter", ()=>initCustomFormatter);
parcelHelpers.export(exports, "inject", ()=>inject);
parcelHelpers.export(exports, "isMemoSame", ()=>isMemoSame);
parcelHelpers.export(exports, "isRuntimeOnly", ()=>isRuntimeOnly);
parcelHelpers.export(exports, "isVNode", ()=>isVNode);
parcelHelpers.export(exports, "mergeDefaults", ()=>mergeDefaults);
parcelHelpers.export(exports, "mergeProps", ()=>mergeProps);
parcelHelpers.export(exports, "nextTick", ()=>nextTick);
parcelHelpers.export(exports, "onActivated", ()=>onActivated);
parcelHelpers.export(exports, "onBeforeMount", ()=>onBeforeMount);
parcelHelpers.export(exports, "onBeforeUnmount", ()=>onBeforeUnmount);
parcelHelpers.export(exports, "onBeforeUpdate", ()=>onBeforeUpdate);
parcelHelpers.export(exports, "onDeactivated", ()=>onDeactivated);
parcelHelpers.export(exports, "onErrorCaptured", ()=>onErrorCaptured);
parcelHelpers.export(exports, "onMounted", ()=>onMounted);
parcelHelpers.export(exports, "onRenderTracked", ()=>onRenderTracked);
parcelHelpers.export(exports, "onRenderTriggered", ()=>onRenderTriggered);
parcelHelpers.export(exports, "onServerPrefetch", ()=>onServerPrefetch);
parcelHelpers.export(exports, "onUnmounted", ()=>onUnmounted);
parcelHelpers.export(exports, "onUpdated", ()=>onUpdated);
parcelHelpers.export(exports, "openBlock", ()=>openBlock);
parcelHelpers.export(exports, "popScopeId", ()=>popScopeId);
parcelHelpers.export(exports, "provide", ()=>provide);
parcelHelpers.export(exports, "pushScopeId", ()=>pushScopeId);
parcelHelpers.export(exports, "queuePostFlushCb", ()=>queuePostFlushCb);
parcelHelpers.export(exports, "registerRuntimeCompiler", ()=>registerRuntimeCompiler);
parcelHelpers.export(exports, "renderList", ()=>renderList);
parcelHelpers.export(exports, "renderSlot", ()=>renderSlot);
parcelHelpers.export(exports, "resolveComponent", ()=>resolveComponent);
parcelHelpers.export(exports, "resolveDirective", ()=>resolveDirective);
parcelHelpers.export(exports, "resolveDynamicComponent", ()=>resolveDynamicComponent);
parcelHelpers.export(exports, "resolveFilter", ()=>resolveFilter);
parcelHelpers.export(exports, "resolveTransitionHooks", ()=>resolveTransitionHooks);
parcelHelpers.export(exports, "setBlockTracking", ()=>setBlockTracking);
parcelHelpers.export(exports, "setDevtoolsHook", ()=>setDevtoolsHook);
parcelHelpers.export(exports, "setTransitionHooks", ()=>setTransitionHooks);
parcelHelpers.export(exports, "ssrContextKey", ()=>ssrContextKey);
parcelHelpers.export(exports, "ssrUtils", ()=>ssrUtils);
parcelHelpers.export(exports, "toHandlers", ()=>toHandlers);
parcelHelpers.export(exports, "transformVNodeArgs", ()=>transformVNodeArgs);
parcelHelpers.export(exports, "useAttrs", ()=>useAttrs);
parcelHelpers.export(exports, "useSSRContext", ()=>useSSRContext);
parcelHelpers.export(exports, "useSlots", ()=>useSlots);
parcelHelpers.export(exports, "useTransitionState", ()=>useTransitionState);
parcelHelpers.export(exports, "version", ()=>version);
parcelHelpers.export(exports, "warn", ()=>warn);
parcelHelpers.export(exports, "watch", ()=>watch);
parcelHelpers.export(exports, "watchEffect", ()=>watchEffect);
parcelHelpers.export(exports, "watchPostEffect", ()=>watchPostEffect);
parcelHelpers.export(exports, "watchSyncEffect", ()=>watchSyncEffect);
parcelHelpers.export(exports, "withAsyncContext", ()=>withAsyncContext);
parcelHelpers.export(exports, "withCtx", ()=>withCtx);
parcelHelpers.export(exports, "withDefaults", ()=>withDefaults);
parcelHelpers.export(exports, "withDirectives", ()=>withDirectives);
parcelHelpers.export(exports, "withMemo", ()=>withMemo);
parcelHelpers.export(exports, "withScopeId", ()=>withScopeId);
var _reactivity = require("@vue/reactivity");
var _shared = require("@vue/shared");
const stack = [];
function pushWarningContext(vnode) {
    stack.push(vnode);
}
function popWarningContext() {
    stack.pop();
}
function warn(msg, ...args) {
    // avoid props formatting or warn handler tracking deps that might be mutated
    // during patch, leading to infinite recursion.
    (0, _reactivity.pauseTracking)();
    const instance = stack.length ? stack[stack.length - 1].component : null;
    const appWarnHandler = instance && instance.appContext.config.warnHandler;
    const trace = getComponentTrace();
    if (appWarnHandler) callWithErrorHandling(appWarnHandler, instance, 11 /* ErrorCodes.APP_WARN_HANDLER */ , [
        msg + args.join(""),
        instance && instance.proxy,
        trace.map(({ vnode  })=>`at <${formatComponentName(instance, vnode.type)}>`).join("\n"),
        trace
    ]);
    else {
        const warnArgs = [
            `[Vue warn]: ${msg}`,
            ...args
        ];
        /* istanbul ignore if */ if (trace.length && // avoid spamming console during tests
        true) warnArgs.push(`\n`, ...formatTrace(trace));
        console.warn(...warnArgs);
    }
    (0, _reactivity.resetTracking)();
}
function getComponentTrace() {
    let currentVNode = stack[stack.length - 1];
    if (!currentVNode) return [];
    // we can't just use the stack because it will be incomplete during updates
    // that did not start from the root. Re-construct the parent chain using
    // instance parent pointers.
    const normalizedStack = [];
    while(currentVNode){
        const last = normalizedStack[0];
        if (last && last.vnode === currentVNode) last.recurseCount++;
        else normalizedStack.push({
            vnode: currentVNode,
            recurseCount: 0
        });
        const parentInstance = currentVNode.component && currentVNode.component.parent;
        currentVNode = parentInstance && parentInstance.vnode;
    }
    return normalizedStack;
}
/* istanbul ignore next */ function formatTrace(trace) {
    const logs = [];
    trace.forEach((entry, i)=>{
        logs.push(...i === 0 ? [] : [
            `\n`
        ], ...formatTraceEntry(entry));
    });
    return logs;
}
function formatTraceEntry({ vnode , recurseCount  }) {
    const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
    const isRoot = vnode.component ? vnode.component.parent == null : false;
    const open = ` at <${formatComponentName(vnode.component, vnode.type, isRoot)}`;
    const close = `>` + postfix;
    return vnode.props ? [
        open,
        ...formatProps(vnode.props),
        close
    ] : [
        open + close
    ];
}
/* istanbul ignore next */ function formatProps(props) {
    const res = [];
    const keys = Object.keys(props);
    keys.slice(0, 3).forEach((key)=>{
        res.push(...formatProp(key, props[key]));
    });
    if (keys.length > 3) res.push(` ...`);
    return res;
}
/* istanbul ignore next */ function formatProp(key, value, raw) {
    if ((0, _shared.isString)(value)) {
        value = JSON.stringify(value);
        return raw ? value : [
            `${key}=${value}`
        ];
    } else if (typeof value === "number" || typeof value === "boolean" || value == null) return raw ? value : [
        `${key}=${value}`
    ];
    else if ((0, _reactivity.isRef)(value)) {
        value = formatProp(key, (0, _reactivity.toRaw)(value.value), true);
        return raw ? value : [
            `${key}=Ref<`,
            value,
            `>`
        ];
    } else if ((0, _shared.isFunction)(value)) return [
        `${key}=fn${value.name ? `<${value.name}>` : ``}`
    ];
    else {
        value = (0, _reactivity.toRaw)(value);
        return raw ? value : [
            `${key}=`,
            value
        ];
    }
}
/**
 * @internal
 */ function assertNumber(val, type) {
    if (val === undefined) return;
    else if (typeof val !== "number") warn(`${type} is not a valid number - ` + `got ${JSON.stringify(val)}.`);
    else if (isNaN(val)) warn(`${type} is NaN - ` + "the duration expression might be incorrect.");
}
const ErrorTypeStrings = {
    ["sp" /* LifecycleHooks.SERVER_PREFETCH */ ]: "serverPrefetch hook",
    ["bc" /* LifecycleHooks.BEFORE_CREATE */ ]: "beforeCreate hook",
    ["c" /* LifecycleHooks.CREATED */ ]: "created hook",
    ["bm" /* LifecycleHooks.BEFORE_MOUNT */ ]: "beforeMount hook",
    ["m" /* LifecycleHooks.MOUNTED */ ]: "mounted hook",
    ["bu" /* LifecycleHooks.BEFORE_UPDATE */ ]: "beforeUpdate hook",
    ["u" /* LifecycleHooks.UPDATED */ ]: "updated",
    ["bum" /* LifecycleHooks.BEFORE_UNMOUNT */ ]: "beforeUnmount hook",
    ["um" /* LifecycleHooks.UNMOUNTED */ ]: "unmounted hook",
    ["a" /* LifecycleHooks.ACTIVATED */ ]: "activated hook",
    ["da" /* LifecycleHooks.DEACTIVATED */ ]: "deactivated hook",
    ["ec" /* LifecycleHooks.ERROR_CAPTURED */ ]: "errorCaptured hook",
    ["rtc" /* LifecycleHooks.RENDER_TRACKED */ ]: "renderTracked hook",
    ["rtg" /* LifecycleHooks.RENDER_TRIGGERED */ ]: "renderTriggered hook",
    [0 /* ErrorCodes.SETUP_FUNCTION */ ]: "setup function",
    [1 /* ErrorCodes.RENDER_FUNCTION */ ]: "render function",
    [2 /* ErrorCodes.WATCH_GETTER */ ]: "watcher getter",
    [3 /* ErrorCodes.WATCH_CALLBACK */ ]: "watcher callback",
    [4 /* ErrorCodes.WATCH_CLEANUP */ ]: "watcher cleanup function",
    [5 /* ErrorCodes.NATIVE_EVENT_HANDLER */ ]: "native event handler",
    [6 /* ErrorCodes.COMPONENT_EVENT_HANDLER */ ]: "component event handler",
    [7 /* ErrorCodes.VNODE_HOOK */ ]: "vnode hook",
    [8 /* ErrorCodes.DIRECTIVE_HOOK */ ]: "directive hook",
    [9 /* ErrorCodes.TRANSITION_HOOK */ ]: "transition hook",
    [10 /* ErrorCodes.APP_ERROR_HANDLER */ ]: "app errorHandler",
    [11 /* ErrorCodes.APP_WARN_HANDLER */ ]: "app warnHandler",
    [12 /* ErrorCodes.FUNCTION_REF */ ]: "ref function",
    [13 /* ErrorCodes.ASYNC_COMPONENT_LOADER */ ]: "async component loader",
    [14 /* ErrorCodes.SCHEDULER */ ]: "scheduler flush. This is likely a Vue internals bug. Please open an issue at https://new-issue.vuejs.org/?repo=vuejs/core"
};
function callWithErrorHandling(fn, instance, type, args) {
    let res;
    try {
        res = args ? fn(...args) : fn();
    } catch (err) {
        handleError(err, instance, type);
    }
    return res;
}
function callWithAsyncErrorHandling(fn, instance, type, args) {
    if ((0, _shared.isFunction)(fn)) {
        const res = callWithErrorHandling(fn, instance, type, args);
        if (res && (0, _shared.isPromise)(res)) res.catch((err)=>{
            handleError(err, instance, type);
        });
        return res;
    }
    const values = [];
    for(let i = 0; i < fn.length; i++)values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));
    return values;
}
function handleError(err, instance, type, throwInDev = true) {
    const contextVNode = instance ? instance.vnode : null;
    if (instance) {
        let cur = instance.parent;
        // the exposed instance is the render proxy to keep it consistent with 2.x
        const exposedInstance = instance.proxy;
        // in production the hook receives only the error code
        const errorInfo = (0, ErrorTypeStrings[type]);
        while(cur){
            const errorCapturedHooks = cur.ec;
            if (errorCapturedHooks) for(let i = 0; i < errorCapturedHooks.length; i++){
                if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) return;
            }
            cur = cur.parent;
        }
        // app-level handling
        const appErrorHandler = instance.appContext.config.errorHandler;
        if (appErrorHandler) {
            callWithErrorHandling(appErrorHandler, null, 10 /* ErrorCodes.APP_ERROR_HANDLER */ , [
                err,
                exposedInstance,
                errorInfo
            ]);
            return;
        }
    }
    logError(err, type, contextVNode, throwInDev);
}
function logError(err, type, contextVNode, throwInDev = true) {
    {
        const info = ErrorTypeStrings[type];
        if (contextVNode) pushWarningContext(contextVNode);
        warn(`Unhandled error${info ? ` during execution of ${info}` : ``}`);
        if (contextVNode) popWarningContext();
        // crash in dev by default so it's more noticeable
        if (throwInDev) throw err;
        else console.error(err);
    }
}
let isFlushing = false;
let isFlushPending = false;
const queue = [];
let flushIndex = 0;
const pendingPostFlushCbs = [];
let activePostFlushCbs = null;
let postFlushIndex = 0;
const resolvedPromise = /*#__PURE__*/ Promise.resolve();
let currentFlushPromise = null;
const RECURSION_LIMIT = 100;
function nextTick(fn) {
    const p = currentFlushPromise || resolvedPromise;
    return fn ? p.then(this ? fn.bind(this) : fn) : p;
}
// #2768
// Use binary-search to find a suitable position in the queue,
// so that the queue maintains the increasing order of job's id,
// which can prevent the job from being skipped and also can avoid repeated patching.
function findInsertionIndex(id) {
    // the start index should be `flushIndex + 1`
    let start = flushIndex + 1;
    let end = queue.length;
    while(start < end){
        const middle = start + end >>> 1;
        const middleJobId = getId(queue[middle]);
        middleJobId < id ? start = middle + 1 : end = middle;
    }
    return start;
}
function queueJob(job) {
    // the dedupe search uses the startIndex argument of Array.includes()
    // by default the search index includes the current job that is being run
    // so it cannot recursively trigger itself again.
    // if the job is a watch() callback, the search will start with a +1 index to
    // allow it recursively trigger itself - it is the user's responsibility to
    // ensure it doesn't end up in an infinite loop.
    if (!queue.length || !queue.includes(job, isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex)) {
        if (job.id == null) queue.push(job);
        else queue.splice(findInsertionIndex(job.id), 0, job);
        queueFlush();
    }
}
function queueFlush() {
    if (!isFlushing && !isFlushPending) {
        isFlushPending = true;
        currentFlushPromise = resolvedPromise.then(flushJobs);
    }
}
function invalidateJob(job) {
    const i = queue.indexOf(job);
    if (i > flushIndex) queue.splice(i, 1);
}
function queuePostFlushCb(cb) {
    if (!(0, _shared.isArray)(cb)) {
        if (!activePostFlushCbs || !activePostFlushCbs.includes(cb, cb.allowRecurse ? postFlushIndex + 1 : postFlushIndex)) pendingPostFlushCbs.push(cb);
    } else // if cb is an array, it is a component lifecycle hook which can only be
    // triggered by a job, which is already deduped in the main queue, so
    // we can skip duplicate check here to improve perf
    pendingPostFlushCbs.push(...cb);
    queueFlush();
}
function flushPreFlushCbs(seen, // if currently flushing, skip the current job itself
i = isFlushing ? flushIndex + 1 : 0) {
    seen = seen || new Map();
    for(; i < queue.length; i++){
        const cb = queue[i];
        if (cb && cb.pre) {
            if (checkRecursiveUpdates(seen, cb)) continue;
            queue.splice(i, 1);
            i--;
            cb();
        }
    }
}
function flushPostFlushCbs(seen) {
    if (pendingPostFlushCbs.length) {
        const deduped = [
            ...new Set(pendingPostFlushCbs)
        ];
        pendingPostFlushCbs.length = 0;
        // #1947 already has active queue, nested flushPostFlushCbs call
        if (activePostFlushCbs) {
            activePostFlushCbs.push(...deduped);
            return;
        }
        activePostFlushCbs = deduped;
        seen = seen || new Map();
        activePostFlushCbs.sort((a, b)=>getId(a) - getId(b));
        for(postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++){
            if (checkRecursiveUpdates(seen, activePostFlushCbs[postFlushIndex])) continue;
            activePostFlushCbs[postFlushIndex]();
        }
        activePostFlushCbs = null;
        postFlushIndex = 0;
    }
}
const getId = (job)=>job.id == null ? Infinity : job.id;
const comparator = (a, b)=>{
    const diff = getId(a) - getId(b);
    if (diff === 0) {
        if (a.pre && !b.pre) return -1;
        if (b.pre && !a.pre) return 1;
    }
    return diff;
};
function flushJobs(seen) {
    isFlushPending = false;
    isFlushing = true;
    seen = seen || new Map();
    // Sort queue before flush.
    // This ensures that:
    // 1. Components are updated from parent to child. (because parent is always
    //    created before the child so its render effect will have smaller
    //    priority number)
    // 2. If a component is unmounted during a parent component's update,
    //    its update can be skipped.
    queue.sort(comparator);
    // conditional usage of checkRecursiveUpdate must be determined out of
    // try ... catch block since Rollup by default de-optimizes treeshaking
    // inside try-catch. This can leave all warning code unshaked. Although
    // they would get eventually shaken by a minifier like terser, some minifiers
    // would fail to do that (e.g. https://github.com/evanw/esbuild/issues/1610)
    const check = (job)=>checkRecursiveUpdates(seen, job);
    try {
        for(flushIndex = 0; flushIndex < queue.length; flushIndex++){
            const job = queue[flushIndex];
            if (job && job.active !== false) {
                if (check(job)) continue;
                // console.log(`running:`, job.id)
                callWithErrorHandling(job, null, 14 /* ErrorCodes.SCHEDULER */ );
            }
        }
    } finally{
        flushIndex = 0;
        queue.length = 0;
        flushPostFlushCbs(seen);
        isFlushing = false;
        currentFlushPromise = null;
        // some postFlushCb queued jobs!
        // keep flushing until it drains.
        if (queue.length || pendingPostFlushCbs.length) flushJobs(seen);
    }
}
function checkRecursiveUpdates(seen, fn) {
    if (!seen.has(fn)) seen.set(fn, 1);
    else {
        const count = seen.get(fn);
        if (count > RECURSION_LIMIT) {
            const instance = fn.ownerInstance;
            const componentName = instance && getComponentName(instance.type);
            warn(`Maximum recursive updates exceeded${componentName ? ` in component <${componentName}>` : ``}. ` + `This means you have a reactive effect that is mutating its own ` + `dependencies and thus recursively triggering itself. Possible sources ` + `include component template, render function, updated hook or ` + `watcher source function.`);
            return true;
        } else seen.set(fn, count + 1);
    }
}
/* eslint-disable no-restricted-globals */ let isHmrUpdating = false;
const hmrDirtyComponents = new Set();
(0, _shared.getGlobalThis)().__VUE_HMR_RUNTIME__ = {
    createRecord: tryWrap(createRecord),
    rerender: tryWrap(rerender),
    reload: tryWrap(reload)
};
const map = new Map();
function registerHMR(instance) {
    const id = instance.type.__hmrId;
    let record = map.get(id);
    if (!record) {
        createRecord(id, instance.type);
        record = map.get(id);
    }
    record.instances.add(instance);
}
function unregisterHMR(instance) {
    map.get(instance.type.__hmrId).instances.delete(instance);
}
function createRecord(id, initialDef) {
    if (map.has(id)) return false;
    map.set(id, {
        initialDef: normalizeClassComponent(initialDef),
        instances: new Set()
    });
    return true;
}
function normalizeClassComponent(component) {
    return isClassComponent(component) ? component.__vccOpts : component;
}
function rerender(id, newRender) {
    const record = map.get(id);
    if (!record) return;
    // update initial record (for not-yet-rendered component)
    record.initialDef.render = newRender;
    [
        ...record.instances
    ].forEach((instance)=>{
        if (newRender) {
            instance.render = newRender;
            normalizeClassComponent(instance.type).render = newRender;
        }
        instance.renderCache = [];
        // this flag forces child components with slot content to update
        isHmrUpdating = true;
        instance.update();
        isHmrUpdating = false;
    });
}
function reload(id, newComp) {
    const record = map.get(id);
    if (!record) return;
    newComp = normalizeClassComponent(newComp);
    // update initial def (for not-yet-rendered components)
    updateComponentDef(record.initialDef, newComp);
    // create a snapshot which avoids the set being mutated during updates
    const instances = [
        ...record.instances
    ];
    for (const instance of instances){
        const oldComp = normalizeClassComponent(instance.type);
        if (!hmrDirtyComponents.has(oldComp)) {
            // 1. Update existing comp definition to match new one
            if (oldComp !== record.initialDef) updateComponentDef(oldComp, newComp);
            // 2. mark definition dirty. This forces the renderer to replace the
            // component on patch.
            hmrDirtyComponents.add(oldComp);
        }
        // 3. invalidate options resolution cache
        instance.appContext.optionsCache.delete(instance.type);
        // 4. actually update
        if (instance.ceReload) {
            // custom element
            hmrDirtyComponents.add(oldComp);
            instance.ceReload(newComp.styles);
            hmrDirtyComponents.delete(oldComp);
        } else if (instance.parent) // 4. Force the parent instance to re-render. This will cause all updated
        // components to be unmounted and re-mounted. Queue the update so that we
        // don't end up forcing the same parent to re-render multiple times.
        queueJob(instance.parent.update);
        else if (instance.appContext.reload) // root instance mounted via createApp() has a reload method
        instance.appContext.reload();
        else if (typeof window !== "undefined") // root instance inside tree created via raw render(). Force reload.
        window.location.reload();
        else console.warn("[HMR] Root or manually mounted instance modified. Full reload required.");
    }
    // 5. make sure to cleanup dirty hmr components after update
    queuePostFlushCb(()=>{
        for (const instance of instances)hmrDirtyComponents.delete(normalizeClassComponent(instance.type));
    });
}
function updateComponentDef(oldComp, newComp) {
    (0, _shared.extend)(oldComp, newComp);
    for(const key in oldComp)if (key !== "__file" && !(key in newComp)) delete oldComp[key];
}
function tryWrap(fn) {
    return (id, arg)=>{
        try {
            return fn(id, arg);
        } catch (e) {
            console.error(e);
            console.warn(`[HMR] Something went wrong during Vue component hot-reload. ` + `Full reload required.`);
        }
    };
}
let devtools;
let buffer = [];
let devtoolsNotInstalled = false;
function emit$1(event, ...args) {
    if (devtools) devtools.emit(event, ...args);
    else if (!devtoolsNotInstalled) buffer.push({
        event,
        args
    });
}
function setDevtoolsHook(hook, target) {
    var _a, _b;
    devtools = hook;
    if (devtools) {
        devtools.enabled = true;
        buffer.forEach(({ event , args  })=>devtools.emit(event, ...args));
        buffer = [];
    } else if (// handle late devtools injection - only do this if we are in an actual
    // browser environment to avoid the timer handle stalling test runner exit
    // (#4815)
    typeof window !== "undefined" && // some envs mock window but not fully
    window.HTMLElement && // also exclude jsdom
    !((_b = (_a = window.navigator) === null || _a === void 0 ? void 0 : _a.userAgent) === null || _b === void 0 ? void 0 : _b.includes("jsdom"))) {
        const replay = target.__VUE_DEVTOOLS_HOOK_REPLAY__ = target.__VUE_DEVTOOLS_HOOK_REPLAY__ || [];
        replay.push((newHook)=>{
            setDevtoolsHook(newHook, target);
        });
        // clear buffer after 3s - the user probably doesn't have devtools installed
        // at all, and keeping the buffer will cause memory leaks (#4738)
        setTimeout(()=>{
            if (!devtools) {
                target.__VUE_DEVTOOLS_HOOK_REPLAY__ = null;
                devtoolsNotInstalled = true;
                buffer = [];
            }
        }, 3000);
    } else {
        // non-browser env, assume not installed
        devtoolsNotInstalled = true;
        buffer = [];
    }
}
function devtoolsInitApp(app, version) {
    emit$1("app:init" /* DevtoolsHooks.APP_INIT */ , app, version, {
        Fragment,
        Text,
        Comment,
        Static
    });
}
function devtoolsUnmountApp(app) {
    emit$1("app:unmount" /* DevtoolsHooks.APP_UNMOUNT */ , app);
}
const devtoolsComponentAdded = /*#__PURE__*/ createDevtoolsComponentHook("component:added" /* DevtoolsHooks.COMPONENT_ADDED */ );
const devtoolsComponentUpdated = /*#__PURE__*/ createDevtoolsComponentHook("component:updated" /* DevtoolsHooks.COMPONENT_UPDATED */ );
const _devtoolsComponentRemoved = /*#__PURE__*/ createDevtoolsComponentHook("component:removed" /* DevtoolsHooks.COMPONENT_REMOVED */ );
const devtoolsComponentRemoved = (component)=>{
    if (devtools && typeof devtools.cleanupBuffer === "function" && // remove the component if it wasn't buffered
    !devtools.cleanupBuffer(component)) _devtoolsComponentRemoved(component);
};
function createDevtoolsComponentHook(hook) {
    return (component)=>{
        emit$1(hook, component.appContext.app, component.uid, component.parent ? component.parent.uid : undefined, component);
    };
}
const devtoolsPerfStart = /*#__PURE__*/ createDevtoolsPerformanceHook("perf:start" /* DevtoolsHooks.PERFORMANCE_START */ );
const devtoolsPerfEnd = /*#__PURE__*/ createDevtoolsPerformanceHook("perf:end" /* DevtoolsHooks.PERFORMANCE_END */ );
function createDevtoolsPerformanceHook(hook) {
    return (component, type, time)=>{
        emit$1(hook, component.appContext.app, component.uid, component, type, time);
    };
}
function devtoolsComponentEmit(component, event, params) {
    emit$1("component:emit" /* DevtoolsHooks.COMPONENT_EMIT */ , component.appContext.app, component, event, params);
}
function emit(instance, event, ...rawArgs) {
    if (instance.isUnmounted) return;
    const props = instance.vnode.props || (0, _shared.EMPTY_OBJ);
    {
        const { emitsOptions , propsOptions: [propsOptions]  } = instance;
        if (emitsOptions) {
            if (!(event in emitsOptions) && true) {
                if (!propsOptions || !((0, _shared.toHandlerKey)(event) in propsOptions)) warn(`Component emitted event "${event}" but it is neither declared in ` + `the emits option nor as an "${(0, _shared.toHandlerKey)(event)}" prop.`);
            } else {
                const validator = emitsOptions[event];
                if ((0, _shared.isFunction)(validator)) {
                    const isValid = validator(...rawArgs);
                    if (!isValid) warn(`Invalid event arguments: event validation failed for event "${event}".`);
                }
            }
        }
    }
    let args = rawArgs;
    const isModelListener = event.startsWith("update:");
    // for v-model update:xxx events, apply modifiers on args
    const modelArg = isModelListener && event.slice(7);
    if (modelArg && modelArg in props) {
        const modifiersKey = `${modelArg === "modelValue" ? "model" : modelArg}Modifiers`;
        const { number , trim  } = props[modifiersKey] || (0, _shared.EMPTY_OBJ);
        if (trim) args = rawArgs.map((a)=>(0, _shared.isString)(a) ? a.trim() : a);
        if (number) args = rawArgs.map((0, _shared.looseToNumber));
    }
    devtoolsComponentEmit(instance, event, args);
    {
        const lowerCaseEvent = event.toLowerCase();
        if (lowerCaseEvent !== event && props[(0, _shared.toHandlerKey)(lowerCaseEvent)]) warn(`Event "${lowerCaseEvent}" is emitted in component ` + `${formatComponentName(instance, instance.type)} but the handler is registered for "${event}". ` + `Note that HTML attributes are case-insensitive and you cannot use ` + `v-on to listen to camelCase events when using in-DOM templates. ` + `You should probably use "${(0, _shared.hyphenate)(event)}" instead of "${event}".`);
    }
    let handlerName;
    let handler = props[handlerName = (0, _shared.toHandlerKey)(event)] || // also try camelCase event handler (#2249)
    props[handlerName = (0, _shared.toHandlerKey)((0, _shared.camelize)(event))];
    // for v-model update:xxx events, also trigger kebab-case equivalent
    // for props passed via kebab-case
    if (!handler && isModelListener) handler = props[handlerName = (0, _shared.toHandlerKey)((0, _shared.hyphenate)(event))];
    if (handler) callWithAsyncErrorHandling(handler, instance, 6 /* ErrorCodes.COMPONENT_EVENT_HANDLER */ , args);
    const onceHandler = props[handlerName + `Once`];
    if (onceHandler) {
        if (!instance.emitted) instance.emitted = {};
        else if (instance.emitted[handlerName]) return;
        instance.emitted[handlerName] = true;
        callWithAsyncErrorHandling(onceHandler, instance, 6 /* ErrorCodes.COMPONENT_EVENT_HANDLER */ , args);
    }
}
function normalizeEmitsOptions(comp, appContext, asMixin = false) {
    const cache = appContext.emitsCache;
    const cached = cache.get(comp);
    if (cached !== undefined) return cached;
    const raw = comp.emits;
    let normalized = {};
    // apply mixin/extends props
    let hasExtends = false;
    if (__VUE_OPTIONS_API__ && !(0, _shared.isFunction)(comp)) {
        const extendEmits = (raw)=>{
            const normalizedFromExtend = normalizeEmitsOptions(raw, appContext, true);
            if (normalizedFromExtend) {
                hasExtends = true;
                (0, _shared.extend)(normalized, normalizedFromExtend);
            }
        };
        if (!asMixin && appContext.mixins.length) appContext.mixins.forEach(extendEmits);
        if (comp.extends) extendEmits(comp.extends);
        if (comp.mixins) comp.mixins.forEach(extendEmits);
    }
    if (!raw && !hasExtends) {
        if ((0, _shared.isObject)(comp)) cache.set(comp, null);
        return null;
    }
    if ((0, _shared.isArray)(raw)) raw.forEach((key)=>normalized[key] = null);
    else (0, _shared.extend)(normalized, raw);
    if ((0, _shared.isObject)(comp)) cache.set(comp, normalized);
    return normalized;
}
// Check if an incoming prop key is a declared emit event listener.
// e.g. With `emits: { click: null }`, props named `onClick` and `onclick` are
// both considered matched listeners.
function isEmitListener(options, key) {
    if (!options || !(0, _shared.isOn)(key)) return false;
    key = key.slice(2).replace(/Once$/, "");
    return (0, _shared.hasOwn)(options, key[0].toLowerCase() + key.slice(1)) || (0, _shared.hasOwn)(options, (0, _shared.hyphenate)(key)) || (0, _shared.hasOwn)(options, key);
}
/**
 * mark the current rendering instance for asset resolution (e.g.
 * resolveComponent, resolveDirective) during render
 */ let currentRenderingInstance = null;
let currentScopeId = null;
/**
 * Note: rendering calls maybe nested. The function returns the parent rendering
 * instance if present, which should be restored after the render is done:
 *
 * ```js
 * const prev = setCurrentRenderingInstance(i)
 * // ...render
 * setCurrentRenderingInstance(prev)
 * ```
 */ function setCurrentRenderingInstance(instance) {
    const prev = currentRenderingInstance;
    currentRenderingInstance = instance;
    currentScopeId = instance && instance.type.__scopeId || null;
    return prev;
}
/**
 * Set scope id when creating hoisted vnodes.
 * @private compiler helper
 */ function pushScopeId(id) {
    currentScopeId = id;
}
/**
 * Technically we no longer need this after 3.0.8 but we need to keep the same
 * API for backwards compat w/ code generated by compilers.
 * @private
 */ function popScopeId() {
    currentScopeId = null;
}
/**
 * Only for backwards compat
 * @private
 */ const withScopeId = (_id)=>withCtx;
/**
 * Wrap a slot function to memoize current rendering instance
 * @private compiler helper
 */ function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot // false only
) {
    if (!ctx) return fn;
    // already normalized
    if (fn._n) return fn;
    const renderFnWithContext = (...args)=>{
        // If a user calls a compiled slot inside a template expression (#1745), it
        // can mess up block tracking, so by default we disable block tracking and
        // force bail out when invoking a compiled slot (indicated by the ._d flag).
        // This isn't necessary if rendering a compiled `<slot>`, so we flip the
        // ._d flag off when invoking the wrapped fn inside `renderSlot`.
        if (renderFnWithContext._d) setBlockTracking(-1);
        const prevInstance = setCurrentRenderingInstance(ctx);
        let res;
        try {
            res = fn(...args);
        } finally{
            setCurrentRenderingInstance(prevInstance);
            if (renderFnWithContext._d) setBlockTracking(1);
        }
        devtoolsComponentUpdated(ctx);
        return res;
    };
    // mark normalized to avoid duplicated wrapping
    renderFnWithContext._n = true;
    // mark this as compiled by default
    // this is used in vnode.ts -> normalizeChildren() to set the slot
    // rendering flag.
    renderFnWithContext._c = true;
    // disable block tracking by default
    renderFnWithContext._d = true;
    return renderFnWithContext;
}
/**
 * dev only flag to track whether $attrs was used during render.
 * If $attrs was used during render then the warning for failed attrs
 * fallthrough can be suppressed.
 */ let accessedAttrs = false;
function markAttrsAccessed() {
    accessedAttrs = true;
}
function renderComponentRoot(instance) {
    const { type: Component , vnode , proxy , withProxy , props , propsOptions: [propsOptions] , slots , attrs , emit , render , renderCache , data , setupState , ctx , inheritAttrs  } = instance;
    let result;
    let fallthroughAttrs;
    const prev = setCurrentRenderingInstance(instance);
    accessedAttrs = false;
    try {
        if (vnode.shapeFlag & 4 /* ShapeFlags.STATEFUL_COMPONENT */ ) {
            // withProxy is a proxy with a different `has` trap only for
            // runtime-compiled render functions using `with` block.
            const proxyToUse = withProxy || proxy;
            result = normalizeVNode(render.call(proxyToUse, proxyToUse, renderCache, props, setupState, data, ctx));
            fallthroughAttrs = attrs;
        } else {
            // functional
            const render = Component;
            // in dev, mark attrs accessed if optional props (attrs === props)
            if (attrs === props) markAttrsAccessed();
            result = normalizeVNode(render.length > 1 ? render(props, {
                get attrs () {
                    markAttrsAccessed();
                    return attrs;
                },
                slots,
                emit
            }) : render(props, null));
            fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
        }
    } catch (err) {
        blockStack.length = 0;
        handleError(err, instance, 1 /* ErrorCodes.RENDER_FUNCTION */ );
        result = createVNode(Comment);
    }
    // attr merging
    // in dev mode, comments are preserved, and it's possible for a template
    // to have comments along side the root element which makes it a fragment
    let root = result;
    let setRoot = undefined;
    if (result.patchFlag > 0 && result.patchFlag & 2048 /* PatchFlags.DEV_ROOT_FRAGMENT */ ) [root, setRoot] = getChildRoot(result);
    if (fallthroughAttrs && inheritAttrs !== false) {
        const keys = Object.keys(fallthroughAttrs);
        const { shapeFlag  } = root;
        if (keys.length) {
            if (shapeFlag & 7 /* ShapeFlags.COMPONENT */ ) {
                if (propsOptions && keys.some((0, _shared.isModelListener))) // If a v-model listener (onUpdate:xxx) has a corresponding declared
                // prop, it indicates this component expects to handle v-model and
                // it should not fallthrough.
                // related: #1543, #1643, #1989
                fallthroughAttrs = filterModelListeners(fallthroughAttrs, propsOptions);
                root = cloneVNode(root, fallthroughAttrs);
            } else if (!accessedAttrs && root.type !== Comment) {
                const allAttrs = Object.keys(attrs);
                const eventAttrs = [];
                const extraAttrs = [];
                for(let i = 0, l = allAttrs.length; i < l; i++){
                    const key = allAttrs[i];
                    if ((0, _shared.isOn)(key)) // ignore v-model handlers when they fail to fallthrough
                    {
                        if (!(0, _shared.isModelListener)(key)) // remove `on`, lowercase first letter to reflect event casing
                        // accurately
                        eventAttrs.push(key[2].toLowerCase() + key.slice(3));
                    } else extraAttrs.push(key);
                }
                if (extraAttrs.length) warn(`Extraneous non-props attributes (` + `${extraAttrs.join(", ")}) ` + `were passed to component but could not be automatically inherited ` + `because component renders fragment or text root nodes.`);
                if (eventAttrs.length) warn(`Extraneous non-emits event listeners (` + `${eventAttrs.join(", ")}) ` + `were passed to component but could not be automatically inherited ` + `because component renders fragment or text root nodes. ` + `If the listener is intended to be a component custom event listener only, ` + `declare it using the "emits" option.`);
            }
        }
    }
    // inherit directives
    if (vnode.dirs) {
        if (!isElementRoot(root)) warn(`Runtime directive used on component with non-element root node. ` + `The directives will not function as intended.`);
        // clone before mutating since the root may be a hoisted vnode
        root = cloneVNode(root);
        root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
    }
    // inherit transition data
    if (vnode.transition) {
        if (!isElementRoot(root)) warn(`Component inside <Transition> renders non-element root node ` + `that cannot be animated.`);
        root.transition = vnode.transition;
    }
    if (setRoot) setRoot(root);
    else result = root;
    setCurrentRenderingInstance(prev);
    return result;
}
/**
 * dev only
 * In dev mode, template root level comments are rendered, which turns the
 * template into a fragment root, but we need to locate the single element
 * root for attrs and scope id processing.
 */ const getChildRoot = (vnode)=>{
    const rawChildren = vnode.children;
    const dynamicChildren = vnode.dynamicChildren;
    const childRoot = filterSingleRoot(rawChildren);
    if (!childRoot) return [
        vnode,
        undefined
    ];
    const index = rawChildren.indexOf(childRoot);
    const dynamicIndex = dynamicChildren ? dynamicChildren.indexOf(childRoot) : -1;
    const setRoot = (updatedRoot)=>{
        rawChildren[index] = updatedRoot;
        if (dynamicChildren) {
            if (dynamicIndex > -1) dynamicChildren[dynamicIndex] = updatedRoot;
            else if (updatedRoot.patchFlag > 0) vnode.dynamicChildren = [
                ...dynamicChildren,
                updatedRoot
            ];
        }
    };
    return [
        normalizeVNode(childRoot),
        setRoot
    ];
};
function filterSingleRoot(children) {
    let singleRoot;
    for(let i = 0; i < children.length; i++){
        const child = children[i];
        if (isVNode(child)) // ignore user comment
        {
            if (child.type !== Comment || child.children === "v-if") {
                if (singleRoot) // has more than 1 non-comment child, return now
                return;
                else singleRoot = child;
            }
        } else return;
    }
    return singleRoot;
}
const getFunctionalFallthrough = (attrs)=>{
    let res;
    for(const key in attrs)if (key === "class" || key === "style" || (0, _shared.isOn)(key)) (res || (res = {}))[key] = attrs[key];
    return res;
};
const filterModelListeners = (attrs, props)=>{
    const res = {};
    for(const key in attrs)if (!(0, _shared.isModelListener)(key) || !(key.slice(9) in props)) res[key] = attrs[key];
    return res;
};
const isElementRoot = (vnode)=>{
    return vnode.shapeFlag & 7 /* ShapeFlags.ELEMENT */  || vnode.type === Comment // potential v-if branch switch
    ;
};
function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
    const { props: prevProps , children: prevChildren , component  } = prevVNode;
    const { props: nextProps , children: nextChildren , patchFlag  } = nextVNode;
    const emits = component.emitsOptions;
    // Parent component's render function was hot-updated. Since this may have
    // caused the child component's slots content to have changed, we need to
    // force the child to update as well.
    if ((prevChildren || nextChildren) && isHmrUpdating) return true;
    // force child update for runtime directive or transition on component vnode.
    if (nextVNode.dirs || nextVNode.transition) return true;
    if (optimized && patchFlag >= 0) {
        if (patchFlag & 1024 /* PatchFlags.DYNAMIC_SLOTS */ ) // slot content that references values that might have changed,
        // e.g. in a v-for
        return true;
        if (patchFlag & 16 /* PatchFlags.FULL_PROPS */ ) {
            if (!prevProps) return !!nextProps;
            // presence of this flag indicates props are always non-null
            return hasPropsChanged(prevProps, nextProps, emits);
        } else if (patchFlag & 8 /* PatchFlags.PROPS */ ) {
            const dynamicProps = nextVNode.dynamicProps;
            for(let i = 0; i < dynamicProps.length; i++){
                const key = dynamicProps[i];
                if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) return true;
            }
        }
    } else {
        // this path is only taken by manually written render functions
        // so presence of any children leads to a forced update
        if (prevChildren || nextChildren) {
            if (!nextChildren || !nextChildren.$stable) return true;
        }
        if (prevProps === nextProps) return false;
        if (!prevProps) return !!nextProps;
        if (!nextProps) return true;
        return hasPropsChanged(prevProps, nextProps, emits);
    }
    return false;
}
function hasPropsChanged(prevProps, nextProps, emitsOptions) {
    const nextKeys = Object.keys(nextProps);
    if (nextKeys.length !== Object.keys(prevProps).length) return true;
    for(let i = 0; i < nextKeys.length; i++){
        const key = nextKeys[i];
        if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) return true;
    }
    return false;
}
function updateHOCHostEl({ vnode , parent  }, el // HostNode
) {
    while(parent && parent.subTree === vnode){
        (vnode = parent.vnode).el = el;
        parent = parent.parent;
    }
}
const isSuspense = (type)=>type.__isSuspense;
// Suspense exposes a component-like API, and is treated like a component
// in the compiler, but internally it's a special built-in type that hooks
// directly into the renderer.
const SuspenseImpl = {
    name: "Suspense",
    // In order to make Suspense tree-shakable, we need to avoid importing it
    // directly in the renderer. The renderer checks for the __isSuspense flag
    // on a vnode's type and calls the `process` method, passing in renderer
    // internals.
    __isSuspense: true,
    process (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, // platform-specific impl passed from renderer
    rendererInternals) {
        if (n1 == null) mountSuspense(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals);
        else patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, rendererInternals);
    },
    hydrate: hydrateSuspense,
    create: createSuspenseBoundary,
    normalize: normalizeSuspenseChildren
};
// Force-casted public typing for h and TSX props inference
const Suspense = SuspenseImpl;
function triggerEvent(vnode, name) {
    const eventListener = vnode.props && vnode.props[name];
    if ((0, _shared.isFunction)(eventListener)) eventListener();
}
function mountSuspense(vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals) {
    const { p: patch , o: { createElement  }  } = rendererInternals;
    const hiddenContainer = createElement("div");
    const suspense = vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals);
    // start mounting the content subtree in an off-dom container
    patch(null, suspense.pendingBranch = vnode.ssContent, hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds);
    // now check if we have encountered any async deps
    if (suspense.deps > 0) {
        // has async
        // invoke @fallback event
        triggerEvent(vnode, "onPending");
        triggerEvent(vnode, "onFallback");
        // mount the fallback tree
        patch(null, vnode.ssFallback, container, anchor, parentComponent, null, isSVG, slotScopeIds);
        setActiveBranch(suspense, vnode.ssFallback);
    } else // Suspense has no async deps. Just resolve.
    suspense.resolve();
}
function patchSuspense(n1, n2, container, anchor, parentComponent, isSVG, slotScopeIds, optimized, { p: patch , um: unmount , o: { createElement  }  }) {
    const suspense = n2.suspense = n1.suspense;
    suspense.vnode = n2;
    n2.el = n1.el;
    const newBranch = n2.ssContent;
    const newFallback = n2.ssFallback;
    const { activeBranch , pendingBranch , isInFallback , isHydrating  } = suspense;
    if (pendingBranch) {
        suspense.pendingBranch = newBranch;
        if (isSameVNodeType(newBranch, pendingBranch)) {
            // same root type but content may have changed.
            patch(pendingBranch, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
            if (suspense.deps <= 0) suspense.resolve();
            else if (isInFallback) {
                patch(activeBranch, newFallback, container, anchor, parentComponent, null, isSVG, slotScopeIds, optimized);
                setActiveBranch(suspense, newFallback);
            }
        } else {
            // toggled before pending tree is resolved
            suspense.pendingId++;
            if (isHydrating) {
                // if toggled before hydration is finished, the current DOM tree is
                // no longer valid. set it as the active branch so it will be unmounted
                // when resolved
                suspense.isHydrating = false;
                suspense.activeBranch = pendingBranch;
            } else unmount(pendingBranch, parentComponent, suspense);
            // increment pending ID. this is used to invalidate async callbacks
            // reset suspense state
            suspense.deps = 0;
            // discard effects from pending branch
            suspense.effects.length = 0;
            // discard previous container
            suspense.hiddenContainer = createElement("div");
            if (isInFallback) {
                // already in fallback state
                patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
                if (suspense.deps <= 0) suspense.resolve();
                else {
                    patch(activeBranch, newFallback, container, anchor, parentComponent, null, isSVG, slotScopeIds, optimized);
                    setActiveBranch(suspense, newFallback);
                }
            } else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
                // toggled "back" to current active branch
                patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);
                // force resolve
                suspense.resolve(true);
            } else {
                // switched to a 3rd branch
                patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
                if (suspense.deps <= 0) suspense.resolve();
            }
        }
    } else if (activeBranch && isSameVNodeType(newBranch, activeBranch)) {
        // root did not change, just normal patch
        patch(activeBranch, newBranch, container, anchor, parentComponent, suspense, isSVG, slotScopeIds, optimized);
        setActiveBranch(suspense, newBranch);
    } else {
        // root node toggled
        // invoke @pending event
        triggerEvent(n2, "onPending");
        // mount pending branch in off-dom container
        suspense.pendingBranch = newBranch;
        suspense.pendingId++;
        patch(null, newBranch, suspense.hiddenContainer, null, parentComponent, suspense, isSVG, slotScopeIds, optimized);
        if (suspense.deps <= 0) // incoming branch has no async deps, resolve now.
        suspense.resolve();
        else {
            const { timeout , pendingId  } = suspense;
            if (timeout > 0) setTimeout(()=>{
                if (suspense.pendingId === pendingId) suspense.fallback(newFallback);
            }, timeout);
            else if (timeout === 0) suspense.fallback(newFallback);
        }
    }
}
let hasWarned = false;
function createSuspenseBoundary(vnode, parent, parentComponent, container, hiddenContainer, anchor, isSVG, slotScopeIds, optimized, rendererInternals, isHydrating = false) {
    /* istanbul ignore if */ if (!hasWarned) {
        hasWarned = true;
        // @ts-ignore `console.info` cannot be null error
        console[console.info ? "info" : "log"](`<Suspense> is an experimental feature and its API will likely change.`);
    }
    const { p: patch , m: move , um: unmount , n: next , o: { parentNode , remove  }  } = rendererInternals;
    const timeout = vnode.props ? (0, _shared.toNumber)(vnode.props.timeout) : undefined;
    assertNumber(timeout, `Suspense timeout`);
    const suspense = {
        vnode,
        parent,
        parentComponent,
        isSVG,
        container,
        hiddenContainer,
        anchor,
        deps: 0,
        pendingId: 0,
        timeout: typeof timeout === "number" ? timeout : -1,
        activeBranch: null,
        pendingBranch: null,
        isInFallback: true,
        isHydrating,
        isUnmounted: false,
        effects: [],
        resolve (resume = false) {
            if (!resume && !suspense.pendingBranch) throw new Error(`suspense.resolve() is called without a pending branch.`);
            if (suspense.isUnmounted) throw new Error(`suspense.resolve() is called on an already unmounted suspense boundary.`);
            const { vnode , activeBranch , pendingBranch , pendingId , effects , parentComponent , container  } = suspense;
            if (suspense.isHydrating) suspense.isHydrating = false;
            else if (!resume) {
                const delayEnter = activeBranch && pendingBranch.transition && pendingBranch.transition.mode === "out-in";
                if (delayEnter) activeBranch.transition.afterLeave = ()=>{
                    if (pendingId === suspense.pendingId) move(pendingBranch, container, anchor, 0 /* MoveType.ENTER */ );
                };
                // this is initial anchor on mount
                let { anchor  } = suspense;
                // unmount current active tree
                if (activeBranch) {
                    // if the fallback tree was mounted, it may have been moved
                    // as part of a parent suspense. get the latest anchor for insertion
                    anchor = next(activeBranch);
                    unmount(activeBranch, parentComponent, suspense, true);
                }
                if (!delayEnter) // move content from off-dom container to actual container
                move(pendingBranch, container, anchor, 0 /* MoveType.ENTER */ );
            }
            setActiveBranch(suspense, pendingBranch);
            suspense.pendingBranch = null;
            suspense.isInFallback = false;
            // flush buffered effects
            // check if there is a pending parent suspense
            let parent = suspense.parent;
            let hasUnresolvedAncestor = false;
            while(parent){
                if (parent.pendingBranch) {
                    // found a pending parent suspense, merge buffered post jobs
                    // into that parent
                    parent.effects.push(...effects);
                    hasUnresolvedAncestor = true;
                    break;
                }
                parent = parent.parent;
            }
            // no pending parent suspense, flush all jobs
            if (!hasUnresolvedAncestor) queuePostFlushCb(effects);
            suspense.effects = [];
            // invoke @resolve event
            triggerEvent(vnode, "onResolve");
        },
        fallback (fallbackVNode) {
            if (!suspense.pendingBranch) return;
            const { vnode , activeBranch , parentComponent , container , isSVG  } = suspense;
            // invoke @fallback event
            triggerEvent(vnode, "onFallback");
            const anchor = next(activeBranch);
            const mountFallback = ()=>{
                if (!suspense.isInFallback) return;
                // mount the fallback tree
                patch(null, fallbackVNode, container, anchor, parentComponent, null, isSVG, slotScopeIds, optimized);
                setActiveBranch(suspense, fallbackVNode);
            };
            const delayEnter = fallbackVNode.transition && fallbackVNode.transition.mode === "out-in";
            if (delayEnter) activeBranch.transition.afterLeave = mountFallback;
            suspense.isInFallback = true;
            // unmount current active branch
            unmount(activeBranch, parentComponent, null, true // shouldRemove
            );
            if (!delayEnter) mountFallback();
        },
        move (container, anchor, type) {
            suspense.activeBranch && move(suspense.activeBranch, container, anchor, type);
            suspense.container = container;
        },
        next () {
            return suspense.activeBranch && next(suspense.activeBranch);
        },
        registerDep (instance, setupRenderEffect) {
            const isInPendingSuspense = !!suspense.pendingBranch;
            if (isInPendingSuspense) suspense.deps++;
            const hydratedEl = instance.vnode.el;
            instance.asyncDep.catch((err)=>{
                handleError(err, instance, 0 /* ErrorCodes.SETUP_FUNCTION */ );
            }).then((asyncSetupResult)=>{
                // retry when the setup() promise resolves.
                // component may have been unmounted before resolve.
                if (instance.isUnmounted || suspense.isUnmounted || suspense.pendingId !== instance.suspenseId) return;
                // retry from this component
                instance.asyncResolved = true;
                const { vnode  } = instance;
                pushWarningContext(vnode);
                handleSetupResult(instance, asyncSetupResult, false);
                if (hydratedEl) // vnode may have been replaced if an update happened before the
                // async dep is resolved.
                vnode.el = hydratedEl;
                const placeholder = !hydratedEl && instance.subTree.el;
                setupRenderEffect(instance, vnode, // component may have been moved before resolve.
                // if this is not a hydration, instance.subTree will be the comment
                // placeholder.
                parentNode(hydratedEl || instance.subTree.el), // anchor will not be used if this is hydration, so only need to
                // consider the comment placeholder case.
                hydratedEl ? null : next(instance.subTree), suspense, isSVG, optimized);
                if (placeholder) remove(placeholder);
                updateHOCHostEl(instance, vnode.el);
                popWarningContext();
                // only decrease deps count if suspense is not already resolved
                if (isInPendingSuspense && --suspense.deps === 0) suspense.resolve();
            });
        },
        unmount (parentSuspense, doRemove) {
            suspense.isUnmounted = true;
            if (suspense.activeBranch) unmount(suspense.activeBranch, parentComponent, parentSuspense, doRemove);
            if (suspense.pendingBranch) unmount(suspense.pendingBranch, parentComponent, parentSuspense, doRemove);
        }
    };
    return suspense;
}
function hydrateSuspense(node, vnode, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, rendererInternals, hydrateNode) {
    /* eslint-disable no-restricted-globals */ const suspense = vnode.suspense = createSuspenseBoundary(vnode, parentSuspense, parentComponent, node.parentNode, document.createElement("div"), null, isSVG, slotScopeIds, optimized, rendererInternals, true);
    // there are two possible scenarios for server-rendered suspense:
    // - success: ssr content should be fully resolved
    // - failure: ssr content should be the fallback branch.
    // however, on the client we don't really know if it has failed or not
    // attempt to hydrate the DOM assuming it has succeeded, but we still
    // need to construct a suspense boundary first
    const result = hydrateNode(node, suspense.pendingBranch = vnode.ssContent, parentComponent, suspense, slotScopeIds, optimized);
    if (suspense.deps === 0) suspense.resolve();
    return result;
/* eslint-enable no-restricted-globals */ }
function normalizeSuspenseChildren(vnode) {
    const { shapeFlag , children  } = vnode;
    const isSlotChildren = shapeFlag & 32 /* ShapeFlags.SLOTS_CHILDREN */ ;
    vnode.ssContent = normalizeSuspenseSlot(isSlotChildren ? children.default : children);
    vnode.ssFallback = isSlotChildren ? normalizeSuspenseSlot(children.fallback) : createVNode(Comment);
}
function normalizeSuspenseSlot(s) {
    let block;
    if ((0, _shared.isFunction)(s)) {
        const trackBlock = isBlockTreeEnabled && s._c;
        if (trackBlock) {
            // disableTracking: false
            // allow block tracking for compiled slots
            // (see ./componentRenderContext.ts)
            s._d = false;
            openBlock();
        }
        s = s();
        if (trackBlock) {
            s._d = true;
            block = currentBlock;
            closeBlock();
        }
    }
    if ((0, _shared.isArray)(s)) {
        const singleChild = filterSingleRoot(s);
        if (!singleChild) warn(`<Suspense> slots expect a single root node.`);
        s = singleChild;
    }
    s = normalizeVNode(s);
    if (block && !s.dynamicChildren) s.dynamicChildren = block.filter((c)=>c !== s);
    return s;
}
function queueEffectWithSuspense(fn, suspense) {
    if (suspense && suspense.pendingBranch) {
        if ((0, _shared.isArray)(fn)) suspense.effects.push(...fn);
        else suspense.effects.push(fn);
    } else queuePostFlushCb(fn);
}
function setActiveBranch(suspense, branch) {
    suspense.activeBranch = branch;
    const { vnode , parentComponent  } = suspense;
    const el = vnode.el = branch.el;
    // in case suspense is the root node of a component,
    // recursively update the HOC el
    if (parentComponent && parentComponent.subTree === vnode) {
        parentComponent.vnode.el = el;
        updateHOCHostEl(parentComponent, el);
    }
}
function provide(key, value) {
    if (!currentInstance) warn(`provide() can only be used inside setup().`);
    else {
        let provides = currentInstance.provides;
        // by default an instance inherits its parent's provides object
        // but when it needs to provide values of its own, it creates its
        // own provides object using parent provides object as prototype.
        // this way in `inject` we can simply look up injections from direct
        // parent and let the prototype chain do the work.
        const parentProvides = currentInstance.parent && currentInstance.parent.provides;
        if (parentProvides === provides) provides = currentInstance.provides = Object.create(parentProvides);
        // TS doesn't allow symbol as index type
        provides[key] = value;
    }
}
function inject(key, defaultValue, treatDefaultAsFactory = false) {
    // fallback to `currentRenderingInstance` so that this can be called in
    // a functional component
    const instance = currentInstance || currentRenderingInstance;
    if (instance) {
        // #2400
        // to support `app.use` plugins,
        // fallback to appContext's `provides` if the instance is at root
        const provides = instance.parent == null ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides;
        if (provides && key in provides) // TS doesn't allow symbol as index type
        return provides[key];
        else if (arguments.length > 1) return treatDefaultAsFactory && (0, _shared.isFunction)(defaultValue) ? defaultValue.call(instance.proxy) : defaultValue;
        else warn(`injection "${String(key)}" not found.`);
    } else warn(`inject() can only be used inside setup() or functional components.`);
}
// Simple effect.
function watchEffect(effect, options) {
    return doWatch(effect, null, options);
}
function watchPostEffect(effect, options) {
    return doWatch(effect, null, Object.assign(Object.assign({}, options), {
        flush: "post"
    }));
}
function watchSyncEffect(effect, options) {
    return doWatch(effect, null, Object.assign(Object.assign({}, options), {
        flush: "sync"
    }));
}
// initial value for watchers to trigger on undefined initial values
const INITIAL_WATCHER_VALUE = {};
// implementation
function watch(source, cb, options) {
    if (!(0, _shared.isFunction)(cb)) warn(`\`watch(fn, options?)\` signature has been moved to a separate API. ` + `Use \`watchEffect(fn, options?)\` instead. \`watch\` now only ` + `supports \`watch(source, cb, options?) signature.`);
    return doWatch(source, cb, options);
}
function doWatch(source, cb, { immediate , deep , flush , onTrack , onTrigger  } = (0, _shared.EMPTY_OBJ)) {
    if (!cb) {
        if (immediate !== undefined) warn(`watch() "immediate" option is only respected when using the ` + `watch(source, callback, options?) signature.`);
        if (deep !== undefined) warn(`watch() "deep" option is only respected when using the ` + `watch(source, callback, options?) signature.`);
    }
    const warnInvalidSource = (s)=>{
        warn(`Invalid watch source: `, s, `A watch source can only be a getter/effect function, a ref, ` + `a reactive object, or an array of these types.`);
    };
    const instance = (0, _reactivity.getCurrentScope)() === (currentInstance === null || currentInstance === void 0 ? void 0 : currentInstance.scope) ? currentInstance : null;
    // const instance = currentInstance
    let getter;
    let forceTrigger = false;
    let isMultiSource = false;
    if ((0, _reactivity.isRef)(source)) {
        getter = ()=>source.value;
        forceTrigger = (0, _reactivity.isShallow)(source);
    } else if ((0, _reactivity.isReactive)(source)) {
        getter = ()=>source;
        deep = true;
    } else if ((0, _shared.isArray)(source)) {
        isMultiSource = true;
        forceTrigger = source.some((s)=>(0, _reactivity.isReactive)(s) || (0, _reactivity.isShallow)(s));
        getter = ()=>source.map((s)=>{
                if ((0, _reactivity.isRef)(s)) return s.value;
                else if ((0, _reactivity.isReactive)(s)) return traverse(s);
                else if ((0, _shared.isFunction)(s)) return callWithErrorHandling(s, instance, 2 /* ErrorCodes.WATCH_GETTER */ );
                else warnInvalidSource(s);
            });
    } else if ((0, _shared.isFunction)(source)) {
        if (cb) // getter with cb
        getter = ()=>callWithErrorHandling(source, instance, 2 /* ErrorCodes.WATCH_GETTER */ );
        else // no cb -> simple effect
        getter = ()=>{
            if (instance && instance.isUnmounted) return;
            if (cleanup) cleanup();
            return callWithAsyncErrorHandling(source, instance, 3 /* ErrorCodes.WATCH_CALLBACK */ , [
                onCleanup
            ]);
        };
    } else {
        getter = (0, _shared.NOOP);
        warnInvalidSource(source);
    }
    if (cb && deep) {
        const baseGetter = getter;
        getter = ()=>traverse(baseGetter());
    }
    let cleanup;
    let onCleanup = (fn)=>{
        cleanup = effect.onStop = ()=>{
            callWithErrorHandling(fn, instance, 4 /* ErrorCodes.WATCH_CLEANUP */ );
        };
    };
    // in SSR there is no need to setup an actual effect, and it should be noop
    // unless it's eager or sync flush
    let ssrCleanup;
    if (isInSSRComponentSetup) {
        // we will also not call the invalidate callback (+ runner is not set up)
        onCleanup = (0, _shared.NOOP);
        if (!cb) getter();
        else if (immediate) callWithAsyncErrorHandling(cb, instance, 3 /* ErrorCodes.WATCH_CALLBACK */ , [
            getter(),
            isMultiSource ? [] : undefined,
            onCleanup
        ]);
        if (flush === "sync") {
            const ctx = useSSRContext();
            ssrCleanup = ctx.__watcherHandles || (ctx.__watcherHandles = []);
        } else return 0, _shared.NOOP;
    }
    let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
    const job = ()=>{
        if (!effect.active) return;
        if (cb) {
            // watch(source, cb)
            const newValue = effect.run();
            if (deep || forceTrigger || (isMultiSource ? newValue.some((v1, i)=>(0, _shared.hasChanged)(v1, oldValue[i])) : (0, _shared.hasChanged)(newValue, oldValue)) || false) {
                // cleanup before running cb again
                if (cleanup) cleanup();
                callWithAsyncErrorHandling(cb, instance, 3 /* ErrorCodes.WATCH_CALLBACK */ , [
                    newValue,
                    // pass undefined as the old value when it's changed for the first time
                    oldValue === INITIAL_WATCHER_VALUE ? undefined : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
                    onCleanup
                ]);
                oldValue = newValue;
            }
        } else // watchEffect
        effect.run();
    };
    // important: mark the job as a watcher callback so that scheduler knows
    // it is allowed to self-trigger (#1727)
    job.allowRecurse = !!cb;
    let scheduler;
    if (flush === "sync") scheduler = job; // the scheduler function gets called directly
    else if (flush === "post") scheduler = ()=>queuePostRenderEffect(job, instance && instance.suspense);
    else {
        // default: 'pre'
        job.pre = true;
        if (instance) job.id = instance.uid;
        scheduler = ()=>queueJob(job);
    }
    const effect = new (0, _reactivity.ReactiveEffect)(getter, scheduler);
    effect.onTrack = onTrack;
    effect.onTrigger = onTrigger;
    // initial run
    if (cb) {
        if (immediate) job();
        else oldValue = effect.run();
    } else if (flush === "post") queuePostRenderEffect(effect.run.bind(effect), instance && instance.suspense);
    else effect.run();
    const unwatch = ()=>{
        effect.stop();
        if (instance && instance.scope) (0, _shared.remove)(instance.scope.effects, effect);
    };
    if (ssrCleanup) ssrCleanup.push(unwatch);
    return unwatch;
}
// this.$watch
function instanceWatch(source, value, options) {
    const publicThis = this.proxy;
    const getter = (0, _shared.isString)(source) ? source.includes(".") ? createPathGetter(publicThis, source) : ()=>publicThis[source] : source.bind(publicThis, publicThis);
    let cb;
    if ((0, _shared.isFunction)(value)) cb = value;
    else {
        cb = value.handler;
        options = value;
    }
    const cur = currentInstance;
    setCurrentInstance(this);
    const res = doWatch(getter, cb.bind(publicThis), options);
    if (cur) setCurrentInstance(cur);
    else unsetCurrentInstance();
    return res;
}
function createPathGetter(ctx, path) {
    const segments = path.split(".");
    return ()=>{
        let cur = ctx;
        for(let i = 0; i < segments.length && cur; i++)cur = cur[segments[i]];
        return cur;
    };
}
function traverse(value, seen) {
    if (!(0, _shared.isObject)(value) || value["__v_skip" /* ReactiveFlags.SKIP */ ]) return value;
    seen = seen || new Set();
    if (seen.has(value)) return value;
    seen.add(value);
    if ((0, _reactivity.isRef)(value)) traverse(value.value, seen);
    else if ((0, _shared.isArray)(value)) for(let i = 0; i < value.length; i++)traverse(value[i], seen);
    else if ((0, _shared.isSet)(value) || (0, _shared.isMap)(value)) value.forEach((v1)=>{
        traverse(v1, seen);
    });
    else if ((0, _shared.isPlainObject)(value)) for(const key in value)traverse(value[key], seen);
    return value;
}
function useTransitionState() {
    const state = {
        isMounted: false,
        isLeaving: false,
        isUnmounting: false,
        leavingVNodes: new Map()
    };
    onMounted(()=>{
        state.isMounted = true;
    });
    onBeforeUnmount(()=>{
        state.isUnmounting = true;
    });
    return state;
}
const TransitionHookValidator = [
    Function,
    Array
];
const BaseTransitionImpl = {
    name: `BaseTransition`,
    props: {
        mode: String,
        appear: Boolean,
        persisted: Boolean,
        // enter
        onBeforeEnter: TransitionHookValidator,
        onEnter: TransitionHookValidator,
        onAfterEnter: TransitionHookValidator,
        onEnterCancelled: TransitionHookValidator,
        // leave
        onBeforeLeave: TransitionHookValidator,
        onLeave: TransitionHookValidator,
        onAfterLeave: TransitionHookValidator,
        onLeaveCancelled: TransitionHookValidator,
        // appear
        onBeforeAppear: TransitionHookValidator,
        onAppear: TransitionHookValidator,
        onAfterAppear: TransitionHookValidator,
        onAppearCancelled: TransitionHookValidator
    },
    setup (props, { slots  }) {
        const instance = getCurrentInstance();
        const state = useTransitionState();
        let prevTransitionKey;
        return ()=>{
            const children = slots.default && getTransitionRawChildren(slots.default(), true);
            if (!children || !children.length) return;
            let child = children[0];
            if (children.length > 1) {
                let hasFound = false;
                // locate first non-comment child
                for (const c of children)if (c.type !== Comment) {
                    if (hasFound) {
                        // warn more than one non-comment child
                        warn("<transition> can only be used on a single element or component. Use <transition-group> for lists.");
                        break;
                    }
                    child = c;
                    hasFound = true;
                }
            }
            // there's no need to track reactivity for these props so use the raw
            // props for a bit better perf
            const rawProps = (0, _reactivity.toRaw)(props);
            const { mode  } = rawProps;
            // check mode
            if (mode && mode !== "in-out" && mode !== "out-in" && mode !== "default") warn(`invalid <transition> mode: ${mode}`);
            if (state.isLeaving) return emptyPlaceholder(child);
            // in the case of <transition><keep-alive/></transition>, we need to
            // compare the type of the kept-alive children.
            const innerChild = getKeepAliveChild(child);
            if (!innerChild) return emptyPlaceholder(child);
            const enterHooks = resolveTransitionHooks(innerChild, rawProps, state, instance);
            setTransitionHooks(innerChild, enterHooks);
            const oldChild = instance.subTree;
            const oldInnerChild = oldChild && getKeepAliveChild(oldChild);
            let transitionKeyChanged = false;
            const { getTransitionKey  } = innerChild.type;
            if (getTransitionKey) {
                const key = getTransitionKey();
                if (prevTransitionKey === undefined) prevTransitionKey = key;
                else if (key !== prevTransitionKey) {
                    prevTransitionKey = key;
                    transitionKeyChanged = true;
                }
            }
            // handle mode
            if (oldInnerChild && oldInnerChild.type !== Comment && (!isSameVNodeType(innerChild, oldInnerChild) || transitionKeyChanged)) {
                const leavingHooks = resolveTransitionHooks(oldInnerChild, rawProps, state, instance);
                // update old tree's hooks in case of dynamic transition
                setTransitionHooks(oldInnerChild, leavingHooks);
                // switching between different views
                if (mode === "out-in") {
                    state.isLeaving = true;
                    // return placeholder node and queue update when leave finishes
                    leavingHooks.afterLeave = ()=>{
                        state.isLeaving = false;
                        // #6835
                        // it also needs to be updated when active is undefined
                        if (instance.update.active !== false) instance.update();
                    };
                    return emptyPlaceholder(child);
                } else if (mode === "in-out" && innerChild.type !== Comment) leavingHooks.delayLeave = (el, earlyRemove, delayedLeave)=>{
                    const leavingVNodesCache = getLeavingNodesForType(state, oldInnerChild);
                    leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
                    // early removal callback
                    el._leaveCb = ()=>{
                        earlyRemove();
                        el._leaveCb = undefined;
                        delete enterHooks.delayedLeave;
                    };
                    enterHooks.delayedLeave = delayedLeave;
                };
            }
            return child;
        };
    }
};
// export the public type for h/tsx inference
// also to avoid inline import() in generated d.ts files
const BaseTransition = BaseTransitionImpl;
function getLeavingNodesForType(state, vnode) {
    const { leavingVNodes  } = state;
    let leavingVNodesCache = leavingVNodes.get(vnode.type);
    if (!leavingVNodesCache) {
        leavingVNodesCache = Object.create(null);
        leavingVNodes.set(vnode.type, leavingVNodesCache);
    }
    return leavingVNodesCache;
}
// The transition hooks are attached to the vnode as vnode.transition
// and will be called at appropriate timing in the renderer.
function resolveTransitionHooks(vnode, props, state, instance) {
    const { appear , mode , persisted =false , onBeforeEnter , onEnter , onAfterEnter , onEnterCancelled , onBeforeLeave , onLeave , onAfterLeave , onLeaveCancelled , onBeforeAppear , onAppear , onAfterAppear , onAppearCancelled  } = props;
    const key = String(vnode.key);
    const leavingVNodesCache = getLeavingNodesForType(state, vnode);
    const callHook = (hook, args)=>{
        hook && callWithAsyncErrorHandling(hook, instance, 9 /* ErrorCodes.TRANSITION_HOOK */ , args);
    };
    const callAsyncHook = (hook, args)=>{
        const done = args[1];
        callHook(hook, args);
        if ((0, _shared.isArray)(hook)) {
            if (hook.every((hook)=>hook.length <= 1)) done();
        } else if (hook.length <= 1) done();
    };
    const hooks = {
        mode,
        persisted,
        beforeEnter (el) {
            let hook = onBeforeEnter;
            if (!state.isMounted) {
                if (appear) hook = onBeforeAppear || onBeforeEnter;
                else return;
            }
            // for same element (v-show)
            if (el._leaveCb) el._leaveCb(true);
            // for toggled element with same key (v-if)
            const leavingVNode = leavingVNodesCache[key];
            if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el._leaveCb) // force early removal (not cancelled)
            leavingVNode.el._leaveCb();
            callHook(hook, [
                el
            ]);
        },
        enter (el) {
            let hook = onEnter;
            let afterHook = onAfterEnter;
            let cancelHook = onEnterCancelled;
            if (!state.isMounted) {
                if (appear) {
                    hook = onAppear || onEnter;
                    afterHook = onAfterAppear || onAfterEnter;
                    cancelHook = onAppearCancelled || onEnterCancelled;
                } else return;
            }
            let called = false;
            const done = el._enterCb = (cancelled)=>{
                if (called) return;
                called = true;
                if (cancelled) callHook(cancelHook, [
                    el
                ]);
                else callHook(afterHook, [
                    el
                ]);
                if (hooks.delayedLeave) hooks.delayedLeave();
                el._enterCb = undefined;
            };
            if (hook) callAsyncHook(hook, [
                el,
                done
            ]);
            else done();
        },
        leave (el, remove) {
            const key = String(vnode.key);
            if (el._enterCb) el._enterCb(true);
            if (state.isUnmounting) return remove();
            callHook(onBeforeLeave, [
                el
            ]);
            let called = false;
            const done = el._leaveCb = (cancelled)=>{
                if (called) return;
                called = true;
                remove();
                if (cancelled) callHook(onLeaveCancelled, [
                    el
                ]);
                else callHook(onAfterLeave, [
                    el
                ]);
                el._leaveCb = undefined;
                if (leavingVNodesCache[key] === vnode) delete leavingVNodesCache[key];
            };
            leavingVNodesCache[key] = vnode;
            if (onLeave) callAsyncHook(onLeave, [
                el,
                done
            ]);
            else done();
        },
        clone (vnode) {
            return resolveTransitionHooks(vnode, props, state, instance);
        }
    };
    return hooks;
}
// the placeholder really only handles one special case: KeepAlive
// in the case of a KeepAlive in a leave phase we need to return a KeepAlive
// placeholder with empty content to avoid the KeepAlive instance from being
// unmounted.
function emptyPlaceholder(vnode) {
    if (isKeepAlive(vnode)) {
        vnode = cloneVNode(vnode);
        vnode.children = null;
        return vnode;
    }
}
function getKeepAliveChild(vnode) {
    return isKeepAlive(vnode) ? vnode.children ? vnode.children[0] : undefined : vnode;
}
function setTransitionHooks(vnode, hooks) {
    if (vnode.shapeFlag & 6 /* ShapeFlags.COMPONENT */  && vnode.component) setTransitionHooks(vnode.component.subTree, hooks);
    else if (vnode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) {
        vnode.ssContent.transition = hooks.clone(vnode.ssContent);
        vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
    } else vnode.transition = hooks;
}
function getTransitionRawChildren(children, keepComment = false, parentKey) {
    let ret = [];
    let keyedFragmentCount = 0;
    for(let i = 0; i < children.length; i++){
        let child = children[i];
        // #5360 inherit parent key in case of <template v-for>
        const key = parentKey == null ? child.key : String(parentKey) + String(child.key != null ? child.key : i);
        // handle fragment children case, e.g. v-for
        if (child.type === Fragment) {
            if (child.patchFlag & 128 /* PatchFlags.KEYED_FRAGMENT */ ) keyedFragmentCount++;
            ret = ret.concat(getTransitionRawChildren(child.children, keepComment, key));
        } else if (keepComment || child.type !== Comment) ret.push(key != null ? cloneVNode(child, {
            key
        }) : child);
    }
    // #1126 if a transition children list contains multiple sub fragments, these
    // fragments will be merged into a flat children array. Since each v-for
    // fragment may contain different static bindings inside, we need to de-op
    // these children to force full diffs to ensure correct behavior.
    if (keyedFragmentCount > 1) for(let i = 0; i < ret.length; i++)ret[i].patchFlag = -2 /* PatchFlags.BAIL */ ;
    return ret;
}
// implementation, close to no-op
function defineComponent(options) {
    return (0, _shared.isFunction)(options) ? {
        setup: options,
        name: options.name
    } : options;
}
const isAsyncWrapper = (i)=>!!i.type.__asyncLoader;
function defineAsyncComponent(source) {
    if ((0, _shared.isFunction)(source)) source = {
        loader: source
    };
    const { loader , loadingComponent , errorComponent , delay =200 , timeout , suspensible =true , onError: userOnError  } = source;
    let pendingRequest = null;
    let resolvedComp;
    let retries = 0;
    const retry = ()=>{
        retries++;
        pendingRequest = null;
        return load();
    };
    const load = ()=>{
        let thisRequest;
        return pendingRequest || (thisRequest = pendingRequest = loader().catch((err)=>{
            err = err instanceof Error ? err : new Error(String(err));
            if (userOnError) return new Promise((resolve, reject)=>{
                const userRetry = ()=>resolve(retry());
                const userFail = ()=>reject(err);
                userOnError(err, userRetry, userFail, retries + 1);
            });
            else throw err;
        }).then((comp)=>{
            if (thisRequest !== pendingRequest && pendingRequest) return pendingRequest;
            if (!comp) warn(`Async component loader resolved to undefined. ` + `If you are using retry(), make sure to return its return value.`);
            // interop module default
            if (comp && (comp.__esModule || comp[Symbol.toStringTag] === "Module")) comp = comp.default;
            if (comp && !(0, _shared.isObject)(comp) && !(0, _shared.isFunction)(comp)) throw new Error(`Invalid async component load result: ${comp}`);
            resolvedComp = comp;
            return comp;
        }));
    };
    return defineComponent({
        name: "AsyncComponentWrapper",
        __asyncLoader: load,
        get __asyncResolved () {
            return resolvedComp;
        },
        setup () {
            const instance = currentInstance;
            // already resolved
            if (resolvedComp) return ()=>createInnerComp(resolvedComp, instance);
            const onError = (err)=>{
                pendingRequest = null;
                handleError(err, instance, 13 /* ErrorCodes.ASYNC_COMPONENT_LOADER */ , !errorComponent /* do not throw in dev if user provided error component */ );
            };
            // suspense-controlled or SSR.
            if (suspensible && instance.suspense || isInSSRComponentSetup) return load().then((comp)=>{
                return ()=>createInnerComp(comp, instance);
            }).catch((err)=>{
                onError(err);
                return ()=>errorComponent ? createVNode(errorComponent, {
                        error: err
                    }) : null;
            });
            const loaded = (0, _reactivity.ref)(false);
            const error = (0, _reactivity.ref)();
            const delayed = (0, _reactivity.ref)(!!delay);
            if (delay) setTimeout(()=>{
                delayed.value = false;
            }, delay);
            if (timeout != null) setTimeout(()=>{
                if (!loaded.value && !error.value) {
                    const err = new Error(`Async component timed out after ${timeout}ms.`);
                    onError(err);
                    error.value = err;
                }
            }, timeout);
            load().then(()=>{
                loaded.value = true;
                if (instance.parent && isKeepAlive(instance.parent.vnode)) // parent is keep-alive, force update so the loaded component's
                // name is taken into account
                queueJob(instance.parent.update);
            }).catch((err)=>{
                onError(err);
                error.value = err;
            });
            return ()=>{
                if (loaded.value && resolvedComp) return createInnerComp(resolvedComp, instance);
                else if (error.value && errorComponent) return createVNode(errorComponent, {
                    error: error.value
                });
                else if (loadingComponent && !delayed.value) return createVNode(loadingComponent);
            };
        }
    });
}
function createInnerComp(comp, parent) {
    const { ref , props , children , ce  } = parent.vnode;
    const vnode = createVNode(comp, props, children);
    // ensure inner component inherits the async wrapper's ref owner
    vnode.ref = ref;
    // pass the custom element callback on to the inner comp
    // and remove it from the async wrapper
    vnode.ce = ce;
    delete parent.vnode.ce;
    return vnode;
}
const isKeepAlive = (vnode)=>vnode.type.__isKeepAlive;
const KeepAliveImpl = {
    name: `KeepAlive`,
    // Marker for special handling inside the renderer. We are not using a ===
    // check directly on KeepAlive in the renderer, because importing it directly
    // would prevent it from being tree-shaken.
    __isKeepAlive: true,
    props: {
        include: [
            String,
            RegExp,
            Array
        ],
        exclude: [
            String,
            RegExp,
            Array
        ],
        max: [
            String,
            Number
        ]
    },
    setup (props, { slots  }) {
        const instance = getCurrentInstance();
        // KeepAlive communicates with the instantiated renderer via the
        // ctx where the renderer passes in its internals,
        // and the KeepAlive instance exposes activate/deactivate implementations.
        // The whole point of this is to avoid importing KeepAlive directly in the
        // renderer to facilitate tree-shaking.
        const sharedContext = instance.ctx;
        // if the internal renderer is not registered, it indicates that this is server-side rendering,
        // for KeepAlive, we just need to render its children
        if (!sharedContext.renderer) return ()=>{
            const children = slots.default && slots.default();
            return children && children.length === 1 ? children[0] : children;
        };
        const cache = new Map();
        const keys = new Set();
        let current = null;
        instance.__v_cache = cache;
        const parentSuspense = instance.suspense;
        const { renderer: { p: patch , m: move , um: _unmount , o: { createElement  }  }  } = sharedContext;
        const storageContainer = createElement("div");
        sharedContext.activate = (vnode, container, anchor, isSVG, optimized)=>{
            const instance = vnode.component;
            move(vnode, container, anchor, 0 /* MoveType.ENTER */ , parentSuspense);
            // in case props have changed
            patch(instance.vnode, vnode, container, anchor, instance, parentSuspense, isSVG, vnode.slotScopeIds, optimized);
            queuePostRenderEffect(()=>{
                instance.isDeactivated = false;
                if (instance.a) (0, _shared.invokeArrayFns)(instance.a);
                const vnodeHook = vnode.props && vnode.props.onVnodeMounted;
                if (vnodeHook) invokeVNodeHook(vnodeHook, instance.parent, vnode);
            }, parentSuspense);
            // Update components tree
            devtoolsComponentAdded(instance);
        };
        sharedContext.deactivate = (vnode)=>{
            const instance = vnode.component;
            move(vnode, storageContainer, null, 1 /* MoveType.LEAVE */ , parentSuspense);
            queuePostRenderEffect(()=>{
                if (instance.da) (0, _shared.invokeArrayFns)(instance.da);
                const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;
                if (vnodeHook) invokeVNodeHook(vnodeHook, instance.parent, vnode);
                instance.isDeactivated = true;
            }, parentSuspense);
            // Update components tree
            devtoolsComponentAdded(instance);
        };
        function unmount(vnode) {
            // reset the shapeFlag so it can be properly unmounted
            resetShapeFlag(vnode);
            _unmount(vnode, instance, parentSuspense, true);
        }
        function pruneCache(filter) {
            cache.forEach((vnode, key)=>{
                const name = getComponentName(vnode.type);
                if (name && (!filter || !filter(name))) pruneCacheEntry(key);
            });
        }
        function pruneCacheEntry(key) {
            const cached = cache.get(key);
            if (!current || !isSameVNodeType(cached, current)) unmount(cached);
            else if (current) // current active instance should no longer be kept-alive.
            // we can't unmount it now but it might be later, so reset its flag now.
            resetShapeFlag(current);
            cache.delete(key);
            keys.delete(key);
        }
        // prune cache on include/exclude prop change
        watch(()=>[
                props.include,
                props.exclude
            ], ([include, exclude])=>{
            include && pruneCache((name)=>matches(include, name));
            exclude && pruneCache((name)=>!matches(exclude, name));
        }, // prune post-render after `current` has been updated
        {
            flush: "post",
            deep: true
        });
        // cache sub tree after render
        let pendingCacheKey = null;
        const cacheSubtree = ()=>{
            // fix #1621, the pendingCacheKey could be 0
            if (pendingCacheKey != null) cache.set(pendingCacheKey, getInnerChild(instance.subTree));
        };
        onMounted(cacheSubtree);
        onUpdated(cacheSubtree);
        onBeforeUnmount(()=>{
            cache.forEach((cached)=>{
                const { subTree , suspense  } = instance;
                const vnode = getInnerChild(subTree);
                if (cached.type === vnode.type && cached.key === vnode.key) {
                    // current instance will be unmounted as part of keep-alive's unmount
                    resetShapeFlag(vnode);
                    // but invoke its deactivated hook here
                    const da = vnode.component.da;
                    da && queuePostRenderEffect(da, suspense);
                    return;
                }
                unmount(cached);
            });
        });
        return ()=>{
            pendingCacheKey = null;
            if (!slots.default) return null;
            const children = slots.default();
            const rawVNode = children[0];
            if (children.length > 1) {
                warn(`KeepAlive should contain exactly one component child.`);
                current = null;
                return children;
            } else if (!isVNode(rawVNode) || !(rawVNode.shapeFlag & 4 /* ShapeFlags.STATEFUL_COMPONENT */ ) && !(rawVNode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */ )) {
                current = null;
                return rawVNode;
            }
            let vnode = getInnerChild(rawVNode);
            const comp = vnode.type;
            // for async components, name check should be based in its loaded
            // inner component if available
            const name = getComponentName(isAsyncWrapper(vnode) ? vnode.type.__asyncResolved || {} : comp);
            const { include , exclude , max  } = props;
            if (include && (!name || !matches(include, name)) || exclude && name && matches(exclude, name)) {
                current = vnode;
                return rawVNode;
            }
            const key = vnode.key == null ? comp : vnode.key;
            const cachedVNode = cache.get(key);
            // clone vnode if it's reused because we are going to mutate it
            if (vnode.el) {
                vnode = cloneVNode(vnode);
                if (rawVNode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) rawVNode.ssContent = vnode;
            }
            // #1513 it's possible for the returned vnode to be cloned due to attr
            // fallthrough or scopeId, so the vnode here may not be the final vnode
            // that is mounted. Instead of caching it directly, we store the pending
            // key and cache `instance.subTree` (the normalized vnode) in
            // beforeMount/beforeUpdate hooks.
            pendingCacheKey = key;
            if (cachedVNode) {
                // copy over mounted state
                vnode.el = cachedVNode.el;
                vnode.component = cachedVNode.component;
                if (vnode.transition) // recursively update transition hooks on subTree
                setTransitionHooks(vnode, vnode.transition);
                // avoid vnode being mounted as fresh
                vnode.shapeFlag |= 512 /* ShapeFlags.COMPONENT_KEPT_ALIVE */ ;
                // make this key the freshest
                keys.delete(key);
                keys.add(key);
            } else {
                keys.add(key);
                // prune oldest entry
                if (max && keys.size > parseInt(max, 10)) pruneCacheEntry(keys.values().next().value);
            }
            // avoid vnode being unmounted
            vnode.shapeFlag |= 256 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */ ;
            current = vnode;
            return isSuspense(rawVNode.type) ? rawVNode : vnode;
        };
    }
};
// export the public type for h/tsx inference
// also to avoid inline import() in generated d.ts files
const KeepAlive = KeepAliveImpl;
function matches(pattern, name) {
    if ((0, _shared.isArray)(pattern)) return pattern.some((p)=>matches(p, name));
    else if ((0, _shared.isString)(pattern)) return pattern.split(",").includes(name);
    else if ((0, _shared.isRegExp)(pattern)) return pattern.test(name);
    /* istanbul ignore next */ return false;
}
function onActivated(hook, target) {
    registerKeepAliveHook(hook, "a" /* LifecycleHooks.ACTIVATED */ , target);
}
function onDeactivated(hook, target) {
    registerKeepAliveHook(hook, "da" /* LifecycleHooks.DEACTIVATED */ , target);
}
function registerKeepAliveHook(hook, type, target = currentInstance) {
    // cache the deactivate branch check wrapper for injected hooks so the same
    // hook can be properly deduped by the scheduler. "__wdc" stands for "with
    // deactivation check".
    const wrappedHook = hook.__wdc || (hook.__wdc = ()=>{
        // only fire the hook if the target instance is NOT in a deactivated branch.
        let current = target;
        while(current){
            if (current.isDeactivated) return;
            current = current.parent;
        }
        return hook();
    });
    injectHook(type, wrappedHook, target);
    // In addition to registering it on the target instance, we walk up the parent
    // chain and register it on all ancestor instances that are keep-alive roots.
    // This avoids the need to walk the entire component tree when invoking these
    // hooks, and more importantly, avoids the need to track child components in
    // arrays.
    if (target) {
        let current = target.parent;
        while(current && current.parent){
            if (isKeepAlive(current.parent.vnode)) injectToKeepAliveRoot(wrappedHook, type, target, current);
            current = current.parent;
        }
    }
}
function injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {
    // injectHook wraps the original for error handling, so make sure to remove
    // the wrapped version.
    const injected = injectHook(type, hook, keepAliveRoot, true);
    onUnmounted(()=>{
        (0, _shared.remove)(keepAliveRoot[type], injected);
    }, target);
}
function resetShapeFlag(vnode) {
    // bitwise operations to remove keep alive flags
    vnode.shapeFlag &= -257 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */ ;
    vnode.shapeFlag &= -513 /* ShapeFlags.COMPONENT_KEPT_ALIVE */ ;
}
function getInnerChild(vnode) {
    return vnode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */  ? vnode.ssContent : vnode;
}
function injectHook(type, hook, target = currentInstance, prepend = false) {
    if (target) {
        const hooks = target[type] || (target[type] = []);
        // cache the error handling wrapper for injected hooks so the same hook
        // can be properly deduped by the scheduler. "__weh" stands for "with error
        // handling".
        const wrappedHook = hook.__weh || (hook.__weh = (...args)=>{
            if (target.isUnmounted) return;
            // disable tracking inside all lifecycle hooks
            // since they can potentially be called inside effects.
            (0, _reactivity.pauseTracking)();
            // Set currentInstance during hook invocation.
            // This assumes the hook does not synchronously trigger other hooks, which
            // can only be false when the user does something really funky.
            setCurrentInstance(target);
            const res = callWithAsyncErrorHandling(hook, target, type, args);
            unsetCurrentInstance();
            (0, _reactivity.resetTracking)();
            return res;
        });
        if (prepend) hooks.unshift(wrappedHook);
        else hooks.push(wrappedHook);
        return wrappedHook;
    } else {
        const apiName = (0, _shared.toHandlerKey)(ErrorTypeStrings[type].replace(/ hook$/, ""));
        warn(`${apiName} is called when there is no active component instance to be ` + `associated with. ` + `Lifecycle injection APIs can only be used during execution of setup().` + (` If you are using async setup(), make sure to register lifecycle ` + `hooks before the first await statement.`));
    }
}
const createHook = (lifecycle)=>(hook, target = currentInstance)=>// post-create lifecycle registrations are noops during SSR (except for serverPrefetch)
        (!isInSSRComponentSetup || lifecycle === "sp" /* LifecycleHooks.SERVER_PREFETCH */ ) && injectHook(lifecycle, (...args)=>hook(...args), target);
const onBeforeMount = createHook("bm" /* LifecycleHooks.BEFORE_MOUNT */ );
const onMounted = createHook("m" /* LifecycleHooks.MOUNTED */ );
const onBeforeUpdate = createHook("bu" /* LifecycleHooks.BEFORE_UPDATE */ );
const onUpdated = createHook("u" /* LifecycleHooks.UPDATED */ );
const onBeforeUnmount = createHook("bum" /* LifecycleHooks.BEFORE_UNMOUNT */ );
const onUnmounted = createHook("um" /* LifecycleHooks.UNMOUNTED */ );
const onServerPrefetch = createHook("sp" /* LifecycleHooks.SERVER_PREFETCH */ );
const onRenderTriggered = createHook("rtg" /* LifecycleHooks.RENDER_TRIGGERED */ );
const onRenderTracked = createHook("rtc" /* LifecycleHooks.RENDER_TRACKED */ );
function onErrorCaptured(hook, target = currentInstance) {
    injectHook("ec" /* LifecycleHooks.ERROR_CAPTURED */ , hook, target);
}
/**
Runtime helper for applying directives to a vnode. Example usage:

const comp = resolveComponent('comp')
const foo = resolveDirective('foo')
const bar = resolveDirective('bar')

return withDirectives(h(comp), [
  [foo, this.x],
  [bar, this.y]
])
*/ function validateDirectiveName(name) {
    if ((0, _shared.isBuiltInDirective)(name)) warn("Do not use built-in directive ids as custom directive id: " + name);
}
/**
 * Adds directives to a VNode.
 */ function withDirectives(vnode, directives) {
    const internalInstance = currentRenderingInstance;
    if (internalInstance === null) {
        warn(`withDirectives can only be used inside render functions.`);
        return vnode;
    }
    const instance = getExposeProxy(internalInstance) || internalInstance.proxy;
    const bindings = vnode.dirs || (vnode.dirs = []);
    for(let i = 0; i < directives.length; i++){
        let [dir, value, arg, modifiers = (0, _shared.EMPTY_OBJ)] = directives[i];
        if (dir) {
            if ((0, _shared.isFunction)(dir)) dir = {
                mounted: dir,
                updated: dir
            };
            if (dir.deep) traverse(value);
            bindings.push({
                dir,
                instance,
                value,
                oldValue: void 0,
                arg,
                modifiers
            });
        }
    }
    return vnode;
}
function invokeDirectiveHook(vnode, prevVNode, instance, name) {
    const bindings = vnode.dirs;
    const oldBindings = prevVNode && prevVNode.dirs;
    for(let i = 0; i < bindings.length; i++){
        const binding = bindings[i];
        if (oldBindings) binding.oldValue = oldBindings[i].value;
        let hook = binding.dir[name];
        if (hook) {
            // disable tracking inside all lifecycle hooks
            // since they can potentially be called inside effects.
            (0, _reactivity.pauseTracking)();
            callWithAsyncErrorHandling(hook, instance, 8 /* ErrorCodes.DIRECTIVE_HOOK */ , [
                vnode.el,
                binding,
                vnode,
                prevVNode
            ]);
            (0, _reactivity.resetTracking)();
        }
    }
}
const COMPONENTS = "components";
const DIRECTIVES = "directives";
/**
 * @private
 */ function resolveComponent(name, maybeSelfReference) {
    return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;
}
const NULL_DYNAMIC_COMPONENT = Symbol();
/**
 * @private
 */ function resolveDynamicComponent(component) {
    if ((0, _shared.isString)(component)) return resolveAsset(COMPONENTS, component, false) || component;
    else // invalid types will fallthrough to createVNode and raise warning
    return component || NULL_DYNAMIC_COMPONENT;
}
/**
 * @private
 */ function resolveDirective(name) {
    return resolveAsset(DIRECTIVES, name);
}
// implementation
function resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {
    const instance = currentRenderingInstance || currentInstance;
    if (instance) {
        const Component = instance.type;
        // explicit self name has highest priority
        if (type === COMPONENTS) {
            const selfName = getComponentName(Component, false);
            if (selfName && (selfName === name || selfName === (0, _shared.camelize)(name) || selfName === (0, _shared.capitalize)((0, _shared.camelize)(name)))) return Component;
        }
        const res = // local registration
        // check instance[type] first which is resolved for options API
        resolve(instance[type] || Component[type], name) || // global registration
        resolve(instance.appContext[type], name);
        if (!res && maybeSelfReference) // fallback to implicit self-reference
        return Component;
        if (warnMissing && !res) {
            const extra = type === COMPONENTS ? `\nIf this is a native custom element, make sure to exclude it from ` + `component resolution via compilerOptions.isCustomElement.` : ``;
            warn(`Failed to resolve ${type.slice(0, -1)}: ${name}${extra}`);
        }
        return res;
    } else warn(`resolve${(0, _shared.capitalize)(type.slice(0, -1))} ` + `can only be used in render() or setup().`);
}
function resolve(registry, name) {
    return registry && (registry[name] || registry[(0, _shared.camelize)(name)] || registry[(0, _shared.capitalize)((0, _shared.camelize)(name))]);
}
/**
 * Actual implementation
 */ function renderList(source, renderItem, cache, index) {
    let ret;
    const cached = cache && cache[index];
    if ((0, _shared.isArray)(source) || (0, _shared.isString)(source)) {
        ret = new Array(source.length);
        for(let i = 0, l = source.length; i < l; i++)ret[i] = renderItem(source[i], i, undefined, cached && cached[i]);
    } else if (typeof source === "number") {
        if (!Number.isInteger(source)) warn(`The v-for range expect an integer value but got ${source}.`);
        ret = new Array(source);
        for(let i = 0; i < source; i++)ret[i] = renderItem(i + 1, i, undefined, cached && cached[i]);
    } else if ((0, _shared.isObject)(source)) {
        if (source[Symbol.iterator]) ret = Array.from(source, (item, i)=>renderItem(item, i, undefined, cached && cached[i]));
        else {
            const keys = Object.keys(source);
            ret = new Array(keys.length);
            for(let i = 0, l = keys.length; i < l; i++){
                const key = keys[i];
                ret[i] = renderItem(source[key], key, i, cached && cached[i]);
            }
        }
    } else ret = [];
    if (cache) cache[index] = ret;
    return ret;
}
/**
 * Compiler runtime helper for creating dynamic slots object
 * @private
 */ function createSlots(slots, dynamicSlots) {
    for(let i = 0; i < dynamicSlots.length; i++){
        const slot = dynamicSlots[i];
        // array of dynamic slot generated by <template v-for="..." #[...]>
        if ((0, _shared.isArray)(slot)) for(let j = 0; j < slot.length; j++)slots[slot[j].name] = slot[j].fn;
        else if (slot) // conditional single slot generated by <template v-if="..." #foo>
        slots[slot.name] = slot.key ? (...args)=>{
            const res = slot.fn(...args);
            // attach branch key so each conditional branch is considered a
            // different fragment
            if (res) res.key = slot.key;
            return res;
        } : slot.fn;
    }
    return slots;
}
/**
 * Compiler runtime helper for rendering `<slot/>`
 * @private
 */ function renderSlot(slots, name, props = {}, // this is not a user-facing function, so the fallback is always generated by
// the compiler and guaranteed to be a function returning an array
fallback, noSlotted) {
    if (currentRenderingInstance.isCE || currentRenderingInstance.parent && isAsyncWrapper(currentRenderingInstance.parent) && currentRenderingInstance.parent.isCE) {
        if (name !== "default") props.name = name;
        return createVNode("slot", props, fallback && fallback());
    }
    let slot = slots[name];
    if (slot && slot.length > 1) {
        warn(`SSR-optimized slot function detected in a non-SSR-optimized render ` + `function. You need to mark this component with $dynamic-slots in the ` + `parent template.`);
        slot = ()=>[];
    }
    // a compiled slot disables block tracking by default to avoid manual
    // invocation interfering with template-based block tracking, but in
    // `renderSlot` we can be sure that it's template-based so we can force
    // enable it.
    if (slot && slot._c) slot._d = false;
    openBlock();
    const validSlotContent = slot && ensureValidVNode(slot(props));
    const rendered = createBlock(Fragment, {
        key: props.key || // slot content array of a dynamic conditional slot may have a branch
        // key attached in the `createSlots` helper, respect that
        validSlotContent && validSlotContent.key || `_${name}`
    }, validSlotContent || (fallback ? fallback() : []), validSlotContent && slots._ === 1 /* SlotFlags.STABLE */  ? 64 /* PatchFlags.STABLE_FRAGMENT */  : -2 /* PatchFlags.BAIL */ );
    if (!noSlotted && rendered.scopeId) rendered.slotScopeIds = [
        rendered.scopeId + "-s"
    ];
    if (slot && slot._c) slot._d = true;
    return rendered;
}
function ensureValidVNode(vnodes) {
    return vnodes.some((child)=>{
        if (!isVNode(child)) return true;
        if (child.type === Comment) return false;
        if (child.type === Fragment && !ensureValidVNode(child.children)) return false;
        return true;
    }) ? vnodes : null;
}
/**
 * For prefixing keys in v-on="obj" with "on"
 * @private
 */ function toHandlers(obj, preserveCaseIfNecessary) {
    const ret = {};
    if (!(0, _shared.isObject)(obj)) {
        warn(`v-on with no argument expects an object value.`);
        return ret;
    }
    for(const key in obj)ret[preserveCaseIfNecessary && /[A-Z]/.test(key) ? `on:${key}` : (0, _shared.toHandlerKey)(key)] = obj[key];
    return ret;
}
/**
 * #2437 In Vue 3, functional components do not have a public instance proxy but
 * they exist in the internal parent chain. For code that relies on traversing
 * public $parent chains, skip functional ones and go to the parent instead.
 */ const getPublicInstance = (i)=>{
    if (!i) return null;
    if (isStatefulComponent(i)) return getExposeProxy(i) || i.proxy;
    return getPublicInstance(i.parent);
};
const publicPropertiesMap = // Move PURE marker to new line to workaround compiler discarding it
// due to type annotation
/*#__PURE__*/ (0, _shared.extend)(Object.create(null), {
    $: (i)=>i,
    $el: (i)=>i.vnode.el,
    $data: (i)=>i.data,
    $props: (i)=>(0, _reactivity.shallowReadonly)(i.props),
    $attrs: (i)=>(0, _reactivity.shallowReadonly)(i.attrs),
    $slots: (i)=>(0, _reactivity.shallowReadonly)(i.slots),
    $refs: (i)=>(0, _reactivity.shallowReadonly)(i.refs),
    $parent: (i)=>getPublicInstance(i.parent),
    $root: (i)=>getPublicInstance(i.root),
    $emit: (i)=>i.emit,
    $options: (i)=>__VUE_OPTIONS_API__ ? resolveMergedOptions(i) : i.type,
    $forceUpdate: (i)=>i.f || (i.f = ()=>queueJob(i.update)),
    $nextTick: (i)=>i.n || (i.n = nextTick.bind(i.proxy)),
    $watch: (i)=>__VUE_OPTIONS_API__ ? instanceWatch.bind(i) : (0, _shared.NOOP)
});
const isReservedPrefix = (key)=>key === "_" || key === "$";
const hasSetupBinding = (state, key)=>state !== (0, _shared.EMPTY_OBJ) && !state.__isScriptSetup && (0, _shared.hasOwn)(state, key);
const PublicInstanceProxyHandlers = {
    get ({ _: instance  }, key) {
        const { ctx , setupState , data , props , accessCache , type , appContext  } = instance;
        // for internal formatters to know that this is a Vue instance
        if (key === "__isVue") return true;
        // data / props / ctx
        // This getter gets called for every property access on the render context
        // during render and is a major hotspot. The most expensive part of this
        // is the multiple hasOwn() calls. It's much faster to do a simple property
        // access on a plain object, so we use an accessCache object (with null
        // prototype) to memoize what access type a key corresponds to.
        let normalizedProps;
        if (key[0] !== "$") {
            const n = accessCache[key];
            if (n !== undefined) switch(n){
                case 1 /* AccessTypes.SETUP */ :
                    return setupState[key];
                case 2 /* AccessTypes.DATA */ :
                    return data[key];
                case 4 /* AccessTypes.CONTEXT */ :
                    return ctx[key];
                case 3 /* AccessTypes.PROPS */ :
                    return props[key];
            }
            else if (hasSetupBinding(setupState, key)) {
                accessCache[key] = 1 /* AccessTypes.SETUP */ ;
                return setupState[key];
            } else if (data !== (0, _shared.EMPTY_OBJ) && (0, _shared.hasOwn)(data, key)) {
                accessCache[key] = 2 /* AccessTypes.DATA */ ;
                return data[key];
            } else if (// only cache other properties when instance has declared (thus stable)
            // props
            (normalizedProps = instance.propsOptions[0]) && (0, _shared.hasOwn)(normalizedProps, key)) {
                accessCache[key] = 3 /* AccessTypes.PROPS */ ;
                return props[key];
            } else if (ctx !== (0, _shared.EMPTY_OBJ) && (0, _shared.hasOwn)(ctx, key)) {
                accessCache[key] = 4 /* AccessTypes.CONTEXT */ ;
                return ctx[key];
            } else if (!__VUE_OPTIONS_API__ || shouldCacheAccess) accessCache[key] = 0 /* AccessTypes.OTHER */ ;
        }
        const publicGetter = publicPropertiesMap[key];
        let cssModule, globalProperties;
        // public $xxx properties
        if (publicGetter) {
            if (key === "$attrs") {
                (0, _reactivity.track)(instance, "get" /* TrackOpTypes.GET */ , key);
                markAttrsAccessed();
            }
            return publicGetter(instance);
        } else if (// css module (injected by vue-loader)
        (cssModule = type.__cssModules) && (cssModule = cssModule[key])) return cssModule;
        else if (ctx !== (0, _shared.EMPTY_OBJ) && (0, _shared.hasOwn)(ctx, key)) {
            // user may set custom properties to `this` that start with `$`
            accessCache[key] = 4 /* AccessTypes.CONTEXT */ ;
            return ctx[key];
        } else if (// global properties
        globalProperties = appContext.config.globalProperties, (0, _shared.hasOwn)(globalProperties, key)) return globalProperties[key];
        else if (currentRenderingInstance && (!(0, _shared.isString)(key) || // #1091 avoid internal isRef/isVNode checks on component instance leading
        // to infinite warning loop
        key.indexOf("__v") !== 0)) {
            if (data !== (0, _shared.EMPTY_OBJ) && isReservedPrefix(key[0]) && (0, _shared.hasOwn)(data, key)) warn(`Property ${JSON.stringify(key)} must be accessed via $data because it starts with a reserved ` + `character ("$" or "_") and is not proxied on the render context.`);
            else if (instance === currentRenderingInstance) warn(`Property ${JSON.stringify(key)} was accessed during render ` + `but is not defined on instance.`);
        }
    },
    set ({ _: instance  }, key, value) {
        const { data , setupState , ctx  } = instance;
        if (hasSetupBinding(setupState, key)) {
            setupState[key] = value;
            return true;
        } else if ((0, setupState.__isScriptSetup) && (0, _shared.hasOwn)(setupState, key)) {
            warn(`Cannot mutate <script setup> binding "${key}" from Options API.`);
            return false;
        } else if (data !== (0, _shared.EMPTY_OBJ) && (0, _shared.hasOwn)(data, key)) {
            data[key] = value;
            return true;
        } else if ((0, _shared.hasOwn)(instance.props, key)) {
            warn(`Attempting to mutate prop "${key}". Props are readonly.`);
            return false;
        }
        if (key[0] === "$" && key.slice(1) in instance) {
            warn(`Attempting to mutate public property "${key}". ` + `Properties starting with $ are reserved and readonly.`);
            return false;
        } else if (key in instance.appContext.config.globalProperties) Object.defineProperty(ctx, key, {
            enumerable: true,
            configurable: true,
            value
        });
        else ctx[key] = value;
        return true;
    },
    has ({ _: { data , setupState , accessCache , ctx , appContext , propsOptions  }  }, key) {
        let normalizedProps;
        return !!accessCache[key] || data !== (0, _shared.EMPTY_OBJ) && (0, _shared.hasOwn)(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && (0, _shared.hasOwn)(normalizedProps, key) || (0, _shared.hasOwn)(ctx, key) || (0, _shared.hasOwn)(publicPropertiesMap, key) || (0, _shared.hasOwn)(appContext.config.globalProperties, key);
    },
    defineProperty (target, key, descriptor) {
        if (descriptor.get != null) // invalidate key cache of a getter based property #5417
        target._.accessCache[key] = 0;
        else if ((0, _shared.hasOwn)(descriptor, "value")) this.set(target, key, descriptor.value, null);
        return Reflect.defineProperty(target, key, descriptor);
    }
};
PublicInstanceProxyHandlers.ownKeys = (target)=>{
    warn(`Avoid app logic that relies on enumerating keys on a component instance. ` + `The keys will be empty in production mode to avoid performance overhead.`);
    return Reflect.ownKeys(target);
};
const RuntimeCompiledPublicInstanceProxyHandlers = /*#__PURE__*/ (0, _shared.extend)({}, PublicInstanceProxyHandlers, {
    get (target, key) {
        // fast path for unscopables when using `with` block
        if (key === Symbol.unscopables) return;
        return PublicInstanceProxyHandlers.get(target, key, target);
    },
    has (_, key) {
        const has = key[0] !== "_" && !(0, _shared.isGloballyWhitelisted)(key);
        if (!has && PublicInstanceProxyHandlers.has(_, key)) warn(`Property ${JSON.stringify(key)} should not start with _ which is a reserved prefix for Vue internals.`);
        return has;
    }
});
// dev only
// In dev mode, the proxy target exposes the same properties as seen on `this`
// for easier console inspection. In prod mode it will be an empty object so
// these properties definitions can be skipped.
function createDevRenderContext(instance) {
    const target = {};
    // expose internal instance for proxy handlers
    Object.defineProperty(target, `_`, {
        configurable: true,
        enumerable: false,
        get: ()=>instance
    });
    // expose public properties
    Object.keys(publicPropertiesMap).forEach((key)=>{
        Object.defineProperty(target, key, {
            configurable: true,
            enumerable: false,
            get: ()=>publicPropertiesMap[key](instance),
            // intercepted by the proxy so no need for implementation,
            // but needed to prevent set errors
            set: (0, _shared.NOOP)
        });
    });
    return target;
}
// dev only
function exposePropsOnRenderContext(instance) {
    const { ctx , propsOptions: [propsOptions]  } = instance;
    if (propsOptions) Object.keys(propsOptions).forEach((key)=>{
        Object.defineProperty(ctx, key, {
            enumerable: true,
            configurable: true,
            get: ()=>instance.props[key],
            set: (0, _shared.NOOP)
        });
    });
}
// dev only
function exposeSetupStateOnRenderContext(instance) {
    const { ctx , setupState  } = instance;
    Object.keys((0, _reactivity.toRaw)(setupState)).forEach((key)=>{
        if (!setupState.__isScriptSetup) {
            if (isReservedPrefix(key[0])) {
                warn(`setup() return property ${JSON.stringify(key)} should not start with "$" or "_" ` + `which are reserved prefixes for Vue internals.`);
                return;
            }
            Object.defineProperty(ctx, key, {
                enumerable: true,
                configurable: true,
                get: ()=>setupState[key],
                set: (0, _shared.NOOP)
            });
        }
    });
}
function createDuplicateChecker() {
    const cache = Object.create(null);
    return (type, key)=>{
        if (cache[key]) warn(`${type} property "${key}" is already defined in ${cache[key]}.`);
        else cache[key] = type;
    };
}
let shouldCacheAccess = true;
function applyOptions(instance) {
    const options = resolveMergedOptions(instance);
    const publicThis = instance.proxy;
    const ctx = instance.ctx;
    // do not cache property access on public proxy during state initialization
    shouldCacheAccess = false;
    // call beforeCreate first before accessing other options since
    // the hook may mutate resolved options (#2791)
    if (options.beforeCreate) callHook(options.beforeCreate, instance, "bc" /* LifecycleHooks.BEFORE_CREATE */ );
    const { // state
    data: dataOptions , computed: computedOptions , methods , watch: watchOptions , provide: provideOptions , inject: injectOptions , // lifecycle
    created , beforeMount , mounted , beforeUpdate , updated , activated , deactivated , beforeDestroy , beforeUnmount , destroyed , unmounted , render , renderTracked , renderTriggered , errorCaptured , serverPrefetch , // public API
    expose , inheritAttrs , // assets
    components , directives , filters  } = options;
    const checkDuplicateProperties = createDuplicateChecker();
    {
        const [propsOptions] = instance.propsOptions;
        if (propsOptions) for(const key in propsOptions)checkDuplicateProperties("Props" /* OptionTypes.PROPS */ , key);
    }
    // options initialization order (to be consistent with Vue 2):
    // - props (already done outside of this function)
    // - inject
    // - methods
    // - data (deferred since it relies on `this` access)
    // - computed
    // - watch (deferred since it relies on `this` access)
    if (injectOptions) resolveInjections(injectOptions, ctx, checkDuplicateProperties, instance.appContext.config.unwrapInjectedRef);
    if (methods) for(const key in methods){
        const methodHandler = methods[key];
        if ((0, _shared.isFunction)(methodHandler)) {
            Object.defineProperty(ctx, key, {
                value: methodHandler.bind(publicThis),
                configurable: true,
                enumerable: true,
                writable: true
            });
            checkDuplicateProperties("Methods" /* OptionTypes.METHODS */ , key);
        } else warn(`Method "${key}" has type "${typeof methodHandler}" in the component definition. ` + `Did you reference the function correctly?`);
    }
    if (dataOptions) {
        if (!(0, _shared.isFunction)(dataOptions)) warn(`The data option must be a function. ` + `Plain object usage is no longer supported.`);
        const data = dataOptions.call(publicThis, publicThis);
        if ((0, _shared.isPromise)(data)) warn(`data() returned a Promise - note data() cannot be async; If you ` + `intend to perform data fetching before component renders, use ` + `async setup() + <Suspense>.`);
        if (!(0, _shared.isObject)(data)) warn(`data() should return an object.`);
        else {
            instance.data = (0, _reactivity.reactive)(data);
            for(const key in data){
                checkDuplicateProperties("Data" /* OptionTypes.DATA */ , key);
                // expose data on ctx during dev
                if (!isReservedPrefix(key[0])) Object.defineProperty(ctx, key, {
                    configurable: true,
                    enumerable: true,
                    get: ()=>data[key],
                    set: (0, _shared.NOOP)
                });
            }
        }
    }
    // state initialization complete at this point - start caching access
    shouldCacheAccess = true;
    if (computedOptions) for(const key in computedOptions){
        const opt = computedOptions[key];
        const get = (0, _shared.isFunction)(opt) ? opt.bind(publicThis, publicThis) : (0, _shared.isFunction)(opt.get) ? opt.get.bind(publicThis, publicThis) : (0, _shared.NOOP);
        if (get === (0, _shared.NOOP)) warn(`Computed property "${key}" has no getter.`);
        const set = !(0, _shared.isFunction)(opt) && (0, _shared.isFunction)(opt.set) ? opt.set.bind(publicThis) : ()=>{
            warn(`Write operation failed: computed property "${key}" is readonly.`);
        };
        const c = computed({
            get,
            set
        });
        Object.defineProperty(ctx, key, {
            enumerable: true,
            configurable: true,
            get: ()=>c.value,
            set: (v1)=>c.value = v1
        });
        checkDuplicateProperties("Computed" /* OptionTypes.COMPUTED */ , key);
    }
    if (watchOptions) for(const key in watchOptions)createWatcher(watchOptions[key], ctx, publicThis, key);
    if (provideOptions) {
        const provides = (0, _shared.isFunction)(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
        Reflect.ownKeys(provides).forEach((key)=>{
            provide(key, provides[key]);
        });
    }
    if (created) callHook(created, instance, "c" /* LifecycleHooks.CREATED */ );
    function registerLifecycleHook(register, hook) {
        if ((0, _shared.isArray)(hook)) hook.forEach((_hook)=>register(_hook.bind(publicThis)));
        else if (hook) register(hook.bind(publicThis));
    }
    registerLifecycleHook(onBeforeMount, beforeMount);
    registerLifecycleHook(onMounted, mounted);
    registerLifecycleHook(onBeforeUpdate, beforeUpdate);
    registerLifecycleHook(onUpdated, updated);
    registerLifecycleHook(onActivated, activated);
    registerLifecycleHook(onDeactivated, deactivated);
    registerLifecycleHook(onErrorCaptured, errorCaptured);
    registerLifecycleHook(onRenderTracked, renderTracked);
    registerLifecycleHook(onRenderTriggered, renderTriggered);
    registerLifecycleHook(onBeforeUnmount, beforeUnmount);
    registerLifecycleHook(onUnmounted, unmounted);
    registerLifecycleHook(onServerPrefetch, serverPrefetch);
    if ((0, _shared.isArray)(expose)) {
        if (expose.length) {
            const exposed = instance.exposed || (instance.exposed = {});
            expose.forEach((key)=>{
                Object.defineProperty(exposed, key, {
                    get: ()=>publicThis[key],
                    set: (val)=>publicThis[key] = val
                });
            });
        } else if (!instance.exposed) instance.exposed = {};
    }
    // options that are handled when creating the instance but also need to be
    // applied from mixins
    if (render && instance.render === (0, _shared.NOOP)) instance.render = render;
    if (inheritAttrs != null) instance.inheritAttrs = inheritAttrs;
    // asset options.
    if (components) instance.components = components;
    if (directives) instance.directives = directives;
}
function resolveInjections(injectOptions, ctx, checkDuplicateProperties = (0, _shared.NOOP), unwrapRef = false) {
    if ((0, _shared.isArray)(injectOptions)) injectOptions = normalizeInject(injectOptions);
    for(const key in injectOptions){
        const opt = injectOptions[key];
        let injected;
        if ((0, _shared.isObject)(opt)) {
            if ("default" in opt) injected = inject(opt.from || key, opt.default, true);
            else injected = inject(opt.from || key);
        } else injected = inject(opt);
        if ((0, _reactivity.isRef)(injected)) {
            // TODO remove the check in 3.3
            if (unwrapRef) Object.defineProperty(ctx, key, {
                enumerable: true,
                configurable: true,
                get: ()=>injected.value,
                set: (v1)=>injected.value = v1
            });
            else {
                warn(`injected property "${key}" is a ref and will be auto-unwrapped ` + `and no longer needs \`.value\` in the next minor release. ` + `To opt-in to the new behavior now, ` + `set \`app.config.unwrapInjectedRef = true\` (this config is ` + `temporary and will not be needed in the future.)`);
                ctx[key] = injected;
            }
        } else ctx[key] = injected;
        checkDuplicateProperties("Inject" /* OptionTypes.INJECT */ , key);
    }
}
function callHook(hook, instance, type) {
    callWithAsyncErrorHandling((0, _shared.isArray)(hook) ? hook.map((h)=>h.bind(instance.proxy)) : hook.bind(instance.proxy), instance, type);
}
function createWatcher(raw, ctx, publicThis, key) {
    const getter = key.includes(".") ? createPathGetter(publicThis, key) : ()=>publicThis[key];
    if ((0, _shared.isString)(raw)) {
        const handler = ctx[raw];
        if ((0, _shared.isFunction)(handler)) watch(getter, handler);
        else warn(`Invalid watch handler specified by key "${raw}"`, handler);
    } else if ((0, _shared.isFunction)(raw)) watch(getter, raw.bind(publicThis));
    else if ((0, _shared.isObject)(raw)) {
        if ((0, _shared.isArray)(raw)) raw.forEach((r)=>createWatcher(r, ctx, publicThis, key));
        else {
            const handler = (0, _shared.isFunction)(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
            if ((0, _shared.isFunction)(handler)) watch(getter, handler, raw);
            else warn(`Invalid watch handler specified by key "${raw.handler}"`, handler);
        }
    } else warn(`Invalid watch option: "${key}"`, raw);
}
/**
 * Resolve merged options and cache it on the component.
 * This is done only once per-component since the merging does not involve
 * instances.
 */ function resolveMergedOptions(instance) {
    const base = instance.type;
    const { mixins , extends: extendsOptions  } = base;
    const { mixins: globalMixins , optionsCache: cache , config: { optionMergeStrategies  }  } = instance.appContext;
    const cached = cache.get(base);
    let resolved;
    if (cached) resolved = cached;
    else if (!globalMixins.length && !mixins && !extendsOptions) resolved = base;
    else {
        resolved = {};
        if (globalMixins.length) globalMixins.forEach((m)=>mergeOptions(resolved, m, optionMergeStrategies, true));
        mergeOptions(resolved, base, optionMergeStrategies);
    }
    if ((0, _shared.isObject)(base)) cache.set(base, resolved);
    return resolved;
}
function mergeOptions(to, from, strats, asMixin = false) {
    const { mixins , extends: extendsOptions  } = from;
    if (extendsOptions) mergeOptions(to, extendsOptions, strats, true);
    if (mixins) mixins.forEach((m)=>mergeOptions(to, m, strats, true));
    for(const key in from)if (asMixin && key === "expose") warn(`"expose" option is ignored when declared in mixins or extends. ` + `It should only be declared in the base component itself.`);
    else {
        const strat = internalOptionMergeStrats[key] || strats && strats[key];
        to[key] = strat ? strat(to[key], from[key]) : from[key];
    }
    return to;
}
const internalOptionMergeStrats = {
    data: mergeDataFn,
    props: mergeObjectOptions,
    emits: mergeObjectOptions,
    // objects
    methods: mergeObjectOptions,
    computed: mergeObjectOptions,
    // lifecycle
    beforeCreate: mergeAsArray,
    created: mergeAsArray,
    beforeMount: mergeAsArray,
    mounted: mergeAsArray,
    beforeUpdate: mergeAsArray,
    updated: mergeAsArray,
    beforeDestroy: mergeAsArray,
    beforeUnmount: mergeAsArray,
    destroyed: mergeAsArray,
    unmounted: mergeAsArray,
    activated: mergeAsArray,
    deactivated: mergeAsArray,
    errorCaptured: mergeAsArray,
    serverPrefetch: mergeAsArray,
    // assets
    components: mergeObjectOptions,
    directives: mergeObjectOptions,
    // watch
    watch: mergeWatchOptions,
    // provide / inject
    provide: mergeDataFn,
    inject: mergeInject
};
function mergeDataFn(to, from) {
    if (!from) return to;
    if (!to) return from;
    return function mergedDataFn() {
        return (0, _shared.extend)((0, _shared.isFunction)(to) ? to.call(this, this) : to, (0, _shared.isFunction)(from) ? from.call(this, this) : from);
    };
}
function mergeInject(to, from) {
    return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
}
function normalizeInject(raw) {
    if ((0, _shared.isArray)(raw)) {
        const res = {};
        for(let i = 0; i < raw.length; i++)res[raw[i]] = raw[i];
        return res;
    }
    return raw;
}
function mergeAsArray(to, from) {
    return to ? [
        ...new Set([].concat(to, from))
    ] : from;
}
function mergeObjectOptions(to, from) {
    return to ? (0, _shared.extend)((0, _shared.extend)(Object.create(null), to), from) : from;
}
function mergeWatchOptions(to, from) {
    if (!to) return from;
    if (!from) return to;
    const merged = (0, _shared.extend)(Object.create(null), to);
    for(const key in from)merged[key] = mergeAsArray(to[key], from[key]);
    return merged;
}
function initProps(instance, rawProps, isStateful, isSSR = false) {
    const props = {};
    const attrs = {};
    (0, _shared.def)(attrs, InternalObjectKey, 1);
    instance.propsDefaults = Object.create(null);
    setFullProps(instance, rawProps, props, attrs);
    // ensure all declared prop keys are present
    for(const key in instance.propsOptions[0])if (!(key in props)) props[key] = undefined;
    validateProps(rawProps || {}, props, instance);
    if (isStateful) // stateful
    instance.props = isSSR ? props : (0, _reactivity.shallowReactive)(props);
    else if (!instance.type.props) // functional w/ optional props, props === attrs
    instance.props = attrs;
    else // functional w/ declared props
    instance.props = props;
    instance.attrs = attrs;
}
function isInHmrContext(instance) {
    while(instance){
        if (instance.type.__hmrId) return true;
        instance = instance.parent;
    }
}
function updateProps(instance, rawProps, rawPrevProps, optimized) {
    const { props , attrs , vnode: { patchFlag  }  } = instance;
    const rawCurrentProps = (0, _reactivity.toRaw)(props);
    const [options] = instance.propsOptions;
    let hasAttrsChanged = false;
    if (// always force full diff in dev
    // - #1942 if hmr is enabled with sfc component
    // - vite#872 non-sfc component used by sfc component
    !isInHmrContext(instance) && (optimized || patchFlag > 0) && !(patchFlag & 16 /* PatchFlags.FULL_PROPS */ )) {
        if (patchFlag & 8 /* PatchFlags.PROPS */ ) {
            // Compiler-generated props & no keys change, just set the updated
            // the props.
            const propsToUpdate = instance.vnode.dynamicProps;
            for(let i = 0; i < propsToUpdate.length; i++){
                let key = propsToUpdate[i];
                // skip if the prop key is a declared emit event listener
                if (isEmitListener(instance.emitsOptions, key)) continue;
                // PROPS flag guarantees rawProps to be non-null
                const value = rawProps[key];
                if (options) {
                    // attr / props separation was done on init and will be consistent
                    // in this code path, so just check if attrs have it.
                    if ((0, _shared.hasOwn)(attrs, key)) {
                        if (value !== attrs[key]) {
                            attrs[key] = value;
                            hasAttrsChanged = true;
                        }
                    } else {
                        const camelizedKey = (0, _shared.camelize)(key);
                        props[camelizedKey] = resolvePropValue(options, rawCurrentProps, camelizedKey, value, instance, false);
                    }
                } else if (value !== attrs[key]) {
                    attrs[key] = value;
                    hasAttrsChanged = true;
                }
            }
        }
    } else {
        // full props update.
        if (setFullProps(instance, rawProps, props, attrs)) hasAttrsChanged = true;
        // in case of dynamic props, check if we need to delete keys from
        // the props object
        let kebabKey;
        for(const key in rawCurrentProps)if (!rawProps || // for camelCase
        !(0, _shared.hasOwn)(rawProps, key) && // it's possible the original props was passed in as kebab-case
        // and converted to camelCase (#955)
        ((kebabKey = (0, _shared.hyphenate)(key)) === key || !(0, _shared.hasOwn)(rawProps, kebabKey))) {
            if (options) {
                if (rawPrevProps && // for camelCase
                (rawPrevProps[key] !== undefined || // for kebab-case
                rawPrevProps[kebabKey] !== undefined)) props[key] = resolvePropValue(options, rawCurrentProps, key, undefined, instance, true);
            } else delete props[key];
        }
        // in the case of functional component w/o props declaration, props and
        // attrs point to the same object so it should already have been updated.
        if (attrs !== rawCurrentProps) {
            for(const key in attrs)if (!rawProps || !(0, _shared.hasOwn)(rawProps, key) && true) {
                delete attrs[key];
                hasAttrsChanged = true;
            }
        }
    }
    // trigger updates for $attrs in case it's used in component slots
    if (hasAttrsChanged) (0, _reactivity.trigger)(instance, "set" /* TriggerOpTypes.SET */ , "$attrs");
    validateProps(rawProps || {}, props, instance);
}
function setFullProps(instance, rawProps, props, attrs) {
    const [options, needCastKeys] = instance.propsOptions;
    let hasAttrsChanged = false;
    let rawCastValues;
    if (rawProps) for(let key in rawProps){
        // key, ref are reserved and never passed down
        if ((0, _shared.isReservedProp)(key)) continue;
        const value = rawProps[key];
        // prop option names are camelized during normalization, so to support
        // kebab -> camel conversion here we need to camelize the key.
        let camelKey;
        if (options && (0, _shared.hasOwn)(options, camelKey = (0, _shared.camelize)(key))) {
            if (!needCastKeys || !needCastKeys.includes(camelKey)) props[camelKey] = value;
            else (rawCastValues || (rawCastValues = {}))[camelKey] = value;
        } else if (!isEmitListener(instance.emitsOptions, key)) {
            if (!(key in attrs) || value !== attrs[key]) {
                attrs[key] = value;
                hasAttrsChanged = true;
            }
        }
    }
    if (needCastKeys) {
        const rawCurrentProps = (0, _reactivity.toRaw)(props);
        const castValues = rawCastValues || (0, _shared.EMPTY_OBJ);
        for(let i = 0; i < needCastKeys.length; i++){
            const key = needCastKeys[i];
            props[key] = resolvePropValue(options, rawCurrentProps, key, castValues[key], instance, !(0, _shared.hasOwn)(castValues, key));
        }
    }
    return hasAttrsChanged;
}
function resolvePropValue(options, props, key, value, instance, isAbsent) {
    const opt = options[key];
    if (opt != null) {
        const hasDefault = (0, _shared.hasOwn)(opt, "default");
        // default values
        if (hasDefault && value === undefined) {
            const defaultValue = opt.default;
            if (opt.type !== Function && (0, _shared.isFunction)(defaultValue)) {
                const { propsDefaults  } = instance;
                if (key in propsDefaults) value = propsDefaults[key];
                else {
                    setCurrentInstance(instance);
                    value = propsDefaults[key] = defaultValue.call(null, props);
                    unsetCurrentInstance();
                }
            } else value = defaultValue;
        }
        // boolean casting
        if (opt[0 /* BooleanFlags.shouldCast */ ]) {
            if (isAbsent && !hasDefault) value = false;
            else if (opt[1 /* BooleanFlags.shouldCastTrue */ ] && (value === "" || value === (0, _shared.hyphenate)(key))) value = true;
        }
    }
    return value;
}
function normalizePropsOptions(comp, appContext, asMixin = false) {
    const cache = appContext.propsCache;
    const cached = cache.get(comp);
    if (cached) return cached;
    const raw = comp.props;
    const normalized = {};
    const needCastKeys = [];
    // apply mixin/extends props
    let hasExtends = false;
    if (__VUE_OPTIONS_API__ && !(0, _shared.isFunction)(comp)) {
        const extendProps = (raw)=>{
            hasExtends = true;
            const [props, keys] = normalizePropsOptions(raw, appContext, true);
            (0, _shared.extend)(normalized, props);
            if (keys) needCastKeys.push(...keys);
        };
        if (!asMixin && appContext.mixins.length) appContext.mixins.forEach(extendProps);
        if (comp.extends) extendProps(comp.extends);
        if (comp.mixins) comp.mixins.forEach(extendProps);
    }
    if (!raw && !hasExtends) {
        if ((0, _shared.isObject)(comp)) cache.set(comp, (0, _shared.EMPTY_ARR));
        return 0, _shared.EMPTY_ARR;
    }
    if ((0, _shared.isArray)(raw)) for(let i = 0; i < raw.length; i++){
        if (!(0, _shared.isString)(raw[i])) warn(`props must be strings when using array syntax.`, raw[i]);
        const normalizedKey = (0, _shared.camelize)(raw[i]);
        if (validatePropName(normalizedKey)) normalized[normalizedKey] = (0, _shared.EMPTY_OBJ);
    }
    else if (raw) {
        if (!(0, _shared.isObject)(raw)) warn(`invalid props options`, raw);
        for(const key in raw){
            const normalizedKey = (0, _shared.camelize)(key);
            if (validatePropName(normalizedKey)) {
                const opt = raw[key];
                const prop = normalized[normalizedKey] = (0, _shared.isArray)(opt) || (0, _shared.isFunction)(opt) ? {
                    type: opt
                } : Object.assign({}, opt);
                if (prop) {
                    const booleanIndex = getTypeIndex(Boolean, prop.type);
                    const stringIndex = getTypeIndex(String, prop.type);
                    prop[0 /* BooleanFlags.shouldCast */ ] = booleanIndex > -1;
                    prop[1 /* BooleanFlags.shouldCastTrue */ ] = stringIndex < 0 || booleanIndex < stringIndex;
                    // if the prop needs boolean casting or default value
                    if (booleanIndex > -1 || (0, _shared.hasOwn)(prop, "default")) needCastKeys.push(normalizedKey);
                }
            }
        }
    }
    const res = [
        normalized,
        needCastKeys
    ];
    if ((0, _shared.isObject)(comp)) cache.set(comp, res);
    return res;
}
function validatePropName(key) {
    if (key[0] !== "$") return true;
    else warn(`Invalid prop name: "${key}" is a reserved property.`);
    return false;
}
// use function string name to check type constructors
// so that it works across vms / iframes.
function getType(ctor) {
    const match = ctor && ctor.toString().match(/^\s*(function|class) (\w+)/);
    return match ? match[2] : ctor === null ? "null" : "";
}
function isSameType(a, b) {
    return getType(a) === getType(b);
}
function getTypeIndex(type, expectedTypes) {
    if ((0, _shared.isArray)(expectedTypes)) return expectedTypes.findIndex((t)=>isSameType(t, type));
    else if ((0, _shared.isFunction)(expectedTypes)) return isSameType(expectedTypes, type) ? 0 : -1;
    return -1;
}
/**
 * dev only
 */ function validateProps(rawProps, props, instance) {
    const resolvedValues = (0, _reactivity.toRaw)(props);
    const options = instance.propsOptions[0];
    for(const key in options){
        let opt = options[key];
        if (opt == null) continue;
        validateProp(key, resolvedValues[key], opt, !(0, _shared.hasOwn)(rawProps, key) && !(0, _shared.hasOwn)(rawProps, (0, _shared.hyphenate)(key)));
    }
}
/**
 * dev only
 */ function validateProp(name, value, prop, isAbsent) {
    const { type , required , validator  } = prop;
    // required!
    if (required && isAbsent) {
        warn('Missing required prop: "' + name + '"');
        return;
    }
    // missing but optional
    if (value == null && !prop.required) return;
    // type check
    if (type != null && type !== true) {
        let isValid = false;
        const types = (0, _shared.isArray)(type) ? type : [
            type
        ];
        const expectedTypes = [];
        // value is valid as long as one of the specified types match
        for(let i = 0; i < types.length && !isValid; i++){
            const { valid , expectedType  } = assertType(value, types[i]);
            expectedTypes.push(expectedType || "");
            isValid = valid;
        }
        if (!isValid) {
            warn(getInvalidTypeMessage(name, value, expectedTypes));
            return;
        }
    }
    // custom validator
    if (validator && !validator(value)) warn('Invalid prop: custom validator check failed for prop "' + name + '".');
}
const isSimpleType = /*#__PURE__*/ (0, _shared.makeMap)("String,Number,Boolean,Function,Symbol,BigInt");
/**
 * dev only
 */ function assertType(value, type) {
    let valid;
    const expectedType = getType(type);
    if (isSimpleType(expectedType)) {
        const t = typeof value;
        valid = t === expectedType.toLowerCase();
        // for primitive wrapper objects
        if (!valid && t === "object") valid = value instanceof type;
    } else if (expectedType === "Object") valid = (0, _shared.isObject)(value);
    else if (expectedType === "Array") valid = (0, _shared.isArray)(value);
    else if (expectedType === "null") valid = value === null;
    else valid = value instanceof type;
    return {
        valid,
        expectedType
    };
}
/**
 * dev only
 */ function getInvalidTypeMessage(name, value, expectedTypes) {
    let message = `Invalid prop: type check failed for prop "${name}".` + ` Expected ${expectedTypes.map((0, _shared.capitalize)).join(" | ")}`;
    const expectedType = expectedTypes[0];
    const receivedType = (0, _shared.toRawType)(value);
    const expectedValue = styleValue(value, expectedType);
    const receivedValue = styleValue(value, receivedType);
    // check if we need to specify expected value
    if (expectedTypes.length === 1 && isExplicable(expectedType) && !isBoolean(expectedType, receivedType)) message += ` with value ${expectedValue}`;
    message += `, got ${receivedType} `;
    // check if we need to specify received value
    if (isExplicable(receivedType)) message += `with value ${receivedValue}.`;
    return message;
}
/**
 * dev only
 */ function styleValue(value, type) {
    if (type === "String") return `"${value}"`;
    else if (type === "Number") return `${Number(value)}`;
    else return `${value}`;
}
/**
 * dev only
 */ function isExplicable(type) {
    const explicitTypes = [
        "string",
        "number",
        "boolean"
    ];
    return explicitTypes.some((elem)=>type.toLowerCase() === elem);
}
/**
 * dev only
 */ function isBoolean(...args) {
    return args.some((elem)=>elem.toLowerCase() === "boolean");
}
const isInternalKey = (key)=>key[0] === "_" || key === "$stable";
const normalizeSlotValue = (value)=>(0, _shared.isArray)(value) ? value.map(normalizeVNode) : [
        normalizeVNode(value)
    ];
const normalizeSlot = (key, rawSlot, ctx)=>{
    if (rawSlot._n) // already normalized - #5353
    return rawSlot;
    const normalized = withCtx((...args)=>{
        if (currentInstance) warn(`Slot "${key}" invoked outside of the render function: ` + `this will not track dependencies used in the slot. ` + `Invoke the slot function inside the render function instead.`);
        return normalizeSlotValue(rawSlot(...args));
    }, ctx);
    normalized._c = false;
    return normalized;
};
const normalizeObjectSlots = (rawSlots, slots, instance)=>{
    const ctx = rawSlots._ctx;
    for(const key in rawSlots){
        if (isInternalKey(key)) continue;
        const value = rawSlots[key];
        if ((0, _shared.isFunction)(value)) slots[key] = normalizeSlot(key, value, ctx);
        else if (value != null) {
            warn(`Non-function value encountered for slot "${key}". ` + `Prefer function slots for better performance.`);
            const normalized = normalizeSlotValue(value);
            slots[key] = ()=>normalized;
        }
    }
};
const normalizeVNodeSlots = (instance, children)=>{
    if (!isKeepAlive(instance.vnode) && true) warn(`Non-function value encountered for default slot. ` + `Prefer function slots for better performance.`);
    const normalized = normalizeSlotValue(children);
    instance.slots.default = ()=>normalized;
};
const initSlots = (instance, children)=>{
    if (instance.vnode.shapeFlag & 32 /* ShapeFlags.SLOTS_CHILDREN */ ) {
        const type = children._;
        if (type) {
            // users can get the shallow readonly version of the slots object through `this.$slots`,
            // we should avoid the proxy object polluting the slots of the internal instance
            instance.slots = (0, _reactivity.toRaw)(children);
            // make compiler marker non-enumerable
            (0, _shared.def)(children, "_", type);
        } else normalizeObjectSlots(children, instance.slots = {});
    } else {
        instance.slots = {};
        if (children) normalizeVNodeSlots(instance, children);
    }
    (0, _shared.def)(instance.slots, InternalObjectKey, 1);
};
const updateSlots = (instance, children, optimized)=>{
    const { vnode , slots  } = instance;
    let needDeletionCheck = true;
    let deletionComparisonTarget = (0, _shared.EMPTY_OBJ);
    if (vnode.shapeFlag & 32 /* ShapeFlags.SLOTS_CHILDREN */ ) {
        const type = children._;
        if (type) {
            // compiled slots.
            if (isHmrUpdating) // Parent was HMR updated so slot content may have changed.
            // force update slots and mark instance for hmr as well
            (0, _shared.extend)(slots, children);
            else if (optimized && type === 1 /* SlotFlags.STABLE */ ) // compiled AND stable.
            // no need to update, and skip stale slots removal.
            needDeletionCheck = false;
            else {
                // compiled but dynamic (v-if/v-for on slots) - update slots, but skip
                // normalization.
                (0, _shared.extend)(slots, children);
                // #2893
                // when rendering the optimized slots by manually written render function,
                // we need to delete the `slots._` flag if necessary to make subsequent updates reliable,
                // i.e. let the `renderSlot` create the bailed Fragment
                if (!optimized && type === 1 /* SlotFlags.STABLE */ ) delete slots._;
            }
        } else {
            needDeletionCheck = !children.$stable;
            normalizeObjectSlots(children, slots);
        }
        deletionComparisonTarget = children;
    } else if (children) {
        // non slot object children (direct value) passed to a component
        normalizeVNodeSlots(instance, children);
        deletionComparisonTarget = {
            default: 1
        };
    }
    // delete stale slots
    if (needDeletionCheck) {
        for(const key in slots)if (!isInternalKey(key) && !(key in deletionComparisonTarget)) delete slots[key];
    }
};
function createAppContext() {
    return {
        app: null,
        config: {
            isNativeTag: (0, _shared.NO),
            performance: false,
            globalProperties: {},
            optionMergeStrategies: {},
            errorHandler: undefined,
            warnHandler: undefined,
            compilerOptions: {}
        },
        mixins: [],
        components: {},
        directives: {},
        provides: Object.create(null),
        optionsCache: new WeakMap(),
        propsCache: new WeakMap(),
        emitsCache: new WeakMap()
    };
}
let uid$1 = 0;
function createAppAPI(render, hydrate) {
    return function createApp(rootComponent, rootProps = null) {
        if (!(0, _shared.isFunction)(rootComponent)) rootComponent = Object.assign({}, rootComponent);
        if (rootProps != null && !(0, _shared.isObject)(rootProps)) {
            warn(`root props passed to app.mount() must be an object.`);
            rootProps = null;
        }
        const context = createAppContext();
        const installedPlugins = new Set();
        let isMounted = false;
        const app = context.app = {
            _uid: uid$1++,
            _component: rootComponent,
            _props: rootProps,
            _container: null,
            _context: context,
            _instance: null,
            version,
            get config () {
                return context.config;
            },
            set config (v){
                warn(`app.config cannot be replaced. Modify individual options instead.`);
            },
            use (plugin, ...options) {
                if (installedPlugins.has(plugin)) warn(`Plugin has already been applied to target app.`);
                else if (plugin && (0, _shared.isFunction)(plugin.install)) {
                    installedPlugins.add(plugin);
                    plugin.install(app, ...options);
                } else if ((0, _shared.isFunction)(plugin)) {
                    installedPlugins.add(plugin);
                    plugin(app, ...options);
                } else warn(`A plugin must either be a function or an object with an "install" ` + `function.`);
                return app;
            },
            mixin (mixin) {
                if (__VUE_OPTIONS_API__) {
                    if (!context.mixins.includes(mixin)) context.mixins.push(mixin);
                    else warn("Mixin has already been applied to target app" + (mixin.name ? `: ${mixin.name}` : ""));
                } else warn("Mixins are only available in builds supporting Options API");
                return app;
            },
            component (name, component) {
                validateComponentName(name, context.config);
                if (!component) return context.components[name];
                if (0, context.components[name]) warn(`Component "${name}" has already been registered in target app.`);
                context.components[name] = component;
                return app;
            },
            directive (name, directive) {
                validateDirectiveName(name);
                if (!directive) return context.directives[name];
                if (0, context.directives[name]) warn(`Directive "${name}" has already been registered in target app.`);
                context.directives[name] = directive;
                return app;
            },
            mount (rootContainer, isHydrate, isSVG) {
                if (!isMounted) {
                    // #5571
                    if (0, rootContainer.__vue_app__) warn(`There is already an app instance mounted on the host container.\n` + ` If you want to mount another app on the same host container,` + ` you need to unmount the previous app by calling \`app.unmount()\` first.`);
                    const vnode = createVNode(rootComponent, rootProps);
                    // store app context on the root VNode.
                    // this will be set on the root instance on initial mount.
                    vnode.appContext = context;
                    context.reload = ()=>{
                        render(cloneVNode(vnode), rootContainer, isSVG);
                    };
                    if (isHydrate && hydrate) hydrate(vnode, rootContainer);
                    else render(vnode, rootContainer, isSVG);
                    isMounted = true;
                    app._container = rootContainer;
                    rootContainer.__vue_app__ = app;
                    app._instance = vnode.component;
                    devtoolsInitApp(app, version);
                    return getExposeProxy(vnode.component) || vnode.component.proxy;
                } else warn(`App has already been mounted.\n` + `If you want to remount the same app, move your app creation logic ` + `into a factory function and create fresh app instances for each ` + `mount - e.g. \`const createMyApp = () => createApp(App)\``);
            },
            unmount () {
                if (isMounted) {
                    render(null, app._container);
                    app._instance = null;
                    devtoolsUnmountApp(app);
                    delete app._container.__vue_app__;
                } else warn(`Cannot unmount an app that is not mounted.`);
            },
            provide (key, value) {
                if (key in context.provides) warn(`App already provides property with key "${String(key)}". ` + `It will be overwritten with the new value.`);
                context.provides[key] = value;
                return app;
            }
        };
        return app;
    };
}
/**
 * Function for handling a template ref
 */ function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
    if ((0, _shared.isArray)(rawRef)) {
        rawRef.forEach((r, i)=>setRef(r, oldRawRef && ((0, _shared.isArray)(oldRawRef) ? oldRawRef[i] : oldRawRef), parentSuspense, vnode, isUnmount));
        return;
    }
    if (isAsyncWrapper(vnode) && !isUnmount) // when mounting async components, nothing needs to be done,
    // because the template ref is forwarded to inner component
    return;
    const refValue = vnode.shapeFlag & 4 /* ShapeFlags.STATEFUL_COMPONENT */  ? getExposeProxy(vnode.component) || vnode.component.proxy : vnode.el;
    const value = isUnmount ? null : refValue;
    const { i: owner , r: ref  } = rawRef;
    if (!owner) {
        warn(`Missing ref owner context. ref cannot be used on hoisted vnodes. ` + `A vnode with ref must be created inside the render function.`);
        return;
    }
    const oldRef = oldRawRef && oldRawRef.r;
    const refs = owner.refs === (0, _shared.EMPTY_OBJ) ? owner.refs = {} : owner.refs;
    const setupState = owner.setupState;
    // dynamic ref changed. unset old ref
    if (oldRef != null && oldRef !== ref) {
        if ((0, _shared.isString)(oldRef)) {
            refs[oldRef] = null;
            if ((0, _shared.hasOwn)(setupState, oldRef)) setupState[oldRef] = null;
        } else if ((0, _reactivity.isRef)(oldRef)) oldRef.value = null;
    }
    if ((0, _shared.isFunction)(ref)) callWithErrorHandling(ref, owner, 12 /* ErrorCodes.FUNCTION_REF */ , [
        value,
        refs
    ]);
    else {
        const _isString = (0, _shared.isString)(ref);
        const _isRef = (0, _reactivity.isRef)(ref);
        if (_isString || _isRef) {
            const doSet = ()=>{
                if (rawRef.f) {
                    const existing = _isString ? (0, _shared.hasOwn)(setupState, ref) ? setupState[ref] : refs[ref] : ref.value;
                    if (isUnmount) (0, _shared.isArray)(existing) && (0, _shared.remove)(existing, refValue);
                    else {
                        if (!(0, _shared.isArray)(existing)) {
                            if (_isString) {
                                refs[ref] = [
                                    refValue
                                ];
                                if ((0, _shared.hasOwn)(setupState, ref)) setupState[ref] = refs[ref];
                            } else {
                                ref.value = [
                                    refValue
                                ];
                                if (rawRef.k) refs[rawRef.k] = ref.value;
                            }
                        } else if (!existing.includes(refValue)) existing.push(refValue);
                    }
                } else if (_isString) {
                    refs[ref] = value;
                    if ((0, _shared.hasOwn)(setupState, ref)) setupState[ref] = value;
                } else if (_isRef) {
                    ref.value = value;
                    if (rawRef.k) refs[rawRef.k] = value;
                } else warn("Invalid template ref type:", ref, `(${typeof ref})`);
            };
            if (value) {
                doSet.id = -1;
                queuePostRenderEffect(doSet, parentSuspense);
            } else doSet();
        } else warn("Invalid template ref type:", ref, `(${typeof ref})`);
    }
}
let hasMismatch = false;
const isSVGContainer = (container)=>/svg/.test(container.namespaceURI) && container.tagName !== "foreignObject";
const isComment = (node)=>node.nodeType === 8 /* DOMNodeTypes.COMMENT */ ;
// Note: hydration is DOM-specific
// But we have to place it in core due to tight coupling with core - splitting
// it out creates a ton of unnecessary complexity.
// Hydration also depends on some renderer internal logic which needs to be
// passed in via arguments.
function createHydrationFunctions(rendererInternals) {
    const { mt: mountComponent , p: patch , o: { patchProp , createText , nextSibling , parentNode , remove , insert , createComment  }  } = rendererInternals;
    const hydrate = (vnode, container)=>{
        if (!container.hasChildNodes()) {
            warn(`Attempting to hydrate existing markup but container is empty. ` + `Performing full mount instead.`);
            patch(null, vnode, container);
            flushPostFlushCbs();
            container._vnode = vnode;
            return;
        }
        hasMismatch = false;
        hydrateNode(container.firstChild, vnode, null, null, null);
        flushPostFlushCbs();
        container._vnode = vnode;
        if (hasMismatch && true) // this error should show up in production
        console.error(`Hydration completed but contains mismatches.`);
    };
    const hydrateNode = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized = false)=>{
        const isFragmentStart = isComment(node) && node.data === "[";
        const onMismatch = ()=>handleMismatch(node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragmentStart);
        const { type , ref , shapeFlag , patchFlag  } = vnode;
        let domType = node.nodeType;
        vnode.el = node;
        if (patchFlag === -2 /* PatchFlags.BAIL */ ) {
            optimized = false;
            vnode.dynamicChildren = null;
        }
        let nextNode = null;
        switch(type){
            case Text:
                if (domType !== 3 /* DOMNodeTypes.TEXT */ ) {
                    // #5728 empty text node inside a slot can cause hydration failure
                    // because the server rendered HTML won't contain a text node
                    if (vnode.children === "") {
                        insert(vnode.el = createText(""), parentNode(node), node);
                        nextNode = node;
                    } else nextNode = onMismatch();
                } else {
                    if (node.data !== vnode.children) {
                        hasMismatch = true;
                        warn(`Hydration text mismatch:` + `\n- Client: ${JSON.stringify(node.data)}` + `\n- Server: ${JSON.stringify(vnode.children)}`);
                        node.data = vnode.children;
                    }
                    nextNode = nextSibling(node);
                }
                break;
            case Comment:
                if (domType !== 8 /* DOMNodeTypes.COMMENT */  || isFragmentStart) nextNode = onMismatch();
                else nextNode = nextSibling(node);
                break;
            case Static:
                if (isFragmentStart) {
                    // entire template is static but SSRed as a fragment
                    node = nextSibling(node);
                    domType = node.nodeType;
                }
                if (domType === 1 /* DOMNodeTypes.ELEMENT */  || domType === 3 /* DOMNodeTypes.TEXT */ ) {
                    // determine anchor, adopt content
                    nextNode = node;
                    // if the static vnode has its content stripped during build,
                    // adopt it from the server-rendered HTML.
                    const needToAdoptContent = !vnode.children.length;
                    for(let i = 0; i < vnode.staticCount; i++){
                        if (needToAdoptContent) vnode.children += nextNode.nodeType === 1 /* DOMNodeTypes.ELEMENT */  ? nextNode.outerHTML : nextNode.data;
                        if (i === vnode.staticCount - 1) vnode.anchor = nextNode;
                        nextNode = nextSibling(nextNode);
                    }
                    return isFragmentStart ? nextSibling(nextNode) : nextNode;
                } else onMismatch();
                break;
            case Fragment:
                if (!isFragmentStart) nextNode = onMismatch();
                else nextNode = hydrateFragment(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
                break;
            default:
                if (shapeFlag & 1 /* ShapeFlags.ELEMENT */ ) {
                    if (domType !== 1 /* DOMNodeTypes.ELEMENT */  || vnode.type.toLowerCase() !== node.tagName.toLowerCase()) nextNode = onMismatch();
                    else nextNode = hydrateElement(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
                } else if (shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) {
                    // when setting up the render effect, if the initial vnode already
                    // has .el set, the component will perform hydration instead of mount
                    // on its sub-tree.
                    vnode.slotScopeIds = slotScopeIds;
                    const container = parentNode(node);
                    mountComponent(vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), optimized);
                    // component may be async, so in the case of fragments we cannot rely
                    // on component's rendered output to determine the end of the fragment
                    // instead, we do a lookahead to find the end anchor node.
                    nextNode = isFragmentStart ? locateClosingAsyncAnchor(node) : nextSibling(node);
                    // #4293 teleport as component root
                    if (nextNode && isComment(nextNode) && nextNode.data === "teleport end") nextNode = nextSibling(nextNode);
                    // #3787
                    // if component is async, it may get moved / unmounted before its
                    // inner component is loaded, so we need to give it a placeholder
                    // vnode that matches its adopted DOM.
                    if (isAsyncWrapper(vnode)) {
                        let subTree;
                        if (isFragmentStart) {
                            subTree = createVNode(Fragment);
                            subTree.anchor = nextNode ? nextNode.previousSibling : container.lastChild;
                        } else subTree = node.nodeType === 3 ? createTextVNode("") : createVNode("div");
                        subTree.el = node;
                        vnode.component.subTree = subTree;
                    }
                } else if (shapeFlag & 64 /* ShapeFlags.TELEPORT */ ) {
                    if (domType !== 8 /* DOMNodeTypes.COMMENT */ ) nextNode = onMismatch();
                    else nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, rendererInternals, hydrateChildren);
                } else if (shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) nextNode = vnode.type.hydrate(node, vnode, parentComponent, parentSuspense, isSVGContainer(parentNode(node)), slotScopeIds, optimized, rendererInternals, hydrateNode);
                else warn("Invalid HostVNode type:", type, `(${typeof type})`);
        }
        if (ref != null) setRef(ref, null, parentSuspense, vnode);
        return nextNode;
    };
    const hydrateElement = (el, vnode, parentComponent, parentSuspense, slotScopeIds, optimized)=>{
        optimized = optimized || !!vnode.dynamicChildren;
        const { type , props , patchFlag , shapeFlag , dirs  } = vnode;
        // #4006 for form elements with non-string v-model value bindings
        // e.g. <option :value="obj">, <input type="checkbox" :true-value="1">
        const forcePatchValue = type === "input" && dirs || type === "option";
        {
            if (dirs) invokeDirectiveHook(vnode, null, parentComponent, "created");
            // props
            if (props) {
                if (forcePatchValue || !optimized || patchFlag & 48 /* PatchFlags.HYDRATE_EVENTS */ ) {
                    for(const key in props)if (forcePatchValue && key.endsWith("value") || (0, _shared.isOn)(key) && !(0, _shared.isReservedProp)(key)) patchProp(el, key, null, props[key], false, undefined, parentComponent);
                } else if (props.onClick) // Fast path for click listeners (which is most often) to avoid
                // iterating through props.
                patchProp(el, "onClick", null, props.onClick, false, undefined, parentComponent);
            }
            // vnode / directive hooks
            let vnodeHooks;
            if (vnodeHooks = props && props.onVnodeBeforeMount) invokeVNodeHook(vnodeHooks, parentComponent, vnode);
            if (dirs) invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
            if ((vnodeHooks = props && props.onVnodeMounted) || dirs) queueEffectWithSuspense(()=>{
                vnodeHooks && invokeVNodeHook(vnodeHooks, parentComponent, vnode);
                dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
            }, parentSuspense);
            // children
            if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */  && // skip if element has innerHTML / textContent
            !(props && (props.innerHTML || props.textContent))) {
                let next = hydrateChildren(el.firstChild, vnode, el, parentComponent, parentSuspense, slotScopeIds, optimized);
                let hasWarned = false;
                while(next){
                    hasMismatch = true;
                    if (!hasWarned) {
                        warn(`Hydration children mismatch in <${vnode.type}>: ` + `server rendered element contains more child nodes than client vdom.`);
                        hasWarned = true;
                    }
                    // The SSRed DOM contains more nodes than it should. Remove them.
                    const cur = next;
                    next = next.nextSibling;
                    remove(cur);
                }
            } else if (shapeFlag & 8 /* ShapeFlags.TEXT_CHILDREN */ ) {
                if (el.textContent !== vnode.children) {
                    hasMismatch = true;
                    warn(`Hydration text content mismatch in <${vnode.type}>:\n` + `- Client: ${el.textContent}\n` + `- Server: ${vnode.children}`);
                    el.textContent = vnode.children;
                }
            }
        }
        return el.nextSibling;
    };
    const hydrateChildren = (node, parentVNode, container, parentComponent, parentSuspense, slotScopeIds, optimized)=>{
        optimized = optimized || !!parentVNode.dynamicChildren;
        const children = parentVNode.children;
        const l = children.length;
        let hasWarned = false;
        for(let i = 0; i < l; i++){
            const vnode = optimized ? children[i] : children[i] = normalizeVNode(children[i]);
            if (node) node = hydrateNode(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized);
            else if (vnode.type === Text && !vnode.children) continue;
            else {
                hasMismatch = true;
                if (!hasWarned) {
                    warn(`Hydration children mismatch in <${container.tagName.toLowerCase()}>: ` + `server rendered element contains fewer child nodes than client vdom.`);
                    hasWarned = true;
                }
                // the SSRed DOM didn't contain enough nodes. Mount the missing ones.
                patch(null, vnode, container, null, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);
            }
        }
        return node;
    };
    const hydrateFragment = (node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized)=>{
        const { slotScopeIds: fragmentSlotScopeIds  } = vnode;
        if (fragmentSlotScopeIds) slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
        const container = parentNode(node);
        const next = hydrateChildren(nextSibling(node), vnode, container, parentComponent, parentSuspense, slotScopeIds, optimized);
        if (next && isComment(next) && next.data === "]") return nextSibling(vnode.anchor = next);
        else {
            // fragment didn't hydrate successfully, since we didn't get a end anchor
            // back. This should have led to node/children mismatch warnings.
            hasMismatch = true;
            // since the anchor is missing, we need to create one and insert it
            insert(vnode.anchor = createComment(`]`), container, next);
            return next;
        }
    };
    const handleMismatch = (node, vnode, parentComponent, parentSuspense, slotScopeIds, isFragment)=>{
        hasMismatch = true;
        warn(`Hydration node mismatch:\n- Client vnode:`, vnode.type, `\n- Server rendered DOM:`, node, node.nodeType === 3 /* DOMNodeTypes.TEXT */  ? `(text)` : isComment(node) && node.data === "[" ? `(start of fragment)` : ``);
        vnode.el = null;
        if (isFragment) {
            // remove excessive fragment nodes
            const end = locateClosingAsyncAnchor(node);
            while(true){
                const next = nextSibling(node);
                if (next && next !== end) remove(next);
                else break;
            }
        }
        const next = nextSibling(node);
        const container = parentNode(node);
        remove(node);
        patch(null, vnode, container, next, parentComponent, parentSuspense, isSVGContainer(container), slotScopeIds);
        return next;
    };
    const locateClosingAsyncAnchor = (node)=>{
        let match = 0;
        while(node){
            node = nextSibling(node);
            if (node && isComment(node)) {
                if (node.data === "[") match++;
                if (node.data === "]") {
                    if (match === 0) return nextSibling(node);
                    else match--;
                }
            }
        }
        return node;
    };
    return [
        hydrate,
        hydrateNode
    ];
}
/* eslint-disable no-restricted-globals */ let supported;
let perf;
function startMeasure(instance, type) {
    if (instance.appContext.config.performance && isSupported()) perf.mark(`vue-${type}-${instance.uid}`);
    devtoolsPerfStart(instance, type, isSupported() ? perf.now() : Date.now());
}
function endMeasure(instance, type) {
    if (instance.appContext.config.performance && isSupported()) {
        const startTag = `vue-${type}-${instance.uid}`;
        const endTag = startTag + `:end`;
        perf.mark(endTag);
        perf.measure(`<${formatComponentName(instance, instance.type)}> ${type}`, startTag, endTag);
        perf.clearMarks(startTag);
        perf.clearMarks(endTag);
    }
    devtoolsPerfEnd(instance, type, isSupported() ? perf.now() : Date.now());
}
function isSupported() {
    if (supported !== undefined) return supported;
    if (typeof window !== "undefined" && window.performance) {
        supported = true;
        perf = window.performance;
    } else supported = false;
    return supported;
}
/**
 * This is only called in esm-bundler builds.
 * It is called when a renderer is created, in `baseCreateRenderer` so that
 * importing runtime-core is side-effects free.
 *
 * istanbul-ignore-next
 */ function initFeatureFlags() {
    const needWarn = [];
    if (typeof __VUE_OPTIONS_API__ !== "boolean") {
        needWarn.push(`__VUE_OPTIONS_API__`);
        (0, _shared.getGlobalThis)().__VUE_OPTIONS_API__ = true;
    }
    if (typeof __VUE_PROD_DEVTOOLS__ !== "boolean") {
        needWarn.push(`__VUE_PROD_DEVTOOLS__`);
        (0, _shared.getGlobalThis)().__VUE_PROD_DEVTOOLS__ = false;
    }
    if (0, needWarn.length) {
        const multi = needWarn.length > 1;
        console.warn(`Feature flag${multi ? `s` : ``} ${needWarn.join(", ")} ${multi ? `are` : `is`} not explicitly defined. You are running the esm-bundler build of Vue, ` + `which expects these compile-time feature flags to be globally injected ` + `via the bundler config in order to get better tree-shaking in the ` + `production bundle.\n\n` + `For more details, see https://link.vuejs.org/feature-flags.`);
    }
}
const queuePostRenderEffect = queueEffectWithSuspense;
/**
 * The createRenderer function accepts two generic arguments:
 * HostNode and HostElement, corresponding to Node and Element types in the
 * host environment. For example, for runtime-dom, HostNode would be the DOM
 * `Node` interface and HostElement would be the DOM `Element` interface.
 *
 * Custom renderers can pass in the platform specific types like this:
 *
 * ``` js
 * const { render, createApp } = createRenderer<Node, Element>({
 *   patchProp,
 *   ...nodeOps
 * })
 * ```
 */ function createRenderer(options) {
    return baseCreateRenderer(options);
}
// Separate API for creating hydration-enabled renderer.
// Hydration logic is only used when calling this function, making it
// tree-shakable.
function createHydrationRenderer(options) {
    return baseCreateRenderer(options, createHydrationFunctions);
}
// implementation
function baseCreateRenderer(options, createHydrationFns) {
    initFeatureFlags();
    const target = (0, _shared.getGlobalThis)();
    target.__VUE__ = true;
    setDevtoolsHook(target.__VUE_DEVTOOLS_GLOBAL_HOOK__, target);
    const { insert: hostInsert , remove: hostRemove , patchProp: hostPatchProp , createElement: hostCreateElement , createText: hostCreateText , createComment: hostCreateComment , setText: hostSetText , setElementText: hostSetElementText , parentNode: hostParentNode , nextSibling: hostNextSibling , setScopeId: hostSetScopeId = (0, _shared.NOOP) , insertStaticContent: hostInsertStaticContent  } = options;
    // Note: functions inside this closure should use `const xxx = () => {}`
    // style in order to prevent being inlined by minifiers.
    const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, isSVG = false, slotScopeIds = null, optimized = isHmrUpdating ? false : !!n2.dynamicChildren)=>{
        if (n1 === n2) return;
        // patching & not same type, unmount old tree
        if (n1 && !isSameVNodeType(n1, n2)) {
            anchor = getNextHostNode(n1);
            unmount(n1, parentComponent, parentSuspense, true);
            n1 = null;
        }
        if (n2.patchFlag === -2 /* PatchFlags.BAIL */ ) {
            optimized = false;
            n2.dynamicChildren = null;
        }
        const { type , ref , shapeFlag  } = n2;
        switch(type){
            case Text:
                processText(n1, n2, container, anchor);
                break;
            case Comment:
                processCommentNode(n1, n2, container, anchor);
                break;
            case Static:
                if (n1 == null) mountStaticNode(n2, container, anchor, isSVG);
                else patchStaticNode(n1, n2, container, isSVG);
                break;
            case Fragment:
                processFragment(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                break;
            default:
                if (shapeFlag & 1 /* ShapeFlags.ELEMENT */ ) processElement(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                else if (shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) processComponent(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                else if (shapeFlag & 64 /* ShapeFlags.TELEPORT */ ) type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
                else if (shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) type.process(n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals);
                else warn("Invalid VNode type:", type, `(${typeof type})`);
        }
        // set ref
        if (ref != null && parentComponent) setRef(ref, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
    };
    const processText = (n1, n2, container, anchor)=>{
        if (n1 == null) hostInsert(n2.el = hostCreateText(n2.children), container, anchor);
        else {
            const el = n2.el = n1.el;
            if (n2.children !== n1.children) hostSetText(el, n2.children);
        }
    };
    const processCommentNode = (n1, n2, container, anchor)=>{
        if (n1 == null) hostInsert(n2.el = hostCreateComment(n2.children || ""), container, anchor);
        else // there's no support for dynamic comments
        n2.el = n1.el;
    };
    const mountStaticNode = (n2, container, anchor, isSVG)=>{
        [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG, n2.el, n2.anchor);
    };
    /**
     * Dev / HMR only
     */ const patchStaticNode = (n1, n2, container, isSVG)=>{
        // static nodes are only patched during dev for HMR
        if (n2.children !== n1.children) {
            const anchor = hostNextSibling(n1.anchor);
            // remove existing
            removeStaticNode(n1);
            [n2.el, n2.anchor] = hostInsertStaticContent(n2.children, container, anchor, isSVG);
        } else {
            n2.el = n1.el;
            n2.anchor = n1.anchor;
        }
    };
    const moveStaticNode = ({ el , anchor  }, container, nextSibling)=>{
        let next;
        while(el && el !== anchor){
            next = hostNextSibling(el);
            hostInsert(el, container, nextSibling);
            el = next;
        }
        hostInsert(anchor, container, nextSibling);
    };
    const removeStaticNode = ({ el , anchor  })=>{
        let next;
        while(el && el !== anchor){
            next = hostNextSibling(el);
            hostRemove(el);
            el = next;
        }
        hostRemove(anchor);
    };
    const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        isSVG = isSVG || n2.type === "svg";
        if (n1 == null) mountElement(n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        else patchElement(n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    };
    const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        let el;
        let vnodeHook;
        const { type , props , shapeFlag , transition , dirs  } = vnode;
        el = vnode.el = hostCreateElement(vnode.type, isSVG, props && props.is, props);
        // mount children first, since some props may rely on child content
        // being already rendered, e.g. `<select value>`
        if (shapeFlag & 8 /* ShapeFlags.TEXT_CHILDREN */ ) hostSetElementText(el, vnode.children);
        else if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) mountChildren(vnode.children, el, null, parentComponent, parentSuspense, isSVG && type !== "foreignObject", slotScopeIds, optimized);
        if (dirs) invokeDirectiveHook(vnode, null, parentComponent, "created");
        // scopeId
        setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
        // props
        if (props) {
            for(const key in props)if (key !== "value" && !(0, _shared.isReservedProp)(key)) hostPatchProp(el, key, null, props[key], isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
            /**
             * Special case for setting value on DOM elements:
             * - it can be order-sensitive (e.g. should be set *after* min/max, #2325, #4024)
             * - it needs to be forced (#1471)
             * #2353 proposes adding another renderer option to configure this, but
             * the properties affects are so finite it is worth special casing it
             * here to reduce the complexity. (Special casing it also should not
             * affect non-DOM renderers)
             */ if ("value" in props) hostPatchProp(el, "value", null, props.value);
            if (vnodeHook = props.onVnodeBeforeMount) invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
        Object.defineProperty(el, "__vnode", {
            value: vnode,
            enumerable: false
        });
        Object.defineProperty(el, "__vueParentComponent", {
            value: parentComponent,
            enumerable: false
        });
        if (dirs) invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
        // #1583 For inside suspense + suspense not resolved case, enter hook should call when suspense resolved
        // #1689 For inside suspense + suspense resolved case, just call it
        const needCallTransitionHooks = (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
        if (needCallTransitionHooks) transition.beforeEnter(el);
        hostInsert(el, container, anchor);
        if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) queuePostRenderEffect(()=>{
            vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
            needCallTransitionHooks && transition.enter(el);
            dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
        }, parentSuspense);
    };
    const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent)=>{
        if (scopeId) hostSetScopeId(el, scopeId);
        if (slotScopeIds) for(let i = 0; i < slotScopeIds.length; i++)hostSetScopeId(el, slotScopeIds[i]);
        if (parentComponent) {
            let subTree = parentComponent.subTree;
            if (subTree.patchFlag > 0 && subTree.patchFlag & 2048 /* PatchFlags.DEV_ROOT_FRAGMENT */ ) subTree = filterSingleRoot(subTree.children) || subTree;
            if (vnode === subTree) {
                const parentVNode = parentComponent.vnode;
                setScopeId(el, parentVNode, parentVNode.scopeId, parentVNode.slotScopeIds, parentComponent.parent);
            }
        }
    };
    const mountChildren = (children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, start = 0)=>{
        for(let i = start; i < children.length; i++){
            const child = children[i] = optimized ? cloneIfMounted(children[i]) : normalizeVNode(children[i]);
            patch(null, child, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
    };
    const patchElement = (n1, n2, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        const el = n2.el = n1.el;
        let { patchFlag , dynamicChildren , dirs  } = n2;
        // #1426 take the old vnode's patch flag into account since user may clone a
        // compiler-generated vnode, which de-opts to FULL_PROPS
        patchFlag |= n1.patchFlag & 16 /* PatchFlags.FULL_PROPS */ ;
        const oldProps = n1.props || (0, _shared.EMPTY_OBJ);
        const newProps = n2.props || (0, _shared.EMPTY_OBJ);
        let vnodeHook;
        // disable recurse in beforeUpdate hooks
        parentComponent && toggleRecurse(parentComponent, false);
        if (vnodeHook = newProps.onVnodeBeforeUpdate) invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
        if (dirs) invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
        parentComponent && toggleRecurse(parentComponent, true);
        if (isHmrUpdating) {
            // HMR updated, force full diff
            patchFlag = 0;
            optimized = false;
            dynamicChildren = null;
        }
        const areChildrenSVG = isSVG && n2.type !== "foreignObject";
        if (dynamicChildren) {
            patchBlockChildren(n1.dynamicChildren, dynamicChildren, el, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds);
            if (parentComponent && parentComponent.type.__hmrId) traverseStaticChildren(n1, n2);
        } else if (!optimized) // full diff
        patchChildren(n1, n2, el, null, parentComponent, parentSuspense, areChildrenSVG, slotScopeIds, false);
        if (patchFlag > 0) {
            // the presence of a patchFlag means this element's render code was
            // generated by the compiler and can take the fast path.
            // in this path old node and new node are guaranteed to have the same shape
            // (i.e. at the exact same position in the source template)
            if (patchFlag & 16 /* PatchFlags.FULL_PROPS */ ) // element props contain dynamic keys, full diff needed
            patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
            else {
                // class
                // this flag is matched when the element has dynamic class bindings.
                if (patchFlag & 2 /* PatchFlags.CLASS */ ) {
                    if (oldProps.class !== newProps.class) hostPatchProp(el, "class", null, newProps.class, isSVG);
                }
                // style
                // this flag is matched when the element has dynamic style bindings
                if (patchFlag & 4 /* PatchFlags.STYLE */ ) hostPatchProp(el, "style", oldProps.style, newProps.style, isSVG);
                // props
                // This flag is matched when the element has dynamic prop/attr bindings
                // other than class and style. The keys of dynamic prop/attrs are saved for
                // faster iteration.
                // Note dynamic keys like :[foo]="bar" will cause this optimization to
                // bail out and go through a full diff because we need to unset the old key
                if (patchFlag & 8 /* PatchFlags.PROPS */ ) {
                    // if the flag is present then dynamicProps must be non-null
                    const propsToUpdate = n2.dynamicProps;
                    for(let i = 0; i < propsToUpdate.length; i++){
                        const key = propsToUpdate[i];
                        const prev = oldProps[key];
                        const next = newProps[key];
                        // #1471 force patch value
                        if (next !== prev || key === "value") hostPatchProp(el, key, prev, next, isSVG, n1.children, parentComponent, parentSuspense, unmountChildren);
                    }
                }
            }
            // text
            // This flag is matched when the element has only dynamic text children.
            if (patchFlag & 1 /* PatchFlags.TEXT */ ) {
                if (n1.children !== n2.children) hostSetElementText(el, n2.children);
            }
        } else if (!optimized && dynamicChildren == null) // unoptimized, full diff
        patchProps(el, n2, oldProps, newProps, parentComponent, parentSuspense, isSVG);
        if ((vnodeHook = newProps.onVnodeUpdated) || dirs) queuePostRenderEffect(()=>{
            vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
            dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
        }, parentSuspense);
    };
    // The fast path for blocks.
    const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, isSVG, slotScopeIds)=>{
        for(let i = 0; i < newChildren.length; i++){
            const oldVNode = oldChildren[i];
            const newVNode = newChildren[i];
            // Determine the container (parent element) for the patch.
            const container = // oldVNode may be an errored async setup() component inside Suspense
            // which will not have a mounted element
            oldVNode.el && // - In the case of a Fragment, we need to provide the actual parent
            // of the Fragment itself so it can move its children.
            (oldVNode.type === Fragment || // - In the case of different nodes, there is going to be a replacement
            // which also requires the correct parent container
            !isSameVNodeType(oldVNode, newVNode) || // - In the case of a component, it could contain anything.
            oldVNode.shapeFlag & 70 /* ShapeFlags.TELEPORT */ ) ? hostParentNode(oldVNode.el) : // just pass the block element here to avoid a DOM parentNode call.
            fallbackContainer;
            patch(oldVNode, newVNode, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, true);
        }
    };
    const patchProps = (el, vnode, oldProps, newProps, parentComponent, parentSuspense, isSVG)=>{
        if (oldProps !== newProps) {
            if (oldProps !== (0, _shared.EMPTY_OBJ)) {
                for(const key in oldProps)if (!(0, _shared.isReservedProp)(key) && !(key in newProps)) hostPatchProp(el, key, oldProps[key], null, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
            }
            for(const key in newProps){
                // empty string is not valid prop
                if ((0, _shared.isReservedProp)(key)) continue;
                const next = newProps[key];
                const prev = oldProps[key];
                // defer patching value
                if (next !== prev && key !== "value") hostPatchProp(el, key, prev, next, isSVG, vnode.children, parentComponent, parentSuspense, unmountChildren);
            }
            if ("value" in newProps) hostPatchProp(el, "value", oldProps.value, newProps.value);
        }
    };
    const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
        const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
        let { patchFlag , dynamicChildren , slotScopeIds: fragmentSlotScopeIds  } = n2;
        if (// #5523 dev root fragment may inherit directives
        isHmrUpdating || patchFlag & 2048 /* PatchFlags.DEV_ROOT_FRAGMENT */ ) {
            // HMR updated / Dev root fragment (w/ comments), force full diff
            patchFlag = 0;
            optimized = false;
            dynamicChildren = null;
        }
        // check if this is a slot fragment with :slotted scope ids
        if (fragmentSlotScopeIds) slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
        if (n1 == null) {
            hostInsert(fragmentStartAnchor, container, anchor);
            hostInsert(fragmentEndAnchor, container, anchor);
            // a fragment can only have array children
            // since they are either generated by the compiler, or implicitly created
            // from arrays.
            mountChildren(n2.children, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        } else if (patchFlag > 0 && patchFlag & 64 /* PatchFlags.STABLE_FRAGMENT */  && dynamicChildren && // #2715 the previous fragment could've been a BAILed one as a result
        // of renderSlot() with no valid children
        n1.dynamicChildren) {
            // a stable fragment (template root or <template v-for>) doesn't need to
            // patch children order, but it may contain dynamicChildren.
            patchBlockChildren(n1.dynamicChildren, dynamicChildren, container, parentComponent, parentSuspense, isSVG, slotScopeIds);
            if (parentComponent && parentComponent.type.__hmrId) traverseStaticChildren(n1, n2);
            else if (// #2080 if the stable fragment has a key, it's a <template v-for> that may
            //  get moved around. Make sure all root level vnodes inherit el.
            // #2134 or if it's a component root, it may also get moved around
            // as the component is being moved.
            n2.key != null || parentComponent && n2 === parentComponent.subTree) traverseStaticChildren(n1, n2, true);
        } else // keyed / unkeyed, or manual fragments.
        // for keyed & unkeyed, since they are compiler generated from v-for,
        // each child is guaranteed to be a block so the fragment will never
        // have dynamicChildren.
        patchChildren(n1, n2, container, fragmentEndAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
    };
    const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        n2.slotScopeIds = slotScopeIds;
        if (n1 == null) {
            if (n2.shapeFlag & 512 /* ShapeFlags.COMPONENT_KEPT_ALIVE */ ) parentComponent.ctx.activate(n2, container, anchor, isSVG, optimized);
            else mountComponent(n2, container, anchor, parentComponent, parentSuspense, isSVG, optimized);
        } else updateComponent(n1, n2, optimized);
    };
    const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, isSVG, optimized)=>{
        const instance = initialVNode.component = createComponentInstance(initialVNode, parentComponent, parentSuspense);
        if (0, instance.type.__hmrId) registerHMR(instance);
        pushWarningContext(initialVNode);
        startMeasure(instance, `mount`);
        // inject renderer internals for keepAlive
        if (isKeepAlive(initialVNode)) instance.ctx.renderer = internals;
        startMeasure(instance, `init`);
        setupComponent(instance);
        endMeasure(instance, `init`);
        // setup() is async. This component relies on async logic to be resolved
        // before proceeding
        if (instance.asyncDep) {
            parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect);
            // Give it a placeholder if this is not hydration
            // TODO handle self-defined fallback
            if (!initialVNode.el) {
                const placeholder = instance.subTree = createVNode(Comment);
                processCommentNode(null, placeholder, container, anchor);
            }
            return;
        }
        setupRenderEffect(instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized);
        popWarningContext();
        endMeasure(instance, `mount`);
    };
    const updateComponent = (n1, n2, optimized)=>{
        const instance = n2.component = n1.component;
        if (shouldUpdateComponent(n1, n2, optimized)) {
            if (instance.asyncDep && !instance.asyncResolved) {
                pushWarningContext(n2);
                updateComponentPreRender(instance, n2, optimized);
                popWarningContext();
                return;
            } else {
                // normal update
                instance.next = n2;
                // in case the child component is also queued, remove it to avoid
                // double updating the same child component in the same flush.
                invalidateJob(instance.update);
                // instance.update is the reactive effect.
                instance.update();
            }
        } else {
            // no update needed. just copy over properties
            n2.el = n1.el;
            instance.vnode = n2;
        }
    };
    const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, isSVG, optimized)=>{
        const componentUpdateFn = ()=>{
            if (!instance.isMounted) {
                let vnodeHook;
                const { el , props  } = initialVNode;
                const { bm , m , parent  } = instance;
                const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
                toggleRecurse(instance, false);
                // beforeMount hook
                if (bm) (0, _shared.invokeArrayFns)(bm);
                // onVnodeBeforeMount
                if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) invokeVNodeHook(vnodeHook, parent, initialVNode);
                toggleRecurse(instance, true);
                if (el && hydrateNode) {
                    // vnode has adopted host node - perform hydration instead of mount.
                    const hydrateSubTree = ()=>{
                        startMeasure(instance, `render`);
                        instance.subTree = renderComponentRoot(instance);
                        endMeasure(instance, `render`);
                        startMeasure(instance, `hydrate`);
                        hydrateNode(el, instance.subTree, instance, parentSuspense, null);
                        endMeasure(instance, `hydrate`);
                    };
                    if (isAsyncWrapperVNode) initialVNode.type.__asyncLoader().then(// note: we are moving the render call into an async callback,
                    // which means it won't track dependencies - but it's ok because
                    // a server-rendered async wrapper is already in resolved state
                    // and it will never need to change.
                    ()=>!instance.isUnmounted && hydrateSubTree());
                    else hydrateSubTree();
                } else {
                    startMeasure(instance, `render`);
                    const subTree = instance.subTree = renderComponentRoot(instance);
                    endMeasure(instance, `render`);
                    startMeasure(instance, `patch`);
                    patch(null, subTree, container, anchor, instance, parentSuspense, isSVG);
                    endMeasure(instance, `patch`);
                    initialVNode.el = subTree.el;
                }
                // mounted hook
                if (m) queuePostRenderEffect(m, parentSuspense);
                // onVnodeMounted
                if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
                    const scopedInitialVNode = initialVNode;
                    queuePostRenderEffect(()=>invokeVNodeHook(vnodeHook, parent, scopedInitialVNode), parentSuspense);
                }
                // activated hook for keep-alive roots.
                // #1742 activated hook must be accessed after first render
                // since the hook may be injected by a child keep-alive
                if (initialVNode.shapeFlag & 256 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */  || parent && isAsyncWrapper(parent.vnode) && parent.vnode.shapeFlag & 256 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */ ) instance.a && queuePostRenderEffect(instance.a, parentSuspense);
                instance.isMounted = true;
                devtoolsComponentAdded(instance);
                // #2458: deference mount-only object parameters to prevent memleaks
                initialVNode = container = anchor = null;
            } else {
                // updateComponent
                // This is triggered by mutation of component's own state (next: null)
                // OR parent calling processComponent (next: VNode)
                let { next , bu , u , parent , vnode  } = instance;
                let originNext = next;
                let vnodeHook;
                pushWarningContext(next || instance.vnode);
                // Disallow component effect recursion during pre-lifecycle hooks.
                toggleRecurse(instance, false);
                if (next) {
                    next.el = vnode.el;
                    updateComponentPreRender(instance, next, optimized);
                } else next = vnode;
                // beforeUpdate hook
                if (bu) (0, _shared.invokeArrayFns)(bu);
                // onVnodeBeforeUpdate
                if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) invokeVNodeHook(vnodeHook, parent, next, vnode);
                toggleRecurse(instance, true);
                startMeasure(instance, `render`);
                const nextTree = renderComponentRoot(instance);
                endMeasure(instance, `render`);
                const prevTree = instance.subTree;
                instance.subTree = nextTree;
                startMeasure(instance, `patch`);
                patch(prevTree, nextTree, // parent may have changed if it's in a teleport
                hostParentNode(prevTree.el), // anchor may have changed if it's in a fragment
                getNextHostNode(prevTree), instance, parentSuspense, isSVG);
                endMeasure(instance, `patch`);
                next.el = nextTree.el;
                if (originNext === null) // self-triggered update. In case of HOC, update parent component
                // vnode el. HOC is indicated by parent instance's subTree pointing
                // to child component's vnode
                updateHOCHostEl(instance, nextTree.el);
                // updated hook
                if (u) queuePostRenderEffect(u, parentSuspense);
                // onVnodeUpdated
                if (vnodeHook = next.props && next.props.onVnodeUpdated) queuePostRenderEffect(()=>invokeVNodeHook(vnodeHook, parent, next, vnode), parentSuspense);
                devtoolsComponentUpdated(instance);
                popWarningContext();
            }
        };
        // create reactive effect for rendering
        const effect = instance.effect = new (0, _reactivity.ReactiveEffect)(componentUpdateFn, ()=>queueJob(update), instance.scope // track it in component's effect scope
        );
        const update = instance.update = ()=>effect.run();
        update.id = instance.uid;
        // allowRecurse
        // #1801, #2043 component render effects should allow recursive updates
        toggleRecurse(instance, true);
        effect.onTrack = instance.rtc ? (e)=>(0, _shared.invokeArrayFns)(instance.rtc, e) : void 0;
        effect.onTrigger = instance.rtg ? (e)=>(0, _shared.invokeArrayFns)(instance.rtg, e) : void 0;
        update.ownerInstance = instance;
        update();
    };
    const updateComponentPreRender = (instance, nextVNode, optimized)=>{
        nextVNode.component = instance;
        const prevProps = instance.vnode.props;
        instance.vnode = nextVNode;
        instance.next = null;
        updateProps(instance, nextVNode.props, prevProps, optimized);
        updateSlots(instance, nextVNode.children, optimized);
        (0, _reactivity.pauseTracking)();
        // props update may have triggered pre-flush watchers.
        // flush them before the render update.
        flushPreFlushCbs();
        (0, _reactivity.resetTracking)();
    };
    const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized = false)=>{
        const c1 = n1 && n1.children;
        const prevShapeFlag = n1 ? n1.shapeFlag : 0;
        const c2 = n2.children;
        const { patchFlag , shapeFlag  } = n2;
        // fast path
        if (patchFlag > 0) {
            if (patchFlag & 128 /* PatchFlags.KEYED_FRAGMENT */ ) {
                // this could be either fully-keyed or mixed (some keyed some not)
                // presence of patchFlag means children are guaranteed to be arrays
                patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                return;
            } else if (patchFlag & 256 /* PatchFlags.UNKEYED_FRAGMENT */ ) {
                // unkeyed
                patchUnkeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                return;
            }
        }
        // children has 3 possibilities: text, array or no children.
        if (shapeFlag & 8 /* ShapeFlags.TEXT_CHILDREN */ ) {
            // text children fast path
            if (prevShapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) unmountChildren(c1, parentComponent, parentSuspense);
            if (c2 !== c1) hostSetElementText(container, c2);
        } else if (prevShapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) {
            // prev children was array
            if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) // two arrays, cannot assume anything, do full diff
            patchKeyedChildren(c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
            else // no new children, just unmount old
            unmountChildren(c1, parentComponent, parentSuspense, true);
        } else {
            // prev children was text OR null
            // new children is array OR null
            if (prevShapeFlag & 8 /* ShapeFlags.TEXT_CHILDREN */ ) hostSetElementText(container, "");
            // mount new if array
            if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
    };
    const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        c1 = c1 || (0, _shared.EMPTY_ARR);
        c2 = c2 || (0, _shared.EMPTY_ARR);
        const oldLength = c1.length;
        const newLength = c2.length;
        const commonLength = Math.min(oldLength, newLength);
        let i;
        for(i = 0; i < commonLength; i++){
            const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
            patch(c1[i], nextChild, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
        }
        if (oldLength > newLength) // remove old
        unmountChildren(c1, parentComponent, parentSuspense, true, false, commonLength);
        else // mount new
        mountChildren(c2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, commonLength);
    };
    // can be all-keyed or mixed
    const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized)=>{
        let i = 0;
        const l2 = c2.length;
        let e1 = c1.length - 1; // prev ending index
        let e2 = l2 - 1; // next ending index
        // 1. sync from start
        // (a b) c
        // (a b) d e
        while(i <= e1 && i <= e2){
            const n1 = c1[i];
            const n2 = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
            if (isSameVNodeType(n1, n2)) patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
            else break;
            i++;
        }
        // 2. sync from end
        // a (b c)
        // d e (b c)
        while(i <= e1 && i <= e2){
            const n1 = c1[e1];
            const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
            if (isSameVNodeType(n1, n2)) patch(n1, n2, container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
            else break;
            e1--;
            e2--;
        }
        // 3. common sequence + mount
        // (a b)
        // (a b) c
        // i = 2, e1 = 1, e2 = 2
        // (a b)
        // c (a b)
        // i = 0, e1 = -1, e2 = 0
        if (i > e1) {
            if (i <= e2) {
                const nextPos = e2 + 1;
                const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
                while(i <= e2){
                    patch(null, c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]), container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                    i++;
                }
            }
        } else if (i > e2) while(i <= e1){
            unmount(c1[i], parentComponent, parentSuspense, true);
            i++;
        }
        else {
            const s1 = i; // prev starting index
            const s2 = i; // next starting index
            // 5.1 build key:index map for newChildren
            const keyToNewIndexMap = new Map();
            for(i = s2; i <= e2; i++){
                const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
                if (nextChild.key != null) {
                    if (keyToNewIndexMap.has(nextChild.key)) warn(`Duplicate keys found during update:`, JSON.stringify(nextChild.key), `Make sure keys are unique.`);
                    keyToNewIndexMap.set(nextChild.key, i);
                }
            }
            // 5.2 loop through old children left to be patched and try to patch
            // matching nodes & remove nodes that are no longer present
            let j;
            let patched = 0;
            const toBePatched = e2 - s2 + 1;
            let moved = false;
            // used to track whether any node has moved
            let maxNewIndexSoFar = 0;
            // works as Map<newIndex, oldIndex>
            // Note that oldIndex is offset by +1
            // and oldIndex = 0 is a special value indicating the new node has
            // no corresponding old node.
            // used for determining longest stable subsequence
            const newIndexToOldIndexMap = new Array(toBePatched);
            for(i = 0; i < toBePatched; i++)newIndexToOldIndexMap[i] = 0;
            for(i = s1; i <= e1; i++){
                const prevChild = c1[i];
                if (patched >= toBePatched) {
                    // all new children have been patched so this can only be a removal
                    unmount(prevChild, parentComponent, parentSuspense, true);
                    continue;
                }
                let newIndex;
                if (prevChild.key != null) newIndex = keyToNewIndexMap.get(prevChild.key);
                else {
                    // key-less node, try to locate a key-less node of the same type
                    for(j = s2; j <= e2; j++)if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
                        newIndex = j;
                        break;
                    }
                }
                if (newIndex === undefined) unmount(prevChild, parentComponent, parentSuspense, true);
                else {
                    newIndexToOldIndexMap[newIndex - s2] = i + 1;
                    if (newIndex >= maxNewIndexSoFar) maxNewIndexSoFar = newIndex;
                    else moved = true;
                    patch(prevChild, c2[newIndex], container, null, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                    patched++;
                }
            }
            // 5.3 move and mount
            // generate longest stable subsequence only when nodes have moved
            const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : (0, _shared.EMPTY_ARR);
            j = increasingNewIndexSequence.length - 1;
            // looping backwards so that we can use last patched node as anchor
            for(i = toBePatched - 1; i >= 0; i--){
                const nextIndex = s2 + i;
                const nextChild = c2[nextIndex];
                const anchor = nextIndex + 1 < l2 ? c2[nextIndex + 1].el : parentAnchor;
                if (newIndexToOldIndexMap[i] === 0) // mount new
                patch(null, nextChild, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
                else if (moved) {
                    // move if:
                    // There is no stable subsequence (e.g. a reverse)
                    // OR current node is not among the stable sequence
                    if (j < 0 || i !== increasingNewIndexSequence[j]) move(nextChild, container, anchor, 2 /* MoveType.REORDER */ );
                    else j--;
                }
            }
        }
    };
    const move = (vnode, container, anchor, moveType, parentSuspense = null)=>{
        const { el , type , transition , children , shapeFlag  } = vnode;
        if (shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) {
            move(vnode.component.subTree, container, anchor, moveType);
            return;
        }
        if (shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) {
            vnode.suspense.move(container, anchor, moveType);
            return;
        }
        if (shapeFlag & 64 /* ShapeFlags.TELEPORT */ ) {
            type.move(vnode, container, anchor, internals);
            return;
        }
        if (type === Fragment) {
            hostInsert(el, container, anchor);
            for(let i = 0; i < children.length; i++)move(children[i], container, anchor, moveType);
            hostInsert(vnode.anchor, container, anchor);
            return;
        }
        if (type === Static) {
            moveStaticNode(vnode, container, anchor);
            return;
        }
        // single nodes
        const needTransition = moveType !== 2 /* MoveType.REORDER */  && shapeFlag & 1 /* ShapeFlags.ELEMENT */  && transition;
        if (needTransition) {
            if (moveType === 0 /* MoveType.ENTER */ ) {
                transition.beforeEnter(el);
                hostInsert(el, container, anchor);
                queuePostRenderEffect(()=>transition.enter(el), parentSuspense);
            } else {
                const { leave , delayLeave , afterLeave  } = transition;
                const remove = ()=>hostInsert(el, container, anchor);
                const performLeave = ()=>{
                    leave(el, ()=>{
                        remove();
                        afterLeave && afterLeave();
                    });
                };
                if (delayLeave) delayLeave(el, remove, performLeave);
                else performLeave();
            }
        } else hostInsert(el, container, anchor);
    };
    const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false)=>{
        const { type , props , ref , children , dynamicChildren , shapeFlag , patchFlag , dirs  } = vnode;
        // unset ref
        if (ref != null) setRef(ref, null, parentSuspense, vnode, true);
        if (shapeFlag & 256 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */ ) {
            parentComponent.ctx.deactivate(vnode);
            return;
        }
        const shouldInvokeDirs = shapeFlag & 1 /* ShapeFlags.ELEMENT */  && dirs;
        const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
        let vnodeHook;
        if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) invokeVNodeHook(vnodeHook, parentComponent, vnode);
        if (shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) unmountComponent(vnode.component, parentSuspense, doRemove);
        else {
            if (shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) {
                vnode.suspense.unmount(parentSuspense, doRemove);
                return;
            }
            if (shouldInvokeDirs) invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
            if (shapeFlag & 64 /* ShapeFlags.TELEPORT */ ) vnode.type.remove(vnode, parentComponent, parentSuspense, optimized, internals, doRemove);
            else if (dynamicChildren && // #1153: fast path should not be taken for non-stable (v-for) fragments
            (type !== Fragment || patchFlag > 0 && patchFlag & 64 /* PatchFlags.STABLE_FRAGMENT */ )) // fast path for block nodes: only need to unmount dynamic children.
            unmountChildren(dynamicChildren, parentComponent, parentSuspense, false, true);
            else if (type === Fragment && patchFlag & 384 /* PatchFlags.UNKEYED_FRAGMENT */  || !optimized && shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) unmountChildren(children, parentComponent, parentSuspense);
            if (doRemove) remove(vnode);
        }
        if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) queuePostRenderEffect(()=>{
            vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
            shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
        }, parentSuspense);
    };
    const remove = (vnode)=>{
        const { type , el , anchor , transition  } = vnode;
        if (type === Fragment) {
            if (vnode.patchFlag > 0 && vnode.patchFlag & 2048 /* PatchFlags.DEV_ROOT_FRAGMENT */  && transition && !transition.persisted) vnode.children.forEach((child)=>{
                if (child.type === Comment) hostRemove(child.el);
                else remove(child);
            });
            else removeFragment(el, anchor);
            return;
        }
        if (type === Static) {
            removeStaticNode(vnode);
            return;
        }
        const performRemove = ()=>{
            hostRemove(el);
            if (transition && !transition.persisted && transition.afterLeave) transition.afterLeave();
        };
        if (vnode.shapeFlag & 1 /* ShapeFlags.ELEMENT */  && transition && !transition.persisted) {
            const { leave , delayLeave  } = transition;
            const performLeave = ()=>leave(el, performRemove);
            if (delayLeave) delayLeave(vnode.el, performRemove, performLeave);
            else performLeave();
        } else performRemove();
    };
    const removeFragment = (cur, end)=>{
        // For fragments, directly remove all contained DOM nodes.
        // (fragment child nodes cannot have transition)
        let next;
        while(cur !== end){
            next = hostNextSibling(cur);
            hostRemove(cur);
            cur = next;
        }
        hostRemove(end);
    };
    const unmountComponent = (instance, parentSuspense, doRemove)=>{
        if (0, instance.type.__hmrId) unregisterHMR(instance);
        const { bum , scope , update , subTree , um  } = instance;
        // beforeUnmount hook
        if (bum) (0, _shared.invokeArrayFns)(bum);
        // stop effects in component scope
        scope.stop();
        // update may be null if a component is unmounted before its async
        // setup has resolved.
        if (update) {
            // so that scheduler will no longer invoke it
            update.active = false;
            unmount(subTree, instance, parentSuspense, doRemove);
        }
        // unmounted hook
        if (um) queuePostRenderEffect(um, parentSuspense);
        queuePostRenderEffect(()=>{
            instance.isUnmounted = true;
        }, parentSuspense);
        // A component with async dep inside a pending suspense is unmounted before
        // its async dep resolves. This should remove the dep from the suspense, and
        // cause the suspense to resolve immediately if that was the last dep.
        if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
            parentSuspense.deps--;
            if (parentSuspense.deps === 0) parentSuspense.resolve();
        }
        devtoolsComponentRemoved(instance);
    };
    const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0)=>{
        for(let i = start; i < children.length; i++)unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);
    };
    const getNextHostNode = (vnode)=>{
        if (vnode.shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) return getNextHostNode(vnode.component.subTree);
        if (vnode.shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) return vnode.suspense.next();
        return hostNextSibling(vnode.anchor || vnode.el);
    };
    const render = (vnode, container, isSVG)=>{
        if (vnode == null) {
            if (container._vnode) unmount(container._vnode, null, null, true);
        } else patch(container._vnode || null, vnode, container, null, null, null, isSVG);
        flushPreFlushCbs();
        flushPostFlushCbs();
        container._vnode = vnode;
    };
    const internals = {
        p: patch,
        um: unmount,
        m: move,
        r: remove,
        mt: mountComponent,
        mc: mountChildren,
        pc: patchChildren,
        pbc: patchBlockChildren,
        n: getNextHostNode,
        o: options
    };
    let hydrate;
    let hydrateNode;
    if (createHydrationFns) [hydrate, hydrateNode] = createHydrationFns(internals);
    return {
        render,
        hydrate,
        createApp: createAppAPI(render, hydrate)
    };
}
function toggleRecurse({ effect , update  }, allowed) {
    effect.allowRecurse = update.allowRecurse = allowed;
}
/**
 * #1156
 * When a component is HMR-enabled, we need to make sure that all static nodes
 * inside a block also inherit the DOM element from the previous tree so that
 * HMR updates (which are full updates) can retrieve the element for patching.
 *
 * #2080
 * Inside keyed `template` fragment static children, if a fragment is moved,
 * the children will always be moved. Therefore, in order to ensure correct move
 * position, el should be inherited from previous nodes.
 */ function traverseStaticChildren(n1, n2, shallow = false) {
    const ch1 = n1.children;
    const ch2 = n2.children;
    if ((0, _shared.isArray)(ch1) && (0, _shared.isArray)(ch2)) for(let i = 0; i < ch1.length; i++){
        // this is only called in the optimized path so array children are
        // guaranteed to be vnodes
        const c1 = ch1[i];
        let c2 = ch2[i];
        if (c2.shapeFlag & 1 /* ShapeFlags.ELEMENT */  && !c2.dynamicChildren) {
            if (c2.patchFlag <= 0 || c2.patchFlag === 32 /* PatchFlags.HYDRATE_EVENTS */ ) {
                c2 = ch2[i] = cloneIfMounted(ch2[i]);
                c2.el = c1.el;
            }
            if (!shallow) traverseStaticChildren(c1, c2);
        }
        // #6852 also inherit for text nodes
        if (c2.type === Text) c2.el = c1.el;
        // also inherit for comment nodes, but not placeholders (e.g. v-if which
        // would have received .el during block patch)
        if (c2.type === Comment && !c2.el) c2.el = c1.el;
    }
}
// https://en.wikipedia.org/wiki/Longest_increasing_subsequence
function getSequence(arr) {
    const p = arr.slice();
    const result = [
        0
    ];
    let i, j, u, v1, c;
    const len = arr.length;
    for(i = 0; i < len; i++){
        const arrI = arr[i];
        if (arrI !== 0) {
            j = result[result.length - 1];
            if (arr[j] < arrI) {
                p[i] = j;
                result.push(i);
                continue;
            }
            u = 0;
            v1 = result.length - 1;
            while(u < v1){
                c = u + v1 >> 1;
                if (arr[result[c]] < arrI) u = c + 1;
                else v1 = c;
            }
            if (arrI < arr[result[u]]) {
                if (u > 0) p[i] = result[u - 1];
                result[u] = i;
            }
        }
    }
    u = result.length;
    v1 = result[u - 1];
    while(u-- > 0){
        result[u] = v1;
        v1 = p[v1];
    }
    return result;
}
const isTeleport = (type)=>type.__isTeleport;
const isTeleportDisabled = (props)=>props && (props.disabled || props.disabled === "");
const isTargetSVG = (target)=>typeof SVGElement !== "undefined" && target instanceof SVGElement;
const resolveTarget = (props, select)=>{
    const targetSelector = props && props.to;
    if ((0, _shared.isString)(targetSelector)) {
        if (!select) {
            warn(`Current renderer does not support string target for Teleports. ` + `(missing querySelector renderer option)`);
            return null;
        } else {
            const target = select(targetSelector);
            if (!target) warn(`Failed to locate Teleport target with selector "${targetSelector}". ` + `Note the target element must exist before the component is mounted - ` + `i.e. the target cannot be rendered by the component itself, and ` + `ideally should be outside of the entire Vue component tree.`);
            return target;
        }
    } else {
        if (!targetSelector && !isTeleportDisabled(props)) warn(`Invalid Teleport target: ${targetSelector}`);
        return targetSelector;
    }
};
const TeleportImpl = {
    __isTeleport: true,
    process (n1, n2, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized, internals) {
        const { mc: mountChildren , pc: patchChildren , pbc: patchBlockChildren , o: { insert , querySelector , createText , createComment  }  } = internals;
        const disabled = isTeleportDisabled(n2.props);
        let { shapeFlag , children , dynamicChildren  } = n2;
        // #3302
        // HMR updated, force full diff
        if (isHmrUpdating) {
            optimized = false;
            dynamicChildren = null;
        }
        if (n1 == null) {
            // insert anchors in the main view
            const placeholder = n2.el = createComment("teleport start");
            const mainAnchor = n2.anchor = createComment("teleport end");
            insert(placeholder, container, anchor);
            insert(mainAnchor, container, anchor);
            const target = n2.target = resolveTarget(n2.props, querySelector);
            const targetAnchor = n2.targetAnchor = createText("");
            if (target) {
                insert(targetAnchor, target);
                // #2652 we could be teleporting from a non-SVG tree into an SVG tree
                isSVG = isSVG || isTargetSVG(target);
            } else if (!disabled) warn("Invalid Teleport target on mount:", target, `(${typeof target})`);
            const mount = (container, anchor)=>{
                // Teleport *always* has Array children. This is enforced in both the
                // compiler and vnode children normalization.
                if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) mountChildren(children, container, anchor, parentComponent, parentSuspense, isSVG, slotScopeIds, optimized);
            };
            if (disabled) mount(container, mainAnchor);
            else if (target) mount(target, targetAnchor);
        } else {
            // update content
            n2.el = n1.el;
            const mainAnchor = n2.anchor = n1.anchor;
            const target = n2.target = n1.target;
            const targetAnchor = n2.targetAnchor = n1.targetAnchor;
            const wasDisabled = isTeleportDisabled(n1.props);
            const currentContainer = wasDisabled ? container : target;
            const currentAnchor = wasDisabled ? mainAnchor : targetAnchor;
            isSVG = isSVG || isTargetSVG(target);
            if (dynamicChildren) {
                // fast path when the teleport happens to be a block root
                patchBlockChildren(n1.dynamicChildren, dynamicChildren, currentContainer, parentComponent, parentSuspense, isSVG, slotScopeIds);
                // even in block tree mode we need to make sure all root-level nodes
                // in the teleport inherit previous DOM references so that they can
                // be moved in future patches.
                traverseStaticChildren(n1, n2, true);
            } else if (!optimized) patchChildren(n1, n2, currentContainer, currentAnchor, parentComponent, parentSuspense, isSVG, slotScopeIds, false);
            if (disabled) {
                if (!wasDisabled) // enabled -> disabled
                // move into main container
                moveTeleport(n2, container, mainAnchor, internals, 1 /* TeleportMoveTypes.TOGGLE */ );
            } else {
                // target changed
                if ((n2.props && n2.props.to) !== (n1.props && n1.props.to)) {
                    const nextTarget = n2.target = resolveTarget(n2.props, querySelector);
                    if (nextTarget) moveTeleport(n2, nextTarget, null, internals, 0 /* TeleportMoveTypes.TARGET_CHANGE */ );
                    else warn("Invalid Teleport target on update:", target, `(${typeof target})`);
                } else if (wasDisabled) // disabled -> enabled
                // move into teleport target
                moveTeleport(n2, target, targetAnchor, internals, 1 /* TeleportMoveTypes.TOGGLE */ );
            }
        }
        updateCssVars(n2);
    },
    remove (vnode, parentComponent, parentSuspense, optimized, { um: unmount , o: { remove: hostRemove  }  }, doRemove) {
        const { shapeFlag , children , anchor , targetAnchor , target , props  } = vnode;
        if (target) hostRemove(targetAnchor);
        // an unmounted teleport should always remove its children if not disabled
        if (doRemove || !isTeleportDisabled(props)) {
            hostRemove(anchor);
            if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) for(let i = 0; i < children.length; i++){
                const child = children[i];
                unmount(child, parentComponent, parentSuspense, true, !!child.dynamicChildren);
            }
        }
    },
    move: moveTeleport,
    hydrate: hydrateTeleport
};
function moveTeleport(vnode, container, parentAnchor, { o: { insert  } , m: move  }, moveType = 2 /* TeleportMoveTypes.REORDER */ ) {
    // move target anchor if this is a target change.
    if (moveType === 0 /* TeleportMoveTypes.TARGET_CHANGE */ ) insert(vnode.targetAnchor, container, parentAnchor);
    const { el , anchor , shapeFlag , children , props  } = vnode;
    const isReorder = moveType === 2 /* TeleportMoveTypes.REORDER */ ;
    // move main view anchor if this is a re-order.
    if (isReorder) insert(el, container, parentAnchor);
    // if this is a re-order and teleport is enabled (content is in target)
    // do not move children. So the opposite is: only move children if this
    // is not a reorder, or the teleport is disabled
    if (!isReorder || isTeleportDisabled(props)) {
        // Teleport has either Array children or no children.
        if (shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) for(let i = 0; i < children.length; i++)move(children[i], container, parentAnchor, 2 /* MoveType.REORDER */ );
    }
    // move main view anchor if this is a re-order.
    if (isReorder) insert(anchor, container, parentAnchor);
}
function hydrateTeleport(node, vnode, parentComponent, parentSuspense, slotScopeIds, optimized, { o: { nextSibling , parentNode , querySelector  }  }, hydrateChildren) {
    const target = vnode.target = resolveTarget(vnode.props, querySelector);
    if (target) {
        // if multiple teleports rendered to the same target element, we need to
        // pick up from where the last teleport finished instead of the first node
        const targetNode = target._lpa || target.firstChild;
        if (vnode.shapeFlag & 16 /* ShapeFlags.ARRAY_CHILDREN */ ) {
            if (isTeleportDisabled(vnode.props)) {
                vnode.anchor = hydrateChildren(nextSibling(node), vnode, parentNode(node), parentComponent, parentSuspense, slotScopeIds, optimized);
                vnode.targetAnchor = targetNode;
            } else {
                vnode.anchor = nextSibling(node);
                // lookahead until we find the target anchor
                // we cannot rely on return value of hydrateChildren() because there
                // could be nested teleports
                let targetAnchor = targetNode;
                while(targetAnchor){
                    targetAnchor = nextSibling(targetAnchor);
                    if (targetAnchor && targetAnchor.nodeType === 8 && targetAnchor.data === "teleport anchor") {
                        vnode.targetAnchor = targetAnchor;
                        target._lpa = vnode.targetAnchor && nextSibling(vnode.targetAnchor);
                        break;
                    }
                }
                hydrateChildren(targetNode, vnode, target, parentComponent, parentSuspense, slotScopeIds, optimized);
            }
        }
        updateCssVars(vnode);
    }
    return vnode.anchor && nextSibling(vnode.anchor);
}
// Force-casted public typing for h and TSX props inference
const Teleport = TeleportImpl;
function updateCssVars(vnode) {
    // presence of .ut method indicates owner component uses css vars.
    // code path here can assume browser environment.
    const ctx = vnode.ctx;
    if (ctx && ctx.ut) {
        let node = vnode.children[0].el;
        while(node !== vnode.targetAnchor){
            if (node.nodeType === 1) node.setAttribute("data-v-owner", ctx.uid);
            node = node.nextSibling;
        }
        ctx.ut();
    }
}
const Fragment = Symbol("Fragment");
const Text = Symbol("Text");
const Comment = Symbol("Comment");
const Static = Symbol("Static");
// Since v-if and v-for are the two possible ways node structure can dynamically
// change, once we consider v-if branches and each v-for fragment a block, we
// can divide a template into nested blocks, and within each block the node
// structure would be stable. This allows us to skip most children diffing
// and only worry about the dynamic nodes (indicated by patch flags).
const blockStack = [];
let currentBlock = null;
/**
 * Open a block.
 * This must be called before `createBlock`. It cannot be part of `createBlock`
 * because the children of the block are evaluated before `createBlock` itself
 * is called. The generated code typically looks like this:
 *
 * ```js
 * function render() {
 *   return (openBlock(),createBlock('div', null, [...]))
 * }
 * ```
 * disableTracking is true when creating a v-for fragment block, since a v-for
 * fragment always diffs its children.
 *
 * @private
 */ function openBlock(disableTracking = false) {
    blockStack.push(currentBlock = disableTracking ? null : []);
}
function closeBlock() {
    blockStack.pop();
    currentBlock = blockStack[blockStack.length - 1] || null;
}
// Whether we should be tracking dynamic child nodes inside a block.
// Only tracks when this value is > 0
// We are not using a simple boolean because this value may need to be
// incremented/decremented by nested usage of v-once (see below)
let isBlockTreeEnabled = 1;
/**
 * Block tracking sometimes needs to be disabled, for example during the
 * creation of a tree that needs to be cached by v-once. The compiler generates
 * code like this:
 *
 * ``` js
 * _cache[1] || (
 *   setBlockTracking(-1),
 *   _cache[1] = createVNode(...),
 *   setBlockTracking(1),
 *   _cache[1]
 * )
 * ```
 *
 * @private
 */ function setBlockTracking(value) {
    isBlockTreeEnabled += value;
}
function setupBlock(vnode) {
    // save current block children on the block vnode
    vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || (0, _shared.EMPTY_ARR) : null;
    // close block
    closeBlock();
    // a block is always going to be patched, so track it as a child of its
    // parent block
    if (isBlockTreeEnabled > 0 && currentBlock) currentBlock.push(vnode);
    return vnode;
}
/**
 * @private
 */ function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
    return setupBlock(createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, true));
}
/**
 * Create a block root vnode. Takes the same exact arguments as `createVNode`.
 * A block root keeps track of dynamic nodes within the block in the
 * `dynamicChildren` array.
 *
 * @private
 */ function createBlock(type, props, children, patchFlag, dynamicProps) {
    return setupBlock(createVNode(type, props, children, patchFlag, dynamicProps, true));
}
function isVNode(value) {
    return value ? value.__v_isVNode === true : false;
}
function isSameVNodeType(n1, n2) {
    if (n2.shapeFlag & 6 /* ShapeFlags.COMPONENT */  && hmrDirtyComponents.has(n2.type)) {
        // #7042, ensure the vnode being unmounted during HMR
        // bitwise operations to remove keep alive flags
        n1.shapeFlag &= -257 /* ShapeFlags.COMPONENT_SHOULD_KEEP_ALIVE */ ;
        n2.shapeFlag &= -513 /* ShapeFlags.COMPONENT_KEPT_ALIVE */ ;
        // HMR only: if the component has been hot-updated, force a reload.
        return false;
    }
    return n1.type === n2.type && n1.key === n2.key;
}
let vnodeArgsTransformer;
/**
 * Internal API for registering an arguments transform for createVNode
 * used for creating stubs in the test-utils
 * It is *internal* but needs to be exposed for test-utils to pick up proper
 * typings
 */ function transformVNodeArgs(transformer) {
    vnodeArgsTransformer = transformer;
}
const createVNodeWithArgsTransform = (...args)=>{
    return _createVNode(...vnodeArgsTransformer ? vnodeArgsTransformer(args, currentRenderingInstance) : args);
};
const InternalObjectKey = `__vInternal`;
const normalizeKey = ({ key  })=>key != null ? key : null;
const normalizeRef = ({ ref , ref_key , ref_for  })=>{
    return ref != null ? (0, _shared.isString)(ref) || (0, _reactivity.isRef)(ref) || (0, _shared.isFunction)(ref) ? {
        i: currentRenderingInstance,
        r: ref,
        k: ref_key,
        f: !!ref_for
    } : ref : null;
};
function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1 /* ShapeFlags.ELEMENT */ , isBlockNode = false, needFullChildrenNormalization = false) {
    const vnode = {
        __v_isVNode: true,
        __v_skip: true,
        type,
        props,
        key: props && normalizeKey(props),
        ref: props && normalizeRef(props),
        scopeId: currentScopeId,
        slotScopeIds: null,
        children,
        component: null,
        suspense: null,
        ssContent: null,
        ssFallback: null,
        dirs: null,
        transition: null,
        el: null,
        anchor: null,
        target: null,
        targetAnchor: null,
        staticCount: 0,
        shapeFlag,
        patchFlag,
        dynamicProps,
        dynamicChildren: null,
        appContext: null,
        ctx: currentRenderingInstance
    };
    if (needFullChildrenNormalization) {
        normalizeChildren(vnode, children);
        // normalize suspense children
        if (shapeFlag & 128 /* ShapeFlags.SUSPENSE */ ) type.normalize(vnode);
    } else if (children) // compiled element vnode - if children is passed, only possible types are
    // string or Array.
    vnode.shapeFlag |= (0, _shared.isString)(children) ? 8 /* ShapeFlags.TEXT_CHILDREN */  : 16 /* ShapeFlags.ARRAY_CHILDREN */ ;
    // validate key
    if (vnode.key !== vnode.key) warn(`VNode created with invalid key (NaN). VNode type:`, vnode.type);
    // track vnode for block tree
    if (isBlockTreeEnabled > 0 && // avoid a block node from tracking itself
    !isBlockNode && // has current parent block
    currentBlock && // presence of a patch flag indicates this node needs patching on updates.
    // component nodes also should always be patched, because even if the
    // component doesn't need to update, it needs to persist the instance on to
    // the next vnode so that it can be properly unmounted later.
    (vnode.patchFlag > 0 || shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) && // the EVENTS flag is only for hydration and if it is the only flag, the
    // vnode should not be considered dynamic due to handler caching.
    vnode.patchFlag !== 32 /* PatchFlags.HYDRATE_EVENTS */ ) currentBlock.push(vnode);
    return vnode;
}
const createVNode = createVNodeWithArgsTransform;
function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
    if (!type || type === NULL_DYNAMIC_COMPONENT) {
        if (!type) warn(`Invalid vnode type when creating vnode: ${type}.`);
        type = Comment;
    }
    if (isVNode(type)) {
        // createVNode receiving an existing vnode. This happens in cases like
        // <component :is="vnode"/>
        // #2078 make sure to merge refs during the clone instead of overwriting it
        const cloned = cloneVNode(type, props, true);
        if (children) normalizeChildren(cloned, children);
        if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock) {
            if (cloned.shapeFlag & 6 /* ShapeFlags.COMPONENT */ ) currentBlock[currentBlock.indexOf(type)] = cloned;
            else currentBlock.push(cloned);
        }
        cloned.patchFlag |= -2 /* PatchFlags.BAIL */ ;
        return cloned;
    }
    // class component normalization.
    if (isClassComponent(type)) type = type.__vccOpts;
    // class & style normalization.
    if (props) {
        // for reactive or proxy objects, we need to clone it to enable mutation.
        props = guardReactiveProps(props);
        let { class: klass , style  } = props;
        if (klass && !(0, _shared.isString)(klass)) props.class = (0, _shared.normalizeClass)(klass);
        if ((0, _shared.isObject)(style)) {
            // reactive state objects need to be cloned since they are likely to be
            // mutated
            if ((0, _reactivity.isProxy)(style) && !(0, _shared.isArray)(style)) style = (0, _shared.extend)({}, style);
            props.style = (0, _shared.normalizeStyle)(style);
        }
    }
    // encode the vnode type information into a bitmap
    const shapeFlag = (0, _shared.isString)(type) ? 1 /* ShapeFlags.ELEMENT */  : isSuspense(type) ? 128 /* ShapeFlags.SUSPENSE */  : isTeleport(type) ? 64 /* ShapeFlags.TELEPORT */  : (0, _shared.isObject)(type) ? 4 /* ShapeFlags.STATEFUL_COMPONENT */  : (0, _shared.isFunction)(type) ? 2 /* ShapeFlags.FUNCTIONAL_COMPONENT */  : 0;
    if (shapeFlag & 4 /* ShapeFlags.STATEFUL_COMPONENT */  && (0, _reactivity.isProxy)(type)) {
        type = (0, _reactivity.toRaw)(type);
        warn(`Vue received a Component which was made a reactive object. This can ` + `lead to unnecessary performance overhead, and should be avoided by ` + `marking the component with \`markRaw\` or using \`shallowRef\` ` + `instead of \`ref\`.`, `\nComponent that was made reactive: `, type);
    }
    return createBaseVNode(type, props, children, patchFlag, dynamicProps, shapeFlag, isBlockNode, true);
}
function guardReactiveProps(props) {
    if (!props) return null;
    return (0, _reactivity.isProxy)(props) || InternalObjectKey in props ? (0, _shared.extend)({}, props) : props;
}
function cloneVNode(vnode, extraProps, mergeRef = false) {
    // This is intentionally NOT using spread or extend to avoid the runtime
    // key enumeration cost.
    const { props , ref , patchFlag , children  } = vnode;
    const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
    const cloned = {
        __v_isVNode: true,
        __v_skip: true,
        type: vnode.type,
        props: mergedProps,
        key: mergedProps && normalizeKey(mergedProps),
        ref: extraProps && extraProps.ref ? // if the vnode itself already has a ref, cloneVNode will need to merge
        // the refs so the single vnode can be set on multiple refs
        mergeRef && ref ? (0, _shared.isArray)(ref) ? ref.concat(normalizeRef(extraProps)) : [
            ref,
            normalizeRef(extraProps)
        ] : normalizeRef(extraProps) : ref,
        scopeId: vnode.scopeId,
        slotScopeIds: vnode.slotScopeIds,
        children: patchFlag === -1 /* PatchFlags.HOISTED */  && (0, _shared.isArray)(children) ? children.map(deepCloneVNode) : children,
        target: vnode.target,
        targetAnchor: vnode.targetAnchor,
        staticCount: vnode.staticCount,
        shapeFlag: vnode.shapeFlag,
        // if the vnode is cloned with extra props, we can no longer assume its
        // existing patch flag to be reliable and need to add the FULL_PROPS flag.
        // note: preserve flag for fragments since they use the flag for children
        // fast paths only.
        patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 // hoisted node
         ? 16 /* PatchFlags.FULL_PROPS */  : patchFlag | 16 /* PatchFlags.FULL_PROPS */  : patchFlag,
        dynamicProps: vnode.dynamicProps,
        dynamicChildren: vnode.dynamicChildren,
        appContext: vnode.appContext,
        dirs: vnode.dirs,
        transition: vnode.transition,
        // These should technically only be non-null on mounted VNodes. However,
        // they *should* be copied for kept-alive vnodes. So we just always copy
        // them since them being non-null during a mount doesn't affect the logic as
        // they will simply be overwritten.
        component: vnode.component,
        suspense: vnode.suspense,
        ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
        ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
        el: vnode.el,
        anchor: vnode.anchor,
        ctx: vnode.ctx,
        ce: vnode.ce
    };
    return cloned;
}
/**
 * Dev only, for HMR of hoisted vnodes reused in v-for
 * https://github.com/vitejs/vite/issues/2022
 */ function deepCloneVNode(vnode) {
    const cloned = cloneVNode(vnode);
    if ((0, _shared.isArray)(vnode.children)) cloned.children = vnode.children.map(deepCloneVNode);
    return cloned;
}
/**
 * @private
 */ function createTextVNode(text = " ", flag = 0) {
    return createVNode(Text, null, text, flag);
}
/**
 * @private
 */ function createStaticVNode(content, numberOfNodes) {
    // A static vnode can contain multiple stringified elements, and the number
    // of elements is necessary for hydration.
    const vnode = createVNode(Static, null, content);
    vnode.staticCount = numberOfNodes;
    return vnode;
}
/**
 * @private
 */ function createCommentVNode(text = "", // when used as the v-else branch, the comment node must be created as a
// block to ensure correct updates.
asBlock = false) {
    return asBlock ? (openBlock(), createBlock(Comment, null, text)) : createVNode(Comment, null, text);
}
function normalizeVNode(child) {
    if (child == null || typeof child === "boolean") // empty placeholder
    return createVNode(Comment);
    else if ((0, _shared.isArray)(child)) // fragment
    return createVNode(Fragment, null, // #3666, avoid reference pollution when reusing vnode
    child.slice());
    else if (typeof child === "object") // already vnode, this should be the most common since compiled templates
    // always produce all-vnode children arrays
    return cloneIfMounted(child);
    else // strings and numbers
    return createVNode(Text, null, String(child));
}
// optimized normalization for template-compiled render fns
function cloneIfMounted(child) {
    return child.el === null && child.patchFlag !== -1 /* PatchFlags.HOISTED */  || child.memo ? child : cloneVNode(child);
}
function normalizeChildren(vnode, children) {
    let type = 0;
    const { shapeFlag  } = vnode;
    if (children == null) children = null;
    else if ((0, _shared.isArray)(children)) type = 16 /* ShapeFlags.ARRAY_CHILDREN */ ;
    else if (typeof children === "object") {
        if (shapeFlag & 65 /* ShapeFlags.TELEPORT */ ) {
            // Normalize slot to plain children for plain element and Teleport
            const slot = children.default;
            if (slot) {
                // _c marker is added by withCtx() indicating this is a compiled slot
                slot._c && (slot._d = false);
                normalizeChildren(vnode, slot());
                slot._c && (slot._d = true);
            }
            return;
        } else {
            type = 32 /* ShapeFlags.SLOTS_CHILDREN */ ;
            const slotFlag = children._;
            if (!slotFlag && !(InternalObjectKey in children)) children._ctx = currentRenderingInstance;
            else if (slotFlag === 3 /* SlotFlags.FORWARDED */  && currentRenderingInstance) {
                // a child component receives forwarded slots from the parent.
                // its slot type is determined by its parent's slot type.
                if (currentRenderingInstance.slots._ === 1 /* SlotFlags.STABLE */ ) children._ = 1 /* SlotFlags.STABLE */ ;
                else {
                    children._ = 2 /* SlotFlags.DYNAMIC */ ;
                    vnode.patchFlag |= 1024 /* PatchFlags.DYNAMIC_SLOTS */ ;
                }
            }
        }
    } else if ((0, _shared.isFunction)(children)) {
        children = {
            default: children,
            _ctx: currentRenderingInstance
        };
        type = 32 /* ShapeFlags.SLOTS_CHILDREN */ ;
    } else {
        children = String(children);
        // force teleport children to array so it can be moved around
        if (shapeFlag & 64 /* ShapeFlags.TELEPORT */ ) {
            type = 16 /* ShapeFlags.ARRAY_CHILDREN */ ;
            children = [
                createTextVNode(children)
            ];
        } else type = 8 /* ShapeFlags.TEXT_CHILDREN */ ;
    }
    vnode.children = children;
    vnode.shapeFlag |= type;
}
function mergeProps(...args) {
    const ret = {};
    for(let i = 0; i < args.length; i++){
        const toMerge = args[i];
        for(const key in toMerge){
            if (key === "class") {
                if (ret.class !== toMerge.class) ret.class = (0, _shared.normalizeClass)([
                    ret.class,
                    toMerge.class
                ]);
            } else if (key === "style") ret.style = (0, _shared.normalizeStyle)([
                ret.style,
                toMerge.style
            ]);
            else if ((0, _shared.isOn)(key)) {
                const existing = ret[key];
                const incoming = toMerge[key];
                if (incoming && existing !== incoming && !((0, _shared.isArray)(existing) && existing.includes(incoming))) ret[key] = existing ? [].concat(existing, incoming) : incoming;
            } else if (key !== "") ret[key] = toMerge[key];
        }
    }
    return ret;
}
function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
    callWithAsyncErrorHandling(hook, instance, 7 /* ErrorCodes.VNODE_HOOK */ , [
        vnode,
        prevVNode
    ]);
}
const emptyAppContext = createAppContext();
let uid = 0;
function createComponentInstance(vnode, parent, suspense) {
    const type = vnode.type;
    // inherit parent app context - or - if root, adopt from root vnode
    const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
    const instance = {
        uid: uid++,
        vnode,
        type,
        parent,
        appContext,
        root: null,
        next: null,
        subTree: null,
        effect: null,
        update: null,
        scope: new (0, _reactivity.EffectScope)(true),
        render: null,
        proxy: null,
        exposed: null,
        exposeProxy: null,
        withProxy: null,
        provides: parent ? parent.provides : Object.create(appContext.provides),
        accessCache: null,
        renderCache: [],
        // local resolved assets
        components: null,
        directives: null,
        // resolved props and emits options
        propsOptions: normalizePropsOptions(type, appContext),
        emitsOptions: normalizeEmitsOptions(type, appContext),
        // emit
        emit: null,
        emitted: null,
        // props default value
        propsDefaults: (0, _shared.EMPTY_OBJ),
        // inheritAttrs
        inheritAttrs: type.inheritAttrs,
        // state
        ctx: (0, _shared.EMPTY_OBJ),
        data: (0, _shared.EMPTY_OBJ),
        props: (0, _shared.EMPTY_OBJ),
        attrs: (0, _shared.EMPTY_OBJ),
        slots: (0, _shared.EMPTY_OBJ),
        refs: (0, _shared.EMPTY_OBJ),
        setupState: (0, _shared.EMPTY_OBJ),
        setupContext: null,
        // suspense related
        suspense,
        suspenseId: suspense ? suspense.pendingId : 0,
        asyncDep: null,
        asyncResolved: false,
        // lifecycle hooks
        // not using enums here because it results in computed properties
        isMounted: false,
        isUnmounted: false,
        isDeactivated: false,
        bc: null,
        c: null,
        bm: null,
        m: null,
        bu: null,
        u: null,
        um: null,
        bum: null,
        da: null,
        a: null,
        rtg: null,
        rtc: null,
        ec: null,
        sp: null
    };
    instance.ctx = createDevRenderContext(instance);
    instance.root = parent ? parent.root : instance;
    instance.emit = emit.bind(null, instance);
    // apply custom element special handling
    if (vnode.ce) vnode.ce(instance);
    return instance;
}
let currentInstance = null;
const getCurrentInstance = ()=>currentInstance || currentRenderingInstance;
const setCurrentInstance = (instance)=>{
    currentInstance = instance;
    instance.scope.on();
};
const unsetCurrentInstance = ()=>{
    currentInstance && currentInstance.scope.off();
    currentInstance = null;
};
const isBuiltInTag = /*#__PURE__*/ (0, _shared.makeMap)("slot,component");
function validateComponentName(name, config) {
    const appIsNativeTag = config.isNativeTag || (0, _shared.NO);
    if (isBuiltInTag(name) || appIsNativeTag(name)) warn("Do not use built-in or reserved HTML elements as component id: " + name);
}
function isStatefulComponent(instance) {
    return instance.vnode.shapeFlag & 4 /* ShapeFlags.STATEFUL_COMPONENT */ ;
}
let isInSSRComponentSetup = false;
function setupComponent(instance, isSSR = false) {
    isInSSRComponentSetup = isSSR;
    const { props , children  } = instance.vnode;
    const isStateful = isStatefulComponent(instance);
    initProps(instance, props, isStateful, isSSR);
    initSlots(instance, children);
    const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : undefined;
    isInSSRComponentSetup = false;
    return setupResult;
}
function setupStatefulComponent(instance, isSSR) {
    var _a;
    const Component = instance.type;
    if (Component.name) validateComponentName(Component.name, instance.appContext.config);
    if (Component.components) {
        const names = Object.keys(Component.components);
        for(let i = 0; i < names.length; i++)validateComponentName(names[i], instance.appContext.config);
    }
    if (Component.directives) {
        const names = Object.keys(Component.directives);
        for(let i = 0; i < names.length; i++)validateDirectiveName(names[i]);
    }
    if (Component.compilerOptions && isRuntimeOnly()) warn(`"compilerOptions" is only supported when using a build of Vue that ` + `includes the runtime compiler. Since you are using a runtime-only ` + `build, the options should be passed via your build tool config instead.`);
    // 0. create render proxy property access cache
    instance.accessCache = Object.create(null);
    // 1. create public instance / render proxy
    // also mark it raw so it's never observed
    instance.proxy = (0, _reactivity.markRaw)(new Proxy(instance.ctx, PublicInstanceProxyHandlers));
    exposePropsOnRenderContext(instance);
    // 2. call setup()
    const { setup  } = Component;
    if (setup) {
        const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
        setCurrentInstance(instance);
        (0, _reactivity.pauseTracking)();
        const setupResult = callWithErrorHandling(setup, instance, 0 /* ErrorCodes.SETUP_FUNCTION */ , [
            (0, _reactivity.shallowReadonly)(instance.props),
            setupContext
        ]);
        (0, _reactivity.resetTracking)();
        unsetCurrentInstance();
        if ((0, _shared.isPromise)(setupResult)) {
            setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
            if (isSSR) // return the promise so server-renderer can wait on it
            return setupResult.then((resolvedResult)=>{
                handleSetupResult(instance, resolvedResult, isSSR);
            }).catch((e)=>{
                handleError(e, instance, 0 /* ErrorCodes.SETUP_FUNCTION */ );
            });
            else {
                // async setup returned Promise.
                // bail here and wait for re-entry.
                instance.asyncDep = setupResult;
                if (!instance.suspense) {
                    const name = (_a = Component.name) !== null && _a !== void 0 ? _a : "Anonymous";
                    warn(`Component <${name}>: setup function returned a promise, but no ` + `<Suspense> boundary was found in the parent component tree. ` + `A component with async setup() must be nested in a <Suspense> ` + `in order to be rendered.`);
                }
            }
        } else handleSetupResult(instance, setupResult, isSSR);
    } else finishComponentSetup(instance, isSSR);
}
function handleSetupResult(instance, setupResult, isSSR) {
    if ((0, _shared.isFunction)(setupResult)) {
        // setup returned an inline render function
        if (instance.type.__ssrInlineRender) // when the function's name is `ssrRender` (compiled by SFC inline mode),
        // set it as ssrRender instead.
        instance.ssrRender = setupResult;
        else instance.render = setupResult;
    } else if ((0, _shared.isObject)(setupResult)) {
        if (isVNode(setupResult)) warn(`setup() should not return VNodes directly - ` + `return a render function instead.`);
        instance.devtoolsRawSetupState = setupResult;
        instance.setupState = (0, _reactivity.proxyRefs)(setupResult);
        exposeSetupStateOnRenderContext(instance);
    } else if (setupResult !== undefined) warn(`setup() should return an object. Received: ${setupResult === null ? "null" : typeof setupResult}`);
    finishComponentSetup(instance, isSSR);
}
let compile;
let installWithProxy;
/**
 * For runtime-dom to register the compiler.
 * Note the exported method uses any to avoid d.ts relying on the compiler types.
 */ function registerRuntimeCompiler(_compile) {
    compile = _compile;
    installWithProxy = (i)=>{
        if (i.render._rc) i.withProxy = new Proxy(i.ctx, RuntimeCompiledPublicInstanceProxyHandlers);
    };
}
// dev only
const isRuntimeOnly = ()=>!compile;
function finishComponentSetup(instance, isSSR, skipOptions) {
    const Component = instance.type;
    // template / render function normalization
    // could be already set when returned from setup()
    if (!instance.render) {
        // only do on-the-fly compile if not in SSR - SSR on-the-fly compilation
        // is done by server-renderer
        if (!isSSR && compile && !Component.render) {
            const template = Component.template || resolveMergedOptions(instance).template;
            if (template) {
                startMeasure(instance, `compile`);
                const { isCustomElement , compilerOptions  } = instance.appContext.config;
                const { delimiters , compilerOptions: componentCompilerOptions  } = Component;
                const finalCompilerOptions = (0, _shared.extend)((0, _shared.extend)({
                    isCustomElement,
                    delimiters
                }, compilerOptions), componentCompilerOptions);
                Component.render = compile(template, finalCompilerOptions);
                endMeasure(instance, `compile`);
            }
        }
        instance.render = Component.render || (0, _shared.NOOP);
        // for runtime-compiled render functions using `with` blocks, the render
        // proxy used needs a different `has` handler which is more performant and
        // also only allows a whitelist of globals to fallthrough.
        if (installWithProxy) installWithProxy(instance);
    }
    // support for 2.x options
    if (__VUE_OPTIONS_API__ && true) {
        setCurrentInstance(instance);
        (0, _reactivity.pauseTracking)();
        applyOptions(instance);
        (0, _reactivity.resetTracking)();
        unsetCurrentInstance();
    }
    // warn missing template/render
    // the runtime compilation of template in SSR is done by server-render
    if (!Component.render && instance.render === (0, _shared.NOOP) && !isSSR) {
        /* istanbul ignore if */ if (!compile && Component.template) warn(`Component provided template option but ` + `runtime compilation is not supported in this build of Vue.` + ` Configure your bundler to alias "vue" to "vue/dist/vue.esm-bundler.js".`);
        else warn(`Component is missing template or render function.`);
    }
}
function createAttrsProxy(instance) {
    return new Proxy(instance.attrs, {
        get (target, key) {
            markAttrsAccessed();
            (0, _reactivity.track)(instance, "get" /* TrackOpTypes.GET */ , "$attrs");
            return target[key];
        },
        set () {
            warn(`setupContext.attrs is readonly.`);
            return false;
        },
        deleteProperty () {
            warn(`setupContext.attrs is readonly.`);
            return false;
        }
    });
}
function createSetupContext(instance) {
    const expose = (exposed)=>{
        if (instance.exposed) warn(`expose() should be called only once per setup().`);
        if (exposed != null) {
            let exposedType = typeof exposed;
            if (exposedType === "object") {
                if ((0, _shared.isArray)(exposed)) exposedType = "array";
                else if ((0, _reactivity.isRef)(exposed)) exposedType = "ref";
            }
            if (exposedType !== "object") warn(`expose() should be passed a plain object, received ${exposedType}.`);
        }
        instance.exposed = exposed || {};
    };
    let attrs;
    // We use getters in dev in case libs like test-utils overwrite instance
    // properties (overwrites should not be done in prod)
    return Object.freeze({
        get attrs () {
            return attrs || (attrs = createAttrsProxy(instance));
        },
        get slots () {
            return (0, _reactivity.shallowReadonly)(instance.slots);
        },
        get emit () {
            return (event, ...args)=>instance.emit(event, ...args);
        },
        expose
    });
}
function getExposeProxy(instance) {
    if (instance.exposed) return instance.exposeProxy || (instance.exposeProxy = new Proxy((0, _reactivity.proxyRefs)((0, _reactivity.markRaw)(instance.exposed)), {
        get (target, key) {
            if (key in target) return target[key];
            else if (key in publicPropertiesMap) return publicPropertiesMap[key](instance);
        },
        has (target, key) {
            return key in target || key in publicPropertiesMap;
        }
    }));
}
const classifyRE = /(?:^|[-_])(\w)/g;
const classify = (str)=>str.replace(classifyRE, (c)=>c.toUpperCase()).replace(/[-_]/g, "");
function getComponentName(Component, includeInferred = true) {
    return (0, _shared.isFunction)(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
}
/* istanbul ignore next */ function formatComponentName(instance, Component, isRoot = false) {
    let name = getComponentName(Component);
    if (!name && Component.__file) {
        const match = Component.__file.match(/([^/\\]+)\.\w+$/);
        if (match) name = match[1];
    }
    if (!name && instance && instance.parent) {
        // try to infer the name based on reverse resolution
        const inferFromRegistry = (registry)=>{
            for(const key in registry){
                if (registry[key] === Component) return key;
            }
        };
        name = inferFromRegistry(instance.components || instance.parent.type.components) || inferFromRegistry(instance.appContext.components);
    }
    return name ? classify(name) : isRoot ? `App` : `Anonymous`;
}
function isClassComponent(value) {
    return (0, _shared.isFunction)(value) && "__vccOpts" in value;
}
const computed = (getterOrOptions, debugOptions)=>{
    // @ts-ignore
    return (0, _reactivity.computed)(getterOrOptions, debugOptions, isInSSRComponentSetup);
};
// dev only
const warnRuntimeUsage = (method)=>warn(`${method}() is a compiler-hint helper that is only usable inside ` + `<script setup> of a single file component. Its arguments should be ` + `compiled away and passing it at runtime has no effect.`);
// implementation
function defineProps() {
    warnRuntimeUsage(`defineProps`);
    return null;
}
// implementation
function defineEmits() {
    warnRuntimeUsage(`defineEmits`);
    return null;
}
/**
 * Vue `<script setup>` compiler macro for declaring a component's exposed
 * instance properties when it is accessed by a parent component via template
 * refs.
 *
 * `<script setup>` components are closed by default - i.e. variables inside
 * the `<script setup>` scope is not exposed to parent unless explicitly exposed
 * via `defineExpose`.
 *
 * This is only usable inside `<script setup>`, is compiled away in the
 * output and should **not** be actually called at runtime.
 */ function defineExpose(exposed) {
    warnRuntimeUsage(`defineExpose`);
}
/**
 * Vue `<script setup>` compiler macro for providing props default values when
 * using type-based `defineProps` declaration.
 *
 * Example usage:
 * ```ts
 * withDefaults(defineProps<{
 *   size?: number
 *   labels?: string[]
 * }>(), {
 *   size: 3,
 *   labels: () => ['default label']
 * })
 * ```
 *
 * This is only usable inside `<script setup>`, is compiled away in the output
 * and should **not** be actually called at runtime.
 */ function withDefaults(props, defaults) {
    warnRuntimeUsage(`withDefaults`);
    return null;
}
function useSlots() {
    return getContext().slots;
}
function useAttrs() {
    return getContext().attrs;
}
function getContext() {
    const i = getCurrentInstance();
    if (!i) warn(`useContext() called without active instance.`);
    return i.setupContext || (i.setupContext = createSetupContext(i));
}
/**
 * Runtime helper for merging default declarations. Imported by compiled code
 * only.
 * @internal
 */ function mergeDefaults(raw, defaults) {
    const props = (0, _shared.isArray)(raw) ? raw.reduce((normalized, p)=>(normalized[p] = {}, normalized), {}) : raw;
    for(const key in defaults){
        const opt = props[key];
        if (opt) {
            if ((0, _shared.isArray)(opt) || (0, _shared.isFunction)(opt)) props[key] = {
                type: opt,
                default: defaults[key]
            };
            else opt.default = defaults[key];
        } else if (opt === null) props[key] = {
            default: defaults[key]
        };
        else warn(`props default key "${key}" has no corresponding declaration.`);
    }
    return props;
}
/**
 * Used to create a proxy for the rest element when destructuring props with
 * defineProps().
 * @internal
 */ function createPropsRestProxy(props, excludedKeys) {
    const ret = {};
    for(const key in props)if (!excludedKeys.includes(key)) Object.defineProperty(ret, key, {
        enumerable: true,
        get: ()=>props[key]
    });
    return ret;
}
/**
 * `<script setup>` helper for persisting the current instance context over
 * async/await flows.
 *
 * `@vue/compiler-sfc` converts the following:
 *
 * ```ts
 * const x = await foo()
 * ```
 *
 * into:
 *
 * ```ts
 * let __temp, __restore
 * const x = (([__temp, __restore] = withAsyncContext(() => foo())),__temp=await __temp,__restore(),__temp)
 * ```
 * @internal
 */ function withAsyncContext(getAwaitable) {
    const ctx = getCurrentInstance();
    if (!ctx) warn(`withAsyncContext called without active current instance. ` + `This is likely a bug.`);
    let awaitable = getAwaitable();
    unsetCurrentInstance();
    if ((0, _shared.isPromise)(awaitable)) awaitable = awaitable.catch((e)=>{
        setCurrentInstance(ctx);
        throw e;
    });
    return [
        awaitable,
        ()=>setCurrentInstance(ctx)
    ];
}
// Actual implementation
function h(type, propsOrChildren, children) {
    const l = arguments.length;
    if (l === 2) {
        if ((0, _shared.isObject)(propsOrChildren) && !(0, _shared.isArray)(propsOrChildren)) {
            // single vnode without props
            if (isVNode(propsOrChildren)) return createVNode(type, null, [
                propsOrChildren
            ]);
            // props without children
            return createVNode(type, propsOrChildren);
        } else // omit props
        return createVNode(type, null, propsOrChildren);
    } else {
        if (l > 3) children = Array.prototype.slice.call(arguments, 2);
        else if (l === 3 && isVNode(children)) children = [
            children
        ];
        return createVNode(type, propsOrChildren, children);
    }
}
const ssrContextKey = Symbol(`ssrContext`);
const useSSRContext = ()=>{
    {
        const ctx = inject(ssrContextKey);
        if (!ctx) warn(`Server rendering context not provided. Make sure to only call ` + `useSSRContext() conditionally in the server build.`);
        return ctx;
    }
};
function isShallow(value) {
    return !!(value && value["__v_isShallow" /* ReactiveFlags.IS_SHALLOW */ ]);
}
function initCustomFormatter() {
    /* eslint-disable no-restricted-globals */ if (typeof window === "undefined") return;
    const vueStyle = {
        style: "color:#3ba776"
    };
    const numberStyle = {
        style: "color:#0b1bc9"
    };
    const stringStyle = {
        style: "color:#b62e24"
    };
    const keywordStyle = {
        style: "color:#9d288c"
    };
    // custom formatter for Chrome
    // https://www.mattzeunert.com/2016/02/19/custom-chrome-devtools-object-formatters.html
    const formatter = {
        header (obj) {
            // TODO also format ComponentPublicInstance & ctx.slots/attrs in setup
            if (!(0, _shared.isObject)(obj)) return null;
            if (obj.__isVue) return [
                "div",
                vueStyle,
                `VueInstance`
            ];
            else if ((0, _reactivity.isRef)(obj)) return [
                "div",
                {},
                [
                    "span",
                    vueStyle,
                    genRefFlag(obj)
                ],
                "<",
                formatValue(obj.value),
                `>`
            ];
            else if ((0, _reactivity.isReactive)(obj)) return [
                "div",
                {},
                [
                    "span",
                    vueStyle,
                    isShallow(obj) ? "ShallowReactive" : "Reactive"
                ],
                "<",
                formatValue(obj),
                `>${(0, _reactivity.isReadonly)(obj) ? ` (readonly)` : ``}`
            ];
            else if ((0, _reactivity.isReadonly)(obj)) return [
                "div",
                {},
                [
                    "span",
                    vueStyle,
                    isShallow(obj) ? "ShallowReadonly" : "Readonly"
                ],
                "<",
                formatValue(obj),
                ">"
            ];
            return null;
        },
        hasBody (obj) {
            return obj && obj.__isVue;
        },
        body (obj) {
            if (obj && obj.__isVue) return [
                "div",
                {},
                ...formatInstance(obj.$)
            ];
        }
    };
    function formatInstance(instance) {
        const blocks = [];
        if (instance.type.props && instance.props) blocks.push(createInstanceBlock("props", (0, _reactivity.toRaw)(instance.props)));
        if (instance.setupState !== (0, _shared.EMPTY_OBJ)) blocks.push(createInstanceBlock("setup", instance.setupState));
        if (instance.data !== (0, _shared.EMPTY_OBJ)) blocks.push(createInstanceBlock("data", (0, _reactivity.toRaw)(instance.data)));
        const computed = extractKeys(instance, "computed");
        if (computed) blocks.push(createInstanceBlock("computed", computed));
        const injected = extractKeys(instance, "inject");
        if (injected) blocks.push(createInstanceBlock("injected", injected));
        blocks.push([
            "div",
            {},
            [
                "span",
                {
                    style: keywordStyle.style + ";opacity:0.66"
                },
                "$ (internal): "
            ],
            [
                "object",
                {
                    object: instance
                }
            ]
        ]);
        return blocks;
    }
    function createInstanceBlock(type, target) {
        target = (0, _shared.extend)({}, target);
        if (!Object.keys(target).length) return [
            "span",
            {}
        ];
        return [
            "div",
            {
                style: "line-height:1.25em;margin-bottom:0.6em"
            },
            [
                "div",
                {
                    style: "color:#476582"
                },
                type
            ],
            [
                "div",
                {
                    style: "padding-left:1.25em"
                },
                ...Object.keys(target).map((key)=>{
                    return [
                        "div",
                        {},
                        [
                            "span",
                            keywordStyle,
                            key + ": "
                        ],
                        formatValue(target[key], false)
                    ];
                })
            ]
        ];
    }
    function formatValue(v1, asRaw = true) {
        if (typeof v1 === "number") return [
            "span",
            numberStyle,
            v1
        ];
        else if (typeof v1 === "string") return [
            "span",
            stringStyle,
            JSON.stringify(v1)
        ];
        else if (typeof v1 === "boolean") return [
            "span",
            keywordStyle,
            v1
        ];
        else if ((0, _shared.isObject)(v1)) return [
            "object",
            {
                object: asRaw ? (0, _reactivity.toRaw)(v1) : v1
            }
        ];
        else return [
            "span",
            stringStyle,
            String(v1)
        ];
    }
    function extractKeys(instance, type) {
        const Comp = instance.type;
        if ((0, _shared.isFunction)(Comp)) return;
        const extracted = {};
        for(const key in instance.ctx)if (isKeyOfType(Comp, key, type)) extracted[key] = instance.ctx[key];
        return extracted;
    }
    function isKeyOfType(Comp, key, type) {
        const opts = Comp[type];
        if ((0, _shared.isArray)(opts) && opts.includes(key) || (0, _shared.isObject)(opts) && key in opts) return true;
        if (Comp.extends && isKeyOfType(Comp.extends, key, type)) return true;
        if (Comp.mixins && Comp.mixins.some((m)=>isKeyOfType(m, key, type))) return true;
    }
    function genRefFlag(v1) {
        if (isShallow(v1)) return `ShallowRef`;
        if (v1.effect) return `ComputedRef`;
        return `Ref`;
    }
    if (window.devtoolsFormatters) window.devtoolsFormatters.push(formatter);
    else window.devtoolsFormatters = [
        formatter
    ];
}
function withMemo(memo, render, cache, index) {
    const cached = cache[index];
    if (cached && isMemoSame(cached, memo)) return cached;
    const ret = render();
    // shallow clone
    ret.memo = memo.slice();
    return cache[index] = ret;
}
function isMemoSame(cached, memo) {
    const prev = cached.memo;
    if (prev.length != memo.length) return false;
    for(let i = 0; i < prev.length; i++){
        if ((0, _shared.hasChanged)(prev[i], memo[i])) return false;
    }
    // make sure to let parent block track it when returning cached
    if (isBlockTreeEnabled > 0 && currentBlock) currentBlock.push(cached);
    return true;
}
// Core API ------------------------------------------------------------------
const version = "3.2.47";
const _ssrUtils = {
    createComponentInstance,
    setupComponent,
    renderComponentRoot,
    setCurrentRenderingInstance,
    isVNode,
    normalizeVNode
};
/**
 * SSR utils for \@vue/server-renderer. Only exposed in ssr-possible builds.
 * @internal
 */ const ssrUtils = _ssrUtils;
/**
 * @internal only exposed in compat builds
 */ const resolveFilter = null;
/**
 * @internal only exposed in compat builds.
 */ const compatUtils = null;

},{"@vue/reactivity":"d7UXQ","@vue/shared":"3SM3y","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"d7UXQ":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "EffectScope", ()=>EffectScope);
parcelHelpers.export(exports, "ITERATE_KEY", ()=>ITERATE_KEY);
parcelHelpers.export(exports, "ReactiveEffect", ()=>ReactiveEffect);
parcelHelpers.export(exports, "computed", ()=>computed);
parcelHelpers.export(exports, "customRef", ()=>customRef);
parcelHelpers.export(exports, "deferredComputed", ()=>deferredComputed);
parcelHelpers.export(exports, "effect", ()=>effect);
parcelHelpers.export(exports, "effectScope", ()=>effectScope);
parcelHelpers.export(exports, "enableTracking", ()=>enableTracking);
parcelHelpers.export(exports, "getCurrentScope", ()=>getCurrentScope);
parcelHelpers.export(exports, "isProxy", ()=>isProxy);
parcelHelpers.export(exports, "isReactive", ()=>isReactive);
parcelHelpers.export(exports, "isReadonly", ()=>isReadonly);
parcelHelpers.export(exports, "isRef", ()=>isRef);
parcelHelpers.export(exports, "isShallow", ()=>isShallow);
parcelHelpers.export(exports, "markRaw", ()=>markRaw);
parcelHelpers.export(exports, "onScopeDispose", ()=>onScopeDispose);
parcelHelpers.export(exports, "pauseTracking", ()=>pauseTracking);
parcelHelpers.export(exports, "proxyRefs", ()=>proxyRefs);
parcelHelpers.export(exports, "reactive", ()=>reactive);
parcelHelpers.export(exports, "readonly", ()=>readonly);
parcelHelpers.export(exports, "ref", ()=>ref);
parcelHelpers.export(exports, "resetTracking", ()=>resetTracking);
parcelHelpers.export(exports, "shallowReactive", ()=>shallowReactive);
parcelHelpers.export(exports, "shallowReadonly", ()=>shallowReadonly);
parcelHelpers.export(exports, "shallowRef", ()=>shallowRef);
parcelHelpers.export(exports, "stop", ()=>stop);
parcelHelpers.export(exports, "toRaw", ()=>toRaw);
parcelHelpers.export(exports, "toRef", ()=>toRef);
parcelHelpers.export(exports, "toRefs", ()=>toRefs);
parcelHelpers.export(exports, "track", ()=>track);
parcelHelpers.export(exports, "trigger", ()=>trigger);
parcelHelpers.export(exports, "triggerRef", ()=>triggerRef);
parcelHelpers.export(exports, "unref", ()=>unref);
var _shared = require("@vue/shared");
function warn(msg, ...args) {
    console.warn(`[Vue warn] ${msg}`, ...args);
}
let activeEffectScope;
class EffectScope {
    constructor(detached = false){
        this.detached = detached;
        /**
         * @internal
         */ this._active = true;
        /**
         * @internal
         */ this.effects = [];
        /**
         * @internal
         */ this.cleanups = [];
        this.parent = activeEffectScope;
        if (!detached && activeEffectScope) this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
    }
    get active() {
        return this._active;
    }
    run(fn) {
        if (this._active) {
            const currentEffectScope = activeEffectScope;
            try {
                activeEffectScope = this;
                return fn();
            } finally{
                activeEffectScope = currentEffectScope;
            }
        } else warn(`cannot run an inactive effect scope.`);
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */ on() {
        activeEffectScope = this;
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */ off() {
        activeEffectScope = this.parent;
    }
    stop(fromParent) {
        if (this._active) {
            let i, l;
            for(i = 0, l = this.effects.length; i < l; i++)this.effects[i].stop();
            for(i = 0, l = this.cleanups.length; i < l; i++)this.cleanups[i]();
            if (this.scopes) for(i = 0, l = this.scopes.length; i < l; i++)this.scopes[i].stop(true);
            // nested scope, dereference from parent to avoid memory leaks
            if (!this.detached && this.parent && !fromParent) {
                // optimized O(1) removal
                const last = this.parent.scopes.pop();
                if (last && last !== this) {
                    this.parent.scopes[this.index] = last;
                    last.index = this.index;
                }
            }
            this.parent = undefined;
            this._active = false;
        }
    }
}
function effectScope(detached) {
    return new EffectScope(detached);
}
function recordEffectScope(effect, scope = activeEffectScope) {
    if (scope && scope.active) scope.effects.push(effect);
}
function getCurrentScope() {
    return activeEffectScope;
}
function onScopeDispose(fn) {
    if (activeEffectScope) activeEffectScope.cleanups.push(fn);
    else warn(`onScopeDispose() is called when there is no active effect scope` + ` to be associated with.`);
}
const createDep = (effects)=>{
    const dep = new Set(effects);
    dep.w = 0;
    dep.n = 0;
    return dep;
};
const wasTracked = (dep)=>(dep.w & trackOpBit) > 0;
const newTracked = (dep)=>(dep.n & trackOpBit) > 0;
const initDepMarkers = ({ deps  })=>{
    if (deps.length) for(let i = 0; i < deps.length; i++)deps[i].w |= trackOpBit; // set was tracked
};
const finalizeDepMarkers = (effect)=>{
    const { deps  } = effect;
    if (deps.length) {
        let ptr = 0;
        for(let i = 0; i < deps.length; i++){
            const dep = deps[i];
            if (wasTracked(dep) && !newTracked(dep)) dep.delete(effect);
            else deps[ptr++] = dep;
            // clear bits
            dep.w &= ~trackOpBit;
            dep.n &= ~trackOpBit;
        }
        deps.length = ptr;
    }
};
const targetMap = new WeakMap();
// The number of effects currently being tracked recursively.
let effectTrackDepth = 0;
let trackOpBit = 1;
/**
 * The bitwise track markers support at most 30 levels of recursion.
 * This value is chosen to enable modern JS engines to use a SMI on all platforms.
 * When recursion depth is greater, fall back to using a full cleanup.
 */ const maxMarkerBits = 30;
let activeEffect;
const ITERATE_KEY = Symbol("iterate");
const MAP_KEY_ITERATE_KEY = Symbol("Map key iterate");
class ReactiveEffect {
    constructor(fn, scheduler = null, scope){
        this.fn = fn;
        this.scheduler = scheduler;
        this.active = true;
        this.deps = [];
        this.parent = undefined;
        recordEffectScope(this, scope);
    }
    run() {
        if (!this.active) return this.fn();
        let parent = activeEffect;
        let lastShouldTrack = shouldTrack;
        while(parent){
            if (parent === this) return;
            parent = parent.parent;
        }
        try {
            this.parent = activeEffect;
            activeEffect = this;
            shouldTrack = true;
            trackOpBit = 1 << ++effectTrackDepth;
            if (effectTrackDepth <= maxMarkerBits) initDepMarkers(this);
            else cleanupEffect(this);
            return this.fn();
        } finally{
            if (effectTrackDepth <= maxMarkerBits) finalizeDepMarkers(this);
            trackOpBit = 1 << --effectTrackDepth;
            activeEffect = this.parent;
            shouldTrack = lastShouldTrack;
            this.parent = undefined;
            if (this.deferStop) this.stop();
        }
    }
    stop() {
        // stopped while running itself - defer the cleanup
        if (activeEffect === this) this.deferStop = true;
        else if (this.active) {
            cleanupEffect(this);
            if (this.onStop) this.onStop();
            this.active = false;
        }
    }
}
function cleanupEffect(effect) {
    const { deps  } = effect;
    if (deps.length) {
        for(let i = 0; i < deps.length; i++)deps[i].delete(effect);
        deps.length = 0;
    }
}
function effect(fn, options) {
    if (fn.effect) fn = fn.effect.fn;
    const _effect = new ReactiveEffect(fn);
    if (options) {
        (0, _shared.extend)(_effect, options);
        if (options.scope) recordEffectScope(_effect, options.scope);
    }
    if (!options || !options.lazy) _effect.run();
    const runner = _effect.run.bind(_effect);
    runner.effect = _effect;
    return runner;
}
function stop(runner) {
    runner.effect.stop();
}
let shouldTrack = true;
const trackStack = [];
function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
}
function enableTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = true;
}
function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === undefined ? true : last;
}
function track(target, type, key) {
    if (shouldTrack && activeEffect) {
        let depsMap = targetMap.get(target);
        if (!depsMap) targetMap.set(target, depsMap = new Map());
        let dep = depsMap.get(key);
        if (!dep) depsMap.set(key, dep = createDep());
        const eventInfo = {
            effect: activeEffect,
            target,
            type,
            key
        };
        trackEffects(dep, eventInfo);
    }
}
function trackEffects(dep, debuggerEventExtraInfo) {
    let shouldTrack = false;
    if (effectTrackDepth <= maxMarkerBits) {
        if (!newTracked(dep)) {
            dep.n |= trackOpBit; // set newly tracked
            shouldTrack = !wasTracked(dep);
        }
    } else // Full cleanup mode.
    shouldTrack = !dep.has(activeEffect);
    if (shouldTrack) {
        dep.add(activeEffect);
        activeEffect.deps.push(dep);
        if (0, activeEffect.onTrack) activeEffect.onTrack(Object.assign({
            effect: activeEffect
        }, debuggerEventExtraInfo));
    }
}
function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) // never been tracked
    return;
    let deps = [];
    if (type === "clear" /* TriggerOpTypes.CLEAR */ ) // collection being cleared
    // trigger all effects for target
    deps = [
        ...depsMap.values()
    ];
    else if (key === "length" && (0, _shared.isArray)(target)) {
        const newLength = Number(newValue);
        depsMap.forEach((dep, key)=>{
            if (key === "length" || key >= newLength) deps.push(dep);
        });
    } else {
        // schedule runs for SET | ADD | DELETE
        if (key !== void 0) deps.push(depsMap.get(key));
        // also run for iteration key on ADD | DELETE | Map.SET
        switch(type){
            case "add" /* TriggerOpTypes.ADD */ :
                if (!(0, _shared.isArray)(target)) {
                    deps.push(depsMap.get(ITERATE_KEY));
                    if ((0, _shared.isMap)(target)) deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
                } else if ((0, _shared.isIntegerKey)(key)) // new index added to array -> length changes
                deps.push(depsMap.get("length"));
                break;
            case "delete" /* TriggerOpTypes.DELETE */ :
                if (!(0, _shared.isArray)(target)) {
                    deps.push(depsMap.get(ITERATE_KEY));
                    if ((0, _shared.isMap)(target)) deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
                }
                break;
            case "set" /* TriggerOpTypes.SET */ :
                if ((0, _shared.isMap)(target)) deps.push(depsMap.get(ITERATE_KEY));
                break;
        }
    }
    const eventInfo = {
        target,
        type,
        key,
        newValue,
        oldValue,
        oldTarget
    };
    if (deps.length === 1) {
        if (deps[0]) triggerEffects(deps[0], eventInfo);
    } else {
        const effects = [];
        for (const dep of deps)if (dep) effects.push(...dep);
        triggerEffects(createDep(effects), eventInfo);
    }
}
function triggerEffects(dep, debuggerEventExtraInfo) {
    // spread into array for stabilization
    const effects = (0, _shared.isArray)(dep) ? dep : [
        ...dep
    ];
    for (const effect of effects)if (effect.computed) triggerEffect(effect, debuggerEventExtraInfo);
    for (const effect of effects)if (!effect.computed) triggerEffect(effect, debuggerEventExtraInfo);
}
function triggerEffect(effect, debuggerEventExtraInfo) {
    if (effect !== activeEffect || effect.allowRecurse) {
        if (0, effect.onTrigger) effect.onTrigger((0, _shared.extend)({
            effect
        }, debuggerEventExtraInfo));
        if (effect.scheduler) effect.scheduler();
        else effect.run();
    }
}
function getDepFromReactive(object, key) {
    var _a;
    return (_a = targetMap.get(object)) === null || _a === void 0 ? void 0 : _a.get(key);
}
const isNonTrackableKeys = /*#__PURE__*/ (0, _shared.makeMap)(`__proto__,__v_isRef,__isVue`);
const builtInSymbols = new Set(/*#__PURE__*/ Object.getOwnPropertyNames(Symbol)// ios10.x Object.getOwnPropertyNames(Symbol) can enumerate 'arguments' and 'caller'
// but accessing them on Symbol leads to TypeError because Symbol is a strict mode
// function
.filter((key)=>key !== "arguments" && key !== "caller").map((key)=>Symbol[key]).filter((0, _shared.isSymbol)));
const get$1 = /*#__PURE__*/ createGetter();
const shallowGet = /*#__PURE__*/ createGetter(false, true);
const readonlyGet = /*#__PURE__*/ createGetter(true);
const shallowReadonlyGet = /*#__PURE__*/ createGetter(true, true);
const arrayInstrumentations = /*#__PURE__*/ createArrayInstrumentations();
function createArrayInstrumentations() {
    const instrumentations = {};
    [
        "includes",
        "indexOf",
        "lastIndexOf"
    ].forEach((key)=>{
        instrumentations[key] = function(...args) {
            const arr = toRaw(this);
            for(let i = 0, l = this.length; i < l; i++)track(arr, "get" /* TrackOpTypes.GET */ , i + "");
            // we run the method using the original args first (which may be reactive)
            const res = arr[key](...args);
            if (res === -1 || res === false) // if that didn't work, run it again using raw values.
            return arr[key](...args.map(toRaw));
            else return res;
        };
    });
    [
        "push",
        "pop",
        "shift",
        "unshift",
        "splice"
    ].forEach((key)=>{
        instrumentations[key] = function(...args) {
            pauseTracking();
            const res = toRaw(this)[key].apply(this, args);
            resetTracking();
            return res;
        };
    });
    return instrumentations;
}
function hasOwnProperty(key) {
    const obj = toRaw(this);
    track(obj, "has" /* TrackOpTypes.HAS */ , key);
    return obj.hasOwnProperty(key);
}
function createGetter(isReadonly = false, shallow = false) {
    return function get(target, key, receiver) {
        if (key === "__v_isReactive" /* ReactiveFlags.IS_REACTIVE */ ) return !isReadonly;
        else if (key === "__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ) return isReadonly;
        else if (key === "__v_isShallow" /* ReactiveFlags.IS_SHALLOW */ ) return shallow;
        else if (key === "__v_raw" /* ReactiveFlags.RAW */  && receiver === (isReadonly ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target)) return target;
        const targetIsArray = (0, _shared.isArray)(target);
        if (!isReadonly) {
            if (targetIsArray && (0, _shared.hasOwn)(arrayInstrumentations, key)) return Reflect.get(arrayInstrumentations, key, receiver);
            if (key === "hasOwnProperty") return hasOwnProperty;
        }
        const res = Reflect.get(target, key, receiver);
        if ((0, _shared.isSymbol)(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) return res;
        if (!isReadonly) track(target, "get" /* TrackOpTypes.GET */ , key);
        if (shallow) return res;
        if (isRef(res)) // ref unwrapping - skip unwrap for Array + integer key.
        return targetIsArray && (0, _shared.isIntegerKey)(key) ? res : res.value;
        if ((0, _shared.isObject)(res)) // Convert returned value into a proxy as well. we do the isObject check
        // here to avoid invalid value warning. Also need to lazy access readonly
        // and reactive here to avoid circular dependency.
        return isReadonly ? readonly(res) : reactive(res);
        return res;
    };
}
const set$1 = /*#__PURE__*/ createSetter();
const shallowSet = /*#__PURE__*/ createSetter(true);
function createSetter(shallow = false) {
    return function set(target, key, value, receiver) {
        let oldValue = target[key];
        if (isReadonly(oldValue) && isRef(oldValue) && !isRef(value)) return false;
        if (!shallow) {
            if (!isShallow(value) && !isReadonly(value)) {
                oldValue = toRaw(oldValue);
                value = toRaw(value);
            }
            if (!(0, _shared.isArray)(target) && isRef(oldValue) && !isRef(value)) {
                oldValue.value = value;
                return true;
            }
        }
        const hadKey = (0, _shared.isArray)(target) && (0, _shared.isIntegerKey)(key) ? Number(key) < target.length : (0, _shared.hasOwn)(target, key);
        const result = Reflect.set(target, key, value, receiver);
        // don't trigger if target is something up in the prototype chain of original
        if (target === toRaw(receiver)) {
            if (!hadKey) trigger(target, "add" /* TriggerOpTypes.ADD */ , key, value);
            else if ((0, _shared.hasChanged)(value, oldValue)) trigger(target, "set" /* TriggerOpTypes.SET */ , key, value, oldValue);
        }
        return result;
    };
}
function deleteProperty(target, key) {
    const hadKey = (0, _shared.hasOwn)(target, key);
    const oldValue = target[key];
    const result = Reflect.deleteProperty(target, key);
    if (result && hadKey) trigger(target, "delete" /* TriggerOpTypes.DELETE */ , key, undefined, oldValue);
    return result;
}
function has$1(target, key) {
    const result = Reflect.has(target, key);
    if (!(0, _shared.isSymbol)(key) || !builtInSymbols.has(key)) track(target, "has" /* TrackOpTypes.HAS */ , key);
    return result;
}
function ownKeys(target) {
    track(target, "iterate" /* TrackOpTypes.ITERATE */ , (0, _shared.isArray)(target) ? "length" : ITERATE_KEY);
    return Reflect.ownKeys(target);
}
const mutableHandlers = {
    get: get$1,
    set: set$1,
    deleteProperty,
    has: has$1,
    ownKeys
};
const readonlyHandlers = {
    get: readonlyGet,
    set (target, key) {
        warn(`Set operation on key "${String(key)}" failed: target is readonly.`, target);
        return true;
    },
    deleteProperty (target, key) {
        warn(`Delete operation on key "${String(key)}" failed: target is readonly.`, target);
        return true;
    }
};
const shallowReactiveHandlers = /*#__PURE__*/ (0, _shared.extend)({}, mutableHandlers, {
    get: shallowGet,
    set: shallowSet
});
// Props handlers are special in the sense that it should not unwrap top-level
// refs (in order to allow refs to be explicitly passed down), but should
// retain the reactivity of the normal readonly object.
const shallowReadonlyHandlers = /*#__PURE__*/ (0, _shared.extend)({}, readonlyHandlers, {
    get: shallowReadonlyGet
});
const toShallow = (value)=>value;
const getProto = (v)=>Reflect.getPrototypeOf(v);
function get(target, key, isReadonly = false, isShallow = false) {
    // #1772: readonly(reactive(Map)) should return readonly + reactive version
    // of the value
    target = target["__v_raw" /* ReactiveFlags.RAW */ ];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly) {
        if (key !== rawKey) track(rawTarget, "get" /* TrackOpTypes.GET */ , key);
        track(rawTarget, "get" /* TrackOpTypes.GET */ , rawKey);
    }
    const { has  } = getProto(rawTarget);
    const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
    if (has.call(rawTarget, key)) return wrap(target.get(key));
    else if (has.call(rawTarget, rawKey)) return wrap(target.get(rawKey));
    else if (target !== rawTarget) // #3602 readonly(reactive(Map))
    // ensure that the nested reactive `Map` can do tracking for itself
    target.get(key);
}
function has(key, isReadonly = false) {
    const target = this["__v_raw" /* ReactiveFlags.RAW */ ];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly) {
        if (key !== rawKey) track(rawTarget, "has" /* TrackOpTypes.HAS */ , key);
        track(rawTarget, "has" /* TrackOpTypes.HAS */ , rawKey);
    }
    return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
}
function size(target, isReadonly = false) {
    target = target["__v_raw" /* ReactiveFlags.RAW */ ];
    !isReadonly && track(toRaw(target), "iterate" /* TrackOpTypes.ITERATE */ , ITERATE_KEY);
    return Reflect.get(target, "size", target);
}
function add(value) {
    value = toRaw(value);
    const target = toRaw(this);
    const proto = getProto(target);
    const hadKey = proto.has.call(target, value);
    if (!hadKey) {
        target.add(value);
        trigger(target, "add" /* TriggerOpTypes.ADD */ , value, value);
    }
    return this;
}
function set(key, value) {
    value = toRaw(value);
    const target = toRaw(this);
    const { has , get  } = getProto(target);
    let hadKey = has.call(target, key);
    if (!hadKey) {
        key = toRaw(key);
        hadKey = has.call(target, key);
    } else checkIdentityKeys(target, has, key);
    const oldValue = get.call(target, key);
    target.set(key, value);
    if (!hadKey) trigger(target, "add" /* TriggerOpTypes.ADD */ , key, value);
    else if ((0, _shared.hasChanged)(value, oldValue)) trigger(target, "set" /* TriggerOpTypes.SET */ , key, value, oldValue);
    return this;
}
function deleteEntry(key) {
    const target = toRaw(this);
    const { has , get  } = getProto(target);
    let hadKey = has.call(target, key);
    if (!hadKey) {
        key = toRaw(key);
        hadKey = has.call(target, key);
    } else checkIdentityKeys(target, has, key);
    const oldValue = get ? get.call(target, key) : undefined;
    // forward the operation before queueing reactions
    const result = target.delete(key);
    if (hadKey) trigger(target, "delete" /* TriggerOpTypes.DELETE */ , key, undefined, oldValue);
    return result;
}
function clear() {
    const target = toRaw(this);
    const hadItems = target.size !== 0;
    const oldTarget = (0, _shared.isMap)(target) ? new Map(target) : new Set(target);
    // forward the operation before queueing reactions
    const result = target.clear();
    if (hadItems) trigger(target, "clear" /* TriggerOpTypes.CLEAR */ , undefined, undefined, oldTarget);
    return result;
}
function createForEach(isReadonly, isShallow) {
    return function forEach(callback, thisArg) {
        const observed = this;
        const target = observed["__v_raw" /* ReactiveFlags.RAW */ ];
        const rawTarget = toRaw(target);
        const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
        !isReadonly && track(rawTarget, "iterate" /* TrackOpTypes.ITERATE */ , ITERATE_KEY);
        return target.forEach((value, key)=>{
            // important: make sure the callback is
            // 1. invoked with the reactive map as `this` and 3rd arg
            // 2. the value received should be a corresponding reactive/readonly.
            return callback.call(thisArg, wrap(value), wrap(key), observed);
        });
    };
}
function createIterableMethod(method, isReadonly, isShallow) {
    return function(...args) {
        const target = this["__v_raw" /* ReactiveFlags.RAW */ ];
        const rawTarget = toRaw(target);
        const targetIsMap = (0, _shared.isMap)(rawTarget);
        const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
        const isKeyOnly = method === "keys" && targetIsMap;
        const innerIterator = target[method](...args);
        const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
        !isReadonly && track(rawTarget, "iterate" /* TrackOpTypes.ITERATE */ , isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
        // return a wrapped iterator which returns observed versions of the
        // values emitted from the real iterator
        return {
            // iterator protocol
            next () {
                const { value , done  } = innerIterator.next();
                return done ? {
                    value,
                    done
                } : {
                    value: isPair ? [
                        wrap(value[0]),
                        wrap(value[1])
                    ] : wrap(value),
                    done
                };
            },
            // iterable protocol
            [Symbol.iterator] () {
                return this;
            }
        };
    };
}
function createReadonlyMethod(type) {
    return function(...args) {
        {
            const key = args[0] ? `on key "${args[0]}" ` : ``;
            console.warn(`${(0, _shared.capitalize)(type)} operation ${key}failed: target is readonly.`, toRaw(this));
        }
        return type === "delete" /* TriggerOpTypes.DELETE */  ? false : this;
    };
}
function createInstrumentations() {
    const mutableInstrumentations = {
        get (key) {
            return get(this, key);
        },
        get size () {
            return size(this);
        },
        has,
        add,
        set,
        delete: deleteEntry,
        clear,
        forEach: createForEach(false, false)
    };
    const shallowInstrumentations = {
        get (key) {
            return get(this, key, false, true);
        },
        get size () {
            return size(this);
        },
        has,
        add,
        set,
        delete: deleteEntry,
        clear,
        forEach: createForEach(false, true)
    };
    const readonlyInstrumentations = {
        get (key) {
            return get(this, key, true);
        },
        get size () {
            return size(this, true);
        },
        has (key) {
            return has.call(this, key, true);
        },
        add: createReadonlyMethod("add" /* TriggerOpTypes.ADD */ ),
        set: createReadonlyMethod("set" /* TriggerOpTypes.SET */ ),
        delete: createReadonlyMethod("delete" /* TriggerOpTypes.DELETE */ ),
        clear: createReadonlyMethod("clear" /* TriggerOpTypes.CLEAR */ ),
        forEach: createForEach(true, false)
    };
    const shallowReadonlyInstrumentations = {
        get (key) {
            return get(this, key, true, true);
        },
        get size () {
            return size(this, true);
        },
        has (key) {
            return has.call(this, key, true);
        },
        add: createReadonlyMethod("add" /* TriggerOpTypes.ADD */ ),
        set: createReadonlyMethod("set" /* TriggerOpTypes.SET */ ),
        delete: createReadonlyMethod("delete" /* TriggerOpTypes.DELETE */ ),
        clear: createReadonlyMethod("clear" /* TriggerOpTypes.CLEAR */ ),
        forEach: createForEach(true, true)
    };
    const iteratorMethods = [
        "keys",
        "values",
        "entries",
        Symbol.iterator
    ];
    iteratorMethods.forEach((method)=>{
        mutableInstrumentations[method] = createIterableMethod(method, false, false);
        readonlyInstrumentations[method] = createIterableMethod(method, true, false);
        shallowInstrumentations[method] = createIterableMethod(method, false, true);
        shallowReadonlyInstrumentations[method] = createIterableMethod(method, true, true);
    });
    return [
        mutableInstrumentations,
        readonlyInstrumentations,
        shallowInstrumentations,
        shallowReadonlyInstrumentations
    ];
}
const [mutableInstrumentations, readonlyInstrumentations, shallowInstrumentations, shallowReadonlyInstrumentations] = /* #__PURE__*/ createInstrumentations();
function createInstrumentationGetter(isReadonly, shallow) {
    const instrumentations = shallow ? isReadonly ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly ? readonlyInstrumentations : mutableInstrumentations;
    return (target, key, receiver)=>{
        if (key === "__v_isReactive" /* ReactiveFlags.IS_REACTIVE */ ) return !isReadonly;
        else if (key === "__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ) return isReadonly;
        else if (key === "__v_raw" /* ReactiveFlags.RAW */ ) return target;
        return Reflect.get((0, _shared.hasOwn)(instrumentations, key) && key in target ? instrumentations : target, key, receiver);
    };
}
const mutableCollectionHandlers = {
    get: /*#__PURE__*/ createInstrumentationGetter(false, false)
};
const shallowCollectionHandlers = {
    get: /*#__PURE__*/ createInstrumentationGetter(false, true)
};
const readonlyCollectionHandlers = {
    get: /*#__PURE__*/ createInstrumentationGetter(true, false)
};
const shallowReadonlyCollectionHandlers = {
    get: /*#__PURE__*/ createInstrumentationGetter(true, true)
};
function checkIdentityKeys(target, has, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has.call(target, rawKey)) {
        const type = (0, _shared.toRawType)(target);
        console.warn(`Reactive ${type} contains both the raw and reactive ` + `versions of the same object${type === `Map` ? ` as keys` : ``}, ` + `which can lead to inconsistencies. ` + `Avoid differentiating between the raw and reactive versions ` + `of an object and only use the reactive version if possible.`);
    }
}
const reactiveMap = new WeakMap();
const shallowReactiveMap = new WeakMap();
const readonlyMap = new WeakMap();
const shallowReadonlyMap = new WeakMap();
function targetTypeMap(rawType) {
    switch(rawType){
        case "Object":
        case "Array":
            return 1 /* TargetType.COMMON */ ;
        case "Map":
        case "Set":
        case "WeakMap":
        case "WeakSet":
            return 2 /* TargetType.COLLECTION */ ;
        default:
            return 0 /* TargetType.INVALID */ ;
    }
}
function getTargetType(value) {
    return value["__v_skip" /* ReactiveFlags.SKIP */ ] || !Object.isExtensible(value) ? 0 /* TargetType.INVALID */  : targetTypeMap((0, _shared.toRawType)(value));
}
function reactive(target) {
    // if trying to observe a readonly proxy, return the readonly version.
    if (isReadonly(target)) return target;
    return createReactiveObject(target, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
}
/**
 * Return a shallowly-reactive copy of the original object, where only the root
 * level properties are reactive. It also does not auto-unwrap refs (even at the
 * root level).
 */ function shallowReactive(target) {
    return createReactiveObject(target, false, shallowReactiveHandlers, shallowCollectionHandlers, shallowReactiveMap);
}
/**
 * Creates a readonly copy of the original object. Note the returned copy is not
 * made reactive, but `readonly` can be called on an already reactive object.
 */ function readonly(target) {
    return createReactiveObject(target, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
}
/**
 * Returns a reactive-copy of the original object, where only the root level
 * properties are readonly, and does NOT unwrap refs nor recursively convert
 * returned properties.
 * This is used for creating the props proxy object for stateful components.
 */ function shallowReadonly(target) {
    return createReactiveObject(target, true, shallowReadonlyHandlers, shallowReadonlyCollectionHandlers, shallowReadonlyMap);
}
function createReactiveObject(target, isReadonly, baseHandlers, collectionHandlers, proxyMap) {
    if (!(0, _shared.isObject)(target)) {
        console.warn(`value cannot be made reactive: ${String(target)}`);
        return target;
    }
    // target is already a Proxy, return it.
    // exception: calling readonly() on a reactive object
    if (target["__v_raw" /* ReactiveFlags.RAW */ ] && !(isReadonly && target["__v_isReactive" /* ReactiveFlags.IS_REACTIVE */ ])) return target;
    // target already has corresponding Proxy
    const existingProxy = proxyMap.get(target);
    if (existingProxy) return existingProxy;
    // only specific value types can be observed.
    const targetType = getTargetType(target);
    if (targetType === 0 /* TargetType.INVALID */ ) return target;
    const proxy = new Proxy(target, targetType === 2 /* TargetType.COLLECTION */  ? collectionHandlers : baseHandlers);
    proxyMap.set(target, proxy);
    return proxy;
}
function isReactive(value) {
    if (isReadonly(value)) return isReactive(value["__v_raw" /* ReactiveFlags.RAW */ ]);
    return !!(value && value["__v_isReactive" /* ReactiveFlags.IS_REACTIVE */ ]);
}
function isReadonly(value) {
    return !!(value && value["__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ]);
}
function isShallow(value) {
    return !!(value && value["__v_isShallow" /* ReactiveFlags.IS_SHALLOW */ ]);
}
function isProxy(value) {
    return isReactive(value) || isReadonly(value);
}
function toRaw(observed) {
    const raw = observed && observed["__v_raw" /* ReactiveFlags.RAW */ ];
    return raw ? toRaw(raw) : observed;
}
function markRaw(value) {
    (0, _shared.def)(value, "__v_skip" /* ReactiveFlags.SKIP */ , true);
    return value;
}
const toReactive = (value)=>(0, _shared.isObject)(value) ? reactive(value) : value;
const toReadonly = (value)=>(0, _shared.isObject)(value) ? readonly(value) : value;
function trackRefValue(ref) {
    if (shouldTrack && activeEffect) {
        ref = toRaw(ref);
        trackEffects(ref.dep || (ref.dep = createDep()), {
            target: ref,
            type: "get" /* TrackOpTypes.GET */ ,
            key: "value"
        });
    }
}
function triggerRefValue(ref, newVal) {
    ref = toRaw(ref);
    const dep = ref.dep;
    if (dep) triggerEffects(dep, {
        target: ref,
        type: "set" /* TriggerOpTypes.SET */ ,
        key: "value",
        newValue: newVal
    });
}
function isRef(r) {
    return !!(r && r.__v_isRef === true);
}
function ref(value) {
    return createRef(value, false);
}
function shallowRef(value) {
    return createRef(value, true);
}
function createRef(rawValue, shallow) {
    if (isRef(rawValue)) return rawValue;
    return new RefImpl(rawValue, shallow);
}
class RefImpl {
    constructor(value, __v_isShallow){
        this.__v_isShallow = __v_isShallow;
        this.dep = undefined;
        this.__v_isRef = true;
        this._rawValue = __v_isShallow ? value : toRaw(value);
        this._value = __v_isShallow ? value : toReactive(value);
    }
    get value() {
        trackRefValue(this);
        return this._value;
    }
    set value(newVal) {
        const useDirectValue = this.__v_isShallow || isShallow(newVal) || isReadonly(newVal);
        newVal = useDirectValue ? newVal : toRaw(newVal);
        if ((0, _shared.hasChanged)(newVal, this._rawValue)) {
            this._rawValue = newVal;
            this._value = useDirectValue ? newVal : toReactive(newVal);
            triggerRefValue(this, newVal);
        }
    }
}
function triggerRef(ref) {
    triggerRefValue(ref, (0, ref.value));
}
function unref(ref) {
    return isRef(ref) ? ref.value : ref;
}
const shallowUnwrapHandlers = {
    get: (target, key, receiver)=>unref(Reflect.get(target, key, receiver)),
    set: (target, key, value, receiver)=>{
        const oldValue = target[key];
        if (isRef(oldValue) && !isRef(value)) {
            oldValue.value = value;
            return true;
        } else return Reflect.set(target, key, value, receiver);
    }
};
function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
}
class CustomRefImpl {
    constructor(factory){
        this.dep = undefined;
        this.__v_isRef = true;
        const { get , set  } = factory(()=>trackRefValue(this), ()=>triggerRefValue(this));
        this._get = get;
        this._set = set;
    }
    get value() {
        return this._get();
    }
    set value(newVal) {
        this._set(newVal);
    }
}
function customRef(factory) {
    return new CustomRefImpl(factory);
}
function toRefs(object) {
    if (!isProxy(object)) console.warn(`toRefs() expects a reactive object but received a plain one.`);
    const ret = (0, _shared.isArray)(object) ? new Array(object.length) : {};
    for(const key in object)ret[key] = toRef(object, key);
    return ret;
}
class ObjectRefImpl {
    constructor(_object, _key, _defaultValue){
        this._object = _object;
        this._key = _key;
        this._defaultValue = _defaultValue;
        this.__v_isRef = true;
    }
    get value() {
        const val = this._object[this._key];
        return val === undefined ? this._defaultValue : val;
    }
    set value(newVal) {
        this._object[this._key] = newVal;
    }
    get dep() {
        return getDepFromReactive(toRaw(this._object), this._key);
    }
}
function toRef(object, key, defaultValue) {
    const val = object[key];
    return isRef(val) ? val : new ObjectRefImpl(object, key, defaultValue);
}
var _a$1;
class ComputedRefImpl {
    constructor(getter, _setter, isReadonly, isSSR){
        this._setter = _setter;
        this.dep = undefined;
        this.__v_isRef = true;
        this[_a$1] = false;
        this._dirty = true;
        this.effect = new ReactiveEffect(getter, ()=>{
            if (!this._dirty) {
                this._dirty = true;
                triggerRefValue(this);
            }
        });
        this.effect.computed = this;
        this.effect.active = this._cacheable = !isSSR;
        this["__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ] = isReadonly;
    }
    get value() {
        // the computed ref may get wrapped by other proxies e.g. readonly() #3376
        const self = toRaw(this);
        trackRefValue(self);
        if (self._dirty || !self._cacheable) {
            self._dirty = false;
            self._value = self.effect.run();
        }
        return self._value;
    }
    set value(newValue) {
        this._setter(newValue);
    }
}
_a$1 = "__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ;
function computed(getterOrOptions, debugOptions, isSSR = false) {
    let getter;
    let setter;
    const onlyGetter = (0, _shared.isFunction)(getterOrOptions);
    if (onlyGetter) {
        getter = getterOrOptions;
        setter = ()=>{
            console.warn("Write operation failed: computed value is readonly");
        };
    } else {
        getter = getterOrOptions.get;
        setter = getterOrOptions.set;
    }
    const cRef = new ComputedRefImpl(getter, setter, onlyGetter || !setter, isSSR);
    if (debugOptions && !isSSR) {
        cRef.effect.onTrack = debugOptions.onTrack;
        cRef.effect.onTrigger = debugOptions.onTrigger;
    }
    return cRef;
}
var _a;
const tick = /*#__PURE__*/ Promise.resolve();
const queue = [];
let queued = false;
const scheduler = (fn)=>{
    queue.push(fn);
    if (!queued) {
        queued = true;
        tick.then(flush);
    }
};
const flush = ()=>{
    for(let i = 0; i < queue.length; i++)queue[i]();
    queue.length = 0;
    queued = false;
};
class DeferredComputedRefImpl {
    constructor(getter){
        this.dep = undefined;
        this._dirty = true;
        this.__v_isRef = true;
        this[_a] = true;
        let compareTarget;
        let hasCompareTarget = false;
        let scheduled = false;
        this.effect = new ReactiveEffect(getter, (computedTrigger)=>{
            if (this.dep) {
                if (computedTrigger) {
                    compareTarget = this._value;
                    hasCompareTarget = true;
                } else if (!scheduled) {
                    const valueToCompare = hasCompareTarget ? compareTarget : this._value;
                    scheduled = true;
                    hasCompareTarget = false;
                    scheduler(()=>{
                        if (this.effect.active && this._get() !== valueToCompare) triggerRefValue(this);
                        scheduled = false;
                    });
                }
                // chained upstream computeds are notified synchronously to ensure
                // value invalidation in case of sync access; normal effects are
                // deferred to be triggered in scheduler.
                for (const e of this.dep)if (e.computed instanceof DeferredComputedRefImpl) e.scheduler(true);
            }
            this._dirty = true;
        });
        this.effect.computed = this;
    }
    _get() {
        if (this._dirty) {
            this._dirty = false;
            return this._value = this.effect.run();
        }
        return this._value;
    }
    get value() {
        trackRefValue(this);
        // the computed ref may get wrapped by other proxies e.g. readonly() #3376
        return toRaw(this)._get();
    }
}
_a = "__v_isReadonly" /* ReactiveFlags.IS_READONLY */ ;
function deferredComputed(getter) {
    return new DeferredComputedRefImpl(getter);
}

},{"@vue/shared":"3SM3y","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"3SM3y":[function(require,module,exports) {
/**
 * Make a map and return a function for checking if a key
 * is in that map.
 * IMPORTANT: all calls of this function must be prefixed with
 * \/\*#\_\_PURE\_\_\*\/
 * So that rollup can tree-shake them if necessary.
 */ var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "EMPTY_ARR", ()=>EMPTY_ARR);
parcelHelpers.export(exports, "EMPTY_OBJ", ()=>EMPTY_OBJ);
parcelHelpers.export(exports, "NO", ()=>NO);
parcelHelpers.export(exports, "NOOP", ()=>NOOP);
parcelHelpers.export(exports, "PatchFlagNames", ()=>PatchFlagNames);
parcelHelpers.export(exports, "camelize", ()=>camelize);
parcelHelpers.export(exports, "capitalize", ()=>capitalize);
parcelHelpers.export(exports, "def", ()=>def);
parcelHelpers.export(exports, "escapeHtml", ()=>escapeHtml);
parcelHelpers.export(exports, "escapeHtmlComment", ()=>escapeHtmlComment);
parcelHelpers.export(exports, "extend", ()=>extend);
parcelHelpers.export(exports, "genPropsAccessExp", ()=>genPropsAccessExp);
parcelHelpers.export(exports, "generateCodeFrame", ()=>generateCodeFrame);
parcelHelpers.export(exports, "getGlobalThis", ()=>getGlobalThis);
parcelHelpers.export(exports, "hasChanged", ()=>hasChanged);
parcelHelpers.export(exports, "hasOwn", ()=>hasOwn);
parcelHelpers.export(exports, "hyphenate", ()=>hyphenate);
parcelHelpers.export(exports, "includeBooleanAttr", ()=>includeBooleanAttr);
parcelHelpers.export(exports, "invokeArrayFns", ()=>invokeArrayFns);
parcelHelpers.export(exports, "isArray", ()=>isArray);
parcelHelpers.export(exports, "isBooleanAttr", ()=>isBooleanAttr);
parcelHelpers.export(exports, "isBuiltInDirective", ()=>isBuiltInDirective);
parcelHelpers.export(exports, "isDate", ()=>isDate);
parcelHelpers.export(exports, "isFunction", ()=>isFunction);
parcelHelpers.export(exports, "isGloballyWhitelisted", ()=>isGloballyWhitelisted);
parcelHelpers.export(exports, "isHTMLTag", ()=>isHTMLTag);
parcelHelpers.export(exports, "isIntegerKey", ()=>isIntegerKey);
parcelHelpers.export(exports, "isKnownHtmlAttr", ()=>isKnownHtmlAttr);
parcelHelpers.export(exports, "isKnownSvgAttr", ()=>isKnownSvgAttr);
parcelHelpers.export(exports, "isMap", ()=>isMap);
parcelHelpers.export(exports, "isModelListener", ()=>isModelListener);
parcelHelpers.export(exports, "isObject", ()=>isObject);
parcelHelpers.export(exports, "isOn", ()=>isOn);
parcelHelpers.export(exports, "isPlainObject", ()=>isPlainObject);
parcelHelpers.export(exports, "isPromise", ()=>isPromise);
parcelHelpers.export(exports, "isRegExp", ()=>isRegExp);
parcelHelpers.export(exports, "isReservedProp", ()=>isReservedProp);
parcelHelpers.export(exports, "isSSRSafeAttrName", ()=>isSSRSafeAttrName);
parcelHelpers.export(exports, "isSVGTag", ()=>isSVGTag);
parcelHelpers.export(exports, "isSet", ()=>isSet);
parcelHelpers.export(exports, "isSpecialBooleanAttr", ()=>isSpecialBooleanAttr);
parcelHelpers.export(exports, "isString", ()=>isString);
parcelHelpers.export(exports, "isSymbol", ()=>isSymbol);
parcelHelpers.export(exports, "isVoidTag", ()=>isVoidTag);
parcelHelpers.export(exports, "looseEqual", ()=>looseEqual);
parcelHelpers.export(exports, "looseIndexOf", ()=>looseIndexOf);
parcelHelpers.export(exports, "looseToNumber", ()=>looseToNumber);
parcelHelpers.export(exports, "makeMap", ()=>makeMap);
parcelHelpers.export(exports, "normalizeClass", ()=>normalizeClass);
parcelHelpers.export(exports, "normalizeProps", ()=>normalizeProps);
parcelHelpers.export(exports, "normalizeStyle", ()=>normalizeStyle);
parcelHelpers.export(exports, "objectToString", ()=>objectToString);
parcelHelpers.export(exports, "parseStringStyle", ()=>parseStringStyle);
parcelHelpers.export(exports, "propsToAttrMap", ()=>propsToAttrMap);
parcelHelpers.export(exports, "remove", ()=>remove);
parcelHelpers.export(exports, "slotFlagsText", ()=>slotFlagsText);
parcelHelpers.export(exports, "stringifyStyle", ()=>stringifyStyle);
parcelHelpers.export(exports, "toDisplayString", ()=>toDisplayString);
parcelHelpers.export(exports, "toHandlerKey", ()=>toHandlerKey);
parcelHelpers.export(exports, "toNumber", ()=>toNumber);
parcelHelpers.export(exports, "toRawType", ()=>toRawType);
parcelHelpers.export(exports, "toTypeString", ()=>toTypeString);
var global = arguments[3];
function makeMap(str, expectsLowerCase) {
    const map = Object.create(null);
    const list = str.split(",");
    for(let i = 0; i < list.length; i++)map[list[i]] = true;
    return expectsLowerCase ? (val)=>!!map[val.toLowerCase()] : (val)=>!!map[val];
}
/**
 * dev only flag -> name mapping
 */ const PatchFlagNames = {
    [1 /* PatchFlags.TEXT */ ]: `TEXT`,
    [2 /* PatchFlags.CLASS */ ]: `CLASS`,
    [4 /* PatchFlags.STYLE */ ]: `STYLE`,
    [8 /* PatchFlags.PROPS */ ]: `PROPS`,
    [16 /* PatchFlags.FULL_PROPS */ ]: `FULL_PROPS`,
    [32 /* PatchFlags.HYDRATE_EVENTS */ ]: `HYDRATE_EVENTS`,
    [64 /* PatchFlags.STABLE_FRAGMENT */ ]: `STABLE_FRAGMENT`,
    [128 /* PatchFlags.KEYED_FRAGMENT */ ]: `KEYED_FRAGMENT`,
    [256 /* PatchFlags.UNKEYED_FRAGMENT */ ]: `UNKEYED_FRAGMENT`,
    [512 /* PatchFlags.NEED_PATCH */ ]: `NEED_PATCH`,
    [1024 /* PatchFlags.DYNAMIC_SLOTS */ ]: `DYNAMIC_SLOTS`,
    [2048 /* PatchFlags.DEV_ROOT_FRAGMENT */ ]: `DEV_ROOT_FRAGMENT`,
    [-1 /* PatchFlags.HOISTED */ ]: `HOISTED`,
    [-2 /* PatchFlags.BAIL */ ]: `BAIL`
};
/**
 * Dev only
 */ const slotFlagsText = {
    [1 /* SlotFlags.STABLE */ ]: "STABLE",
    [2 /* SlotFlags.DYNAMIC */ ]: "DYNAMIC",
    [3 /* SlotFlags.FORWARDED */ ]: "FORWARDED"
};
const GLOBALS_WHITE_LISTED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt";
const isGloballyWhitelisted = /*#__PURE__*/ makeMap(GLOBALS_WHITE_LISTED);
const range = 2;
function generateCodeFrame(source, start = 0, end = source.length) {
    // Split the content into individual lines but capture the newline sequence
    // that separated each line. This is important because the actual sequence is
    // needed to properly take into account the full line length for offset
    // comparison
    let lines = source.split(/(\r?\n)/);
    // Separate the lines and newline sequences into separate arrays for easier referencing
    const newlineSequences = lines.filter((_, idx)=>idx % 2 === 1);
    lines = lines.filter((_, idx)=>idx % 2 === 0);
    let count = 0;
    const res = [];
    for(let i = 0; i < lines.length; i++){
        count += lines[i].length + (newlineSequences[i] && newlineSequences[i].length || 0);
        if (count >= start) {
            for(let j = i - range; j <= i + range || end > count; j++){
                if (j < 0 || j >= lines.length) continue;
                const line = j + 1;
                res.push(`${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`);
                const lineLength = lines[j].length;
                const newLineSeqLength = newlineSequences[j] && newlineSequences[j].length || 0;
                if (j === i) {
                    // push underline
                    const pad = start - (count - (lineLength + newLineSeqLength));
                    const length = Math.max(1, end > count ? lineLength - pad : end - start);
                    res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
                } else if (j > i) {
                    if (end > count) {
                        const length = Math.max(Math.min(end - count, lineLength), 1);
                        res.push(`   |  ` + "^".repeat(length));
                    }
                    count += lineLength + newLineSeqLength;
                }
            }
            break;
        }
    }
    return res.join("\n");
}
function normalizeStyle(value) {
    if (isArray(value)) {
        const res = {};
        for(let i = 0; i < value.length; i++){
            const item = value[i];
            const normalized = isString(item) ? parseStringStyle(item) : normalizeStyle(item);
            if (normalized) for(const key in normalized)res[key] = normalized[key];
        }
        return res;
    } else if (isString(value)) return value;
    else if (isObject(value)) return value;
}
const listDelimiterRE = /;(?![^(]*\))/g;
const propertyDelimiterRE = /:([^]+)/;
const styleCommentRE = /\/\*.*?\*\//gs;
function parseStringStyle(cssText) {
    const ret = {};
    cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item)=>{
        if (item) {
            const tmp = item.split(propertyDelimiterRE);
            tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
        }
    });
    return ret;
}
function stringifyStyle(styles) {
    let ret = "";
    if (!styles || isString(styles)) return ret;
    for(const key in styles){
        const value = styles[key];
        const normalizedKey = key.startsWith(`--`) ? key : hyphenate(key);
        if (isString(value) || typeof value === "number") // only render valid values
        ret += `${normalizedKey}:${value};`;
    }
    return ret;
}
function normalizeClass(value) {
    let res = "";
    if (isString(value)) res = value;
    else if (isArray(value)) for(let i = 0; i < value.length; i++){
        const normalized = normalizeClass(value[i]);
        if (normalized) res += normalized + " ";
    }
    else if (isObject(value)) {
        for(const name in value)if (value[name]) res += name + " ";
    }
    return res.trim();
}
function normalizeProps(props) {
    if (!props) return null;
    let { class: klass , style  } = props;
    if (klass && !isString(klass)) props.class = normalizeClass(klass);
    if (style) props.style = normalizeStyle(style);
    return props;
}
// These tag configs are shared between compiler-dom and runtime-dom, so they
// https://developer.mozilla.org/en-US/docs/Web/HTML/Element
const HTML_TAGS = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
// https://developer.mozilla.org/en-US/docs/Web/SVG/Element
const SVG_TAGS = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
const VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
/**
 * Compiler only.
 * Do NOT use in runtime code paths unless behind `(process.env.NODE_ENV !== 'production')` flag.
 */ const isHTMLTag = /*#__PURE__*/ makeMap(HTML_TAGS);
/**
 * Compiler only.
 * Do NOT use in runtime code paths unless behind `(process.env.NODE_ENV !== 'production')` flag.
 */ const isSVGTag = /*#__PURE__*/ makeMap(SVG_TAGS);
/**
 * Compiler only.
 * Do NOT use in runtime code paths unless behind `(process.env.NODE_ENV !== 'production')` flag.
 */ const isVoidTag = /*#__PURE__*/ makeMap(VOID_TAGS);
/**
 * On the client we only need to offer special cases for boolean attributes that
 * have different names from their corresponding dom properties:
 * - itemscope -> N/A
 * - allowfullscreen -> allowFullscreen
 * - formnovalidate -> formNoValidate
 * - ismap -> isMap
 * - nomodule -> noModule
 * - novalidate -> noValidate
 * - readonly -> readOnly
 */ const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
const isSpecialBooleanAttr = /*#__PURE__*/ makeMap(specialBooleanAttrs);
/**
 * The full list is needed during SSR to produce the correct initial markup.
 */ const isBooleanAttr = /*#__PURE__*/ makeMap(specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,` + `loop,open,required,reversed,scoped,seamless,` + `checked,muted,multiple,selected`);
/**
 * Boolean attributes should be included if the value is truthy or ''.
 * e.g. `<select multiple>` compiles to `{ multiple: '' }`
 */ function includeBooleanAttr(value) {
    return !!value || value === "";
}
const unsafeAttrCharRE = /[>/="'\u0009\u000a\u000c\u0020]/;
const attrValidationCache = {};
function isSSRSafeAttrName(name) {
    if (attrValidationCache.hasOwnProperty(name)) return attrValidationCache[name];
    const isUnsafe = unsafeAttrCharRE.test(name);
    if (isUnsafe) console.error(`unsafe attribute name: ${name}`);
    return attrValidationCache[name] = !isUnsafe;
}
const propsToAttrMap = {
    acceptCharset: "accept-charset",
    className: "class",
    htmlFor: "for",
    httpEquiv: "http-equiv"
};
/**
 * Known attributes, this is used for stringification of runtime static nodes
 * so that we don't stringify bindings that cannot be set from HTML.
 * Don't also forget to allow `data-*` and `aria-*`!
 * Generated from https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes
 */ const isKnownHtmlAttr = /*#__PURE__*/ makeMap(`accept,accept-charset,accesskey,action,align,allow,alt,async,` + `autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,` + `border,buffered,capture,challenge,charset,checked,cite,class,code,` + `codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,` + `coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,` + `disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,` + `formaction,formenctype,formmethod,formnovalidate,formtarget,headers,` + `height,hidden,high,href,hreflang,http-equiv,icon,id,importance,integrity,` + `ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,` + `manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,` + `open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,` + `referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,` + `selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,` + `start,step,style,summary,tabindex,target,title,translate,type,usemap,` + `value,width,wrap`);
/**
 * Generated from https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute
 */ const isKnownSvgAttr = /*#__PURE__*/ makeMap(`xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,` + `arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,` + `baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,` + `clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,` + `color-interpolation-filters,color-profile,color-rendering,` + `contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,` + `descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,` + `dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,` + `fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,` + `font-family,font-size,font-size-adjust,font-stretch,font-style,` + `font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,` + `glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,` + `gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,` + `horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,` + `k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,` + `lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,` + `marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,` + `mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,` + `name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,` + `overflow,overline-position,overline-thickness,panose-1,paint-order,path,` + `pathLength,patternContentUnits,patternTransform,patternUnits,ping,` + `pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,` + `preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,` + `rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,` + `restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,` + `specularConstant,specularExponent,speed,spreadMethod,startOffset,` + `stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,` + `strikethrough-position,strikethrough-thickness,string,stroke,` + `stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,` + `stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,` + `systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,` + `text-decoration,text-rendering,textLength,to,transform,transform-origin,` + `type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,` + `unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,` + `v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,` + `vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,` + `writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,` + `xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xml:base,xml:lang,` + `xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`);
const escapeRE = /["'&<>]/;
function escapeHtml(string) {
    const str = "" + string;
    const match = escapeRE.exec(str);
    if (!match) return str;
    let html = "";
    let escaped;
    let index;
    let lastIndex = 0;
    for(index = match.index; index < str.length; index++){
        switch(str.charCodeAt(index)){
            case 34:
                escaped = "&quot;";
                break;
            case 38:
                escaped = "&amp;";
                break;
            case 39:
                escaped = "&#39;";
                break;
            case 60:
                escaped = "&lt;";
                break;
            case 62:
                escaped = "&gt;";
                break;
            default:
                continue;
        }
        if (lastIndex !== index) html += str.slice(lastIndex, index);
        lastIndex = index + 1;
        html += escaped;
    }
    return lastIndex !== index ? html + str.slice(lastIndex, index) : html;
}
// https://www.w3.org/TR/html52/syntax.html#comments
const commentStripRE = /^-?>|<!--|-->|--!>|<!-$/g;
function escapeHtmlComment(src) {
    return src.replace(commentStripRE, "");
}
function looseCompareArrays(a, b) {
    if (a.length !== b.length) return false;
    let equal = true;
    for(let i = 0; equal && i < a.length; i++)equal = looseEqual(a[i], b[i]);
    return equal;
}
function looseEqual(a, b) {
    if (a === b) return true;
    let aValidType = isDate(a);
    let bValidType = isDate(b);
    if (aValidType || bValidType) return aValidType && bValidType ? a.getTime() === b.getTime() : false;
    aValidType = isSymbol(a);
    bValidType = isSymbol(b);
    if (aValidType || bValidType) return a === b;
    aValidType = isArray(a);
    bValidType = isArray(b);
    if (aValidType || bValidType) return aValidType && bValidType ? looseCompareArrays(a, b) : false;
    aValidType = isObject(a);
    bValidType = isObject(b);
    if (aValidType || bValidType) {
        /* istanbul ignore if: this if will probably never be called */ if (!aValidType || !bValidType) return false;
        const aKeysCount = Object.keys(a).length;
        const bKeysCount = Object.keys(b).length;
        if (aKeysCount !== bKeysCount) return false;
        for(const key in a){
            const aHasKey = a.hasOwnProperty(key);
            const bHasKey = b.hasOwnProperty(key);
            if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a[key], b[key])) return false;
        }
    }
    return String(a) === String(b);
}
function looseIndexOf(arr, val) {
    return arr.findIndex((item)=>looseEqual(item, val));
}
/**
 * For converting {{ interpolation }} values to displayed strings.
 * @private
 */ const toDisplayString = (val)=>{
    return isString(val) ? val : val == null ? "" : isArray(val) || isObject(val) && (val.toString === objectToString || !isFunction(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
};
const replacer = (_key, val)=>{
    // can't use isRef here since @vue/shared has no deps
    if (val && val.__v_isRef) return replacer(_key, val.value);
    else if (isMap(val)) return {
        [`Map(${val.size})`]: [
            ...val.entries()
        ].reduce((entries, [key, val])=>{
            entries[`${key} =>`] = val;
            return entries;
        }, {})
    };
    else if (isSet(val)) return {
        [`Set(${val.size})`]: [
            ...val.values()
        ]
    };
    else if (isObject(val) && !isArray(val) && !isPlainObject(val)) return String(val);
    return val;
};
const EMPTY_OBJ = Object.freeze({});
const EMPTY_ARR = Object.freeze([]);
const NOOP = ()=>{};
/**
 * Always return false.
 */ const NO = ()=>false;
const onRE = /^on[^a-z]/;
const isOn = (key)=>onRE.test(key);
const isModelListener = (key)=>key.startsWith("onUpdate:");
const extend = Object.assign;
const remove = (arr, el)=>{
    const i = arr.indexOf(el);
    if (i > -1) arr.splice(i, 1);
};
const hasOwnProperty = Object.prototype.hasOwnProperty;
const hasOwn = (val, key)=>hasOwnProperty.call(val, key);
const isArray = Array.isArray;
const isMap = (val)=>toTypeString(val) === "[object Map]";
const isSet = (val)=>toTypeString(val) === "[object Set]";
const isDate = (val)=>toTypeString(val) === "[object Date]";
const isRegExp = (val)=>toTypeString(val) === "[object RegExp]";
const isFunction = (val)=>typeof val === "function";
const isString = (val)=>typeof val === "string";
const isSymbol = (val)=>typeof val === "symbol";
const isObject = (val)=>val !== null && typeof val === "object";
const isPromise = (val)=>{
    return isObject(val) && isFunction(val.then) && isFunction(val.catch);
};
const objectToString = Object.prototype.toString;
const toTypeString = (value)=>objectToString.call(value);
const toRawType = (value)=>{
    // extract "RawType" from strings like "[object RawType]"
    return toTypeString(value).slice(8, -1);
};
const isPlainObject = (val)=>toTypeString(val) === "[object Object]";
const isIntegerKey = (key)=>isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
const isReservedProp = /*#__PURE__*/ makeMap(// the leading comma is intentional so empty string "" is also included
",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted");
const isBuiltInDirective = /*#__PURE__*/ makeMap("bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo");
const cacheStringFunction = (fn)=>{
    const cache = Object.create(null);
    return (str)=>{
        const hit = cache[str];
        return hit || (cache[str] = fn(str));
    };
};
const camelizeRE = /-(\w)/g;
/**
 * @private
 */ const camelize = cacheStringFunction((str)=>{
    return str.replace(camelizeRE, (_, c)=>c ? c.toUpperCase() : "");
});
const hyphenateRE = /\B([A-Z])/g;
/**
 * @private
 */ const hyphenate = cacheStringFunction((str)=>str.replace(hyphenateRE, "-$1").toLowerCase());
/**
 * @private
 */ const capitalize = cacheStringFunction((str)=>str.charAt(0).toUpperCase() + str.slice(1));
/**
 * @private
 */ const toHandlerKey = cacheStringFunction((str)=>str ? `on${capitalize(str)}` : ``);
// compare whether a value has changed, accounting for NaN.
const hasChanged = (value, oldValue)=>!Object.is(value, oldValue);
const invokeArrayFns = (fns, arg)=>{
    for(let i = 0; i < fns.length; i++)fns[i](arg);
};
const def = (obj, key, value)=>{
    Object.defineProperty(obj, key, {
        configurable: true,
        enumerable: false,
        value
    });
};
/**
 * "123-foo" will be parsed to 123
 * This is used for the .number modifier in v-model
 */ const looseToNumber = (val)=>{
    const n = parseFloat(val);
    return isNaN(n) ? val : n;
};
/**
 * Only conerces number-like strings
 * "123-foo" will be returned as-is
 */ const toNumber = (val)=>{
    const n = isString(val) ? Number(val) : NaN;
    return isNaN(n) ? val : n;
};
let _globalThis;
const getGlobalThis = ()=>{
    return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
};
const identRE = /^[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*$/;
function genPropsAccessExp(name) {
    return identRE.test(name) ? `__props.${name}` : `__props[${JSON.stringify(name)}]`;
}

},{"@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"1O2iU":[function(require,module,exports) {
exports.interopDefault = function(a) {
    return a && a.__esModule ? a : {
        default: a
    };
};
exports.defineInteropFlag = function(a) {
    Object.defineProperty(a, "__esModule", {
        value: true
    });
};
exports.exportAll = function(source, dest) {
    Object.keys(source).forEach(function(key) {
        if (key === "default" || key === "__esModule" || dest.hasOwnProperty(key)) return;
        Object.defineProperty(dest, key, {
            enumerable: true,
            get: function() {
                return source[key];
            }
        });
    });
    return dest;
};
exports.export = function(dest, destName, get) {
    Object.defineProperty(dest, destName, {
        enumerable: true,
        get: get
    });
};

},{}],"5JiMD":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "game_data", ()=>game_data);
parcelHelpers.export(exports, "playSound", ()=>playSound);
parcelHelpers.export(exports, "start", ()=>start);
var _sensorGatt = require("./sensor-gatt");
var _vue = require("vue");
const debug = false;
var game_data = (0, _vue.reactive)({
    sensor: _sensorGatt.state,
    game: {
        game_id: 0,
        game_state: -1,
        game_state_dest: -1,
        game_state_animating: 0,
        game_began: 0,
        // ready_timer: 0, //computes ready set go?
        timeout_timer: 0,
        result_timer: 0,
        debug: debug
    },
    button: {
        triggered: 0
    }
});
var game_state = game_data.game;
var button_state = game_data.button;
var sensor_state = game_data.sensor;
sensor_state.connected = debug;
var sound_arr = [];
function playSound(filename, action, loop = false, time = 0) {
    if (filename.indexOf("intro") >= 0 && game_state.game_state_dest == 0) {
        fn = "intro";
        if (sound_arr[fn] != undefined) {
            sound_arr[fn].paused = true;
            delete sound_arr[fn];
        }
        sound_arr[fn] = new Audio("../sounds/" + ("intro_" + Math.ceil(Math.random() * 4)) + ".mp3");
        sound_arr[fn].loop = loop;
    } else if (action != "stopall") {
        var fn = filename.substring(0, filename.lastIndexOf("."));
        if (sound_arr[fn] == undefined) sound_arr[fn] = new Audio("../sounds/" + filename);
        sound_arr[fn].loop = loop;
    }
    try {
        if (action == "play") sound_arr[fn].play();
        else if (action == "stop") {
            sound_arr[fn].pause();
            sound_arr[fn].currentTime = 0;
        } else if (action == "stopall") for(var key in sound_arr){
            sound_arr[key].pause();
            sound_arr[key].currentTime = 0;
        }
    } catch (err) {
        console.log(err);
    }
}
function game_loop() {
    if (game_state.debug) sensor_state.connected = game_state.debug;
    // SENSOR ERROR
    if (!sensor_state.connected) {
        //error state
        game_state.game_state = -1;
        game_state.game_state_dest = -1;
        game_state.game_state_animating = false;
        // game_state.ready_timer = 0;
        game_state.timeout_timer = 0;
        game_state.game_id = 0;
        sensor_state.game_id = 0;
        sensor_state.punched_num = 0;
        sensor_state.punched = 0;
        return;
    } else if (game_state.game_state_dest == -1) // game_state.game_state = 0; //reset error
    game_state.game_state_dest = 0; //reset error
    var READY = 5000;
    var TIMEOUT = 30000;
    var PUNCH_RECORD = 1000;
    var RESULT = 16000;
    if (button_state.triggered == 1) {
        button_state.triggered = 0;
        game_state.game_state_dest = 1; //start game
    } else {
        if (game_state.game_state_dest == 0) {
            if (game_state.game_state != game_state.game_state_dest) {
                if (!game_state.game_state_animating) game_state.game_state_animating = true;
            }
        } else if (game_state.game_state_dest == 1) {
            if (game_state.game_state != game_state.game_state_dest) {
                if (!game_state.game_state_animating) {
                    game_state.game_state_animating = true;
                    game_state.game_id = 0;
                    game_state.game_began = 0;
                    // game_state.ready_timer = 0;
                    game_state.timeout_timer = 0;
                    game_state.result_timer = 0;
                    sensor_state.game_id = 0;
                    sensor_state.punch_score = 0;
                    sensor_state.punch_id = 0;
                    sensor_state.punched = 0;
                    sensor_state.punched_num = 0;
                }
            }
        } else if (game_state.game_state_dest == 2) {
            if (game_state.game_state != game_state.game_state_dest) {
                if (!game_state.game_state_animating) {
                    game_state.game_state_animating = true;
                    game_state.game_id = Math.random();
                    game_state.game_began = Date.now();
                    sensor_state.game_id = game_state.game_id;
                }
            }
            game_state.timeout_timer = Math.ceil(Math.max(0, TIMEOUT - (Date.now() - game_state.game_began)) / 1000);
            if (game_state.game_id == sensor_state.punch_id) //punch recorded!
            //game end?
            {
                if (Date.now() - sensor_state.punched_time > PUNCH_RECORD) game_state.game_state_dest = 3;
            } else if (Date.now() - game_state.game_began > TIMEOUT) {
                game_state.game_state = -1;
                game_state.game_state_dest = 0;
            }
        } else if (game_state.game_state_dest == 3) {
            if (game_state.game_state != game_state.game_state_dest) {
                if (!game_state.game_state_animating) {
                    game_state.game_state_animating = true;
                    if (game_state.debug) {
                        sensor_state.punched_time = Date.now();
                        sensor_state.punched_num += 1;
                    // sensor_state.punch_score = 33;
                    }
                }
            }
            game_state.result_timer = Math.ceil(Math.max(0, RESULT - (Date.now() - (sensor_state.punched_time + PUNCH_RECORD))) / 1000);
            if (Date.now() - (sensor_state.punched_time + PUNCH_RECORD) > RESULT) {
                if (sensor_state.punched_num >= 2) {
                    game_state.game_state = -1;
                    game_state.game_state_dest = 0;
                    game_state.game_state_animating = false;
                } else {
                    game_state.game_state = 1;
                    game_state.game_state_dest = 2;
                    game_state.game_state_animating = false;
                }
            }
        }
    }
}
async function start() {
    setInterval(()=>{
        game_loop();
        button_state.triggered = 0; //[postprocess]
    }, 50);
}

},{"./sensor-gatt":"byeTi","vue":"gzxs9","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"82TDq":[function(require,module,exports) {
var parcelHelpers = require("@parcel/transformer-js/src/esmodule-helpers.js");
parcelHelpers.defineInteropFlag(exports);
parcelHelpers.export(exports, "Vue3Lottie", ()=>Vue3Lottie);
parcelHelpers.export(exports, "default", ()=>plugin);
parcelHelpers.export(exports, "install", ()=>install);
var _vue = require("vue");
var _lottieWeb = require("lottie-web");
var _lottieWebDefault = parcelHelpers.interopDefault(_lottieWeb);
var global = arguments[3];
var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
var freeGlobal$1 = freeGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal$1 || freeSelf || Function("return this")();
var root$1 = root;
var Symbol$1 = root$1.Symbol;
var Symbol$2 = Symbol$1;
var objectProto$e = Object.prototype;
var hasOwnProperty$b = objectProto$e.hasOwnProperty;
var nativeObjectToString$1 = objectProto$e.toString;
var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
function getRawTag(value) {
    var isOwn = hasOwnProperty$b.call(value, symToStringTag$1), tag = value[symToStringTag$1];
    try {
        value[symToStringTag$1] = void 0;
        var unmasked = true;
    } catch (e) {}
    var result = nativeObjectToString$1.call(value);
    if (unmasked) {
        if (isOwn) value[symToStringTag$1] = tag;
        else delete value[symToStringTag$1];
    }
    return result;
}
var objectProto$d = Object.prototype;
var nativeObjectToString = objectProto$d.toString;
function objectToString(value) {
    return nativeObjectToString.call(value);
}
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
function baseGetTag(value) {
    if (value == null) return value === void 0 ? undefinedTag : nullTag;
    return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
}
function isObjectLike(value) {
    return value != null && typeof value == "object";
}
var isArray = Array.isArray;
var isArray$1 = isArray;
function isObject(value) {
    var type = typeof value;
    return value != null && (type == "object" || type == "function");
}
var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
function isFunction(value) {
    if (!isObject(value)) return false;
    var tag = baseGetTag(value);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
}
var coreJsData = root$1["__core-js_shared__"];
var coreJsData$1 = coreJsData;
var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
}();
function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
}
var funcProto$1 = Function.prototype;
var funcToString$1 = funcProto$1.toString;
function toSource(func) {
    if (func != null) {
        try {
            return funcToString$1.call(func);
        } catch (e) {}
        try {
            return func + "";
        } catch (e) {}
    }
    return "";
}
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto = Function.prototype, objectProto$c = Object.prototype;
var funcToString = funcProto.toString;
var hasOwnProperty$a = objectProto$c.hasOwnProperty;
var reIsNative = RegExp("^" + funcToString.call(hasOwnProperty$a).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
function baseIsNative(value) {
    if (!isObject(value) || isMasked(value)) return false;
    var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
}
function getValue(object, key) {
    return object == null ? void 0 : object[key];
}
function getNative(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : void 0;
}
var WeakMap = getNative(root$1, "WeakMap");
var WeakMap$1 = WeakMap;
var objectCreate = Object.create;
var baseCreate = function() {
    function object() {}
    return function(proto) {
        if (!isObject(proto)) return {};
        if (objectCreate) return objectCreate(proto);
        object.prototype = proto;
        var result = new object();
        object.prototype = void 0;
        return result;
    };
}();
var baseCreate$1 = baseCreate;
function copyArray(source, array) {
    var index = -1, length = source.length;
    array || (array = Array(length));
    while(++index < length)array[index] = source[index];
    return array;
}
var defineProperty = function() {
    try {
        var func = getNative(Object, "defineProperty");
        func({}, "", {});
        return func;
    } catch (e) {}
}();
var defineProperty$1 = defineProperty;
function arrayEach(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (iteratee(array[index], index, array) === false) break;
    }
    return array;
}
var MAX_SAFE_INTEGER$1 = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex(value, length) {
    var type = typeof value;
    length = length == null ? MAX_SAFE_INTEGER$1 : length;
    return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
}
function baseAssignValue(object, key, value) {
    if (key == "__proto__" && defineProperty$1) defineProperty$1(object, key, {
        "configurable": true,
        "enumerable": true,
        "value": value,
        "writable": true
    });
    else object[key] = value;
}
function eq(value, other) {
    return value === other || value !== value && other !== other;
}
var objectProto$b = Object.prototype;
var hasOwnProperty$9 = objectProto$b.hasOwnProperty;
function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty$9.call(object, key) && eq(objValue, value)) || value === void 0 && !(key in object)) baseAssignValue(object, key, value);
}
function copyObject(source, props, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index = -1, length = props.length;
    while(++index < length){
        var key = props[index];
        var newValue = customizer ? customizer(object[key], source[key], key, object, source) : void 0;
        if (newValue === void 0) newValue = source[key];
        if (isNew) baseAssignValue(object, key, newValue);
        else assignValue(object, key, newValue);
    }
    return object;
}
var MAX_SAFE_INTEGER = 9007199254740991;
function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}
function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
}
var objectProto$a = Object.prototype;
function isPrototype(value) {
    var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$a;
    return value === proto;
}
function baseTimes(n, iteratee) {
    var index = -1, result = Array(n);
    while(++index < n)result[index] = iteratee(index);
    return result;
}
var argsTag$3 = "[object Arguments]";
function baseIsArguments(value) {
    return isObjectLike(value) && baseGetTag(value) == argsTag$3;
}
var objectProto$9 = Object.prototype;
var hasOwnProperty$8 = objectProto$9.hasOwnProperty;
var propertyIsEnumerable$1 = objectProto$9.propertyIsEnumerable;
var isArguments = baseIsArguments(function() {
    return arguments;
}()) ? baseIsArguments : function(value) {
    return isObjectLike(value) && hasOwnProperty$8.call(value, "callee") && !propertyIsEnumerable$1.call(value, "callee");
};
var isArguments$1 = isArguments;
function stubFalse() {
    return false;
}
var freeExports$2 = exports && !exports.nodeType && exports;
var freeModule$2 = freeExports$2 && true && module && !module.nodeType && module;
var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
var Buffer$1 = moduleExports$2 ? root$1.Buffer : void 0;
var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : void 0;
var isBuffer = nativeIsBuffer || stubFalse;
var isBuffer$1 = isBuffer;
var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$1 = "[object Function]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$2 = "[object WeakMap]";
var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$4] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$5] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$5] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$2] = false;
function baseIsTypedArray(value) {
    return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}
function baseUnary(func) {
    return function(value) {
        return func(value);
    };
}
var freeExports$1 = exports && !exports.nodeType && exports;
var freeModule$1 = freeExports$1 && true && module && !module.nodeType && module;
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
var freeProcess = moduleExports$1 && freeGlobal$1.process;
var nodeUtil = function() {
    try {
        var types = freeModule$1 && freeModule$1.require && freeModule$1.require("util").types;
        if (types) return types;
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {}
}();
var nodeUtil$1 = nodeUtil;
var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
var isTypedArray$1 = isTypedArray;
var objectProto$8 = Object.prototype;
var hasOwnProperty$7 = objectProto$8.hasOwnProperty;
function arrayLikeKeys(value, inherited) {
    var isArr = isArray$1(value), isArg = !isArr && isArguments$1(value), isBuff = !isArr && !isArg && isBuffer$1(value), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
    for(var key in value)if ((inherited || hasOwnProperty$7.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex(key, length)))) result.push(key);
    return result;
}
function overArg(func, transform) {
    return function(arg) {
        return func(transform(arg));
    };
}
var nativeKeys = overArg(Object.keys, Object);
var nativeKeys$1 = nativeKeys;
var objectProto$7 = Object.prototype;
var hasOwnProperty$6 = objectProto$7.hasOwnProperty;
function baseKeys(object) {
    if (!isPrototype(object)) return nativeKeys$1(object);
    var result = [];
    for(var key in Object(object))if (hasOwnProperty$6.call(object, key) && key != "constructor") result.push(key);
    return result;
}
function keys(object) {
    return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}
function nativeKeysIn(object) {
    var result = [];
    if (object != null) for(var key in Object(object))result.push(key);
    return result;
}
var objectProto$6 = Object.prototype;
var hasOwnProperty$5 = objectProto$6.hasOwnProperty;
function baseKeysIn(object) {
    if (!isObject(object)) return nativeKeysIn(object);
    var isProto = isPrototype(object), result = [];
    for(var key in object)if (!(key == "constructor" && (isProto || !hasOwnProperty$5.call(object, key)))) result.push(key);
    return result;
}
function keysIn(object) {
    return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}
var nativeCreate = getNative(Object, "create");
var nativeCreate$1 = nativeCreate;
function hashClear() {
    this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
    this.size = 0;
}
function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
}
var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
var objectProto$5 = Object.prototype;
var hasOwnProperty$4 = objectProto$5.hasOwnProperty;
function hashGet(key) {
    var data = this.__data__;
    if (nativeCreate$1) {
        var result = data[key];
        return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$4.call(data, key) ? data[key] : void 0;
}
var objectProto$4 = Object.prototype;
var hasOwnProperty$3 = objectProto$4.hasOwnProperty;
function hashHas(key) {
    var data = this.__data__;
    return nativeCreate$1 ? data[key] !== void 0 : hasOwnProperty$3.call(data, key);
}
var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
function hashSet(key, value) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate$1 && value === void 0 ? HASH_UNDEFINED$1 : value;
    return this;
}
function Hash(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
Hash.prototype.clear = hashClear;
Hash.prototype["delete"] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;
function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
}
function assocIndexOf(array, key) {
    var length = array.length;
    while(length--){
        if (eq(array[length][0], key)) return length;
    }
    return -1;
}
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete(key) {
    var data = this.__data__, index = assocIndexOf(data, key);
    if (index < 0) return false;
    var lastIndex = data.length - 1;
    if (index == lastIndex) data.pop();
    else splice.call(data, index, 1);
    --this.size;
    return true;
}
function listCacheGet(key) {
    var data = this.__data__, index = assocIndexOf(data, key);
    return index < 0 ? void 0 : data[index][1];
}
function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
}
function listCacheSet(key, value) {
    var data = this.__data__, index = assocIndexOf(data, key);
    if (index < 0) {
        ++this.size;
        data.push([
            key,
            value
        ]);
    } else data[index][1] = value;
    return this;
}
function ListCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
ListCache.prototype.clear = listCacheClear;
ListCache.prototype["delete"] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;
var Map = getNative(root$1, "Map");
var Map$1 = Map;
function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
        "hash": new Hash(),
        "map": new (Map$1 || ListCache)(),
        "string": new Hash()
    };
}
function isKeyable(value) {
    var type = typeof value;
    return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
}
function getMapData(map, key) {
    var data = map.__data__;
    return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
}
function mapCacheDelete(key) {
    var result = getMapData(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
}
function mapCacheGet(key) {
    return getMapData(this, key).get(key);
}
function mapCacheHas(key) {
    return getMapData(this, key).has(key);
}
function mapCacheSet(key, value) {
    var data = getMapData(this, key), size = data.size;
    data.set(key, value);
    this.size += data.size == size ? 0 : 1;
    return this;
}
function MapCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype["delete"] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;
function arrayPush(array, values) {
    var index = -1, length = values.length, offset = array.length;
    while(++index < length)array[offset + index] = values[index];
    return array;
}
var getPrototype = overArg(Object.getPrototypeOf, Object);
var getPrototype$1 = getPrototype;
function stackClear() {
    this.__data__ = new ListCache();
    this.size = 0;
}
function stackDelete(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
}
function stackGet(key) {
    return this.__data__.get(key);
}
function stackHas(key) {
    return this.__data__.has(key);
}
var LARGE_ARRAY_SIZE = 200;
function stackSet(key, value) {
    var data = this.__data__;
    if (data instanceof ListCache) {
        var pairs = data.__data__;
        if (!Map$1 || pairs.length < LARGE_ARRAY_SIZE - 1) {
            pairs.push([
                key,
                value
            ]);
            this.size = ++data.size;
            return this;
        }
        data = this.__data__ = new MapCache(pairs);
    }
    data.set(key, value);
    this.size = data.size;
    return this;
}
function Stack(entries) {
    var data = this.__data__ = new ListCache(entries);
    this.size = data.size;
}
Stack.prototype.clear = stackClear;
Stack.prototype["delete"] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;
function baseAssign(object, source) {
    return object && copyObject(source, keys(source), object);
}
function baseAssignIn(object, source) {
    return object && copyObject(source, keysIn(source), object);
}
var freeExports = exports && !exports.nodeType && exports;
var freeModule = freeExports && true && module && !module.nodeType && module;
var moduleExports = freeModule && freeModule.exports === freeExports;
var Buffer = moduleExports ? root$1.Buffer : void 0, allocUnsafe = Buffer ? Buffer.allocUnsafe : void 0;
function cloneBuffer(buffer, isDeep) {
    if (isDeep) return buffer.slice();
    var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
    buffer.copy(result);
    return result;
}
function arrayFilter(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
    while(++index < length){
        var value = array[index];
        if (predicate(value, index, array)) result[resIndex++] = value;
    }
    return result;
}
function stubArray() {
    return [];
}
var objectProto$3 = Object.prototype;
var propertyIsEnumerable = objectProto$3.propertyIsEnumerable;
var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
var getSymbols = !nativeGetSymbols$1 ? stubArray : function(object) {
    if (object == null) return [];
    object = Object(object);
    return arrayFilter(nativeGetSymbols$1(object), function(symbol) {
        return propertyIsEnumerable.call(object, symbol);
    });
};
var getSymbols$1 = getSymbols;
function copySymbols(source, object) {
    return copyObject(source, getSymbols$1(source), object);
}
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
    var result = [];
    while(object){
        arrayPush(result, getSymbols$1(object));
        object = getPrototype$1(object);
    }
    return result;
};
var getSymbolsIn$1 = getSymbolsIn;
function copySymbolsIn(source, object) {
    return copyObject(source, getSymbolsIn$1(source), object);
}
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray$1(object) ? result : arrayPush(result, symbolsFunc(object));
}
function getAllKeys(object) {
    return baseGetAllKeys(object, keys, getSymbols$1);
}
function getAllKeysIn(object) {
    return baseGetAllKeys(object, keysIn, getSymbolsIn$1);
}
var DataView = getNative(root$1, "DataView");
var DataView$1 = DataView;
var Promise$1 = getNative(root$1, "Promise");
var Promise$2 = Promise$1;
var Set = getNative(root$1, "Set");
var Set$1 = Set;
var mapTag$4 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$4 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
var dataViewTag$3 = "[object DataView]";
var dataViewCtorString = toSource(DataView$1), mapCtorString = toSource(Map$1), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$1), weakMapCtorString = toSource(WeakMap$1);
var getTag = baseGetTag;
if (DataView$1 && getTag(new DataView$1(new ArrayBuffer(1))) != dataViewTag$3 || Map$1 && getTag(new Map$1()) != mapTag$4 || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$1 && getTag(new Set$1()) != setTag$4 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$1) getTag = function(value) {
    var result = baseGetTag(value), Ctor = result == objectTag$2 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
    if (ctorString) switch(ctorString){
        case dataViewCtorString:
            return dataViewTag$3;
        case mapCtorString:
            return mapTag$4;
        case promiseCtorString:
            return promiseTag;
        case setCtorString:
            return setTag$4;
        case weakMapCtorString:
            return weakMapTag$1;
    }
    return result;
};
var getTag$1 = getTag;
var objectProto$2 = Object.prototype;
var hasOwnProperty$2 = objectProto$2.hasOwnProperty;
function initCloneArray(array) {
    var length = array.length, result = new array.constructor(length);
    if (length && typeof array[0] == "string" && hasOwnProperty$2.call(array, "index")) {
        result.index = array.index;
        result.input = array.input;
    }
    return result;
}
var Uint8Array = root$1.Uint8Array;
var Uint8Array$1 = Uint8Array;
function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
    return result;
}
function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
var reFlags = /\w*$/;
function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
}
var symbolProto$1 = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf$1 = symbolProto$1 ? symbolProto$1.valueOf : void 0;
function cloneSymbol(symbol) {
    return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
}
function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
var boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", mapTag$3 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$2 = "[object RegExp]", setTag$3 = "[object Set]", stringTag$2 = "[object String]", symbolTag$2 = "[object Symbol]";
var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch(tag){
        case arrayBufferTag$2:
            return cloneArrayBuffer(object);
        case boolTag$2:
        case dateTag$2:
            return new Ctor(+object);
        case dataViewTag$2:
            return cloneDataView(object, isDeep);
        case float32Tag$1:
        case float64Tag$1:
        case int8Tag$1:
        case int16Tag$1:
        case int32Tag$1:
        case uint8Tag$1:
        case uint8ClampedTag$1:
        case uint16Tag$1:
        case uint32Tag$1:
            return cloneTypedArray(object, isDeep);
        case mapTag$3:
            return new Ctor();
        case numberTag$2:
        case stringTag$2:
            return new Ctor(object);
        case regexpTag$2:
            return cloneRegExp(object);
        case setTag$3:
            return new Ctor();
        case symbolTag$2:
            return cloneSymbol(object);
    }
}
function initCloneObject(object) {
    return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate$1(getPrototype$1(object)) : {};
}
var mapTag$2 = "[object Map]";
function baseIsMap(value) {
    return isObjectLike(value) && getTag$1(value) == mapTag$2;
}
var nodeIsMap = nodeUtil$1 && nodeUtil$1.isMap;
var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
var isMap$1 = isMap;
var setTag$2 = "[object Set]";
function baseIsSet(value) {
    return isObjectLike(value) && getTag$1(value) == setTag$2;
}
var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;
var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
var isSet$1 = isSet;
var CLONE_DEEP_FLAG$1 = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$1 = 4;
var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag$1 = "[object Map]", numberTag$1 = "[object Number]", objectTag$1 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$1 = "[object Set]", stringTag$1 = "[object String]", symbolTag$1 = "[object Symbol]", weakMapTag = "[object WeakMap]";
var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
var cloneableTags = {};
cloneableTags[argsTag$1] = cloneableTags[arrayTag$1] = cloneableTags[arrayBufferTag$1] = cloneableTags[dataViewTag$1] = cloneableTags[boolTag$1] = cloneableTags[dateTag$1] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag$1] = cloneableTags[numberTag$1] = cloneableTags[objectTag$1] = cloneableTags[regexpTag$1] = cloneableTags[setTag$1] = cloneableTags[stringTag$1] = cloneableTags[symbolTag$1] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
cloneableTags[errorTag$1] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
function baseClone(value, bitmask, customizer, key, object, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG$1, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$1;
    if (customizer) result = object ? customizer(value, key, object, stack) : customizer(value);
    if (result !== void 0) return result;
    if (!isObject(value)) return value;
    var isArr = isArray$1(value);
    if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) return copyArray(value, result);
    } else {
        var tag = getTag$1(value), isFunc = tag == funcTag || tag == genTag;
        if (isBuffer$1(value)) return cloneBuffer(value, isDeep);
        if (tag == objectTag$1 || tag == argsTag$1 || isFunc && !object) {
            result = isFlat || isFunc ? {} : initCloneObject(value);
            if (!isDeep) return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
        } else {
            if (!cloneableTags[tag]) return object ? value : {};
            result = initCloneByTag(value, tag, isDeep);
        }
    }
    stack || (stack = new Stack());
    var stacked = stack.get(value);
    if (stacked) return stacked;
    stack.set(value, result);
    if (isSet$1(value)) value.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
    });
    else if (isMap$1(value)) value.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
    var props = isArr ? void 0 : keysFunc(value);
    arrayEach(props || value, function(subValue, key2) {
        if (props) {
            key2 = subValue;
            subValue = value[key2];
        }
        assignValue(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
}
var CLONE_DEEP_FLAG = 1, CLONE_SYMBOLS_FLAG = 4;
function cloneDeep(value) {
    return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
}
var HASH_UNDEFINED = "__lodash_hash_undefined__";
function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);
    return this;
}
function setCacheHas(value) {
    return this.__data__.has(value);
}
function SetCache(values) {
    var index = -1, length = values == null ? 0 : values.length;
    this.__data__ = new MapCache();
    while(++index < length)this.add(values[index]);
}
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;
function arraySome(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (predicate(array[index], index, array)) return true;
    }
    return false;
}
function cacheHas(cache, key) {
    return cache.has(key);
}
var COMPARE_PARTIAL_FLAG$3 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, arrLength = array.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) return false;
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) return arrStacked == other && othStacked == array;
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$1 ? new SetCache() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while(++index < arrLength){
        var arrValue = array[index], othValue = other[index];
        if (customizer) var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        if (compared !== void 0) {
            if (compared) continue;
            result = false;
            break;
        }
        if (seen) {
            if (!arraySome(other, function(othValue2, othIndex) {
                if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) return seen.push(othIndex);
            })) {
                result = false;
                break;
            }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
            result = false;
            break;
        }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
}
function mapToArray(map) {
    var index = -1, result = Array(map.size);
    map.forEach(function(value, key) {
        result[++index] = [
            key,
            value
        ];
    });
    return result;
}
function setToArray(set) {
    var index = -1, result = Array(set.size);
    set.forEach(function(value) {
        result[++index] = value;
    });
    return result;
}
var COMPARE_PARTIAL_FLAG$2 = 1, COMPARE_UNORDERED_FLAG = 2;
var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]";
var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]";
var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
    switch(tag){
        case dataViewTag:
            if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) return false;
            object = object.buffer;
            other = other.buffer;
        case arrayBufferTag:
            if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array$1(object), new Uint8Array$1(other))) return false;
            return true;
        case boolTag:
        case dateTag:
        case numberTag:
            return eq(+object, +other);
        case errorTag:
            return object.name == other.name && object.message == other.message;
        case regexpTag:
        case stringTag:
            return object == other + "";
        case mapTag:
            var convert = mapToArray;
        case setTag:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG$2;
            convert || (convert = setToArray);
            if (object.size != other.size && !isPartial) return false;
            var stacked = stack.get(object);
            if (stacked) return stacked == other;
            bitmask |= COMPARE_UNORDERED_FLAG;
            stack.set(object, other);
            var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
            stack["delete"](object);
            return result;
        case symbolTag:
            if (symbolValueOf) return symbolValueOf.call(object) == symbolValueOf.call(other);
    }
    return false;
}
var COMPARE_PARTIAL_FLAG$1 = 1;
var objectProto$1 = Object.prototype;
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$1, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) return false;
    var index = objLength;
    while(index--){
        var key = objProps[index];
        if (!(isPartial ? key in other : hasOwnProperty$1.call(other, key))) return false;
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) return objStacked == other && othStacked == object;
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while(++index < objLength){
        key = objProps[index];
        var objValue = object[key], othValue = other[key];
        if (customizer) var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
            result = false;
            break;
        }
        skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
        var objCtor = object.constructor, othCtor = other.constructor;
        if (objCtor != othCtor && "constructor" in object && "constructor" in other && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) result = false;
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
}
var COMPARE_PARTIAL_FLAG = 1;
var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$1(object), othIsArr = isArray$1(other), objTag = objIsArr ? arrayTag : getTag$1(object), othTag = othIsArr ? arrayTag : getTag$1(other);
    objTag = objTag == argsTag ? objectTag : objTag;
    othTag = othTag == argsTag ? objectTag : othTag;
    var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object)) {
        if (!isBuffer$1(other)) return false;
        objIsArr = true;
        objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
        stack || (stack = new Stack());
        return objIsArr || isTypedArray$1(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty.call(other, "__wrapped__");
        if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
            stack || (stack = new Stack());
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
    }
    if (!isSameTag) return false;
    stack || (stack = new Stack());
    return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}
function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) return true;
    if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) return value !== value && other !== other;
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}
function isEqual(value, other) {
    return baseIsEqual(value, other);
}
var vue3Lottie_vue_vue_type_style_index_0_lang = "";
var _export_sfc = (sfc, props)=>{
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props)target[key] = val;
    return target;
};
const _sfc_main = (0, _vue.defineComponent)({
    props: {
        animationData: {
            type: Object,
            default: ()=>({})
        },
        animationLink: {
            type: String,
            default: ""
        },
        loop: {
            type: [
                Boolean,
                Number
            ],
            default: true
        },
        autoPlay: {
            type: Boolean,
            default: true
        },
        width: {
            type: [
                Number,
                String
            ],
            default: "100%"
        },
        height: {
            type: [
                Number,
                String
            ],
            default: "100%"
        },
        speed: {
            type: Number,
            default: 1
        },
        delay: {
            type: Number,
            default: 0
        },
        direction: {
            type: String,
            default: "forward"
        },
        pauseOnHover: {
            type: Boolean,
            default: false
        },
        playOnHover: {
            type: Boolean,
            default: false
        },
        backgroundColor: {
            type: String,
            default: "transparent"
        },
        pauseAnimation: {
            type: Boolean,
            default: false
        },
        renderer: {
            type: String,
            default: "svg"
        },
        rendererSettings: {
            type: Object,
            default: ()=>({})
        }
    },
    emits: {
        onComplete: null,
        onLoopComplete: null,
        onEnterFrame: null,
        onSegmentStart: null,
        onAnimationLoaded: null
    },
    setup (props, { emit: emits  }) {
        let lottieAnimation = (0, _vue.ref)(null);
        const elementid = (0, _vue.ref)("");
        let direction = 1;
        const checkIfContainerExists = (elementID)=>{
            if (document.querySelector(`[data-id="${elementID}"]`) !== null) return true;
            else return false;
        };
        const loadLottie = async (element)=>{
            let autoPlay = props.autoPlay;
            if (props.playOnHover) autoPlay = false;
            let animationData = {};
            if (isEqual(props.animationData, {}) === false) animationData = cloneDeep(props.animationData);
            if (props.animationLink != "") try {
                const response = await fetch(props.animationLink);
                const json = await response.json();
                animationData = json;
            } catch (error) {
                console.error(error);
                return;
            }
            let loop = props.loop;
            if (typeof loop === "number") {
                if (loop > 0) loop = loop - 1;
            }
            if (props.delay > 0) autoPlay = false;
            const lottieAnimationConfig = {
                container: element,
                renderer: props.renderer,
                loop,
                autoplay: autoPlay,
                animationData
            };
            if (isEqual(props.rendererSettings, {}) === false) lottieAnimationConfig.rendererSettings = props.rendererSettings;
            lottieAnimation = (0, _lottieWebDefault.default).loadAnimation(lottieAnimationConfig);
            setTimeout(()=>{
                autoPlay = props.autoPlay;
                if (props.playOnHover) lottieAnimation.pause();
                else if (autoPlay) lottieAnimation.play();
                else lottieAnimation.pause();
                emits("onAnimationLoaded");
            }, props.delay);
            lottieAnimation.setSpeed(props.speed);
            if (props.direction === "reverse") lottieAnimation.setDirection(-1);
            if (props.direction === "normal") lottieAnimation.setDirection(1);
            if (props.pauseAnimation) lottieAnimation.pause();
            else if (props.playOnHover) lottieAnimation.pause();
            lottieAnimation.addEventListener("loopComplete", ()=>{
                if (props.direction === "alternate") {
                    lottieAnimation.stop();
                    direction = direction * -1;
                    lottieAnimation.setDirection(direction);
                    lottieAnimation.play();
                }
                emits("onLoopComplete");
            });
            lottieAnimation.addEventListener("complete", ()=>{
                emits("onComplete");
            });
            lottieAnimation.addEventListener("enterFrame", ()=>{
                emits("onEnterFrame");
            });
            lottieAnimation.addEventListener("segmentStart", ()=>{
                emits("onSegmentStart");
            });
        };
        const getCurrentStyle = (0, _vue.computed)(()=>{
            let width = props.width;
            let height = props.height;
            if (typeof props.width === "number") width = `${props.width}px`;
            if (typeof props.height === "number") height = `${props.height}px`;
            let cssVariables = {
                "--lottie-animation-container-width": width,
                "--lottie-animation-container-height": height,
                "--lottie-animation-container-background-color": props.backgroundColor
            };
            return cssVariables;
        });
        const hoverStarted = ()=>{
            if (lottieAnimation && props.pauseOnHover) lottieAnimation.pause();
            if (lottieAnimation && props.playOnHover) lottieAnimation.play();
        };
        const hoverEnded = ()=>{
            if (lottieAnimation && props.pauseOnHover) lottieAnimation.play();
            if (lottieAnimation && props.playOnHover) lottieAnimation.pause();
        };
        (0, _vue.watch)(()=>props.pauseAnimation, ()=>{
            if ((props.pauseOnHover || props.playOnHover) && props.pauseAnimation) {
                console.error("If you are using pauseAnimation prop for Vue3-Lottie, please remove the props pauseOnHover and playOnHover");
                return;
            }
            if (lottieAnimation) {
                if (props.pauseAnimation) lottieAnimation.pause();
                else lottieAnimation.play();
            }
        });
        const play = ()=>{
            if (lottieAnimation) lottieAnimation.play();
        };
        const pause = ()=>{
            if (lottieAnimation) lottieAnimation.pause();
        };
        const stop = ()=>{
            if (lottieAnimation) lottieAnimation.stop();
        };
        const destroy = ()=>{
            if (lottieAnimation) lottieAnimation.destroy();
        };
        const setSpeed = (speed = 1)=>{
            if (speed <= 0) throw new Error("Speed must be greater than 0");
            if (lottieAnimation) lottieAnimation.setSpeed(speed);
        };
        const setDirection = (direction2)=>{
            if (lottieAnimation) {
                if (direction2 === "forward") lottieAnimation.setDirection(1);
                else if (direction2 === "reverse") lottieAnimation.setDirection(-1);
            }
        };
        const goToAndStop = (frame, isFrame = true)=>{
            if (lottieAnimation) lottieAnimation.goToAndStop(frame, isFrame);
        };
        const goToAndPlay = (frame, isFrame = true)=>{
            if (lottieAnimation) lottieAnimation.goToAndPlay(frame, isFrame);
        };
        const playSegments = (segments, forceFlag = false)=>{
            if (lottieAnimation) lottieAnimation.playSegments(segments, forceFlag);
        };
        const setSubFrame = (useSubFrame = true)=>{
            if (lottieAnimation) lottieAnimation.setSubframe(useSubFrame);
        };
        const getDuration = (inFrames = true)=>{
            if (lottieAnimation) return lottieAnimation.getDuration(inFrames);
        };
        const updateDocumentData = (documentData, index = 0)=>{
            if (lottieAnimation) lottieAnimation.renderer.elements[index].updateDocumentData(documentData);
        };
        const makeid = (length)=>{
            var result = "";
            var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            var charactersLength = characters.length;
            for(var i = 0; i < length; i++)result += characters.charAt(Math.floor(Math.random() * charactersLength));
            return result;
        };
        const setupLottie = (elementID)=>{
            if (props.pauseOnHover && props.playOnHover) throw new Error("You cannot set pauseOnHover and playOnHover for Vue3-Lottie at the same time.");
            if (props.animationLink === "" && isEqual(props.animationData, {})) {
                console.log(props.animationData, "animationData", props.animationLink, "animationLink");
                throw new Error("You must provide either animationLink or animationData");
            }
            const interval = setInterval(()=>{
                if (checkIfContainerExists(elementID)) {
                    clearInterval(interval);
                    const element = document.querySelector(`[data-id="${elementID}" ]`);
                    if (element) loadLottie(element);
                }
            }, 0);
        };
        (0, _vue.onMounted)(async ()=>{
            elementid.value = makeid(20);
            setupLottie(elementid.value);
        });
        return {
            elementid,
            hoverEnded,
            hoverStarted,
            getCurrentStyle,
            play,
            pause,
            stop,
            destroy,
            setSpeed,
            setDirection,
            goToAndStop,
            goToAndPlay,
            playSegments,
            setSubFrame,
            getDuration,
            updateDocumentData
        };
    }
});
const _hoisted_1 = [
    "data-id"
];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
    return (0, _vue.openBlock)(), (0, _vue.createElementBlock)("div", {
        "data-id": _ctx.elementid,
        class: "lottie-animation-container",
        style: (0, _vue.normalizeStyle)(_ctx.getCurrentStyle),
        onMouseenter: _cache[0] || (_cache[0] = (...args)=>_ctx.hoverStarted && _ctx.hoverStarted(...args)),
        onMouseleave: _cache[1] || (_cache[1] = (...args)=>_ctx.hoverEnded && _ctx.hoverEnded(...args))
    }, null, 44, _hoisted_1);
}
var Vue3Lottie = /* @__PURE__ */ _export_sfc(_sfc_main, [
    [
        "render",
        _sfc_render
    ]
]);
function install(app, options) {
    const finalOptions = Object.assign({}, {
        name: "Vue3Lottie"
    }, options);
    app.component(`${finalOptions.name}`, Vue3Lottie);
}
const plugin = {
    version: "2.5.0",
    install
};

},{"vue":"gzxs9","lottie-web":"7GKqM","@parcel/transformer-js/src/esmodule-helpers.js":"1O2iU"}],"7GKqM":[function(require,module,exports) {
typeof navigator !== "undefined" && function(global, factory) {
    module.exports = factory();
}(this, function() {
    "use strict";
    var svgNS = "http://www.w3.org/2000/svg";
    var locationHref = "";
    var _useWebWorker = false;
    var initialDefaultFrame = -999999;
    var setWebWorker = function setWebWorker(flag) {
        _useWebWorker = !!flag;
    };
    var getWebWorker = function getWebWorker() {
        return _useWebWorker;
    };
    var setLocationHref = function setLocationHref(value) {
        locationHref = value;
    };
    var getLocationHref = function getLocationHref() {
        return locationHref;
    };
    function createTag(type) {
        // return {appendChild:function(){},setAttribute:function(){},style:{}}
        return document.createElement(type);
    }
    function extendPrototype(sources, destination) {
        var i;
        var len = sources.length;
        var sourcePrototype;
        for(i = 0; i < len; i += 1){
            sourcePrototype = sources[i].prototype;
            for(var attr in sourcePrototype)if (Object.prototype.hasOwnProperty.call(sourcePrototype, attr)) destination.prototype[attr] = sourcePrototype[attr];
        }
    }
    function getDescriptor(object, prop) {
        return Object.getOwnPropertyDescriptor(object, prop);
    }
    function createProxyFunction(prototype) {
        function ProxyFunction() {}
        ProxyFunction.prototype = prototype;
        return ProxyFunction;
    }
    // import Howl from '../../3rd_party/howler';
    var audioControllerFactory = function() {
        function AudioController(audioFactory) {
            this.audios = [];
            this.audioFactory = audioFactory;
            this._volume = 1;
            this._isMuted = false;
        }
        AudioController.prototype = {
            addAudio: function addAudio(audio) {
                this.audios.push(audio);
            },
            pause: function pause() {
                var i;
                var len = this.audios.length;
                for(i = 0; i < len; i += 1)this.audios[i].pause();
            },
            resume: function resume() {
                var i;
                var len = this.audios.length;
                for(i = 0; i < len; i += 1)this.audios[i].resume();
            },
            setRate: function setRate(rateValue) {
                var i;
                var len = this.audios.length;
                for(i = 0; i < len; i += 1)this.audios[i].setRate(rateValue);
            },
            createAudio: function createAudio(assetPath) {
                if (this.audioFactory) return this.audioFactory(assetPath);
                if (window.Howl) return new window.Howl({
                    src: [
                        assetPath
                    ]
                });
                return {
                    isPlaying: false,
                    play: function play() {
                        this.isPlaying = true;
                    },
                    seek: function seek() {
                        this.isPlaying = false;
                    },
                    playing: function playing() {},
                    rate: function rate() {},
                    setVolume: function setVolume() {}
                };
            },
            setAudioFactory: function setAudioFactory(audioFactory) {
                this.audioFactory = audioFactory;
            },
            setVolume: function setVolume(value) {
                this._volume = value;
                this._updateVolume();
            },
            mute: function mute() {
                this._isMuted = true;
                this._updateVolume();
            },
            unmute: function unmute() {
                this._isMuted = false;
                this._updateVolume();
            },
            getVolume: function getVolume() {
                return this._volume;
            },
            _updateVolume: function _updateVolume() {
                var i;
                var len = this.audios.length;
                for(i = 0; i < len; i += 1)this.audios[i].volume(this._volume * (this._isMuted ? 0 : 1));
            }
        };
        return function() {
            return new AudioController();
        };
    }();
    var createTypedArray = function() {
        function createRegularArray(type, len) {
            var i = 0;
            var arr = [];
            var value;
            switch(type){
                case "int16":
                case "uint8c":
                    value = 1;
                    break;
                default:
                    value = 1.1;
                    break;
            }
            for(i = 0; i < len; i += 1)arr.push(value);
            return arr;
        }
        function createTypedArrayFactory(type, len) {
            if (type === "float32") return new Float32Array(len);
            if (type === "int16") return new Int16Array(len);
            if (type === "uint8c") return new Uint8ClampedArray(len);
            return createRegularArray(type, len);
        }
        if (typeof Uint8ClampedArray === "function" && typeof Float32Array === "function") return createTypedArrayFactory;
        return createRegularArray;
    }();
    function createSizedArray(len) {
        return Array.apply(null, {
            length: len
        });
    }
    function _typeof$6(obj) {
        "@babel/helpers - typeof";
        if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") _typeof$6 = function _typeof(obj) {
            return typeof obj;
        };
        else _typeof$6 = function _typeof(obj) {
            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
        return _typeof$6(obj);
    }
    var subframeEnabled = true;
    var expressionsPlugin = null;
    var expressionsInterfaces = null;
    var idPrefix$1 = "";
    var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
    var _shouldRoundValues = false;
    var bmPow = Math.pow;
    var bmSqrt = Math.sqrt;
    var bmFloor = Math.floor;
    var bmMax = Math.max;
    var bmMin = Math.min;
    var BMMath = {};
    (function() {
        var propertyNames = [
            "abs",
            "acos",
            "acosh",
            "asin",
            "asinh",
            "atan",
            "atanh",
            "atan2",
            "ceil",
            "cbrt",
            "expm1",
            "clz32",
            "cos",
            "cosh",
            "exp",
            "floor",
            "fround",
            "hypot",
            "imul",
            "log",
            "log1p",
            "log2",
            "log10",
            "max",
            "min",
            "pow",
            "random",
            "round",
            "sign",
            "sin",
            "sinh",
            "sqrt",
            "tan",
            "tanh",
            "trunc",
            "E",
            "LN10",
            "LN2",
            "LOG10E",
            "LOG2E",
            "PI",
            "SQRT1_2",
            "SQRT2"
        ];
        var i;
        var len = propertyNames.length;
        for(i = 0; i < len; i += 1)BMMath[propertyNames[i]] = Math[propertyNames[i]];
    })();
    function ProjectInterface$1() {
        return {};
    }
    BMMath.random = Math.random;
    BMMath.abs = function(val) {
        var tOfVal = _typeof$6(val);
        if (tOfVal === "object" && val.length) {
            var absArr = createSizedArray(val.length);
            var i;
            var len = val.length;
            for(i = 0; i < len; i += 1)absArr[i] = Math.abs(val[i]);
            return absArr;
        }
        return Math.abs(val);
    };
    var defaultCurveSegments = 150;
    var degToRads = Math.PI / 180;
    var roundCorner = 0.5519;
    function roundValues(flag) {
        _shouldRoundValues = !!flag;
    }
    function bmRnd(value) {
        if (_shouldRoundValues) return Math.round(value);
        return value;
    }
    function styleDiv(element) {
        element.style.position = "absolute";
        element.style.top = 0;
        element.style.left = 0;
        element.style.display = "block";
        element.style.transformOrigin = "0 0";
        element.style.webkitTransformOrigin = "0 0";
        element.style.backfaceVisibility = "visible";
        element.style.webkitBackfaceVisibility = "visible";
        element.style.transformStyle = "preserve-3d";
        element.style.webkitTransformStyle = "preserve-3d";
        element.style.mozTransformStyle = "preserve-3d";
    }
    function BMEnterFrameEvent(type, currentTime, totalTime, frameMultiplier) {
        this.type = type;
        this.currentTime = currentTime;
        this.totalTime = totalTime;
        this.direction = frameMultiplier < 0 ? -1 : 1;
    }
    function BMCompleteEvent(type, frameMultiplier) {
        this.type = type;
        this.direction = frameMultiplier < 0 ? -1 : 1;
    }
    function BMCompleteLoopEvent(type, totalLoops, currentLoop, frameMultiplier) {
        this.type = type;
        this.currentLoop = currentLoop;
        this.totalLoops = totalLoops;
        this.direction = frameMultiplier < 0 ? -1 : 1;
    }
    function BMSegmentStartEvent(type, firstFrame, totalFrames) {
        this.type = type;
        this.firstFrame = firstFrame;
        this.totalFrames = totalFrames;
    }
    function BMDestroyEvent(type, target) {
        this.type = type;
        this.target = target;
    }
    function BMRenderFrameErrorEvent(nativeError, currentTime) {
        this.type = "renderFrameError";
        this.nativeError = nativeError;
        this.currentTime = currentTime;
    }
    function BMConfigErrorEvent(nativeError) {
        this.type = "configError";
        this.nativeError = nativeError;
    }
    function BMAnimationConfigErrorEvent(type, nativeError) {
        this.type = type;
        this.nativeError = nativeError;
    }
    var createElementID = function() {
        var _count = 0;
        return function createID() {
            _count += 1;
            return idPrefix$1 + "__lottie_element_" + _count;
        };
    }();
    function HSVtoRGB(h, s, v) {
        var r;
        var g;
        var b;
        var i;
        var f;
        var p;
        var q;
        var t;
        i = Math.floor(h * 6);
        f = h * 6 - i;
        p = v * (1 - s);
        q = v * (1 - f * s);
        t = v * (1 - (1 - f) * s);
        switch(i % 6){
            case 0:
                r = v;
                g = t;
                b = p;
                break;
            case 1:
                r = q;
                g = v;
                b = p;
                break;
            case 2:
                r = p;
                g = v;
                b = t;
                break;
            case 3:
                r = p;
                g = q;
                b = v;
                break;
            case 4:
                r = t;
                g = p;
                b = v;
                break;
            case 5:
                r = v;
                g = p;
                b = q;
                break;
            default:
                break;
        }
        return [
            r,
            g,
            b
        ];
    }
    function RGBtoHSV(r, g, b) {
        var max = Math.max(r, g, b);
        var min = Math.min(r, g, b);
        var d = max - min;
        var h;
        var s = max === 0 ? 0 : d / max;
        var v = max / 255;
        switch(max){
            case min:
                h = 0;
                break;
            case r:
                h = g - b + d * (g < b ? 6 : 0);
                h /= 6 * d;
                break;
            case g:
                h = b - r + d * 2;
                h /= 6 * d;
                break;
            case b:
                h = r - g + d * 4;
                h /= 6 * d;
                break;
            default:
                break;
        }
        return [
            h,
            s,
            v
        ];
    }
    function addSaturationToRGB(color, offset) {
        var hsv = RGBtoHSV(color[0] * 255, color[1] * 255, color[2] * 255);
        hsv[1] += offset;
        if (hsv[1] > 1) hsv[1] = 1;
        else if (hsv[1] <= 0) hsv[1] = 0;
        return HSVtoRGB(hsv[0], hsv[1], hsv[2]);
    }
    function addBrightnessToRGB(color, offset) {
        var hsv = RGBtoHSV(color[0] * 255, color[1] * 255, color[2] * 255);
        hsv[2] += offset;
        if (hsv[2] > 1) hsv[2] = 1;
        else if (hsv[2] < 0) hsv[2] = 0;
        return HSVtoRGB(hsv[0], hsv[1], hsv[2]);
    }
    function addHueToRGB(color, offset) {
        var hsv = RGBtoHSV(color[0] * 255, color[1] * 255, color[2] * 255);
        hsv[0] += offset / 360;
        if (hsv[0] > 1) hsv[0] -= 1;
        else if (hsv[0] < 0) hsv[0] += 1;
        return HSVtoRGB(hsv[0], hsv[1], hsv[2]);
    }
    var rgbToHex = function() {
        var colorMap = [];
        var i;
        var hex;
        for(i = 0; i < 256; i += 1){
            hex = i.toString(16);
            colorMap[i] = hex.length === 1 ? "0" + hex : hex;
        }
        return function(r, g, b) {
            if (r < 0) r = 0;
            if (g < 0) g = 0;
            if (b < 0) b = 0;
            return "#" + colorMap[r] + colorMap[g] + colorMap[b];
        };
    }();
    var setSubframeEnabled = function setSubframeEnabled(flag) {
        subframeEnabled = !!flag;
    };
    var getSubframeEnabled = function getSubframeEnabled() {
        return subframeEnabled;
    };
    var setExpressionsPlugin = function setExpressionsPlugin(value) {
        expressionsPlugin = value;
    };
    var getExpressionsPlugin = function getExpressionsPlugin() {
        return expressionsPlugin;
    };
    var setExpressionInterfaces = function setExpressionInterfaces(value) {
        expressionsInterfaces = value;
    };
    var getExpressionInterfaces = function getExpressionInterfaces() {
        return expressionsInterfaces;
    };
    var setDefaultCurveSegments = function setDefaultCurveSegments(value) {
        defaultCurveSegments = value;
    };
    var getDefaultCurveSegments = function getDefaultCurveSegments() {
        return defaultCurveSegments;
    };
    var setIdPrefix = function setIdPrefix(value) {
        idPrefix$1 = value;
    };
    var getIdPrefix = function getIdPrefix() {
        return idPrefix$1;
    };
    function createNS(type) {
        // return {appendChild:function(){},setAttribute:function(){},style:{}}
        return document.createElementNS(svgNS, type);
    }
    function _typeof$5(obj) {
        "@babel/helpers - typeof";
        if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") _typeof$5 = function _typeof(obj) {
            return typeof obj;
        };
        else _typeof$5 = function _typeof(obj) {
            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
        return _typeof$5(obj);
    }
    var dataManager = function() {
        var _counterId = 1;
        var processes = [];
        var workerFn;
        var workerInstance;
        var workerProxy = {
            onmessage: function onmessage() {},
            postMessage: function postMessage(path) {
                workerFn({
                    data: path
                });
            }
        };
        var _workerSelf = {
            postMessage: function postMessage(data) {
                workerProxy.onmessage({
                    data: data
                });
            }
        };
        function createWorker(fn) {
            if (window.Worker && window.Blob && getWebWorker()) {
                var blob = new Blob([
                    "var _workerSelf = self; self.onmessage = ",
                    fn.toString()
                ], {
                    type: "text/javascript"
                }); // var blob = new Blob(['self.onmessage = ', fn.toString()], { type: 'text/javascript' });
                var url = URL.createObjectURL(blob);
                return new Worker(url);
            }
            workerFn = fn;
            return workerProxy;
        }
        function setupWorker() {
            if (!workerInstance) {
                workerInstance = createWorker(function workerStart(e) {
                    function dataFunctionManager() {
                        function completeLayers(layers, comps) {
                            var layerData;
                            var i;
                            var len = layers.length;
                            var j;
                            var jLen;
                            var k;
                            var kLen;
                            for(i = 0; i < len; i += 1){
                                layerData = layers[i];
                                if ("ks" in layerData && !layerData.completed) {
                                    layerData.completed = true;
                                    if (layerData.hasMask) {
                                        var maskProps = layerData.masksProperties;
                                        jLen = maskProps.length;
                                        for(j = 0; j < jLen; j += 1)if (maskProps[j].pt.k.i) convertPathsToAbsoluteValues(maskProps[j].pt.k);
                                        else {
                                            kLen = maskProps[j].pt.k.length;
                                            for(k = 0; k < kLen; k += 1){
                                                if (maskProps[j].pt.k[k].s) convertPathsToAbsoluteValues(maskProps[j].pt.k[k].s[0]);
                                                if (maskProps[j].pt.k[k].e) convertPathsToAbsoluteValues(maskProps[j].pt.k[k].e[0]);
                                            }
                                        }
                                    }
                                    if (layerData.ty === 0) {
                                        layerData.layers = findCompLayers(layerData.refId, comps);
                                        completeLayers(layerData.layers, comps);
                                    } else if (layerData.ty === 4) completeShapes(layerData.shapes);
                                    else if (layerData.ty === 5) completeText(layerData);
                                }
                            }
                        }
                        function completeChars(chars, assets) {
                            if (chars) {
                                var i = 0;
                                var len = chars.length;
                                for(i = 0; i < len; i += 1)if (chars[i].t === 1) {
                                    // var compData = findComp(chars[i].data.refId, assets);
                                    chars[i].data.layers = findCompLayers(chars[i].data.refId, assets); // chars[i].data.ip = 0;
                                    // chars[i].data.op = 99999;
                                    // chars[i].data.st = 0;
                                    // chars[i].data.sr = 1;
                                    // chars[i].w = compData.w;
                                    // chars[i].data.ks = {
                                    //   a: { k: [0, 0, 0], a: 0 },
                                    //   p: { k: [0, -compData.h, 0], a: 0 },
                                    //   r: { k: 0, a: 0 },
                                    //   s: { k: [100, 100], a: 0 },
                                    //   o: { k: 100, a: 0 },
                                    // };
                                    completeLayers(chars[i].data.layers, assets);
                                }
                            }
                        }
                        function findComp(id, comps) {
                            var i = 0;
                            var len = comps.length;
                            while(i < len){
                                if (comps[i].id === id) return comps[i];
                                i += 1;
                            }
                            return null;
                        }
                        function findCompLayers(id, comps) {
                            var comp = findComp(id, comps);
                            if (comp) {
                                if (!comp.layers.__used) {
                                    comp.layers.__used = true;
                                    return comp.layers;
                                }
                                return JSON.parse(JSON.stringify(comp.layers));
                            }
                            return null;
                        }
                        function completeShapes(arr) {
                            var i;
                            var len = arr.length;
                            var j;
                            var jLen;
                            for(i = len - 1; i >= 0; i -= 1){
                                if (arr[i].ty === "sh") {
                                    if (arr[i].ks.k.i) convertPathsToAbsoluteValues(arr[i].ks.k);
                                    else {
                                        jLen = arr[i].ks.k.length;
                                        for(j = 0; j < jLen; j += 1){
                                            if (arr[i].ks.k[j].s) convertPathsToAbsoluteValues(arr[i].ks.k[j].s[0]);
                                            if (arr[i].ks.k[j].e) convertPathsToAbsoluteValues(arr[i].ks.k[j].e[0]);
                                        }
                                    }
                                } else if (arr[i].ty === "gr") completeShapes(arr[i].it);
                            }
                        }
                        function convertPathsToAbsoluteValues(path) {
                            var i;
                            var len = path.i.length;
                            for(i = 0; i < len; i += 1){
                                path.i[i][0] += path.v[i][0];
                                path.i[i][1] += path.v[i][1];
                                path.o[i][0] += path.v[i][0];
                                path.o[i][1] += path.v[i][1];
                            }
                        }
                        function checkVersion(minimum, animVersionString) {
                            var animVersion = animVersionString ? animVersionString.split(".") : [
                                100,
                                100,
                                100
                            ];
                            if (minimum[0] > animVersion[0]) return true;
                            if (animVersion[0] > minimum[0]) return false;
                            if (minimum[1] > animVersion[1]) return true;
                            if (animVersion[1] > minimum[1]) return false;
                            if (minimum[2] > animVersion[2]) return true;
                            if (animVersion[2] > minimum[2]) return false;
                            return null;
                        }
                        var checkText = function() {
                            var minimumVersion = [
                                4,
                                4,
                                14
                            ];
                            function updateTextLayer(textLayer) {
                                var documentData = textLayer.t.d;
                                textLayer.t.d = {
                                    k: [
                                        {
                                            s: documentData,
                                            t: 0
                                        }
                                    ]
                                };
                            }
                            function iterateLayers(layers) {
                                var i;
                                var len = layers.length;
                                for(i = 0; i < len; i += 1)if (layers[i].ty === 5) updateTextLayer(layers[i]);
                            }
                            return function(animationData) {
                                if (checkVersion(minimumVersion, animationData.v)) {
                                    iterateLayers(animationData.layers);
                                    if (animationData.assets) {
                                        var i;
                                        var len = animationData.assets.length;
                                        for(i = 0; i < len; i += 1)if (animationData.assets[i].layers) iterateLayers(animationData.assets[i].layers);
                                    }
                                }
                            };
                        }();
                        var checkChars = function() {
                            var minimumVersion = [
                                4,
                                7,
                                99
                            ];
                            return function(animationData) {
                                if (animationData.chars && !checkVersion(minimumVersion, animationData.v)) {
                                    var i;
                                    var len = animationData.chars.length;
                                    for(i = 0; i < len; i += 1){
                                        var charData = animationData.chars[i];
                                        if (charData.data && charData.data.shapes) {
                                            completeShapes(charData.data.shapes);
                                            charData.data.ip = 0;
                                            charData.data.op = 99999;
                                            charData.data.st = 0;
                                            charData.data.sr = 1;
                                            charData.data.ks = {
                                                p: {
                                                    k: [
                                                        0,
                                                        0
                                                    ],
                                                    a: 0
                                                },
                                                s: {
                                                    k: [
                                                        100,
                                                        100
                                                    ],
                                                    a: 0
                                                },
                                                a: {
                                                    k: [
                                                        0,
                                                        0
                                                    ],
                                                    a: 0
                                                },
                                                r: {
                                                    k: 0,
                                                    a: 0
                                                },
                                                o: {
                                                    k: 100,
                                                    a: 0
                                                }
                                            };
                                            if (!animationData.chars[i].t) {
                                                charData.data.shapes.push({
                                                    ty: "no"
                                                });
                                                charData.data.shapes[0].it.push({
                                                    p: {
                                                        k: [
                                                            0,
                                                            0
                                                        ],
                                                        a: 0
                                                    },
                                                    s: {
                                                        k: [
                                                            100,
                                                            100
                                                        ],
                                                        a: 0
                                                    },
                                                    a: {
                                                        k: [
                                                            0,
                                                            0
                                                        ],
                                                        a: 0
                                                    },
                                                    r: {
                                                        k: 0,
                                                        a: 0
                                                    },
                                                    o: {
                                                        k: 100,
                                                        a: 0
                                                    },
                                                    sk: {
                                                        k: 0,
                                                        a: 0
                                                    },
                                                    sa: {
                                                        k: 0,
                                                        a: 0
                                                    },
                                                    ty: "tr"
                                                });
                                            }
                                        }
                                    }
                                }
                            };
                        }();
                        var checkPathProperties = function() {
                            var minimumVersion = [
                                5,
                                7,
                                15
                            ];
                            function updateTextLayer(textLayer) {
                                var pathData = textLayer.t.p;
                                if (typeof pathData.a === "number") pathData.a = {
                                    a: 0,
                                    k: pathData.a
                                };
                                if (typeof pathData.p === "number") pathData.p = {
                                    a: 0,
                                    k: pathData.p
                                };
                                if (typeof pathData.r === "number") pathData.r = {
                                    a: 0,
                                    k: pathData.r
                                };
                            }
                            function iterateLayers(layers) {
                                var i;
                                var len = layers.length;
                                for(i = 0; i < len; i += 1)if (layers[i].ty === 5) updateTextLayer(layers[i]);
                            }
                            return function(animationData) {
                                if (checkVersion(minimumVersion, animationData.v)) {
                                    iterateLayers(animationData.layers);
                                    if (animationData.assets) {
                                        var i;
                                        var len = animationData.assets.length;
                                        for(i = 0; i < len; i += 1)if (animationData.assets[i].layers) iterateLayers(animationData.assets[i].layers);
                                    }
                                }
                            };
                        }();
                        var checkColors = function() {
                            var minimumVersion = [
                                4,
                                1,
                                9
                            ];
                            function iterateShapes(shapes) {
                                var i;
                                var len = shapes.length;
                                var j;
                                var jLen;
                                for(i = 0; i < len; i += 1){
                                    if (shapes[i].ty === "gr") iterateShapes(shapes[i].it);
                                    else if (shapes[i].ty === "fl" || shapes[i].ty === "st") {
                                        if (shapes[i].c.k && shapes[i].c.k[0].i) {
                                            jLen = shapes[i].c.k.length;
                                            for(j = 0; j < jLen; j += 1){
                                                if (shapes[i].c.k[j].s) {
                                                    shapes[i].c.k[j].s[0] /= 255;
                                                    shapes[i].c.k[j].s[1] /= 255;
                                                    shapes[i].c.k[j].s[2] /= 255;
                                                    shapes[i].c.k[j].s[3] /= 255;
                                                }
                                                if (shapes[i].c.k[j].e) {
                                                    shapes[i].c.k[j].e[0] /= 255;
                                                    shapes[i].c.k[j].e[1] /= 255;
                                                    shapes[i].c.k[j].e[2] /= 255;
                                                    shapes[i].c.k[j].e[3] /= 255;
                                                }
                                            }
                                        } else {
                                            shapes[i].c.k[0] /= 255;
                                            shapes[i].c.k[1] /= 255;
                                            shapes[i].c.k[2] /= 255;
                                            shapes[i].c.k[3] /= 255;
                                        }
                                    }
                                }
                            }
                            function iterateLayers(layers) {
                                var i;
                                var len = layers.length;
                                for(i = 0; i < len; i += 1)if (layers[i].ty === 4) iterateShapes(layers[i].shapes);
                            }
                            return function(animationData) {
                                if (checkVersion(minimumVersion, animationData.v)) {
                                    iterateLayers(animationData.layers);
                                    if (animationData.assets) {
                                        var i;
                                        var len = animationData.assets.length;
                                        for(i = 0; i < len; i += 1)if (animationData.assets[i].layers) iterateLayers(animationData.assets[i].layers);
                                    }
                                }
                            };
                        }();
                        var checkShapes = function() {
                            var minimumVersion = [
                                4,
                                4,
                                18
                            ];
                            function completeClosingShapes(arr) {
                                var i;
                                var len = arr.length;
                                var j;
                                var jLen;
                                for(i = len - 1; i >= 0; i -= 1){
                                    if (arr[i].ty === "sh") {
                                        if (arr[i].ks.k.i) arr[i].ks.k.c = arr[i].closed;
                                        else {
                                            jLen = arr[i].ks.k.length;
                                            for(j = 0; j < jLen; j += 1){
                                                if (arr[i].ks.k[j].s) arr[i].ks.k[j].s[0].c = arr[i].closed;
                                                if (arr[i].ks.k[j].e) arr[i].ks.k[j].e[0].c = arr[i].closed;
                                            }
                                        }
                                    } else if (arr[i].ty === "gr") completeClosingShapes(arr[i].it);
                                }
                            }
                            function iterateLayers(layers) {
                                var layerData;
                                var i;
                                var len = layers.length;
                                var j;
                                var jLen;
                                var k;
                                var kLen;
                                for(i = 0; i < len; i += 1){
                                    layerData = layers[i];
                                    if (layerData.hasMask) {
                                        var maskProps = layerData.masksProperties;
                                        jLen = maskProps.length;
                                        for(j = 0; j < jLen; j += 1)if (maskProps[j].pt.k.i) maskProps[j].pt.k.c = maskProps[j].cl;
                                        else {
                                            kLen = maskProps[j].pt.k.length;
                                            for(k = 0; k < kLen; k += 1){
                                                if (maskProps[j].pt.k[k].s) maskProps[j].pt.k[k].s[0].c = maskProps[j].cl;
                                                if (maskProps[j].pt.k[k].e) maskProps[j].pt.k[k].e[0].c = maskProps[j].cl;
                                            }
                                        }
                                    }
                                    if (layerData.ty === 4) completeClosingShapes(layerData.shapes);
                                }
                            }
                            return function(animationData) {
                                if (checkVersion(minimumVersion, animationData.v)) {
                                    iterateLayers(animationData.layers);
                                    if (animationData.assets) {
                                        var i;
                                        var len = animationData.assets.length;
                                        for(i = 0; i < len; i += 1)if (animationData.assets[i].layers) iterateLayers(animationData.assets[i].layers);
                                    }
                                }
                            };
                        }();
                        function completeData(animationData) {
                            if (animationData.__complete) return;
                            checkColors(animationData);
                            checkText(animationData);
                            checkChars(animationData);
                            checkPathProperties(animationData);
                            checkShapes(animationData);
                            completeLayers(animationData.layers, animationData.assets);
                            completeChars(animationData.chars, animationData.assets);
                            animationData.__complete = true;
                        }
                        function completeText(data) {
                            data.t.a.length === 0 && data.t.p;
                        }
                        var moduleOb = {};
                        moduleOb.completeData = completeData;
                        moduleOb.checkColors = checkColors;
                        moduleOb.checkChars = checkChars;
                        moduleOb.checkPathProperties = checkPathProperties;
                        moduleOb.checkShapes = checkShapes;
                        moduleOb.completeLayers = completeLayers;
                        return moduleOb;
                    }
                    if (!_workerSelf.dataManager) _workerSelf.dataManager = dataFunctionManager();
                    if (!_workerSelf.assetLoader) _workerSelf.assetLoader = function() {
                        function formatResponse(xhr) {
                            // using typeof doubles the time of execution of this method,
                            // so if available, it's better to use the header to validate the type
                            var contentTypeHeader = xhr.getResponseHeader("content-type");
                            if (contentTypeHeader && xhr.responseType === "json" && contentTypeHeader.indexOf("json") !== -1) return xhr.response;
                            if (xhr.response && _typeof$5(xhr.response) === "object") return xhr.response;
                            if (xhr.response && typeof xhr.response === "string") return JSON.parse(xhr.response);
                            if (xhr.responseText) return JSON.parse(xhr.responseText);
                            return null;
                        }
                        function loadAsset(path, fullPath, callback, errorCallback) {
                            var response;
                            var xhr = new XMLHttpRequest(); // set responseType after calling open or IE will break.
                            try {
                                // This crashes on Android WebView prior to KitKat
                                xhr.responseType = "json";
                            } catch (err) {} // eslint-disable-line no-empty
                            xhr.onreadystatechange = function() {
                                if (xhr.readyState === 4) {
                                    if (xhr.status === 200) {
                                        response = formatResponse(xhr);
                                        callback(response);
                                    } else try {
                                        response = formatResponse(xhr);
                                        callback(response);
                                    } catch (err) {
                                        if (errorCallback) errorCallback(err);
                                    }
                                }
                            };
                            try {
                                // Hack to workaround banner validation
                                xhr.open([
                                    "G",
                                    "E",
                                    "T"
                                ].join(""), path, true);
                            } catch (error) {
                                // Hack to workaround banner validation
                                xhr.open([
                                    "G",
                                    "E",
                                    "T"
                                ].join(""), fullPath + "/" + path, true);
                            }
                            xhr.send();
                        }
                        return {
                            load: loadAsset
                        };
                    }();
                    if (e.data.type === "loadAnimation") _workerSelf.assetLoader.load(e.data.path, e.data.fullPath, function(data) {
                        _workerSelf.dataManager.completeData(data);
                        _workerSelf.postMessage({
                            id: e.data.id,
                            payload: data,
                            status: "success"
                        });
                    }, function() {
                        _workerSelf.postMessage({
                            id: e.data.id,
                            status: "error"
                        });
                    });
                    else if (e.data.type === "complete") {
                        var animation = e.data.animation;
                        _workerSelf.dataManager.completeData(animation);
                        _workerSelf.postMessage({
                            id: e.data.id,
                            payload: animation,
                            status: "success"
                        });
                    } else if (e.data.type === "loadData") _workerSelf.assetLoader.load(e.data.path, e.data.fullPath, function(data) {
                        _workerSelf.postMessage({
                            id: e.data.id,
                            payload: data,
                            status: "success"
                        });
                    }, function() {
                        _workerSelf.postMessage({
                            id: e.data.id,
                            status: "error"
                        });
                    });
                });
                workerInstance.onmessage = function(event) {
                    var data = event.data;
                    var id = data.id;
                    var process = processes[id];
                    processes[id] = null;
                    if (data.status === "success") process.onComplete(data.payload);
                    else if (process.onError) process.onError();
                };
            }
        }
        function createProcess(onComplete, onError) {
            _counterId += 1;
            var id = "processId_" + _counterId;
            processes[id] = {
                onComplete: onComplete,
                onError: onError
            };
            return id;
        }
        function loadAnimation(path, onComplete, onError) {
            setupWorker();
            var processId = createProcess(onComplete, onError);
            workerInstance.postMessage({
                type: "loadAnimation",
                path: path,
                fullPath: window.location.origin + window.location.pathname,
                id: processId
            });
        }
        function loadData(path, onComplete, onError) {
            setupWorker();
            var processId = createProcess(onComplete, onError);
            workerInstance.postMessage({
                type: "loadData",
                path: path,
                fullPath: window.location.origin + window.location.pathname,
                id: processId
            });
        }
        function completeAnimation(anim, onComplete, onError) {
            setupWorker();
            var processId = createProcess(onComplete, onError);
            workerInstance.postMessage({
                type: "complete",
                animation: anim,
                id: processId
            });
        }
        return {
            loadAnimation: loadAnimation,
            loadData: loadData,
            completeAnimation: completeAnimation
        };
    }();
    var ImagePreloader = function() {
        var proxyImage = function() {
            var canvas = createTag("canvas");
            canvas.width = 1;
            canvas.height = 1;
            var ctx = canvas.getContext("2d");
            ctx.fillStyle = "rgba(0,0,0,0)";
            ctx.fillRect(0, 0, 1, 1);
            return canvas;
        }();
        function imageLoaded() {
            this.loadedAssets += 1;
            if (this.loadedAssets === this.totalImages && this.loadedFootagesCount === this.totalFootages) {
                if (this.imagesLoadedCb) this.imagesLoadedCb(null);
            }
        }
        function footageLoaded() {
            this.loadedFootagesCount += 1;
            if (this.loadedAssets === this.totalImages && this.loadedFootagesCount === this.totalFootages) {
                if (this.imagesLoadedCb) this.imagesLoadedCb(null);
            }
        }
        function getAssetsPath(assetData, assetsPath, originalPath) {
            var path = "";
            if (assetData.e) path = assetData.p;
            else if (assetsPath) {
                var imagePath = assetData.p;
                if (imagePath.indexOf("images/") !== -1) imagePath = imagePath.split("/")[1];
                path = assetsPath + imagePath;
            } else {
                path = originalPath;
                path += assetData.u ? assetData.u : "";
                path += assetData.p;
            }
            return path;
        }
        function testImageLoaded(img) {
            var _count = 0;
            var intervalId = setInterval((function() {
                var box = img.getBBox();
                if (box.width || _count > 500) {
                    this._imageLoaded();
                    clearInterval(intervalId);
                }
                _count += 1;
            }).bind(this), 50);
        }
        function createImageData(assetData) {
            var path = getAssetsPath(assetData, this.assetsPath, this.path);
            var img = createNS("image");
            if (isSafari) this.testImageLoaded(img);
            else img.addEventListener("load", this._imageLoaded, false);
            img.addEventListener("error", (function() {
                ob.img = proxyImage;
                this._imageLoaded();
            }).bind(this), false);
            img.setAttributeNS("http://www.w3.org/1999/xlink", "href", path);
            if (this._elementHelper.append) this._elementHelper.append(img);
            else this._elementHelper.appendChild(img);
            var ob = {
                img: img,
                assetData: assetData
            };
            return ob;
        }
        function createImgData(assetData) {
            var path = getAssetsPath(assetData, this.assetsPath, this.path);
            var img = createTag("img");
            img.crossOrigin = "anonymous";
            img.addEventListener("load", this._imageLoaded, false);
            img.addEventListener("error", (function() {
                ob.img = proxyImage;
                this._imageLoaded();
            }).bind(this), false);
            img.src = path;
            var ob = {
                img: img,
                assetData: assetData
            };
            return ob;
        }
        function createFootageData(data) {
            var ob = {
                assetData: data
            };
            var path = getAssetsPath(data, this.assetsPath, this.path);
            dataManager.loadData(path, (function(footageData) {
                ob.img = footageData;
                this._footageLoaded();
            }).bind(this), (function() {
                ob.img = {};
                this._footageLoaded();
            }).bind(this));
            return ob;
        }
        function loadAssets(assets, cb) {
            this.imagesLoadedCb = cb;
            var i;
            var len = assets.length;
            for(i = 0; i < len; i += 1)if (!assets[i].layers) {
                if (!assets[i].t || assets[i].t === "seq") {
                    this.totalImages += 1;
                    this.images.push(this._createImageData(assets[i]));
                } else if (assets[i].t === 3) {
                    this.totalFootages += 1;
                    this.images.push(this.createFootageData(assets[i]));
                }
            }
        }
        function setPath(path) {
            this.path = path || "";
        }
        function setAssetsPath(path) {
            this.assetsPath = path || "";
        }
        function getAsset(assetData) {
            var i = 0;
            var len = this.images.length;
            while(i < len){
                if (this.images[i].assetData === assetData) return this.images[i].img;
                i += 1;
            }
            return null;
        }
        function destroy() {
            this.imagesLoadedCb = null;
            this.images.length = 0;
        }
        function loadedImages() {
            return this.totalImages === this.loadedAssets;
        }
        function loadedFootages() {
            return this.totalFootages === this.loadedFootagesCount;
        }
        function setCacheType(type, elementHelper) {
            if (type === "svg") {
                this._elementHelper = elementHelper;
                this._createImageData = this.createImageData.bind(this);
            } else this._createImageData = this.createImgData.bind(this);
        }
        function ImagePreloaderFactory() {
            this._imageLoaded = imageLoaded.bind(this);
            this._footageLoaded = footageLoaded.bind(this);
            this.testImageLoaded = testImageLoaded.bind(this);
            this.createFootageData = createFootageData.bind(this);
            this.assetsPath = "";
            this.path = "";
            this.totalImages = 0;
            this.totalFootages = 0;
            this.loadedAssets = 0;
            this.loadedFootagesCount = 0;
            this.imagesLoadedCb = null;
            this.images = [];
        }
        ImagePreloaderFactory.prototype = {
            loadAssets: loadAssets,
            setAssetsPath: setAssetsPath,
            setPath: setPath,
            loadedImages: loadedImages,
            loadedFootages: loadedFootages,
            destroy: destroy,
            getAsset: getAsset,
            createImgData: createImgData,
            createImageData: createImageData,
            imageLoaded: imageLoaded,
            footageLoaded: footageLoaded,
            setCacheType: setCacheType
        };
        return ImagePreloaderFactory;
    }();
    function BaseEvent() {}
    BaseEvent.prototype = {
        triggerEvent: function triggerEvent(eventName, args) {
            if (this._cbs[eventName]) {
                var callbacks = this._cbs[eventName];
                for(var i = 0; i < callbacks.length; i += 1)callbacks[i](args);
            }
        },
        addEventListener: function addEventListener(eventName, callback) {
            if (!this._cbs[eventName]) this._cbs[eventName] = [];
            this._cbs[eventName].push(callback);
            return (function() {
                this.removeEventListener(eventName, callback);
            }).bind(this);
        },
        removeEventListener: function removeEventListener(eventName, callback) {
            if (!callback) this._cbs[eventName] = null;
            else if (this._cbs[eventName]) {
                var i = 0;
                var len = this._cbs[eventName].length;
                while(i < len){
                    if (this._cbs[eventName][i] === callback) {
                        this._cbs[eventName].splice(i, 1);
                        i -= 1;
                        len -= 1;
                    }
                    i += 1;
                }
                if (!this._cbs[eventName].length) this._cbs[eventName] = null;
            }
        }
    };
    var markerParser = function() {
        function parsePayloadLines(payload) {
            var lines = payload.split("\r\n");
            var keys = {};
            var line;
            var keysCount = 0;
            for(var i = 0; i < lines.length; i += 1){
                line = lines[i].split(":");
                if (line.length === 2) {
                    keys[line[0]] = line[1].trim();
                    keysCount += 1;
                }
            }
            if (keysCount === 0) throw new Error();
            return keys;
        }
        return function(_markers) {
            var markers = [];
            for(var i = 0; i < _markers.length; i += 1){
                var _marker = _markers[i];
                var markerData = {
                    time: _marker.tm,
                    duration: _marker.dr
                };
                try {
                    markerData.payload = JSON.parse(_markers[i].cm);
                } catch (_) {
                    try {
                        markerData.payload = parsePayloadLines(_markers[i].cm);
                    } catch (__) {
                        markerData.payload = {
                            name: _markers[i].cm
                        };
                    }
                }
                markers.push(markerData);
            }
            return markers;
        };
    }();
    var ProjectInterface = function() {
        function registerComposition(comp) {
            this.compositions.push(comp);
        }
        return function() {
            function _thisProjectFunction(name) {
                var i = 0;
                var len = this.compositions.length;
                while(i < len){
                    if (this.compositions[i].data && this.compositions[i].data.nm === name) {
                        if (this.compositions[i].prepareFrame && this.compositions[i].data.xt) this.compositions[i].prepareFrame(this.currentFrame);
                        return this.compositions[i].compInterface;
                    }
                    i += 1;
                }
                return null;
            }
            _thisProjectFunction.compositions = [];
            _thisProjectFunction.currentFrame = 0;
            _thisProjectFunction.registerComposition = registerComposition;
            return _thisProjectFunction;
        };
    }();
    var renderers = {};
    var registerRenderer = function registerRenderer(key, value) {
        renderers[key] = value;
    };
    function getRenderer(key) {
        return renderers[key];
    }
    function _typeof$4(obj) {
        "@babel/helpers - typeof";
        if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") _typeof$4 = function _typeof(obj) {
            return typeof obj;
        };
        else _typeof$4 = function _typeof(obj) {
            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
        return _typeof$4(obj);
    }
    var AnimationItem = function AnimationItem() {
        this._cbs = [];
        this.name = "";
        this.path = "";
        this.isLoaded = false;
        this.currentFrame = 0;
        this.currentRawFrame = 0;
        this.firstFrame = 0;
        this.totalFrames = 0;
        this.frameRate = 0;
        this.frameMult = 0;
        this.playSpeed = 1;
        this.playDirection = 1;
        this.playCount = 0;
        this.animationData = {};
        this.assets = [];
        this.isPaused = true;
        this.autoplay = false;
        this.loop = true;
        this.renderer = null;
        this.animationID = createElementID();
        this.assetsPath = "";
        this.timeCompleted = 0;
        this.segmentPos = 0;
        this.isSubframeEnabled = getSubframeEnabled();
        this.segments = [];
        this._idle = true;
        this._completedLoop = false;
        this.projectInterface = ProjectInterface();
        this.imagePreloader = new ImagePreloader();
        this.audioController = audioControllerFactory();
        this.markers = [];
        this.configAnimation = this.configAnimation.bind(this);
        this.onSetupError = this.onSetupError.bind(this);
        this.onSegmentComplete = this.onSegmentComplete.bind(this);
        this.drawnFrameEvent = new BMEnterFrameEvent("drawnFrame", 0, 0, 0);
    };
    extendPrototype([
        BaseEvent
    ], AnimationItem);
    AnimationItem.prototype.setParams = function(params) {
        if (params.wrapper || params.container) this.wrapper = params.wrapper || params.container;
        var animType = "svg";
        if (params.animType) animType = params.animType;
        else if (params.renderer) animType = params.renderer;
        var RendererClass = getRenderer(animType);
        this.renderer = new RendererClass(this, params.rendererSettings);
        this.imagePreloader.setCacheType(animType, this.renderer.globalData.defs);
        this.renderer.setProjectInterface(this.projectInterface);
        this.animType = animType;
        if (params.loop === "" || params.loop === null || params.loop === undefined || params.loop === true) this.loop = true;
        else if (params.loop === false) this.loop = false;
        else this.loop = parseInt(params.loop, 10);
        this.autoplay = "autoplay" in params ? params.autoplay : true;
        this.name = params.name ? params.name : "";
        this.autoloadSegments = Object.prototype.hasOwnProperty.call(params, "autoloadSegments") ? params.autoloadSegments : true;
        this.assetsPath = params.assetsPath;
        this.initialSegment = params.initialSegment;
        if (params.audioFactory) this.audioController.setAudioFactory(params.audioFactory);
        if (params.animationData) this.setupAnimation(params.animationData);
        else if (params.path) {
            if (params.path.lastIndexOf("\\") !== -1) this.path = params.path.substr(0, params.path.lastIndexOf("\\") + 1);
            else this.path = params.path.substr(0, params.path.lastIndexOf("/") + 1);
            this.fileName = params.path.substr(params.path.lastIndexOf("/") + 1);
            this.fileName = this.fileName.substr(0, this.fileName.lastIndexOf(".json"));
            dataManager.loadAnimation(params.path, this.configAnimation, this.onSetupError);
        }
    };
    AnimationItem.prototype.onSetupError = function() {
        this.trigger("data_failed");
    };
    AnimationItem.prototype.setupAnimation = function(data) {
        dataManager.completeAnimation(data, this.configAnimation);
    };
    AnimationItem.prototype.setData = function(wrapper, animationData) {
        if (animationData) {
            if (_typeof$4(animationData) !== "object") animationData = JSON.parse(animationData);
        }
        var params = {
            wrapper: wrapper,
            animationData: animationData
        };
        var wrapperAttributes = wrapper.attributes;
        params.path = wrapperAttributes.getNamedItem("data-animation-path") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-animation-path").value : wrapperAttributes.getNamedItem("data-bm-path") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-path").value : wrapperAttributes.getNamedItem("bm-path") ? wrapperAttributes.getNamedItem("bm-path").value : "";
        params.animType = wrapperAttributes.getNamedItem("data-anim-type") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-anim-type").value : wrapperAttributes.getNamedItem("data-bm-type") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-type").value : wrapperAttributes.getNamedItem("bm-type") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("bm-type").value : wrapperAttributes.getNamedItem("data-bm-renderer") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-renderer").value : wrapperAttributes.getNamedItem("bm-renderer") ? wrapperAttributes.getNamedItem("bm-renderer").value : "canvas";
        var loop = wrapperAttributes.getNamedItem("data-anim-loop") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-anim-loop").value : wrapperAttributes.getNamedItem("data-bm-loop") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-loop").value : wrapperAttributes.getNamedItem("bm-loop") ? wrapperAttributes.getNamedItem("bm-loop").value : "";
        if (loop === "false") params.loop = false;
        else if (loop === "true") params.loop = true;
        else if (loop !== "") params.loop = parseInt(loop, 10);
        var autoplay = wrapperAttributes.getNamedItem("data-anim-autoplay") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-anim-autoplay").value : wrapperAttributes.getNamedItem("data-bm-autoplay") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-autoplay").value : wrapperAttributes.getNamedItem("bm-autoplay") ? wrapperAttributes.getNamedItem("bm-autoplay").value : true;
        params.autoplay = autoplay !== "false";
        params.name = wrapperAttributes.getNamedItem("data-name") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-name").value : wrapperAttributes.getNamedItem("data-bm-name") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-name").value : wrapperAttributes.getNamedItem("bm-name") ? wrapperAttributes.getNamedItem("bm-name").value : "";
        var prerender = wrapperAttributes.getNamedItem("data-anim-prerender") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-anim-prerender").value : wrapperAttributes.getNamedItem("data-bm-prerender") // eslint-disable-line no-nested-ternary
         ? wrapperAttributes.getNamedItem("data-bm-prerender").value : wrapperAttributes.getNamedItem("bm-prerender") ? wrapperAttributes.getNamedItem("bm-prerender").value : "";
        if (prerender === "false") params.prerender = false;
        this.setParams(params);
    };
    AnimationItem.prototype.includeLayers = function(data) {
        if (data.op > this.animationData.op) {
            this.animationData.op = data.op;
            this.totalFrames = Math.floor(data.op - this.animationData.ip);
        }
        var layers = this.animationData.layers;
        var i;
        var len = layers.length;
        var newLayers = data.layers;
        var j;
        var jLen = newLayers.length;
        for(j = 0; j < jLen; j += 1){
            i = 0;
            while(i < len){
                if (layers[i].id === newLayers[j].id) {
                    layers[i] = newLayers[j];
                    break;
                }
                i += 1;
            }
        }
        if (data.chars || data.fonts) {
            this.renderer.globalData.fontManager.addChars(data.chars);
            this.renderer.globalData.fontManager.addFonts(data.fonts, this.renderer.globalData.defs);
        }
        if (data.assets) {
            len = data.assets.length;
            for(i = 0; i < len; i += 1)this.animationData.assets.push(data.assets[i]);
        }
        this.animationData.__complete = false;
        dataManager.completeAnimation(this.animationData, this.onSegmentComplete);
    };
    AnimationItem.prototype.onSegmentComplete = function(data) {
        this.animationData = data;
        var expressionsPlugin = getExpressionsPlugin();
        if (expressionsPlugin) expressionsPlugin.initExpressions(this);
        this.loadNextSegment();
    };
    AnimationItem.prototype.loadNextSegment = function() {
        var segments = this.animationData.segments;
        if (!segments || segments.length === 0 || !this.autoloadSegments) {
            this.trigger("data_ready");
            this.timeCompleted = this.totalFrames;
            return;
        }
        var segment = segments.shift();
        this.timeCompleted = segment.time * this.frameRate;
        var segmentPath = this.path + this.fileName + "_" + this.segmentPos + ".json";
        this.segmentPos += 1;
        dataManager.loadData(segmentPath, this.includeLayers.bind(this), (function() {
            this.trigger("data_failed");
        }).bind(this));
    };
    AnimationItem.prototype.loadSegments = function() {
        var segments = this.animationData.segments;
        if (!segments) this.timeCompleted = this.totalFrames;
        this.loadNextSegment();
    };
    AnimationItem.prototype.imagesLoaded = function() {
        this.trigger("loaded_images");
        this.checkLoaded();
    };
    AnimationItem.prototype.preloadImages = function() {
        this.imagePreloader.setAssetsPath(this.assetsPath);
        this.imagePreloader.setPath(this.path);
        this.imagePreloader.loadAssets(this.animationData.assets, this.imagesLoaded.bind(this));
    };
    AnimationItem.prototype.configAnimation = function(animData) {
        if (!this.renderer) return;
        try {
            this.animationData = animData;
            if (this.initialSegment) {
                this.totalFrames = Math.floor(this.initialSegment[1] - this.initialSegment[0]);
                this.firstFrame = Math.round(this.initialSegment[0]);
            } else {
                this.totalFrames = Math.floor(this.animationData.op - this.animationData.ip);
                this.firstFrame = Math.round(this.animationData.ip);
            }
            this.renderer.configAnimation(animData);
            if (!animData.assets) animData.assets = [];
            this.assets = this.animationData.assets;
            this.frameRate = this.animationData.fr;
            this.frameMult = this.animationData.fr / 1000;
            this.renderer.searchExtraCompositions(animData.assets);
            this.markers = markerParser(animData.markers || []);
            this.trigger("config_ready");
            this.preloadImages();
            this.loadSegments();
            this.updaFrameModifier();
            this.waitForFontsLoaded();
            if (this.isPaused) this.audioController.pause();
        } catch (error) {
            this.triggerConfigError(error);
        }
    };
    AnimationItem.prototype.waitForFontsLoaded = function() {
        if (!this.renderer) return;
        if (this.renderer.globalData.fontManager.isLoaded) this.checkLoaded();
        else setTimeout(this.waitForFontsLoaded.bind(this), 20);
    };
    AnimationItem.prototype.checkLoaded = function() {
        if (!this.isLoaded && this.renderer.globalData.fontManager.isLoaded && (this.imagePreloader.loadedImages() || this.renderer.rendererType !== "canvas") && this.imagePreloader.loadedFootages()) {
            this.isLoaded = true;
            var expressionsPlugin = getExpressionsPlugin();
            if (expressionsPlugin) expressionsPlugin.initExpressions(this);
            this.renderer.initItems();
            setTimeout((function() {
                this.trigger("DOMLoaded");
            }).bind(this), 0);
            this.gotoFrame();
            if (this.autoplay) this.play();
        }
    };
    AnimationItem.prototype.resize = function(width, height) {
        // Adding this validation for backwards compatibility in case an event object was being passed down
        var _width = typeof width === "number" ? width : undefined;
        var _height = typeof height === "number" ? height : undefined;
        this.renderer.updateContainerSize(_width, _height);
    };
    AnimationItem.prototype.setSubframe = function(flag) {
        this.isSubframeEnabled = !!flag;
    };
    AnimationItem.prototype.gotoFrame = function() {
        this.currentFrame = this.isSubframeEnabled ? this.currentRawFrame : ~~this.currentRawFrame; // eslint-disable-line no-bitwise
        if (this.timeCompleted !== this.totalFrames && this.currentFrame > this.timeCompleted) this.currentFrame = this.timeCompleted;
        this.trigger("enterFrame");
        this.renderFrame();
        this.trigger("drawnFrame");
    };
    AnimationItem.prototype.renderFrame = function() {
        if (this.isLoaded === false || !this.renderer) return;
        try {
            this.renderer.renderFrame(this.currentFrame + this.firstFrame);
        } catch (error) {
            this.triggerRenderFrameError(error);
        }
    };
    AnimationItem.prototype.play = function(name) {
        if (name && this.name !== name) return;
        if (this.isPaused === true) {
            this.isPaused = false;
            this.trigger("_pause");
            this.audioController.resume();
            if (this._idle) {
                this._idle = false;
                this.trigger("_active");
            }
        }
    };
    AnimationItem.prototype.pause = function(name) {
        if (name && this.name !== name) return;
        if (this.isPaused === false) {
            this.isPaused = true;
            this.trigger("_play");
            this._idle = true;
            this.trigger("_idle");
            this.audioController.pause();
        }
    };
    AnimationItem.prototype.togglePause = function(name) {
        if (name && this.name !== name) return;
        if (this.isPaused === true) this.play();
        else this.pause();
    };
    AnimationItem.prototype.stop = function(name) {
        if (name && this.name !== name) return;
        this.pause();
        this.playCount = 0;
        this._completedLoop = false;
        this.setCurrentRawFrameValue(0);
    };
    AnimationItem.prototype.getMarkerData = function(markerName) {
        var marker;
        for(var i = 0; i < this.markers.length; i += 1){
            marker = this.markers[i];
            if (marker.payload && marker.payload.name === markerName) return marker;
        }
        return null;
    };
    AnimationItem.prototype.goToAndStop = function(value, isFrame, name) {
        if (name && this.name !== name) return;
        var numValue = Number(value);
        if (isNaN(numValue)) {
            var marker = this.getMarkerData(value);
            if (marker) this.goToAndStop(marker.time, true);
        } else if (isFrame) this.setCurrentRawFrameValue(value);
        else this.setCurrentRawFrameValue(value * this.frameModifier);
        this.pause();
    };
    AnimationItem.prototype.goToAndPlay = function(value, isFrame, name) {
        if (name && this.name !== name) return;
        var numValue = Number(value);
        if (isNaN(numValue)) {
            var marker = this.getMarkerData(value);
            if (marker) {
                if (!marker.duration) this.goToAndStop(marker.time, true);
                else this.playSegments([
                    marker.time,
                    marker.time + marker.duration
                ], true);
            }
        } else this.goToAndStop(numValue, isFrame, name);
        this.play();
    };
    AnimationItem.prototype.advanceTime = function(value) {
        if (this.isPaused === true || this.isLoaded === false) return;
        var nextValue = this.currentRawFrame + value * this.frameModifier;
        var _isComplete = false; // Checking if nextValue > totalFrames - 1 for addressing non looping and looping animations.
        // If animation won't loop, it should stop at totalFrames - 1. If it will loop it should complete the last frame and then loop.
        if (nextValue >= this.totalFrames - 1 && this.frameModifier > 0) {
            if (!this.loop || this.playCount === this.loop) {
                if (!this.checkSegments(nextValue > this.totalFrames ? nextValue % this.totalFrames : 0)) {
                    _isComplete = true;
                    nextValue = this.totalFrames - 1;
                }
            } else if (nextValue >= this.totalFrames) {
                this.playCount += 1;
                if (!this.checkSegments(nextValue % this.totalFrames)) {
                    this.setCurrentRawFrameValue(nextValue % this.totalFrames);
                    this._completedLoop = true;
                    this.trigger("loopComplete");
                }
            } else this.setCurrentRawFrameValue(nextValue);
        } else if (nextValue < 0) {
            if (!this.checkSegments(nextValue % this.totalFrames)) {
                if (this.loop && !(this.playCount-- <= 0 && this.loop !== true)) {
                    // eslint-disable-line no-plusplus
                    this.setCurrentRawFrameValue(this.totalFrames + nextValue % this.totalFrames);
                    if (!this._completedLoop) this._completedLoop = true;
                    else this.trigger("loopComplete");
                } else {
                    _isComplete = true;
                    nextValue = 0;
                }
            }
        } else this.setCurrentRawFrameValue(nextValue);
        if (_isComplete) {
            this.setCurrentRawFrameValue(nextValue);
            this.pause();
            this.trigger("complete");
        }
    };
    AnimationItem.prototype.adjustSegment = function(arr, offset) {
        this.playCount = 0;
        if (arr[1] < arr[0]) {
            if (this.frameModifier > 0) {
                if (this.playSpeed < 0) this.setSpeed(-this.playSpeed);
                else this.setDirection(-1);
            }
            this.totalFrames = arr[0] - arr[1];
            this.timeCompleted = this.totalFrames;
            this.firstFrame = arr[1];
            this.setCurrentRawFrameValue(this.totalFrames - 0.001 - offset);
        } else if (arr[1] > arr[0]) {
            if (this.frameModifier < 0) {
                if (this.playSpeed < 0) this.setSpeed(-this.playSpeed);
                else this.setDirection(1);
            }
            this.totalFrames = arr[1] - arr[0];
            this.timeCompleted = this.totalFrames;
            this.firstFrame = arr[0];
            this.setCurrentRawFrameValue(0.001 + offset);
        }
        this.trigger("segmentStart");
    };
    AnimationItem.prototype.setSegment = function(init, end) {
        var pendingFrame = -1;
        if (this.isPaused) {
            if (this.currentRawFrame + this.firstFrame < init) pendingFrame = init;
            else if (this.currentRawFrame + this.firstFrame > end) pendingFrame = end - init;
        }
        this.firstFrame = init;
        this.totalFrames = end - init;
        this.timeCompleted = this.totalFrames;
        if (pendingFrame !== -1) this.goToAndStop(pendingFrame, true);
    };
    AnimationItem.prototype.playSegments = function(arr, forceFlag) {
        if (forceFlag) this.segments.length = 0;
        if (_typeof$4(arr[0]) === "object") {
            var i;
            var len = arr.length;
            for(i = 0; i < len; i += 1)this.segments.push(arr[i]);
        } else this.segments.push(arr);
        if (this.segments.length && forceFlag) this.adjustSegment(this.segments.shift(), 0);
        if (this.isPaused) this.play();
    };
    AnimationItem.prototype.resetSegments = function(forceFlag) {
        this.segments.length = 0;
        this.segments.push([
            this.animationData.ip,
            this.animationData.op
        ]);
        if (forceFlag) this.checkSegments(0);
    };
    AnimationItem.prototype.checkSegments = function(offset) {
        if (this.segments.length) {
            this.adjustSegment(this.segments.shift(), offset);
            return true;
        }
        return false;
    };
    AnimationItem.prototype.destroy = function(name) {
        if (name && this.name !== name || !this.renderer) return;
        this.renderer.destroy();
        this.imagePreloader.destroy();
        this.trigger("destroy");
        this._cbs = null;
        this.onEnterFrame = null;
        this.onLoopComplete = null;
        this.onComplete = null;
        this.onSegmentStart = null;
        this.onDestroy = null;
        this.renderer = null;
        this.renderer = null;
        this.imagePreloader = null;
        this.projectInterface = null;
    };
    AnimationItem.prototype.setCurrentRawFrameValue = function(value) {
        this.currentRawFrame = value;
        this.gotoFrame();
    };
    AnimationItem.prototype.setSpeed = function(val) {
        this.playSpeed = val;
        this.updaFrameModifier();
    };
    AnimationItem.prototype.setDirection = function(val) {
        this.playDirection = val < 0 ? -1 : 1;
        this.updaFrameModifier();
    };
    AnimationItem.prototype.setLoop = function(isLooping) {
        this.loop = isLooping;
    };
    AnimationItem.prototype.setVolume = function(val, name) {
        if (name && this.name !== name) return;
        this.audioController.setVolume(val);
    };
    AnimationItem.prototype.getVolume = function() {
        return this.audioController.getVolume();
    };
    AnimationItem.prototype.mute = function(name) {
        if (name && this.name !== name) return;
        this.audioController.mute();
    };
    AnimationItem.prototype.unmute = function(name) {
        if (name && this.name !== name) return;
        this.audioController.unmute();
    };
    AnimationItem.prototype.updaFrameModifier = function() {
        this.frameModifier = this.frameMult * this.playSpeed * this.playDirection;
        this.audioController.setRate(this.playSpeed * this.playDirection);
    };
    AnimationItem.prototype.getPath = function() {
        return this.path;
    };
    AnimationItem.prototype.getAssetsPath = function(assetData) {
        var path = "";
        if (assetData.e) path = assetData.p;
        else if (this.assetsPath) {
            var imagePath = assetData.p;
            if (imagePath.indexOf("images/") !== -1) imagePath = imagePath.split("/")[1];
            path = this.assetsPath + imagePath;
        } else {
            path = this.path;
            path += assetData.u ? assetData.u : "";
            path += assetData.p;
        }
        return path;
    };
    AnimationItem.prototype.getAssetData = function(id) {
        var i = 0;
        var len = this.assets.length;
        while(i < len){
            if (id === this.assets[i].id) return this.assets[i];
            i += 1;
        }
        return null;
    };
    AnimationItem.prototype.hide = function() {
        this.renderer.hide();
    };
    AnimationItem.prototype.show = function() {
        this.renderer.show();
    };
    AnimationItem.prototype.getDuration = function(isFrame) {
        return isFrame ? this.totalFrames : this.totalFrames / this.frameRate;
    };
    AnimationItem.prototype.updateDocumentData = function(path, documentData, index) {
        try {
            var element = this.renderer.getElementByPath(path);
            element.updateDocumentData(documentData, index);
        } catch (error) {}
    };
    AnimationItem.prototype.trigger = function(name) {
        if (this._cbs && this._cbs[name]) switch(name){
            case "enterFrame":
                this.triggerEvent(name, new BMEnterFrameEvent(name, this.currentFrame, this.totalFrames, this.frameModifier));
                break;
            case "drawnFrame":
                this.drawnFrameEvent.currentTime = this.currentFrame;
                this.drawnFrameEvent.totalTime = this.totalFrames;
                this.drawnFrameEvent.direction = this.frameModifier;
                this.triggerEvent(name, this.drawnFrameEvent);
                break;
            case "loopComplete":
                this.triggerEvent(name, new BMCompleteLoopEvent(name, this.loop, this.playCount, this.frameMult));
                break;
            case "complete":
                this.triggerEvent(name, new BMCompleteEvent(name, this.frameMult));
                break;
            case "segmentStart":
                this.triggerEvent(name, new BMSegmentStartEvent(name, this.firstFrame, this.totalFrames));
                break;
            case "destroy":
                this.triggerEvent(name, new BMDestroyEvent(name, this));
                break;
            default:
                this.triggerEvent(name);
        }
        if (name === "enterFrame" && this.onEnterFrame) this.onEnterFrame.call(this, new BMEnterFrameEvent(name, this.currentFrame, this.totalFrames, this.frameMult));
        if (name === "loopComplete" && this.onLoopComplete) this.onLoopComplete.call(this, new BMCompleteLoopEvent(name, this.loop, this.playCount, this.frameMult));
        if (name === "complete" && this.onComplete) this.onComplete.call(this, new BMCompleteEvent(name, this.frameMult));
        if (name === "segmentStart" && this.onSegmentStart) this.onSegmentStart.call(this, new BMSegmentStartEvent(name, this.firstFrame, this.totalFrames));
        if (name === "destroy" && this.onDestroy) this.onDestroy.call(this, new BMDestroyEvent(name, this));
    };
    AnimationItem.prototype.triggerRenderFrameError = function(nativeError) {
        var error = new BMRenderFrameErrorEvent(nativeError, this.currentFrame);
        this.triggerEvent("error", error);
        if (this.onError) this.onError.call(this, error);
    };
    AnimationItem.prototype.triggerConfigError = function(nativeError) {
        var error = new BMConfigErrorEvent(nativeError, this.currentFrame);
        this.triggerEvent("error", error);
        if (this.onError) this.onError.call(this, error);
    };
    var animationManager = function() {
        var moduleOb = {};
        var registeredAnimations = [];
        var initTime = 0;
        var len = 0;
        var playingAnimationsNum = 0;
        var _stopped = true;
        var _isFrozen = false;
        function removeElement(ev) {
            var i = 0;
            var animItem = ev.target;
            while(i < len){
                if (registeredAnimations[i].animation === animItem) {
                    registeredAnimations.splice(i, 1);
                    i -= 1;
                    len -= 1;
                    if (!animItem.isPaused) subtractPlayingCount();
                }
                i += 1;
            }
        }
        function registerAnimation(element, animationData) {
            if (!element) return null;
            var i = 0;
            while(i < len){
                if (registeredAnimations[i].elem === element && registeredAnimations[i].elem !== null) return registeredAnimations[i].animation;
                i += 1;
            }
            var animItem = new AnimationItem();
            setupAnimation(animItem, element);
            animItem.setData(element, animationData);
            return animItem;
        }
        function getRegisteredAnimations() {
            var i;
            var lenAnims = registeredAnimations.length;
            var animations = [];
            for(i = 0; i < lenAnims; i += 1)animations.push(registeredAnimations[i].animation);
            return animations;
        }
        function addPlayingCount() {
            playingAnimationsNum += 1;
            activate();
        }
        function subtractPlayingCount() {
            playingAnimationsNum -= 1;
        }
        function setupAnimation(animItem, element) {
            animItem.addEventListener("destroy", removeElement);
            animItem.addEventListener("_active", addPlayingCount);
            animItem.addEventListener("_idle", subtractPlayingCount);
            registeredAnimations.push({
                elem: element,
                animation: animItem
            });
            len += 1;
        }
        function loadAnimation(params) {
            var animItem = new AnimationItem();
            setupAnimation(animItem, null);
            animItem.setParams(params);
            return animItem;
        }
        function setSpeed(val, animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.setSpeed(val, animation);
        }
        function setDirection(val, animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.setDirection(val, animation);
        }
        function play(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.play(animation);
        }
        function resume(nowTime) {
            var elapsedTime = nowTime - initTime;
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.advanceTime(elapsedTime);
            initTime = nowTime;
            if (playingAnimationsNum && !_isFrozen) window.requestAnimationFrame(resume);
            else _stopped = true;
        }
        function first(nowTime) {
            initTime = nowTime;
            window.requestAnimationFrame(resume);
        }
        function pause(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.pause(animation);
        }
        function goToAndStop(value, isFrame, animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.goToAndStop(value, isFrame, animation);
        }
        function stop(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.stop(animation);
        }
        function togglePause(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.togglePause(animation);
        }
        function destroy(animation) {
            var i;
            for(i = len - 1; i >= 0; i -= 1)registeredAnimations[i].animation.destroy(animation);
        }
        function searchAnimations(animationData, standalone, renderer) {
            var animElements = [].concat([].slice.call(document.getElementsByClassName("lottie")), [].slice.call(document.getElementsByClassName("bodymovin")));
            var i;
            var lenAnims = animElements.length;
            for(i = 0; i < lenAnims; i += 1){
                if (renderer) animElements[i].setAttribute("data-bm-type", renderer);
                registerAnimation(animElements[i], animationData);
            }
            if (standalone && lenAnims === 0) {
                if (!renderer) renderer = "svg";
                var body = document.getElementsByTagName("body")[0];
                body.innerText = "";
                var div = createTag("div");
                div.style.width = "100%";
                div.style.height = "100%";
                div.setAttribute("data-bm-type", renderer);
                body.appendChild(div);
                registerAnimation(div, animationData);
            }
        }
        function resize() {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.resize();
        }
        function activate() {
            if (!_isFrozen && playingAnimationsNum) {
                if (_stopped) {
                    window.requestAnimationFrame(first);
                    _stopped = false;
                }
            }
        }
        function freeze() {
            _isFrozen = true;
        }
        function unfreeze() {
            _isFrozen = false;
            activate();
        }
        function setVolume(val, animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.setVolume(val, animation);
        }
        function mute(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.mute(animation);
        }
        function unmute(animation) {
            var i;
            for(i = 0; i < len; i += 1)registeredAnimations[i].animation.unmute(animation);
        }
        moduleOb.registerAnimation = registerAnimation;
        moduleOb.loadAnimation = loadAnimation;
        moduleOb.setSpeed = setSpeed;
        moduleOb.setDirection = setDirection;
        moduleOb.play = play;
        moduleOb.pause = pause;
        moduleOb.stop = stop;
        moduleOb.togglePause = togglePause;
        moduleOb.searchAnimations = searchAnimations;
        moduleOb.resize = resize; // moduleOb.start = start;
        moduleOb.goToAndStop = goToAndStop;
        moduleOb.destroy = destroy;
        moduleOb.freeze = freeze;
        moduleOb.unfreeze = unfreeze;
        moduleOb.setVolume = setVolume;
        moduleOb.mute = mute;
        moduleOb.unmute = unmute;
        moduleOb.getRegisteredAnimations = getRegisteredAnimations;
        return moduleOb;
    }();
    /* eslint-disable */ var BezierFactory = function() {
        /**
       * BezierEasing - use bezier curve for transition easing function
       * by Gaëtan Renaudeau 2014 - 2015 – MIT License
       *
       * Credits: is based on Firefox's nsSMILKeySpline.cpp
       * Usage:
       * var spline = BezierEasing([ 0.25, 0.1, 0.25, 1.0 ])
       * spline.get(x) => returns the easing value | x must be in [0, 1] range
       *
       */ var ob = {};
        ob.getBezierEasing = getBezierEasing;
        var beziers = {};
        function getBezierEasing(a, b, c, d, nm) {
            var str = nm || ("bez_" + a + "_" + b + "_" + c + "_" + d).replace(/\./g, "p");
            if (beziers[str]) return beziers[str];
            var bezEasing = new BezierEasing([
                a,
                b,
                c,
                d
            ]);
            beziers[str] = bezEasing;
            return bezEasing;
        } // These values are established by empiricism with tests (tradeoff: performance VS precision)
        var NEWTON_ITERATIONS = 4;
        var NEWTON_MIN_SLOPE = 0.001;
        var SUBDIVISION_PRECISION = 0.0000001;
        var SUBDIVISION_MAX_ITERATIONS = 10;
        var kSplineTableSize = 11;
        var kSampleStepSize = 1.0 / (kSplineTableSize - 1.0);
        var float32ArraySupported = typeof Float32Array === "function";
        function A(aA1, aA2) {
            return 1.0 - 3.0 * aA2 + 3.0 * aA1;
        }
        function B(aA1, aA2) {
            return 3.0 * aA2 - 6.0 * aA1;
        }
        function C(aA1) {
            return 3.0 * aA1;
        } // Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
        function calcBezier(aT, aA1, aA2) {
            return ((A(aA1, aA2) * aT + B(aA1, aA2)) * aT + C(aA1)) * aT;
        } // Returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.
        function getSlope(aT, aA1, aA2) {
            return 3.0 * A(aA1, aA2) * aT * aT + 2.0 * B(aA1, aA2) * aT + C(aA1);
        }
        function binarySubdivide(aX, aA, aB, mX1, mX2) {
            var currentX, currentT, i = 0;
            do {
                currentT = aA + (aB - aA) / 2.0;
                currentX = calcBezier(currentT, mX1, mX2) - aX;
                if (currentX > 0.0) aB = currentT;
                else aA = currentT;
            }while (Math.abs(currentX) > SUBDIVISION_PRECISION && ++i < SUBDIVISION_MAX_ITERATIONS);
            return currentT;
        }
        function newtonRaphsonIterate(aX, aGuessT, mX1, mX2) {
            for(var i = 0; i < NEWTON_ITERATIONS; ++i){
                var currentSlope = getSlope(aGuessT, mX1, mX2);
                if (currentSlope === 0.0) return aGuessT;
                var currentX = calcBezier(aGuessT, mX1, mX2) - aX;
                aGuessT -= currentX / currentSlope;
            }
            return aGuessT;
        }
        /**
       * points is an array of [ mX1, mY1, mX2, mY2 ]
       */ function BezierEasing(points) {
            this._p = points;
            this._mSampleValues = float32ArraySupported ? new Float32Array(kSplineTableSize) : new Array(kSplineTableSize);
            this._precomputed = false;
            this.get = this.get.bind(this);
        }
        BezierEasing.prototype = {
            get: function get(x) {
                var mX1 = this._p[0], mY1 = this._p[1], mX2 = this._p[2], mY2 = this._p[3];
                if (!this._precomputed) this._precompute();
                if (mX1 === mY1 && mX2 === mY2) return x; // linear
                // Because JavaScript number are imprecise, we should guarantee the extremes are right.
                if (x === 0) return 0;
                if (x === 1) return 1;
                return calcBezier(this._getTForX(x), mY1, mY2);
            },
            // Private part
            _precompute: function _precompute() {
                var mX1 = this._p[0], mY1 = this._p[1], mX2 = this._p[2], mY2 = this._p[3];
                this._precomputed = true;
                if (mX1 !== mY1 || mX2 !== mY2) this._calcSampleValues();
            },
            _calcSampleValues: function _calcSampleValues() {
                var mX1 = this._p[0], mX2 = this._p[2];
                for(var i = 0; i < kSplineTableSize; ++i)this._mSampleValues[i] = calcBezier(i * kSampleStepSize, mX1, mX2);
            },
            /**
           * getTForX chose the fastest heuristic to determine the percentage value precisely from a given X projection.
           */ _getTForX: function _getTForX(aX) {
                var mX1 = this._p[0], mX2 = this._p[2], mSampleValues = this._mSampleValues;
                var intervalStart = 0.0;
                var currentSample = 1;
                var lastSample = kSplineTableSize - 1;
                for(; currentSample !== lastSample && mSampleValues[currentSample] <= aX; ++currentSample)intervalStart += kSampleStepSize;
                --currentSample; // Interpolate to provide an initial guess for t
                var dist = (aX - mSampleValues[currentSample]) / (mSampleValues[currentSample + 1] - mSampleValues[currentSample]);
                var guessForT = intervalStart + dist * kSampleStepSize;
                var initialSlope = getSlope(guessForT, mX1, mX2);
                if (initialSlope >= NEWTON_MIN_SLOPE) return newtonRaphsonIterate(aX, guessForT, mX1, mX2);
                if (initialSlope === 0.0) return guessForT;
                return binarySubdivide(aX, intervalStart, intervalStart + kSampleStepSize, mX1, mX2);
            }
        };
        return ob;
    }();
    var pooling = function() {
        function _double(arr) {
            return arr.concat(createSizedArray(arr.length));
        }
        return {
            "double": _double
        };
    }();
    var poolFactory = function() {
        return function(initialLength, _create, _release) {
            var _length = 0;
            var _maxLength = initialLength;
            var pool = createSizedArray(_maxLength);
            var ob = {
                newElement: newElement,
                release: release
            };
            function newElement() {
                var element;
                if (_length) {
                    _length -= 1;
                    element = pool[_length];
                } else element = _create();
                return element;
            }
            function release(element) {
                if (_length === _maxLength) {
                    pool = pooling["double"](pool);
                    _maxLength *= 2;
                }
                if (_release) _release(element);
                pool[_length] = element;
                _length += 1;
            }
            return ob;
        };
    }();
    var bezierLengthPool = function() {
        function create() {
            return {
                addedLength: 0,
                percents: createTypedArray("float32", getDefaultCurveSegments()),
                lengths: createTypedArray("float32", getDefaultCurveSegments())
            };
        }
        return poolFactory(8, create);
    }();
    var segmentsLengthPool = function() {
        function create() {
            return {
                lengths: [],
                totalLength: 0
            };
        }
        function release(element) {
            var i;
            var len = element.lengths.length;
            for(i = 0; i < len; i += 1)bezierLengthPool.release(element.lengths[i]);
            element.lengths.length = 0;
        }
        return poolFactory(8, create, release);
    }();
    function bezFunction() {
        var math = Math;
        function pointOnLine2D(x1, y1, x2, y2, x3, y3) {
            var det1 = x1 * y2 + y1 * x3 + x2 * y3 - x3 * y2 - y3 * x1 - x2 * y1;
            return det1 > -0.001 && det1 < 0.001;
        }
        function pointOnLine3D(x1, y1, z1, x2, y2, z2, x3, y3, z3) {
            if (z1 === 0 && z2 === 0 && z3 === 0) return pointOnLine2D(x1, y1, x2, y2, x3, y3);
            var dist1 = math.sqrt(math.pow(x2 - x1, 2) + math.pow(y2 - y1, 2) + math.pow(z2 - z1, 2));
            var dist2 = math.sqrt(math.pow(x3 - x1, 2) + math.pow(y3 - y1, 2) + math.pow(z3 - z1, 2));
            var dist3 = math.sqrt(math.pow(x3 - x2, 2) + math.pow(y3 - y2, 2) + math.pow(z3 - z2, 2));
            var diffDist;
            if (dist1 > dist2) {
                if (dist1 > dist3) diffDist = dist1 - dist2 - dist3;
                else diffDist = dist3 - dist2 - dist1;
            } else if (dist3 > dist2) diffDist = dist3 - dist2 - dist1;
            else diffDist = dist2 - dist1 - dist3;
            return diffDist > -0.0001 && diffDist < 0.0001;
        }
        var getBezierLength = function() {
            return function(pt1, pt2, pt3, pt4) {
                var curveSegments = getDefaultCurveSegments();
                var k;
                var i;
                var len;
                var ptCoord;
                var perc;
                var addedLength = 0;
                var ptDistance;
                var point = [];
                var lastPoint = [];
                var lengthData = bezierLengthPool.newElement();
                len = pt3.length;
                for(k = 0; k < curveSegments; k += 1){
                    perc = k / (curveSegments - 1);
                    ptDistance = 0;
                    for(i = 0; i < len; i += 1){
                        ptCoord = bmPow(1 - perc, 3) * pt1[i] + 3 * bmPow(1 - perc, 2) * perc * pt3[i] + 3 * (1 - perc) * bmPow(perc, 2) * pt4[i] + bmPow(perc, 3) * pt2[i];
                        point[i] = ptCoord;
                        if (lastPoint[i] !== null) ptDistance += bmPow(point[i] - lastPoint[i], 2);
                        lastPoint[i] = point[i];
                    }
                    if (ptDistance) {
                        ptDistance = bmSqrt(ptDistance);
                        addedLength += ptDistance;
                    }
                    lengthData.percents[k] = perc;
                    lengthData.lengths[k] = addedLength;
                }
                lengthData.addedLength = addedLength;
                return lengthData;
            };
        }();
        function getSegmentsLength(shapeData) {
            var segmentsLength = segmentsLengthPool.newElement();
            var closed = shapeData.c;
            var pathV = shapeData.v;
            var pathO = shapeData.o;
            var pathI = shapeData.i;
            var i;
            var len = shapeData._length;
            var lengths = segmentsLength.lengths;
            var totalLength = 0;
            for(i = 0; i < len - 1; i += 1){
                lengths[i] = getBezierLength(pathV[i], pathV[i + 1], pathO[i], pathI[i + 1]);
                totalLength += lengths[i].addedLength;
            }
            if (closed && len) {
                lengths[i] = getBezierLength(pathV[i], pathV[0], pathO[i], pathI[0]);
                totalLength += lengths[i].addedLength;
            }
            segmentsLength.totalLength = totalLength;
            return segmentsLength;
        }
        function BezierData(length) {
            this.segmentLength = 0;
            this.points = new Array(length);
        }
        function PointData(partial, point) {
            this.partialLength = partial;
            this.point = point;
        }
        var buildBezierData = function() {
            var storedData = {};
            return function(pt1, pt2, pt3, pt4) {
                var bezierName = (pt1[0] + "_" + pt1[1] + "_" + pt2[0] + "_" + pt2[1] + "_" + pt3[0] + "_" + pt3[1] + "_" + pt4[0] + "_" + pt4[1]).replace(/\./g, "p");
                if (!storedData[bezierName]) {
                    var curveSegments = getDefaultCurveSegments();
                    var k;
                    var i;
                    var len;
                    var ptCoord;
                    var perc;
                    var addedLength = 0;
                    var ptDistance;
                    var point;
                    var lastPoint = null;
                    if (pt1.length === 2 && (pt1[0] !== pt2[0] || pt1[1] !== pt2[1]) && pointOnLine2D(pt1[0], pt1[1], pt2[0], pt2[1], pt1[0] + pt3[0], pt1[1] + pt3[1]) && pointOnLine2D(pt1[0], pt1[1], pt2[0], pt2[1], pt2[0] + pt4[0], pt2[1] + pt4[1])) curveSegments = 2;
                    var bezierData = new BezierData(curveSegments);
                    len = pt3.length;
                    for(k = 0; k < curveSegments; k += 1){
                        point = createSizedArray(len);
                        perc = k / (curveSegments - 1);
                        ptDistance = 0;
                        for(i = 0; i < len; i += 1){
                            ptCoord = bmPow(1 - perc, 3) * pt1[i] + 3 * bmPow(1 - perc, 2) * perc * (pt1[i] + pt3[i]) + 3 * (1 - perc) * bmPow(perc, 2) * (pt2[i] + pt4[i]) + bmPow(perc, 3) * pt2[i];
                            point[i] = ptCoord;
                            if (lastPoint !== null) ptDistance += bmPow(point[i] - lastPoint[i], 2);
                        }
                        ptDistance = bmSqrt(ptDistance);
                        addedLength += ptDistance;
                        bezierData.points[k] = new PointData(ptDistance, point);
                        lastPoint = point;
                    }
                    bezierData.segmentLength = addedLength;
                    storedData[bezierName] = bezierData;
                }
                return storedData[bezierName];
            };
        }();
        function getDistancePerc(perc, bezierData) {
            var percents = bezierData.percents;
            var lengths = bezierData.lengths;
            var len = percents.length;
            var initPos = bmFloor((len - 1) * perc);
            var lengthPos = perc * bezierData.addedLength;
            var lPerc = 0;
            if (initPos === len - 1 || initPos === 0 || lengthPos === lengths[initPos]) return percents[initPos];
            var dir = lengths[initPos] > lengthPos ? -1 : 1;
            var flag = true;
            while(flag){
                if (lengths[initPos] <= lengthPos && lengths[initPos + 1] > lengthPos) {
                    lPerc = (lengthPos - lengths[initPos]) / (lengths[initPos + 1] - lengths[initPos]);
                    flag = false;
                } else initPos += dir;
                if (initPos < 0 || initPos >= len - 1) {
                    // FIX for TypedArrays that don't store floating point values with enough accuracy
                    if (initPos === len - 1) return percents[initPos];
                    flag = false;
                }
            }
            return percents[initPos] + (percents[initPos + 1] - percents[initPos]) * lPerc;
        }
        function getPointInSegment(pt1, pt2, pt3, pt4, percent, bezierData) {
            var t1 = getDistancePerc(percent, bezierData);
            var u1 = 1 - t1;
            var ptX = math.round((u1 * u1 * u1 * pt1[0] + (t1 * u1 * u1 + u1 * t1 * u1 + u1 * u1 * t1) * pt3[0] + (t1 * t1 * u1 + u1 * t1 * t1 + t1 * u1 * t1) * pt4[0] + t1 * t1 * t1 * pt2[0]) * 1000) / 1000;
            var ptY = math.round((u1 * u1 * u1 * pt1[1] + (t1 * u1 * u1 + u1 * t1 * u1 + u1 * u1 * t1) * pt3[1] + (t1 * t1 * u1 + u1 * t1 * t1 + t1 * u1 * t1) * pt4[1] + t1 * t1 * t1 * pt2[1]) * 1000) / 1000;
            return [
                ptX,
                ptY
            ];
        }
        var bezierSegmentPoints = createTypedArray("float32", 8);
        function getNewSegment(pt1, pt2, pt3, pt4, startPerc, endPerc, bezierData) {
            if (startPerc < 0) startPerc = 0;
            else if (startPerc > 1) startPerc = 1;
            var t0 = getDistancePerc(startPerc, bezierData);
            endPerc = endPerc > 1 ? 1 : endPerc;
            var t1 = getDistancePerc(endPerc, bezierData);
            var i;
            var len = pt1.length;
            var u0 = 1 - t0;
            var u1 = 1 - t1;
            var u0u0u0 = u0 * u0 * u0;
            var t0u0u0_3 = t0 * u0 * u0 * 3; // eslint-disable-line camelcase
            var t0t0u0_3 = t0 * t0 * u0 * 3; // eslint-disable-line camelcase
            var t0t0t0 = t0 * t0 * t0; //
            var u0u0u1 = u0 * u0 * u1;
            var t0u0u1_3 = t0 * u0 * u1 + u0 * t0 * u1 + u0 * u0 * t1; // eslint-disable-line camelcase
            var t0t0u1_3 = t0 * t0 * u1 + u0 * t0 * t1 + t0 * u0 * t1; // eslint-disable-line camelcase
            var t0t0t1 = t0 * t0 * t1; //
            var u0u1u1 = u0 * u1 * u1;
            var t0u1u1_3 = t0 * u1 * u1 + u0 * t1 * u1 + u0 * u1 * t1; // eslint-disable-line camelcase
            var t0t1u1_3 = t0 * t1 * u1 + u0 * t1 * t1 + t0 * u1 * t1; // eslint-disable-line camelcase
            var t0t1t1 = t0 * t1 * t1; //
            var u1u1u1 = u1 * u1 * u1;
            var t1u1u1_3 = t1 * u1 * u1 + u1 * t1 * u1 + u1 * u1 * t1; // eslint-disable-line camelcase
            var t1t1u1_3 = t1 * t1 * u1 + u1 * t1 * t1 + t1 * u1 * t1; // eslint-disable-line camelcase
            var t1t1t1 = t1 * t1 * t1;
            for(i = 0; i < len; i += 1){
                bezierSegmentPoints[i * 4] = math.round((u0u0u0 * pt1[i] + t0u0u0_3 * pt3[i] + t0t0u0_3 * pt4[i] + t0t0t0 * pt2[i]) * 1000) / 1000; // eslint-disable-line camelcase
                bezierSegmentPoints[i * 4 + 1] = math.round((u0u0u1 * pt1[i] + t0u0u1_3 * pt3[i] + t0t0u1_3 * pt4[i] + t0t0t1 * pt2[i]) * 1000) / 1000; // eslint-disable-line camelcase
                bezierSegmentPoints[i * 4 + 2] = math.round((u0u1u1 * pt1[i] + t0u1u1_3 * pt3[i] + t0t1u1_3 * pt4[i] + t0t1t1 * pt2[i]) * 1000) / 1000; // eslint-disable-line camelcase
                bezierSegmentPoints[i * 4 + 3] = math.round((u1u1u1 * pt1[i] + t1u1u1_3 * pt3[i] + t1t1u1_3 * pt4[i] + t1t1t1 * pt2[i]) * 1000) / 1000; // eslint-disable-line camelcase
            }
            return bezierSegmentPoints;
        }
        return {
            getSegmentsLength: getSegmentsLength,
            getNewSegment: getNewSegment,
            getPointInSegment: getPointInSegment,
            buildBezierData: buildBezierData,
            pointOnLine2D: pointOnLine2D,
            pointOnLine3D: pointOnLine3D
        };
    }
    var bez = bezFunction();
    var PropertyFactory = function() {
        var initFrame = initialDefaultFrame;
        var mathAbs = Math.abs;
        function interpolateValue(frameNum, caching) {
            var offsetTime = this.offsetTime;
            var newValue;
            if (this.propType === "multidimensional") newValue = createTypedArray("float32", this.pv.length);
            var iterationIndex = caching.lastIndex;
            var i = iterationIndex;
            var len = this.keyframes.length - 1;
            var flag = true;
            var keyData;
            var nextKeyData;
            var keyframeMetadata;
            while(flag){
                keyData = this.keyframes[i];
                nextKeyData = this.keyframes[i + 1];
                if (i === len - 1 && frameNum >= nextKeyData.t - offsetTime) {
                    if (keyData.h) keyData = nextKeyData;
                    iterationIndex = 0;
                    break;
                }
                if (nextKeyData.t - offsetTime > frameNum) {
                    iterationIndex = i;
                    break;
                }
                if (i < len - 1) i += 1;
                else {
                    iterationIndex = 0;
                    flag = false;
                }
            }
            keyframeMetadata = this.keyframesMetadata[i] || {};
            var k;
            var kLen;
            var perc;
            var jLen;
            var j;
            var fnc;
            var nextKeyTime = nextKeyData.t - offsetTime;
            var keyTime = keyData.t - offsetTime;
            var endValue;
            if (keyData.to) {
                if (!keyframeMetadata.bezierData) keyframeMetadata.bezierData = bez.buildBezierData(keyData.s, nextKeyData.s || keyData.e, keyData.to, keyData.ti);
                var bezierData = keyframeMetadata.bezierData;
                if (frameNum >= nextKeyTime || frameNum < keyTime) {
                    var ind = frameNum >= nextKeyTime ? bezierData.points.length - 1 : 0;
                    kLen = bezierData.points[ind].point.length;
                    for(k = 0; k < kLen; k += 1)newValue[k] = bezierData.points[ind].point[k];
                     // caching._lastKeyframeIndex = -1;
                } else {
                    if (keyframeMetadata.__fnct) fnc = keyframeMetadata.__fnct;
                    else {
                        fnc = BezierFactory.getBezierEasing(keyData.o.x, keyData.o.y, keyData.i.x, keyData.i.y, keyData.n).get;
                        keyframeMetadata.__fnct = fnc;
                    }
                    perc = fnc((frameNum - keyTime) / (nextKeyTime - keyTime));
                    var distanceInLine = bezierData.segmentLength * perc;
                    var segmentPerc;
                    var addedLength = caching.lastFrame < frameNum && caching._lastKeyframeIndex === i ? caching._lastAddedLength : 0;
                    j = caching.lastFrame < frameNum && caching._lastKeyframeIndex === i ? caching._lastPoint : 0;
                    flag = true;
                    jLen = bezierData.points.length;
                    while(flag){
                        addedLength += bezierData.points[j].partialLength;
                        if (distanceInLine === 0 || perc === 0 || j === bezierData.points.length - 1) {
                            kLen = bezierData.points[j].point.length;
                            for(k = 0; k < kLen; k += 1)newValue[k] = bezierData.points[j].point[k];
                            break;
                        } else if (distanceInLine >= addedLength && distanceInLine < addedLength + bezierData.points[j + 1].partialLength) {
                            segmentPerc = (distanceInLine - addedLength) / bezierData.points[j + 1].partialLength;
                            kLen = bezierData.points[j].point.length;
                            for(k = 0; k < kLen; k += 1)newValue[k] = bezierData.points[j].point[k] + (bezierData.points[j + 1].point[k] - bezierData.points[j].point[k]) * segmentPerc;
                            break;
                        }
                        if (j < jLen - 1) j += 1;
                        else flag = false;
                    }
                    caching._lastPoint = j;
                    caching._lastAddedLength = addedLength - bezierData.points[j].partialLength;
                    caching._lastKeyframeIndex = i;
                }
            } else {
                var outX;
                var outY;
                var inX;
                var inY;
                var keyValue;
                len = keyData.s.length;
                endValue = nextKeyData.s || keyData.e;
                if (this.sh && keyData.h !== 1) {
                    if (frameNum >= nextKeyTime) {
                        newValue[0] = endValue[0];
                        newValue[1] = endValue[1];
                        newValue[2] = endValue[2];
                    } else if (frameNum <= keyTime) {
                        newValue[0] = keyData.s[0];
                        newValue[1] = keyData.s[1];
                        newValue[2] = keyData.s[2];
                    } else {
                        var quatStart = createQuaternion(keyData.s);
                        var quatEnd = createQuaternion(endValue);
                        var time = (frameNum - keyTime) / (nextKeyTime - keyTime);
                        quaternionToEuler(newValue, slerp(quatStart, quatEnd, time));
                    }
                } else for(i = 0; i < len; i += 1){
                    if (keyData.h !== 1) {
                        if (frameNum >= nextKeyTime) perc = 1;
                        else if (frameNum < keyTime) perc = 0;
                        else {
                            if (keyData.o.x.constructor === Array) {
                                if (!keyframeMetadata.__fnct) keyframeMetadata.__fnct = [];
                                if (!keyframeMetadata.__fnct[i]) {
                                    outX = keyData.o.x[i] === undefined ? keyData.o.x[0] : keyData.o.x[i];
                                    outY = keyData.o.y[i] === undefined ? keyData.o.y[0] : keyData.o.y[i];
                                    inX = keyData.i.x[i] === undefined ? keyData.i.x[0] : keyData.i.x[i];
                                    inY = keyData.i.y[i] === undefined ? keyData.i.y[0] : keyData.i.y[i];
                                    fnc = BezierFactory.getBezierEasing(outX, outY, inX, inY).get;
                                    keyframeMetadata.__fnct[i] = fnc;
                                } else fnc = keyframeMetadata.__fnct[i];
                            } else if (!keyframeMetadata.__fnct) {
                                outX = keyData.o.x;
                                outY = keyData.o.y;
                                inX = keyData.i.x;
                                inY = keyData.i.y;
                                fnc = BezierFactory.getBezierEasing(outX, outY, inX, inY).get;
                                keyData.keyframeMetadata = fnc;
                            } else fnc = keyframeMetadata.__fnct;
                            perc = fnc((frameNum - keyTime) / (nextKeyTime - keyTime));
                        }
                    }
                    endValue = nextKeyData.s || keyData.e;
                    keyValue = keyData.h === 1 ? keyData.s[i] : keyData.s[i] + (endValue[i] - keyData.s[i]) * perc;
                    if (this.propType === "multidimensional") newValue[i] = keyValue;
                    else newValue = keyValue;
                }
            }
            caching.lastIndex = iterationIndex;
            return newValue;
        } // based on @Toji's https://github.com/toji/gl-matrix/
        function slerp(a, b, t) {
            var out = [];
            var ax = a[0];
            var ay = a[1];
            var az = a[2];
            var aw = a[3];
            var bx = b[0];
            var by = b[1];
            var bz = b[2];
            var bw = b[3];
            var omega;
            var cosom;
            var sinom;
            var scale0;
            var scale1;
            cosom = ax * bx + ay * by + az * bz + aw * bw;
            if (cosom < 0.0) {
                cosom = -cosom;
                bx = -bx;
                by = -by;
                bz = -bz;
                bw = -bw;
            }
            if (1.0 - cosom > 0.000001) {
                omega = Math.acos(cosom);
                sinom = Math.sin(omega);
                scale0 = Math.sin((1.0 - t) * omega) / sinom;
                scale1 = Math.sin(t * omega) / sinom;
            } else {
                scale0 = 1.0 - t;
                scale1 = t;
            }
            out[0] = scale0 * ax + scale1 * bx;
            out[1] = scale0 * ay + scale1 * by;
            out[2] = scale0 * az + scale1 * bz;
            out[3] = scale0 * aw + scale1 * bw;
            return out;
        }
        function quaternionToEuler(out, quat) {
            var qx = quat[0];
            var qy = quat[1];
            var qz = quat[2];
            var qw = quat[3];
            var heading = Math.atan2(2 * qy * qw - 2 * qx * qz, 1 - 2 * qy * qy - 2 * qz * qz);
            var attitude = Math.asin(2 * qx * qy + 2 * qz * qw);
            var bank = Math.atan2(2 * qx * qw - 2 * qy * qz, 1 - 2 * qx * qx - 2 * qz * qz);
            out[0] = heading / degToRads;
            out[1] = attitude / degToRads;
            out[2] = bank / degToRads;
        }
        function createQuaternion(values) {
            var heading = values[0] * degToRads;
            var attitude = values[1] * degToRads;
            var bank = values[2] * degToRads;
            var c1 = Math.cos(heading / 2);
            var c2 = Math.cos(attitude / 2);
            var c3 = Math.cos(bank / 2);
            var s1 = Math.sin(heading / 2);
            var s2 = Math.sin(attitude / 2);
            var s3 = Math.sin(bank / 2);
            var w = c1 * c2 * c3 - s1 * s2 * s3;
            var x = s1 * s2 * c3 + c1 * c2 * s3;
            var y = s1 * c2 * c3 + c1 * s2 * s3;
            var z = c1 * s2 * c3 - s1 * c2 * s3;
            return [
                x,
                y,
                z,
                w
            ];
        }
        function getValueAtCurrentTime() {
            var frameNum = this.comp.renderedFrame - this.offsetTime;
            var initTime = this.keyframes[0].t - this.offsetTime;
            var endTime = this.keyframes[this.keyframes.length - 1].t - this.offsetTime;
            if (!(frameNum === this._caching.lastFrame || this._caching.lastFrame !== initFrame && (this._caching.lastFrame >= endTime && frameNum >= endTime || this._caching.lastFrame < initTime && frameNum < initTime))) {
                if (this._caching.lastFrame >= frameNum) {
                    this._caching._lastKeyframeIndex = -1;
                    this._caching.lastIndex = 0;
                }
                var renderResult = this.interpolateValue(frameNum, this._caching);
                this.pv = renderResult;
            }
            this._caching.lastFrame = frameNum;
            return this.pv;
        }
        function setVValue(val) {
            var multipliedValue;
            if (this.propType === "unidimensional") {
                multipliedValue = val * this.mult;
                if (mathAbs(this.v - multipliedValue) > 0.00001) {
                    this.v = multipliedValue;
                    this._mdf = true;
                }
            } else {
                var i = 0;
                var len = this.v.length;
                while(i < len){
                    multipliedValue = val[i] * this.mult;
                    if (mathAbs(this.v[i] - multipliedValue) > 0.00001) {
                        this.v[i] = multipliedValue;
                        this._mdf = true;
                    }
                    i += 1;
                }
            }
        }
        function processEffectsSequence() {
            if (this.elem.globalData.frameId === this.frameId || !this.effectsSequence.length) return;
            if (this.lock) {
                this.setVValue(this.pv);
                return;
            }
            this.lock = true;
            this._mdf = this._isFirstFrame;
            var i;
            var len = this.effectsSequence.length;
            var finalValue = this.kf ? this.pv : this.data.k;
            for(i = 0; i < len; i += 1)finalValue = this.effectsSequence[i](finalValue);
            this.setVValue(finalValue);
            this._isFirstFrame = false;
            this.lock = false;
            this.frameId = this.elem.globalData.frameId;
        }
        function addEffect(effectFunction) {
            this.effectsSequence.push(effectFunction);
            this.container.addDynamicProperty(this);
        }
        function ValueProperty(elem, data, mult, container) {
            this.propType = "unidimensional";
            this.mult = mult || 1;
            this.data = data;
            this.v = mult ? data.k * mult : data.k;
            this.pv = data.k;
            this._mdf = false;
            this.elem = elem;
            this.container = container;
            this.comp = elem.comp;
            this.k = false;
            this.kf = false;
            this.vel = 0;
            this.effectsSequence = [];
            this._isFirstFrame = true;
            this.getValue = processEffectsSequence;
            this.setVValue = setVValue;
            this.addEffect = addEffect;
        }
        function MultiDimensionalProperty(elem, data, mult, container) {
            this.propType = "multidimensional";
            this.mult = mult || 1;
            this.data = data;
            this._mdf = false;
            this.elem = elem;
            this.container = container;
            this.comp = elem.comp;
            this.k = false;
            this.kf = false;
            this.frameId = -1;
            var i;
            var len = data.k.length;
            this.v = createTypedArray("float32", len);
            this.pv = createTypedArray("float32", len);
            this.vel = createTypedArray("float32", len);
            for(i = 0; i < len; i += 1){
                this.v[i] = data.k[i] * this.mult;
                this.pv[i] = data.k[i];
            }
            this._isFirstFrame = true;
            this.effectsSequence = [];
            this.getValue = processEffectsSequence;
            this.setVValue = setVValue;
            this.addEffect = addEffect;
        }
        function KeyframedValueProperty(elem, data, mult, container) {
            this.propType = "unidimensional";
            this.keyframes = data.k;
            this.keyframesMetadata = [];
            this.offsetTime = elem.data.st;
            this.frameId = -1;
            this._caching = {
                lastFrame: initFrame,
                lastIndex: 0,
                value: 0,
                _lastKeyframeIndex: -1
            };
            this.k = true;
            this.kf = true;
            this.data = data;
            this.mult = mult || 1;
            this.elem = elem;
            this.container = container;
            this.comp = elem.comp;
            this.v = initFrame;
            this.pv = initFrame;
            this._isFirstFrame = true;
            this.getValue = processEffectsSequence;
            this.setVValue = setVValue;
            this.interpolateValue = interpolateValue;
            this.effectsSequence = [
                getValueAtCurrentTime.bind(this)
            ];
            this.addEffect = addEffect;
        }
        function KeyframedMultidimensionalProperty(elem, data, mult, container) {
            this.propType = "multidimensional";
            var i;
            var len = data.k.length;
            var s;
            var e;
            var to;
            var ti;
            for(i = 0; i < len - 1; i += 1)if (data.k[i].to && data.k[i].s && data.k[i + 1] && data.k[i + 1].s) {
                s = data.k[i].s;
                e = data.k[i + 1].s;
                to = data.k[i].to;
                ti = data.k[i].ti;
                if (s.length === 2 && !(s[0] === e[0] && s[1] === e[1]) && bez.pointOnLine2D(s[0], s[1], e[0], e[1], s[0] + to[0], s[1] + to[1]) && bez.pointOnLine2D(s[0], s[1], e[0], e[1], e[0] + ti[0], e[1] + ti[1]) || s.length === 3 && !(s[0] === e[0] && s[1] === e[1] && s[2] === e[2]) && bez.pointOnLine3D(s[0], s[1], s[2], e[0], e[1], e[2], s[0] + to[0], s[1] + to[1], s[2] + to[2]) && bez.pointOnLine3D(s[0], s[1], s[2], e[0], e[1], e[2], e[0] + ti[0], e[1] + ti[1], e[2] + ti[2])) {
                    data.k[i].to = null;
                    data.k[i].ti = null;
                }
                if (s[0] === e[0] && s[1] === e[1] && to[0] === 0 && to[1] === 0 && ti[0] === 0 && ti[1] === 0) {
                    if (s.length === 2 || s[2] === e[2] && to[2] === 0 && ti[2] === 0) {
                        data.k[i].to = null;
                        data.k[i].ti = null;
                    }
                }
            }
            this.effectsSequence = [
                getValueAtCurrentTime.bind(this)
            ];
            this.data = data;
            this.keyframes = data.k;
            this.keyframesMetadata = [];
            this.offsetTime = elem.data.st;
            this.k = true;
            this.kf = true;
            this._isFirstFrame = true;
            this.mult = mult || 1;
            this.elem = elem;
            this.container = container;
            this.comp = elem.comp;
            this.getValue = processEffectsSequence;
            this.setVValue = setVValue;
            this.interpolateValue = interpolateValue;
            this.frameId = -1;
            var arrLen = data.k[0].s.length;
            this.v = createTypedArray("float32", arrLen);
            this.pv = createTypedArray("float32", arrLen);
            for(i = 0; i < arrLen; i += 1){
                this.v[i] = initFrame;
                this.pv[i] = initFrame;
            }
            this._caching = {
                lastFrame: initFrame,
                lastIndex: 0,
                value: createTypedArray("float32", arrLen)
            };
            this.addEffect = addEffect;
        }
        function getProp(elem, data, type, mult, container) {
            var p;
            if (!data.k.length) p = new ValueProperty(elem, data, mult, container);
            else if (typeof data.k[0] === "number") p = new MultiDimensionalProperty(elem, data, mult, container);
            else switch(type){
                case 0:
                    p = new KeyframedValueProperty(elem, data, mult, container);
                    break;
                case 1:
                    p = new KeyframedMultidimensionalProperty(elem, data, mult, container);
                    break;
                default:
                    break;
            }
            if (p.effectsSequence.length) container.addDynamicProperty(p);
            return p;
        }
        var ob = {
            getProp: getProp
        };
        return ob;
    }();
    function DynamicPropertyContainer() {}
    DynamicPropertyContainer.prototype = {
        addDynamicProperty: function addDynamicProperty(prop) {
            if (this.dynamicProperties.indexOf(prop) === -1) {
                this.dynamicProperties.push(prop);
                this.container.addDynamicProperty(this);
                this._isAnimated = true;
            }
        },
        iterateDynamicProperties: function iterateDynamicProperties() {
            this._mdf = false;
            var i;
            var len = this.dynamicProperties.length;
            for(i = 0; i < len; i += 1){
                this.dynamicProperties[i].getValue();
                if (this.dynamicProperties[i]._mdf) this._mdf = true;
            }
        },
        initDynamicPropertyContainer: function initDynamicPropertyContainer(container) {
            this.container = container;
            this.dynamicProperties = [];
            this._mdf = false;
            this._isAnimated = false;
        }
    };
    var pointPool = function() {
        function create() {
            return createTypedArray("float32", 2);
        }
        return poolFactory(8, create);
    }();
    function ShapePath() {
        this.c = false;
        this._length = 0;
        this._maxLength = 8;
        this.v = createSizedArray(this._maxLength);
        this.o = createSizedArray(this._maxLength);
        this.i = createSizedArray(this._maxLength);
    }
    ShapePath.prototype.setPathData = function(closed, len) {
        this.c = closed;
        this.setLength(len);
        var i = 0;
        while(i < len){
            this.v[i] = pointPool.newElement();
            this.o[i] = pointPool.newElement();
            this.i[i] = pointPool.newElement();
            i += 1;
        }
    };
    ShapePath.prototype.setLength = function(len) {
        while(this._maxLength < len)this.doubleArrayLength();
        this._length = len;
    };
    ShapePath.prototype.doubleArrayLength = function() {
        this.v = this.v.concat(createSizedArray(this._maxLength));
        this.i = this.i.concat(createSizedArray(this._maxLength));
        this.o = this.o.concat(createSizedArray(this._maxLength));
        this._maxLength *= 2;
    };
    ShapePath.prototype.setXYAt = function(x, y, type, pos, replace) {
        var arr;
        this._length = Math.max(this._length, pos + 1);
        if (this._length >= this._maxLength) this.doubleArrayLength();
        switch(type){
            case "v":
                arr = this.v;
                break;
            case "i":
                arr = this.i;
                break;
            case "o":
                arr = this.o;
                break;
            default:
                arr = [];
                break;
        }
        if (!arr[pos] || arr[pos] && !replace) arr[pos] = pointPool.newElement();
        arr[pos][0] = x;
        arr[pos][1] = y;
    };
    ShapePath.prototype.setTripleAt = function(vX, vY, oX, oY, iX, iY, pos, replace) {
        this.setXYAt(vX, vY, "v", pos, replace);
        this.setXYAt(oX, oY, "o", pos, replace);
        this.setXYAt(iX, iY, "i", pos, replace);
    };
    ShapePath.prototype.reverse = function() {
        var newPath = new ShapePath();
        newPath.setPathData(this.c, this._length);
        var vertices = this.v;
        var outPoints = this.o;
        var inPoints = this.i;
        var init = 0;
        if (this.c) {
            newPath.setTripleAt(vertices[0][0], vertices[0][1], inPoints[0][0], inPoints[0][1], outPoints[0][0], outPoints[0][1], 0, false);
            init = 1;
        }
        var cnt = this._length - 1;
        var len = this._length;
        var i;
        for(i = init; i < len; i += 1){
            newPath.setTripleAt(vertices[cnt][0], vertices[cnt][1], inPoints[cnt][0], inPoints[cnt][1], outPoints[cnt][0], outPoints[cnt][1], i, false);
            cnt -= 1;
        }
        return newPath;
    };
    ShapePath.prototype.length = function() {
        return this._length;
    };
    var shapePool = function() {
        function create() {
            return new ShapePath();
        }
        function release(shapePath) {
            var len = shapePath._length;
            var i;
            for(i = 0; i < len; i += 1){
                pointPool.release(shapePath.v[i]);
                pointPool.release(shapePath.i[i]);
                pointPool.release(shapePath.o[i]);
                shapePath.v[i] = null;
                shapePath.i[i] = null;
                shapePath.o[i] = null;
            }
            shapePath._length = 0;
            shapePath.c = false;
        }
        function clone(shape) {
            var cloned = factory.newElement();
            var i;
            var len = shape._length === undefined ? shape.v.length : shape._length;
            cloned.setLength(len);
            cloned.c = shape.c;
            for(i = 0; i < len; i += 1)cloned.setTripleAt(shape.v[i][0], shape.v[i][1], shape.o[i][0], shape.o[i][1], shape.i[i][0], shape.i[i][1], i);
            return cloned;
        }
        var factory = poolFactory(4, create, release);
        factory.clone = clone;
        return factory;
    }();
    function ShapeCollection() {
        this._length = 0;
        this._maxLength = 4;
        this.shapes = createSizedArray(this._maxLength);
    }
    ShapeCollection.prototype.addShape = function(shapeData) {
        if (this._length === this._maxLength) {
            this.shapes = this.shapes.concat(createSizedArray(this._maxLength));
            this._maxLength *= 2;
        }
        this.shapes[this._length] = shapeData;
        this._length += 1;
    };
    ShapeCollection.prototype.releaseShapes = function() {
        var i;
        for(i = 0; i < this._length; i += 1)shapePool.release(this.shapes[i]);
        this._length = 0;
    };
    var shapeCollectionPool = function() {
        var ob = {
            newShapeCollection: newShapeCollection,
            release: release
        };
        var _length = 0;
        var _maxLength = 4;
        var pool = createSizedArray(_maxLength);
        function newShapeCollection() {
            var shapeCollection;
            if (_length) {
                _length -= 1;
                shapeCollection = pool[_length];
            } else shapeCollection = new ShapeCollection();
            return shapeCollection;
        }
        function release(shapeCollection) {
            var i;
            var len = shapeCollection._length;
            for(i = 0; i < len; i += 1)shapePool.release(shapeCollection.shapes[i]);
            shapeCollection._length = 0;
            if (_length === _maxLength) {
                pool = pooling["double"](pool);
                _maxLength *= 2;
            }
            pool[_length] = shapeCollection;
            _length += 1;
        }
        return ob;
    }();
    var ShapePropertyFactory = function() {
        var initFrame = -999999;
        function interpolateShape(frameNum, previousValue, caching) {
            var iterationIndex = caching.lastIndex;
            var keyPropS;
            var keyPropE;
            var isHold;
            var j;
            var k;
            var jLen;
            var kLen;
            var perc;
            var vertexValue;
            var kf = this.keyframes;
            if (frameNum < kf[0].t - this.offsetTime) {
                keyPropS = kf[0].s[0];
                isHold = true;
                iterationIndex = 0;
            } else if (frameNum >= kf[kf.length - 1].t - this.offsetTime) {
                keyPropS = kf[kf.length - 1].s ? kf[kf.length - 1].s[0] : kf[kf.length - 2].e[0];
                /* if(kf[kf.length - 1].s){
                  keyPropS = kf[kf.length - 1].s[0];
              }else{
                  keyPropS = kf[kf.length - 2].e[0];
              } */ isHold = true;
            } else {
                var i = iterationIndex;
                var len = kf.length - 1;
                var flag = true;
                var keyData;
                var nextKeyData;
                var keyframeMetadata;
                while(flag){
                    keyData = kf[i];
                    nextKeyData = kf[i + 1];
                    if (nextKeyData.t - this.offsetTime > frameNum) break;
                    if (i < len - 1) i += 1;
                    else flag = false;
                }
                keyframeMetadata = this.keyframesMetadata[i] || {};
                isHold = keyData.h === 1;
                iterationIndex = i;
                if (!isHold) {
                    if (frameNum >= nextKeyData.t - this.offsetTime) perc = 1;
                    else if (frameNum < keyData.t - this.offsetTime) perc = 0;
                    else {
                        var fnc;
                        if (keyframeMetadata.__fnct) fnc = keyframeMetadata.__fnct;
                        else {
                            fnc = BezierFactory.getBezierEasing(keyData.o.x, keyData.o.y, keyData.i.x, keyData.i.y).get;
                            keyframeMetadata.__fnct = fnc;
                        }
                        perc = fnc((frameNum - (keyData.t - this.offsetTime)) / (nextKeyData.t - this.offsetTime - (keyData.t - this.offsetTime)));
                    }
                    keyPropE = nextKeyData.s ? nextKeyData.s[0] : keyData.e[0];
                }
                keyPropS = keyData.s[0];
            }
            jLen = previousValue._length;
            kLen = keyPropS.i[0].length;
            caching.lastIndex = iterationIndex;
            for(j = 0; j < jLen; j += 1)for(k = 0; k < kLen; k += 1){
                vertexValue = isHold ? keyPropS.i[j][k] : keyPropS.i[j][k] + (keyPropE.i[j][k] - keyPropS.i[j][k]) * perc;
                previousValue.i[j][k] = vertexValue;
                vertexValue = isHold ? keyPropS.o[j][k] : keyPropS.o[j][k] + (keyPropE.o[j][k] - keyPropS.o[j][k]) * perc;
                previousValue.o[j][k] = vertexValue;
                vertexValue = isHold ? keyPropS.v[j][k] : keyPropS.v[j][k] + (keyPropE.v[j][k] - keyPropS.v[j][k]) * perc;
                previousValue.v[j][k] = vertexValue;
            }
        }
        function interpolateShapeCurrentTime() {
            var frameNum = this.comp.renderedFrame - this.offsetTime;
            var initTime = this.keyframes[0].t - this.offsetTime;
            var endTime = this.keyframes[this.keyframes.length - 1].t - this.offsetTime;
            var lastFrame = this._caching.lastFrame;
            if (!(lastFrame !== initFrame && (lastFrame < initTime && frameNum < initTime || lastFrame > endTime && frameNum > endTime))) {
                /// /
                this._caching.lastIndex = lastFrame < frameNum ? this._caching.lastIndex : 0;
                this.interpolateShape(frameNum, this.pv, this._caching); /// /
            }
            this._caching.lastFrame = frameNum;
            return this.pv;
        }
        function resetShape() {
            this.paths = this.localShapeCollection;
        }
        function shapesEqual(shape1, shape2) {
            if (shape1._length !== shape2._length || shape1.c !== shape2.c) return false;
            var i;
            var len = shape1._length;
            for(i = 0; i < len; i += 1){
                if (shape1.v[i][0] !== shape2.v[i][0] || shape1.v[i][1] !== shape2.v[i][1] || shape1.o[i][0] !== shape2.o[i][0] || shape1.o[i][1] !== shape2.o[i][1] || shape1.i[i][0] !== shape2.i[i][0] || shape1.i[i][1] !== shape2.i[i][1]) return false;
            }
            return true;
        }
        function setVValue(newPath) {
            if (!shapesEqual(this.v, newPath)) {
                this.v = shapePool.clone(newPath);
                this.localShapeCollection.releaseShapes();
                this.localShapeCollection.addShape(this.v);
                this._mdf = true;
                this.paths = this.localShapeCollection;
            }
        }
        function processEffectsSequence() {
            if (this.elem.globalData.frameId === this.frameId) return;
            if (!this.effectsSequence.length) {
                this._mdf = false;
                return;
            }
            if (this.lock) {
                this.setVValue(this.pv);
                return;
            }
            this.lock = true;
            this._mdf = false;
            var finalValue;
            if (this.kf) finalValue = this.pv;
            else if (this.data.ks) finalValue = this.data.ks.k;
            else finalValue = this.data.pt.k;
            var i;
            var len = this.effectsSequence.length;
            for(i = 0; i < len; i += 1)finalValue = this.effectsSequence[i](finalValue);
            this.setVValue(finalValue);
            this.lock = false;
            this.frameId = this.elem.globalData.frameId;
        }
        function ShapeProperty(elem, data, type) {
            this.propType = "shape";
            this.comp = elem.comp;
            this.container = elem;
            this.elem = elem;
            this.data = data;
            this.k = false;
            this.kf = false;
            this._mdf = false;
            var pathData = type === 3 ? data.pt.k : data.ks.k;
            this.v = shapePool.clone(pathData);
            this.pv = shapePool.clone(this.v);
            this.localShapeCollection = shapeCollectionPool.newShapeCollection();
            this.paths = this.localShapeCollection;
            this.paths.addShape(this.v);
            this.reset = resetShape;
            this.effectsSequence = [];
        }
        function addEffect(effectFunction) {
            this.effectsSequence.push(effectFunction);
            this.container.addDynamicProperty(this);
        }
        ShapeProperty.prototype.interpolateShape = interpolateShape;
        ShapeProperty.prototype.getValue = processEffectsSequence;
        ShapeProperty.prototype.setVValue = setVValue;
        ShapeProperty.prototype.addEffect = addEffect;
        function KeyframedShapeProperty(elem, data, type) {
            this.propType = "shape";
            this.comp = elem.comp;
            this.elem = elem;
            this.container = elem;
            this.offsetTime = elem.data.st;
            this.keyframes = type === 3 ? data.pt.k : data.ks.k;
            this.keyframesMetadata = [];
            this.k = true;
            this.kf = true;
            var len = this.keyframes[0].s[0].i.length;
            this.v = shapePool.newElement();
            this.v.setPathData(this.keyframes[0].s[0].c, len);
            this.pv = shapePool.clone(this.v);
            this.localShapeCollection = shapeCollectionPool.newShapeCollection();
            this.paths = this.localShapeCollection;
            this.paths.addShape(this.v);
            this.lastFrame = initFrame;
            this.reset = resetShape;
            this._caching = {
                lastFrame: initFrame,
                lastIndex: 0
            };
            this.effectsSequence = [
                interpolateShapeCurrentTime.bind(this)
            ];
        }
        KeyframedShapeProperty.prototype.getValue = processEffectsSequence;
        KeyframedShapeProperty.prototype.interpolateShape = interpolateShape;
        KeyframedShapeProperty.prototype.setVValue = setVValue;
        KeyframedShapeProperty.prototype.addEffect = addEffect;
        var EllShapeProperty = function() {
            var cPoint = roundCorner;
            function EllShapePropertyFactory(elem, data) {
                this.v = shapePool.newElement();
                this.v.setPathData(true, 4);
                this.localShapeCollection = shapeCollectionPool.newShapeCollection();
                this.paths = this.localShapeCollection;
                this.localShapeCollection.addShape(this.v);
                this.d = data.d;
                this.elem = elem;
                this.comp = elem.comp;
                this.frameId = -1;
                this.initDynamicPropertyContainer(elem);
                this.p = PropertyFactory.getProp(elem, data.p, 1, 0, this);
                this.s = PropertyFactory.getProp(elem, data.s, 1, 0, this);
                if (this.dynamicProperties.length) this.k = true;
                else {
                    this.k = false;
                    this.convertEllToPath();
                }
            }
            EllShapePropertyFactory.prototype = {
                reset: resetShape,
                getValue: function getValue() {
                    if (this.elem.globalData.frameId === this.frameId) return;
                    this.frameId = this.elem.globalData.frameId;
                    this.iterateDynamicProperties();
                    if (this._mdf) this.convertEllToPath();
                },
                convertEllToPath: function convertEllToPath() {
                    var p0 = this.p.v[0];
                    var p1 = this.p.v[1];
                    var s0 = this.s.v[0] / 2;
                    var s1 = this.s.v[1] / 2;
                    var _cw = this.d !== 3;
                    var _v = this.v;
                    _v.v[0][0] = p0;
                    _v.v[0][1] = p1 - s1;
                    _v.v[1][0] = _cw ? p0 + s0 : p0 - s0;
                    _v.v[1][1] = p1;
                    _v.v[2][0] = p0;
                    _v.v[2][1] = p1 + s1;
                    _v.v[3][0] = _cw ? p0 - s0 : p0 + s0;
                    _v.v[3][1] = p1;
                    _v.i[0][0] = _cw ? p0 - s0 * cPoint : p0 + s0 * cPoint;
                    _v.i[0][1] = p1 - s1;
                    _v.i[1][0] = _cw ? p0 + s0 : p0 - s0;
                    _v.i[1][1] = p1 - s1 * cPoint;
                    _v.i[2][0] = _cw ? p0 + s0 * cPoint : p0 - s0 * cPoint;
                    _v.i[2][1] = p1 + s1;
                    _v.i[3][0] = _cw ? p0 - s0 : p0 + s0;
                    _v.i[3][1] = p1 + s1 * cPoint;
                    _v.o[0][0] = _cw ? p0 + s0 * cPoint : p0 - s0 * cPoint;
                    _v.o[0][1] = p1 - s1;
                    _v.o[1][0] = _cw ? p0 + s0 : p0 - s0;
                    _v.o[1][1] = p1 + s1 * cPoint;
                    _v.o[2][0] = _cw ? p0 - s0 * cPoint : p0 + s0 * cPoint;
                    _v.o[2][1] = p1 + s1;
                    _v.o[3][0] = _cw ? p0 - s0 : p0 + s0;
                    _v.o[3][1] = p1 - s1 * cPoint;
                }
            };
            extendPrototype([
                DynamicPropertyContainer
            ], EllShapePropertyFactory);
            return EllShapePropertyFactory;
        }();
        var StarShapeProperty = function() {
            function StarShapePropertyFactory(elem, data) {
                this.v = shapePool.newElement();
                this.v.setPathData(true, 0);
                this.elem = elem;
                this.comp = elem.comp;
                this.data = data;
                this.frameId = -1;
                this.d = data.d;
                this.initDynamicPropertyContainer(elem);
                if (data.sy === 1) {
                    this.ir = PropertyFactory.getProp(elem, data.ir, 0, 0, this);
                    this.is = PropertyFactory.getProp(elem, data.is, 0, 0.01, this);
                    this.convertToPath = this.convertStarToPath;
                } else this.convertToPath = this.convertPolygonToPath;
                this.pt = PropertyFactory.getProp(elem, data.pt, 0, 0, this);
                this.p = PropertyFactory.getProp(elem, data.p, 1, 0, this);
                this.r = PropertyFactory.getProp(elem, data.r, 0, degToRads, this);
                this.or = PropertyFactory.getProp(elem, data.or, 0, 0, this);
                this.os = PropertyFactory.getProp(elem, data.os, 0, 0.01, this);
                this.localShapeCollection = shapeCollectionPool.newShapeCollection();
                this.localShapeCollection.addShape(this.v);
                this.paths = this.localShapeCollection;
                if (this.dynamicProperties.length) this.k = true;
                else {
                    this.k = false;
                    this.convertToPath();
                }
            }
            StarShapePropertyFactory.prototype = {
                reset: resetShape,
                getValue: function getValue() {
                    if (this.elem.globalData.frameId === this.frameId) return;
                    this.frameId = this.elem.globalData.frameId;
                    this.iterateDynamicProperties();
                    if (this._mdf) this.convertToPath();
                },
                convertStarToPath: function convertStarToPath() {
                    var numPts = Math.floor(this.pt.v) * 2;
                    var angle = Math.PI * 2 / numPts;
                    /* this.v.v.length = numPts;
                  this.v.i.length = numPts;
                  this.v.o.length = numPts; */ var longFlag = true;
                    var longRad = this.or.v;
                    var shortRad = this.ir.v;
                    var longRound = this.os.v;
                    var shortRound = this.is.v;
                    var longPerimSegment = 2 * Math.PI * longRad / (numPts * 2);
                    var shortPerimSegment = 2 * Math.PI * shortRad / (numPts * 2);
                    var i;
                    var rad;
                    var roundness;
                    var perimSegment;
                    var currentAng = -Math.PI / 2;
                    currentAng += this.r.v;
                    var dir = this.data.d === 3 ? -1 : 1;
                    this.v._length = 0;
                    for(i = 0; i < numPts; i += 1){
                        rad = longFlag ? longRad : shortRad;
                        roundness = longFlag ? longRound : shortRound;
                        perimSegment = longFlag ? longPerimSegment : shortPerimSegment;
                        var x = rad * Math.cos(currentAng);
                        var y = rad * Math.sin(currentAng);
                        var ox = x === 0 && y === 0 ? 0 : y / Math.sqrt(x * x + y * y);
                        var oy = x === 0 && y === 0 ? 0 : -x / Math.sqrt(x * x + y * y);
                        x += +this.p.v[0];
                        y += +this.p.v[1];
                        this.v.setTripleAt(x, y, x - ox * perimSegment * roundness * dir, y - oy * perimSegment * roundness * dir, x + ox * perimSegment * roundness * dir, y + oy * perimSegment * roundness * dir, i, true);
                        /* this.v.v[i] = [x,y];
                      this.v.i[i] = [x+ox*perimSegment*roundness*dir,y+oy*perimSegment*roundness*dir];
                      this.v.o[i] = [x-ox*perimSegment*roundness*dir,y-oy*perimSegment*roundness*dir];
                      this.v._length = numPts; */ longFlag = !longFlag;
                        currentAng += angle * dir;
                    }
                },
                convertPolygonToPath: function convertPolygonToPath() {
                    var numPts = Math.floor(this.pt.v);
                    var angle = Math.PI * 2 / numPts;
                    var rad = this.or.v;
                    var roundness = this.os.v;
                    var perimSegment = 2 * Math.PI * rad / (numPts * 4);
                    var i;
                    var currentAng = -Math.PI * 0.5;
                    var dir = this.data.d === 3 ? -1 : 1;
                    currentAng += this.r.v;
                    this.v._length = 0;
                    for(i = 0; i < numPts; i += 1){
                        var x = rad * Math.cos(currentAng);
                        var y = rad * Math.sin(currentAng);
                        var ox = x === 0 && y === 0 ? 0 : y / Math.sqrt(x * x + y * y);
                        var oy = x === 0 && y === 0 ? 0 : -x / Math.sqrt(x * x + y * y);
                        x += +this.p.v[0];
                        y += +this.p.v[1];
                        this.v.setTripleAt(x, y, x - ox * perimSegment * roundness * dir, y - oy * perimSegment * roundness * dir, x + ox * perimSegment * roundness * dir, y + oy * perimSegment * roundness * dir, i, true);
                        currentAng += angle * dir;
                    }
                    this.paths.length = 0;
                    this.paths[0] = this.v;
                }
            };
            extendPrototype([
                DynamicPropertyContainer
            ], StarShapePropertyFactory);
            return StarShapePropertyFactory;
        }();
        var RectShapeProperty = function() {
            function RectShapePropertyFactory(elem, data) {
                this.v = shapePool.newElement();
                this.v.c = true;
                this.localShapeCollection = shapeCollectionPool.newShapeCollection();
                this.localShapeCollection.addShape(this.v);
                this.paths = this.localShapeCollection;
                this.elem = elem;
                this.comp = elem.comp;
                this.frameId = -1;
                this.d = data.d;
                this.initDynamicPropertyContainer(elem);
                this.p = PropertyFactory.getProp(elem, data.p, 1, 0, this);
                this.s = PropertyFactory.getProp(elem, data.s, 1, 0, this);
                this.r = PropertyFactory.getProp(elem, data.r, 0, 0, this);
                if (this.dynamicProperties.length) this.k = true;
                else {
                    this.k = false;
                    this.convertRectToPath();
                }
            }
            RectShapePropertyFactory.prototype = {
                convertRectToPath: function convertRectToPath() {
                    var p0 = this.p.v[0];
                    var p1 = this.p.v[1];
                    var v0 = this.s.v[0] / 2;
                    var v1 = this.s.v[1] / 2;
                    var round = bmMin(v0, v1, this.r.v);
                    var cPoint = round * (1 - roundCorner);
                    this.v._length = 0;
                    if (this.d === 2 || this.d === 1) {
                        this.v.setTripleAt(p0 + v0, p1 - v1 + round, p0 + v0, p1 - v1 + round, p0 + v0, p1 - v1 + cPoint, 0, true);
                        this.v.setTripleAt(p0 + v0, p1 + v1 - round, p0 + v0, p1 + v1 - cPoint, p0 + v0, p1 + v1 - round, 1, true);
                        if (round !== 0) {
                            this.v.setTripleAt(p0 + v0 - round, p1 + v1, p0 + v0 - round, p1 + v1, p0 + v0 - cPoint, p1 + v1, 2, true);
                            this.v.setTripleAt(p0 - v0 + round, p1 + v1, p0 - v0 + cPoint, p1 + v1, p0 - v0 + round, p1 + v1, 3, true);
                            this.v.setTripleAt(p0 - v0, p1 + v1 - round, p0 - v0, p1 + v1 - round, p0 - v0, p1 + v1 - cPoint, 4, true);
                            this.v.setTripleAt(p0 - v0, p1 - v1 + round, p0 - v0, p1 - v1 + cPoint, p0 - v0, p1 - v1 + round, 5, true);
                            this.v.setTripleAt(p0 - v0 + round, p1 - v1, p0 - v0 + round, p1 - v1, p0 - v0 + cPoint, p1 - v1, 6, true);
                            this.v.setTripleAt(p0 + v0 - round, p1 - v1, p0 + v0 - cPoint, p1 - v1, p0 + v0 - round, p1 - v1, 7, true);
                        } else {
                            this.v.setTripleAt(p0 - v0, p1 + v1, p0 - v0 + cPoint, p1 + v1, p0 - v0, p1 + v1, 2);
                            this.v.setTripleAt(p0 - v0, p1 - v1, p0 - v0, p1 - v1 + cPoint, p0 - v0, p1 - v1, 3);
                        }
                    } else {
                        this.v.setTripleAt(p0 + v0, p1 - v1 + round, p0 + v0, p1 - v1 + cPoint, p0 + v0, p1 - v1 + round, 0, true);
                        if (round !== 0) {
                            this.v.setTripleAt(p0 + v0 - round, p1 - v1, p0 + v0 - round, p1 - v1, p0 + v0 - cPoint, p1 - v1, 1, true);
                            this.v.setTripleAt(p0 - v0 + round, p1 - v1, p0 - v0 + cPoint, p1 - v1, p0 - v0 + round, p1 - v1, 2, true);
                            this.v.setTripleAt(p0 - v0, p1 - v1 + round, p0 - v0, p1 - v1 + round, p0 - v0, p1 - v1 + cPoint, 3, true);
                            this.v.setTripleAt(p0 - v0, p1 + v1 - round, p0 - v0, p1 + v1 - cPoint, p0 - v0, p1 + v1 - round, 4, true);
                            this.v.setTripleAt(p0 - v0 + round, p1 + v1, p0 - v0 + round, p1 + v1, p0 - v0 + cPoint, p1 + v1, 5, true);
                            this.v.setTripleAt(p0 + v0 - round, p1 + v1, p0 + v0 - cPoint, p1 + v1, p0 + v0 - round, p1 + v1, 6, true);
                            this.v.setTripleAt(p0 + v0, p1 + v1 - round, p0 + v0, p1 + v1 - round, p0 + v0, p1 + v1 - cPoint, 7, true);
                        } else {
                            this.v.setTripleAt(p0 - v0, p1 - v1, p0 - v0 + cPoint, p1 - v1, p0 - v0, p1 - v1, 1, true);
                            this.v.setTripleAt(p0 - v0, p1 + v1, p0 - v0, p1 + v1 - cPoint, p0 - v0, p1 + v1, 2, true);
                            this.v.setTripleAt(p0 + v0, p1 + v1, p0 + v0 - cPoint, p1 + v1, p0 + v0, p1 + v1, 3, true);
                        }
                    }
                },
                getValue: function getValue() {
                    if (this.elem.globalData.frameId === this.frameId) return;
                    this.frameId = this.elem.globalData.frameId;
                    this.iterateDynamicProperties();
                    if (this._mdf) this.convertRectToPath();
                },
                reset: resetShape
            };
            extendPrototype([
                DynamicPropertyContainer
            ], RectShapePropertyFactory);
            return RectShapePropertyFactory;
        }();
        function getShapeProp(elem, data, type) {
            var prop;
            if (type === 3 || type === 4) {
                var dataProp = type === 3 ? data.pt : data.ks;
                var keys = dataProp.k;
                if (keys.length) prop = new KeyframedShapeProperty(elem, data, type);
                else prop = new ShapeProperty(elem, data, type);
            } else if (type === 5) prop = new RectShapeProperty(elem, data);
            else if (type === 6) prop = new EllShapeProperty(elem, data);
            else if (type === 7) prop = new StarShapeProperty(elem, data);
            if (prop.k) elem.addDynamicProperty(prop);
            return prop;
        }
        function getConstructorFunction() {
            return ShapeProperty;
        }
        function getKeyframedConstructorFunction() {
            return KeyframedShapeProperty;
        }
        var ob = {};
        ob.getShapeProp = getShapeProp;
        ob.getConstructorFunction = getConstructorFunction;
        ob.getKeyframedConstructorFunction = getKeyframedConstructorFunction;
        return ob;
    }();
    /*!
   Transformation Matrix v2.0
   (c) Epistemex 2014-2015
   www.epistemex.com
   By Ken Fyrstenberg
   Contributions by leeoniya.
   License: MIT, header required.
   */ /**
   * 2D transformation matrix object initialized with identity matrix.
   *
   * The matrix can synchronize a canvas context by supplying the context
   * as an argument, or later apply current absolute transform to an
   * existing context.
   *
   * All values are handled as floating point values.
   *
   * @param {CanvasRenderingContext2D} [context] - Optional context to sync with Matrix
   * @prop {number} a - scale x
   * @prop {number} b - shear y
   * @prop {number} c - shear x
   * @prop {number} d - scale y
   * @prop {number} e - translate x
   * @prop {number} f - translate y
   * @prop {CanvasRenderingContext2D|null} [context=null] - set or get current canvas context
   * @constructor
   */ var Matrix = function() {
        var _cos = Math.cos;
        var _sin = Math.sin;
        var _tan = Math.tan;
        var _rnd = Math.round;
        function reset() {
            this.props[0] = 1;
            this.props[1] = 0;
            this.props[2] = 0;
            this.props[3] = 0;
            this.props[4] = 0;
            this.props[5] = 1;
            this.props[6] = 0;
            this.props[7] = 0;
            this.props[8] = 0;
            this.props[9] = 0;
            this.props[10] = 1;
            this.props[11] = 0;
            this.props[12] = 0;
            this.props[13] = 0;
            this.props[14] = 0;
            this.props[15] = 1;
            return this;
        }
        function rotate(angle) {
            if (angle === 0) return this;
            var mCos = _cos(angle);
            var mSin = _sin(angle);
            return this._t(mCos, -mSin, 0, 0, mSin, mCos, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
        }
        function rotateX(angle) {
            if (angle === 0) return this;
            var mCos = _cos(angle);
            var mSin = _sin(angle);
            return this._t(1, 0, 0, 0, 0, mCos, -mSin, 0, 0, mSin, mCos, 0, 0, 0, 0, 1);
        }
        function rotateY(angle) {
            if (angle === 0) return this;
            var mCos = _cos(angle);
            var mSin = _sin(angle);
            return this._t(mCos, 0, mSin, 0, 0, 1, 0, 0, -mSin, 0, mCos, 0, 0, 0, 0, 1);
        }
        function rotateZ(angle) {
            if (angle === 0) return this;
            var mCos = _cos(angle);
            var mSin = _sin(angle);
            return this._t(mCos, -mSin, 0, 0, mSin, mCos, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
        }
        function shear(sx, sy) {
            return this._t(1, sy, sx, 1, 0, 0);
        }
        function skew(ax, ay) {
            return this.shear(_tan(ax), _tan(ay));
        }
        function skewFromAxis(ax, angle) {
            var mCos = _cos(angle);
            var mSin = _sin(angle);
            return this._t(mCos, mSin, 0, 0, -mSin, mCos, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)._t(1, 0, 0, 0, _tan(ax), 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)._t(mCos, -mSin, 0, 0, mSin, mCos, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1); // return this._t(mCos, mSin, -mSin, mCos, 0, 0)._t(1, 0, _tan(ax), 1, 0, 0)._t(mCos, -mSin, mSin, mCos, 0, 0);
        }
        function scale(sx, sy, sz) {
            if (!sz && sz !== 0) sz = 1;
            if (sx === 1 && sy === 1 && sz === 1) return this;
            return this._t(sx, 0, 0, 0, 0, sy, 0, 0, 0, 0, sz, 0, 0, 0, 0, 1);
        }
        function setTransform(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
            this.props[0] = a;
            this.props[1] = b;
            this.props[2] = c;
            this.props[3] = d;
            this.props[4] = e;
            this.props[5] = f;
            this.props[6] = g;
            this.props[7] = h;
            this.props[8] = i;
            this.props[9] = j;
            this.props[10] = k;
            this.props[11] = l;
            this.props[12] = m;
            this.props[13] = n;
            this.props[14] = o;
            this.props[15] = p;
            return this;
        }
        function translate(tx, ty, tz) {
            tz = tz || 0;
            if (tx !== 0 || ty !== 0 || tz !== 0) return this._t(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, tx, ty, tz, 1);
            return this;
        }
        function transform(a2, b2, c2, d2, e2, f2, g2, h2, i2, j2, k2, l2, m2, n2, o2, p2) {
            var _p = this.props;
            if (a2 === 1 && b2 === 0 && c2 === 0 && d2 === 0 && e2 === 0 && f2 === 1 && g2 === 0 && h2 === 0 && i2 === 0 && j2 === 0 && k2 === 1 && l2 === 0) {
                // NOTE: commenting this condition because TurboFan deoptimizes code when present
                // if(m2 !== 0 || n2 !== 0 || o2 !== 0){
                _p[12] = _p[12] * a2 + _p[15] * m2;
                _p[13] = _p[13] * f2 + _p[15] * n2;
                _p[14] = _p[14] * k2 + _p[15] * o2;
                _p[15] *= p2; // }
                this._identityCalculated = false;
                return this;
            }
            var a1 = _p[0];
            var b1 = _p[1];
            var c1 = _p[2];
            var d1 = _p[3];
            var e1 = _p[4];
            var f1 = _p[5];
            var g1 = _p[6];
            var h1 = _p[7];
            var i1 = _p[8];
            var j1 = _p[9];
            var k1 = _p[10];
            var l1 = _p[11];
            var m1 = _p[12];
            var n1 = _p[13];
            var o1 = _p[14];
            var p1 = _p[15];
            /* matrix order (canvas compatible):
           * ace
           * bdf
           * 001
           */ _p[0] = a1 * a2 + b1 * e2 + c1 * i2 + d1 * m2;
            _p[1] = a1 * b2 + b1 * f2 + c1 * j2 + d1 * n2;
            _p[2] = a1 * c2 + b1 * g2 + c1 * k2 + d1 * o2;
            _p[3] = a1 * d2 + b1 * h2 + c1 * l2 + d1 * p2;
            _p[4] = e1 * a2 + f1 * e2 + g1 * i2 + h1 * m2;
            _p[5] = e1 * b2 + f1 * f2 + g1 * j2 + h1 * n2;
            _p[6] = e1 * c2 + f1 * g2 + g1 * k2 + h1 * o2;
            _p[7] = e1 * d2 + f1 * h2 + g1 * l2 + h1 * p2;
            _p[8] = i1 * a2 + j1 * e2 + k1 * i2 + l1 * m2;
            _p[9] = i1 * b2 + j1 * f2 + k1 * j2 + l1 * n2;
            _p[10] = i1 * c2 + j1 * g2 + k1 * k2 + l1 * o2;
            _p[11] = i1 * d2 + j1 * h2 + k1 * l2 + l1 * p2;
            _p[12] = m1 * a2 + n1 * e2 + o1 * i2 + p1 * m2;
            _p[13] = m1 * b2 + n1 * f2 + o1 * j2 + p1 * n2;
            _p[14] = m1 * c2 + n1 * g2 + o1 * k2 + p1 * o2;
            _p[15] = m1 * d2 + n1 * h2 + o1 * l2 + p1 * p2;
            this._identityCalculated = false;
            return this;
        }
        function isIdentity() {
            if (!this._identityCalculated) {
                this._identity = !(this.props[0] !== 1 || this.props[1] !== 0 || this.props[2] !== 0 || this.props[3] !== 0 || this.props[4] !== 0 || this.props[5] !== 1 || this.props[6] !== 0 || this.props[7] !== 0 || this.props[8] !== 0 || this.props[9] !== 0 || this.props[10] !== 1 || this.props[11] !== 0 || this.props[12] !== 0 || this.props[13] !== 0 || this.props[14] !== 0 || this.props[15] !== 1);
                this._identityCalculated = true;
            }
            return this._identity;
        }
        function equals(matr) {
            var i = 0;
            while(i < 16){
                if (matr.props[i] !== this.props[i]) return false;
                i += 1;
            }
            return true;
        }
        function clone(matr) {
            var i;
            for(i = 0; i < 16; i += 1)matr.props[i] = this.props[i];
            return matr;
        }
        function cloneFromProps(props) {
            var i;
            for(i = 0; i < 16; i += 1)this.props[i] = props[i];
        }
        function applyToPoint(x, y, z) {
            return {
                x: x * this.props[0] + y * this.props[4] + z * this.props[8] + this.props[12],
                y: x * this.props[1] + y * this.props[5] + z * this.props[9] + this.props[13],
                z: x * this.props[2] + y * this.props[6] + z * this.props[10] + this.props[14]
            };
        /* return {
           x: x * me.a + y * me.c + me.e,
           y: x * me.b + y * me.d + me.f
           }; */ }
        function applyToX(x, y, z) {
            return x * this.props[0] + y * this.props[4] + z * this.props[8] + this.props[12];
        }
        function applyToY(x, y, z) {
            return x * this.props[1] + y * this.props[5] + z * this.props[9] + this.props[13];
        }
        function applyToZ(x, y, z) {
            return x * this.props[2] + y * this.props[6] + z * this.props[10] + this.props[14];
        }
        function getInverseMatrix() {
            var determinant = this.props[0] * this.props[5] - this.props[1] * this.props[4];
            var a = this.props[5] / determinant;
            var b = -this.props[1] / determinant;
            var c = -this.props[4] / determinant;
            var d = this.props[0] / determinant;
            var e = (this.props[4] * this.props[13] - this.props[5] * this.props[12]) / determinant;
            var f = -(this.props[0] * this.props[13] - this.props[1] * this.props[12]) / determinant;
            var inverseMatrix = new Matrix();
            inverseMatrix.props[0] = a;
            inverseMatrix.props[1] = b;
            inverseMatrix.props[4] = c;
            inverseMatrix.props[5] = d;
            inverseMatrix.props[12] = e;
            inverseMatrix.props[13] = f;
            return inverseMatrix;
        }
        function inversePoint(pt) {
            var inverseMatrix = this.getInverseMatrix();
            return inverseMatrix.applyToPointArray(pt[0], pt[1], pt[2] || 0);
        }
        function inversePoints(pts) {
            var i;
            var len = pts.length;
            var retPts = [];
            for(i = 0; i < len; i += 1)retPts[i] = inversePoint(pts[i]);
            return retPts;
        }
        function applyToTriplePoints(pt1, pt2, pt3) {
            var arr = createTypedArray("float32", 6);
            if (this.isIdentity()) {
                arr[0] = pt1[0];
                arr[1] = pt1[1];
                arr[2] = pt2[0];
                arr[3] = pt2[1];
                arr[4] = pt3[0];
                arr[5] = pt3[1];
            } else {
                var p0 = this.props[0];
                var p1 = this.props[1];
                var p4 = this.props[4];
                var p5 = this.props[5];
                var p12 = this.props[12];
                var p13 = this.props[13];
                arr[0] = pt1[0] * p0 + pt1[1] * p4 + p12;
                arr[1] = pt1[0] * p1 + pt1[1] * p5 + p13;
                arr[2] = pt2[0] * p0 + pt2[1] * p4 + p12;
                arr[3] = pt2[0] * p1 + pt2[1] * p5 + p13;
                arr[4] = pt3[0] * p0 + pt3[1] * p4 + p12;
                arr[5] = pt3[0] * p1 + pt3[1] * p5 + p13;
            }
            return arr;
        }
        function applyToPointArray(x, y, z) {
            var arr;
            if (this.isIdentity()) arr = [
                x,
                y,
                z
            ];
            else arr = [
                x * this.props[0] + y * this.props[4] + z * this.props[8] + this.props[12],
                x * this.props[1] + y * this.props[5] + z * this.props[9] + this.props[13],
                x * this.props[2] + y * this.props[6] + z * this.props[10] + this.props[14]
            ];
            return arr;
        }
        function applyToPointStringified(x, y) {
            if (this.isIdentity()) return x + "," + y;
            var _p = this.props;
            return Math.round((x * _p[0] + y * _p[4] + _p[12]) * 100) / 100 + "," + Math.round((x * _p[1] + y * _p[5] + _p[13]) * 100) / 100;
        }
        function toCSS() {
            // Doesn't make much sense to add this optimization. If it is an identity matrix, it's very likely this will get called only once since it won't be keyframed.
            /* if(this.isIdentity()) {
              return '';
          } */ var i = 0;
            var props = this.props;
            var cssValue = "matrix3d(";
            var v = 10000;
            while(i < 16){
                cssValue += _rnd(props[i] * v) / v;
                cssValue += i === 15 ? ")" : ",";
                i += 1;
            }
            return cssValue;
        }
        function roundMatrixProperty(val) {
            var v = 10000;
            if (val < 0.000001 && val > 0 || val > -0.000001 && val < 0) return _rnd(val * v) / v;
            return val;
        }
        function to2dCSS() {
            // Doesn't make much sense to add this optimization. If it is an identity matrix, it's very likely this will get called only once since it won't be keyframed.
            /* if(this.isIdentity()) {
              return '';
          } */ var props = this.props;
            var _a = roundMatrixProperty(props[0]);
            var _b = roundMatrixProperty(props[1]);
            var _c = roundMatrixProperty(props[4]);
            var _d = roundMatrixProperty(props[5]);
            var _e = roundMatrixProperty(props[12]);
            var _f = roundMatrixProperty(props[13]);
            return "matrix(" + _a + "," + _b + "," + _c + "," + _d + "," + _e + "," + _f + ")";
        }
        return function() {
            this.reset = reset;
            this.rotate = rotate;
            this.rotateX = rotateX;
            this.rotateY = rotateY;
            this.rotateZ = rotateZ;
            this.skew = skew;
            this.skewFromAxis = skewFromAxis;
            this.shear = shear;
            this.scale = scale;
            this.setTransform = setTransform;
            this.translate = translate;
            this.transform = transform;
            this.applyToPoint = applyToPoint;
            this.applyToX = applyToX;
            this.applyToY = applyToY;
            this.applyToZ = applyToZ;
            this.applyToPointArray = applyToPointArray;
            this.applyToTriplePoints = applyToTriplePoints;
            this.applyToPointStringified = applyToPointStringified;
            this.toCSS = toCSS;
            this.to2dCSS = to2dCSS;
            this.clone = clone;
            this.cloneFromProps = cloneFromProps;
            this.equals = equals;
            this.inversePoints = inversePoints;
            this.inversePoint = inversePoint;
            this.getInverseMatrix = getInverseMatrix;
            this._t = this.transform;
            this.isIdentity = isIdentity;
            this._identity = true;
            this._identityCalculated = false;
            this.props = createTypedArray("float32", 16);
            this.reset();
        };
    }();
    function _typeof$3(obj) {
        "@babel/helpers - typeof";
        if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") _typeof$3 = function _typeof(obj) {
            return typeof obj;
        };
        else _typeof$3 = function _typeof(obj) {
            return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
        return _typeof$3(obj);
    }
    var lottie = {};
    var standalone = "__[STANDALONE]__";
    var animationData = "__[ANIMATIONDATA]__";
    var renderer = "";
    function setLocation(href) {
        setLocationHref(href);
    }
    function searchAnimations() {
        if (standalone === true) animationManager.searchAnimations(animationData, standalone, renderer);
        else animationManager.searchAnimations();
    }
    function setSubframeRendering(flag) {
        setSubframeEnabled(flag);
    }
    function setPrefix(prefix) {
        setIdPrefix(prefix);
    }
    function loadAnimation(params) {
        if (standalone === true) params.animationData = JSON.parse(animationData);
        return animationManager.loadAnimation(params);
    }
    function setQuality(value) {
        if (typeof value === "string") switch(value){
            case "high":
                setDefaultCurveSegments(200);
                break;
            default:
            case "medium":
                setDefaultCurveSegments(50);
                break;
            case "low":
                setDefaultCurveSegments(10);
                break;
        }
        else if (!isNaN(value) && value > 1) setDefaultCurveSegments(value);
        if (getDefaultCurveSegments() >= 50) roundValues(false);
        else roundValues(true);
    }
    function inBrowser() {
        return typeof navigator !== "undefined";
    }
    function installPlugin(type, plugin) {
        if (type === "expressions") setExpressionsPlugin(plugin);
    }
    function getFactory(name) {
        switch(name){
            case "propertyFactory":
                return PropertyFactory;
            case "shapePropertyFactory":
                return ShapePropertyFactory;
            case "matrix":
                return Matrix;
            default:
                return null;
        }
    }
    lottie.play = animationManager.play;
    lottie.pause = animationManager.pause;
    lottie.setLocationHref = setLocation;
    lottie.togglePause = animationManager.togglePause;
    lottie.setSpeed = animationManager.setSpeed;
    lottie.setDirection = animationManager.setDirection;
    lottie.stop = animationManager.stop;
    lottie.searchAnimations = searchAnimations;
    lottie.registerAnimation = animationManager.registerAnimation;
    lottie.loadAnimation = loadAnimation;
    lottie.setSubframeRendering = setSubframeRendering;
    lottie.resize = animationManager.resize; // lottie.start = start;
    lottie.goToAndStop = animationManager.goToAndStop;
    lottie.destroy = animationManager.destroy;
    lottie.setQuality = setQuality;
    lottie.inBrowser = inBrowser;
    lottie.installPlugin = installPlugin;
    lottie.freeze = animationManager.freeze;
    lottie.unfreeze = animationManager.unfreeze;
    lottie.setVolume = animationManager.setVolume;
    lottie.mute = animationManager.mute;
    lottie.unmute = animationManager.unmute;
    lottie.getRegisteredAnimations = animationManager.getRegisteredAnimations;
    lottie.useWebWorker = setWebWorker;
    lottie.setIDPrefix = setPrefix;
    lottie.__getFactory = getFactory;
    lottie.version = "5.10.2";
    function checkReady() {
        if (document.readyState === "complete") {
            clearInterval(readyStateCheckInterval);
            searchAnimations();
        }
    }
    function getQueryVariable(variable) {
        var vars = queryString.split("&");
        for(var i = 0; i < vars.length; i += 1){
            var pair = vars[i].split("=");
            if (decodeURIComponent(pair[0]) == variable) // eslint-disable-line eqeqeq
            return decodeURIComponent(pair[1]);
        }
        return null;
    }
    var queryString = "";
    if (standalone) {
        var scripts = document.getElementsByTagName("script");
        var index = scripts.length - 1;
        var myScript = scripts[index] || {
            src: ""
        };
        queryString = myScript.src ? myScript.src.replace(/^[^\?]+\??/, "") : ""; // eslint-disable-line no-useless-escape
        renderer = getQueryVariable("renderer");
    }
    var readyStateCheckInterval = setInterval(checkReady, 100); // this adds bodymovin to the window object for backwards compatibility
    try {
        if (!(_typeof$3(exports) === "object" && true) && !(typeof define === "function" && define.amd // eslint-disable-line no-undef
        )) window.bodymovin = lottie;
    } catch (err) {}
    var ShapeModifiers = function() {
        var ob = {};
        var modifiers = {};
        ob.registerModifier = registerModifier;
        ob.getModifier = getModifier;
        function registerModifier(nm, factory) {
            if (!modifiers[nm]) modifiers[nm] = factory;
        }
        function getModifier(nm, elem, data) {
            return new modifiers[nm](elem, data);
        }
        return ob;
    }();
    function ShapeModifier() {}
    ShapeModifier.prototype.initModifierProperties = function() {};
    ShapeModifier.prototype.addShapeToModifier = function() {};
    ShapeModifier.prototype.addShape = function(data) {
        if (!this.closed) {
            // Adding shape to dynamic properties. It covers the case where a shape has no effects applied, to reset it's _mdf state on every tick.
            data.sh.container.addDynamicProperty(data.sh);
            var shapeData = {
                shape: data.sh,
                data: data,
                localShapeCollection: shapeCollectionPool.newShapeCollection()
            };
            this.shapes.push(shapeData);
            this.addShapeToModifier(shapeData);
            if (this._isAnimated) data.setAsAnimated();
        }
    };
    ShapeModifier.prototype.init = function(elem, data) {
        this.shapes = [];
        this.elem = elem;
        this.initDynamicPropertyContainer(elem);
        this.initModifierProperties(elem, data);
        this.frameId = initialDefaultFrame;
        this.closed = false;
        this.k = false;
        if (this.dynamicProperties.length) this.k = true;
        else this.getValue(true);
    };
    ShapeModifier.prototype.processKeys = function() {
        if (this.elem.globalData.frameId === this.frameId) return;
        this.frameId = this.elem.globalData.frameId;
        this.iterateDynamicProperties();
    };
    extendPrototype([
        DynamicPropertyContainer
    ], ShapeModifier);
    function TrimModifier() {}
    extendPrototype([
        ShapeModifier
    ], TrimModifier);
    TrimModifier.prototype.initModifierProperties = function(elem, data) {
        this.s = PropertyFactory.getProp(elem, data.s, 0, 0.01, this);
        this.e = PropertyFactory.getProp(elem, data.e, 0, 0.01, this);
        this.o = PropertyFactory.getProp(elem, data.o, 0, 0, this);
        this.sValue = 0;
        this.eValue = 0;
        this.getValue = this.processKeys;
        this.m = data.m;
        this._isAnimated = !!this.s.effectsSequence.length || !!this.e.effectsSequence.length || !!this.o.effectsSequence.length;
    };
    TrimModifier.prototype.addShapeToModifier = function(shapeData) {
        shapeData.pathsData = [];
    };
    TrimModifier.prototype.calculateShapeEdges = function(s, e, shapeLength, addedLength, totalModifierLength) {
        var segments = [];
        if (e <= 1) segments.push({
            s: s,
            e: e
        });
        else if (s >= 1) segments.push({
            s: s - 1,
            e: e - 1
        });
        else {
            segments.push({
                s: s,
                e: 1
            });
            segments.push({
                s: 0,
                e: e - 1
            });
        }
        var shapeSegments = [];
        var i;
        var len = segments.length;
        var segmentOb;
        for(i = 0; i < len; i += 1){
            segmentOb = segments[i];
            if (!(segmentOb.e * totalModifierLength < addedLength || segmentOb.s * totalModifierLength > addedLength + shapeLength)) {
                var shapeS;
                var shapeE;
                if (segmentOb.s * totalModifierLength <= addedLength) shapeS = 0;
                else shapeS = (segmentOb.s * totalModifierLength - addedLength) / shapeLength;
                if (segmentOb.e * totalModifierLength >= addedLength + shapeLength) shapeE = 1;
                else shapeE = (segmentOb.e * totalModifierLength - addedLength) / shapeLength;
                shapeSegments.push([
                    shapeS,
                    shapeE
                ]);
            }
        }
        if (!shapeSegments.length) shapeSegments.push([
            0,
            0
        ]);
        return shapeSegments;
    };
    TrimModifier.prototype.releasePathsData = function(pathsData) {
        var i;
        var len = pathsData.length;
        for(i = 0; i < len; i += 1)segmentsLengthPool.release(pathsData[i]);
        pathsData.length = 0;
        return pathsData;
    };
    TrimModifier.prototype.processShapes = function(_isFirstFrame) {
        var s;
        var e;
        if (this._mdf || _isFirstFrame) {
            var o = this.o.v % 360 / 360;
            if (o < 0) o += 1;
            if (this.s.v > 1) s = 1 + o;
            else if (this.s.v < 0) s = 0 + o;
            else s = this.s.v + o;
            if (this.e.v > 1) e = 1 + o;
            else if (this.e.v < 0) e = 0 + o;
            else e = this.e.v + o;
            if (s > e) {
                var _s = s;
                s = e;
                e = _s;
            }
            s = Math.round(s * 10000) * 0.0001;
            e = Math.round(e * 10000) * 0.0001;
            this.sValue = s;
            this.eValue = e;
        } else {
            s = this.sValue;
            e = this.eValue;
        }
        var shapePaths;
        var i;
        var len = this.shapes.length;
        var j;
        var jLen;
        var pathsData;
        var pathData;
        var totalShapeLength;
        var totalModifierLength = 0;
        if (e === s) for(i = 0; i < len; i += 1){
            this.shapes[i].localShapeCollection.releaseShapes();
            this.shapes[i].shape._mdf = true;
            this.shapes[i].shape.paths = this.shapes[i].localShapeCollection;
            if (this._mdf) this.shapes[i].pathsData.length = 0;
        }
        else if (!(e === 1 && s === 0 || e === 0 && s === 1)) {
            var segments = [];
            var shapeData;
            var localShapeCollection;
            for(i = 0; i < len; i += 1){
                shapeData = this.shapes[i]; // if shape hasn't changed and trim properties haven't changed, cached previous path can be used
                if (!shapeData.shape._mdf && !this._mdf && !_isFirstFrame && this.m !== 2) shapeData.shape.paths = shapeData.localShapeCollection;
                else {
                    shapePaths = shapeData.shape.paths;
                    jLen = shapePaths._length;
                    totalShapeLength = 0;
                    if (!shapeData.shape._mdf && shapeData.pathsData.length) totalShapeLength = shapeData.totalShapeLength;
                    else {
                        pathsData = this.releasePathsData(shapeData.pathsData);
                        for(j = 0; j < jLen; j += 1){
                            pathData = bez.getSegmentsLength(shapePaths.shapes[j]);
                            pathsData.push(pathData);
                            totalShapeLength += pathData.totalLength;
                        }
                        shapeData.totalShapeLength = totalShapeLength;
                        shapeData.pathsData = pathsData;
                    }
                    totalModifierLength += totalShapeLength;
                    shapeData.shape._mdf = true;
                }
            }
            var shapeS = s;
            var shapeE = e;
            var addedLength = 0;
            var edges;
            for(i = len - 1; i >= 0; i -= 1){
                shapeData = this.shapes[i];
                if (shapeData.shape._mdf) {
                    localShapeCollection = shapeData.localShapeCollection;
                    localShapeCollection.releaseShapes(); // if m === 2 means paths are trimmed individually so edges need to be found for this specific shape relative to whoel group
                    if (this.m === 2 && len > 1) {
                        edges = this.calculateShapeEdges(s, e, shapeData.totalShapeLength, addedLength, totalModifierLength);
                        addedLength += shapeData.totalShapeLength;
                    } else edges = [
                        [
                            shapeS,
                            shapeE
                        ]
                    ];
                    jLen = edges.length;
                    for(j = 0; j < jLen; j += 1){
                        shapeS = edges[j][0];
                        shapeE = edges[j][1];
                        segments.length = 0;
                        if (shapeE <= 1) segments.push({
                            s: shapeData.totalShapeLength * shapeS,
                            e: shapeData.totalShapeLength * shapeE
                        });
                        else if (shapeS >= 1) segments.push({
                            s: shapeData.totalShapeLength * (shapeS - 1),
                            e: shapeData.totalShapeLength * (shapeE - 1)
                        });
                        else {
                            segments.push({
                                s: shapeData.totalShapeLength * shapeS,
                                e: shapeData.totalShapeLength
                            });
                            segments.push({
                                s: 0,
                                e: shapeData.totalShapeLength * (shapeE - 1)
                            });
                        }
                        var newShapesData = this.addShapes(shapeData, segments[0]);
                        if (segments[0].s !== segments[0].e) {
                            if (segments.length > 1) {
                                var lastShapeInCollection = shapeData.shape.paths.shapes[shapeData.shape.paths._length - 1];
                                if (lastShapeInCollection.c) {
                                    var lastShape = newShapesData.pop();
                                    this.addPaths(newShapesData, localShapeCollection);
                                    newShapesData = this.addShapes(shapeData, segments[1], lastShape);
                                } else {
                                    this.addPaths(newShapesData, localShapeCollection);
                                    newShapesData = this.addShapes(shapeData, segments[1]);
                                }
                            }
                            this.addPaths(newShapesData, localShapeCollection);
                        }
                    }
                    shapeData.shape.paths = localShapeCollection;
                }
            }
        } else if (this._mdf) for(i = 0; i < len; i += 1){
            // Releasign Trim Cached paths data when no trim applied in case shapes are modified inbetween.
            // Don't remove this even if it's losing cached info.
            this.shapes[i].pathsData.length = 0;
            this.shapes[i].shape._mdf = true;
        }
    };
    TrimModifier.prototype.addPaths = function(newPaths, localShapeCollection) {
        var i;
        var len = newPaths.length;
        for(i = 0; i < len; i += 1)localShapeCollection.addShape(newPaths[i]);
    };
    TrimModifier.prototype.addSegment = function(pt1, pt2, pt3, pt4, shapePath, pos, newShape) {
        shapePath.setXYAt(pt2[0], pt2[1], "o", pos);
        shapePath.setXYAt(pt3[0], pt3[1], "i", pos + 1);
        if (newShape) shapePath.setXYAt(pt1[0], pt1[1], "v", pos);
        shapePath.setXYAt(pt4[0], pt4[1], "v", pos + 1);
    };
    TrimModifier.prototype.addSegmentFromArray = function(points, shapePath, pos, newShape) {
        shapePath.setXYAt(points[1], points[5], "o", pos);
        shapePath.setXYAt(points[2], points[6], "i", pos + 1);
        if (newShape) shapePath.setXYAt(points[0], points[4], "v", pos);
        shapePath.setXYAt(points[3], points[7], "v", pos + 1);
    };
    TrimModifier.prototype.addShapes = function(shapeData, shapeSegment, shapePath) {
        var pathsData = shapeData.pathsData;
        var shapePaths = shapeData.shape.paths.shapes;
        var i;
        var len = shapeData.shape.paths._length;
        var j;
        var jLen;
        var addedLength = 0;
        var currentLengthData;
        var segmentCount;
        var lengths;
        var segment;
        var shapes = [];
        var initPos;
        var newShape = true;
        if (!shapePath) {
            shapePath = shapePool.newElement();
            segmentCount = 0;
            initPos = 0;
        } else {
            segmentCount = shapePath._length;
            initPos = shapePath._length;
        }
        shapes.push(shapePath);
        for(i = 0; i < len; i += 1){
            lengths = pathsData[i].lengths;
            shapePath.c = shapePaths[i].c;
            jLen = shapePaths[i].c ? lengths.length : lengths.length + 1;
            for(j = 1; j < jLen; j += 1){
                currentLengthData = lengths[j - 1];
                if (addedLength + currentLengthData.addedLength < shapeSegment.s) {
                    addedLength += currentLengthData.addedLength;
                    shapePath.c = false;
                } else if (addedLength > shapeSegment.e) {
                    shapePath.c = false;
                    break;
                } else {
                    if (shapeSegment.s <= addedLength && shapeSegment.e >= addedLength + currentLengthData.addedLength) {
                        this.addSegment(shapePaths[i].v[j - 1], shapePaths[i].o[j - 1], shapePaths[i].i[j], shapePaths[i].v[j], shapePath, segmentCount, newShape);
                        newShape = false;
                    } else {
                        segment = bez.getNewSegment(shapePaths[i].v[j - 1], shapePaths[i].v[j], shapePaths[i].o[j - 1], shapePaths[i].i[j], (shapeSegment.s - addedLength) / currentLengthData.addedLength, (shapeSegment.e - addedLength) / currentLengthData.addedLength, lengths[j - 1]);
                        this.addSegmentFromArray(segment, shapePath, segmentCount, newShape); // this.addSegment(segment.pt1, segment.pt3, segment.pt4, segment.pt2, shapePath, segmentCount, newShape);
                        newShape = false;
                        shapePath.c = false;
                    }
                    addedLength += currentLengthData.addedLength;
                    segmentCount += 1;
                }
            }
            if (shapePaths[i].c && lengths.length) {
                currentLengthData = lengths[j - 1];
                if (addedLength <= shapeSegment.e) {
                    var segmentLength = lengths[j - 1].addedLength;
                    if (shapeSegment.s <= addedLength && shapeSegment.e >= addedLength + segmentLength) {
                        this.addSegment(shapePaths[i].v[j - 1], shapePaths[i].o[j - 1], shapePaths[i].i[0], shapePaths[i].v[0], shapePath, segmentCount, newShape);
                        newShape = false;
                    } else {
                        segment = bez.getNewSegment(shapePaths[i].v[j - 1], shapePaths[i].v[0], shapePaths[i].o[j - 1], shapePaths[i].i[0], (shapeSegment.s - addedLength) / segmentLength, (shapeSegment.e - addedLength) / segmentLength, lengths[j - 1]);
                        this.addSegmentFromArray(segment, shapePath, segmentCount, newShape); // this.addSegment(segment.pt1, segment.pt3, segment.pt4, segment.pt2, shapePath, segmentCount, newShape);
                        newShape = false;
                        shapePath.c = false;
                    }
                } else shapePath.c = false;
                addedLength += currentLengthData.addedLength;
                segmentCount += 1;
            }
            if (shapePath._length) {
                shapePath.setXYAt(shapePath.v[initPos][0], shapePath.v[initPos][1], "i", initPos);
                shapePath.setXYAt(shapePath.v[shapePath._length - 1][0], shapePath.v[shapePath._length - 1][1], "o", shapePath._length - 1);
            }
            if (addedLength > shapeSegment.e) break;
            if (i < len - 1) {
                shapePath = shapePool.newElement();
                newShape = true;
                shapes.push(shapePath);
                segmentCount = 0;
            }
        }
        return shapes;
    };
    function PuckerAndBloatModifier() {}
    extendPrototype([
        ShapeModifier
    ], PuckerAndBloatModifier);
    PuckerAndBloatModifier.prototype.initModifierProperties = function(elem, data) {
        this.getValue = this.processKeys;
        this.amount = PropertyFactory.getProp(elem, data.a, 0, null, this);
        this._isAnimated = !!this.amount.effectsSequence.length;
    };
    PuckerAndBloatModifier.prototype.processPath = function(path, amount) {
        var percent = amount / 100;
        var centerPoint = [
            0,
            0
        ];
        var pathLength = path._length;
        var i = 0;
        for(i = 0; i < pathLength; i += 1){
            centerPoint[0] += path.v[i][0];
            centerPoint[1] += path.v[i][1];
        }
        centerPoint[0] /= pathLength;
        centerPoint[1] /= pathLength;
        var clonedPath = shapePool.newElement();
        clonedPath.c = path.c;
        var vX;
        var vY;
        var oX;
        var oY;
        var iX;
        var iY;
        for(i = 0; i < pathLength; i += 1){
            vX = path.v[i][0] + (centerPoint[0] - path.v[i][0]) * percent;
            vY = path.v[i][1] + (centerPoint[1] - path.v[i][1]) * percent;
            oX = path.o[i][0] + (centerPoint[0] - path.o[i][0]) * -percent;
            oY = path.o[i][1] + (centerPoint[1] - path.o[i][1]) * -percent;
            iX = path.i[i][0] + (centerPoint[0] - path.i[i][0]) * -percent;
            iY = path.i[i][1] + (centerPoint[1] - path.i[i][1]) * -percent;
            clonedPath.setTripleAt(vX, vY, oX, oY, iX, iY, i);
        }
        return clonedPath;
    };
    PuckerAndBloatModifier.prototype.processShapes = function(_isFirstFrame) {
        var shapePaths;
        var i;
        var len = this.shapes.length;
        var j;
        var jLen;
        var amount = this.amount.v;
        if (amount !== 0) {
            var shapeData;
            var localShapeCollection;
            for(i = 0; i < len; i += 1){
                shapeData = this.shapes[i];
                localShapeCollection = shapeData.localShapeCollection;
                if (!(!shapeData.shape._mdf && !this._mdf && !_isFirstFrame)) {
                    localShapeCollection.releaseShapes();
                    shapeData.shape._mdf = true;
                    shapePaths = shapeData.shape.paths.shapes;
                    jLen = shapeData.shape.paths._length;
                    for(j = 0; j < jLen; j += 1)localShapeCollection.addShape(this.processPath(shapePaths[j], amount));
                }
                shapeData.shape.paths = shapeData.localShapeCollection;
            }
        }
        if (!this.dynamicProperties.length) this._mdf = false;
    };
    var TransformPropertyFactory = function() {
        var defaultVector = [
            0,
            0
        ];
        function applyToMatrix(mat) {
            var _mdf = this._mdf;
            this.iterateDynamicProperties();
            this._mdf = this._mdf || _mdf;
            if (this.a) mat.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]);
            if (this.s) mat.scale(this.s.v[0], this.s.v[1], this.s.v[2]);
            if (this.sk) mat.skewFromAxis(-this.sk.v, this.sa.v);
            if (this.r) mat.rotate(-this.r.v);
            else mat.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]);
            if (this.data.p.s) {
                if (this.data.p.z) mat.translate(this.px.v, this.py.v, -this.pz.v);
                else mat.translate(this.px.v, this.py.v, 0);
            } else mat.translate(this.p.v[0], this.p.v[1], -this.p.v[2]);
        }
        function processKeys(forceRender) {
            if (this.elem.globalData.frameId === this.frameId) return;
            if (this._isDirty) {
                this.precalculateMatrix();
                this._isDirty = false;
            }
            this.iterateDynamicProperties();
            if (this._mdf || forceRender) {
                var frameRate;
                this.v.cloneFromProps(this.pre.props);
                if (this.appliedTransformations < 1) this.v.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]);
                if (this.appliedTransformations < 2) this.v.scale(this.s.v[0], this.s.v[1], this.s.v[2]);
                if (this.sk && this.appliedTransformations < 3) this.v.skewFromAxis(-this.sk.v, this.sa.v);
                if (this.r && this.appliedTransformations < 4) this.v.rotate(-this.r.v);
                else if (!this.r && this.appliedTransformations < 4) this.v.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]);
                if (this.autoOriented) {
                    var v1;
                    var v2;
                    frameRate = this.elem.globalData.frameRate;
                    if (this.p && this.p.keyframes && this.p.getValueAtTime) {
                        if (this.p._caching.lastFrame + this.p.offsetTime <= this.p.keyframes[0].t) {
                            v1 = this.p.getValueAtTime((this.p.keyframes[0].t + 0.01) / frameRate, 0);
                            v2 = this.p.getValueAtTime(this.p.keyframes[0].t / frameRate, 0);
                        } else if (this.p._caching.lastFrame + this.p.offsetTime >= this.p.keyframes[this.p.keyframes.length - 1].t) {
                            v1 = this.p.getValueAtTime(this.p.keyframes[this.p.keyframes.length - 1].t / frameRate, 0);
                            v2 = this.p.getValueAtTime((this.p.keyframes[this.p.keyframes.length - 1].t - 0.05) / frameRate, 0);
                        } else {
                            v1 = this.p.pv;
                            v2 = this.p.getValueAtTime((this.p._caching.lastFrame + this.p.offsetTime - 0.01) / frameRate, this.p.offsetTime);
                        }
                    } else if (this.px && this.px.keyframes && this.py.keyframes && this.px.getValueAtTime && this.py.getValueAtTime) {
                        v1 = [];
                        v2 = [];
                        var px = this.px;
                        var py = this.py;
                        if (px._caching.lastFrame + px.offsetTime <= px.keyframes[0].t) {
                            v1[0] = px.getValueAtTime((px.keyframes[0].t + 0.01) / frameRate, 0);
                            v1[1] = py.getValueAtTime((py.keyframes[0].t + 0.01) / frameRate, 0);
                            v2[0] = px.getValueAtTime(px.keyframes[0].t / frameRate, 0);
                            v2[1] = py.getValueAtTime(py.keyframes[0].t / frameRate, 0);
                        } else if (px._caching.lastFrame + px.offsetTime >= px.keyframes[px.keyframes.length - 1].t) {
                            v1[0] = px.getValueAtTime(px.keyframes[px.keyframes.length - 1].t / frameRate, 0);
                            v1[1] = py.getValueAtTime(py.keyframes[py.keyframes.length - 1].t / frameRate, 0);
                            v2[0] = px.getValueAtTime((px.keyframes[px.keyframes.length - 1].t - 0.01) / frameRate, 0);
                            v2[1] = py.getValueAtTime((py.keyframes[py.keyframes.length - 1].t - 0.01) / frameRate, 0);
                        } else {
                            v1 = [
                                px.pv,
                                py.pv
                            ];
                            v2[0] = px.getValueAtTime((px._caching.lastFrame + px.offsetTime - 0.01) / frameRate, px.offsetTime);
                            v2[1] = py.getValueAtTime((py._caching.lastFrame + py.offsetTime - 0.01) / frameRate, py.offsetTime);
                        }
                    } else {
                        v2 = defaultVector;
                        v1 = v2;
                    }
                    this.v.rotate(-Math.atan2(v1[1] - v2[1], v1[0] - v2[0]));
                }
                if (this.data.p && this.data.p.s) {
                    if (this.data.p.z) this.v.translate(this.px.v, this.py.v, -this.pz.v);
                    else this.v.translate(this.px.v, this.py.v, 0);
                } else this.v.translate(this.p.v[0], this.p.v[1], -this.p.v[2]);
            }
            this.frameId = this.elem.globalData.frameId;
        }
        function precalculateMatrix() {
            if (!this.a.k) {
                this.pre.translate(-this.a.v[0], -this.a.v[1], this.a.v[2]);
                this.appliedTransformations = 1;
            } else return;
            if (!this.s.effectsSequence.length) {
                this.pre.scale(this.s.v[0], this.s.v[1], this.s.v[2]);
                this.appliedTransformations = 2;
            } else return;
            if (this.sk) {
                if (!this.sk.effectsSequence.length && !this.sa.effectsSequence.length) {
                    this.pre.skewFromAxis(-this.sk.v, this.sa.v);
                    this.appliedTransformations = 3;
                } else return;
            }
            if (this.r) {
                if (!this.r.effectsSequence.length) {
                    this.pre.rotate(-this.r.v);
                    this.appliedTransformations = 4;
                }
            } else if (!this.rz.effectsSequence.length && !this.ry.effectsSequence.length && !this.rx.effectsSequence.length && !this.or.effectsSequence.length) {
                this.pre.rotateZ(-this.rz.v).rotateY(this.ry.v).rotateX(this.rx.v).rotateZ(-this.or.v[2]).rotateY(this.or.v[1]).rotateX(this.or.v[0]);
                this.appliedTransformations = 4;
            }
        }
        function autoOrient() {
        // var prevP = this.getValueAtTime();
        }
        function addDynamicProperty(prop) {
            this._addDynamicProperty(prop);
            this.elem.addDynamicProperty(prop);
            this._isDirty = true;
        }
        function TransformProperty(elem, data, container) {
            this.elem = elem;
            this.frameId = -1;
            this.propType = "transform";
            this.data = data;
            this.v = new Matrix(); // Precalculated matrix with non animated properties
            this.pre = new Matrix();
            this.appliedTransformations = 0;
            this.initDynamicPropertyContainer(container || elem);
            if (data.p && data.p.s) {
                this.px = PropertyFactory.getProp(elem, data.p.x, 0, 0, this);
                this.py = PropertyFactory.getProp(elem, data.p.y, 0, 0, this);
                if (data.p.z) this.pz = PropertyFactory.getProp(elem, data.p.z, 0, 0, this);
            } else this.p = PropertyFactory.getProp(elem, data.p || {
                k: [
                    0,
                    0,
                    0
                ]
            }, 1, 0, this);
            if (data.rx) {
                this.rx = PropertyFactory.getProp(elem, data.rx, 0, degToRads, this);
                this.ry = PropertyFactory.getProp(elem, data.ry, 0, degToRads, this);
                this.rz = PropertyFactory.getProp(elem, data.rz, 0, degToRads, this);
                if (data.or.k[0].ti) {
                    var i;
                    var len = data.or.k.length;
                    for(i = 0; i < len; i += 1){
                        data.or.k[i].to = null;
                        data.or.k[i].ti = null;
                    }
                }
                this.or = PropertyFactory.getProp(elem, data.or, 1, degToRads, this); // sh Indicates it needs to be capped between -180 and 180
                this.or.sh = true;
            } else this.r = PropertyFactory.getProp(elem, data.r || {
                k: 0
            }, 0, degToRads, this);
            if (data.sk) {
                this.sk = PropertyFactory.getProp(elem, data.sk, 0, degToRads, this);
                this.sa = PropertyFactory.getProp(elem, data.sa, 0, degToRads, this);
            }
            this.a = PropertyFactory.getProp(elem, data.a || {
                k: [
                    0,
                    0,
                    0
                ]
            }, 1, 0, this);
            this.s = PropertyFactory.getProp(elem, data.s || {
                k: [
                    100,
                    100,
                    100
                ]
            }, 1, 0.01, this); // Opacity is not part of the transform properties, that's why it won't use this.dynamicProperties. That way transforms won't get updated if opacity changes.
            if (data.o) this.o = PropertyFactory.getProp(elem, data.o, 0, 0.01, elem);
            else this.o = {
                _mdf: false,
                v: 1
            };
            this._isDirty = true;
            if (!this.dynamicProperties.length) this.getValue(true);
        }
        TransformProperty.prototype = {
            applyToMatrix: applyToMatrix,
            getValue: processKeys,
            precalculateMatrix: precalculateMatrix,
            autoOrient: autoOrient
        };
        extendPrototype([
            DynamicPropertyContainer
        ], TransformProperty);
        TransformProperty.prototype.addDynamicProperty = addDynamicProperty;
        TransformProperty.prototype._addDynamicProperty = DynamicPropertyContainer.prototype.addDynamicProperty;
        function getTransformProperty(elem, data, container) {
            return new TransformProperty(elem, data, container);
        }
        return {
            getTransformProperty: getTransformProperty
        };
    }();
    function RepeaterModifier() {}
    extendPrototype([
        ShapeModifier
    ], RepeaterModifier);
    RepeaterModifier.prototype.initModifierProperties = function(elem, data) {
        this.getValue = this.processKeys;
        this.c = PropertyFactory.getProp(elem, data.c, 0, null, this);
        this.o = PropertyFactory.getProp(elem, data.o, 0, null, this);
        this.tr = TransformPropertyFactory.getTransformProperty(elem, data.tr, this);
        this.so = PropertyFactory.getProp(elem, data.tr.so, 0, 0.01, this);
        this.eo = PropertyFactory.getProp(elem, data.tr.eo, 0, 0.01, this);
        this.data = data;
        if (!this.dynamicProperties.length) this.getValue(true);
        this._isAnimated = !!this.dynamicProperties.length;
        this.pMatrix = new Matrix();
        this.rMatrix = new Matrix();
        this.sMatrix = new Matrix();
        this.tMatrix = new Matrix();
        this.matrix = new Matrix();
    };
    RepeaterModifier.prototype.applyTransforms = function(pMatrix, rMatrix, sMatrix, transform, perc, inv) {
        var dir = inv ? -1 : 1;
        var scaleX = transform.s.v[0] + (1 - transform.s.v[0]) * (1 - perc);
        var scaleY = transform.s.v[1] + (1 - transform.s.v[1]) * (1 - perc);
        pMatrix.translate(transform.p.v[0] * dir * perc, transform.p.v[1] * dir * perc, transform.p.v[2]);
        rMatrix.translate(-transform.a.v[0], -transform.a.v[1], transform.a.v[2]);
        rMatrix.rotate(-transform.r.v * dir * perc);
        rMatrix.translate(transform.a.v[0], transform.a.v[1], transform.a.v[2]);
        sMatrix.translate(-transform.a.v[0], -transform.a.v[1], transform.a.v[2]);
        sMatrix.scale(inv ? 1 / scaleX : scaleX, inv ? 1 / scaleY : scaleY);
        sMatrix.translate(transform.a.v[0], transform.a.v[1], transform.a.v[2]);
    };
    RepeaterModifier.prototype.init = function(elem, arr, pos, elemsData) {
        this.elem = elem;
        this.arr = arr;
        this.pos = pos;
        this.elemsData = elemsData;
        this._currentCopies = 0;
        this._elements = [];
        this._groups = [];
        this.frameId = -1;
        this.initDynamicPropertyContainer(elem);
        this.initModifierProperties(elem, arr[pos]);
        while(pos > 0){
            pos -= 1; // this._elements.unshift(arr.splice(pos,1)[0]);
            this._elements.unshift(arr[pos]);
        }
        if (this.dynamicProperties.length) this.k = true;
        else this.getValue(true);
    };
    RepeaterModifier.prototype.resetElements = function(elements) {
        var i;
        var len = elements.length;
        for(i = 0; i < len; i += 1){
            elements[i]._processed = false;
            if (elements[i].ty === "gr") this.resetElements(elements[i].it);
        }
    };
    RepeaterModifier.prototype.cloneElements = function(elements) {
        var newElements = JSON.parse(JSON.stringify(elements));
        this.resetElements(newElements);
        return newElements;
    };
    RepeaterModifier.prototype.changeGroupRender = function(elements, renderFlag) {
        var i;
        var len = elements.length;
        for(i = 0; i < len; i += 1){
            elements[i]._render = renderFlag;
            if (elements[i].ty === "gr") this.changeGroupRender(elements[i].it, renderFlag);
        }
    };
    RepeaterModifier.prototype.processShapes = function(_isFirstFrame) {
        var items;
        var itemsTransform;
        var i;
        var dir;
        var cont;
        var hasReloaded = false;
        if (this._mdf || _isFirstFrame) {
            var copies = Math.ceil(this.c.v);
            if (this._groups.length < copies) {
                while(this._groups.length < copies){
                    var group = {
                        it: this.cloneElements(this._elements),
                        ty: "gr"
                    };
                    group.it.push({
                        a: {
                            a: 0,
                            ix: 1,
                            k: [
                                0,
                                0
                            ]
                        },
                        nm: "Transform",
                        o: {
                            a: 0,
                            ix: 7,
                            k: 100
                        },
                        p: {
                            a: 0,
                            ix: 2,
                            k: [
                                0,
                                0
                            ]
                        },
                        r: {
                            a: 1,
                            ix: 6,
                            k: [
                                {
                                    s: 0,
                                    e: 0,
                                    t: 0
                                },
                                {
                                    s: 0,
                                    e: 0,
                                    t: 1
                                }
                            ]
                        },
                        s: {
                            a: 0,
                            ix: 3,
                            k: [
                                100,
                                100
                            ]
                        },
                        sa: {
                            a: 0,
                            ix: 5,
                            k: 0
                        },
                        sk: {
                            a: 0,
                            ix: 4,
                            k: 0
                        },
                        ty: "tr"
                    });
                    this.arr.splice(0, 0, group);
                    this._groups.splice(0, 0, group);
                    this._currentCopies += 1;
                }
                this.elem.reloadShapes();
                hasReloaded = true;
            }
            cont = 0;
            var renderFlag;
            for(i = 0; i <= this._groups.length - 1; i += 1){
                renderFlag = cont < copies;
                this._groups[i]._render = renderFlag;
                this.changeGroupRender(this._groups[i].it, renderFlag);
                if (!renderFlag) {
                    var elems = this.elemsData[i].it;
                    var transformData = elems[elems.length - 1];
                    if (transformData.transform.op.v !== 0) {
                        transformData.transform.op._mdf = true;
                        transformData.transform.op.v = 0;
                    } else transformData.transform.op._mdf = false;
                }
                cont += 1;
            }
            this._currentCopies = copies; /// /
            var offset = this.o.v;
            var offsetModulo = offset % 1;
            var roundOffset = offset > 0 ? Math.floor(offset) : Math.ceil(offset);
            var pProps = this.pMatrix.props;
            var rProps = this.rMatrix.props;
            var sProps = this.sMatrix.props;
            this.pMatrix.reset();
            this.rMatrix.reset();
            this.sMatrix.reset();
            this.tMatrix.reset();
            this.matrix.reset();
            var iteration = 0;
            if (offset > 0) {
                while(iteration < roundOffset){
                    this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, false);
                    iteration += 1;
                }
                if (offsetModulo) {
                    this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, offsetModulo, false);
                    iteration += offsetModulo;
                }
            } else if (offset < 0) {
                while(iteration > roundOffset){
                    this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, true);
                    iteration -= 1;
                }
                if (offsetModulo) {
                    this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, -offsetModulo, true);
                    iteration -= offsetModulo;
                }
            }
            i = this.data.m === 1 ? 0 : this._currentCopies - 1;
            dir = this.data.m === 1 ? 1 : -1;
            cont = this._currentCopies;
            var j;
            var jLen;
            while(cont){
                items = this.elemsData[i].it;
                itemsTransform = items[items.length - 1].transform.mProps.v.props;
                jLen = itemsTransform.length;
                items[items.length - 1].transform.mProps._mdf = true;
                items[items.length - 1].transform.op._mdf = true;
                items[items.length - 1].transform.op.v = this._currentCopies === 1 ? this.so.v : this.so.v + (this.eo.v - this.so.v) * (i / (this._currentCopies - 1));
                if (iteration !== 0) {
                    if (i !== 0 && dir === 1 || i !== this._currentCopies - 1 && dir === -1) this.applyTransforms(this.pMatrix, this.rMatrix, this.sMatrix, this.tr, 1, false);
                    this.matrix.transform(rProps[0], rProps[1], rProps[2], rProps[3], rProps[4], rProps[5], rProps[6], rProps[7], rProps[8], rProps[9], rProps[10], rProps[11], rProps[12], rProps[13], rProps[14], rProps[15]);
                    this.matrix.transform(sProps[0], sProps[1], sProps[2], sProps[3], sProps[4], sProps[5], sProps[6], sProps[7], sProps[8], sProps[9], sProps[10], sProps[11], sProps[12], sProps[13], sProps[14], sProps[15]);
                    this.matrix.transform(pProps[0], pProps[1], pProps[2], pProps[3], pProps[4], pProps[5], pProps[6], pProps[7], pProps[8], pProps[9], pProps[10], pProps[11], pProps[12], pProps[13], pProps[14], pProps[15]);
                    for(j = 0; j < jLen; j += 1)itemsTransform[j] = this.matrix.props[j];
                    this.matrix.reset();
                } else {
                    this.matrix.reset();
                    for(j = 0; j < jLen; j += 1)itemsTransform[j] = this.matrix.props[j];
                }
                iteration += 1;
                cont -= 1;
                i += dir;
            }
        } else {
            cont = this._currentCopies;
            i = 0;
            dir = 1;
            while(cont){
                items = this.elemsData[i].it;
                itemsTransform = items[items.length - 1].transform.mProps.v.props;
                items[items.length - 1].transform.mProps._mdf = false;
                items[items.length - 1].transform.op._mdf = false;
                cont -= 1;
                i += dir;
            }
        }
        return hasReloaded;
    };
    RepeaterModifier.prototype.addShape = function() {};
    function RoundCornersModifier() {}
    extendPrototype([
        ShapeModifier
    ], RoundCornersModifier);
    RoundCornersModifier.prototype.initModifierProperties = function(elem, data) {
        this.getValue = this.processKeys;
        this.rd = PropertyFactory.getProp(elem, data.r, 0, null, this);
        this._isAnimated = !!this.rd.effectsSequence.length;
    };
    RoundCornersModifier.prototype.processPath = function(path, round) {
        var clonedPath = shapePool.newElement();
        clonedPath.c = path.c;
        var i;
        var len = path._length;
        var currentV;
        var currentI;
        var currentO;
        var closerV;
        var distance;
        var newPosPerc;
        var index = 0;
        var vX;
        var vY;
        var oX;
        var oY;
        var iX;
        var iY;
        for(i = 0; i < len; i += 1){
            currentV = path.v[i];
            currentO = path.o[i];
            currentI = path.i[i];
            if (currentV[0] === currentO[0] && currentV[1] === currentO[1] && currentV[0] === currentI[0] && currentV[1] === currentI[1]) {
                if ((i === 0 || i === len - 1) && !path.c) {
                    clonedPath.setTripleAt(currentV[0], currentV[1], currentO[0], currentO[1], currentI[0], currentI[1], index);
                    /* clonedPath.v[index] = currentV;
                  clonedPath.o[index] = currentO;
                  clonedPath.i[index] = currentI; */ index += 1;
                } else {
                    if (i === 0) closerV = path.v[len - 1];
                    else closerV = path.v[i - 1];
                    distance = Math.sqrt(Math.pow(currentV[0] - closerV[0], 2) + Math.pow(currentV[1] - closerV[1], 2));
                    newPosPerc = distance ? Math.min(distance / 2, round) / distance : 0;
                    iX = currentV[0] + (closerV[0] - currentV[0]) * newPosPerc;
                    vX = iX;
                    iY = currentV[1] - (currentV[1] - closerV[1]) * newPosPerc;
                    vY = iY;
                    oX = vX - (vX - currentV[0]) * roundCorner;
                    oY = vY - (vY - currentV[1]) * roundCorner;
                    clonedPath.setTripleAt(vX, vY, oX, oY, iX, iY, index);
                    index += 1;
                    if (i === len - 1) closerV = path.v[0];
                    else closerV = path.v[i + 1];
                    distance = Math.sqrt(Math.pow(currentV[0] - closerV[0], 2) + Math.pow(currentV[1] - closerV[1], 2));
                    newPosPerc = distance ? Math.min(distance / 2, round) / distance : 0;
                    oX = currentV[0] + (closerV[0] - currentV[0]) * newPosPerc;
                    vX = oX;
                    oY = currentV[1] + (closerV[1] - currentV[1]) * newPosPerc;
                    vY = oY;
                    iX = vX - (vX - currentV[0]) * roundCorner;
                    iY = vY - (vY - currentV[1]) * roundCorner;
                    clonedPath.setTripleAt(vX, vY, oX, oY, iX, iY, index);
                    index += 1;
                }
            } else {
                clonedPath.setTripleAt(path.v[i][0], path.v[i][1], path.o[i][0], path.o[i][1], path.i[i][0], path.i[i][1], index);
                index += 1;
            }
        }
        return clonedPath;
    };
    RoundCornersModifier.prototype.processShapes = function(_isFirstFrame) {
        var shapePaths;
        var i;
        var len = this.shapes.length;
        var j;
        var jLen;
        var rd = this.rd.v;
        if (rd !== 0) {
            var shapeData;
            var localShapeCollection;
            for(i = 0; i < len; i += 1){
                shapeData = this.shapes[i];
                localShapeCollection = shapeData.localShapeCollection;
                if (!(!shapeData.shape._mdf && !this._mdf && !_isFirstFrame)) {
                    localShapeCollection.releaseShapes();
                    shapeData.shape._mdf = true;
                    shapePaths = shapeData.shape.paths.shapes;
                    jLen = shapeData.shape.paths._length;
                    for(j = 0; j < jLen; j += 1)localShapeCollection.addShape(this.processPath(shapePaths[j], rd));
                }
                shapeData.shape.paths = shapeData.localShapeCollection;
            }
        }
        if (!this.dynamicProperties.length) this._mdf = false;
    };
    function floatEqual(a, b) {
        return Math.abs(a - b) * 100000 <= Math.min(Math.abs(a), Math.abs(b));
    }
    function floatZero(f) {
        return Math.abs(f) <= 0.00001;
    }
    function lerp(p0, p1, amount) {
        return p0 * (1 - amount) + p1 * amount;
    }
    function lerpPoint(p0, p1, amount) {
        return [
            lerp(p0[0], p1[0], amount),
            lerp(p0[1], p1[1], amount)
        ];
    }
    function quadRoots(a, b, c) {
        // no root
        if (a === 0) return [];
        var s = b * b - 4 * a * c; // Complex roots
        if (s < 0) return [];
        var singleRoot = -b / (2 * a); // 1 root
        if (s === 0) return [
            singleRoot
        ];
        var delta = Math.sqrt(s) / (2 * a); // 2 roots
        return [
            singleRoot - delta,
            singleRoot + delta
        ];
    }
    function polynomialCoefficients(p0, p1, p2, p3) {
        return [
            -p0 + 3 * p1 - 3 * p2 + p3,
            3 * p0 - 6 * p1 + 3 * p2,
            -3 * p0 + 3 * p1,
            p0
        ];
    }
    function singlePoint(p) {
        return new PolynomialBezier(p, p, p, p, false);
    }
    function PolynomialBezier(p0, p1, p2, p3, linearize) {
        if (linearize && pointEqual(p0, p1)) p1 = lerpPoint(p0, p3, 1 / 3);
        if (linearize && pointEqual(p2, p3)) p2 = lerpPoint(p0, p3, 2 / 3);
        var coeffx = polynomialCoefficients(p0[0], p1[0], p2[0], p3[0]);
        var coeffy = polynomialCoefficients(p0[1], p1[1], p2[1], p3[1]);
        this.a = [
            coeffx[0],
            coeffy[0]
        ];
        this.b = [
            coeffx[1],
            coeffy[1]
        ];
        this.c = [
            coeffx[2],
            coeffy[2]
        ];
        this.d = [
            coeffx[3],
            coeffy[3]
        ];
        this.points = [
            p0,
            p1,
            p2,
            p3
        ];
    }
    PolynomialBezier.prototype.point = function(t) {
        return [
            ((this.a[0] * t + this.b[0]) * t + this.c[0]) * t + this.d[0],
            ((this.a[1] * t + this.b[1]) * t + this.c[1]) * t + this.d[1]
        ];
    };
    PolynomialBezier.prototype.derivative = function(t) {
        return [
            (3 * t * this.a[0] + 2 * this.b[0]) * t + this.c[0],
            (3 * t * this.a[1] + 2 * this.b[1]) * t + this.c[1]
        ];
    };
    PolynomialBezier.prototype.tangentAngle = function(t) {
        var p = this.derivative(t);
        return Math.atan2(p[1], p[0]);
    };
    PolynomialBezier.prototype.normalAngle = function(t) {
        var p = this.derivative(t);
        return Math.atan2(p[0], p[1]);
    };
    PolynomialBezier.prototype.inflectionPoints = function() {
        var denom = this.a[1] * this.b[0] - this.a[0] * this.b[1];
        if (floatZero(denom)) return [];
        var tcusp = -0.5 * (this.a[1] * this.c[0] - this.a[0] * this.c[1]) / denom;
        var square = tcusp * tcusp - 1 / 3 * (this.b[1] * this.c[0] - this.b[0] * this.c[1]) / denom;
        if (square < 0) return [];
        var root = Math.sqrt(square);
        if (floatZero(root)) {
            if (root > 0 && root < 1) return [
                tcusp
            ];
            return [];
        }
        return [
            tcusp - root,
            tcusp + root
        ].filter(function(r) {
            return r > 0 && r < 1;
        });
    };
    PolynomialBezier.prototype.split = function(t) {
        if (t <= 0) return [
            singlePoint(this.points[0]),
            this
        ];
        if (t >= 1) return [
            this,
            singlePoint(this.points[this.points.length - 1])
        ];
        var p10 = lerpPoint(this.points[0], this.points[1], t);
        var p11 = lerpPoint(this.points[1], this.points[2], t);
        var p12 = lerpPoint(this.points[2], this.points[3], t);
        var p20 = lerpPoint(p10, p11, t);
        var p21 = lerpPoint(p11, p12, t);
        var p3 = lerpPoint(p20, p21, t);
        return [
            new PolynomialBezier(this.points[0], p10, p20, p3, true),
            new PolynomialBezier(p3, p21, p12, this.points[3], true)
        ];
    };
    function extrema(bez, comp) {
        var min = bez.points[0][comp];
        var max = bez.points[bez.points.length - 1][comp];
        if (min > max) {
            var e = max;
            max = min;
            min = e;
        } // Derivative roots to find min/max
        var f = quadRoots(3 * bez.a[comp], 2 * bez.b[comp], bez.c[comp]);
        for(var i = 0; i < f.length; i += 1)if (f[i] > 0 && f[i] < 1) {
            var val = bez.point(f[i])[comp];
            if (val < min) min = val;
            else if (val > max) max = val;
        }
        return {
            min: min,
            max: max
        };
    }
    PolynomialBezier.prototype.bounds = function() {
        return {
            x: extrema(this, 0),
            y: extrema(this, 1)
        };
    };
    PolynomialBezier.prototype.boundingBox = function() {
        var bounds = this.bounds();
        return {
            left: bounds.x.min,
            right: bounds.x.max,
            top: bounds.y.min,
            bottom: bounds.y.max,
            width: bounds.x.max - bounds.x.min,
            height: bounds.y.max - bounds.y.min,
            cx: (bounds.x.max + bounds.x.min) / 2,
            cy: (bounds.y.max + bounds.y.min) / 2
        };
    };
    function intersectData(bez, t1, t2) {
        var box = bez.boundingBox();
        return {
            cx: box.cx,
            cy: box.cy,
            width: box.width,
            height: box.height,
            bez: bez,
            t: (t1 + t2) / 2,
            t1: t1,
            t2: t2
        };
    }
    function splitData(data) {
        var split = data.bez.split(0.5);
        return [
            intersectData(split[0], data.t1, data.t),
            intersectData(split[1], data.t, data.t2)
        ];
    }
    function boxIntersect(b1, b2) {
        return Math.abs(b1.cx - b2.cx) * 2 < b1.width + b2.width && Math.abs(b1.cy - b2.cy) * 2 < b1.height + b2.height;
    }
    function intersectsImpl(d1, d2, depth, tolerance, intersections, maxRecursion) {
        if (!boxIntersect(d1, d2)) return;
        if (depth >= maxRecursion || d1.width <= tolerance && d1.height <= tolerance && d2.width <= tolerance && d2.height <= tolerance) {
            intersections.push([
                d1.t,
                d2.t
            ]);
            return;
        }
        var d1s = splitData(d1);
        var d2s = splitData(d2);
        intersectsImpl(d1s[0], d2s[0], depth + 1, tolerance, intersections, maxRecursion);
        intersectsImpl(d1s[0], d2s[1], depth + 1, tolerance, intersections, maxRecursion);
        intersectsImpl(d1s[1], d2s[0], depth + 1, tolerance, intersections, maxRecursion);
        intersectsImpl(d1s[1], d2s[1], depth + 1, tolerance, intersections, maxRecursion);
    }
    PolynomialBezier.prototype.intersections = function(other, tolerance, maxRecursion) {
        if (tolerance === undefined) tolerance = 2;
        if (maxRecursion === undefined) maxRecursion = 7;
        var intersections = [];
        intersectsImpl(intersectData(this, 0, 1), intersectData(other, 0, 1), 0, tolerance, intersections, maxRecursion);
        return intersections;
    };
    PolynomialBezier.shapeSegment = function(shapePath, index) {
        var nextIndex = (index + 1) % shapePath.length();
        return new PolynomialBezier(shapePath.v[index], shapePath.o[index], shapePath.i[nextIndex], shapePath.v[nextIndex], true);
    };
    PolynomialBezier.shapeSegmentInverted = function(shapePath, index) {
        var nextIndex = (index + 1) % shapePath.length();
        return new PolynomialBezier(shapePath.v[nextIndex], shapePath.i[nextIndex], shapePath.o[index], shapePath.v[index], true);
    };
    function crossProduct(a, b) {
        return [
            a[1] * b[2] - a[2] * b[1],
            a[2] * b[0] - a[0] * b[2],
            a[0] * b[1] - a[1] * b[0]
        ];
    }
    function lineIntersection(start1, end1, start2, end2) {
        var v1 = [
            start1[0],
            start1[1],
            1
        ];
        var v2 = [
            end1[0],
            end1[1],
            1
        ];
        var v3 = [
            start2[0],
            start2[1],
            1
        ];
        var v4 = [
            end2[0],
            end2[1],
            1
        ];
        var r = crossProduct(crossProduct(v1, v2), crossProduct(v3, v4));
        if (floatZero(r[2])) return null;
        return [
            r[0] / r[2],
            r[1] / r[2]
        ];
    }
    function polarOffset(p, angle, length) {
        return [
            p[0] + Math.cos(angle) * length,
            p[1] - Math.sin(angle) * length
        ];
    }
    function pointDistance(p1, p2) {
        return Math.hypot(p1[0] - p2[0], p1[1] - p2[1]);
    }
    function pointEqual(p1, p2) {
        return floatEqual(p1[0], p2[0]) && floatEqual(p1[1], p2[1]);
    }
    function ZigZagModifier() {}
    extendPrototype([
        ShapeModifier
    ], ZigZagModifier);
    ZigZagModifier.prototype.initModifierProperties = function(elem, data) {
        this.getValue = this.processKeys;
        this.amplitude = PropertyFactory.getProp(elem, data.s, 0, null, this);
        this.frequency = PropertyFactory.getProp(elem, data.r, 0, null, this);
        this.pointsType = PropertyFactory.getProp(elem, data.pt, 0, null, this);
        this._isAnimated = this.amplitude.effectsSequence.length !== 0 || this.frequency.effectsSequence.length !== 0 || this.pointsType.effectsSequence.length !== 0;
    };
    function setPoint(outputBezier, point, angle, direction, amplitude, outAmplitude, inAmplitude) {
        var angO = angle - Math.PI / 2;
        var angI = angle + Math.PI / 2;
        var px = point[0] + Math.cos(angle) * direction * amplitude;
        var py = point[1] - Math.sin(angle) * direction * amplitude;
        outputBezier.setTripleAt(px, py, px + Math.cos(angO) * outAmplitude, py - Math.sin(angO) * outAmplitude, px + Math.cos(angI) * inAmplitude, py - Math.sin(angI) * inAmplitude, outputBezier.length());
    }
    function getPerpendicularVector(pt1, pt2) {
        var vector = [
            pt2[0] - pt1[0],
            pt2[1] - pt1[1]
        ];
        var rot = -Math.PI * 0.5;
        var rotatedVector = [
            Math.cos(rot) * vector[0] - Math.sin(rot) * vector[1],
            Math.sin(rot) * vector[0] + Math.cos(rot) * vector[1]
        ];
        return rotatedVector;
    }
    function getProjectingAngle(path, cur) {
        var prevIndex = cur === 0 ? path.length() - 1 : cur - 1;
        var nextIndex = (cur + 1) % path.length();
        var prevPoint = path.v[prevIndex];
        var nextPoint = path.v[nextIndex];
        var pVector = getPerpendicularVector(prevPoint, nextPoint);
        return Math.atan2(0, 1) - Math.atan2(pVector[1], pVector[0]);
    }
    function zigZagCorner(outputBezier, path, cur, amplitude, frequency, pointType, direction) {
        var angle = getProjectingAngle(path, cur);
        var point = path.v[cur % path._length];
        var prevPoint = path.v[cur === 0 ? path._length - 1 : cur - 1];
        var nextPoint = path.v[(cur + 1) % path._length];
        var prevDist = pointType === 2 ? Math.sqrt(Math.pow(point[0] - prevPoint[0], 2) + Math.pow(point[1] - prevPoint[1], 2)) : 0;
        var nextDist = pointType === 2 ? Math.sqrt(Math.pow(point[0] - nextPoint[0], 2) + Math.pow(point[1] - nextPoint[1], 2)) : 0;
        setPoint(outputBezier, path.v[cur % path._length], angle, direction, amplitude, nextDist / ((frequency + 1) * 2), prevDist / ((frequency + 1) * 2), pointType);
    }
    function zigZagSegment(outputBezier, segment, amplitude, frequency, pointType, direction) {
        for(var i = 0; i < frequency; i += 1){
            var t = (i + 1) / (frequency + 1);
            var dist = pointType === 2 ? Math.sqrt(Math.pow(segment.points[3][0] - segment.points[0][0], 2) + Math.pow(segment.points[3][1] - segment.points[0][1], 2)) : 0;
            var angle = segment.normalAngle(t);
            var point = segment.point(t);
            setPoint(outputBezier, point, angle, direction, amplitude, dist / ((frequency + 1) * 2), dist / ((frequency + 1) * 2), pointType);
            direction = -direction;
        }
        return direction;
    }
    ZigZagModifier.prototype.processPath = function(path, amplitude, frequency, pointType) {
        var count = path._length;
        var clonedPath = shapePool.newElement();
        clonedPath.c = path.c;
        if (!path.c) count -= 1;
        if (count === 0) return clonedPath;
        var direction = -1;
        var segment = PolynomialBezier.shapeSegment(path, 0);
        zigZagCorner(clonedPath, path, 0, amplitude, frequency, pointType, direction);
        for(var i = 0; i < count; i += 1){
            direction = zigZagSegment(clonedPath, segment, amplitude, frequency, pointType, -direction);
            if (i === count - 1 && !path.c) segment = null;
            else segment = PolynomialBezier.shapeSegment(path, (i + 1) % count);
            zigZagCorner(clonedPath, path, i + 1, amplitude, frequency, pointType, direction);
        }
        return clonedPath;
    };
    ZigZagModifier.prototype.processShapes = function(_isFirstFrame) {
        var shapePaths;
        var i;
        var len = this.shapes.length;
        var j;
        var jLen;
        var amplitude = this.amplitude.v;
        var frequency = Math.max(0, Math.round(this.frequency.v));
        var pointType = this.pointsType.v;
        if (amplitude !== 0) {
            var shapeData;
            var localShapeCollection;
            for(i = 0; i < len; i += 1){
                shapeData = this.shapes[i];
                localShapeCollection = shapeData.localShapeCollection;
                if (!(!shapeData.shape._mdf && !this._mdf && !_isFirstFrame)) {
                    localShapeCollection.releaseShapes();
                    shapeData.shape._mdf = true;
                    shapePaths = shapeData.shape.paths.shapes;
                    jLen = shapeData.shape.paths._length;
                    for(j = 0; j < jLen; j += 1)localShapeCollection.addShape(this.processPath(shapePaths[j], amplitude, frequency, pointType));
                }
                shapeData.shape.paths = shapeData.localShapeCollection;
            }
        }
        if (!this.dynamicProperties.length) this._mdf = false;
    };
    function linearOffset(p1, p2, amount) {
        var angle = Math.atan2(p2[0] - p1[0], p2[1] - p1[1]);
        return [
            polarOffset(p1, angle, amount),
            polarOffset(p2, angle, amount)
        ];
    }
    function offsetSegment(segment, amount) {
        var p0;
        var p1a;
        var p1b;
        var p2b;
        var p2a;
        var p3;
        var e;
        e = linearOffset(segment.points[0], segment.points[1], amount);
        p0 = e[0];
        p1a = e[1];
        e = linearOffset(segment.points[1], segment.points[2], amount);
        p1b = e[0];
        p2b = e[1];
        e = linearOffset(segment.points[2], segment.points[3], amount);
        p2a = e[0];
        p3 = e[1];
        var p1 = lineIntersection(p0, p1a, p1b, p2b);
        if (p1 === null) p1 = p1a;
        var p2 = lineIntersection(p2a, p3, p1b, p2b);
        if (p2 === null) p2 = p2a;
        return new PolynomialBezier(p0, p1, p2, p3);
    }
    function joinLines(outputBezier, seg1, seg2, lineJoin, miterLimit) {
        var p0 = seg1.points[3];
        var p1 = seg2.points[0]; // Bevel
        if (lineJoin === 3) return p0; // Connected, they don't need a joint
        if (pointEqual(p0, p1)) return p0; // Round
        if (lineJoin === 2) {
            var angleOut = -seg1.tangentAngle(1);
            var angleIn = -seg2.tangentAngle(0) + Math.PI;
            var center = lineIntersection(p0, polarOffset(p0, angleOut + Math.PI / 2, 100), p1, polarOffset(p1, angleOut + Math.PI / 2, 100));
            var radius = center ? pointDistance(center, p0) : pointDistance(p0, p1) / 2;
            var tan = polarOffset(p0, angleOut, 2 * radius * roundCorner);
            outputBezier.setXYAt(tan[0], tan[1], "o", outputBezier.length() - 1);
            tan = polarOffset(p1, angleIn, 2 * radius * roundCorner);
            outputBezier.setTripleAt(p1[0], p1[1], p1[0], p1[1], tan[0], tan[1], outputBezier.length());
            return p1;
        } // Miter
        var t0 = pointEqual(p0, seg1.points[2]) ? seg1.points[0] : seg1.points[2];
        var t1 = pointEqual(p1, seg2.points[1]) ? seg2.points[3] : seg2.points[1];
        var intersection = lineIntersection(t0, p0, p1, t1);
        if (intersection && pointDistance(intersection, p0) < miterLimit) {
            outputBezier.setTripleAt(intersection[0], intersection[1], intersection[0], intersection[1], intersection[0], intersection[1], outputBezier.length());
            return intersection;
        }
        return p0;
    }
    function getIntersection(a, b) {
        var intersect = a.intersections(b);
        if (intersect.length && floatEqual(intersect[0][0], 1)) intersect.shift();
        if (intersect.length) return intersect[0];
        return null;
    }
    function pruneSegmentIntersection(a, b) {
        var outa = a.slice();
        var outb = b.slice();
        var intersect = getIntersection(a[a.length - 1], b[0]);
        if (intersect) {
            outa[a.length - 1] = a[a.length - 1].split(intersect[0])[0];
            outb[0] = b[0].split(intersect[1])[1];
        }
        if (a.length > 1 && b.length > 1) {
            intersect = getIntersection(a[0], b[b.length - 1]);
            if (intersect) return [
                [
                    a[0].split(intersect[0])[0]
                ],
                [
                    b[b.length - 1].split(intersect[1])[1]
                ]
            ];
        }
        return [
            outa,
            outb
        ];
    }
    function pruneIntersections(segments) {
        var e;
        for(var i = 1; i < segments.length; i += 1){
            e = pruneSegmentIntersection(segments[i - 1], segments[i]);
            segments[i - 1] = e[0];
            segments[i] = e[1];
        }
        if (segments.length > 1) {
            e = pruneSegmentIntersection(segments[segments.length - 1], segments[0]);
            segments[segments.length - 1] = e[0];
            segments[0] = e[1];
        }
        return segments;
    }
    function offsetSegmentSplit(segment, amount) {
        /*
      We split each bezier segment into smaller pieces based
      on inflection points, this ensures the control point
      polygon is convex.
        (A cubic bezier can have none, one, or two inflection points)
    */ var flex = segment.inflectionPoints();
        var left;
        var right;
        var split;
        var mid;
        if (flex.length === 0) return [
            offsetSegment(segment, amount)
        ];
        if (flex.length === 1 || floatEqual(flex[1], 1)) {
            split = segment.split(flex[0]);
            left = split[0];
            right = split[1];
            return [
                offsetSegment(left, amount),
                offsetSegment(right, amount)
            ];
        }
        split = segment.split(flex[0]);
        left = split[0];
        var t = (flex[1] - flex[0]) / (1 - flex[0]);
        split = split[1].split(t);
        mid = split[0];
        right = split[1];
        return [
            offsetSegment(left, amount),
            offsetSegment(mid, amount),
            offsetSegment(right, amount)
        ];
    }
    function OffsetPathModifier() {}
    extendPrototype([
        ShapeModifier
    ], OffsetPathModifier);
    OffsetPathModifier.prototype.initModifierProperties = function(elem, data) {
        this.getValue = this.processKeys;
        this.amount = PropertyFactory.getProp(elem, data.a, 0, null, this);
        this.miterLimit = PropertyFactory.getProp(elem, data.ml, 0, null, this);
        this.lineJoin = data.lj;
        this._isAnimated = this.amount.effectsSequence.length !== 0;
    };
    OffsetPathModifier.prototype.processPath = function(inputBezier, amount, lineJoin, miterLimit) {
        var outputBezier = shapePool.newElement();
        outputBezier.c = inputBezier.c;
        var count = inputBezier.length();
        if (!inputBezier.c) count -= 1;
        var i;
        var j;
        var segment;
        var multiSegments = [];
        for(i = 0; i < count; i += 1){
            segment = PolynomialBezier.shapeSegment(inputBezier, i);
            multiSegments.push(offsetSegmentSplit(segment, amount));
        }
        if (!inputBezier.c) for(i = count - 1; i >= 0; i -= 1){
            segment = PolynomialBezier.shapeSegmentInverted(inputBezier, i);
            multiSegments.push(offsetSegmentSplit(segment, amount));
        }
        multiSegments = pruneIntersections(multiSegments); // Add bezier segments to the output and apply line joints
        var lastPoint = null;
        var lastSeg = null;
        for(i = 0; i < multiSegments.length; i += 1){
            var multiSegment = multiSegments[i];
            if (lastSeg) lastPoint = joinLines(outputBezier, lastSeg, multiSegment[0], lineJoin, miterLimit);
            lastSeg = multiSegment[multiSegment.length - 1];
            for(j = 0; j < multiSegment.length; j += 1){
                segment = multiSegment[j];
                if (lastPoint && pointEqual(segment.points[0], lastPoint)) outputBezier.setXYAt(segment.points[1][0], segment.points[1][1], "o", outputBezier.length() - 1);
                else outputBezier.setTripleAt(segment.points[0][0], segment.points[0][1], segment.points[1][0], segment.points[1][1], segment.points[0][0], segment.points[0][1], outputBezier.length());
                outputBezier.setTripleAt(segment.points[3][0], segment.points[3][1], segment.points[3][0], segment.points[3][1], segment.points[2][0], segment.points[2][1], outputBezier.length());
                lastPoint = segment.points[3];
            }
        }
        if (multiSegments.length) joinLines(outputBezier, lastSeg, multiSegments[0][0], lineJoin, miterLimit);
        return outputBezier;
    };
    OffsetPathModifier.prototype.processShapes = function(_isFirstFrame) {
        var shapePaths;
        var i;
        var len = this.shapes.length;
        var j;
        var jLen;
        var amount = this.amount.v;
        var miterLimit = this.miterLimit.v;
        var lineJoin = this.lineJoin;
        if (amount !== 0) {
            var shapeData;
            var localShapeCollection;
            for(i = 0; i < len; i += 1){
                shapeData = this.shapes[i];
                localShapeCollection = shapeData.localShapeCollection;
                if (!(!shapeData.shape._mdf && !this._mdf && !_isFirstFrame)) {
                    localShapeCollection.releaseShapes();
                    shapeData.shape._mdf = true;
                    shapePaths = shapeData.shape.paths.shapes;
                    jLen = shapeData.shape.paths._length;
                    for(j = 0; j < jLen; j += 1)localShapeCollection.addShape(this.processPath(shapePaths[j], amount, lineJoin, miterLimit));
                }
                shapeData.shape.paths = shapeData.localShapeCollection;
            }
        }
        if (!this.dynamicProperties.length) this._mdf = false;
    };
    function getFontProperties(fontData) {
        var styles = fontData.fStyle ? fontData.fStyle.split(" ") : [];
        var fWeight = "normal";
        var fStyle = "normal";
        var len = styles.length;
        var styleName;
        for(var i = 0; i < len; i += 1){
            styleName = styles[i].toLowerCase();
            switch(styleName){
                case "italic":
                    fStyle = "italic";
                    break;
                case "bold":
                    fWeight = "700";
                    break;
                case "black":
                    fWeight = "900";
                    break;
                case "medium":
                    fWeight = "500";
                    break;
                case "regular":
                case "normal":
                    fWeight = "400";
                    break;
                case "light":
                case "thin":
                    fWeight = "200";
                    break;
                default:
                    break;
            }
        }
        return {
            style: fStyle,
            weight: fontData.fWeight || fWeight
        };
    }
    var FontManager = function() {
        var maxWaitingTime = 5000;
        var emptyChar = {
            w: 0,
            size: 0,
            shapes: [],
            data: {
                shapes: []
            }
        };
        var combinedCharacters = []; // Hindi characters
        combinedCharacters = combinedCharacters.concat([
            2304,
            2305,
            2306,
            2307,
            2362,
            2363,
            2364,
            2364,
            2366,
            2367,
            2368,
            2369,
            2370,
            2371,
            2372,
            2373,
            2374,
            2375,
            2376,
            2377,
            2378,
            2379,
            2380,
            2381,
            2382,
            2383,
            2387,
            2388,
            2389,
            2390,
            2391,
            2402,
            2403
        ]);
        var surrogateModifiers = [
            "d83cdffb",
            "d83cdffc",
            "d83cdffd",
            "d83cdffe",
            "d83cdfff"
        ];
        var zeroWidthJoiner = [
            65039,
            8205
        ];
        function trimFontOptions(font) {
            var familyArray = font.split(",");
            var i;
            var len = familyArray.length;
            var enabledFamilies = [];
            for(i = 0; i < len; i += 1)if (familyArray[i] !== "sans-serif" && familyArray[i] !== "monospace") enabledFamilies.push(familyArray[i]);
            return enabledFamilies.join(",");
        }
        function setUpNode(font, family) {
            var parentNode = createTag("span"); // Node is invisible to screen readers.
            parentNode.setAttribute("aria-hidden", true);
            parentNode.style.fontFamily = family;
            var node = createTag("span"); // Characters that vary significantly among different fonts
            node.innerText = "giItT1WQy@!-/#"; // Visible - so we can measure it - but not on the screen
            parentNode.style.position = "absolute";
            parentNode.style.left = "-10000px";
            parentNode.style.top = "-10000px"; // Large font size makes even subtle changes obvious
            parentNode.style.fontSize = "300px"; // Reset any font properties
            parentNode.style.fontVariant = "normal";
            parentNode.style.fontStyle = "normal";
            parentNode.style.fontWeight = "normal";
            parentNode.style.letterSpacing = "0";
            parentNode.appendChild(node);
            document.body.appendChild(parentNode); // Remember width with no applied web font
            var width = node.offsetWidth;
            node.style.fontFamily = trimFontOptions(font) + ", " + family;
            return {
                node: node,
                w: width,
                parent: parentNode
            };
        }
        function checkLoadedFonts() {
            var i;
            var len = this.fonts.length;
            var node;
            var w;
            var loadedCount = len;
            for(i = 0; i < len; i += 1){
                if (this.fonts[i].loaded) loadedCount -= 1;
                else if (this.fonts[i].fOrigin === "n" || this.fonts[i].origin === 0) this.fonts[i].loaded = true;
                else {
                    node = this.fonts[i].monoCase.node;
                    w = this.fonts[i].monoCase.w;
                    if (node.offsetWidth !== w) {
                        loadedCount -= 1;
                        this.fonts[i].loaded = true;
                    } else {
                        node = this.fonts[i].sansCase.node;
                        w = this.fonts[i].sansCase.w;
                        if (node.offsetWidth !== w) {
                            loadedCount -= 1;
                            this.fonts[i].loaded = true;
                        }
                    }
                    if (this.fonts[i].loaded) {
                        this.fonts[i].sansCase.parent.parentNode.removeChild(this.fonts[i].sansCase.parent);
                        this.fonts[i].monoCase.parent.parentNode.removeChild(this.fonts[i].monoCase.parent);
                    }
                }
            }
            if (loadedCount !== 0 && Date.now() - this.initTime < maxWaitingTime) setTimeout(this.checkLoadedFontsBinded, 20);
            else setTimeout(this.setIsLoadedBinded, 10);
        }
        function createHelper(fontData, def) {
            var engine = document.body && def ? "svg" : "canvas";
            var helper;
            var fontProps = getFontProperties(fontData);
            if (engine === "svg") {
                var tHelper = createNS("text");
                tHelper.style.fontSize = "100px"; // tHelper.style.fontFamily = fontData.fFamily;
                tHelper.setAttribute("font-family", fontData.fFamily);
                tHelper.setAttribute("font-style", fontProps.style);
                tHelper.setAttribute("font-weight", fontProps.weight);
                tHelper.textContent = "1";
                if (fontData.fClass) {
                    tHelper.style.fontFamily = "inherit";
                    tHelper.setAttribute("class", fontData.fClass);
                } else tHelper.style.fontFamily = fontData.fFamily;
                def.appendChild(tHelper);
                helper = tHelper;
            } else {
                var tCanvasHelper = new OffscreenCanvas(500, 500).getContext("2d");
                tCanvasHelper.font = fontProps.style + " " + fontProps.weight + " 100px " + fontData.fFamily;
                helper = tCanvasHelper;
            }
            function measure(text) {
                if (engine === "svg") {
                    helper.textContent = text;
                    return helper.getComputedTextLength();
                }
                return helper.measureText(text).width;
            }
            return {
                measureText: measure
            };
        }
        function addFonts(fontData, defs) {
            if (!fontData) {
                this.isLoaded = true;
                return;
            }
            if (this.chars) {
                this.isLoaded = true;
                this.fonts = fontData.list;
                return;
            }
            if (!document.body) {
                this.isLoaded = true;
                fontData.list.forEach(function(data) {
                    data.helper = createHelper(data);
                    data.cache = {};
                });
                this.fonts = fontData.list;
                return;
            }
            var fontArr = fontData.list;
            var i;
            var len = fontArr.length;
            var _pendingFonts = len;
            for(i = 0; i < len; i += 1){
                var shouldLoadFont = true;
                var loadedSelector;
                var j;
                fontArr[i].loaded = false;
                fontArr[i].monoCase = setUpNode(fontArr[i].fFamily, "monospace");
                fontArr[i].sansCase = setUpNode(fontArr[i].fFamily, "sans-serif");
                if (!fontArr[i].fPath) {
                    fontArr[i].loaded = true;
                    _pendingFonts -= 1;
                } else if (fontArr[i].fOrigin === "p" || fontArr[i].origin === 3) {
                    loadedSelector = document.querySelectorAll('style[f-forigin="p"][f-family="' + fontArr[i].fFamily + '"], style[f-origin="3"][f-family="' + fontArr[i].fFamily + '"]');
                    if (loadedSelector.length > 0) shouldLoadFont = false;
                    if (shouldLoadFont) {
                        var s = createTag("style");
                        s.setAttribute("f-forigin", fontArr[i].fOrigin);
                        s.setAttribute("f-origin", fontArr[i].origin);
                        s.setAttribute("f-family", fontArr[i].fFamily);
                        s.type = "text/css";
                        s.innerText = "@font-face {font-family: " + fontArr[i].fFamily + "; font-style: normal; src: url('" + fontArr[i].fPath + "');}";
                        defs.appendChild(s);
                    }
                } else if (fontArr[i].fOrigin === "g" || fontArr[i].origin === 1) {
                    loadedSelector = document.querySelectorAll('link[f-forigin="g"], link[f-origin="1"]');
                    for(j = 0; j < loadedSelector.length; j += 1)if (loadedSelector[j].href.indexOf(fontArr[i].fPath) !== -1) // Font is already loaded
                    shouldLoadFont = false;
                    if (shouldLoadFont) {
                        var l = createTag("link");
                        l.setAttribute("f-forigin", fontArr[i].fOrigin);
                        l.setAttribute("f-origin", fontArr[i].origin);
                        l.type = "text/css";
                        l.rel = "stylesheet";
                        l.href = fontArr[i].fPath;
                        document.body.appendChild(l);
                    }
                } else if (fontArr[i].fOrigin === "t" || fontArr[i].origin === 2) {
                    loadedSelector = document.querySelectorAll('script[f-forigin="t"], script[f-origin="2"]');
                    for(j = 0; j < loadedSelector.length; j += 1)if (fontArr[i].fPath === loadedSelector[j].src) // Font is already loaded
                    shouldLoadFont = false;
                    if (shouldLoadFont) {
                        var sc = createTag("link");
                        sc.setAttribute("f-forigin", fontArr[i].fOrigin);
                        sc.setAttribute("f-origin", fontArr[i].origin);
                        sc.setAttribute("rel", "stylesheet");
                        sc.setAttribute("href", fontArr[i].fPath);
                        defs.appendChild(sc);
                    }
                }
                fontArr[i].helper = createHelper(fontArr[i], defs);
                fontArr[i].cache = {};
                this.fonts.push(fontArr[i]);
            }
            if (_pendingFonts === 0) this.isLoaded = true;
            else // On some cases even if the font is loaded, it won't load correctly when measuring text on canvas.
            // Adding this timeout seems to fix it
            setTimeout(this.checkLoadedFonts.bind(this), 100);
        }
        function addChars(chars) {
            if (!chars) return;
            if (!this.chars) this.chars = [];
            var i;
            var len = chars.length;
            var j;
            var jLen = this.chars.length;
            var found;
            for(i = 0; i < len; i += 1){
                j = 0;
                found = false;
                while(j < jLen){
                    if (this.chars[j].style === chars[i].style && this.chars[j].fFamily === chars[i].fFamily && this.chars[j].ch === chars[i].ch) found = true;
                    j += 1;
                }
                if (!found) {
                    this.chars.push(chars[i]);
                    jLen += 1;
                }
            }
        }
        function getCharData(_char, style, font) {
            var i = 0;
            var len = this.chars.length;
            while(i < len){
                if (this.chars[i].ch === _char && this.chars[i].style === style && this.chars[i].fFamily === font) return this.chars[i];
                i += 1;
            }
            if ((typeof _char === "string" && _char.charCodeAt(0) !== 13 || !_char) && console && console.warn // eslint-disable-line no-console
             && !this._warned) {
                this._warned = true;
                console.warn("Missing character from exported characters list: ", _char, style, font); // eslint-disable-line no-console
            }
            return emptyChar;
        }
        function measureText(_char2, fontName, size) {
            var fontData = this.getFontByName(fontName);
            var index = _char2.charCodeAt(0);
            if (!fontData.cache[index + 1]) {
                var tHelper = fontData.helper;
                if (_char2 === " ") {
                    var doubleSize = tHelper.measureText("|" + _char2 + "|");
                    var singleSize = tHelper.measureText("||");
                    fontData.cache[index + 1] = (doubleSize - singleSize) / 100;
                } else fontData.cache[index + 1] = tHelper.measureText(_char2) / 100;
            }
            return fontData.cache[index + 1] * size;
        }
        function getFontByName(name) {
            var i = 0;
            var len = this.fonts.length;
            while(i < len){
                if (this.fonts[i].fName === name) return this.fonts[i];
                i += 1;
            }
            return this.fonts[0];
        }
        function isModifier(firstCharCode, secondCharCode) {
            var sum = firstCharCode.toString(16) + secondCharCode.toString(16);
            return surrogateModifiers.indexOf(sum) !== -1;
        }
        function isZeroWidthJoiner(firstCharCode, secondCharCode) {
            if (!secondCharCode) return firstCharCode === zeroWidthJoiner[1];
            return firstCharCode === zeroWidthJoiner[0] && secondCharCode === zeroWidthJoiner[1];
        }
        function isCombinedCharacter(_char3) {
            return combinedCharacters.indexOf(_char3) !== -1;
        }
        function setIsLoaded() {
            this.isLoaded = true;
        }
        var Font = function Font() {
            this.fonts = [];
            this.chars = null;
            this.typekitLoaded = 0;
            this.isLoaded = false;
            this._warned = false;
            this.initTime = Date.now();
            this.setIsLoadedBinded = this.setIsLoaded.bind(this);
            this.checkLoadedFontsBinded = this.checkLoadedFonts.bind(this);
        };
        Font.isModifier = isModifier;
        Font.isZeroWidthJoiner = isZeroWidthJoiner;
        Font.isCombinedCharacter = isCombinedCharacter;
        var fontPrototype = {
            addChars: addChars,
            addFonts: addFonts,
            getCharData: getCharData,
            getFontByName: getFontByName,
            measureText: measureText,
            checkLoadedFonts: checkLoadedFonts,
            setIsLoaded: setIsLoaded
        };
        Font.prototype = fontPrototype;
        return Font;
    }();
    function RenderableElement() {}
    RenderableElement.prototype = {
        initRenderable: function initRenderable() {
            // layer's visibility related to inpoint and outpoint. Rename isVisible to isInRange
            this.isInRange = false; // layer's display state
            this.hidden = false; // If layer's transparency equals 0, it can be hidden
            this.isTransparent = false; // list of animated components
            this.renderableComponents = [];
        },
        addRenderableComponent: function addRenderableComponent(component) {
            if (this.renderableComponents.indexOf(component) === -1) this.renderableComponents.push(component);
        },
        removeRenderableComponent: function removeRenderableComponent(component) {
            if (this.renderableComponents.indexOf(component) !== -1) this.renderableComponents.splice(this.renderableComponents.indexOf(component), 1);
        },
        prepareRenderableFrame: function prepareRenderableFrame(num) {
            this.checkLayerLimits(num);
        },
        checkTransparency: function checkTransparency() {
            if (this.finalTransform.mProp.o.v <= 0) {
                if (!this.isTransparent && this.globalData.renderConfig.hideOnTransparent) {
                    this.isTransparent = true;
                    this.hide();
                }
            } else if (this.isTransparent) {
                this.isTransparent = false;
                this.show();
            }
        },
        /**
       * @function
       * Initializes frame related properties.
       *
       * @param {number} num
       * current frame number in Layer's time
       *
       */ checkLayerLimits: function checkLayerLimits(num) {
            if (this.data.ip - this.data.st <= num && this.data.op - this.data.st > num) {
                if (this.isInRange !== true) {
                    this.globalData._mdf = true;
                    this._mdf = true;
                    this.isInRange = true;
                    this.show();
                }
            } else if (this.isInRange !== false) {
                this.globalData._mdf = true;
                this.isInRange = false;
                this.hide();
            }
        },
        renderRenderable: function renderRenderable() {
            var i;
            var len = this.renderableComponents.length;
            for(i = 0; i < len; i += 1)this.renderableComponents[i].renderFrame(this._isFirstFrame);
        /* this.maskManager.renderFrame(this.finalTransform.mat);
          this.renderableEffectsManager.renderFrame(this._isFirstFrame); */ },
        sourceRectAtTime: function sourceRectAtTime() {
            return {
                top: 0,
                left: 0,
                width: 100,
                height: 100
            };
        },
        getLayerSize: function getLayerSize() {
            if (this.data.ty === 5) return {
                w: this.data.textData.width,
                h: this.data.textData.height
            };
            return {
                w: this.data.width,
                h: this.data.height
            };
        }
    };
    var getBlendMode = function() {
        var blendModeEnums = {
            0: "source-over",
            1: "multiply",
            2: "screen",
            3: "overlay",
            4: "darken",
            5: "lighten",
            6: "color-dodge",
            7: "color-burn",
            8: "hard-light",
            9: "soft-light",
            10: "difference",
            11: "exclusion",
            12: "hue",
            13: "saturation",
            14: "color",
            15: "luminosity"
        };
        return function(mode) {
            return blendModeEnums[mode] || "";
        };
    }();
    function SliderEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 0, 0, container);
    }
    function AngleEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 0, 0, container);
    }
    function ColorEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 1, 0, container);
    }
    function PointEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 1, 0, container);
    }
    function LayerIndexEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 0, 0, container);
    }
    function MaskIndexEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 0, 0, container);
    }
    function CheckboxEffect(data, elem, container) {
        this.p = PropertyFactory.getProp(elem, data.v, 0, 0, container);
    }
    function NoValueEffect() {
        this.p = {};
    }
    function EffectsManager(data, element) {
        var effects = data.ef || [];
        this.effectElements = [];
        var i;
        var len = effects.length;
        var effectItem;
        for(i = 0; i < len; i += 1){
            effectItem = new GroupEffect(effects[i], element);
            this.effectElements.push(effectItem);
        }
    }
    function GroupEffect(data, element) {
        this.init(data, element);
    }
    extendPrototype([
        DynamicPropertyContainer
    ], GroupEffect);
    GroupEffect.prototype.getValue = GroupEffect.prototype.iterateDynamicProperties;
    GroupEffect.prototype.init = function(data, element) {
        this.data = data;
        this.effectElements = [];
        this.initDynamicPropertyContainer(element);
        var i;
        var len = this.data.ef.length;
        var eff;
        var effects = this.data.ef;
        for(i = 0; i < len; i += 1){
            eff = null;
            switch(effects[i].ty){
                case 0:
                    eff = new SliderEffect(effects[i], element, this);
                    break;
                case 1:
                    eff = new AngleEffect(effects[i], element, this);
                    break;
                case 2:
                    eff = new ColorEffect(effects[i], element, this);
                    break;
                case 3:
                    eff = new PointEffect(effects[i], element, this);
                    break;
                case 4:
                case 7:
                    eff = new CheckboxEffect(effects[i], element, this);
                    break;
                case 10:
                    eff = new LayerIndexEffect(effects[i], element, this);
                    break;
                case 11:
                    eff = new MaskIndexEffect(effects[i], element, this);
                    break;
                case 5:
                    eff = new EffectsManager(effects[i], element, this);
                    break;
                // case 6:
                default:
                    eff = new NoValueEffect(effects[i], element, this);
                    break;
            }
            if (eff) this.effectElements.push(eff);
        }
    };
    function BaseElement() {}
    BaseElement.prototype = {
        checkMasks: function checkMasks() {
            if (!this.data.hasMask) return false;
            var i = 0;
            var len = this.data.masksProperties.length;
            while(i < len){
                if (this.data.masksProperties[i].mode !== "n" && this.data.masksProperties[i].cl !== false) return true;
                i += 1;
            }
            return false;
        },
        initExpressions: function initExpressions() {
            var expressionsInterfaces = getExpressionInterfaces();
            if (!expressionsInterfaces) return;
            var LayerExpressionInterface = expressionsInterfaces("layer");
            var EffectsExpressionInterface = expressionsInterfaces("effects");
            var ShapeExpressionInterface = expressionsInterfaces("shape");
            var TextExpressionInterface = expressionsInterfaces("text");
            var CompExpressionInterface = expressionsInterfaces("comp");
            this.layerInterface = LayerExpressionInterface(this);
            if (this.data.hasMask && this.maskManager) this.layerInterface.registerMaskInterface(this.maskManager);
            var effectsInterface = EffectsExpressionInterface.createEffectsInterface(this, this.layerInterface);
            this.layerInterface.registerEffectsInterface(effectsInterface);
            if (this.data.ty === 0 || this.data.xt) this.compInterface = CompExpressionInterface(this);
            else if (this.data.ty === 4) {
                this.layerInterface.shapeInterface = ShapeExpressionInterface(this.shapesData, this.itemsData, this.layerInterface);
                this.layerInterface.content = this.layerInterface.shapeInterface;
            } else if (this.data.ty === 5) {
                this.layerInterface.textInterface = TextExpressionInterface(this);
                this.layerInterface.text = this.layerInterface.textInterface;
            }
        },
        setBlendMode: function setBlendMode() {
            var blendModeValue = getBlendMode(this.data.bm);
            var elem = this.baseElement || this.layerElement;
            elem.style["mix-blend-mode"] = blendModeValue;
        },
        initBaseData: function initBaseData(data, globalData, comp) {
            this.globalData = globalData;
            this.comp = comp;
            this.data = data;
            this.layerId = createElementID(); // Stretch factor for old animations missing this property.
            if (!this.data.sr) this.data.sr = 1;
             // effects manager
            this.effectsManager = new EffectsManager(this.data, this, this.dynamicProperties);
        },
        getType: function getType() {
            return this.type;
        },
        sourceRectAtTime: function sourceRectAtTime() {}
    };
    /**
   * @file
   * Handles element's layer frame update.
   * Checks layer in point and out point
   *
   */ function FrameElement() {}
    FrameElement.prototype = {
        /**
       * @function
       * Initializes frame related properties.
       *
       */ initFrame: function initFrame() {
            // set to true when inpoint is rendered
            this._isFirstFrame = false; // list of animated properties
            this.dynamicProperties = []; // If layer has been modified in current tick this will be true
            this._mdf = false;
        },
        /**
       * @function
       * Calculates all dynamic values
       *
       * @param {number} num
       * current frame number in Layer's time
       * @param {boolean} isVisible
       * if layers is currently in range
       *
       */ prepareProperties: function prepareProperties(num, isVisible) {
            var i;
            var len = this.dynamicProperties.length;
            for(i = 0; i < len; i += 1)if (isVisible || this._isParent && this.dynamicProperties[i].propType === "transform") {
                this.dynamicProperties[i].getValue();
                if (this.dynamicProperties[i]._mdf) {
                    this.globalData._mdf = true;
                    this._mdf = true;
                }
            }
        },
        addDynamicProperty: function addDynamicProperty(prop) {
            if (this.dynamicProperties.indexOf(prop) === -1) this.dynamicProperties.push(prop);
        }
    };
    function FootageElement(data, globalData, comp) {
        this.initFrame();
        this.initRenderable();
        this.assetData = globalData.getAssetData(data.refId);
        this.footageData = globalData.imageLoader.getAsset(this.assetData);
        this.initBaseData(data, globalData, comp);
    }
    FootageElement.prototype.prepareFrame = function() {};
    extendPrototype([
        RenderableElement,
        BaseElement,
        FrameElement
    ], FootageElement);
    FootageElement.prototype.getBaseElement = function() {
        return null;
    };
    FootageElement.prototype.renderFrame = function() {};
    FootageElement.prototype.destroy = function() {};
    FootageElement.prototype.initExpressions = function() {
        var expressionsInterfaces = getExpressionInterfaces();
        if (!expressionsInterfaces) return;
        var FootageInterface = expressionsInterfaces("footage");
        this.layerInterface = FootageInterface(this);
    };
    FootageElement.prototype.getFootageData = function() {
        return this.footageData;
    };
    function AudioElement(data, globalData, comp) {
        this.initFrame();
        this.initRenderable();
        this.assetData = globalData.getAssetData(data.refId);
        this.initBaseData(data, globalData, comp);
        this._isPlaying = false;
        this._canPlay = false;
        var assetPath = this.globalData.getAssetsPath(this.assetData);
        this.audio = this.globalData.audioController.createAudio(assetPath);
        this._currentTime = 0;
        this.globalData.audioController.addAudio(this);
        this._volumeMultiplier = 1;
        this._volume = 1;
        this._previousVolume = null;
        this.tm = data.tm ? PropertyFactory.getProp(this, data.tm, 0, globalData.frameRate, this) : {
            _placeholder: true
        };
        this.lv = PropertyFactory.getProp(this, data.au && data.au.lv ? data.au.lv : {
            k: [
                100
            ]
        }, 1, 0.01, this);
    }
    AudioElement.prototype.prepareFrame = function(num) {
        this.prepareRenderableFrame(num, true);
        this.prepareProperties(num, true);
        if (!this.tm._placeholder) {
            var timeRemapped = this.tm.v;
            this._currentTime = timeRemapped;
        } else this._currentTime = num / this.data.sr;
        this._volume = this.lv.v[0];
        var totalVolume = this._volume * this._volumeMultiplier;
        if (this._previousVolume !== totalVolume) {
            this._previousVolume = totalVolume;
            this.audio.volume(totalVolume);
        }
    };
    extendPrototype([
        RenderableElement,
        BaseElement,
        FrameElement
    ], AudioElement);
    AudioElement.prototype.renderFrame = function() {
        if (this.isInRange && this._canPlay) {
            if (!this._isPlaying) {
                this.audio.play();
                this.audio.seek(this._currentTime / this.globalData.frameRate);
                this._isPlaying = true;
            } else if (!this.audio.playing() || Math.abs(this._currentTime / this.globalData.frameRate - this.audio.seek()) > 0.1) this.audio.seek(this._currentTime / this.globalData.frameRate);
        }
    };
    AudioElement.prototype.show = function() {};
    AudioElement.prototype.hide = function() {
        this.audio.pause();
        this._isPlaying = false;
    };
    AudioElement.prototype.pause = function() {
        this.audio.pause();
        this._isPlaying = false;
        this._canPlay = false;
    };
    AudioElement.prototype.resume = function() {
        this._canPlay = true;
    };
    AudioElement.prototype.setRate = function(rateValue) {
        this.audio.rate(rateValue);
    };
    AudioElement.prototype.volume = function(volumeValue) {
        this._volumeMultiplier = volumeValue;
        this._previousVolume = volumeValue * this._volume;
        this.audio.volume(this._previousVolume);
    };
    AudioElement.prototype.getBaseElement = function() {
        return null;
    };
    AudioElement.prototype.destroy = function() {};
    AudioElement.prototype.sourceRectAtTime = function() {};
    AudioElement.prototype.initExpressions = function() {};
    function BaseRenderer() {}
    BaseRenderer.prototype.checkLayers = function(num) {
        var i;
        var len = this.layers.length;
        var data;
        this.completeLayers = true;
        for(i = len - 1; i >= 0; i -= 1){
            if (!this.elements[i]) {
                data = this.layers[i];
                if (data.ip - data.st <= num - this.layers[i].st && data.op - data.st > num - this.layers[i].st) this.buildItem(i);
            }
            this.completeLayers = this.elements[i] ? this.completeLayers : false;
        }
        this.checkPendingElements();
    };
    BaseRenderer.prototype.createItem = function(layer) {
        switch(layer.ty){
            case 2:
                return this.createImage(layer);
            case 0:
                return this.createComp(layer);
            case 1:
                return this.createSolid(layer);
            case 3:
                return this.createNull(layer);
            case 4:
                return this.createShape(layer);
            case 5:
                return this.createText(layer);
            case 6:
                return this.createAudio(layer);
            case 13:
                return this.createCamera(layer);
            case 15:
                return this.createFootage(layer);
            default:
                return this.createNull(layer);
        }
    };
    BaseRenderer.prototype.createCamera = function() {
        throw new Error("You're using a 3d camera. Try the html renderer.");
    };
    BaseRenderer.prototype.createAudio = function(data) {
        return new AudioElement(data, this.globalData, this);
    };
    BaseRenderer.prototype.createFootage = function(data) {
        return new FootageElement(data, this.globalData, this);
    };
    BaseRenderer.prototype.buildAllItems = function() {
        var i;
        var len = this.layers.length;
        for(i = 0; i < len; i += 1)this.buildItem(i);
        this.checkPendingElements();
    };
    BaseRenderer.prototype.includeLayers = function(newLayers) {
        this.completeLayers = false;
        var i;
        var len = newLayers.length;
        var j;
        var jLen = this.layers.length;
        for(i = 0; i < len; i += 1){
            j = 0;
            while(j < jLen){
                if (this.layers[j].id === newLayers[i].id) {
                    this.layers[j] = newLayers[i];
                    break;
                }
                j += 1;
            }
        }
    };
    BaseRenderer.prototype.setProjectInterface = function(pInterface) {
        this.globalData.projectInterface = pInterface;
    };
    BaseRenderer.prototype.initItems = function() {
        if (!this.globalData.progressiveLoad) this.buildAllItems();
    };
    BaseRenderer.prototype.buildElementParenting = function(element, parentName, hierarchy) {
        var elements = this.elements;
        var layers = this.layers;
        var i = 0;
        var len = layers.length;
        while(i < len){
            if (layers[i].ind == parentName) {
                // eslint-disable-line eqeqeq
                if (!elements[i] || elements[i] === true) {
                    this.buildItem(i);
                    this.addPendingElement(element);
                } else {
                    hierarchy.push(elements[i]);
                    elements[i].setAsParent();
                    if (layers[i].parent !== undefined) this.buildElementParenting(element, layers[i].parent, hierarchy);
                    else element.setHierarchy(hierarchy);
                }
            }
            i += 1;
        }
    };
    BaseRenderer.prototype.addPendingElement = function(element) {
        this.pendingElements.push(element);
    };
    BaseRenderer.prototype.searchExtraCompositions = function(assets) {
        var i;
        var len = assets.length;
        for(i = 0; i < len; i += 1)if (assets[i].xt) {
            var comp = this.createComp(assets[i]);
            comp.initExpressions();
            this.globalData.projectInterface.registerComposition(comp);
        }
    };
    BaseRenderer.prototype.getElementById = function(ind) {
        var i;
        var len = this.elements.length;
        for(i = 0; i < len; i += 1){
            if (this.elements[i].data.ind === ind) return this.elements[i];
        }
        return null;
    };
    BaseRenderer.prototype.getElementByPath = function(path) {
        var pathValue = path.shift();
        var element;
        if (typeof pathValue === "number") element = this.elements[pathValue];
        else {
            var i;
            var len = this.elements.length;
            for(i = 0; i < len; i += 1)if (this.elements[i].data.nm === pathValue) {
                element = this.elements[i];
                break;
            }
        }
        if (path.length === 0) return element;
        return element.getElementByPath(path);
    };
    BaseRenderer.prototype.setupGlobalData = function(animData, fontsContainer) {
        this.globalData.fontManager = new FontManager();
        this.globalData.fontManager.addChars(animData.chars);
        this.globalData.fontManager.addFonts(animData.fonts, fontsContainer);
        this.globalData.getAssetData = this.animationItem.getAssetData.bind(this.animationItem);
        this.globalData.getAssetsPath = this.animationItem.getAssetsPath.bind(this.animationItem);
        this.globalData.imageLoader = this.animationItem.imagePreloader;
        this.globalData.audioController = this.animationItem.audioController;
        this.globalData.frameId = 0;
        this.globalData.frameRate = animData.fr;
        this.globalData.nm = animData.nm;
        this.globalData.compSize = {
            w: animData.w,
            h: animData.h
        };
    };
    function TransformElement() {}
    TransformElement.prototype = {
        initTransform: function initTransform() {
            this.finalTransform = {
                mProp: this.data.ks ? TransformPropertyFactory.getTransformProperty(this, this.data.ks, this) : {
                    o: 0
                },
                _matMdf: false,
                _opMdf: false,
                mat: new Matrix()
            };
            if (this.data.ao) this.finalTransform.mProp.autoOriented = true;
             // TODO: check TYPE 11: Guided elements
            this.data.ty;
        },
        renderTransform: function renderTransform() {
            this.finalTransform._opMdf = this.finalTransform.mProp.o._mdf || this._isFirstFrame;
            this.finalTransform._matMdf = this.finalTransform.mProp._mdf || this._isFirstFrame;
            if (this.hierarchy) {
                var mat;
                var finalMat = this.finalTransform.mat;
                var i = 0;
                var len = this.hierarchy.length; // Checking if any of the transformation matrices in the hierarchy chain has changed.
                if (!this.finalTransform._matMdf) while(i < len){
                    if (this.hierarchy[i].finalTransform.mProp._mdf) {
                        this.finalTransform._matMdf = true;
                        break;
                    }
                    i += 1;
                }
                if (this.finalTransform._matMdf) {
                    mat = this.finalTransform.mProp.v.props;
                    finalMat.cloneFromProps(mat);
                    for(i = 0; i < len; i += 1){
                        mat = this.hierarchy[i].finalTransform.mProp.v.props;
                        finalMat.transform(mat[0], mat[1], mat[2], mat[3], mat[4], mat[5], mat[6], mat[7], mat[8], mat[9], mat[10], mat[11], mat[12], mat[13], mat[14], mat[15]);
                    }
                }
            }
        },
        globalToLocal: function globalToLocal(pt) {
            var transforms = [];
            transforms.push(this.finalTransform);
            var flag = true;
            var comp = this.comp;
            while(flag)if (comp.finalTransform) {
                if (comp.data.hasMask) transforms.splice(0, 0, comp.finalTransform);
                comp = comp.comp;
            } else flag = false;
            var i;
            var len = transforms.length;
            var ptNew;
            for(i = 0; i < len; i += 1){
                ptNew = transforms[i].mat.applyToPointArray(0, 0, 0); // ptNew = transforms[i].mat.applyToPointArray(pt[0],pt[1],pt[2]);
                pt = [
                    pt[0] - ptNew[0],
                    pt[1] - ptNew[1],
                    0
                ];
            }
            return pt;
        },
        mHelper: new Matrix()
    };
    function MaskElement(data, element, globalData) {
        this.data = data;
        this.element = element;
        this.globalData = globalData;
        this.storedData = [];
        this.masksProperties = this.data.masksProperties || [];
        this.maskElement = null;
        var defs = this.globalData.defs;
        var i;
        var len = this.masksProperties ? this.masksProperties.length : 0;
        this.viewData = createSizedArray(len);
        this.solidPath = "";
        var path;
        var properties = this.masksProperties;
        var count = 0;
        var currentMasks = [];
        var j;
        var jLen;
        var layerId = createElementID();
        var rect;
        var expansor;
        var feMorph;
        var x;
        var maskType = "clipPath";
        var maskRef = "clip-path";
        for(i = 0; i < len; i += 1){
            if (properties[i].mode !== "a" && properties[i].mode !== "n" || properties[i].inv || properties[i].o.k !== 100 || properties[i].o.x) {
                maskType = "mask";
                maskRef = "mask";
            }
            if ((properties[i].mode === "s" || properties[i].mode === "i") && count === 0) {
                rect = createNS("rect");
                rect.setAttribute("fill", "#ffffff");
                rect.setAttribute("width", this.element.comp.data.w || 0);
                rect.setAttribute("height", this.element.comp.data.h || 0);
                currentMasks.push(rect);
            } else rect = null;
            path = createNS("path");
            if (properties[i].mode === "n") {
                // TODO move this to a factory or to a constructor
                this.viewData[i] = {
                    op: PropertyFactory.getProp(this.element, properties[i].o, 0, 0.01, this.element),
                    prop: ShapePropertyFactory.getShapeProp(this.element, properties[i], 3),
                    elem: path,
                    lastPath: ""
                };
                defs.appendChild(path);
            } else {
                count += 1;
                path.setAttribute("fill", properties[i].mode === "s" ? "#000000" : "#ffffff");
                path.setAttribute("clip-rule", "nonzero");
                var filterID;
                if (properties[i].x.k !== 0) {
                    maskType = "mask";
                    maskRef = "mask";
                    x = PropertyFactory.getProp(this.element, properties[i].x, 0, null, this.element);
                    filterID = createElementID();
                    expansor = createNS("filter");
                    expansor.setAttribute("id", filterID);
                    feMorph = createNS("feMorphology");
                    feMorph.setAttribute("operator", "erode");
                    feMorph.setAttribute("in", "SourceGraphic");
                    feMorph.setAttribute("radius", "0");
                    expansor.appendChild(feMorph);
                    defs.appendChild(expansor);
                    path.setAttribute("stroke", properties[i].mode === "s" ? "#000000" : "#ffffff");
                } else {
                    feMorph = null;
                    x = null;
                } // TODO move this to a factory or to a constructor
                this.storedData[i] = {
                    elem: path,
                    x: x,
                    expan: feMorph,
                    lastPath: "",
                    lastOperator: "",
                    filterId: filterID,
                    lastRadius: 0
                };
                if (properties[i].mode === "i") {
                    jLen = currentMasks.length;
                    var g = createNS("g");
                    for(j = 0; j < jLen; j += 1)g.appendChild(currentMasks[j]);
                    var mask = createNS("mask");
                    mask.setAttribute("mask-type", "alpha");
                    mask.setAttribute("id", layerId + "_" + count);
                    mask.appendChild(path);
                    defs.appendChild(mask);
                    g.setAttribute("mask", "url(" + getLocationHref() + "#" + layerId + "_" + count + ")");
                    currentMasks.length = 0;
                    currentMasks.push(g);
                } else currentMasks.push(path);
                if (properties[i].inv && !this.solidPath) this.solidPath = this.createLayerSolidPath();
                 // TODO move this to a factory or to a constructor
                this.viewData[i] = {
                    elem: path,
                    lastPath: "",
                    op: PropertyFactory.getProp(this.element, properties[i].o, 0, 0.01, this.element),
                    prop: ShapePropertyFactory.getShapeProp(this.element, properties[i], 3),
                    invRect: rect
                };
                if (!this.viewData[i].prop.k) this.drawPath(properties[i], this.viewData[i].prop.v, this.viewData[i]);
            }
        }
        this.maskElement = createNS(maskType);
        len = currentMasks.length;
        for(i = 0; i < len; i += 1)this.maskElement.appendChild(currentMasks[i]);
        if (count > 0) {
            this.maskElement.setAttribute("id", layerId);
            this.element.maskedElement.setAttribute(maskRef, "url(" + getLocationHref() + "#" + layerId + ")");
            defs.appendChild(this.maskElement);
        }
        if (this.viewData.length) this.element.addRenderableComponent(this);
    }
    MaskElement.prototype.getMaskProperty = function(pos) {
        return this.viewData[pos].prop;
    };
    MaskElement.prototype.renderFrame = function(isFirstFrame) {
        var finalMat = this.element.finalTransform.mat;
        var i;
        var len = this.masksProperties.length;
        for(i = 0; i < len; i += 1){
            if (this.viewData[i].prop._mdf || isFirstFrame) this.drawPath(this.masksProperties[i], this.viewData[i].prop.v, this.viewData[i]);
            if (this.viewData[i].op._mdf || isFirstFrame) this.viewData[i].elem.setAttribute("fill-opacity", this.viewData[i].op.v);
            if (this.masksProperties[i].mode !== "n") {
                if (this.viewData[i].invRect && (this.element.finalTransform.mProp._mdf || isFirstFrame)) this.viewData[i].invRect.setAttribute("transform", finalMat.getInverseMatrix().to2dCSS());
                if (this.storedData[i].x && (this.storedData[i].x._mdf || isFirstFrame)) {
                    var feMorph = this.storedData[i].expan;
                    if (this.storedData[i].x.v < 0) {
                        if (this.storedData[i].lastOperator !== "erode") {
                            this.storedData[i].lastOperator = "erode";
                            this.storedData[i].elem.setAttribute("filter", "url(" + getLocationHref() + "#" + this.storedData[i].filterId + ")");
                        }
                        feMorph.setAttribute("radius", -this.storedData[i].x.v);
                    } else {
                        if (this.storedData[i].lastOperator !== "dilate") {
                            this.storedData[i].lastOperator = "dilate";
                            this.storedData[i].elem.setAttribute("filter", null);
                        }
                        this.storedData[i].elem.setAttribute("stroke-width", this.storedData[i].x.v * 2);
                    }
                }
            }
        }
    };
    MaskElement.prototype.getMaskelement = function() {
        return this.maskElement;
    };
    MaskElement.prototype.createLayerSolidPath = function() {
        var path = "M0,0 ";
        path += " h" + this.globalData.compSize.w;
        path += " v" + this.globalData.compSize.h;
        path += " h-" + this.globalData.compSize.w;
        path += " v-" + this.globalData.compSize.h + " ";
        return path;
    };
    MaskElement.prototype.drawPath = function(pathData, pathNodes, viewData) {
        var pathString = " M" + pathNodes.v[0][0] + "," + pathNodes.v[0][1];
        var i;
        var len;
        len = pathNodes._length;
        for(i = 1; i < len; i += 1)// pathString += " C"+pathNodes.o[i-1][0]+','+pathNodes.o[i-1][1] + " "+pathNodes.i[i][0]+','+pathNodes.i[i][1] + " "+pathNodes.v[i][0]+','+pathNodes.v[i][1];
        pathString += " C" + pathNodes.o[i - 1][0] + "," + pathNodes.o[i - 1][1] + " " + pathNodes.i[i][0] + "," + pathNodes.i[i][1] + " " + pathNodes.v[i][0] + "," + pathNodes.v[i][1];
         // pathString += " C"+pathNodes.o[i-1][0]+','+pathNodes.o[i-1][1] + " "+pathNodes.i[0][0]+','+pathNodes.i[0][1] + " "+pathNodes.v[0][0]+','+pathNodes.v[0][1];
        if (pathNodes.c && len > 1) pathString += " C" + pathNodes.o[i - 1][0] + "," + pathNodes.o[i - 1][1] + " " + pathNodes.i[0][0] + "," + pathNodes.i[0][1] + " " + pathNodes.v[0][0] + "," + pathNodes.v[0][1];
         // pathNodes.__renderedString = pathString;
        if (viewData.lastPath !== pathString) {
            var pathShapeValue = "";
            if (viewData.elem) {
                if (pathNodes.c) pathShapeValue = pathData.inv ? this.solidPath + pathString : pathString;
                viewData.elem.setAttribute("d", pathShapeValue);
            }
            viewData.lastPath = pathString;
        }
    };
    MaskElement.prototype.destroy = function() {
        this.element = null;
        this.globalData = null;
        this.maskElement = null;
        this.data = null;
        this.masksProperties = null;
    };
    var filtersFactory = function() {
        var ob = {};
        ob.createFilter = createFilter;
        ob.createAlphaToLuminanceFilter = createAlphaToLuminanceFilter;
        function createFilter(filId, skipCoordinates) {
            var fil = createNS("filter");
            fil.setAttribute("id", filId);
            if (skipCoordinates !== true) {
                fil.setAttribute("filterUnits", "objectBoundingBox");
                fil.setAttribute("x", "0%");
                fil.setAttribute("y", "0%");
                fil.setAttribute("width", "100%");
                fil.setAttribute("height", "100%");
            }
            return fil;
        }
        function createAlphaToLuminanceFilter() {
            var feColorMatrix = createNS("feColorMatrix");
            feColorMatrix.setAttribute("type", "matrix");
            feColorMatrix.setAttribute("color-interpolation-filters", "sRGB");
            feColorMatrix.setAttribute("values", "0 0 0 1 0  0 0 0 1 0  0 0 0 1 0  0 0 0 1 1");
            return feColorMatrix;
        }
        return ob;
    }();
    var featureSupport = function() {
        var ob = {
            maskType: true,
            svgLumaHidden: true,
            offscreenCanvas: typeof OffscreenCanvas !== "undefined"
        };
        if (/MSIE 10/i.test(navigator.userAgent) || /MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent) || /Edge\/\d./i.test(navigator.userAgent)) ob.maskType = false;
        if (/firefox/i.test(navigator.userAgent)) ob.svgLumaHidden = false;
        return ob;
    }();
    var registeredEffects = {};
    var idPrefix = "filter_result_";
    function SVGEffects(elem) {
        var i;
        var source = "SourceGraphic";
        var len = elem.data.ef ? elem.data.ef.length : 0;
        var filId = createElementID();
        var fil = filtersFactory.createFilter(filId, true);
        var count = 0;
        this.filters = [];
        var filterManager;
        for(i = 0; i < len; i += 1){
            filterManager = null;
            var type = elem.data.ef[i].ty;
            if (registeredEffects[type]) {
                var Effect = registeredEffects[type].effect;
                filterManager = new Effect(fil, elem.effectsManager.effectElements[i], elem, idPrefix + count, source);
                source = idPrefix + count;
                if (registeredEffects[type].countsAsEffect) count += 1;
            }
            if (filterManager) this.filters.push(filterManager);
        }
        if (count) {
            elem.globalData.defs.appendChild(fil);
            elem.layerElement.setAttribute("filter", "url(" + getLocationHref() + "#" + filId + ")");
        }
        if (this.filters.length) elem.addRenderableComponent(this);
    }
    SVGEffects.prototype.renderFrame = function(_isFirstFrame) {
        var i;
        var len = this.filters.length;
        for(i = 0; i < len; i += 1)this.filters[i].renderFrame(_isFirstFrame);
    };
    function registerEffect(id, effect, countsAsEffect) {
        registeredEffects[id] = {
            effect: effect,
            countsAsEffect: countsAsEffect
        };
    }
    function SVGBaseElement() {}
    SVGBaseElement.prototype = {
        initRendererElement: function initRendererElement() {
            this.layerElement = createNS("g");
        },
        createContainerElements: function createContainerElements() {
            this.matteElement = createNS("g");
            this.transformedElement = this.layerElement;
            this.maskedElement = this.layerElement;
            this._sizeChanged = false;
            var layerElementParent = null; // If this layer acts as a mask for the following layer
            if (this.data.td) {
                this.matteMasks = {};
                var gg = createNS("g");
                gg.setAttribute("id", this.layerId);
                gg.appendChild(this.layerElement);
                layerElementParent = gg;
                this.globalData.defs.appendChild(gg);
            } else if (this.data.tt) {
                this.matteElement.appendChild(this.layerElement);
                layerElementParent = this.matteElement;
                this.baseElement = this.matteElement;
            } else this.baseElement = this.layerElement;
            if (this.data.ln) this.layerElement.setAttribute("id", this.data.ln);
            if (this.data.cl) this.layerElement.setAttribute("class", this.data.cl);
             // Clipping compositions to hide content that exceeds boundaries. If collapsed transformations is on, component should not be clipped
            if (this.data.ty === 0 && !this.data.hd) {
                var cp = createNS("clipPath");
                var pt = createNS("path");
                pt.setAttribute("d", "M0,0 L" + this.data.w + ",0 L" + this.data.w + "," + this.data.h + " L0," + this.data.h + "z");
                var clipId = createElementID();
                cp.setAttribute("id", clipId);
                cp.appendChild(pt);
                this.globalData.defs.appendChild(cp);
                if (this.checkMasks()) {
                    var cpGroup = createNS("g");
                    cpGroup.setAttribute("clip-path", "url(" + getLocationHref() + "#" + clipId + ")");
                    cpGroup.appendChild(this.layerElement);
                    this.transformedElement = cpGroup;
                    if (layerElementParent) layerElementParent.appendChild(this.transformedElement);
                    else this.baseElement = this.transformedElement;
                } else this.layerElement.setAttribute("clip-path", "url(" + getLocationHref() + "#" + clipId + ")");
            }
            if (this.data.bm !== 0) this.setBlendMode();
        },
        renderElement: function renderElement() {
            if (this.finalTransform._matMdf) this.transformedElement.setAttribute("transform", this.finalTransform.mat.to2dCSS());
            if (this.finalTransform._opMdf) this.transformedElement.setAttribute("opacity", this.finalTransform.mProp.o.v);
        },
        destroyBaseElement: function destroyBaseElement() {
            this.layerElement = null;
            this.matteElement = null;
            this.maskManager.destroy();
        },
        getBaseElement: function getBaseElement() {
            if (this.data.hd) return null;
            return this.baseElement;
        },
        createRenderableComponents: function createRenderableComponents() {
            this.maskManager = new MaskElement(this.data, this, this.globalData);
            this.renderableEffectsManager = new SVGEffects(this);
        },
        getMatte: function getMatte(matteType) {
            // This should not be a common case. But for backward compatibility, we'll create the matte object.
            // It solves animations that have two consecutive layers marked as matte masks.
            // Which is an undefined behavior in AE.
            if (!this.matteMasks) this.matteMasks = {};
            if (!this.matteMasks[matteType]) {
                var id = this.layerId + "_" + matteType;
                var filId;
                var fil;
                var useElement;
                var gg;
                if (matteType === 1 || matteType === 3) {
                    var masker = createNS("mask");
                    masker.setAttribute("id", id);
                    masker.setAttribute("mask-type", matteType === 3 ? "luminance" : "alpha");
                    useElement = createNS("use");
                    useElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", "#" + this.layerId);
                    masker.appendChild(useElement);
                    this.globalData.defs.appendChild(masker);
                    if (!featureSupport.maskType && matteType === 1) {
                        masker.setAttribute("mask-type", "luminance");
                        filId = createElementID();
                        fil = filtersFactory.createFilter(filId);
                        this.globalData.defs.appendChild(fil);
                        fil.appendChild(filtersFactory.createAlphaToLuminanceFilter());
                        gg = createNS("g");
                        gg.appendChild(useElement);
                        masker.appendChild(gg);
                        gg.setAttribute("filter", "url(" + getLocationHref() + "#" + filId + ")");
                    }
                } else if (matteType === 2) {
                    var maskGroup = createNS("mask");
                    maskGroup.setAttribute("id", id);
                    maskGroup.setAttribute("mask-type", "alpha");
                    var maskGrouper = createNS("g");
                    maskGroup.appendChild(maskGrouper);
                    filId = createElementID();
                    fil = filtersFactory.createFilter(filId); /// /
                    var feCTr = createNS("feComponentTransfer");
                    feCTr.setAttribute("in", "SourceGraphic");
                    fil.appendChild(feCTr);
                    var feFunc = createNS("feFuncA");
                    feFunc.setAttribute("type", "table");
                    feFunc.setAttribute("tableValues", "1.0 0.0");
                    feCTr.appendChild(feFunc); /// /
                    this.globalData.defs.appendChild(fil);
                    var alphaRect = createNS("rect");
                    alphaRect.setAttribute("width", this.comp.data.w);
                    alphaRect.setAttribute("height", this.comp.data.h);
                    alphaRect.setAttribute("x", "0");
                    alphaRect.setAttribute("y", "0");
                    alphaRect.setAttribute("fill", "#ffffff");
                    alphaRect.setAttribute("opacity", "0");
                    maskGrouper.setAttribute("filter", "url(" + getLocationHref() + "#" + filId + ")");
                    maskGrouper.appendChild(alphaRect);
                    useElement = createNS("use");
                    useElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", "#" + this.layerId);
                    maskGrouper.appendChild(useElement);
                    if (!featureSupport.maskType) {
                        maskGroup.setAttribute("mask-type", "luminance");
                        fil.appendChild(filtersFactory.createAlphaToLuminanceFilter());
                        gg = createNS("g");
                        maskGrouper.appendChild(alphaRect);
                        gg.appendChild(this.layerElement);
                        maskGrouper.appendChild(gg);
                    }
                    this.globalData.defs.appendChild(maskGroup);
                }
                this.matteMasks[matteType] = id;
            }
            return this.matteMasks[matteType];
        },
        setMatte: function setMatte(id) {
            if (!this.matteElement) return;
            this.matteElement.setAttribute("mask", "url(" + getLocationHref() + "#" + id + ")");
        }
    };
    /**
   * @file
   * Handles AE's layer parenting property.
   *
   */ function HierarchyElement() {}
    HierarchyElement.prototype = {
        /**
       * @function
       * Initializes hierarchy properties
       *
       */ initHierarchy: function initHierarchy() {
            // element's parent list
            this.hierarchy = []; // if element is parent of another layer _isParent will be true
            this._isParent = false;
            this.checkParenting();
        },
        /**
       * @function
       * Sets layer's hierarchy.
       * @param {array} hierarch
       * layer's parent list
       *
       */ setHierarchy: function setHierarchy(hierarchy) {
            this.hierarchy = hierarchy;
        },
        /**
       * @function
       * Sets layer as parent.
       *
       */ setAsParent: function setAsParent() {
            this._isParent = true;
        },
        /**
       * @function
       * Searches layer's parenting chain
       *
       */ checkParenting: function checkParenting() {
            if (this.data.parent !== undefined) this.comp.buildElementParenting(this, this.data.parent, []);
        }
    };
    function RenderableDOMElement() {}
    (function() {
        var _prototype = {
            initElement: function initElement(data, globalData, comp) {
                this.initFrame();
                this.initBaseData(data, globalData, comp);
                this.initTransform(data, globalData, comp);
                this.initHierarchy();
                this.initRenderable();
                this.initRendererElement();
                this.createContainerElements();
                this.createRenderableComponents();
                this.createContent();
                this.hide();
            },
            hide: function hide() {
                // console.log('HIDE', this);
                if (!this.hidden && (!this.isInRange || this.isTransparent)) {
                    var elem = this.baseElement || this.layerElement;
                    elem.style.display = "none";
                    this.hidden = true;
                }
            },
            show: function show() {
                // console.log('SHOW', this);
                if (this.isInRange && !this.isTransparent) {
                    if (!this.data.hd) {
                        var elem = this.baseElement || this.layerElement;
                        elem.style.display = "block";
                    }
                    this.hidden = false;
                    this._isFirstFrame = true;
                }
            },
            renderFrame: function renderFrame() {
                // If it is exported as hidden (data.hd === true) no need to render
                // If it is not visible no need to render
                if (this.data.hd || this.hidden) return;
                this.renderTransform();
                this.renderRenderable();
                this.renderElement();
                this.renderInnerContent();
                if (this._isFirstFrame) this._isFirstFrame = false;
            },
            renderInnerContent: function renderInnerContent() {},
            prepareFrame: function prepareFrame(num) {
                this._mdf = false;
                this.prepareRenderableFrame(num);
                this.prepareProperties(num, this.isInRange);
                this.checkTransparency();
            },
            destroy: function destroy() {
                this.innerElem = null;
                this.destroyBaseElement();
            }
        };
        extendPrototype([
            RenderableElement,
            createProxyFunction(_prototype)
        ], RenderableDOMElement);
    })();
    function IImageElement(data, globalData, comp) {
        this.assetData = globalData.getAssetData(data.refId);
        this.initElement(data, globalData, comp);
        this.sourceRect = {
            top: 0,
            left: 0,
            width: this.assetData.w,
            height: this.assetData.h
        };
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        SVGBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement
    ], IImageElement);
    IImageElement.prototype.createContent = function() {
        var assetPath = this.globalData.getAssetsPath(this.assetData);
        this.innerElem = createNS("image");
        this.innerElem.setAttribute("width", this.assetData.w + "px");
        this.innerElem.setAttribute("height", this.assetData.h + "px");
        this.innerElem.setAttribute("preserveAspectRatio", this.assetData.pr || this.globalData.renderConfig.imagePreserveAspectRatio);
        this.innerElem.setAttributeNS("http://www.w3.org/1999/xlink", "href", assetPath);
        this.layerElement.appendChild(this.innerElem);
    };
    IImageElement.prototype.sourceRectAtTime = function() {
        return this.sourceRect;
    };
    function ProcessedElement(element, position) {
        this.elem = element;
        this.pos = position;
    }
    function IShapeElement() {}
    IShapeElement.prototype = {
        addShapeToModifiers: function addShapeToModifiers(data) {
            var i;
            var len = this.shapeModifiers.length;
            for(i = 0; i < len; i += 1)this.shapeModifiers[i].addShape(data);
        },
        isShapeInAnimatedModifiers: function isShapeInAnimatedModifiers(data) {
            var i = 0;
            var len = this.shapeModifiers.length;
            while(i < len){
                if (this.shapeModifiers[i].isAnimatedWithShape(data)) return true;
            }
            return false;
        },
        renderModifiers: function renderModifiers() {
            if (!this.shapeModifiers.length) return;
            var i;
            var len = this.shapes.length;
            for(i = 0; i < len; i += 1)this.shapes[i].sh.reset();
            len = this.shapeModifiers.length;
            var shouldBreakProcess;
            for(i = len - 1; i >= 0; i -= 1){
                shouldBreakProcess = this.shapeModifiers[i].processShapes(this._isFirstFrame); // workaround to fix cases where a repeater resets the shape so the following processes get called twice
                // TODO: find a better solution for this
                if (shouldBreakProcess) break;
            }
        },
        searchProcessedElement: function searchProcessedElement(elem) {
            var elements = this.processedElements;
            var i = 0;
            var len = elements.length;
            while(i < len){
                if (elements[i].elem === elem) return elements[i].pos;
                i += 1;
            }
            return 0;
        },
        addProcessedElement: function addProcessedElement(elem, pos) {
            var elements = this.processedElements;
            var i = elements.length;
            while(i){
                i -= 1;
                if (elements[i].elem === elem) {
                    elements[i].pos = pos;
                    return;
                }
            }
            elements.push(new ProcessedElement(elem, pos));
        },
        prepareFrame: function prepareFrame(num) {
            this.prepareRenderableFrame(num);
            this.prepareProperties(num, this.isInRange);
        }
    };
    var lineCapEnum = {
        1: "butt",
        2: "round",
        3: "square"
    };
    var lineJoinEnum = {
        1: "miter",
        2: "round",
        3: "bevel"
    };
    function SVGShapeData(transformers, level, shape) {
        this.caches = [];
        this.styles = [];
        this.transformers = transformers;
        this.lStr = "";
        this.sh = shape;
        this.lvl = level; // TODO find if there are some cases where _isAnimated can be false.
        // For now, since shapes add up with other shapes. They have to be calculated every time.
        // One way of finding out is checking if all styles associated to this shape depend only of this shape
        this._isAnimated = !!shape.k; // TODO: commenting this for now since all shapes are animated
        var i = 0;
        var len = transformers.length;
        while(i < len){
            if (transformers[i].mProps.dynamicProperties.length) {
                this._isAnimated = true;
                break;
            }
            i += 1;
        }
    }
    SVGShapeData.prototype.setAsAnimated = function() {
        this._isAnimated = true;
    };
    function SVGStyleData(data, level) {
        this.data = data;
        this.type = data.ty;
        this.d = "";
        this.lvl = level;
        this._mdf = false;
        this.closed = data.hd === true;
        this.pElem = createNS("path");
        this.msElem = null;
    }
    SVGStyleData.prototype.reset = function() {
        this.d = "";
        this._mdf = false;
    };
    function DashProperty(elem, data, renderer, container) {
        this.elem = elem;
        this.frameId = -1;
        this.dataProps = createSizedArray(data.length);
        this.renderer = renderer;
        this.k = false;
        this.dashStr = "";
        this.dashArray = createTypedArray("float32", data.length ? data.length - 1 : 0);
        this.dashoffset = createTypedArray("float32", 1);
        this.initDynamicPropertyContainer(container);
        var i;
        var len = data.length || 0;
        var prop;
        for(i = 0; i < len; i += 1){
            prop = PropertyFactory.getProp(elem, data[i].v, 0, 0, this);
            this.k = prop.k || this.k;
            this.dataProps[i] = {
                n: data[i].n,
                p: prop
            };
        }
        if (!this.k) this.getValue(true);
        this._isAnimated = this.k;
    }
    DashProperty.prototype.getValue = function(forceRender) {
        if (this.elem.globalData.frameId === this.frameId && !forceRender) return;
        this.frameId = this.elem.globalData.frameId;
        this.iterateDynamicProperties();
        this._mdf = this._mdf || forceRender;
        if (this._mdf) {
            var i = 0;
            var len = this.dataProps.length;
            if (this.renderer === "svg") this.dashStr = "";
            for(i = 0; i < len; i += 1)if (this.dataProps[i].n !== "o") {
                if (this.renderer === "svg") this.dashStr += " " + this.dataProps[i].p.v;
                else this.dashArray[i] = this.dataProps[i].p.v;
            } else this.dashoffset[0] = this.dataProps[i].p.v;
        }
    };
    extendPrototype([
        DynamicPropertyContainer
    ], DashProperty);
    function SVGStrokeStyleData(elem, data, styleOb) {
        this.initDynamicPropertyContainer(elem);
        this.getValue = this.iterateDynamicProperties;
        this.o = PropertyFactory.getProp(elem, data.o, 0, 0.01, this);
        this.w = PropertyFactory.getProp(elem, data.w, 0, null, this);
        this.d = new DashProperty(elem, data.d || {}, "svg", this);
        this.c = PropertyFactory.getProp(elem, data.c, 1, 255, this);
        this.style = styleOb;
        this._isAnimated = !!this._isAnimated;
    }
    extendPrototype([
        DynamicPropertyContainer
    ], SVGStrokeStyleData);
    function SVGFillStyleData(elem, data, styleOb) {
        this.initDynamicPropertyContainer(elem);
        this.getValue = this.iterateDynamicProperties;
        this.o = PropertyFactory.getProp(elem, data.o, 0, 0.01, this);
        this.c = PropertyFactory.getProp(elem, data.c, 1, 255, this);
        this.style = styleOb;
    }
    extendPrototype([
        DynamicPropertyContainer
    ], SVGFillStyleData);
    function SVGNoStyleData(elem, data, styleOb) {
        this.initDynamicPropertyContainer(elem);
        this.getValue = this.iterateDynamicProperties;
        this.style = styleOb;
    }
    extendPrototype([
        DynamicPropertyContainer
    ], SVGNoStyleData);
    function GradientProperty(elem, data, container) {
        this.data = data;
        this.c = createTypedArray("uint8c", data.p * 4);
        var cLength = data.k.k[0].s ? data.k.k[0].s.length - data.p * 4 : data.k.k.length - data.p * 4;
        this.o = createTypedArray("float32", cLength);
        this._cmdf = false;
        this._omdf = false;
        this._collapsable = this.checkCollapsable();
        this._hasOpacity = cLength;
        this.initDynamicPropertyContainer(container);
        this.prop = PropertyFactory.getProp(elem, data.k, 1, null, this);
        this.k = this.prop.k;
        this.getValue(true);
    }
    GradientProperty.prototype.comparePoints = function(values, points) {
        var i = 0;
        var len = this.o.length / 2;
        var diff;
        while(i < len){
            diff = Math.abs(values[i * 4] - values[points * 4 + i * 2]);
            if (diff > 0.01) return false;
            i += 1;
        }
        return true;
    };
    GradientProperty.prototype.checkCollapsable = function() {
        if (this.o.length / 2 !== this.c.length / 4) return false;
        if (this.data.k.k[0].s) {
            var i = 0;
            var len = this.data.k.k.length;
            while(i < len){
                if (!this.comparePoints(this.data.k.k[i].s, this.data.p)) return false;
                i += 1;
            }
        } else if (!this.comparePoints(this.data.k.k, this.data.p)) return false;
        return true;
    };
    GradientProperty.prototype.getValue = function(forceRender) {
        this.prop.getValue();
        this._mdf = false;
        this._cmdf = false;
        this._omdf = false;
        if (this.prop._mdf || forceRender) {
            var i;
            var len = this.data.p * 4;
            var mult;
            var val;
            for(i = 0; i < len; i += 1){
                mult = i % 4 === 0 ? 100 : 255;
                val = Math.round(this.prop.v[i] * mult);
                if (this.c[i] !== val) {
                    this.c[i] = val;
                    this._cmdf = !forceRender;
                }
            }
            if (this.o.length) {
                len = this.prop.v.length;
                for(i = this.data.p * 4; i < len; i += 1){
                    mult = i % 2 === 0 ? 100 : 1;
                    val = i % 2 === 0 ? Math.round(this.prop.v[i] * 100) : this.prop.v[i];
                    if (this.o[i - this.data.p * 4] !== val) {
                        this.o[i - this.data.p * 4] = val;
                        this._omdf = !forceRender;
                    }
                }
            }
            this._mdf = !forceRender;
        }
    };
    extendPrototype([
        DynamicPropertyContainer
    ], GradientProperty);
    function SVGGradientFillStyleData(elem, data, styleOb) {
        this.initDynamicPropertyContainer(elem);
        this.getValue = this.iterateDynamicProperties;
        this.initGradientData(elem, data, styleOb);
    }
    SVGGradientFillStyleData.prototype.initGradientData = function(elem, data, styleOb) {
        this.o = PropertyFactory.getProp(elem, data.o, 0, 0.01, this);
        this.s = PropertyFactory.getProp(elem, data.s, 1, null, this);
        this.e = PropertyFactory.getProp(elem, data.e, 1, null, this);
        this.h = PropertyFactory.getProp(elem, data.h || {
            k: 0
        }, 0, 0.01, this);
        this.a = PropertyFactory.getProp(elem, data.a || {
            k: 0
        }, 0, degToRads, this);
        this.g = new GradientProperty(elem, data.g, this);
        this.style = styleOb;
        this.stops = [];
        this.setGradientData(styleOb.pElem, data);
        this.setGradientOpacity(data, styleOb);
        this._isAnimated = !!this._isAnimated;
    };
    SVGGradientFillStyleData.prototype.setGradientData = function(pathElement, data) {
        var gradientId = createElementID();
        var gfill = createNS(data.t === 1 ? "linearGradient" : "radialGradient");
        gfill.setAttribute("id", gradientId);
        gfill.setAttribute("spreadMethod", "pad");
        gfill.setAttribute("gradientUnits", "userSpaceOnUse");
        var stops = [];
        var stop;
        var j;
        var jLen;
        jLen = data.g.p * 4;
        for(j = 0; j < jLen; j += 4){
            stop = createNS("stop");
            gfill.appendChild(stop);
            stops.push(stop);
        }
        pathElement.setAttribute(data.ty === "gf" ? "fill" : "stroke", "url(" + getLocationHref() + "#" + gradientId + ")");
        this.gf = gfill;
        this.cst = stops;
    };
    SVGGradientFillStyleData.prototype.setGradientOpacity = function(data, styleOb) {
        if (this.g._hasOpacity && !this.g._collapsable) {
            var stop;
            var j;
            var jLen;
            var mask = createNS("mask");
            var maskElement = createNS("path");
            mask.appendChild(maskElement);
            var opacityId = createElementID();
            var maskId = createElementID();
            mask.setAttribute("id", maskId);
            var opFill = createNS(data.t === 1 ? "linearGradient" : "radialGradient");
            opFill.setAttribute("id", opacityId);
            opFill.setAttribute("spreadMethod", "pad");
            opFill.setAttribute("gradientUnits", "userSpaceOnUse");
            jLen = data.g.k.k[0].s ? data.g.k.k[0].s.length : data.g.k.k.length;
            var stops = this.stops;
            for(j = data.g.p * 4; j < jLen; j += 2){
                stop = createNS("stop");
                stop.setAttribute("stop-color", "rgb(255,255,255)");
                opFill.appendChild(stop);
                stops.push(stop);
            }
            maskElement.setAttribute(data.ty === "gf" ? "fill" : "stroke", "url(" + getLocationHref() + "#" + opacityId + ")");
            if (data.ty === "gs") {
                maskElement.setAttribute("stroke-linecap", lineCapEnum[data.lc || 2]);
                maskElement.setAttribute("stroke-linejoin", lineJoinEnum[data.lj || 2]);
                if (data.lj === 1) maskElement.setAttribute("stroke-miterlimit", data.ml);
            }
            this.of = opFill;
            this.ms = mask;
            this.ost = stops;
            this.maskId = maskId;
            styleOb.msElem = maskElement;
        }
    };
    extendPrototype([
        DynamicPropertyContainer
    ], SVGGradientFillStyleData);
    function SVGGradientStrokeStyleData(elem, data, styleOb) {
        this.initDynamicPropertyContainer(elem);
        this.getValue = this.iterateDynamicProperties;
        this.w = PropertyFactory.getProp(elem, data.w, 0, null, this);
        this.d = new DashProperty(elem, data.d || {}, "svg", this);
        this.initGradientData(elem, data, styleOb);
        this._isAnimated = !!this._isAnimated;
    }
    extendPrototype([
        SVGGradientFillStyleData,
        DynamicPropertyContainer
    ], SVGGradientStrokeStyleData);
    function ShapeGroupData() {
        this.it = [];
        this.prevViewData = [];
        this.gr = createNS("g");
    }
    function SVGTransformData(mProps, op, container) {
        this.transform = {
            mProps: mProps,
            op: op,
            container: container
        };
        this.elements = [];
        this._isAnimated = this.transform.mProps.dynamicProperties.length || this.transform.op.effectsSequence.length;
    }
    var buildShapeString = function buildShapeString(pathNodes, length, closed, mat) {
        if (length === 0) return "";
        var _o = pathNodes.o;
        var _i = pathNodes.i;
        var _v = pathNodes.v;
        var i;
        var shapeString = " M" + mat.applyToPointStringified(_v[0][0], _v[0][1]);
        for(i = 1; i < length; i += 1)shapeString += " C" + mat.applyToPointStringified(_o[i - 1][0], _o[i - 1][1]) + " " + mat.applyToPointStringified(_i[i][0], _i[i][1]) + " " + mat.applyToPointStringified(_v[i][0], _v[i][1]);
        if (closed && length) {
            shapeString += " C" + mat.applyToPointStringified(_o[i - 1][0], _o[i - 1][1]) + " " + mat.applyToPointStringified(_i[0][0], _i[0][1]) + " " + mat.applyToPointStringified(_v[0][0], _v[0][1]);
            shapeString += "z";
        }
        return shapeString;
    };
    var SVGElementsRenderer = function() {
        var _identityMatrix = new Matrix();
        var _matrixHelper = new Matrix();
        var ob = {
            createRenderFunction: createRenderFunction
        };
        function createRenderFunction(data) {
            switch(data.ty){
                case "fl":
                    return renderFill;
                case "gf":
                    return renderGradient;
                case "gs":
                    return renderGradientStroke;
                case "st":
                    return renderStroke;
                case "sh":
                case "el":
                case "rc":
                case "sr":
                    return renderPath;
                case "tr":
                    return renderContentTransform;
                case "no":
                    return renderNoop;
                default:
                    return null;
            }
        }
        function renderContentTransform(styleData, itemData, isFirstFrame) {
            if (isFirstFrame || itemData.transform.op._mdf) itemData.transform.container.setAttribute("opacity", itemData.transform.op.v);
            if (isFirstFrame || itemData.transform.mProps._mdf) itemData.transform.container.setAttribute("transform", itemData.transform.mProps.v.to2dCSS());
        }
        function renderNoop() {}
        function renderPath(styleData, itemData, isFirstFrame) {
            var j;
            var jLen;
            var pathStringTransformed;
            var redraw;
            var pathNodes;
            var l;
            var lLen = itemData.styles.length;
            var lvl = itemData.lvl;
            var paths;
            var mat;
            var props;
            var iterations;
            var k;
            for(l = 0; l < lLen; l += 1){
                redraw = itemData.sh._mdf || isFirstFrame;
                if (itemData.styles[l].lvl < lvl) {
                    mat = _matrixHelper.reset();
                    iterations = lvl - itemData.styles[l].lvl;
                    k = itemData.transformers.length - 1;
                    while(!redraw && iterations > 0){
                        redraw = itemData.transformers[k].mProps._mdf || redraw;
                        iterations -= 1;
                        k -= 1;
                    }
                    if (redraw) {
                        iterations = lvl - itemData.styles[l].lvl;
                        k = itemData.transformers.length - 1;
                        while(iterations > 0){
                            props = itemData.transformers[k].mProps.v.props;
                            mat.transform(props[0], props[1], props[2], props[3], props[4], props[5], props[6], props[7], props[8], props[9], props[10], props[11], props[12], props[13], props[14], props[15]);
                            iterations -= 1;
                            k -= 1;
                        }
                    }
                } else mat = _identityMatrix;
                paths = itemData.sh.paths;
                jLen = paths._length;
                if (redraw) {
                    pathStringTransformed = "";
                    for(j = 0; j < jLen; j += 1){
                        pathNodes = paths.shapes[j];
                        if (pathNodes && pathNodes._length) pathStringTransformed += buildShapeString(pathNodes, pathNodes._length, pathNodes.c, mat);
                    }
                    itemData.caches[l] = pathStringTransformed;
                } else pathStringTransformed = itemData.caches[l];
                itemData.styles[l].d += styleData.hd === true ? "" : pathStringTransformed;
                itemData.styles[l]._mdf = redraw || itemData.styles[l]._mdf;
            }
        }
        function renderFill(styleData, itemData, isFirstFrame) {
            var styleElem = itemData.style;
            if (itemData.c._mdf || isFirstFrame) styleElem.pElem.setAttribute("fill", "rgb(" + bmFloor(itemData.c.v[0]) + "," + bmFloor(itemData.c.v[1]) + "," + bmFloor(itemData.c.v[2]) + ")");
            if (itemData.o._mdf || isFirstFrame) styleElem.pElem.setAttribute("fill-opacity", itemData.o.v);
        }
        function renderGradientStroke(styleData, itemData, isFirstFrame) {
            renderGradient(styleData, itemData, isFirstFrame);
            renderStroke(styleData, itemData, isFirstFrame);
        }
        function renderGradient(styleData, itemData, isFirstFrame) {
            var gfill = itemData.gf;
            var hasOpacity = itemData.g._hasOpacity;
            var pt1 = itemData.s.v;
            var pt2 = itemData.e.v;
            if (itemData.o._mdf || isFirstFrame) {
                var attr = styleData.ty === "gf" ? "fill-opacity" : "stroke-opacity";
                itemData.style.pElem.setAttribute(attr, itemData.o.v);
            }
            if (itemData.s._mdf || isFirstFrame) {
                var attr1 = styleData.t === 1 ? "x1" : "cx";
                var attr2 = attr1 === "x1" ? "y1" : "cy";
                gfill.setAttribute(attr1, pt1[0]);
                gfill.setAttribute(attr2, pt1[1]);
                if (hasOpacity && !itemData.g._collapsable) {
                    itemData.of.setAttribute(attr1, pt1[0]);
                    itemData.of.setAttribute(attr2, pt1[1]);
                }
            }
            var stops;
            var i;
            var len;
            var stop;
            if (itemData.g._cmdf || isFirstFrame) {
                stops = itemData.cst;
                var cValues = itemData.g.c;
                len = stops.length;
                for(i = 0; i < len; i += 1){
                    stop = stops[i];
                    stop.setAttribute("offset", cValues[i * 4] + "%");
                    stop.setAttribute("stop-color", "rgb(" + cValues[i * 4 + 1] + "," + cValues[i * 4 + 2] + "," + cValues[i * 4 + 3] + ")");
                }
            }
            if (hasOpacity && (itemData.g._omdf || isFirstFrame)) {
                var oValues = itemData.g.o;
                if (itemData.g._collapsable) stops = itemData.cst;
                else stops = itemData.ost;
                len = stops.length;
                for(i = 0; i < len; i += 1){
                    stop = stops[i];
                    if (!itemData.g._collapsable) stop.setAttribute("offset", oValues[i * 2] + "%");
                    stop.setAttribute("stop-opacity", oValues[i * 2 + 1]);
                }
            }
            if (styleData.t === 1) {
                if (itemData.e._mdf || isFirstFrame) {
                    gfill.setAttribute("x2", pt2[0]);
                    gfill.setAttribute("y2", pt2[1]);
                    if (hasOpacity && !itemData.g._collapsable) {
                        itemData.of.setAttribute("x2", pt2[0]);
                        itemData.of.setAttribute("y2", pt2[1]);
                    }
                }
            } else {
                var rad;
                if (itemData.s._mdf || itemData.e._mdf || isFirstFrame) {
                    rad = Math.sqrt(Math.pow(pt1[0] - pt2[0], 2) + Math.pow(pt1[1] - pt2[1], 2));
                    gfill.setAttribute("r", rad);
                    if (hasOpacity && !itemData.g._collapsable) itemData.of.setAttribute("r", rad);
                }
                if (itemData.e._mdf || itemData.h._mdf || itemData.a._mdf || isFirstFrame) {
                    if (!rad) rad = Math.sqrt(Math.pow(pt1[0] - pt2[0], 2) + Math.pow(pt1[1] - pt2[1], 2));
                    var ang = Math.atan2(pt2[1] - pt1[1], pt2[0] - pt1[0]);
                    var percent = itemData.h.v;
                    if (percent >= 1) percent = 0.99;
                    else if (percent <= -1) percent = -0.99;
                    var dist = rad * percent;
                    var x = Math.cos(ang + itemData.a.v) * dist + pt1[0];
                    var y = Math.sin(ang + itemData.a.v) * dist + pt1[1];
                    gfill.setAttribute("fx", x);
                    gfill.setAttribute("fy", y);
                    if (hasOpacity && !itemData.g._collapsable) {
                        itemData.of.setAttribute("fx", x);
                        itemData.of.setAttribute("fy", y);
                    }
                } // gfill.setAttribute('fy','200');
            }
        }
        function renderStroke(styleData, itemData, isFirstFrame) {
            var styleElem = itemData.style;
            var d = itemData.d;
            if (d && (d._mdf || isFirstFrame) && d.dashStr) {
                styleElem.pElem.setAttribute("stroke-dasharray", d.dashStr);
                styleElem.pElem.setAttribute("stroke-dashoffset", d.dashoffset[0]);
            }
            if (itemData.c && (itemData.c._mdf || isFirstFrame)) styleElem.pElem.setAttribute("stroke", "rgb(" + bmFloor(itemData.c.v[0]) + "," + bmFloor(itemData.c.v[1]) + "," + bmFloor(itemData.c.v[2]) + ")");
            if (itemData.o._mdf || isFirstFrame) styleElem.pElem.setAttribute("stroke-opacity", itemData.o.v);
            if (itemData.w._mdf || isFirstFrame) {
                styleElem.pElem.setAttribute("stroke-width", itemData.w.v);
                if (styleElem.msElem) styleElem.msElem.setAttribute("stroke-width", itemData.w.v);
            }
        }
        return ob;
    }();
    function SVGShapeElement(data, globalData, comp) {
        // List of drawable elements
        this.shapes = []; // Full shape data
        this.shapesData = data.shapes; // List of styles that will be applied to shapes
        this.stylesList = []; // List of modifiers that will be applied to shapes
        this.shapeModifiers = []; // List of items in shape tree
        this.itemsData = []; // List of items in previous shape tree
        this.processedElements = []; // List of animated components
        this.animatedContents = [];
        this.initElement(data, globalData, comp); // Moving any property that doesn't get too much access after initialization because of v8 way of handling more than 10 properties.
        // List of elements that have been created
        this.prevViewData = []; // Moving any property that doesn't get too much access after initialization because of v8 way of handling more than 10 properties.
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        SVGBaseElement,
        IShapeElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement
    ], SVGShapeElement);
    SVGShapeElement.prototype.initSecondaryElement = function() {};
    SVGShapeElement.prototype.identityMatrix = new Matrix();
    SVGShapeElement.prototype.buildExpressionInterface = function() {};
    SVGShapeElement.prototype.createContent = function() {
        this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.layerElement, 0, [], true);
        this.filterUniqueShapes();
    };
    /*
  This method searches for multiple shapes that affect a single element and one of them is animated
  */ SVGShapeElement.prototype.filterUniqueShapes = function() {
        var i;
        var len = this.shapes.length;
        var shape;
        var j;
        var jLen = this.stylesList.length;
        var style;
        var tempShapes = [];
        var areAnimated = false;
        for(j = 0; j < jLen; j += 1){
            style = this.stylesList[j];
            areAnimated = false;
            tempShapes.length = 0;
            for(i = 0; i < len; i += 1){
                shape = this.shapes[i];
                if (shape.styles.indexOf(style) !== -1) {
                    tempShapes.push(shape);
                    areAnimated = shape._isAnimated || areAnimated;
                }
            }
            if (tempShapes.length > 1 && areAnimated) this.setShapesAsAnimated(tempShapes);
        }
    };
    SVGShapeElement.prototype.setShapesAsAnimated = function(shapes) {
        var i;
        var len = shapes.length;
        for(i = 0; i < len; i += 1)shapes[i].setAsAnimated();
    };
    SVGShapeElement.prototype.createStyleElement = function(data, level) {
        // TODO: prevent drawing of hidden styles
        var elementData;
        var styleOb = new SVGStyleData(data, level);
        var pathElement = styleOb.pElem;
        if (data.ty === "st") elementData = new SVGStrokeStyleData(this, data, styleOb);
        else if (data.ty === "fl") elementData = new SVGFillStyleData(this, data, styleOb);
        else if (data.ty === "gf" || data.ty === "gs") {
            var GradientConstructor = data.ty === "gf" ? SVGGradientFillStyleData : SVGGradientStrokeStyleData;
            elementData = new GradientConstructor(this, data, styleOb);
            this.globalData.defs.appendChild(elementData.gf);
            if (elementData.maskId) {
                this.globalData.defs.appendChild(elementData.ms);
                this.globalData.defs.appendChild(elementData.of);
                pathElement.setAttribute("mask", "url(" + getLocationHref() + "#" + elementData.maskId + ")");
            }
        } else if (data.ty === "no") elementData = new SVGNoStyleData(this, data, styleOb);
        if (data.ty === "st" || data.ty === "gs") {
            pathElement.setAttribute("stroke-linecap", lineCapEnum[data.lc || 2]);
            pathElement.setAttribute("stroke-linejoin", lineJoinEnum[data.lj || 2]);
            pathElement.setAttribute("fill-opacity", "0");
            if (data.lj === 1) pathElement.setAttribute("stroke-miterlimit", data.ml);
        }
        if (data.r === 2) pathElement.setAttribute("fill-rule", "evenodd");
        if (data.ln) pathElement.setAttribute("id", data.ln);
        if (data.cl) pathElement.setAttribute("class", data.cl);
        if (data.bm) pathElement.style["mix-blend-mode"] = getBlendMode(data.bm);
        this.stylesList.push(styleOb);
        this.addToAnimatedContents(data, elementData);
        return elementData;
    };
    SVGShapeElement.prototype.createGroupElement = function(data) {
        var elementData = new ShapeGroupData();
        if (data.ln) elementData.gr.setAttribute("id", data.ln);
        if (data.cl) elementData.gr.setAttribute("class", data.cl);
        if (data.bm) elementData.gr.style["mix-blend-mode"] = getBlendMode(data.bm);
        return elementData;
    };
    SVGShapeElement.prototype.createTransformElement = function(data, container) {
        var transformProperty = TransformPropertyFactory.getTransformProperty(this, data, this);
        var elementData = new SVGTransformData(transformProperty, transformProperty.o, container);
        this.addToAnimatedContents(data, elementData);
        return elementData;
    };
    SVGShapeElement.prototype.createShapeElement = function(data, ownTransformers, level) {
        var ty = 4;
        if (data.ty === "rc") ty = 5;
        else if (data.ty === "el") ty = 6;
        else if (data.ty === "sr") ty = 7;
        var shapeProperty = ShapePropertyFactory.getShapeProp(this, data, ty, this);
        var elementData = new SVGShapeData(ownTransformers, level, shapeProperty);
        this.shapes.push(elementData);
        this.addShapeToModifiers(elementData);
        this.addToAnimatedContents(data, elementData);
        return elementData;
    };
    SVGShapeElement.prototype.addToAnimatedContents = function(data, element) {
        var i = 0;
        var len = this.animatedContents.length;
        while(i < len){
            if (this.animatedContents[i].element === element) return;
            i += 1;
        }
        this.animatedContents.push({
            fn: SVGElementsRenderer.createRenderFunction(data),
            element: element,
            data: data
        });
    };
    SVGShapeElement.prototype.setElementStyles = function(elementData) {
        var arr = elementData.styles;
        var j;
        var jLen = this.stylesList.length;
        for(j = 0; j < jLen; j += 1)if (!this.stylesList[j].closed) arr.push(this.stylesList[j]);
    };
    SVGShapeElement.prototype.reloadShapes = function() {
        this._isFirstFrame = true;
        var i;
        var len = this.itemsData.length;
        for(i = 0; i < len; i += 1)this.prevViewData[i] = this.itemsData[i];
        this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.layerElement, 0, [], true);
        this.filterUniqueShapes();
        len = this.dynamicProperties.length;
        for(i = 0; i < len; i += 1)this.dynamicProperties[i].getValue();
        this.renderModifiers();
    };
    SVGShapeElement.prototype.searchShapes = function(arr, itemsData, prevViewData, container, level, transformers, render) {
        var ownTransformers = [].concat(transformers);
        var i;
        var len = arr.length - 1;
        var j;
        var jLen;
        var ownStyles = [];
        var ownModifiers = [];
        var currentTransform;
        var modifier;
        var processedPos;
        for(i = len; i >= 0; i -= 1){
            processedPos = this.searchProcessedElement(arr[i]);
            if (!processedPos) arr[i]._render = render;
            else itemsData[i] = prevViewData[processedPos - 1];
            if (arr[i].ty === "fl" || arr[i].ty === "st" || arr[i].ty === "gf" || arr[i].ty === "gs" || arr[i].ty === "no") {
                if (!processedPos) itemsData[i] = this.createStyleElement(arr[i], level);
                else itemsData[i].style.closed = false;
                if (arr[i]._render) {
                    if (itemsData[i].style.pElem.parentNode !== container) container.appendChild(itemsData[i].style.pElem);
                }
                ownStyles.push(itemsData[i].style);
            } else if (arr[i].ty === "gr") {
                if (!processedPos) itemsData[i] = this.createGroupElement(arr[i]);
                else {
                    jLen = itemsData[i].it.length;
                    for(j = 0; j < jLen; j += 1)itemsData[i].prevViewData[j] = itemsData[i].it[j];
                }
                this.searchShapes(arr[i].it, itemsData[i].it, itemsData[i].prevViewData, itemsData[i].gr, level + 1, ownTransformers, render);
                if (arr[i]._render) {
                    if (itemsData[i].gr.parentNode !== container) container.appendChild(itemsData[i].gr);
                }
            } else if (arr[i].ty === "tr") {
                if (!processedPos) itemsData[i] = this.createTransformElement(arr[i], container);
                currentTransform = itemsData[i].transform;
                ownTransformers.push(currentTransform);
            } else if (arr[i].ty === "sh" || arr[i].ty === "rc" || arr[i].ty === "el" || arr[i].ty === "sr") {
                if (!processedPos) itemsData[i] = this.createShapeElement(arr[i], ownTransformers, level);
                this.setElementStyles(itemsData[i]);
            } else if (arr[i].ty === "tm" || arr[i].ty === "rd" || arr[i].ty === "ms" || arr[i].ty === "pb" || arr[i].ty === "zz" || arr[i].ty === "op") {
                if (!processedPos) {
                    modifier = ShapeModifiers.getModifier(arr[i].ty);
                    modifier.init(this, arr[i]);
                    itemsData[i] = modifier;
                    this.shapeModifiers.push(modifier);
                } else {
                    modifier = itemsData[i];
                    modifier.closed = false;
                }
                ownModifiers.push(modifier);
            } else if (arr[i].ty === "rp") {
                if (!processedPos) {
                    modifier = ShapeModifiers.getModifier(arr[i].ty);
                    itemsData[i] = modifier;
                    modifier.init(this, arr, i, itemsData);
                    this.shapeModifiers.push(modifier);
                    render = false;
                } else {
                    modifier = itemsData[i];
                    modifier.closed = true;
                }
                ownModifiers.push(modifier);
            }
            this.addProcessedElement(arr[i], i + 1);
        }
        len = ownStyles.length;
        for(i = 0; i < len; i += 1)ownStyles[i].closed = true;
        len = ownModifiers.length;
        for(i = 0; i < len; i += 1)ownModifiers[i].closed = true;
    };
    SVGShapeElement.prototype.renderInnerContent = function() {
        this.renderModifiers();
        var i;
        var len = this.stylesList.length;
        for(i = 0; i < len; i += 1)this.stylesList[i].reset();
        this.renderShape();
        for(i = 0; i < len; i += 1)if (this.stylesList[i]._mdf || this._isFirstFrame) {
            if (this.stylesList[i].msElem) {
                this.stylesList[i].msElem.setAttribute("d", this.stylesList[i].d); // Adding M0 0 fixes same mask bug on all browsers
                this.stylesList[i].d = "M0 0" + this.stylesList[i].d;
            }
            this.stylesList[i].pElem.setAttribute("d", this.stylesList[i].d || "M0 0");
        }
    };
    SVGShapeElement.prototype.renderShape = function() {
        var i;
        var len = this.animatedContents.length;
        var animatedContent;
        for(i = 0; i < len; i += 1){
            animatedContent = this.animatedContents[i];
            if ((this._isFirstFrame || animatedContent.element._isAnimated) && animatedContent.data !== true) animatedContent.fn(animatedContent.data, animatedContent.element, this._isFirstFrame);
        }
    };
    SVGShapeElement.prototype.destroy = function() {
        this.destroyBaseElement();
        this.shapesData = null;
        this.itemsData = null;
    };
    function LetterProps(o, sw, sc, fc, m, p) {
        this.o = o;
        this.sw = sw;
        this.sc = sc;
        this.fc = fc;
        this.m = m;
        this.p = p;
        this._mdf = {
            o: true,
            sw: !!sw,
            sc: !!sc,
            fc: !!fc,
            m: true,
            p: true
        };
    }
    LetterProps.prototype.update = function(o, sw, sc, fc, m, p) {
        this._mdf.o = false;
        this._mdf.sw = false;
        this._mdf.sc = false;
        this._mdf.fc = false;
        this._mdf.m = false;
        this._mdf.p = false;
        var updated = false;
        if (this.o !== o) {
            this.o = o;
            this._mdf.o = true;
            updated = true;
        }
        if (this.sw !== sw) {
            this.sw = sw;
            this._mdf.sw = true;
            updated = true;
        }
        if (this.sc !== sc) {
            this.sc = sc;
            this._mdf.sc = true;
            updated = true;
        }
        if (this.fc !== fc) {
            this.fc = fc;
            this._mdf.fc = true;
            updated = true;
        }
        if (this.m !== m) {
            this.m = m;
            this._mdf.m = true;
            updated = true;
        }
        if (p.length && (this.p[0] !== p[0] || this.p[1] !== p[1] || this.p[4] !== p[4] || this.p[5] !== p[5] || this.p[12] !== p[12] || this.p[13] !== p[13])) {
            this.p = p;
            this._mdf.p = true;
            updated = true;
        }
        return updated;
    };
    function TextProperty(elem, data) {
        this._frameId = initialDefaultFrame;
        this.pv = "";
        this.v = "";
        this.kf = false;
        this._isFirstFrame = true;
        this._mdf = false;
        this.data = data;
        this.elem = elem;
        this.comp = this.elem.comp;
        this.keysIndex = 0;
        this.canResize = false;
        this.minimumFontSize = 1;
        this.effectsSequence = [];
        this.currentData = {
            ascent: 0,
            boxWidth: this.defaultBoxWidth,
            f: "",
            fStyle: "",
            fWeight: "",
            fc: "",
            j: "",
            justifyOffset: "",
            l: [],
            lh: 0,
            lineWidths: [],
            ls: "",
            of: "",
            s: "",
            sc: "",
            sw: 0,
            t: 0,
            tr: 0,
            sz: 0,
            ps: null,
            fillColorAnim: false,
            strokeColorAnim: false,
            strokeWidthAnim: false,
            yOffset: 0,
            finalSize: 0,
            finalText: [],
            finalLineHeight: 0,
            __complete: false
        };
        this.copyData(this.currentData, this.data.d.k[0].s);
        if (!this.searchProperty()) this.completeTextData(this.currentData);
    }
    TextProperty.prototype.defaultBoxWidth = [
        0,
        0
    ];
    TextProperty.prototype.copyData = function(obj, data) {
        for(var s in data)if (Object.prototype.hasOwnProperty.call(data, s)) obj[s] = data[s];
        return obj;
    };
    TextProperty.prototype.setCurrentData = function(data) {
        if (!data.__complete) this.completeTextData(data);
        this.currentData = data;
        this.currentData.boxWidth = this.currentData.boxWidth || this.defaultBoxWidth;
        this._mdf = true;
    };
    TextProperty.prototype.searchProperty = function() {
        return this.searchKeyframes();
    };
    TextProperty.prototype.searchKeyframes = function() {
        this.kf = this.data.d.k.length > 1;
        if (this.kf) this.addEffect(this.getKeyframeValue.bind(this));
        return this.kf;
    };
    TextProperty.prototype.addEffect = function(effectFunction) {
        this.effectsSequence.push(effectFunction);
        this.elem.addDynamicProperty(this);
    };
    TextProperty.prototype.getValue = function(_finalValue) {
        if ((this.elem.globalData.frameId === this.frameId || !this.effectsSequence.length) && !_finalValue) return;
        this.currentData.t = this.data.d.k[this.keysIndex].s.t;
        var currentValue = this.currentData;
        var currentIndex = this.keysIndex;
        if (this.lock) {
            this.setCurrentData(this.currentData);
            return;
        }
        this.lock = true;
        this._mdf = false;
        var i;
        var len = this.effectsSequence.length;
        var finalValue = _finalValue || this.data.d.k[this.keysIndex].s;
        for(i = 0; i < len; i += 1)// Checking if index changed to prevent creating a new object every time the expression updates.
        if (currentIndex !== this.keysIndex) finalValue = this.effectsSequence[i](finalValue, finalValue.t);
        else finalValue = this.effectsSequence[i](this.currentData, finalValue.t);
        if (currentValue !== finalValue) this.setCurrentData(finalValue);
        this.v = this.currentData;
        this.pv = this.v;
        this.lock = false;
        this.frameId = this.elem.globalData.frameId;
    };
    TextProperty.prototype.getKeyframeValue = function() {
        var textKeys = this.data.d.k;
        var frameNum = this.elem.comp.renderedFrame;
        var i = 0;
        var len = textKeys.length;
        while(i <= len - 1){
            if (i === len - 1 || textKeys[i + 1].t > frameNum) break;
            i += 1;
        }
        if (this.keysIndex !== i) this.keysIndex = i;
        return this.data.d.k[this.keysIndex].s;
    };
    TextProperty.prototype.buildFinalText = function(text) {
        var charactersArray = [];
        var i = 0;
        var len = text.length;
        var charCode;
        var secondCharCode;
        var shouldCombine = false;
        while(i < len){
            charCode = text.charCodeAt(i);
            if (FontManager.isCombinedCharacter(charCode)) charactersArray[charactersArray.length - 1] += text.charAt(i);
            else if (charCode >= 0xD800 && charCode <= 0xDBFF) {
                secondCharCode = text.charCodeAt(i + 1);
                if (secondCharCode >= 0xDC00 && secondCharCode <= 0xDFFF) {
                    if (shouldCombine || FontManager.isModifier(charCode, secondCharCode)) {
                        charactersArray[charactersArray.length - 1] += text.substr(i, 2);
                        shouldCombine = false;
                    } else charactersArray.push(text.substr(i, 2));
                    i += 1;
                } else charactersArray.push(text.charAt(i));
            } else if (charCode > 0xDBFF) {
                secondCharCode = text.charCodeAt(i + 1);
                if (FontManager.isZeroWidthJoiner(charCode, secondCharCode)) {
                    shouldCombine = true;
                    charactersArray[charactersArray.length - 1] += text.substr(i, 2);
                    i += 1;
                } else charactersArray.push(text.charAt(i));
            } else if (FontManager.isZeroWidthJoiner(charCode)) {
                charactersArray[charactersArray.length - 1] += text.charAt(i);
                shouldCombine = true;
            } else charactersArray.push(text.charAt(i));
            i += 1;
        }
        return charactersArray;
    };
    TextProperty.prototype.completeTextData = function(documentData) {
        documentData.__complete = true;
        var fontManager = this.elem.globalData.fontManager;
        var data = this.data;
        var letters = [];
        var i;
        var len;
        var newLineFlag;
        var index = 0;
        var val;
        var anchorGrouping = data.m.g;
        var currentSize = 0;
        var currentPos = 0;
        var currentLine = 0;
        var lineWidths = [];
        var lineWidth = 0;
        var maxLineWidth = 0;
        var j;
        var jLen;
        var fontData = fontManager.getFontByName(documentData.f);
        var charData;
        var cLength = 0;
        var fontProps = getFontProperties(fontData);
        documentData.fWeight = fontProps.weight;
        documentData.fStyle = fontProps.style;
        documentData.finalSize = documentData.s;
        documentData.finalText = this.buildFinalText(documentData.t);
        len = documentData.finalText.length;
        documentData.finalLineHeight = documentData.lh;
        var trackingOffset = documentData.tr / 1000 * documentData.finalSize;
        var charCode;
        if (documentData.sz) {
            var flag = true;
            var boxWidth = documentData.sz[0];
            var boxHeight = documentData.sz[1];
            var currentHeight;
            var finalText;
            while(flag){
                finalText = this.buildFinalText(documentData.t);
                currentHeight = 0;
                lineWidth = 0;
                len = finalText.length;
                trackingOffset = documentData.tr / 1000 * documentData.finalSize;
                var lastSpaceIndex = -1;
                for(i = 0; i < len; i += 1){
                    charCode = finalText[i].charCodeAt(0);
                    newLineFlag = false;
                    if (finalText[i] === " ") lastSpaceIndex = i;
                    else if (charCode === 13 || charCode === 3) {
                        lineWidth = 0;
                        newLineFlag = true;
                        currentHeight += documentData.finalLineHeight || documentData.finalSize * 1.2;
                    }
                    if (fontManager.chars) {
                        charData = fontManager.getCharData(finalText[i], fontData.fStyle, fontData.fFamily);
                        cLength = newLineFlag ? 0 : charData.w * documentData.finalSize / 100;
                    } else // tCanvasHelper.font = documentData.s + 'px '+ fontData.fFamily;
                    cLength = fontManager.measureText(finalText[i], documentData.f, documentData.finalSize);
                    if (lineWidth + cLength > boxWidth && finalText[i] !== " ") {
                        if (lastSpaceIndex === -1) len += 1;
                        else i = lastSpaceIndex;
                        currentHeight += documentData.finalLineHeight || documentData.finalSize * 1.2;
                        finalText.splice(i, lastSpaceIndex === i ? 1 : 0, "\r"); // finalText = finalText.substr(0,i) + "\r" + finalText.substr(i === lastSpaceIndex ? i + 1 : i);
                        lastSpaceIndex = -1;
                        lineWidth = 0;
                    } else {
                        lineWidth += cLength;
                        lineWidth += trackingOffset;
                    }
                }
                currentHeight += fontData.ascent * documentData.finalSize / 100;
                if (this.canResize && documentData.finalSize > this.minimumFontSize && boxHeight < currentHeight) {
                    documentData.finalSize -= 1;
                    documentData.finalLineHeight = documentData.finalSize * documentData.lh / documentData.s;
                } else {
                    documentData.finalText = finalText;
                    len = documentData.finalText.length;
                    flag = false;
                }
            }
        }
        lineWidth = -trackingOffset;
        cLength = 0;
        var uncollapsedSpaces = 0;
        var currentChar;
        for(i = 0; i < len; i += 1){
            newLineFlag = false;
            currentChar = documentData.finalText[i];
            charCode = currentChar.charCodeAt(0);
            if (charCode === 13 || charCode === 3) {
                uncollapsedSpaces = 0;
                lineWidths.push(lineWidth);
                maxLineWidth = lineWidth > maxLineWidth ? lineWidth : maxLineWidth;
                lineWidth = -2 * trackingOffset;
                val = "";
                newLineFlag = true;
                currentLine += 1;
            } else val = currentChar;
            if (fontManager.chars) {
                charData = fontManager.getCharData(currentChar, fontData.fStyle, fontManager.getFontByName(documentData.f).fFamily);
                cLength = newLineFlag ? 0 : charData.w * documentData.finalSize / 100;
            } else // var charWidth = fontManager.measureText(val, documentData.f, documentData.finalSize);
            // tCanvasHelper.font = documentData.finalSize + 'px '+ fontManager.getFontByName(documentData.f).fFamily;
            cLength = fontManager.measureText(val, documentData.f, documentData.finalSize);
             //
            if (currentChar === " ") uncollapsedSpaces += cLength + trackingOffset;
            else {
                lineWidth += cLength + trackingOffset + uncollapsedSpaces;
                uncollapsedSpaces = 0;
            }
            letters.push({
                l: cLength,
                an: cLength,
                add: currentSize,
                n: newLineFlag,
                anIndexes: [],
                val: val,
                line: currentLine,
                animatorJustifyOffset: 0
            });
            if (anchorGrouping == 2) {
                // eslint-disable-line eqeqeq
                currentSize += cLength;
                if (val === "" || val === " " || i === len - 1) {
                    if (val === "" || val === " ") currentSize -= cLength;
                    while(currentPos <= i){
                        letters[currentPos].an = currentSize;
                        letters[currentPos].ind = index;
                        letters[currentPos].extra = cLength;
                        currentPos += 1;
                    }
                    index += 1;
                    currentSize = 0;
                }
            } else if (anchorGrouping == 3) {
                // eslint-disable-line eqeqeq
                currentSize += cLength;
                if (val === "" || i === len - 1) {
                    if (val === "") currentSize -= cLength;
                    while(currentPos <= i){
                        letters[currentPos].an = currentSize;
                        letters[currentPos].ind = index;
                        letters[currentPos].extra = cLength;
                        currentPos += 1;
                    }
                    currentSize = 0;
                    index += 1;
                }
            } else {
                letters[index].ind = index;
                letters[index].extra = 0;
                index += 1;
            }
        }
        documentData.l = letters;
        maxLineWidth = lineWidth > maxLineWidth ? lineWidth : maxLineWidth;
        lineWidths.push(lineWidth);
        if (documentData.sz) {
            documentData.boxWidth = documentData.sz[0];
            documentData.justifyOffset = 0;
        } else {
            documentData.boxWidth = maxLineWidth;
            switch(documentData.j){
                case 1:
                    documentData.justifyOffset = -documentData.boxWidth;
                    break;
                case 2:
                    documentData.justifyOffset = -documentData.boxWidth / 2;
                    break;
                default:
                    documentData.justifyOffset = 0;
            }
        }
        documentData.lineWidths = lineWidths;
        var animators = data.a;
        var animatorData;
        var letterData;
        jLen = animators.length;
        var based;
        var ind;
        var indexes = [];
        for(j = 0; j < jLen; j += 1){
            animatorData = animators[j];
            if (animatorData.a.sc) documentData.strokeColorAnim = true;
            if (animatorData.a.sw) documentData.strokeWidthAnim = true;
            if (animatorData.a.fc || animatorData.a.fh || animatorData.a.fs || animatorData.a.fb) documentData.fillColorAnim = true;
            ind = 0;
            based = animatorData.s.b;
            for(i = 0; i < len; i += 1){
                letterData = letters[i];
                letterData.anIndexes[j] = ind;
                if (based == 1 && letterData.val !== "" || based == 2 && letterData.val !== "" && letterData.val !== " " || based == 3 && (letterData.n || letterData.val == " " || i == len - 1) || based == 4 && (letterData.n || i == len - 1)) {
                    // eslint-disable-line eqeqeq
                    if (animatorData.s.rn === 1) indexes.push(ind);
                    ind += 1;
                }
            }
            data.a[j].s.totalChars = ind;
            var currentInd = -1;
            var newInd;
            if (animatorData.s.rn === 1) for(i = 0; i < len; i += 1){
                letterData = letters[i];
                if (currentInd != letterData.anIndexes[j]) {
                    // eslint-disable-line eqeqeq
                    currentInd = letterData.anIndexes[j];
                    newInd = indexes.splice(Math.floor(Math.random() * indexes.length), 1)[0];
                }
                letterData.anIndexes[j] = newInd;
            }
        }
        documentData.yOffset = documentData.finalLineHeight || documentData.finalSize * 1.2;
        documentData.ls = documentData.ls || 0;
        documentData.ascent = fontData.ascent * documentData.finalSize / 100;
    };
    TextProperty.prototype.updateDocumentData = function(newData, index) {
        index = index === undefined ? this.keysIndex : index;
        var dData = this.copyData({}, this.data.d.k[index].s);
        dData = this.copyData(dData, newData);
        this.data.d.k[index].s = dData;
        this.recalculate(index);
        this.elem.addDynamicProperty(this);
    };
    TextProperty.prototype.recalculate = function(index) {
        var dData = this.data.d.k[index].s;
        dData.__complete = false;
        this.keysIndex = 0;
        this._isFirstFrame = true;
        this.getValue(dData);
    };
    TextProperty.prototype.canResizeFont = function(_canResize) {
        this.canResize = _canResize;
        this.recalculate(this.keysIndex);
        this.elem.addDynamicProperty(this);
    };
    TextProperty.prototype.setMinimumFontSize = function(_fontValue) {
        this.minimumFontSize = Math.floor(_fontValue) || 1;
        this.recalculate(this.keysIndex);
        this.elem.addDynamicProperty(this);
    };
    var TextSelectorProp = function() {
        var max = Math.max;
        var min = Math.min;
        var floor = Math.floor;
        function TextSelectorPropFactory(elem, data) {
            this._currentTextLength = -1;
            this.k = false;
            this.data = data;
            this.elem = elem;
            this.comp = elem.comp;
            this.finalS = 0;
            this.finalE = 0;
            this.initDynamicPropertyContainer(elem);
            this.s = PropertyFactory.getProp(elem, data.s || {
                k: 0
            }, 0, 0, this);
            if ("e" in data) this.e = PropertyFactory.getProp(elem, data.e, 0, 0, this);
            else this.e = {
                v: 100
            };
            this.o = PropertyFactory.getProp(elem, data.o || {
                k: 0
            }, 0, 0, this);
            this.xe = PropertyFactory.getProp(elem, data.xe || {
                k: 0
            }, 0, 0, this);
            this.ne = PropertyFactory.getProp(elem, data.ne || {
                k: 0
            }, 0, 0, this);
            this.sm = PropertyFactory.getProp(elem, data.sm || {
                k: 100
            }, 0, 0, this);
            this.a = PropertyFactory.getProp(elem, data.a, 0, 0.01, this);
            if (!this.dynamicProperties.length) this.getValue();
        }
        TextSelectorPropFactory.prototype = {
            getMult: function getMult(ind) {
                if (this._currentTextLength !== this.elem.textProperty.currentData.l.length) this.getValue();
                var x1 = 0;
                var y1 = 0;
                var x2 = 1;
                var y2 = 1;
                if (this.ne.v > 0) x1 = this.ne.v / 100.0;
                else y1 = -this.ne.v / 100.0;
                if (this.xe.v > 0) x2 = 1.0 - this.xe.v / 100.0;
                else y2 = 1.0 + this.xe.v / 100.0;
                var easer = BezierFactory.getBezierEasing(x1, y1, x2, y2).get;
                var mult = 0;
                var s = this.finalS;
                var e = this.finalE;
                var type = this.data.sh;
                if (type === 2) {
                    if (e === s) mult = ind >= e ? 1 : 0;
                    else mult = max(0, min(0.5 / (e - s) + (ind - s) / (e - s), 1));
                    mult = easer(mult);
                } else if (type === 3) {
                    if (e === s) mult = ind >= e ? 0 : 1;
                    else mult = 1 - max(0, min(0.5 / (e - s) + (ind - s) / (e - s), 1));
                    mult = easer(mult);
                } else if (type === 4) {
                    if (e === s) mult = 0;
                    else {
                        mult = max(0, min(0.5 / (e - s) + (ind - s) / (e - s), 1));
                        if (mult < 0.5) mult *= 2;
                        else mult = 1 - 2 * (mult - 0.5);
                    }
                    mult = easer(mult);
                } else if (type === 5) {
                    if (e === s) mult = 0;
                    else {
                        var tot = e - s;
                        /* ind += 0.5;
                      mult = -4/(tot*tot)*(ind*ind)+(4/tot)*ind; */ ind = min(max(0, ind + 0.5 - s), e - s);
                        var x = -tot / 2 + ind;
                        var a = tot / 2;
                        mult = Math.sqrt(1 - x * x / (a * a));
                    }
                    mult = easer(mult);
                } else if (type === 6) {
                    if (e === s) mult = 0;
                    else {
                        ind = min(max(0, ind + 0.5 - s), e - s);
                        mult = (1 + Math.cos(Math.PI + Math.PI * 2 * ind / (e - s))) / 2; // eslint-disable-line
                    }
                    mult = easer(mult);
                } else {
                    if (ind >= floor(s)) {
                        if (ind - s < 0) mult = max(0, min(min(e, 1) - (s - ind), 1));
                        else mult = max(0, min(e - ind, 1));
                    }
                    mult = easer(mult);
                } // Smoothness implementation.
                // The smoothness represents a reduced range of the original [0; 1] range.
                // if smoothness is 25%, the new range will be [0.375; 0.625]
                // Steps are:
                // - find the lower value of the new range (threshold)
                // - if multiplier is smaller than that value, floor it to 0
                // - if it is larger,
                //     - subtract the threshold
                //     - divide it by the smoothness (this will return the range to [0; 1])
                // Note: If it doesn't work on some scenarios, consider applying it before the easer.
                if (this.sm.v !== 100) {
                    var smoothness = this.sm.v * 0.01;
                    if (smoothness === 0) smoothness = 0.00000001;
                    var threshold = 0.5 - smoothness * 0.5;
                    if (mult < threshold) mult = 0;
                    else {
                        mult = (mult - threshold) / smoothness;
                        if (mult > 1) mult = 1;
                    }
                }
                return mult * this.a.v;
            },
            getValue: function getValue(newCharsFlag) {
                this.iterateDynamicProperties();
                this._mdf = newCharsFlag || this._mdf;
                this._currentTextLength = this.elem.textProperty.currentData.l.length || 0;
                if (newCharsFlag && this.data.r === 2) this.e.v = this._currentTextLength;
                var divisor = this.data.r === 2 ? 1 : 100 / this.data.totalChars;
                var o = this.o.v / divisor;
                var s = this.s.v / divisor + o;
                var e = this.e.v / divisor + o;
                if (s > e) {
                    var _s = s;
                    s = e;
                    e = _s;
                }
                this.finalS = s;
                this.finalE = e;
            }
        };
        extendPrototype([
            DynamicPropertyContainer
        ], TextSelectorPropFactory);
        function getTextSelectorProp(elem, data, arr) {
            return new TextSelectorPropFactory(elem, data, arr);
        }
        return {
            getTextSelectorProp: getTextSelectorProp
        };
    }();
    function TextAnimatorDataProperty(elem, animatorProps, container) {
        var defaultData = {
            propType: false
        };
        var getProp = PropertyFactory.getProp;
        var textAnimatorAnimatables = animatorProps.a;
        this.a = {
            r: textAnimatorAnimatables.r ? getProp(elem, textAnimatorAnimatables.r, 0, degToRads, container) : defaultData,
            rx: textAnimatorAnimatables.rx ? getProp(elem, textAnimatorAnimatables.rx, 0, degToRads, container) : defaultData,
            ry: textAnimatorAnimatables.ry ? getProp(elem, textAnimatorAnimatables.ry, 0, degToRads, container) : defaultData,
            sk: textAnimatorAnimatables.sk ? getProp(elem, textAnimatorAnimatables.sk, 0, degToRads, container) : defaultData,
            sa: textAnimatorAnimatables.sa ? getProp(elem, textAnimatorAnimatables.sa, 0, degToRads, container) : defaultData,
            s: textAnimatorAnimatables.s ? getProp(elem, textAnimatorAnimatables.s, 1, 0.01, container) : defaultData,
            a: textAnimatorAnimatables.a ? getProp(elem, textAnimatorAnimatables.a, 1, 0, container) : defaultData,
            o: textAnimatorAnimatables.o ? getProp(elem, textAnimatorAnimatables.o, 0, 0.01, container) : defaultData,
            p: textAnimatorAnimatables.p ? getProp(elem, textAnimatorAnimatables.p, 1, 0, container) : defaultData,
            sw: textAnimatorAnimatables.sw ? getProp(elem, textAnimatorAnimatables.sw, 0, 0, container) : defaultData,
            sc: textAnimatorAnimatables.sc ? getProp(elem, textAnimatorAnimatables.sc, 1, 0, container) : defaultData,
            fc: textAnimatorAnimatables.fc ? getProp(elem, textAnimatorAnimatables.fc, 1, 0, container) : defaultData,
            fh: textAnimatorAnimatables.fh ? getProp(elem, textAnimatorAnimatables.fh, 0, 0, container) : defaultData,
            fs: textAnimatorAnimatables.fs ? getProp(elem, textAnimatorAnimatables.fs, 0, 0.01, container) : defaultData,
            fb: textAnimatorAnimatables.fb ? getProp(elem, textAnimatorAnimatables.fb, 0, 0.01, container) : defaultData,
            t: textAnimatorAnimatables.t ? getProp(elem, textAnimatorAnimatables.t, 0, 0, container) : defaultData
        };
        this.s = TextSelectorProp.getTextSelectorProp(elem, animatorProps.s, container);
        this.s.t = animatorProps.s.t;
    }
    function TextAnimatorProperty(textData, renderType, elem) {
        this._isFirstFrame = true;
        this._hasMaskedPath = false;
        this._frameId = -1;
        this._textData = textData;
        this._renderType = renderType;
        this._elem = elem;
        this._animatorsData = createSizedArray(this._textData.a.length);
        this._pathData = {};
        this._moreOptions = {
            alignment: {}
        };
        this.renderedLetters = [];
        this.lettersChangedFlag = false;
        this.initDynamicPropertyContainer(elem);
    }
    TextAnimatorProperty.prototype.searchProperties = function() {
        var i;
        var len = this._textData.a.length;
        var animatorProps;
        var getProp = PropertyFactory.getProp;
        for(i = 0; i < len; i += 1){
            animatorProps = this._textData.a[i];
            this._animatorsData[i] = new TextAnimatorDataProperty(this._elem, animatorProps, this);
        }
        if (this._textData.p && "m" in this._textData.p) {
            this._pathData = {
                a: getProp(this._elem, this._textData.p.a, 0, 0, this),
                f: getProp(this._elem, this._textData.p.f, 0, 0, this),
                l: getProp(this._elem, this._textData.p.l, 0, 0, this),
                r: getProp(this._elem, this._textData.p.r, 0, 0, this),
                p: getProp(this._elem, this._textData.p.p, 0, 0, this),
                m: this._elem.maskManager.getMaskProperty(this._textData.p.m)
            };
            this._hasMaskedPath = true;
        } else this._hasMaskedPath = false;
        this._moreOptions.alignment = getProp(this._elem, this._textData.m.a, 1, 0, this);
    };
    TextAnimatorProperty.prototype.getMeasures = function(documentData, lettersChangedFlag) {
        this.lettersChangedFlag = lettersChangedFlag;
        if (!this._mdf && !this._isFirstFrame && !lettersChangedFlag && (!this._hasMaskedPath || !this._pathData.m._mdf)) return;
        this._isFirstFrame = false;
        var alignment = this._moreOptions.alignment.v;
        var animators = this._animatorsData;
        var textData = this._textData;
        var matrixHelper = this.mHelper;
        var renderType = this._renderType;
        var renderedLettersCount = this.renderedLetters.length;
        var xPos;
        var yPos;
        var i;
        var len;
        var letters = documentData.l;
        var pathInfo;
        var currentLength;
        var currentPoint;
        var segmentLength;
        var flag;
        var pointInd;
        var segmentInd;
        var prevPoint;
        var points;
        var segments;
        var partialLength;
        var totalLength;
        var perc;
        var tanAngle;
        var mask;
        if (this._hasMaskedPath) {
            mask = this._pathData.m;
            if (!this._pathData.n || this._pathData._mdf) {
                var paths = mask.v;
                if (this._pathData.r.v) paths = paths.reverse();
                 // TODO: release bezier data cached from previous pathInfo: this._pathData.pi
                pathInfo = {
                    tLength: 0,
                    segments: []
                };
                len = paths._length - 1;
                var bezierData;
                totalLength = 0;
                for(i = 0; i < len; i += 1){
                    bezierData = bez.buildBezierData(paths.v[i], paths.v[i + 1], [
                        paths.o[i][0] - paths.v[i][0],
                        paths.o[i][1] - paths.v[i][1]
                    ], [
                        paths.i[i + 1][0] - paths.v[i + 1][0],
                        paths.i[i + 1][1] - paths.v[i + 1][1]
                    ]);
                    pathInfo.tLength += bezierData.segmentLength;
                    pathInfo.segments.push(bezierData);
                    totalLength += bezierData.segmentLength;
                }
                i = len;
                if (mask.v.c) {
                    bezierData = bez.buildBezierData(paths.v[i], paths.v[0], [
                        paths.o[i][0] - paths.v[i][0],
                        paths.o[i][1] - paths.v[i][1]
                    ], [
                        paths.i[0][0] - paths.v[0][0],
                        paths.i[0][1] - paths.v[0][1]
                    ]);
                    pathInfo.tLength += bezierData.segmentLength;
                    pathInfo.segments.push(bezierData);
                    totalLength += bezierData.segmentLength;
                }
                this._pathData.pi = pathInfo;
            }
            pathInfo = this._pathData.pi;
            currentLength = this._pathData.f.v;
            segmentInd = 0;
            pointInd = 1;
            segmentLength = 0;
            flag = true;
            segments = pathInfo.segments;
            if (currentLength < 0 && mask.v.c) {
                if (pathInfo.tLength < Math.abs(currentLength)) currentLength = -Math.abs(currentLength) % pathInfo.tLength;
                segmentInd = segments.length - 1;
                points = segments[segmentInd].points;
                pointInd = points.length - 1;
                while(currentLength < 0){
                    currentLength += points[pointInd].partialLength;
                    pointInd -= 1;
                    if (pointInd < 0) {
                        segmentInd -= 1;
                        points = segments[segmentInd].points;
                        pointInd = points.length - 1;
                    }
                }
            }
            points = segments[segmentInd].points;
            prevPoint = points[pointInd - 1];
            currentPoint = points[pointInd];
            partialLength = currentPoint.partialLength;
        }
        len = letters.length;
        xPos = 0;
        yPos = 0;
        var yOff = documentData.finalSize * 1.2 * 0.714;
        var firstLine = true;
        var animatorProps;
        var animatorSelector;
        var j;
        var jLen;
        var letterValue;
        jLen = animators.length;
        var mult;
        var ind = -1;
        var offf;
        var xPathPos;
        var yPathPos;
        var initPathPos = currentLength;
        var initSegmentInd = segmentInd;
        var initPointInd = pointInd;
        var currentLine = -1;
        var elemOpacity;
        var sc;
        var sw;
        var fc;
        var k;
        var letterSw;
        var letterSc;
        var letterFc;
        var letterM = "";
        var letterP = this.defaultPropsArray;
        var letterO; //
        if (documentData.j === 2 || documentData.j === 1) {
            var animatorJustifyOffset = 0;
            var animatorFirstCharOffset = 0;
            var justifyOffsetMult = documentData.j === 2 ? -0.5 : -1;
            var lastIndex = 0;
            var isNewLine = true;
            for(i = 0; i < len; i += 1)if (letters[i].n) {
                if (animatorJustifyOffset) animatorJustifyOffset += animatorFirstCharOffset;
                while(lastIndex < i){
                    letters[lastIndex].animatorJustifyOffset = animatorJustifyOffset;
                    lastIndex += 1;
                }
                animatorJustifyOffset = 0;
                isNewLine = true;
            } else {
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    if (animatorProps.t.propType) {
                        if (isNewLine && documentData.j === 2) animatorFirstCharOffset += animatorProps.t.v * justifyOffsetMult;
                        animatorSelector = animators[j].s;
                        mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                        if (mult.length) animatorJustifyOffset += animatorProps.t.v * mult[0] * justifyOffsetMult;
                        else animatorJustifyOffset += animatorProps.t.v * mult * justifyOffsetMult;
                    }
                }
                isNewLine = false;
            }
            if (animatorJustifyOffset) animatorJustifyOffset += animatorFirstCharOffset;
            while(lastIndex < i){
                letters[lastIndex].animatorJustifyOffset = animatorJustifyOffset;
                lastIndex += 1;
            }
        } //
        for(i = 0; i < len; i += 1){
            matrixHelper.reset();
            elemOpacity = 1;
            if (letters[i].n) {
                xPos = 0;
                yPos += documentData.yOffset;
                yPos += firstLine ? 1 : 0;
                currentLength = initPathPos;
                firstLine = false;
                if (this._hasMaskedPath) {
                    segmentInd = initSegmentInd;
                    pointInd = initPointInd;
                    points = segments[segmentInd].points;
                    prevPoint = points[pointInd - 1];
                    currentPoint = points[pointInd];
                    partialLength = currentPoint.partialLength;
                    segmentLength = 0;
                }
                letterM = "";
                letterFc = "";
                letterSw = "";
                letterO = "";
                letterP = this.defaultPropsArray;
            } else {
                if (this._hasMaskedPath) {
                    if (currentLine !== letters[i].line) {
                        switch(documentData.j){
                            case 1:
                                currentLength += totalLength - documentData.lineWidths[letters[i].line];
                                break;
                            case 2:
                                currentLength += (totalLength - documentData.lineWidths[letters[i].line]) / 2;
                                break;
                            default:
                                break;
                        }
                        currentLine = letters[i].line;
                    }
                    if (ind !== letters[i].ind) {
                        if (letters[ind]) currentLength += letters[ind].extra;
                        currentLength += letters[i].an / 2;
                        ind = letters[i].ind;
                    }
                    currentLength += alignment[0] * letters[i].an * 0.005;
                    var animatorOffset = 0;
                    for(j = 0; j < jLen; j += 1){
                        animatorProps = animators[j].a;
                        if (animatorProps.p.propType) {
                            animatorSelector = animators[j].s;
                            mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                            if (mult.length) animatorOffset += animatorProps.p.v[0] * mult[0];
                            else animatorOffset += animatorProps.p.v[0] * mult;
                        }
                        if (animatorProps.a.propType) {
                            animatorSelector = animators[j].s;
                            mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                            if (mult.length) animatorOffset += animatorProps.a.v[0] * mult[0];
                            else animatorOffset += animatorProps.a.v[0] * mult;
                        }
                    }
                    flag = true; // Force alignment only works with a single line for now
                    if (this._pathData.a.v) {
                        currentLength = letters[0].an * 0.5 + (totalLength - this._pathData.f.v - letters[0].an * 0.5 - letters[letters.length - 1].an * 0.5) * ind / (len - 1);
                        currentLength += this._pathData.f.v;
                    }
                    while(flag){
                        if (segmentLength + partialLength >= currentLength + animatorOffset || !points) {
                            perc = (currentLength + animatorOffset - segmentLength) / currentPoint.partialLength;
                            xPathPos = prevPoint.point[0] + (currentPoint.point[0] - prevPoint.point[0]) * perc;
                            yPathPos = prevPoint.point[1] + (currentPoint.point[1] - prevPoint.point[1]) * perc;
                            matrixHelper.translate(-alignment[0] * letters[i].an * 0.005, -(alignment[1] * yOff) * 0.01);
                            flag = false;
                        } else if (points) {
                            segmentLength += currentPoint.partialLength;
                            pointInd += 1;
                            if (pointInd >= points.length) {
                                pointInd = 0;
                                segmentInd += 1;
                                if (!segments[segmentInd]) {
                                    if (mask.v.c) {
                                        pointInd = 0;
                                        segmentInd = 0;
                                        points = segments[segmentInd].points;
                                    } else {
                                        segmentLength -= currentPoint.partialLength;
                                        points = null;
                                    }
                                } else points = segments[segmentInd].points;
                            }
                            if (points) {
                                prevPoint = currentPoint;
                                currentPoint = points[pointInd];
                                partialLength = currentPoint.partialLength;
                            }
                        }
                    }
                    offf = letters[i].an / 2 - letters[i].add;
                    matrixHelper.translate(-offf, 0, 0);
                } else {
                    offf = letters[i].an / 2 - letters[i].add;
                    matrixHelper.translate(-offf, 0, 0); // Grouping alignment
                    matrixHelper.translate(-alignment[0] * letters[i].an * 0.005, -alignment[1] * yOff * 0.01, 0);
                }
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    if (animatorProps.t.propType) {
                        animatorSelector = animators[j].s;
                        mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars); // This condition is to prevent applying tracking to first character in each line. Might be better to use a boolean "isNewLine"
                        if (xPos !== 0 || documentData.j !== 0) {
                            if (this._hasMaskedPath) {
                                if (mult.length) currentLength += animatorProps.t.v * mult[0];
                                else currentLength += animatorProps.t.v * mult;
                            } else if (mult.length) xPos += animatorProps.t.v * mult[0];
                            else xPos += animatorProps.t.v * mult;
                        }
                    }
                }
                if (documentData.strokeWidthAnim) sw = documentData.sw || 0;
                if (documentData.strokeColorAnim) {
                    if (documentData.sc) sc = [
                        documentData.sc[0],
                        documentData.sc[1],
                        documentData.sc[2]
                    ];
                    else sc = [
                        0,
                        0,
                        0
                    ];
                }
                if (documentData.fillColorAnim && documentData.fc) fc = [
                    documentData.fc[0],
                    documentData.fc[1],
                    documentData.fc[2]
                ];
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    if (animatorProps.a.propType) {
                        animatorSelector = animators[j].s;
                        mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                        if (mult.length) matrixHelper.translate(-animatorProps.a.v[0] * mult[0], -animatorProps.a.v[1] * mult[1], animatorProps.a.v[2] * mult[2]);
                        else matrixHelper.translate(-animatorProps.a.v[0] * mult, -animatorProps.a.v[1] * mult, animatorProps.a.v[2] * mult);
                    }
                }
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    if (animatorProps.s.propType) {
                        animatorSelector = animators[j].s;
                        mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                        if (mult.length) matrixHelper.scale(1 + (animatorProps.s.v[0] - 1) * mult[0], 1 + (animatorProps.s.v[1] - 1) * mult[1], 1);
                        else matrixHelper.scale(1 + (animatorProps.s.v[0] - 1) * mult, 1 + (animatorProps.s.v[1] - 1) * mult, 1);
                    }
                }
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    animatorSelector = animators[j].s;
                    mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                    if (animatorProps.sk.propType) {
                        if (mult.length) matrixHelper.skewFromAxis(-animatorProps.sk.v * mult[0], animatorProps.sa.v * mult[1]);
                        else matrixHelper.skewFromAxis(-animatorProps.sk.v * mult, animatorProps.sa.v * mult);
                    }
                    if (animatorProps.r.propType) {
                        if (mult.length) matrixHelper.rotateZ(-animatorProps.r.v * mult[2]);
                        else matrixHelper.rotateZ(-animatorProps.r.v * mult);
                    }
                    if (animatorProps.ry.propType) {
                        if (mult.length) matrixHelper.rotateY(animatorProps.ry.v * mult[1]);
                        else matrixHelper.rotateY(animatorProps.ry.v * mult);
                    }
                    if (animatorProps.rx.propType) {
                        if (mult.length) matrixHelper.rotateX(animatorProps.rx.v * mult[0]);
                        else matrixHelper.rotateX(animatorProps.rx.v * mult);
                    }
                    if (animatorProps.o.propType) {
                        if (mult.length) elemOpacity += (animatorProps.o.v * mult[0] - elemOpacity) * mult[0];
                        else elemOpacity += (animatorProps.o.v * mult - elemOpacity) * mult;
                    }
                    if (documentData.strokeWidthAnim && animatorProps.sw.propType) {
                        if (mult.length) sw += animatorProps.sw.v * mult[0];
                        else sw += animatorProps.sw.v * mult;
                    }
                    if (documentData.strokeColorAnim && animatorProps.sc.propType) {
                        for(k = 0; k < 3; k += 1)if (mult.length) sc[k] += (animatorProps.sc.v[k] - sc[k]) * mult[0];
                        else sc[k] += (animatorProps.sc.v[k] - sc[k]) * mult;
                    }
                    if (documentData.fillColorAnim && documentData.fc) {
                        if (animatorProps.fc.propType) {
                            for(k = 0; k < 3; k += 1)if (mult.length) fc[k] += (animatorProps.fc.v[k] - fc[k]) * mult[0];
                            else fc[k] += (animatorProps.fc.v[k] - fc[k]) * mult;
                        }
                        if (animatorProps.fh.propType) {
                            if (mult.length) fc = addHueToRGB(fc, animatorProps.fh.v * mult[0]);
                            else fc = addHueToRGB(fc, animatorProps.fh.v * mult);
                        }
                        if (animatorProps.fs.propType) {
                            if (mult.length) fc = addSaturationToRGB(fc, animatorProps.fs.v * mult[0]);
                            else fc = addSaturationToRGB(fc, animatorProps.fs.v * mult);
                        }
                        if (animatorProps.fb.propType) {
                            if (mult.length) fc = addBrightnessToRGB(fc, animatorProps.fb.v * mult[0]);
                            else fc = addBrightnessToRGB(fc, animatorProps.fb.v * mult);
                        }
                    }
                }
                for(j = 0; j < jLen; j += 1){
                    animatorProps = animators[j].a;
                    if (animatorProps.p.propType) {
                        animatorSelector = animators[j].s;
                        mult = animatorSelector.getMult(letters[i].anIndexes[j], textData.a[j].s.totalChars);
                        if (this._hasMaskedPath) {
                            if (mult.length) matrixHelper.translate(0, animatorProps.p.v[1] * mult[0], -animatorProps.p.v[2] * mult[1]);
                            else matrixHelper.translate(0, animatorProps.p.v[1] * mult, -animatorProps.p.v[2] * mult);
                        } else if (mult.length) matrixHelper.translate(animatorProps.p.v[0] * mult[0], animatorProps.p.v[1] * mult[1], -animatorProps.p.v[2] * mult[2]);
                        else matrixHelper.translate(animatorProps.p.v[0] * mult, animatorProps.p.v[1] * mult, -animatorProps.p.v[2] * mult);
                    }
                }
                if (documentData.strokeWidthAnim) letterSw = sw < 0 ? 0 : sw;
                if (documentData.strokeColorAnim) letterSc = "rgb(" + Math.round(sc[0] * 255) + "," + Math.round(sc[1] * 255) + "," + Math.round(sc[2] * 255) + ")";
                if (documentData.fillColorAnim && documentData.fc) letterFc = "rgb(" + Math.round(fc[0] * 255) + "," + Math.round(fc[1] * 255) + "," + Math.round(fc[2] * 255) + ")";
                if (this._hasMaskedPath) {
                    matrixHelper.translate(0, -documentData.ls);
                    matrixHelper.translate(0, alignment[1] * yOff * 0.01 + yPos, 0);
                    if (this._pathData.p.v) {
                        tanAngle = (currentPoint.point[1] - prevPoint.point[1]) / (currentPoint.point[0] - prevPoint.point[0]);
                        var rot = Math.atan(tanAngle) * 180 / Math.PI;
                        if (currentPoint.point[0] < prevPoint.point[0]) rot += 180;
                        matrixHelper.rotate(-rot * Math.PI / 180);
                    }
                    matrixHelper.translate(xPathPos, yPathPos, 0);
                    currentLength -= alignment[0] * letters[i].an * 0.005;
                    if (letters[i + 1] && ind !== letters[i + 1].ind) {
                        currentLength += letters[i].an / 2;
                        currentLength += documentData.tr * 0.001 * documentData.finalSize;
                    }
                } else {
                    matrixHelper.translate(xPos, yPos, 0);
                    if (documentData.ps) // matrixHelper.translate(documentData.ps[0],documentData.ps[1],0);
                    matrixHelper.translate(documentData.ps[0], documentData.ps[1] + documentData.ascent, 0);
                    switch(documentData.j){
                        case 1:
                            matrixHelper.translate(letters[i].animatorJustifyOffset + documentData.justifyOffset + (documentData.boxWidth - documentData.lineWidths[letters[i].line]), 0, 0);
                            break;
                        case 2:
                            matrixHelper.translate(letters[i].animatorJustifyOffset + documentData.justifyOffset + (documentData.boxWidth - documentData.lineWidths[letters[i].line]) / 2, 0, 0);
                            break;
                        default:
                            break;
                    }
                    matrixHelper.translate(0, -documentData.ls);
                    matrixHelper.translate(offf, 0, 0);
                    matrixHelper.translate(alignment[0] * letters[i].an * 0.005, alignment[1] * yOff * 0.01, 0);
                    xPos += letters[i].l + documentData.tr * 0.001 * documentData.finalSize;
                }
                if (renderType === "html") letterM = matrixHelper.toCSS();
                else if (renderType === "svg") letterM = matrixHelper.to2dCSS();
                else letterP = [
                    matrixHelper.props[0],
                    matrixHelper.props[1],
                    matrixHelper.props[2],
                    matrixHelper.props[3],
                    matrixHelper.props[4],
                    matrixHelper.props[5],
                    matrixHelper.props[6],
                    matrixHelper.props[7],
                    matrixHelper.props[8],
                    matrixHelper.props[9],
                    matrixHelper.props[10],
                    matrixHelper.props[11],
                    matrixHelper.props[12],
                    matrixHelper.props[13],
                    matrixHelper.props[14],
                    matrixHelper.props[15]
                ];
                letterO = elemOpacity;
            }
            if (renderedLettersCount <= i) {
                letterValue = new LetterProps(letterO, letterSw, letterSc, letterFc, letterM, letterP);
                this.renderedLetters.push(letterValue);
                renderedLettersCount += 1;
                this.lettersChangedFlag = true;
            } else {
                letterValue = this.renderedLetters[i];
                this.lettersChangedFlag = letterValue.update(letterO, letterSw, letterSc, letterFc, letterM, letterP) || this.lettersChangedFlag;
            }
        }
    };
    TextAnimatorProperty.prototype.getValue = function() {
        if (this._elem.globalData.frameId === this._frameId) return;
        this._frameId = this._elem.globalData.frameId;
        this.iterateDynamicProperties();
    };
    TextAnimatorProperty.prototype.mHelper = new Matrix();
    TextAnimatorProperty.prototype.defaultPropsArray = [];
    extendPrototype([
        DynamicPropertyContainer
    ], TextAnimatorProperty);
    function ITextElement() {}
    ITextElement.prototype.initElement = function(data, globalData, comp) {
        this.lettersChangedFlag = true;
        this.initFrame();
        this.initBaseData(data, globalData, comp);
        this.textProperty = new TextProperty(this, data.t, this.dynamicProperties);
        this.textAnimator = new TextAnimatorProperty(data.t, this.renderType, this);
        this.initTransform(data, globalData, comp);
        this.initHierarchy();
        this.initRenderable();
        this.initRendererElement();
        this.createContainerElements();
        this.createRenderableComponents();
        this.createContent();
        this.hide();
        this.textAnimator.searchProperties(this.dynamicProperties);
    };
    ITextElement.prototype.prepareFrame = function(num) {
        this._mdf = false;
        this.prepareRenderableFrame(num);
        this.prepareProperties(num, this.isInRange);
        if (this.textProperty._mdf || this.textProperty._isFirstFrame) {
            this.buildNewText();
            this.textProperty._isFirstFrame = false;
            this.textProperty._mdf = false;
        }
    };
    ITextElement.prototype.createPathShape = function(matrixHelper, shapes) {
        var j;
        var jLen = shapes.length;
        var pathNodes;
        var shapeStr = "";
        for(j = 0; j < jLen; j += 1)if (shapes[j].ty === "sh") {
            pathNodes = shapes[j].ks.k;
            shapeStr += buildShapeString(pathNodes, pathNodes.i.length, true, matrixHelper);
        }
        return shapeStr;
    };
    ITextElement.prototype.updateDocumentData = function(newData, index) {
        this.textProperty.updateDocumentData(newData, index);
    };
    ITextElement.prototype.canResizeFont = function(_canResize) {
        this.textProperty.canResizeFont(_canResize);
    };
    ITextElement.prototype.setMinimumFontSize = function(_fontSize) {
        this.textProperty.setMinimumFontSize(_fontSize);
    };
    ITextElement.prototype.applyTextPropertiesToMatrix = function(documentData, matrixHelper, lineNumber, xPos, yPos) {
        if (documentData.ps) matrixHelper.translate(documentData.ps[0], documentData.ps[1] + documentData.ascent, 0);
        matrixHelper.translate(0, -documentData.ls, 0);
        switch(documentData.j){
            case 1:
                matrixHelper.translate(documentData.justifyOffset + (documentData.boxWidth - documentData.lineWidths[lineNumber]), 0, 0);
                break;
            case 2:
                matrixHelper.translate(documentData.justifyOffset + (documentData.boxWidth - documentData.lineWidths[lineNumber]) / 2, 0, 0);
                break;
            default:
                break;
        }
        matrixHelper.translate(xPos, yPos, 0);
    };
    ITextElement.prototype.buildColor = function(colorData) {
        return "rgb(" + Math.round(colorData[0] * 255) + "," + Math.round(colorData[1] * 255) + "," + Math.round(colorData[2] * 255) + ")";
    };
    ITextElement.prototype.emptyProp = new LetterProps();
    ITextElement.prototype.destroy = function() {};
    var emptyShapeData = {
        shapes: []
    };
    function SVGTextLottieElement(data, globalData, comp) {
        this.textSpans = [];
        this.renderType = "svg";
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        SVGBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement,
        ITextElement
    ], SVGTextLottieElement);
    SVGTextLottieElement.prototype.createContent = function() {
        if (this.data.singleShape && !this.globalData.fontManager.chars) this.textContainer = createNS("text");
    };
    SVGTextLottieElement.prototype.buildTextContents = function(textArray) {
        var i = 0;
        var len = textArray.length;
        var textContents = [];
        var currentTextContent = "";
        while(i < len){
            if (textArray[i] === String.fromCharCode(13) || textArray[i] === String.fromCharCode(3)) {
                textContents.push(currentTextContent);
                currentTextContent = "";
            } else currentTextContent += textArray[i];
            i += 1;
        }
        textContents.push(currentTextContent);
        return textContents;
    };
    SVGTextLottieElement.prototype.buildShapeData = function(data, scale) {
        // data should probably be cloned to apply scale separately to each instance of a text on different layers
        // but since text internal content gets only rendered once and then it's never rerendered,
        // it's probably safe not to clone data and reuse always the same instance even if the object is mutated.
        // Avoiding cloning is preferred since cloning each character shape data is expensive
        if (data.shapes && data.shapes.length) {
            var shape = data.shapes[0];
            if (shape.it) {
                var shapeItem = shape.it[shape.it.length - 1];
                if (shapeItem.s) {
                    shapeItem.s.k[0] = scale;
                    shapeItem.s.k[1] = scale;
                }
            }
        }
        return data;
    };
    SVGTextLottieElement.prototype.buildNewText = function() {
        this.addDynamicProperty(this);
        var i;
        var len;
        var documentData = this.textProperty.currentData;
        this.renderedLetters = createSizedArray(documentData ? documentData.l.length : 0);
        if (documentData.fc) this.layerElement.setAttribute("fill", this.buildColor(documentData.fc));
        else this.layerElement.setAttribute("fill", "rgba(0,0,0,0)");
        if (documentData.sc) {
            this.layerElement.setAttribute("stroke", this.buildColor(documentData.sc));
            this.layerElement.setAttribute("stroke-width", documentData.sw);
        }
        this.layerElement.setAttribute("font-size", documentData.finalSize);
        var fontData = this.globalData.fontManager.getFontByName(documentData.f);
        if (fontData.fClass) this.layerElement.setAttribute("class", fontData.fClass);
        else {
            this.layerElement.setAttribute("font-family", fontData.fFamily);
            var fWeight = documentData.fWeight;
            var fStyle = documentData.fStyle;
            this.layerElement.setAttribute("font-style", fStyle);
            this.layerElement.setAttribute("font-weight", fWeight);
        }
        this.layerElement.setAttribute("aria-label", documentData.t);
        var letters = documentData.l || [];
        var usesGlyphs = !!this.globalData.fontManager.chars;
        len = letters.length;
        var tSpan;
        var matrixHelper = this.mHelper;
        var shapeStr = "";
        var singleShape = this.data.singleShape;
        var xPos = 0;
        var yPos = 0;
        var firstLine = true;
        var trackingOffset = documentData.tr * 0.001 * documentData.finalSize;
        if (singleShape && !usesGlyphs && !documentData.sz) {
            var tElement = this.textContainer;
            var justify = "start";
            switch(documentData.j){
                case 1:
                    justify = "end";
                    break;
                case 2:
                    justify = "middle";
                    break;
                default:
                    justify = "start";
                    break;
            }
            tElement.setAttribute("text-anchor", justify);
            tElement.setAttribute("letter-spacing", trackingOffset);
            var textContent = this.buildTextContents(documentData.finalText);
            len = textContent.length;
            yPos = documentData.ps ? documentData.ps[1] + documentData.ascent : 0;
            for(i = 0; i < len; i += 1){
                tSpan = this.textSpans[i].span || createNS("tspan");
                tSpan.textContent = textContent[i];
                tSpan.setAttribute("x", 0);
                tSpan.setAttribute("y", yPos);
                tSpan.style.display = "inherit";
                tElement.appendChild(tSpan);
                if (!this.textSpans[i]) this.textSpans[i] = {
                    span: null,
                    glyph: null
                };
                this.textSpans[i].span = tSpan;
                yPos += documentData.finalLineHeight;
            }
            this.layerElement.appendChild(tElement);
        } else {
            var cachedSpansLength = this.textSpans.length;
            var charData;
            for(i = 0; i < len; i += 1){
                if (!this.textSpans[i]) this.textSpans[i] = {
                    span: null,
                    childSpan: null,
                    glyph: null
                };
                if (!usesGlyphs || !singleShape || i === 0) {
                    tSpan = cachedSpansLength > i ? this.textSpans[i].span : createNS(usesGlyphs ? "g" : "text");
                    if (cachedSpansLength <= i) {
                        tSpan.setAttribute("stroke-linecap", "butt");
                        tSpan.setAttribute("stroke-linejoin", "round");
                        tSpan.setAttribute("stroke-miterlimit", "4");
                        this.textSpans[i].span = tSpan;
                        if (usesGlyphs) {
                            var childSpan = createNS("g");
                            tSpan.appendChild(childSpan);
                            this.textSpans[i].childSpan = childSpan;
                        }
                        this.textSpans[i].span = tSpan;
                        this.layerElement.appendChild(tSpan);
                    }
                    tSpan.style.display = "inherit";
                }
                matrixHelper.reset();
                if (singleShape) {
                    if (letters[i].n) {
                        xPos = -trackingOffset;
                        yPos += documentData.yOffset;
                        yPos += firstLine ? 1 : 0;
                        firstLine = false;
                    }
                    this.applyTextPropertiesToMatrix(documentData, matrixHelper, letters[i].line, xPos, yPos);
                    xPos += letters[i].l || 0; // xPos += letters[i].val === ' ' ? 0 : trackingOffset;
                    xPos += trackingOffset;
                }
                if (usesGlyphs) {
                    charData = this.globalData.fontManager.getCharData(documentData.finalText[i], fontData.fStyle, this.globalData.fontManager.getFontByName(documentData.f).fFamily);
                    var glyphElement; // t === 1 means the character has been replaced with an animated shaped
                    if (charData.t === 1) glyphElement = new SVGCompElement(charData.data, this.globalData, this);
                    else {
                        var data = emptyShapeData;
                        if (charData.data && charData.data.shapes) data = this.buildShapeData(charData.data, documentData.finalSize);
                        glyphElement = new SVGShapeElement(data, this.globalData, this);
                    }
                    if (this.textSpans[i].glyph) {
                        var glyph = this.textSpans[i].glyph;
                        this.textSpans[i].childSpan.removeChild(glyph.layerElement);
                        glyph.destroy();
                    }
                    this.textSpans[i].glyph = glyphElement;
                    glyphElement._debug = true;
                    glyphElement.prepareFrame(0);
                    glyphElement.renderFrame();
                    this.textSpans[i].childSpan.appendChild(glyphElement.layerElement); // when using animated shapes, the layer will be scaled instead of replacing the internal scale
                    // this might have issues with strokes and might need a different solution
                    if (charData.t === 1) this.textSpans[i].childSpan.setAttribute("transform", "scale(" + documentData.finalSize / 100 + "," + documentData.finalSize / 100 + ")");
                } else {
                    if (singleShape) tSpan.setAttribute("transform", "translate(" + matrixHelper.props[12] + "," + matrixHelper.props[13] + ")");
                    tSpan.textContent = letters[i].val;
                    tSpan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
                } //
            }
            if (singleShape && tSpan) tSpan.setAttribute("d", shapeStr);
        }
        while(i < this.textSpans.length){
            this.textSpans[i].span.style.display = "none";
            i += 1;
        }
        this._sizeChanged = true;
    };
    SVGTextLottieElement.prototype.sourceRectAtTime = function() {
        this.prepareFrame(this.comp.renderedFrame - this.data.st);
        this.renderInnerContent();
        if (this._sizeChanged) {
            this._sizeChanged = false;
            var textBox = this.layerElement.getBBox();
            this.bbox = {
                top: textBox.y,
                left: textBox.x,
                width: textBox.width,
                height: textBox.height
            };
        }
        return this.bbox;
    };
    SVGTextLottieElement.prototype.getValue = function() {
        var i;
        var len = this.textSpans.length;
        var glyphElement;
        this.renderedFrame = this.comp.renderedFrame;
        for(i = 0; i < len; i += 1){
            glyphElement = this.textSpans[i].glyph;
            if (glyphElement) {
                glyphElement.prepareFrame(this.comp.renderedFrame - this.data.st);
                if (glyphElement._mdf) this._mdf = true;
            }
        }
    };
    SVGTextLottieElement.prototype.renderInnerContent = function() {
        if (!this.data.singleShape || this._mdf) {
            this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag);
            if (this.lettersChangedFlag || this.textAnimator.lettersChangedFlag) {
                this._sizeChanged = true;
                var i;
                var len;
                var renderedLetters = this.textAnimator.renderedLetters;
                var letters = this.textProperty.currentData.l;
                len = letters.length;
                var renderedLetter;
                var textSpan;
                var glyphElement;
                for(i = 0; i < len; i += 1)if (!letters[i].n) {
                    renderedLetter = renderedLetters[i];
                    textSpan = this.textSpans[i].span;
                    glyphElement = this.textSpans[i].glyph;
                    if (glyphElement) glyphElement.renderFrame();
                    if (renderedLetter._mdf.m) textSpan.setAttribute("transform", renderedLetter.m);
                    if (renderedLetter._mdf.o) textSpan.setAttribute("opacity", renderedLetter.o);
                    if (renderedLetter._mdf.sw) textSpan.setAttribute("stroke-width", renderedLetter.sw);
                    if (renderedLetter._mdf.sc) textSpan.setAttribute("stroke", renderedLetter.sc);
                    if (renderedLetter._mdf.fc) textSpan.setAttribute("fill", renderedLetter.fc);
                }
            }
        }
    };
    function ISolidElement(data, globalData, comp) {
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        IImageElement
    ], ISolidElement);
    ISolidElement.prototype.createContent = function() {
        var rect = createNS("rect"); /// /rect.style.width = this.data.sw;
        /// /rect.style.height = this.data.sh;
        /// /rect.style.fill = this.data.sc;
        rect.setAttribute("width", this.data.sw);
        rect.setAttribute("height", this.data.sh);
        rect.setAttribute("fill", this.data.sc);
        this.layerElement.appendChild(rect);
    };
    function NullElement(data, globalData, comp) {
        this.initFrame();
        this.initBaseData(data, globalData, comp);
        this.initFrame();
        this.initTransform(data, globalData, comp);
        this.initHierarchy();
    }
    NullElement.prototype.prepareFrame = function(num) {
        this.prepareProperties(num, true);
    };
    NullElement.prototype.renderFrame = function() {};
    NullElement.prototype.getBaseElement = function() {
        return null;
    };
    NullElement.prototype.destroy = function() {};
    NullElement.prototype.sourceRectAtTime = function() {};
    NullElement.prototype.hide = function() {};
    extendPrototype([
        BaseElement,
        TransformElement,
        HierarchyElement,
        FrameElement
    ], NullElement);
    function SVGRendererBase() {}
    extendPrototype([
        BaseRenderer
    ], SVGRendererBase);
    SVGRendererBase.prototype.createNull = function(data) {
        return new NullElement(data, this.globalData, this);
    };
    SVGRendererBase.prototype.createShape = function(data) {
        return new SVGShapeElement(data, this.globalData, this);
    };
    SVGRendererBase.prototype.createText = function(data) {
        return new SVGTextLottieElement(data, this.globalData, this);
    };
    SVGRendererBase.prototype.createImage = function(data) {
        return new IImageElement(data, this.globalData, this);
    };
    SVGRendererBase.prototype.createSolid = function(data) {
        return new ISolidElement(data, this.globalData, this);
    };
    SVGRendererBase.prototype.configAnimation = function(animData) {
        this.svgElement.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this.svgElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        if (this.renderConfig.viewBoxSize) this.svgElement.setAttribute("viewBox", this.renderConfig.viewBoxSize);
        else this.svgElement.setAttribute("viewBox", "0 0 " + animData.w + " " + animData.h);
        if (!this.renderConfig.viewBoxOnly) {
            this.svgElement.setAttribute("width", animData.w);
            this.svgElement.setAttribute("height", animData.h);
            this.svgElement.style.width = "100%";
            this.svgElement.style.height = "100%";
            this.svgElement.style.transform = "translate3d(0,0,0)";
            this.svgElement.style.contentVisibility = this.renderConfig.contentVisibility;
        }
        if (this.renderConfig.width) this.svgElement.setAttribute("width", this.renderConfig.width);
        if (this.renderConfig.height) this.svgElement.setAttribute("height", this.renderConfig.height);
        if (this.renderConfig.className) this.svgElement.setAttribute("class", this.renderConfig.className);
        if (this.renderConfig.id) this.svgElement.setAttribute("id", this.renderConfig.id);
        if (this.renderConfig.focusable !== undefined) this.svgElement.setAttribute("focusable", this.renderConfig.focusable);
        this.svgElement.setAttribute("preserveAspectRatio", this.renderConfig.preserveAspectRatio); // this.layerElement.style.transform = 'translate3d(0,0,0)';
        // this.layerElement.style.transformOrigin = this.layerElement.style.mozTransformOrigin = this.layerElement.style.webkitTransformOrigin = this.layerElement.style['-webkit-transform'] = "0px 0px 0px";
        this.animationItem.wrapper.appendChild(this.svgElement); // Mask animation
        var defs = this.globalData.defs;
        this.setupGlobalData(animData, defs);
        this.globalData.progressiveLoad = this.renderConfig.progressiveLoad;
        this.data = animData;
        var maskElement = createNS("clipPath");
        var rect = createNS("rect");
        rect.setAttribute("width", animData.w);
        rect.setAttribute("height", animData.h);
        rect.setAttribute("x", 0);
        rect.setAttribute("y", 0);
        var maskId = createElementID();
        maskElement.setAttribute("id", maskId);
        maskElement.appendChild(rect);
        this.layerElement.setAttribute("clip-path", "url(" + getLocationHref() + "#" + maskId + ")");
        defs.appendChild(maskElement);
        this.layers = animData.layers;
        this.elements = createSizedArray(animData.layers.length);
    };
    SVGRendererBase.prototype.destroy = function() {
        if (this.animationItem.wrapper) this.animationItem.wrapper.innerText = "";
        this.layerElement = null;
        this.globalData.defs = null;
        var i;
        var len = this.layers ? this.layers.length : 0;
        for(i = 0; i < len; i += 1)if (this.elements[i]) this.elements[i].destroy();
        this.elements.length = 0;
        this.destroyed = true;
        this.animationItem = null;
    };
    SVGRendererBase.prototype.updateContainerSize = function() {};
    SVGRendererBase.prototype.findIndexByInd = function(ind) {
        var i = 0;
        var len = this.layers.length;
        for(i = 0; i < len; i += 1){
            if (this.layers[i].ind === ind) return i;
        }
        return -1;
    };
    SVGRendererBase.prototype.buildItem = function(pos) {
        var elements = this.elements;
        if (elements[pos] || this.layers[pos].ty === 99) return;
        elements[pos] = true;
        var element = this.createItem(this.layers[pos]);
        elements[pos] = element;
        if (getExpressionsPlugin()) {
            if (this.layers[pos].ty === 0) this.globalData.projectInterface.registerComposition(element);
            element.initExpressions();
        }
        this.appendElementInPos(element, pos);
        if (this.layers[pos].tt) {
            var elementIndex = "tp" in this.layers[pos] ? this.findIndexByInd(this.layers[pos].tp) : pos - 1;
            if (elementIndex === -1) return;
            if (!this.elements[elementIndex] || this.elements[elementIndex] === true) {
                this.buildItem(elementIndex);
                this.addPendingElement(element);
            } else {
                var matteElement = elements[elementIndex];
                var matteMask = matteElement.getMatte(this.layers[pos].tt);
                element.setMatte(matteMask);
            }
        }
    };
    SVGRendererBase.prototype.checkPendingElements = function() {
        while(this.pendingElements.length){
            var element = this.pendingElements.pop();
            element.checkParenting();
            if (element.data.tt) {
                var i = 0;
                var len = this.elements.length;
                while(i < len){
                    if (this.elements[i] === element) {
                        var elementIndex = "tp" in element.data ? this.findIndexByInd(element.data.tp) : i - 1;
                        var matteElement = this.elements[elementIndex];
                        var matteMask = matteElement.getMatte(this.layers[i].tt);
                        element.setMatte(matteMask);
                        break;
                    }
                    i += 1;
                }
            }
        }
    };
    SVGRendererBase.prototype.renderFrame = function(num) {
        if (this.renderedFrame === num || this.destroyed) return;
        if (num === null) num = this.renderedFrame;
        else this.renderedFrame = num;
         // console.log('-------');
        // console.log('FRAME ',num);
        this.globalData.frameNum = num;
        this.globalData.frameId += 1;
        this.globalData.projectInterface.currentFrame = num;
        this.globalData._mdf = false;
        var i;
        var len = this.layers.length;
        if (!this.completeLayers) this.checkLayers(num);
        for(i = len - 1; i >= 0; i -= 1)if (this.completeLayers || this.elements[i]) this.elements[i].prepareFrame(num - this.layers[i].st);
        if (this.globalData._mdf) {
            for(i = 0; i < len; i += 1)if (this.completeLayers || this.elements[i]) this.elements[i].renderFrame();
        }
    };
    SVGRendererBase.prototype.appendElementInPos = function(element, pos) {
        var newElement = element.getBaseElement();
        if (!newElement) return;
        var i = 0;
        var nextElement;
        while(i < pos){
            if (this.elements[i] && this.elements[i] !== true && this.elements[i].getBaseElement()) nextElement = this.elements[i].getBaseElement();
            i += 1;
        }
        if (nextElement) this.layerElement.insertBefore(newElement, nextElement);
        else this.layerElement.appendChild(newElement);
    };
    SVGRendererBase.prototype.hide = function() {
        this.layerElement.style.display = "none";
    };
    SVGRendererBase.prototype.show = function() {
        this.layerElement.style.display = "block";
    };
    function ICompElement() {}
    extendPrototype([
        BaseElement,
        TransformElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement
    ], ICompElement);
    ICompElement.prototype.initElement = function(data, globalData, comp) {
        this.initFrame();
        this.initBaseData(data, globalData, comp);
        this.initTransform(data, globalData, comp);
        this.initRenderable();
        this.initHierarchy();
        this.initRendererElement();
        this.createContainerElements();
        this.createRenderableComponents();
        if (this.data.xt || !globalData.progressiveLoad) this.buildAllItems();
        this.hide();
    };
    /* ICompElement.prototype.hide = function(){
      if(!this.hidden){
          this.hideElement();
          var i,len = this.elements.length;
          for( i = 0; i < len; i+=1 ){
              if(this.elements[i]){
                  this.elements[i].hide();
              }
          }
      }
  }; */ ICompElement.prototype.prepareFrame = function(num) {
        this._mdf = false;
        this.prepareRenderableFrame(num);
        this.prepareProperties(num, this.isInRange);
        if (!this.isInRange && !this.data.xt) return;
        if (!this.tm._placeholder) {
            var timeRemapped = this.tm.v;
            if (timeRemapped === this.data.op) timeRemapped = this.data.op - 1;
            this.renderedFrame = timeRemapped;
        } else this.renderedFrame = num / this.data.sr;
        var i;
        var len = this.elements.length;
        if (!this.completeLayers) this.checkLayers(this.renderedFrame);
         // This iteration needs to be backwards because of how expressions connect between each other
        for(i = len - 1; i >= 0; i -= 1)if (this.completeLayers || this.elements[i]) {
            this.elements[i].prepareFrame(this.renderedFrame - this.layers[i].st);
            if (this.elements[i]._mdf) this._mdf = true;
        }
    };
    ICompElement.prototype.renderInnerContent = function() {
        var i;
        var len = this.layers.length;
        for(i = 0; i < len; i += 1)if (this.completeLayers || this.elements[i]) this.elements[i].renderFrame();
    };
    ICompElement.prototype.setElements = function(elems) {
        this.elements = elems;
    };
    ICompElement.prototype.getElements = function() {
        return this.elements;
    };
    ICompElement.prototype.destroyElements = function() {
        var i;
        var len = this.layers.length;
        for(i = 0; i < len; i += 1)if (this.elements[i]) this.elements[i].destroy();
    };
    ICompElement.prototype.destroy = function() {
        this.destroyElements();
        this.destroyBaseElement();
    };
    function SVGCompElement(data, globalData, comp) {
        this.layers = data.layers;
        this.supports3d = true;
        this.completeLayers = false;
        this.pendingElements = [];
        this.elements = this.layers ? createSizedArray(this.layers.length) : [];
        this.initElement(data, globalData, comp);
        this.tm = data.tm ? PropertyFactory.getProp(this, data.tm, 0, globalData.frameRate, this) : {
            _placeholder: true
        };
    }
    extendPrototype([
        SVGRendererBase,
        ICompElement,
        SVGBaseElement
    ], SVGCompElement);
    SVGCompElement.prototype.createComp = function(data) {
        return new SVGCompElement(data, this.globalData, this);
    };
    function SVGRenderer(animationItem, config) {
        this.animationItem = animationItem;
        this.layers = null;
        this.renderedFrame = -1;
        this.svgElement = createNS("svg");
        var ariaLabel = "";
        if (config && config.title) {
            var titleElement = createNS("title");
            var titleId = createElementID();
            titleElement.setAttribute("id", titleId);
            titleElement.textContent = config.title;
            this.svgElement.appendChild(titleElement);
            ariaLabel += titleId;
        }
        if (config && config.description) {
            var descElement = createNS("desc");
            var descId = createElementID();
            descElement.setAttribute("id", descId);
            descElement.textContent = config.description;
            this.svgElement.appendChild(descElement);
            ariaLabel += " " + descId;
        }
        if (ariaLabel) this.svgElement.setAttribute("aria-labelledby", ariaLabel);
        var defs = createNS("defs");
        this.svgElement.appendChild(defs);
        var maskElement = createNS("g");
        this.svgElement.appendChild(maskElement);
        this.layerElement = maskElement;
        this.renderConfig = {
            preserveAspectRatio: config && config.preserveAspectRatio || "xMidYMid meet",
            imagePreserveAspectRatio: config && config.imagePreserveAspectRatio || "xMidYMid slice",
            contentVisibility: config && config.contentVisibility || "visible",
            progressiveLoad: config && config.progressiveLoad || false,
            hideOnTransparent: !(config && config.hideOnTransparent === false),
            viewBoxOnly: config && config.viewBoxOnly || false,
            viewBoxSize: config && config.viewBoxSize || false,
            className: config && config.className || "",
            id: config && config.id || "",
            focusable: config && config.focusable,
            filterSize: {
                width: config && config.filterSize && config.filterSize.width || "100%",
                height: config && config.filterSize && config.filterSize.height || "100%",
                x: config && config.filterSize && config.filterSize.x || "0%",
                y: config && config.filterSize && config.filterSize.y || "0%"
            },
            width: config && config.width,
            height: config && config.height,
            runExpressions: !config || config.runExpressions === undefined || config.runExpressions
        };
        this.globalData = {
            _mdf: false,
            frameNum: -1,
            defs: defs,
            renderConfig: this.renderConfig
        };
        this.elements = [];
        this.pendingElements = [];
        this.destroyed = false;
        this.rendererType = "svg";
    }
    extendPrototype([
        SVGRendererBase
    ], SVGRenderer);
    SVGRenderer.prototype.createComp = function(data) {
        return new SVGCompElement(data, this.globalData, this);
    };
    function CVContextData() {
        this.saved = [];
        this.cArrPos = 0;
        this.cTr = new Matrix();
        this.cO = 1;
        var i;
        var len = 15;
        this.savedOp = createTypedArray("float32", len);
        for(i = 0; i < len; i += 1)this.saved[i] = createTypedArray("float32", 16);
        this._length = len;
    }
    CVContextData.prototype.duplicate = function() {
        var newLength = this._length * 2;
        var currentSavedOp = this.savedOp;
        this.savedOp = createTypedArray("float32", newLength);
        this.savedOp.set(currentSavedOp);
        var i = 0;
        for(i = this._length; i < newLength; i += 1)this.saved[i] = createTypedArray("float32", 16);
        this._length = newLength;
    };
    CVContextData.prototype.reset = function() {
        this.cArrPos = 0;
        this.cTr.reset();
        this.cO = 1;
    };
    CVContextData.prototype.popTransform = function() {
        var popped = this.saved[this.cArrPos];
        var i;
        var arr = this.cTr.props;
        for(i = 0; i < 16; i += 1)arr[i] = popped[i];
        return popped;
    };
    CVContextData.prototype.popOpacity = function() {
        var popped = this.savedOp[this.cArrPos];
        this.cO = popped;
        return popped;
    };
    CVContextData.prototype.pop = function() {
        this.cArrPos -= 1;
        var transform = this.popTransform();
        var opacity = this.popOpacity();
        return {
            transform: transform,
            opacity: opacity
        };
    };
    CVContextData.prototype.push = function() {
        var props = this.cTr.props;
        if (this._length <= this.cArrPos) this.duplicate();
        var i;
        var arr = this.saved[this.cArrPos];
        for(i = 0; i < 16; i += 1)arr[i] = props[i];
        this.savedOp[this.cArrPos] = this.cO;
        this.cArrPos += 1;
    };
    CVContextData.prototype.getTransform = function() {
        return this.cTr;
    };
    CVContextData.prototype.getOpacity = function() {
        return this.cO;
    };
    CVContextData.prototype.setOpacity = function(value) {
        this.cO = value;
    };
    function ShapeTransformManager() {
        this.sequences = {};
        this.sequenceList = [];
        this.transform_key_count = 0;
    }
    ShapeTransformManager.prototype = {
        addTransformSequence: function addTransformSequence(transforms) {
            var i;
            var len = transforms.length;
            var key = "_";
            for(i = 0; i < len; i += 1)key += transforms[i].transform.key + "_";
            var sequence = this.sequences[key];
            if (!sequence) {
                sequence = {
                    transforms: [].concat(transforms),
                    finalTransform: new Matrix(),
                    _mdf: false
                };
                this.sequences[key] = sequence;
                this.sequenceList.push(sequence);
            }
            return sequence;
        },
        processSequence: function processSequence(sequence, isFirstFrame) {
            var i = 0;
            var len = sequence.transforms.length;
            var _mdf = isFirstFrame;
            while(i < len && !isFirstFrame){
                if (sequence.transforms[i].transform.mProps._mdf) {
                    _mdf = true;
                    break;
                }
                i += 1;
            }
            if (_mdf) {
                var props;
                sequence.finalTransform.reset();
                for(i = len - 1; i >= 0; i -= 1){
                    props = sequence.transforms[i].transform.mProps.v.props;
                    sequence.finalTransform.transform(props[0], props[1], props[2], props[3], props[4], props[5], props[6], props[7], props[8], props[9], props[10], props[11], props[12], props[13], props[14], props[15]);
                }
            }
            sequence._mdf = _mdf;
        },
        processSequences: function processSequences(isFirstFrame) {
            var i;
            var len = this.sequenceList.length;
            for(i = 0; i < len; i += 1)this.processSequence(this.sequenceList[i], isFirstFrame);
        },
        getNewKey: function getNewKey() {
            this.transform_key_count += 1;
            return "_" + this.transform_key_count;
        }
    };
    var lumaLoader = function lumaLoader() {
        var id = "__lottie_element_luma_buffer";
        var lumaBuffer = null;
        var lumaBufferCtx = null;
        var svg = null; // This alternate solution has a slight delay before the filter is applied, resulting in a flicker on the first frame.
        // Keeping this here for reference, and in the future, if offscreen canvas supports url filters, this can be used.
        // For now, neither of them work for offscreen canvas, so canvas workers can't support the luma track matte mask.
        // Naming it solution 2 to mark the extra comment lines.
        /*
    var svgString = [
      '<svg xmlns="http://www.w3.org/2000/svg">',
      '<filter id="' + id + '">',
      '<feColorMatrix type="matrix" color-interpolation-filters="sRGB" values="',
      '0.3, 0.3, 0.3, 0, 0, ',
      '0.3, 0.3, 0.3, 0, 0, ',
      '0.3, 0.3, 0.3, 0, 0, ',
      '0.3, 0.3, 0.3, 0, 0',
      '"/>',
      '</filter>',
      '</svg>',
    ].join('');
    var blob = new Blob([svgString], { type: 'image/svg+xml' });
    var url = URL.createObjectURL(blob);
    */ function createLumaSvgFilter() {
            var _svg = createNS("svg");
            var fil = createNS("filter");
            var matrix = createNS("feColorMatrix");
            fil.setAttribute("id", id);
            matrix.setAttribute("type", "matrix");
            matrix.setAttribute("color-interpolation-filters", "sRGB");
            matrix.setAttribute("values", "0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0, 0.3, 0.3, 0.3, 0, 0");
            fil.appendChild(matrix);
            _svg.appendChild(fil);
            _svg.setAttribute("id", id + "_svg");
            if (featureSupport.svgLumaHidden) _svg.style.display = "none";
            return _svg;
        }
        function loadLuma() {
            if (!lumaBuffer) {
                svg = createLumaSvgFilter();
                document.body.appendChild(svg);
                lumaBuffer = createTag("canvas");
                lumaBufferCtx = lumaBuffer.getContext("2d"); // lumaBufferCtx.filter = `url('${url}#__lottie_element_luma_buffer')`; // part of solution 2
                lumaBufferCtx.filter = "url(#" + id + ")";
                lumaBufferCtx.fillStyle = "rgba(0,0,0,0)";
                lumaBufferCtx.fillRect(0, 0, 1, 1);
            }
        }
        function getLuma(canvas) {
            if (!lumaBuffer) loadLuma();
            lumaBuffer.width = canvas.width;
            lumaBuffer.height = canvas.height; // lumaBufferCtx.filter = `url('${url}#__lottie_element_luma_buffer')`; // part of solution 2
            lumaBufferCtx.filter = "url(#" + id + ")";
            return lumaBuffer;
        }
        return {
            load: loadLuma,
            get: getLuma
        };
    };
    function createCanvas(width, height) {
        if (featureSupport.offscreenCanvas) return new OffscreenCanvas(width, height);
        var canvas = createTag("canvas");
        canvas.width = width;
        canvas.height = height;
        return canvas;
    }
    var assetLoader = function() {
        return {
            loadLumaCanvas: lumaLoader.load,
            getLumaCanvas: lumaLoader.get,
            createCanvas: createCanvas
        };
    }();
    function CVEffects() {}
    CVEffects.prototype.renderFrame = function() {};
    function CVMaskElement(data, element) {
        this.data = data;
        this.element = element;
        this.masksProperties = this.data.masksProperties || [];
        this.viewData = createSizedArray(this.masksProperties.length);
        var i;
        var len = this.masksProperties.length;
        var hasMasks = false;
        for(i = 0; i < len; i += 1){
            if (this.masksProperties[i].mode !== "n") hasMasks = true;
            this.viewData[i] = ShapePropertyFactory.getShapeProp(this.element, this.masksProperties[i], 3);
        }
        this.hasMasks = hasMasks;
        if (hasMasks) this.element.addRenderableComponent(this);
    }
    CVMaskElement.prototype.renderFrame = function() {
        if (!this.hasMasks) return;
        var transform = this.element.finalTransform.mat;
        var ctx = this.element.canvasContext;
        var i;
        var len = this.masksProperties.length;
        var pt;
        var pts;
        var data;
        ctx.beginPath();
        for(i = 0; i < len; i += 1)if (this.masksProperties[i].mode !== "n") {
            if (this.masksProperties[i].inv) {
                ctx.moveTo(0, 0);
                ctx.lineTo(this.element.globalData.compSize.w, 0);
                ctx.lineTo(this.element.globalData.compSize.w, this.element.globalData.compSize.h);
                ctx.lineTo(0, this.element.globalData.compSize.h);
                ctx.lineTo(0, 0);
            }
            data = this.viewData[i].v;
            pt = transform.applyToPointArray(data.v[0][0], data.v[0][1], 0);
            ctx.moveTo(pt[0], pt[1]);
            var j;
            var jLen = data._length;
            for(j = 1; j < jLen; j += 1){
                pts = transform.applyToTriplePoints(data.o[j - 1], data.i[j], data.v[j]);
                ctx.bezierCurveTo(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
            }
            pts = transform.applyToTriplePoints(data.o[j - 1], data.i[0], data.v[0]);
            ctx.bezierCurveTo(pts[0], pts[1], pts[2], pts[3], pts[4], pts[5]);
        }
        this.element.globalData.renderer.save(true);
        ctx.clip();
    };
    CVMaskElement.prototype.getMaskProperty = MaskElement.prototype.getMaskProperty;
    CVMaskElement.prototype.destroy = function() {
        this.element = null;
    };
    function CVBaseElement() {}
    var operationsMap = {
        1: "source-in",
        2: "source-out",
        3: "source-in",
        4: "source-out"
    };
    CVBaseElement.prototype = {
        createElements: function createElements() {},
        initRendererElement: function initRendererElement() {},
        createContainerElements: function createContainerElements() {
            // If the layer is masked we will use two buffers to store each different states of the drawing
            // This solution is not ideal for several reason. But unfortunately, because of the recursive
            // nature of the render tree, it's the only simple way to make sure one inner mask doesn't override an outer mask.
            // TODO: try to reduce the size of these buffers to the size of the composition contaning the layer
            // It might be challenging because the layer most likely is transformed in some way
            if (this.data.tt >= 1) {
                this.buffers = [];
                var canvasContext = this.globalData.canvasContext;
                var bufferCanvas = assetLoader.createCanvas(canvasContext.canvas.width, canvasContext.canvas.height);
                this.buffers.push(bufferCanvas);
                var bufferCanvas2 = assetLoader.createCanvas(canvasContext.canvas.width, canvasContext.canvas.height);
                this.buffers.push(bufferCanvas2);
                if (this.data.tt >= 3 && !document._isProxy) assetLoader.loadLumaCanvas();
            }
            this.canvasContext = this.globalData.canvasContext;
            this.transformCanvas = this.globalData.transformCanvas;
            this.renderableEffectsManager = new CVEffects(this);
        },
        createContent: function createContent() {},
        setBlendMode: function setBlendMode() {
            var globalData = this.globalData;
            if (globalData.blendMode !== this.data.bm) {
                globalData.blendMode = this.data.bm;
                var blendModeValue = getBlendMode(this.data.bm);
                globalData.canvasContext.globalCompositeOperation = blendModeValue;
            }
        },
        createRenderableComponents: function createRenderableComponents() {
            this.maskManager = new CVMaskElement(this.data, this);
        },
        hideElement: function hideElement() {
            if (!this.hidden && (!this.isInRange || this.isTransparent)) this.hidden = true;
        },
        showElement: function showElement() {
            if (this.isInRange && !this.isTransparent) {
                this.hidden = false;
                this._isFirstFrame = true;
                this.maskManager._isFirstFrame = true;
            }
        },
        clearCanvas: function clearCanvas(canvasContext) {
            canvasContext.clearRect(this.transformCanvas.tx, this.transformCanvas.ty, this.transformCanvas.w * this.transformCanvas.sx, this.transformCanvas.h * this.transformCanvas.sy);
        },
        prepareLayer: function prepareLayer() {
            if (this.data.tt >= 1) {
                var buffer = this.buffers[0];
                var bufferCtx = buffer.getContext("2d");
                this.clearCanvas(bufferCtx); // on the first buffer we store the current state of the global drawing
                bufferCtx.drawImage(this.canvasContext.canvas, 0, 0); // The next four lines are to clear the canvas
                // TODO: Check if there is a way to clear the canvas without resetting the transform
                this.currentTransform = this.canvasContext.getTransform();
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0);
                this.clearCanvas(this.canvasContext);
                this.canvasContext.setTransform(this.currentTransform);
            }
        },
        exitLayer: function exitLayer() {
            if (this.data.tt >= 1) {
                var buffer = this.buffers[1]; // On the second buffer we store the current state of the global drawing
                // that only contains the content of this layer
                // (if it is a composition, it also includes the nested layers)
                var bufferCtx = buffer.getContext("2d");
                this.clearCanvas(bufferCtx);
                bufferCtx.drawImage(this.canvasContext.canvas, 0, 0); // We clear the canvas again
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0);
                this.clearCanvas(this.canvasContext);
                this.canvasContext.setTransform(this.currentTransform); // We draw the mask
                var mask = this.comp.getElementById("tp" in this.data ? this.data.tp : this.data.ind - 1);
                mask.renderFrame(true); // We draw the second buffer (that contains the content of this layer)
                this.canvasContext.setTransform(1, 0, 0, 1, 0, 0); // If the mask is a Luma matte, we need to do two extra painting operations
                // the _isProxy check is to avoid drawing a fake canvas in workers that will throw an error
                if (this.data.tt >= 3 && !document._isProxy) {
                    // We copy the painted mask to a buffer that has a color matrix filter applied to it
                    // that applies the rgb values to the alpha channel
                    var lumaBuffer = assetLoader.getLumaCanvas(this.canvasContext.canvas);
                    var lumaBufferCtx = lumaBuffer.getContext("2d");
                    lumaBufferCtx.drawImage(this.canvasContext.canvas, 0, 0);
                    this.clearCanvas(this.canvasContext); // we repaint the context with the mask applied to it
                    this.canvasContext.drawImage(lumaBuffer, 0, 0);
                }
                this.canvasContext.globalCompositeOperation = operationsMap[this.data.tt];
                this.canvasContext.drawImage(buffer, 0, 0); // We finally draw the first buffer (that contains the content of the global drawing)
                // We use destination-over to draw the global drawing below the current layer
                this.canvasContext.globalCompositeOperation = "destination-over";
                this.canvasContext.drawImage(this.buffers[0], 0, 0);
                this.canvasContext.setTransform(this.currentTransform); // We reset the globalCompositeOperation to source-over, the standard type of operation
                this.canvasContext.globalCompositeOperation = "source-over";
            }
        },
        renderFrame: function renderFrame(forceRender) {
            if (this.hidden || this.data.hd) return;
            if (this.data.td === 1 && !forceRender) return;
            this.renderTransform();
            this.renderRenderable();
            this.setBlendMode();
            var forceRealStack = this.data.ty === 0;
            this.prepareLayer();
            this.globalData.renderer.save(forceRealStack);
            this.globalData.renderer.ctxTransform(this.finalTransform.mat.props);
            this.globalData.renderer.ctxOpacity(this.finalTransform.mProp.o.v);
            this.renderInnerContent();
            this.globalData.renderer.restore(forceRealStack);
            this.exitLayer();
            if (this.maskManager.hasMasks) this.globalData.renderer.restore(true);
            if (this._isFirstFrame) this._isFirstFrame = false;
        },
        destroy: function destroy() {
            this.canvasContext = null;
            this.data = null;
            this.globalData = null;
            this.maskManager.destroy();
        },
        mHelper: new Matrix()
    };
    CVBaseElement.prototype.hide = CVBaseElement.prototype.hideElement;
    CVBaseElement.prototype.show = CVBaseElement.prototype.showElement;
    function CVShapeData(element, data, styles, transformsManager) {
        this.styledShapes = [];
        this.tr = [
            0,
            0,
            0,
            0,
            0,
            0
        ];
        var ty = 4;
        if (data.ty === "rc") ty = 5;
        else if (data.ty === "el") ty = 6;
        else if (data.ty === "sr") ty = 7;
        this.sh = ShapePropertyFactory.getShapeProp(element, data, ty, element);
        var i;
        var len = styles.length;
        var styledShape;
        for(i = 0; i < len; i += 1)if (!styles[i].closed) {
            styledShape = {
                transforms: transformsManager.addTransformSequence(styles[i].transforms),
                trNodes: []
            };
            this.styledShapes.push(styledShape);
            styles[i].elements.push(styledShape);
        }
    }
    CVShapeData.prototype.setAsAnimated = SVGShapeData.prototype.setAsAnimated;
    function CVShapeElement(data, globalData, comp) {
        this.shapes = [];
        this.shapesData = data.shapes;
        this.stylesList = [];
        this.itemsData = [];
        this.prevViewData = [];
        this.shapeModifiers = [];
        this.processedElements = [];
        this.transformsManager = new ShapeTransformManager();
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        CVBaseElement,
        IShapeElement,
        HierarchyElement,
        FrameElement,
        RenderableElement
    ], CVShapeElement);
    CVShapeElement.prototype.initElement = RenderableDOMElement.prototype.initElement;
    CVShapeElement.prototype.transformHelper = {
        opacity: 1,
        _opMdf: false
    };
    CVShapeElement.prototype.dashResetter = [];
    CVShapeElement.prototype.createContent = function() {
        this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, true, []);
    };
    CVShapeElement.prototype.createStyleElement = function(data, transforms) {
        var styleElem = {
            data: data,
            type: data.ty,
            preTransforms: this.transformsManager.addTransformSequence(transforms),
            transforms: [],
            elements: [],
            closed: data.hd === true
        };
        var elementData = {};
        if (data.ty === "fl" || data.ty === "st") {
            elementData.c = PropertyFactory.getProp(this, data.c, 1, 255, this);
            if (!elementData.c.k) styleElem.co = "rgb(" + bmFloor(elementData.c.v[0]) + "," + bmFloor(elementData.c.v[1]) + "," + bmFloor(elementData.c.v[2]) + ")";
        } else if (data.ty === "gf" || data.ty === "gs") {
            elementData.s = PropertyFactory.getProp(this, data.s, 1, null, this);
            elementData.e = PropertyFactory.getProp(this, data.e, 1, null, this);
            elementData.h = PropertyFactory.getProp(this, data.h || {
                k: 0
            }, 0, 0.01, this);
            elementData.a = PropertyFactory.getProp(this, data.a || {
                k: 0
            }, 0, degToRads, this);
            elementData.g = new GradientProperty(this, data.g, this);
        }
        elementData.o = PropertyFactory.getProp(this, data.o, 0, 0.01, this);
        if (data.ty === "st" || data.ty === "gs") {
            styleElem.lc = lineCapEnum[data.lc || 2];
            styleElem.lj = lineJoinEnum[data.lj || 2];
            if (data.lj == 1) // eslint-disable-line eqeqeq
            styleElem.ml = data.ml;
            elementData.w = PropertyFactory.getProp(this, data.w, 0, null, this);
            if (!elementData.w.k) styleElem.wi = elementData.w.v;
            if (data.d) {
                var d = new DashProperty(this, data.d, "canvas", this);
                elementData.d = d;
                if (!elementData.d.k) {
                    styleElem.da = elementData.d.dashArray;
                    styleElem["do"] = elementData.d.dashoffset[0];
                }
            }
        } else styleElem.r = data.r === 2 ? "evenodd" : "nonzero";
        this.stylesList.push(styleElem);
        elementData.style = styleElem;
        return elementData;
    };
    CVShapeElement.prototype.createGroupElement = function() {
        var elementData = {
            it: [],
            prevViewData: []
        };
        return elementData;
    };
    CVShapeElement.prototype.createTransformElement = function(data) {
        var elementData = {
            transform: {
                opacity: 1,
                _opMdf: false,
                key: this.transformsManager.getNewKey(),
                op: PropertyFactory.getProp(this, data.o, 0, 0.01, this),
                mProps: TransformPropertyFactory.getTransformProperty(this, data, this)
            }
        };
        return elementData;
    };
    CVShapeElement.prototype.createShapeElement = function(data) {
        var elementData = new CVShapeData(this, data, this.stylesList, this.transformsManager);
        this.shapes.push(elementData);
        this.addShapeToModifiers(elementData);
        return elementData;
    };
    CVShapeElement.prototype.reloadShapes = function() {
        this._isFirstFrame = true;
        var i;
        var len = this.itemsData.length;
        for(i = 0; i < len; i += 1)this.prevViewData[i] = this.itemsData[i];
        this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, true, []);
        len = this.dynamicProperties.length;
        for(i = 0; i < len; i += 1)this.dynamicProperties[i].getValue();
        this.renderModifiers();
        this.transformsManager.processSequences(this._isFirstFrame);
    };
    CVShapeElement.prototype.addTransformToStyleList = function(transform) {
        var i;
        var len = this.stylesList.length;
        for(i = 0; i < len; i += 1)if (!this.stylesList[i].closed) this.stylesList[i].transforms.push(transform);
    };
    CVShapeElement.prototype.removeTransformFromStyleList = function() {
        var i;
        var len = this.stylesList.length;
        for(i = 0; i < len; i += 1)if (!this.stylesList[i].closed) this.stylesList[i].transforms.pop();
    };
    CVShapeElement.prototype.closeStyles = function(styles) {
        var i;
        var len = styles.length;
        for(i = 0; i < len; i += 1)styles[i].closed = true;
    };
    CVShapeElement.prototype.searchShapes = function(arr, itemsData, prevViewData, shouldRender, transforms) {
        var i;
        var len = arr.length - 1;
        var j;
        var jLen;
        var ownStyles = [];
        var ownModifiers = [];
        var processedPos;
        var modifier;
        var currentTransform;
        var ownTransforms = [].concat(transforms);
        for(i = len; i >= 0; i -= 1){
            processedPos = this.searchProcessedElement(arr[i]);
            if (!processedPos) arr[i]._shouldRender = shouldRender;
            else itemsData[i] = prevViewData[processedPos - 1];
            if (arr[i].ty === "fl" || arr[i].ty === "st" || arr[i].ty === "gf" || arr[i].ty === "gs") {
                if (!processedPos) itemsData[i] = this.createStyleElement(arr[i], ownTransforms);
                else itemsData[i].style.closed = false;
                ownStyles.push(itemsData[i].style);
            } else if (arr[i].ty === "gr") {
                if (!processedPos) itemsData[i] = this.createGroupElement(arr[i]);
                else {
                    jLen = itemsData[i].it.length;
                    for(j = 0; j < jLen; j += 1)itemsData[i].prevViewData[j] = itemsData[i].it[j];
                }
                this.searchShapes(arr[i].it, itemsData[i].it, itemsData[i].prevViewData, shouldRender, ownTransforms);
            } else if (arr[i].ty === "tr") {
                if (!processedPos) {
                    currentTransform = this.createTransformElement(arr[i]);
                    itemsData[i] = currentTransform;
                }
                ownTransforms.push(itemsData[i]);
                this.addTransformToStyleList(itemsData[i]);
            } else if (arr[i].ty === "sh" || arr[i].ty === "rc" || arr[i].ty === "el" || arr[i].ty === "sr") {
                if (!processedPos) itemsData[i] = this.createShapeElement(arr[i]);
            } else if (arr[i].ty === "tm" || arr[i].ty === "rd" || arr[i].ty === "pb" || arr[i].ty === "zz" || arr[i].ty === "op") {
                if (!processedPos) {
                    modifier = ShapeModifiers.getModifier(arr[i].ty);
                    modifier.init(this, arr[i]);
                    itemsData[i] = modifier;
                    this.shapeModifiers.push(modifier);
                } else {
                    modifier = itemsData[i];
                    modifier.closed = false;
                }
                ownModifiers.push(modifier);
            } else if (arr[i].ty === "rp") {
                if (!processedPos) {
                    modifier = ShapeModifiers.getModifier(arr[i].ty);
                    itemsData[i] = modifier;
                    modifier.init(this, arr, i, itemsData);
                    this.shapeModifiers.push(modifier);
                    shouldRender = false;
                } else {
                    modifier = itemsData[i];
                    modifier.closed = true;
                }
                ownModifiers.push(modifier);
            }
            this.addProcessedElement(arr[i], i + 1);
        }
        this.removeTransformFromStyleList();
        this.closeStyles(ownStyles);
        len = ownModifiers.length;
        for(i = 0; i < len; i += 1)ownModifiers[i].closed = true;
    };
    CVShapeElement.prototype.renderInnerContent = function() {
        this.transformHelper.opacity = 1;
        this.transformHelper._opMdf = false;
        this.renderModifiers();
        this.transformsManager.processSequences(this._isFirstFrame);
        this.renderShape(this.transformHelper, this.shapesData, this.itemsData, true);
    };
    CVShapeElement.prototype.renderShapeTransform = function(parentTransform, groupTransform) {
        if (parentTransform._opMdf || groupTransform.op._mdf || this._isFirstFrame) {
            groupTransform.opacity = parentTransform.opacity;
            groupTransform.opacity *= groupTransform.op.v;
            groupTransform._opMdf = true;
        }
    };
    CVShapeElement.prototype.drawLayer = function() {
        var i;
        var len = this.stylesList.length;
        var j;
        var jLen;
        var k;
        var kLen;
        var elems;
        var nodes;
        var renderer = this.globalData.renderer;
        var ctx = this.globalData.canvasContext;
        var type;
        var currentStyle;
        for(i = 0; i < len; i += 1){
            currentStyle = this.stylesList[i];
            type = currentStyle.type; // Skipping style when
            // Stroke width equals 0
            // style should not be rendered (extra unused repeaters)
            // current opacity equals 0
            // global opacity equals 0
            if (!((type === "st" || type === "gs") && currentStyle.wi === 0 || !currentStyle.data._shouldRender || currentStyle.coOp === 0 || this.globalData.currentGlobalAlpha === 0)) {
                renderer.save();
                elems = currentStyle.elements;
                if (type === "st" || type === "gs") {
                    ctx.strokeStyle = type === "st" ? currentStyle.co : currentStyle.grd;
                    ctx.lineWidth = currentStyle.wi;
                    ctx.lineCap = currentStyle.lc;
                    ctx.lineJoin = currentStyle.lj;
                    ctx.miterLimit = currentStyle.ml || 0;
                } else ctx.fillStyle = type === "fl" ? currentStyle.co : currentStyle.grd;
                renderer.ctxOpacity(currentStyle.coOp);
                if (type !== "st" && type !== "gs") ctx.beginPath();
                renderer.ctxTransform(currentStyle.preTransforms.finalTransform.props);
                jLen = elems.length;
                for(j = 0; j < jLen; j += 1){
                    if (type === "st" || type === "gs") {
                        ctx.beginPath();
                        if (currentStyle.da) {
                            ctx.setLineDash(currentStyle.da);
                            ctx.lineDashOffset = currentStyle["do"];
                        }
                    }
                    nodes = elems[j].trNodes;
                    kLen = nodes.length;
                    for(k = 0; k < kLen; k += 1){
                        if (nodes[k].t === "m") ctx.moveTo(nodes[k].p[0], nodes[k].p[1]);
                        else if (nodes[k].t === "c") ctx.bezierCurveTo(nodes[k].pts[0], nodes[k].pts[1], nodes[k].pts[2], nodes[k].pts[3], nodes[k].pts[4], nodes[k].pts[5]);
                        else ctx.closePath();
                    }
                    if (type === "st" || type === "gs") {
                        ctx.stroke();
                        if (currentStyle.da) ctx.setLineDash(this.dashResetter);
                    }
                }
                if (type !== "st" && type !== "gs") ctx.fill(currentStyle.r);
                renderer.restore();
            }
        }
    };
    CVShapeElement.prototype.renderShape = function(parentTransform, items, data, isMain) {
        var i;
        var len = items.length - 1;
        var groupTransform;
        groupTransform = parentTransform;
        for(i = len; i >= 0; i -= 1){
            if (items[i].ty === "tr") {
                groupTransform = data[i].transform;
                this.renderShapeTransform(parentTransform, groupTransform);
            } else if (items[i].ty === "sh" || items[i].ty === "el" || items[i].ty === "rc" || items[i].ty === "sr") this.renderPath(items[i], data[i]);
            else if (items[i].ty === "fl") this.renderFill(items[i], data[i], groupTransform);
            else if (items[i].ty === "st") this.renderStroke(items[i], data[i], groupTransform);
            else if (items[i].ty === "gf" || items[i].ty === "gs") this.renderGradientFill(items[i], data[i], groupTransform);
            else if (items[i].ty === "gr") this.renderShape(groupTransform, items[i].it, data[i].it);
            else items[i].ty;
        }
        if (isMain) this.drawLayer();
    };
    CVShapeElement.prototype.renderStyledShape = function(styledShape, shape) {
        if (this._isFirstFrame || shape._mdf || styledShape.transforms._mdf) {
            var shapeNodes = styledShape.trNodes;
            var paths = shape.paths;
            var i;
            var len;
            var j;
            var jLen = paths._length;
            shapeNodes.length = 0;
            var groupTransformMat = styledShape.transforms.finalTransform;
            for(j = 0; j < jLen; j += 1){
                var pathNodes = paths.shapes[j];
                if (pathNodes && pathNodes.v) {
                    len = pathNodes._length;
                    for(i = 1; i < len; i += 1){
                        if (i === 1) shapeNodes.push({
                            t: "m",
                            p: groupTransformMat.applyToPointArray(pathNodes.v[0][0], pathNodes.v[0][1], 0)
                        });
                        shapeNodes.push({
                            t: "c",
                            pts: groupTransformMat.applyToTriplePoints(pathNodes.o[i - 1], pathNodes.i[i], pathNodes.v[i])
                        });
                    }
                    if (len === 1) shapeNodes.push({
                        t: "m",
                        p: groupTransformMat.applyToPointArray(pathNodes.v[0][0], pathNodes.v[0][1], 0)
                    });
                    if (pathNodes.c && len) {
                        shapeNodes.push({
                            t: "c",
                            pts: groupTransformMat.applyToTriplePoints(pathNodes.o[i - 1], pathNodes.i[0], pathNodes.v[0])
                        });
                        shapeNodes.push({
                            t: "z"
                        });
                    }
                }
            }
            styledShape.trNodes = shapeNodes;
        }
    };
    CVShapeElement.prototype.renderPath = function(pathData, itemData) {
        if (pathData.hd !== true && pathData._shouldRender) {
            var i;
            var len = itemData.styledShapes.length;
            for(i = 0; i < len; i += 1)this.renderStyledShape(itemData.styledShapes[i], itemData.sh);
        }
    };
    CVShapeElement.prototype.renderFill = function(styleData, itemData, groupTransform) {
        var styleElem = itemData.style;
        if (itemData.c._mdf || this._isFirstFrame) styleElem.co = "rgb(" + bmFloor(itemData.c.v[0]) + "," + bmFloor(itemData.c.v[1]) + "," + bmFloor(itemData.c.v[2]) + ")";
        if (itemData.o._mdf || groupTransform._opMdf || this._isFirstFrame) styleElem.coOp = itemData.o.v * groupTransform.opacity;
    };
    CVShapeElement.prototype.renderGradientFill = function(styleData, itemData, groupTransform) {
        var styleElem = itemData.style;
        var grd;
        if (!styleElem.grd || itemData.g._mdf || itemData.s._mdf || itemData.e._mdf || styleData.t !== 1 && (itemData.h._mdf || itemData.a._mdf)) {
            var ctx = this.globalData.canvasContext;
            var pt1 = itemData.s.v;
            var pt2 = itemData.e.v;
            if (styleData.t === 1) grd = ctx.createLinearGradient(pt1[0], pt1[1], pt2[0], pt2[1]);
            else {
                var rad = Math.sqrt(Math.pow(pt1[0] - pt2[0], 2) + Math.pow(pt1[1] - pt2[1], 2));
                var ang = Math.atan2(pt2[1] - pt1[1], pt2[0] - pt1[0]);
                var percent = itemData.h.v;
                if (percent >= 1) percent = 0.99;
                else if (percent <= -1) percent = -0.99;
                var dist = rad * percent;
                var x = Math.cos(ang + itemData.a.v) * dist + pt1[0];
                var y = Math.sin(ang + itemData.a.v) * dist + pt1[1];
                grd = ctx.createRadialGradient(x, y, 0, pt1[0], pt1[1], rad);
            }
            var i;
            var len = styleData.g.p;
            var cValues = itemData.g.c;
            var opacity = 1;
            for(i = 0; i < len; i += 1){
                if (itemData.g._hasOpacity && itemData.g._collapsable) opacity = itemData.g.o[i * 2 + 1];
                grd.addColorStop(cValues[i * 4] / 100, "rgba(" + cValues[i * 4 + 1] + "," + cValues[i * 4 + 2] + "," + cValues[i * 4 + 3] + "," + opacity + ")");
            }
            styleElem.grd = grd;
        }
        styleElem.coOp = itemData.o.v * groupTransform.opacity;
    };
    CVShapeElement.prototype.renderStroke = function(styleData, itemData, groupTransform) {
        var styleElem = itemData.style;
        var d = itemData.d;
        if (d && (d._mdf || this._isFirstFrame)) {
            styleElem.da = d.dashArray;
            styleElem["do"] = d.dashoffset[0];
        }
        if (itemData.c._mdf || this._isFirstFrame) styleElem.co = "rgb(" + bmFloor(itemData.c.v[0]) + "," + bmFloor(itemData.c.v[1]) + "," + bmFloor(itemData.c.v[2]) + ")";
        if (itemData.o._mdf || groupTransform._opMdf || this._isFirstFrame) styleElem.coOp = itemData.o.v * groupTransform.opacity;
        if (itemData.w._mdf || this._isFirstFrame) styleElem.wi = itemData.w.v;
    };
    CVShapeElement.prototype.destroy = function() {
        this.shapesData = null;
        this.globalData = null;
        this.canvasContext = null;
        this.stylesList.length = 0;
        this.itemsData.length = 0;
    };
    function CVTextElement(data, globalData, comp) {
        this.textSpans = [];
        this.yOffset = 0;
        this.fillColorAnim = false;
        this.strokeColorAnim = false;
        this.strokeWidthAnim = false;
        this.stroke = false;
        this.fill = false;
        this.justifyOffset = 0;
        this.currentRender = null;
        this.renderType = "canvas";
        this.values = {
            fill: "rgba(0,0,0,0)",
            stroke: "rgba(0,0,0,0)",
            sWidth: 0,
            fValue: ""
        };
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        CVBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableElement,
        ITextElement
    ], CVTextElement);
    CVTextElement.prototype.tHelper = createTag("canvas").getContext("2d");
    CVTextElement.prototype.buildNewText = function() {
        var documentData = this.textProperty.currentData;
        this.renderedLetters = createSizedArray(documentData.l ? documentData.l.length : 0);
        var hasFill = false;
        if (documentData.fc) {
            hasFill = true;
            this.values.fill = this.buildColor(documentData.fc);
        } else this.values.fill = "rgba(0,0,0,0)";
        this.fill = hasFill;
        var hasStroke = false;
        if (documentData.sc) {
            hasStroke = true;
            this.values.stroke = this.buildColor(documentData.sc);
            this.values.sWidth = documentData.sw;
        }
        var fontData = this.globalData.fontManager.getFontByName(documentData.f);
        var i;
        var len;
        var letters = documentData.l;
        var matrixHelper = this.mHelper;
        this.stroke = hasStroke;
        this.values.fValue = documentData.finalSize + "px " + this.globalData.fontManager.getFontByName(documentData.f).fFamily;
        len = documentData.finalText.length; // this.tHelper.font = this.values.fValue;
        var charData;
        var shapeData;
        var k;
        var kLen;
        var shapes;
        var j;
        var jLen;
        var pathNodes;
        var commands;
        var pathArr;
        var singleShape = this.data.singleShape;
        var trackingOffset = documentData.tr * 0.001 * documentData.finalSize;
        var xPos = 0;
        var yPos = 0;
        var firstLine = true;
        var cnt = 0;
        for(i = 0; i < len; i += 1){
            charData = this.globalData.fontManager.getCharData(documentData.finalText[i], fontData.fStyle, this.globalData.fontManager.getFontByName(documentData.f).fFamily);
            shapeData = charData && charData.data || {};
            matrixHelper.reset();
            if (singleShape && letters[i].n) {
                xPos = -trackingOffset;
                yPos += documentData.yOffset;
                yPos += firstLine ? 1 : 0;
                firstLine = false;
            }
            shapes = shapeData.shapes ? shapeData.shapes[0].it : [];
            jLen = shapes.length;
            matrixHelper.scale(documentData.finalSize / 100, documentData.finalSize / 100);
            if (singleShape) this.applyTextPropertiesToMatrix(documentData, matrixHelper, letters[i].line, xPos, yPos);
            commands = createSizedArray(jLen - 1);
            var commandsCounter = 0;
            for(j = 0; j < jLen; j += 1)if (shapes[j].ty === "sh") {
                kLen = shapes[j].ks.k.i.length;
                pathNodes = shapes[j].ks.k;
                pathArr = [];
                for(k = 1; k < kLen; k += 1){
                    if (k === 1) pathArr.push(matrixHelper.applyToX(pathNodes.v[0][0], pathNodes.v[0][1], 0), matrixHelper.applyToY(pathNodes.v[0][0], pathNodes.v[0][1], 0));
                    pathArr.push(matrixHelper.applyToX(pathNodes.o[k - 1][0], pathNodes.o[k - 1][1], 0), matrixHelper.applyToY(pathNodes.o[k - 1][0], pathNodes.o[k - 1][1], 0), matrixHelper.applyToX(pathNodes.i[k][0], pathNodes.i[k][1], 0), matrixHelper.applyToY(pathNodes.i[k][0], pathNodes.i[k][1], 0), matrixHelper.applyToX(pathNodes.v[k][0], pathNodes.v[k][1], 0), matrixHelper.applyToY(pathNodes.v[k][0], pathNodes.v[k][1], 0));
                }
                pathArr.push(matrixHelper.applyToX(pathNodes.o[k - 1][0], pathNodes.o[k - 1][1], 0), matrixHelper.applyToY(pathNodes.o[k - 1][0], pathNodes.o[k - 1][1], 0), matrixHelper.applyToX(pathNodes.i[0][0], pathNodes.i[0][1], 0), matrixHelper.applyToY(pathNodes.i[0][0], pathNodes.i[0][1], 0), matrixHelper.applyToX(pathNodes.v[0][0], pathNodes.v[0][1], 0), matrixHelper.applyToY(pathNodes.v[0][0], pathNodes.v[0][1], 0));
                commands[commandsCounter] = pathArr;
                commandsCounter += 1;
            }
            if (singleShape) {
                xPos += letters[i].l;
                xPos += trackingOffset;
            }
            if (this.textSpans[cnt]) this.textSpans[cnt].elem = commands;
            else this.textSpans[cnt] = {
                elem: commands
            };
            cnt += 1;
        }
    };
    CVTextElement.prototype.renderInnerContent = function() {
        var ctx = this.canvasContext;
        ctx.font = this.values.fValue;
        ctx.lineCap = "butt";
        ctx.lineJoin = "miter";
        ctx.miterLimit = 4;
        if (!this.data.singleShape) this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag);
        var i;
        var len;
        var j;
        var jLen;
        var k;
        var kLen;
        var renderedLetters = this.textAnimator.renderedLetters;
        var letters = this.textProperty.currentData.l;
        len = letters.length;
        var renderedLetter;
        var lastFill = null;
        var lastStroke = null;
        var lastStrokeW = null;
        var commands;
        var pathArr;
        for(i = 0; i < len; i += 1)if (!letters[i].n) {
            renderedLetter = renderedLetters[i];
            if (renderedLetter) {
                this.globalData.renderer.save();
                this.globalData.renderer.ctxTransform(renderedLetter.p);
                this.globalData.renderer.ctxOpacity(renderedLetter.o);
            }
            if (this.fill) {
                if (renderedLetter && renderedLetter.fc) {
                    if (lastFill !== renderedLetter.fc) {
                        lastFill = renderedLetter.fc;
                        ctx.fillStyle = renderedLetter.fc;
                    }
                } else if (lastFill !== this.values.fill) {
                    lastFill = this.values.fill;
                    ctx.fillStyle = this.values.fill;
                }
                commands = this.textSpans[i].elem;
                jLen = commands.length;
                this.globalData.canvasContext.beginPath();
                for(j = 0; j < jLen; j += 1){
                    pathArr = commands[j];
                    kLen = pathArr.length;
                    this.globalData.canvasContext.moveTo(pathArr[0], pathArr[1]);
                    for(k = 2; k < kLen; k += 6)this.globalData.canvasContext.bezierCurveTo(pathArr[k], pathArr[k + 1], pathArr[k + 2], pathArr[k + 3], pathArr[k + 4], pathArr[k + 5]);
                }
                this.globalData.canvasContext.closePath();
                this.globalData.canvasContext.fill(); /// ctx.fillText(this.textSpans[i].val,0,0);
            }
            if (this.stroke) {
                if (renderedLetter && renderedLetter.sw) {
                    if (lastStrokeW !== renderedLetter.sw) {
                        lastStrokeW = renderedLetter.sw;
                        ctx.lineWidth = renderedLetter.sw;
                    }
                } else if (lastStrokeW !== this.values.sWidth) {
                    lastStrokeW = this.values.sWidth;
                    ctx.lineWidth = this.values.sWidth;
                }
                if (renderedLetter && renderedLetter.sc) {
                    if (lastStroke !== renderedLetter.sc) {
                        lastStroke = renderedLetter.sc;
                        ctx.strokeStyle = renderedLetter.sc;
                    }
                } else if (lastStroke !== this.values.stroke) {
                    lastStroke = this.values.stroke;
                    ctx.strokeStyle = this.values.stroke;
                }
                commands = this.textSpans[i].elem;
                jLen = commands.length;
                this.globalData.canvasContext.beginPath();
                for(j = 0; j < jLen; j += 1){
                    pathArr = commands[j];
                    kLen = pathArr.length;
                    this.globalData.canvasContext.moveTo(pathArr[0], pathArr[1]);
                    for(k = 2; k < kLen; k += 6)this.globalData.canvasContext.bezierCurveTo(pathArr[k], pathArr[k + 1], pathArr[k + 2], pathArr[k + 3], pathArr[k + 4], pathArr[k + 5]);
                }
                this.globalData.canvasContext.closePath();
                this.globalData.canvasContext.stroke(); /// ctx.strokeText(letters[i].val,0,0);
            }
            if (renderedLetter) this.globalData.renderer.restore();
        }
    };
    function CVImageElement(data, globalData, comp) {
        this.assetData = globalData.getAssetData(data.refId);
        this.img = globalData.imageLoader.getAsset(this.assetData);
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        CVBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableElement
    ], CVImageElement);
    CVImageElement.prototype.initElement = SVGShapeElement.prototype.initElement;
    CVImageElement.prototype.prepareFrame = IImageElement.prototype.prepareFrame;
    CVImageElement.prototype.createContent = function() {
        if (this.img.width && (this.assetData.w !== this.img.width || this.assetData.h !== this.img.height)) {
            var canvas = createTag("canvas");
            canvas.width = this.assetData.w;
            canvas.height = this.assetData.h;
            var ctx = canvas.getContext("2d");
            var imgW = this.img.width;
            var imgH = this.img.height;
            var imgRel = imgW / imgH;
            var canvasRel = this.assetData.w / this.assetData.h;
            var widthCrop;
            var heightCrop;
            var par = this.assetData.pr || this.globalData.renderConfig.imagePreserveAspectRatio;
            if (imgRel > canvasRel && par === "xMidYMid slice" || imgRel < canvasRel && par !== "xMidYMid slice") {
                heightCrop = imgH;
                widthCrop = heightCrop * canvasRel;
            } else {
                widthCrop = imgW;
                heightCrop = widthCrop / canvasRel;
            }
            ctx.drawImage(this.img, (imgW - widthCrop) / 2, (imgH - heightCrop) / 2, widthCrop, heightCrop, 0, 0, this.assetData.w, this.assetData.h);
            this.img = canvas;
        }
    };
    CVImageElement.prototype.renderInnerContent = function() {
        this.canvasContext.drawImage(this.img, 0, 0);
    };
    CVImageElement.prototype.destroy = function() {
        this.img = null;
    };
    function CVSolidElement(data, globalData, comp) {
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        CVBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableElement
    ], CVSolidElement);
    CVSolidElement.prototype.initElement = SVGShapeElement.prototype.initElement;
    CVSolidElement.prototype.prepareFrame = IImageElement.prototype.prepareFrame;
    CVSolidElement.prototype.renderInnerContent = function() {
        var ctx = this.canvasContext;
        ctx.fillStyle = this.data.sc;
        ctx.fillRect(0, 0, this.data.sw, this.data.sh); //
    };
    function CanvasRendererBase(animationItem, config) {
        this.animationItem = animationItem;
        this.renderConfig = {
            clearCanvas: config && config.clearCanvas !== undefined ? config.clearCanvas : true,
            context: config && config.context || null,
            progressiveLoad: config && config.progressiveLoad || false,
            preserveAspectRatio: config && config.preserveAspectRatio || "xMidYMid meet",
            imagePreserveAspectRatio: config && config.imagePreserveAspectRatio || "xMidYMid slice",
            contentVisibility: config && config.contentVisibility || "visible",
            className: config && config.className || "",
            id: config && config.id || ""
        };
        this.renderConfig.dpr = config && config.dpr || 1;
        if (this.animationItem.wrapper) this.renderConfig.dpr = config && config.dpr || window.devicePixelRatio || 1;
        this.renderedFrame = -1;
        this.globalData = {
            frameNum: -1,
            _mdf: false,
            renderConfig: this.renderConfig,
            currentGlobalAlpha: -1
        };
        this.contextData = new CVContextData();
        this.elements = [];
        this.pendingElements = [];
        this.transformMat = new Matrix();
        this.completeLayers = false;
        this.rendererType = "canvas";
    }
    extendPrototype([
        BaseRenderer
    ], CanvasRendererBase);
    CanvasRendererBase.prototype.createShape = function(data) {
        return new CVShapeElement(data, this.globalData, this);
    };
    CanvasRendererBase.prototype.createText = function(data) {
        return new CVTextElement(data, this.globalData, this);
    };
    CanvasRendererBase.prototype.createImage = function(data) {
        return new CVImageElement(data, this.globalData, this);
    };
    CanvasRendererBase.prototype.createSolid = function(data) {
        return new CVSolidElement(data, this.globalData, this);
    };
    CanvasRendererBase.prototype.createNull = SVGRenderer.prototype.createNull;
    CanvasRendererBase.prototype.ctxTransform = function(props) {
        if (props[0] === 1 && props[1] === 0 && props[4] === 0 && props[5] === 1 && props[12] === 0 && props[13] === 0) return;
        if (!this.renderConfig.clearCanvas) {
            this.canvasContext.transform(props[0], props[1], props[4], props[5], props[12], props[13]);
            return;
        } // Resetting the canvas transform matrix to the new transform
        this.transformMat.cloneFromProps(props); // Taking the last transform value from the stored stack of transforms
        var currentTransform = this.contextData.getTransform();
        var cProps = currentTransform.props; // Applying the last transform value after the new transform to respect the order of transformations
        this.transformMat.transform(cProps[0], cProps[1], cProps[2], cProps[3], cProps[4], cProps[5], cProps[6], cProps[7], cProps[8], cProps[9], cProps[10], cProps[11], cProps[12], cProps[13], cProps[14], cProps[15]); // Storing the new transformed value in the stored transform
        currentTransform.cloneFromProps(this.transformMat.props);
        var trProps = currentTransform.props; // Applying the new transform to the canvas
        this.canvasContext.setTransform(trProps[0], trProps[1], trProps[4], trProps[5], trProps[12], trProps[13]);
    };
    CanvasRendererBase.prototype.ctxOpacity = function(op) {
        /* if(op === 1){
          return;
      } */ var currentOpacity = this.contextData.getOpacity();
        if (!this.renderConfig.clearCanvas) {
            this.canvasContext.globalAlpha *= op < 0 ? 0 : op;
            this.globalData.currentGlobalAlpha = currentOpacity;
            return;
        }
        currentOpacity *= op < 0 ? 0 : op;
        this.contextData.setOpacity(currentOpacity);
        if (this.globalData.currentGlobalAlpha !== currentOpacity) {
            this.canvasContext.globalAlpha = currentOpacity;
            this.globalData.currentGlobalAlpha = currentOpacity;
        }
    };
    CanvasRendererBase.prototype.reset = function() {
        if (!this.renderConfig.clearCanvas) {
            this.canvasContext.restore();
            return;
        }
        this.contextData.reset();
    };
    CanvasRendererBase.prototype.save = function(actionFlag) {
        if (!this.renderConfig.clearCanvas) {
            this.canvasContext.save();
            return;
        }
        if (actionFlag) this.canvasContext.save();
        this.contextData.push();
    };
    CanvasRendererBase.prototype.restore = function(actionFlag) {
        if (!this.renderConfig.clearCanvas) {
            this.canvasContext.restore();
            return;
        }
        if (actionFlag) {
            this.canvasContext.restore();
            this.globalData.blendMode = "source-over";
        }
        var popped = this.contextData.pop();
        var transform = popped.transform;
        var opacity = popped.opacity;
        this.canvasContext.setTransform(transform[0], transform[1], transform[4], transform[5], transform[12], transform[13]);
        if (this.globalData.currentGlobalAlpha !== opacity) {
            this.canvasContext.globalAlpha = opacity;
            this.globalData.currentGlobalAlpha = opacity;
        }
    };
    CanvasRendererBase.prototype.configAnimation = function(animData) {
        if (this.animationItem.wrapper) {
            this.animationItem.container = createTag("canvas");
            var containerStyle = this.animationItem.container.style;
            containerStyle.width = "100%";
            containerStyle.height = "100%";
            var origin = "0px 0px 0px";
            containerStyle.transformOrigin = origin;
            containerStyle.mozTransformOrigin = origin;
            containerStyle.webkitTransformOrigin = origin;
            containerStyle["-webkit-transform"] = origin;
            containerStyle.contentVisibility = this.renderConfig.contentVisibility;
            this.animationItem.wrapper.appendChild(this.animationItem.container);
            this.canvasContext = this.animationItem.container.getContext("2d");
            if (this.renderConfig.className) this.animationItem.container.setAttribute("class", this.renderConfig.className);
            if (this.renderConfig.id) this.animationItem.container.setAttribute("id", this.renderConfig.id);
        } else this.canvasContext = this.renderConfig.context;
        this.data = animData;
        this.layers = animData.layers;
        this.transformCanvas = {
            w: animData.w,
            h: animData.h,
            sx: 0,
            sy: 0,
            tx: 0,
            ty: 0
        };
        this.setupGlobalData(animData, document.body);
        this.globalData.canvasContext = this.canvasContext;
        this.globalData.renderer = this;
        this.globalData.isDashed = false;
        this.globalData.progressiveLoad = this.renderConfig.progressiveLoad;
        this.globalData.transformCanvas = this.transformCanvas;
        this.elements = createSizedArray(animData.layers.length);
        this.updateContainerSize();
    };
    CanvasRendererBase.prototype.updateContainerSize = function(width, height) {
        this.reset();
        var elementWidth;
        var elementHeight;
        if (width) {
            elementWidth = width;
            elementHeight = height;
            this.canvasContext.canvas.width = elementWidth;
            this.canvasContext.canvas.height = elementHeight;
        } else {
            if (this.animationItem.wrapper && this.animationItem.container) {
                elementWidth = this.animationItem.wrapper.offsetWidth;
                elementHeight = this.animationItem.wrapper.offsetHeight;
            } else {
                elementWidth = this.canvasContext.canvas.width;
                elementHeight = this.canvasContext.canvas.height;
            }
            this.canvasContext.canvas.width = elementWidth * this.renderConfig.dpr;
            this.canvasContext.canvas.height = elementHeight * this.renderConfig.dpr;
        }
        var elementRel;
        var animationRel;
        if (this.renderConfig.preserveAspectRatio.indexOf("meet") !== -1 || this.renderConfig.preserveAspectRatio.indexOf("slice") !== -1) {
            var par = this.renderConfig.preserveAspectRatio.split(" ");
            var fillType = par[1] || "meet";
            var pos = par[0] || "xMidYMid";
            var xPos = pos.substr(0, 4);
            var yPos = pos.substr(4);
            elementRel = elementWidth / elementHeight;
            animationRel = this.transformCanvas.w / this.transformCanvas.h;
            if (animationRel > elementRel && fillType === "meet" || animationRel < elementRel && fillType === "slice") {
                this.transformCanvas.sx = elementWidth / (this.transformCanvas.w / this.renderConfig.dpr);
                this.transformCanvas.sy = elementWidth / (this.transformCanvas.w / this.renderConfig.dpr);
            } else {
                this.transformCanvas.sx = elementHeight / (this.transformCanvas.h / this.renderConfig.dpr);
                this.transformCanvas.sy = elementHeight / (this.transformCanvas.h / this.renderConfig.dpr);
            }
            if (xPos === "xMid" && (animationRel < elementRel && fillType === "meet" || animationRel > elementRel && fillType === "slice")) this.transformCanvas.tx = (elementWidth - this.transformCanvas.w * (elementHeight / this.transformCanvas.h)) / 2 * this.renderConfig.dpr;
            else if (xPos === "xMax" && (animationRel < elementRel && fillType === "meet" || animationRel > elementRel && fillType === "slice")) this.transformCanvas.tx = (elementWidth - this.transformCanvas.w * (elementHeight / this.transformCanvas.h)) * this.renderConfig.dpr;
            else this.transformCanvas.tx = 0;
            if (yPos === "YMid" && (animationRel > elementRel && fillType === "meet" || animationRel < elementRel && fillType === "slice")) this.transformCanvas.ty = (elementHeight - this.transformCanvas.h * (elementWidth / this.transformCanvas.w)) / 2 * this.renderConfig.dpr;
            else if (yPos === "YMax" && (animationRel > elementRel && fillType === "meet" || animationRel < elementRel && fillType === "slice")) this.transformCanvas.ty = (elementHeight - this.transformCanvas.h * (elementWidth / this.transformCanvas.w)) * this.renderConfig.dpr;
            else this.transformCanvas.ty = 0;
        } else if (this.renderConfig.preserveAspectRatio === "none") {
            this.transformCanvas.sx = elementWidth / (this.transformCanvas.w / this.renderConfig.dpr);
            this.transformCanvas.sy = elementHeight / (this.transformCanvas.h / this.renderConfig.dpr);
            this.transformCanvas.tx = 0;
            this.transformCanvas.ty = 0;
        } else {
            this.transformCanvas.sx = this.renderConfig.dpr;
            this.transformCanvas.sy = this.renderConfig.dpr;
            this.transformCanvas.tx = 0;
            this.transformCanvas.ty = 0;
        }
        this.transformCanvas.props = [
            this.transformCanvas.sx,
            0,
            0,
            0,
            0,
            this.transformCanvas.sy,
            0,
            0,
            0,
            0,
            1,
            0,
            this.transformCanvas.tx,
            this.transformCanvas.ty,
            0,
            1
        ];
        /* var i, len = this.elements.length;
      for(i=0;i<len;i+=1){
          if(this.elements[i] && this.elements[i].data.ty === 0){
              this.elements[i].resize(this.globalData.transformCanvas);
          }
      } */ this.ctxTransform(this.transformCanvas.props);
        this.canvasContext.beginPath();
        this.canvasContext.rect(0, 0, this.transformCanvas.w, this.transformCanvas.h);
        this.canvasContext.closePath();
        this.canvasContext.clip();
        this.renderFrame(this.renderedFrame, true);
    };
    CanvasRendererBase.prototype.destroy = function() {
        if (this.renderConfig.clearCanvas && this.animationItem.wrapper) this.animationItem.wrapper.innerText = "";
        var i;
        var len = this.layers ? this.layers.length : 0;
        for(i = len - 1; i >= 0; i -= 1)if (this.elements[i]) this.elements[i].destroy();
        this.elements.length = 0;
        this.globalData.canvasContext = null;
        this.animationItem.container = null;
        this.destroyed = true;
    };
    CanvasRendererBase.prototype.renderFrame = function(num, forceRender) {
        if (this.renderedFrame === num && this.renderConfig.clearCanvas === true && !forceRender || this.destroyed || num === -1) return;
        this.renderedFrame = num;
        this.globalData.frameNum = num - this.animationItem._isFirstFrame;
        this.globalData.frameId += 1;
        this.globalData._mdf = !this.renderConfig.clearCanvas || forceRender;
        this.globalData.projectInterface.currentFrame = num; // console.log('--------');
        // console.log('NEW: ',num);
        var i;
        var len = this.layers.length;
        if (!this.completeLayers) this.checkLayers(num);
        for(i = 0; i < len; i += 1)if (this.completeLayers || this.elements[i]) this.elements[i].prepareFrame(num - this.layers[i].st);
        if (this.globalData._mdf) {
            if (this.renderConfig.clearCanvas === true) this.canvasContext.clearRect(0, 0, this.transformCanvas.w, this.transformCanvas.h);
            else this.save();
            for(i = len - 1; i >= 0; i -= 1)if (this.completeLayers || this.elements[i]) this.elements[i].renderFrame();
            if (this.renderConfig.clearCanvas !== true) this.restore();
        }
    };
    CanvasRendererBase.prototype.buildItem = function(pos) {
        var elements = this.elements;
        if (elements[pos] || this.layers[pos].ty === 99) return;
        var element = this.createItem(this.layers[pos], this, this.globalData);
        elements[pos] = element;
        element.initExpressions();
    /* if(this.layers[pos].ty === 0){
          element.resize(this.globalData.transformCanvas);
      } */ };
    CanvasRendererBase.prototype.checkPendingElements = function() {
        while(this.pendingElements.length){
            var element = this.pendingElements.pop();
            element.checkParenting();
        }
    };
    CanvasRendererBase.prototype.hide = function() {
        this.animationItem.container.style.display = "none";
    };
    CanvasRendererBase.prototype.show = function() {
        this.animationItem.container.style.display = "block";
    };
    function CVCompElement(data, globalData, comp) {
        this.completeLayers = false;
        this.layers = data.layers;
        this.pendingElements = [];
        this.elements = createSizedArray(this.layers.length);
        this.initElement(data, globalData, comp);
        this.tm = data.tm ? PropertyFactory.getProp(this, data.tm, 0, globalData.frameRate, this) : {
            _placeholder: true
        };
    }
    extendPrototype([
        CanvasRendererBase,
        ICompElement,
        CVBaseElement
    ], CVCompElement);
    CVCompElement.prototype.renderInnerContent = function() {
        var ctx = this.canvasContext;
        ctx.beginPath();
        ctx.moveTo(0, 0);
        ctx.lineTo(this.data.w, 0);
        ctx.lineTo(this.data.w, this.data.h);
        ctx.lineTo(0, this.data.h);
        ctx.lineTo(0, 0);
        ctx.clip();
        var i;
        var len = this.layers.length;
        for(i = len - 1; i >= 0; i -= 1)if (this.completeLayers || this.elements[i]) this.elements[i].renderFrame();
    };
    CVCompElement.prototype.destroy = function() {
        var i;
        var len = this.layers.length;
        for(i = len - 1; i >= 0; i -= 1)if (this.elements[i]) this.elements[i].destroy();
        this.layers = null;
        this.elements = null;
    };
    CVCompElement.prototype.createComp = function(data) {
        return new CVCompElement(data, this.globalData, this);
    };
    function CanvasRenderer(animationItem, config) {
        this.animationItem = animationItem;
        this.renderConfig = {
            clearCanvas: config && config.clearCanvas !== undefined ? config.clearCanvas : true,
            context: config && config.context || null,
            progressiveLoad: config && config.progressiveLoad || false,
            preserveAspectRatio: config && config.preserveAspectRatio || "xMidYMid meet",
            imagePreserveAspectRatio: config && config.imagePreserveAspectRatio || "xMidYMid slice",
            contentVisibility: config && config.contentVisibility || "visible",
            className: config && config.className || "",
            id: config && config.id || "",
            runExpressions: !config || config.runExpressions === undefined || config.runExpressions
        };
        this.renderConfig.dpr = config && config.dpr || 1;
        if (this.animationItem.wrapper) this.renderConfig.dpr = config && config.dpr || window.devicePixelRatio || 1;
        this.renderedFrame = -1;
        this.globalData = {
            frameNum: -1,
            _mdf: false,
            renderConfig: this.renderConfig,
            currentGlobalAlpha: -1
        };
        this.contextData = new CVContextData();
        this.elements = [];
        this.pendingElements = [];
        this.transformMat = new Matrix();
        this.completeLayers = false;
        this.rendererType = "canvas";
    }
    extendPrototype([
        CanvasRendererBase
    ], CanvasRenderer);
    CanvasRenderer.prototype.createComp = function(data) {
        return new CVCompElement(data, this.globalData, this);
    };
    function HBaseElement() {}
    HBaseElement.prototype = {
        checkBlendMode: function checkBlendMode() {},
        initRendererElement: function initRendererElement() {
            this.baseElement = createTag(this.data.tg || "div");
            if (this.data.hasMask) {
                this.svgElement = createNS("svg");
                this.layerElement = createNS("g");
                this.maskedElement = this.layerElement;
                this.svgElement.appendChild(this.layerElement);
                this.baseElement.appendChild(this.svgElement);
            } else this.layerElement = this.baseElement;
            styleDiv(this.baseElement);
        },
        createContainerElements: function createContainerElements() {
            this.renderableEffectsManager = new CVEffects(this);
            this.transformedElement = this.baseElement;
            this.maskedElement = this.layerElement;
            if (this.data.ln) this.layerElement.setAttribute("id", this.data.ln);
            if (this.data.cl) this.layerElement.setAttribute("class", this.data.cl);
            if (this.data.bm !== 0) this.setBlendMode();
        },
        renderElement: function renderElement() {
            var transformedElementStyle = this.transformedElement ? this.transformedElement.style : {};
            if (this.finalTransform._matMdf) {
                var matrixValue = this.finalTransform.mat.toCSS();
                transformedElementStyle.transform = matrixValue;
                transformedElementStyle.webkitTransform = matrixValue;
            }
            if (this.finalTransform._opMdf) transformedElementStyle.opacity = this.finalTransform.mProp.o.v;
        },
        renderFrame: function renderFrame() {
            // If it is exported as hidden (data.hd === true) no need to render
            // If it is not visible no need to render
            if (this.data.hd || this.hidden) return;
            this.renderTransform();
            this.renderRenderable();
            this.renderElement();
            this.renderInnerContent();
            if (this._isFirstFrame) this._isFirstFrame = false;
        },
        destroy: function destroy() {
            this.layerElement = null;
            this.transformedElement = null;
            if (this.matteElement) this.matteElement = null;
            if (this.maskManager) {
                this.maskManager.destroy();
                this.maskManager = null;
            }
        },
        createRenderableComponents: function createRenderableComponents() {
            this.maskManager = new MaskElement(this.data, this, this.globalData);
        },
        addEffects: function addEffects() {},
        setMatte: function setMatte() {}
    };
    HBaseElement.prototype.getBaseElement = SVGBaseElement.prototype.getBaseElement;
    HBaseElement.prototype.destroyBaseElement = HBaseElement.prototype.destroy;
    HBaseElement.prototype.buildElementParenting = BaseRenderer.prototype.buildElementParenting;
    function HSolidElement(data, globalData, comp) {
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        HBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement
    ], HSolidElement);
    HSolidElement.prototype.createContent = function() {
        var rect;
        if (this.data.hasMask) {
            rect = createNS("rect");
            rect.setAttribute("width", this.data.sw);
            rect.setAttribute("height", this.data.sh);
            rect.setAttribute("fill", this.data.sc);
            this.svgElement.setAttribute("width", this.data.sw);
            this.svgElement.setAttribute("height", this.data.sh);
        } else {
            rect = createTag("div");
            rect.style.width = this.data.sw + "px";
            rect.style.height = this.data.sh + "px";
            rect.style.backgroundColor = this.data.sc;
        }
        this.layerElement.appendChild(rect);
    };
    function HShapeElement(data, globalData, comp) {
        // List of drawable elements
        this.shapes = []; // Full shape data
        this.shapesData = data.shapes; // List of styles that will be applied to shapes
        this.stylesList = []; // List of modifiers that will be applied to shapes
        this.shapeModifiers = []; // List of items in shape tree
        this.itemsData = []; // List of items in previous shape tree
        this.processedElements = []; // List of animated components
        this.animatedContents = [];
        this.shapesContainer = createNS("g");
        this.initElement(data, globalData, comp); // Moving any property that doesn't get too much access after initialization because of v8 way of handling more than 10 properties.
        // List of elements that have been created
        this.prevViewData = [];
        this.currentBBox = {
            x: 999999,
            y: -999999,
            h: 0,
            w: 0
        };
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        HSolidElement,
        SVGShapeElement,
        HBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableElement
    ], HShapeElement);
    HShapeElement.prototype._renderShapeFrame = HShapeElement.prototype.renderInnerContent;
    HShapeElement.prototype.createContent = function() {
        var cont;
        this.baseElement.style.fontSize = 0;
        if (this.data.hasMask) {
            this.layerElement.appendChild(this.shapesContainer);
            cont = this.svgElement;
        } else {
            cont = createNS("svg");
            var size = this.comp.data ? this.comp.data : this.globalData.compSize;
            cont.setAttribute("width", size.w);
            cont.setAttribute("height", size.h);
            cont.appendChild(this.shapesContainer);
            this.layerElement.appendChild(cont);
        }
        this.searchShapes(this.shapesData, this.itemsData, this.prevViewData, this.shapesContainer, 0, [], true);
        this.filterUniqueShapes();
        this.shapeCont = cont;
    };
    HShapeElement.prototype.getTransformedPoint = function(transformers, point) {
        var i;
        var len = transformers.length;
        for(i = 0; i < len; i += 1)point = transformers[i].mProps.v.applyToPointArray(point[0], point[1], 0);
        return point;
    };
    HShapeElement.prototype.calculateShapeBoundingBox = function(item, boundingBox) {
        var shape = item.sh.v;
        var transformers = item.transformers;
        var i;
        var len = shape._length;
        var vPoint;
        var oPoint;
        var nextIPoint;
        var nextVPoint;
        if (len <= 1) return;
        for(i = 0; i < len - 1; i += 1){
            vPoint = this.getTransformedPoint(transformers, shape.v[i]);
            oPoint = this.getTransformedPoint(transformers, shape.o[i]);
            nextIPoint = this.getTransformedPoint(transformers, shape.i[i + 1]);
            nextVPoint = this.getTransformedPoint(transformers, shape.v[i + 1]);
            this.checkBounds(vPoint, oPoint, nextIPoint, nextVPoint, boundingBox);
        }
        if (shape.c) {
            vPoint = this.getTransformedPoint(transformers, shape.v[i]);
            oPoint = this.getTransformedPoint(transformers, shape.o[i]);
            nextIPoint = this.getTransformedPoint(transformers, shape.i[0]);
            nextVPoint = this.getTransformedPoint(transformers, shape.v[0]);
            this.checkBounds(vPoint, oPoint, nextIPoint, nextVPoint, boundingBox);
        }
    };
    HShapeElement.prototype.checkBounds = function(vPoint, oPoint, nextIPoint, nextVPoint, boundingBox) {
        this.getBoundsOfCurve(vPoint, oPoint, nextIPoint, nextVPoint);
        var bounds = this.shapeBoundingBox;
        boundingBox.x = bmMin(bounds.left, boundingBox.x);
        boundingBox.xMax = bmMax(bounds.right, boundingBox.xMax);
        boundingBox.y = bmMin(bounds.top, boundingBox.y);
        boundingBox.yMax = bmMax(bounds.bottom, boundingBox.yMax);
    };
    HShapeElement.prototype.shapeBoundingBox = {
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
    };
    HShapeElement.prototype.tempBoundingBox = {
        x: 0,
        xMax: 0,
        y: 0,
        yMax: 0,
        width: 0,
        height: 0
    };
    HShapeElement.prototype.getBoundsOfCurve = function(p0, p1, p2, p3) {
        var bounds = [
            [
                p0[0],
                p3[0]
            ],
            [
                p0[1],
                p3[1]
            ]
        ];
        for(var a, b, c, t, b2ac, t1, t2, i = 0; i < 2; ++i){
            // eslint-disable-line no-plusplus
            b = 6 * p0[i] - 12 * p1[i] + 6 * p2[i];
            a = -3 * p0[i] + 9 * p1[i] - 9 * p2[i] + 3 * p3[i];
            c = 3 * p1[i] - 3 * p0[i];
            b |= 0; // eslint-disable-line no-bitwise
            a |= 0; // eslint-disable-line no-bitwise
            c |= 0; // eslint-disable-line no-bitwise
            if (a === 0 && b === 0) ;
            else if (a === 0) {
                t = -c / b;
                if (t > 0 && t < 1) bounds[i].push(this.calculateF(t, p0, p1, p2, p3, i));
            } else {
                b2ac = b * b - 4 * c * a;
                if (b2ac >= 0) {
                    t1 = (-b + bmSqrt(b2ac)) / (2 * a);
                    if (t1 > 0 && t1 < 1) bounds[i].push(this.calculateF(t1, p0, p1, p2, p3, i));
                    t2 = (-b - bmSqrt(b2ac)) / (2 * a);
                    if (t2 > 0 && t2 < 1) bounds[i].push(this.calculateF(t2, p0, p1, p2, p3, i));
                }
            }
        }
        this.shapeBoundingBox.left = bmMin.apply(null, bounds[0]);
        this.shapeBoundingBox.top = bmMin.apply(null, bounds[1]);
        this.shapeBoundingBox.right = bmMax.apply(null, bounds[0]);
        this.shapeBoundingBox.bottom = bmMax.apply(null, bounds[1]);
    };
    HShapeElement.prototype.calculateF = function(t, p0, p1, p2, p3, i) {
        return bmPow(1 - t, 3) * p0[i] + 3 * bmPow(1 - t, 2) * t * p1[i] + 3 * (1 - t) * bmPow(t, 2) * p2[i] + bmPow(t, 3) * p3[i];
    };
    HShapeElement.prototype.calculateBoundingBox = function(itemsData, boundingBox) {
        var i;
        var len = itemsData.length;
        for(i = 0; i < len; i += 1){
            if (itemsData[i] && itemsData[i].sh) this.calculateShapeBoundingBox(itemsData[i], boundingBox);
            else if (itemsData[i] && itemsData[i].it) this.calculateBoundingBox(itemsData[i].it, boundingBox);
            else if (itemsData[i] && itemsData[i].style && itemsData[i].w) this.expandStrokeBoundingBox(itemsData[i].w, boundingBox);
        }
    };
    HShapeElement.prototype.expandStrokeBoundingBox = function(widthProperty, boundingBox) {
        var width = 0;
        if (widthProperty.keyframes) {
            for(var i = 0; i < widthProperty.keyframes.length; i += 1){
                var kfw = widthProperty.keyframes[i].s;
                if (kfw > width) width = kfw;
            }
            width *= widthProperty.mult;
        } else width = widthProperty.v * widthProperty.mult;
        boundingBox.x -= width;
        boundingBox.xMax += width;
        boundingBox.y -= width;
        boundingBox.yMax += width;
    };
    HShapeElement.prototype.currentBoxContains = function(box) {
        return this.currentBBox.x <= box.x && this.currentBBox.y <= box.y && this.currentBBox.width + this.currentBBox.x >= box.x + box.width && this.currentBBox.height + this.currentBBox.y >= box.y + box.height;
    };
    HShapeElement.prototype.renderInnerContent = function() {
        this._renderShapeFrame();
        if (!this.hidden && (this._isFirstFrame || this._mdf)) {
            var tempBoundingBox = this.tempBoundingBox;
            var max = 999999;
            tempBoundingBox.x = max;
            tempBoundingBox.xMax = -max;
            tempBoundingBox.y = max;
            tempBoundingBox.yMax = -max;
            this.calculateBoundingBox(this.itemsData, tempBoundingBox);
            tempBoundingBox.width = tempBoundingBox.xMax < tempBoundingBox.x ? 0 : tempBoundingBox.xMax - tempBoundingBox.x;
            tempBoundingBox.height = tempBoundingBox.yMax < tempBoundingBox.y ? 0 : tempBoundingBox.yMax - tempBoundingBox.y; // var tempBoundingBox = this.shapeCont.getBBox();
            if (this.currentBoxContains(tempBoundingBox)) return;
            var changed = false;
            if (this.currentBBox.w !== tempBoundingBox.width) {
                this.currentBBox.w = tempBoundingBox.width;
                this.shapeCont.setAttribute("width", tempBoundingBox.width);
                changed = true;
            }
            if (this.currentBBox.h !== tempBoundingBox.height) {
                this.currentBBox.h = tempBoundingBox.height;
                this.shapeCont.setAttribute("height", tempBoundingBox.height);
                changed = true;
            }
            if (changed || this.currentBBox.x !== tempBoundingBox.x || this.currentBBox.y !== tempBoundingBox.y) {
                this.currentBBox.w = tempBoundingBox.width;
                this.currentBBox.h = tempBoundingBox.height;
                this.currentBBox.x = tempBoundingBox.x;
                this.currentBBox.y = tempBoundingBox.y;
                this.shapeCont.setAttribute("viewBox", this.currentBBox.x + " " + this.currentBBox.y + " " + this.currentBBox.w + " " + this.currentBBox.h);
                var shapeStyle = this.shapeCont.style;
                var shapeTransform = "translate(" + this.currentBBox.x + "px," + this.currentBBox.y + "px)";
                shapeStyle.transform = shapeTransform;
                shapeStyle.webkitTransform = shapeTransform;
            }
        }
    };
    function HTextElement(data, globalData, comp) {
        this.textSpans = [];
        this.textPaths = [];
        this.currentBBox = {
            x: 999999,
            y: -999999,
            h: 0,
            w: 0
        };
        this.renderType = "svg";
        this.isMasked = false;
        this.initElement(data, globalData, comp);
    }
    extendPrototype([
        BaseElement,
        TransformElement,
        HBaseElement,
        HierarchyElement,
        FrameElement,
        RenderableDOMElement,
        ITextElement
    ], HTextElement);
    HTextElement.prototype.createContent = function() {
        this.isMasked = this.checkMasks();
        if (this.isMasked) {
            this.renderType = "svg";
            this.compW = this.comp.data.w;
            this.compH = this.comp.data.h;
            this.svgElement.setAttribute("width", this.compW);
            this.svgElement.setAttribute("height", this.compH);
            var g = createNS("g");
            this.maskedElement.appendChild(g);
            this.innerElem = g;
        } else {
            this.renderType = "html";
            this.innerElem = this.layerElement;
        }
        this.checkParenting();
    };
    HTextElement.prototype.buildNewText = function() {
        var documentData = this.textProperty.currentData;
        this.renderedLetters = createSizedArray(documentData.l ? documentData.l.length : 0);
        var innerElemStyle = this.innerElem.style;
        var textColor = documentData.fc ? this.buildColor(documentData.fc) : "rgba(0,0,0,0)";
        innerElemStyle.fill = textColor;
        innerElemStyle.color = textColor;
        if (documentData.sc) {
            innerElemStyle.stroke = this.buildColor(documentData.sc);
            innerElemStyle.strokeWidth = documentData.sw + "px";
        }
        var fontData = this.globalData.fontManager.getFontByName(documentData.f);
        if (!this.globalData.fontManager.chars) {
            innerElemStyle.fontSize = documentData.finalSize + "px";
            innerElemStyle.lineHeight = documentData.finalSize + "px";
            if (fontData.fClass) this.innerElem.className = fontData.fClass;
            else {
                innerElemStyle.fontFamily = fontData.fFamily;
                var fWeight = documentData.fWeight;
                var fStyle = documentData.fStyle;
                innerElemStyle.fontStyle = fStyle;
                innerElemStyle.fontWeight = fWeight;
            }
        }
        var i;
        var len;
        var letters = documentData.l;
        len = letters.length;
        var tSpan;
        var tParent;
        var tCont;
        var matrixHelper = this.mHelper;
        var shapes;
        var shapeStr = "";
        var cnt = 0;
        for(i = 0; i < len; i += 1){
            if (this.globalData.fontManager.chars) {
                if (!this.textPaths[cnt]) {
                    tSpan = createNS("path");
                    tSpan.setAttribute("stroke-linecap", lineCapEnum[1]);
                    tSpan.setAttribute("stroke-linejoin", lineJoinEnum[2]);
                    tSpan.setAttribute("stroke-miterlimit", "4");
                } else tSpan = this.textPaths[cnt];
                if (!this.isMasked) {
                    if (this.textSpans[cnt]) {
                        tParent = this.textSpans[cnt];
                        tCont = tParent.children[0];
                    } else {
                        tParent = createTag("div");
                        tParent.style.lineHeight = 0;
                        tCont = createNS("svg");
                        tCont.appendChild(tSpan);
                        styleDiv(tParent);
                    }
                }
            } else if (!this.isMasked) {
                if (this.textSpans[cnt]) {
                    tParent = this.textSpans[cnt];
                    tSpan = this.textPaths[cnt];
                } else {
                    tParent = createTag("span");
                    styleDiv(tParent);
                    tSpan = createTag("span");
                    styleDiv(tSpan);
                    tParent.appendChild(tSpan);
                }
            } else tSpan = this.textPaths[cnt] ? this.textPaths[cnt] : createNS("text");
             // tSpan.setAttribute('visibility', 'hidden');
            if (this.globalData.fontManager.chars) {
                var charData = this.globalData.fontManager.getCharData(documentData.finalText[i], fontData.fStyle, this.globalData.fontManager.getFontByName(documentData.f).fFamily);
                var shapeData;
                if (charData) shapeData = charData.data;
                else shapeData = null;
                matrixHelper.reset();
                if (shapeData && shapeData.shapes && shapeData.shapes.length) {
                    shapes = shapeData.shapes[0].it;
                    matrixHelper.scale(documentData.finalSize / 100, documentData.finalSize / 100);
                    shapeStr = this.createPathShape(matrixHelper, shapes);
                    tSpan.setAttribute("d", shapeStr);
                }
                if (!this.isMasked) {
                    this.innerElem.appendChild(tParent);
                    if (shapeData && shapeData.shapes) {
                        // document.body.appendChild is needed to get exact measure of shape
                        document.body.appendChild(tCont);
                        var boundingBox = tCont.getBBox();
                        tCont.setAttribute("width", boundingBox.width + 2);
                        tCont.setAttribute("height", boundingBox.height + 2);
                        tCont.setAttribute("viewBox", boundingBox.x - 1 + " " + (boundingBox.y - 1) + " " + (boundingBox.width + 2) + " " + (boundingBox.height + 2));
                        var tContStyle = tCont.style;
                        var tContTranslation = "translate(" + (boundingBox.x - 1) + "px," + (boundingBox.y - 1) + "px)";
                        tContStyle.transform = tContTranslation;
                        tContStyle.webkitTransform = tContTranslation;
                        letters[i].yOffset = boundingBox.y - 1;
                    } else {
                        tCont.setAttribute("width", 1);
                        tCont.setAttribute("height", 1);
                    }
                    tParent.appendChild(tCont);
                } else this.innerElem.appendChild(tSpan);
            } else {
                tSpan.textContent = letters[i].val;
                tSpan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
                if (!this.isMasked) {
                    this.innerElem.appendChild(tParent); //
                    var tStyle = tSpan.style;
                    var tSpanTranslation = "translate3d(0," + -documentData.finalSize / 1.2 + "px,0)";
                    tStyle.transform = tSpanTranslation;
                    tStyle.webkitTransform = tSpanTranslation;
                } else this.innerElem.appendChild(tSpan);
            } //
            if (!this.isMasked) this.textSpans[cnt] = tParent;
            else this.textSpans[cnt] = tSpan;
            this.textSpans[cnt].style.display = "block";
            this.textPaths[cnt] = tSpan;
            cnt += 1;
        }
        while(cnt < this.textSpans.length){
            this.textSpans[cnt].style.display = "none";
            cnt += 1;
        }
    };
    HTextElement.prototype.renderInnerContent = function() {
        var svgStyle;
        if (this.data.singleShape) {
            if (!this._isFirstFrame && !this.lettersChangedFlag) return;
            if (this.isMasked && this.finalTransform._matMdf) {
                // Todo Benchmark if using this is better than getBBox
                this.svgElement.setAttribute("viewBox", -this.finalTransform.mProp.p.v[0] + " " + -this.finalTransform.mProp.p.v[1] + " " + this.compW + " " + this.compH);
                svgStyle = this.svgElement.style;
                var translation = "translate(" + -this.finalTransform.mProp.p.v[0] + "px," + -this.finalTransform.mProp.p.v[1] + "px)";
                svgStyle.transform = translation;
                svgStyle.webkitTransform = translation;
            }
        }
        this.textAnimator.getMeasures(this.textProperty.currentData, this.lettersChangedFlag);
        if (!this.lettersChangedFlag && !this.textAnimator.lettersChangedFlag) return;
        var i;
        var len;
        var count = 0;
        var renderedLetters = this.textAnimator.renderedLetters;
        var letters = this.textProperty.currentData.l;
        len = letters.length;
        var renderedLetter;
        var textSpan;
        var textPath;
        for(i = 0; i < len; i += 1)if (letters[i].n) count += 1;
        else {
            textSpan = this.textSpans[i];
            textPath = this.textPaths[i];
            renderedLetter = renderedLetters[count];
            count += 1;
            if (renderedLetter._mdf.m) {
                if (!this.isMasked) {
                    textSpan.style.webkitTransform = renderedLetter.m;
                    textSpan.style.transform = renderedLetter.m;
                } else textSpan.setAttribute("transform", renderedLetter.m);
            } /// /textSpan.setAttribute('opacity',renderedLetter.o);
            textSpan.style.opacity = renderedLetter.o;
            if (renderedLetter.sw && renderedLetter._mdf.sw) textPath.setAttribute("stroke-width", renderedLetter.sw);
            if (renderedLetter.sc && renderedLetter._mdf.sc) textPath.setAttribute("stroke", renderedLetter.sc);
            if (renderedLetter.fc && renderedLetter._mdf.fc) {
                textPath.setAttribute("fill", renderedLetter.fc);
                textPath.style.color = renderedLetter.fc;
            }
        }
        if (this.innerElem.getBBox && !this.hidden && (this._isFirstFrame || this._mdf)) {
            var boundingBox = this.innerElem.getBBox();
            if (this.currentBBox.w !== boundingBox.width) {
                this.currentBBox.w = boundingBox.width;
                this.svgElement.setAttribute("width", boundingBox.width);
            }
            if (this.currentBBox.h !== boundingBox.height) {
                this.currentBBox.h = boundingBox.height;
                this.svgElement.setAttribute("height", boundingBox.height);
            }
            var margin = 1;
            if (this.currentBBox.w !== boundingBox.width + margin * 2 || this.currentBBox.h !== boundingBox.height + margin * 2 || this.currentBBox.x !== boundingBox.x - margin || this.currentBBox.y !== boundingBox.y - margin) {
                this.currentBBox.w = boundingBox.width + margin * 2;
                this.currentBBox.h = boundingBox.height + margin * 2;
                this.currentBBox.x = boundingBox.x - margin;
                this.currentBBox.y = boundingBox.y - margin;
                this.svgElement.setAttribute("viewBox", this.currentBBox.x + " " + this.currentBBox.y + " " + this.currentBBox.w + " " + this.currentBBox.h);
                svgStyle = this.svgElement.style;
                var svgTransform = "translate(" + this.currentBBox.x + "px," + this.currentBBox.y + "px)";
                svgStyle.transform = svgTransform;
                svgStyle.webkitTransform = svgTransform;
            }
        }
    };
    function HCameraElement(data, globalData, comp) {
        this.initFrame();
        this.initBaseData(data, globalData, comp);
        this.initHierarchy();
        var getProp = PropertyFactory.getProp;
        this.pe = getProp(this, data.pe, 0, 0, this);
        if (data.ks.p.s) {
            this.px = getProp(this, data.ks.p.x, 1, 0, this);
            this.py = getProp(this, data.ks.p.y, 1, 0, this);
            this.pz = getProp(this, data.ks.p.z, 1, 0, this);
        } else this.p = getProp(this, data.ks.p, 1, 0, this);
        if (data.ks.a) this.a = getProp(this, data.ks.a, 1, 0, this);
        if (data.ks.or.k.length && data.ks.or.k[0].to) {
            var i;
            var len = data.ks.or.k.length;
            for(i = 0; i < len; i += 1){
                data.ks.or.k[i].to = null;
                data.ks.or.k[i].ti = null;
            }
        }
        this.or = getProp(this, data.ks.or, 1, degToRads, this);
        this.or.sh = true;
        this.rx = getProp(this, data.ks.rx, 0, degToRads, this);
        this.