import * as sensor from "./sensor-gatt";
import * as vue from "vue";
import { reactive } from "vue";

const debug = false;

//game logic
export var game_data = reactive({
    sensor: sensor.state,
    game: {
        game_id: 0,
        game_state: -1,
        game_state_dest: -1,
        game_state_animating: 0,
        game_began: 0,
        // ready_timer: 0, //computes ready set go?
        timeout_timer: 0, //computes timeout,
        result_timer: 0,
        debug: debug
    },
    button: {
        triggered: 0, //read it from arduino (via serial or ble.. either way)
    }
});
var game_state = game_data.game;
var button_state = game_data.button;
var sensor_state = game_data.sensor;
    sensor_state.connected = debug;

var sound_arr = [];
export function playSound( filename, action, loop = false, time = 0 )
{
    if( filename.indexOf( 'intro' ) >= 0 && game_state.game_state_dest == 0 )
    {
        fn = 'intro';
        if( sound_arr[ fn ] != undefined )
        {
            sound_arr[ fn ].paused = true;
            delete sound_arr[ fn ];
        }
        sound_arr[ fn ] = new Audio( '../sounds/' + ( 'intro_' + Math.ceil( Math.random() * 4 ) ) + '.mp3' );
        sound_arr[ fn ].loop = loop;
    }
    else
    {
        if( action != 'stopall' )
        {
            var fn = filename.substring( 0, filename.lastIndexOf( '.' ) );
            if( sound_arr[ fn ] == undefined )
            {
                sound_arr[ fn ] = new Audio( '../sounds/' + filename );
            }

            sound_arr[ fn ].loop = loop;
        } 
    }

    try
    {
        if( action == 'play' ) sound_arr[ fn ].play();
        else if( action == 'stop' )
        {
            sound_arr[ fn ].pause();
            sound_arr[ fn ].currentTime = 0;
        }
        else if( action == 'stopall' )
        {
            for( var key in sound_arr )
            {
                sound_arr[ key ].pause();
                sound_arr[ key ].currentTime = 0;
            }
        }
    }
    catch( err )
    {
        console.log( err );
    }
}

function game_loop()
{
    if( game_state.debug ) sensor_state.connected = game_state.debug;

    // SENSOR ERROR
    if (!sensor_state.connected) {
        //error state
        game_state.game_state = -1;
        game_state.game_state_dest = -1;
        game_state.game_state_animating = false;
        // game_state.ready_timer = 0;
        game_state.timeout_timer = 0;
        game_state.game_id = 0;
        sensor_state.game_id = 0;
        sensor_state.punched_num = 0;
        sensor_state.punched = 0;
        return;
    }
    else
    {
        if (game_state.game_state_dest == -1)
        {
            // game_state.game_state = 0; //reset error
            game_state.game_state_dest = 0; //reset error
            // return;
        }
    }

    var READY = 5000;
    var TIMEOUT = 30 * 1000;
    var PUNCH_RECORD = 1000;
    var RESULT = 16000;

    if( button_state.triggered == 1 )
    {
        button_state.triggered = 0;
        game_state.game_state_dest = 1; //start game
    }
    else
    {
        if( game_state.game_state_dest == 0 )
        {
            if( game_state.game_state != game_state.game_state_dest )
            {
                if( !game_state.game_state_animating )
                {
                    game_state.game_state_animating = true;
                }
            }
        }
        else if( game_state.game_state_dest == 1 )
        {
            if( game_state.game_state != game_state.game_state_dest )
            {
                if( !game_state.game_state_animating )
                {
                    game_state.game_state_animating = true;
                    game_state.game_id = 0;
                    game_state.game_began = 0;
                    // game_state.ready_timer = 0;
                    game_state.timeout_timer = 0;
                    game_state.result_timer = 0;
                    sensor_state.game_id = 0;
                    sensor_state.punch_score = 0;
                    sensor_state.punch_id = 0;
                    sensor_state.punched = 0;
                    sensor_state.punched_num = 0;
                }
            }
        }
        else if( game_state.game_state_dest == 2 )
        {
            if( game_state.game_state != game_state.game_state_dest )
            {
                if( !game_state.game_state_animating )
                {
                    game_state.game_state_animating = true;
                    game_state.game_id = Math.random();
                    game_state.game_began = Date.now();
                    sensor_state.game_id = game_state.game_id;
                }
            }

            game_state.timeout_timer = Math.ceil( Math.max( 0, ( TIMEOUT - ( Date.now() - game_state.game_began ) ) ) / 1000 );

            if( game_state.game_id == sensor_state.punch_id ) {
                //punch recorded!
                //game end?
                if( Date.now() - sensor_state.punched_time > PUNCH_RECORD )
                {
                    game_state.game_state_dest = 3;
                }
            }
            else {
                if( Date.now() - game_state.game_began > TIMEOUT ) //timeout!
                {
                    game_state.game_state = -1;
                    game_state.game_state_dest = 0;
                }
            }
        }
        else if( game_state.game_state_dest == 3 )
        {
            if( game_state.game_state != game_state.game_state_dest )
            {
                if( !game_state.game_state_animating )
                {
                    game_state.game_state_animating = true;

                    if( game_state.debug )
                    {
                        sensor_state.punched_time = Date.now();
                        sensor_state.punched_num += 1;
                        // sensor_state.punch_score = 33;
                    }
                }
            }

            game_state.result_timer = Math.ceil( Math.max( 0, ( RESULT - ( Date.now() - ( sensor_state.punched_time + PUNCH_RECORD ) ) ) ) / 1000 );

            if( ( Date.now() - ( sensor_state.punched_time + PUNCH_RECORD ) ) > RESULT )
            {
                if( sensor_state.punched_num >= 2 )
                {
                    game_state.game_state = -1;
                    game_state.game_state_dest = 0;
                    game_state.game_state_animating = false;
                }
                else
                {
                    game_state.game_state = 1;
                    game_state.game_state_dest = 2;
                    game_state.game_state_animating = false;
                }
            }
        }
    }
}


export async function start() {
    setInterval(() => {
        game_loop();
        button_state.triggered = 0; //[postprocess]
    }, 50);
}
